// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/feed_mapping.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A feed mapping.
type FeedMapping struct {
	// The resource name of the feed mapping.
	// Feed mapping resource names have the form:
	//
	// `customers/{customer_id}/feedMappings/{feed_id}~{feed_mapping_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The feed of this feed mapping.
	Feed *wrappers.StringValue `protobuf:"bytes,2,opt,name=feed,proto3" json:"feed,omitempty"`
	// Feed attributes to field mappings. These mappings are a one-to-many
	// relationship meaning that 1 feed attribute can be used to populate
	// multiple placeholder fields, but 1 placeholder field can only draw
	// data from 1 feed attribute. Ad Customizer is an exception, 1 placeholder
	// field can be mapped to multiple feed attributes. Required.
	AttributeFieldMappings []*AttributeFieldMapping `protobuf:"bytes,5,rep,name=attribute_field_mappings,json=attributeFieldMappings,proto3" json:"attribute_field_mappings,omitempty"`
	// Status of the feed mapping.
	// This field is read-only.
	Status enums.FeedMappingStatusEnum_FeedMappingStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v1.enums.FeedMappingStatusEnum_FeedMappingStatus" json:"status,omitempty"`
	// Feed mapping target. Can be either a placeholder or a criterion. For a
	// given feed, the active FeedMappings must have unique targets. Required.
	//
	// Types that are valid to be assigned to Target:
	//	*FeedMapping_PlaceholderType
	//	*FeedMapping_CriterionType
	Target               isFeedMapping_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FeedMapping) Reset()         { *m = FeedMapping{} }
func (m *FeedMapping) String() string { return proto.CompactTextString(m) }
func (*FeedMapping) ProtoMessage()    {}
func (*FeedMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_feed_mapping_f08dc24e8136e1ff, []int{0}
}
func (m *FeedMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedMapping.Unmarshal(m, b)
}
func (m *FeedMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedMapping.Marshal(b, m, deterministic)
}
func (dst *FeedMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedMapping.Merge(dst, src)
}
func (m *FeedMapping) XXX_Size() int {
	return xxx_messageInfo_FeedMapping.Size(m)
}
func (m *FeedMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedMapping.DiscardUnknown(m)
}

var xxx_messageInfo_FeedMapping proto.InternalMessageInfo

func (m *FeedMapping) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *FeedMapping) GetFeed() *wrappers.StringValue {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *FeedMapping) GetAttributeFieldMappings() []*AttributeFieldMapping {
	if m != nil {
		return m.AttributeFieldMappings
	}
	return nil
}

func (m *FeedMapping) GetStatus() enums.FeedMappingStatusEnum_FeedMappingStatus {
	if m != nil {
		return m.Status
	}
	return enums.FeedMappingStatusEnum_UNSPECIFIED
}

type isFeedMapping_Target interface {
	isFeedMapping_Target()
}

type FeedMapping_PlaceholderType struct {
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,3,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v1.enums.PlaceholderTypeEnum_PlaceholderType,oneof"`
}

type FeedMapping_CriterionType struct {
	CriterionType enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType `protobuf:"varint,4,opt,name=criterion_type,json=criterionType,proto3,enum=google.ads.googleads.v1.enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType,oneof"`
}

func (*FeedMapping_PlaceholderType) isFeedMapping_Target() {}

func (*FeedMapping_CriterionType) isFeedMapping_Target() {}

func (m *FeedMapping) GetTarget() isFeedMapping_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *FeedMapping) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x, ok := m.GetTarget().(*FeedMapping_PlaceholderType); ok {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (m *FeedMapping) GetCriterionType() enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType {
	if x, ok := m.GetTarget().(*FeedMapping_CriterionType); ok {
		return x.CriterionType
	}
	return enums.FeedMappingCriterionTypeEnum_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*FeedMapping) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _FeedMapping_OneofMarshaler, _FeedMapping_OneofUnmarshaler, _FeedMapping_OneofSizer, []interface{}{
		(*FeedMapping_PlaceholderType)(nil),
		(*FeedMapping_CriterionType)(nil),
	}
}

func _FeedMapping_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*FeedMapping)
	// target
	switch x := m.Target.(type) {
	case *FeedMapping_PlaceholderType:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.PlaceholderType))
	case *FeedMapping_CriterionType:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CriterionType))
	case nil:
	default:
		return fmt.Errorf("FeedMapping.Target has unexpected type %T", x)
	}
	return nil
}

func _FeedMapping_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*FeedMapping)
	switch tag {
	case 3: // target.placeholder_type
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &FeedMapping_PlaceholderType{enums.PlaceholderTypeEnum_PlaceholderType(x)}
		return true, err
	case 4: // target.criterion_type
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &FeedMapping_CriterionType{enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType(x)}
		return true, err
	default:
		return false, nil
	}
}

func _FeedMapping_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*FeedMapping)
	// target
	switch x := m.Target.(type) {
	case *FeedMapping_PlaceholderType:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.PlaceholderType))
	case *FeedMapping_CriterionType:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.CriterionType))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Maps from feed attribute id to a placeholder or criterion field id.
type AttributeFieldMapping struct {
	// Feed attribute from which to map.
	FeedAttributeId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=feed_attribute_id,json=feedAttributeId,proto3" json:"feed_attribute_id,omitempty"`
	// The placeholder field ID. If a placeholder field enum is not published in
	// the current API version, then this field will be populated and the field
	// oneof will be empty.
	// This field is read-only.
	FieldId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Placeholder or criterion field to be populated using data from
	// the above feed attribute. Required.
	//
	// Types that are valid to be assigned to Field:
	//	*AttributeFieldMapping_SitelinkField
	//	*AttributeFieldMapping_CallField
	//	*AttributeFieldMapping_AppField
	//	*AttributeFieldMapping_LocationField
	//	*AttributeFieldMapping_AffiliateLocationField
	//	*AttributeFieldMapping_CalloutField
	//	*AttributeFieldMapping_StructuredSnippetField
	//	*AttributeFieldMapping_MessageField
	//	*AttributeFieldMapping_PriceField
	//	*AttributeFieldMapping_PromotionField
	//	*AttributeFieldMapping_AdCustomizerField
	//	*AttributeFieldMapping_DsaPageFeedField
	//	*AttributeFieldMapping_LocationExtensionTargetingField
	//	*AttributeFieldMapping_EducationField
	//	*AttributeFieldMapping_FlightField
	//	*AttributeFieldMapping_CustomField
	//	*AttributeFieldMapping_HotelField
	//	*AttributeFieldMapping_RealEstateField
	//	*AttributeFieldMapping_TravelField
	//	*AttributeFieldMapping_LocalField
	//	*AttributeFieldMapping_JobField
	Field                isAttributeFieldMapping_Field `protobuf_oneof:"field"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AttributeFieldMapping) Reset()         { *m = AttributeFieldMapping{} }
func (m *AttributeFieldMapping) String() string { return proto.CompactTextString(m) }
func (*AttributeFieldMapping) ProtoMessage()    {}
func (*AttributeFieldMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_feed_mapping_f08dc24e8136e1ff, []int{1}
}
func (m *AttributeFieldMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeFieldMapping.Unmarshal(m, b)
}
func (m *AttributeFieldMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeFieldMapping.Marshal(b, m, deterministic)
}
func (dst *AttributeFieldMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeFieldMapping.Merge(dst, src)
}
func (m *AttributeFieldMapping) XXX_Size() int {
	return xxx_messageInfo_AttributeFieldMapping.Size(m)
}
func (m *AttributeFieldMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeFieldMapping.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeFieldMapping proto.InternalMessageInfo

func (m *AttributeFieldMapping) GetFeedAttributeId() *wrappers.Int64Value {
	if m != nil {
		return m.FeedAttributeId
	}
	return nil
}

func (m *AttributeFieldMapping) GetFieldId() *wrappers.Int64Value {
	if m != nil {
		return m.FieldId
	}
	return nil
}

type isAttributeFieldMapping_Field interface {
	isAttributeFieldMapping_Field()
}

type AttributeFieldMapping_SitelinkField struct {
	SitelinkField enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField `protobuf:"varint,3,opt,name=sitelink_field,json=sitelinkField,proto3,enum=google.ads.googleads.v1.enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField,oneof"`
}

type AttributeFieldMapping_CallField struct {
	CallField enums.CallPlaceholderFieldEnum_CallPlaceholderField `protobuf:"varint,4,opt,name=call_field,json=callField,proto3,enum=google.ads.googleads.v1.enums.CallPlaceholderFieldEnum_CallPlaceholderField,oneof"`
}

type AttributeFieldMapping_AppField struct {
	AppField enums.AppPlaceholderFieldEnum_AppPlaceholderField `protobuf:"varint,5,opt,name=app_field,json=appField,proto3,enum=google.ads.googleads.v1.enums.AppPlaceholderFieldEnum_AppPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocationField struct {
	LocationField enums.LocationPlaceholderFieldEnum_LocationPlaceholderField `protobuf:"varint,6,opt,name=location_field,json=locationField,proto3,enum=google.ads.googleads.v1.enums.LocationPlaceholderFieldEnum_LocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_AffiliateLocationField struct {
	AffiliateLocationField enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField `protobuf:"varint,7,opt,name=affiliate_location_field,json=affiliateLocationField,proto3,enum=google.ads.googleads.v1.enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_CalloutField struct {
	CalloutField enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField `protobuf:"varint,8,opt,name=callout_field,json=calloutField,proto3,enum=google.ads.googleads.v1.enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField,oneof"`
}

type AttributeFieldMapping_StructuredSnippetField struct {
	StructuredSnippetField enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField `protobuf:"varint,9,opt,name=structured_snippet_field,json=structuredSnippetField,proto3,enum=google.ads.googleads.v1.enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField,oneof"`
}

type AttributeFieldMapping_MessageField struct {
	MessageField enums.MessagePlaceholderFieldEnum_MessagePlaceholderField `protobuf:"varint,10,opt,name=message_field,json=messageField,proto3,enum=google.ads.googleads.v1.enums.MessagePlaceholderFieldEnum_MessagePlaceholderField,oneof"`
}

type AttributeFieldMapping_PriceField struct {
	PriceField enums.PricePlaceholderFieldEnum_PricePlaceholderField `protobuf:"varint,11,opt,name=price_field,json=priceField,proto3,enum=google.ads.googleads.v1.enums.PricePlaceholderFieldEnum_PricePlaceholderField,oneof"`
}

type AttributeFieldMapping_PromotionField struct {
	PromotionField enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField `protobuf:"varint,12,opt,name=promotion_field,json=promotionField,proto3,enum=google.ads.googleads.v1.enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField,oneof"`
}

type AttributeFieldMapping_AdCustomizerField struct {
	AdCustomizerField enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField `protobuf:"varint,13,opt,name=ad_customizer_field,json=adCustomizerField,proto3,enum=google.ads.googleads.v1.enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField,oneof"`
}

type AttributeFieldMapping_DsaPageFeedField struct {
	DsaPageFeedField enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField `protobuf:"varint,14,opt,name=dsa_page_feed_field,json=dsaPageFeedField,proto3,enum=google.ads.googleads.v1.enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField,oneof"`
}

type AttributeFieldMapping_LocationExtensionTargetingField struct {
	LocationExtensionTargetingField enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField `protobuf:"varint,15,opt,name=location_extension_targeting_field,json=locationExtensionTargetingField,proto3,enum=google.ads.googleads.v1.enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField,oneof"`
}

type AttributeFieldMapping_EducationField struct {
	EducationField enums.EducationPlaceholderFieldEnum_EducationPlaceholderField `protobuf:"varint,16,opt,name=education_field,json=educationField,proto3,enum=google.ads.googleads.v1.enums.EducationPlaceholderFieldEnum_EducationPlaceholderField,oneof"`
}

type AttributeFieldMapping_FlightField struct {
	FlightField enums.FlightPlaceholderFieldEnum_FlightPlaceholderField `protobuf:"varint,17,opt,name=flight_field,json=flightField,proto3,enum=google.ads.googleads.v1.enums.FlightPlaceholderFieldEnum_FlightPlaceholderField,oneof"`
}

type AttributeFieldMapping_CustomField struct {
	CustomField enums.CustomPlaceholderFieldEnum_CustomPlaceholderField `protobuf:"varint,18,opt,name=custom_field,json=customField,proto3,enum=google.ads.googleads.v1.enums.CustomPlaceholderFieldEnum_CustomPlaceholderField,oneof"`
}

type AttributeFieldMapping_HotelField struct {
	HotelField enums.HotelPlaceholderFieldEnum_HotelPlaceholderField `protobuf:"varint,19,opt,name=hotel_field,json=hotelField,proto3,enum=google.ads.googleads.v1.enums.HotelPlaceholderFieldEnum_HotelPlaceholderField,oneof"`
}

type AttributeFieldMapping_RealEstateField struct {
	RealEstateField enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField `protobuf:"varint,20,opt,name=real_estate_field,json=realEstateField,proto3,enum=google.ads.googleads.v1.enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField,oneof"`
}

type AttributeFieldMapping_TravelField struct {
	TravelField enums.TravelPlaceholderFieldEnum_TravelPlaceholderField `protobuf:"varint,21,opt,name=travel_field,json=travelField,proto3,enum=google.ads.googleads.v1.enums.TravelPlaceholderFieldEnum_TravelPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocalField struct {
	LocalField enums.LocalPlaceholderFieldEnum_LocalPlaceholderField `protobuf:"varint,22,opt,name=local_field,json=localField,proto3,enum=google.ads.googleads.v1.enums.LocalPlaceholderFieldEnum_LocalPlaceholderField,oneof"`
}

type AttributeFieldMapping_JobField struct {
	JobField enums.JobPlaceholderFieldEnum_JobPlaceholderField `protobuf:"varint,23,opt,name=job_field,json=jobField,proto3,enum=google.ads.googleads.v1.enums.JobPlaceholderFieldEnum_JobPlaceholderField,oneof"`
}

func (*AttributeFieldMapping_SitelinkField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CallField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AppField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AffiliateLocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CalloutField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_StructuredSnippetField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_MessageField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PriceField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PromotionField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AdCustomizerField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_DsaPageFeedField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationExtensionTargetingField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_EducationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_FlightField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CustomField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_HotelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_RealEstateField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_TravelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocalField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_JobField) isAttributeFieldMapping_Field() {}

func (m *AttributeFieldMapping) GetField() isAttributeFieldMapping_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *AttributeFieldMapping) GetSitelinkField() enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_SitelinkField); ok {
		return x.SitelinkField
	}
	return enums.SitelinkPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCallField() enums.CallPlaceholderFieldEnum_CallPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CallField); ok {
		return x.CallField
	}
	return enums.CallPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAppField() enums.AppPlaceholderFieldEnum_AppPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AppField); ok {
		return x.AppField
	}
	return enums.AppPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationField() enums.LocationPlaceholderFieldEnum_LocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationField); ok {
		return x.LocationField
	}
	return enums.LocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAffiliateLocationField() enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AffiliateLocationField); ok {
		return x.AffiliateLocationField
	}
	return enums.AffiliateLocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCalloutField() enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CalloutField); ok {
		return x.CalloutField
	}
	return enums.CalloutPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetStructuredSnippetField() enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_StructuredSnippetField); ok {
		return x.StructuredSnippetField
	}
	return enums.StructuredSnippetPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetMessageField() enums.MessagePlaceholderFieldEnum_MessagePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_MessageField); ok {
		return x.MessageField
	}
	return enums.MessagePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPriceField() enums.PricePlaceholderFieldEnum_PricePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PriceField); ok {
		return x.PriceField
	}
	return enums.PricePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPromotionField() enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PromotionField); ok {
		return x.PromotionField
	}
	return enums.PromotionPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAdCustomizerField() enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AdCustomizerField); ok {
		return x.AdCustomizerField
	}
	return enums.AdCustomizerPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetDsaPageFeedField() enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_DsaPageFeedField); ok {
		return x.DsaPageFeedField
	}
	return enums.DsaPageFeedCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationExtensionTargetingField() enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationExtensionTargetingField); ok {
		return x.LocationExtensionTargetingField
	}
	return enums.LocationExtensionTargetingCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetEducationField() enums.EducationPlaceholderFieldEnum_EducationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_EducationField); ok {
		return x.EducationField
	}
	return enums.EducationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetFlightField() enums.FlightPlaceholderFieldEnum_FlightPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_FlightField); ok {
		return x.FlightField
	}
	return enums.FlightPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCustomField() enums.CustomPlaceholderFieldEnum_CustomPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CustomField); ok {
		return x.CustomField
	}
	return enums.CustomPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetHotelField() enums.HotelPlaceholderFieldEnum_HotelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_HotelField); ok {
		return x.HotelField
	}
	return enums.HotelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetRealEstateField() enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_RealEstateField); ok {
		return x.RealEstateField
	}
	return enums.RealEstatePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetTravelField() enums.TravelPlaceholderFieldEnum_TravelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_TravelField); ok {
		return x.TravelField
	}
	return enums.TravelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocalField() enums.LocalPlaceholderFieldEnum_LocalPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocalField); ok {
		return x.LocalField
	}
	return enums.LocalPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetJobField() enums.JobPlaceholderFieldEnum_JobPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_JobField); ok {
		return x.JobField
	}
	return enums.JobPlaceholderFieldEnum_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttributeFieldMapping) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttributeFieldMapping_OneofMarshaler, _AttributeFieldMapping_OneofUnmarshaler, _AttributeFieldMapping_OneofSizer, []interface{}{
		(*AttributeFieldMapping_SitelinkField)(nil),
		(*AttributeFieldMapping_CallField)(nil),
		(*AttributeFieldMapping_AppField)(nil),
		(*AttributeFieldMapping_LocationField)(nil),
		(*AttributeFieldMapping_AffiliateLocationField)(nil),
		(*AttributeFieldMapping_CalloutField)(nil),
		(*AttributeFieldMapping_StructuredSnippetField)(nil),
		(*AttributeFieldMapping_MessageField)(nil),
		(*AttributeFieldMapping_PriceField)(nil),
		(*AttributeFieldMapping_PromotionField)(nil),
		(*AttributeFieldMapping_AdCustomizerField)(nil),
		(*AttributeFieldMapping_DsaPageFeedField)(nil),
		(*AttributeFieldMapping_LocationExtensionTargetingField)(nil),
		(*AttributeFieldMapping_EducationField)(nil),
		(*AttributeFieldMapping_FlightField)(nil),
		(*AttributeFieldMapping_CustomField)(nil),
		(*AttributeFieldMapping_HotelField)(nil),
		(*AttributeFieldMapping_RealEstateField)(nil),
		(*AttributeFieldMapping_TravelField)(nil),
		(*AttributeFieldMapping_LocalField)(nil),
		(*AttributeFieldMapping_JobField)(nil),
	}
}

func _AttributeFieldMapping_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttributeFieldMapping)
	// field
	switch x := m.Field.(type) {
	case *AttributeFieldMapping_SitelinkField:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.SitelinkField))
	case *AttributeFieldMapping_CallField:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CallField))
	case *AttributeFieldMapping_AppField:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.AppField))
	case *AttributeFieldMapping_LocationField:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.LocationField))
	case *AttributeFieldMapping_AffiliateLocationField:
		b.EncodeVarint(7<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.AffiliateLocationField))
	case *AttributeFieldMapping_CalloutField:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CalloutField))
	case *AttributeFieldMapping_StructuredSnippetField:
		b.EncodeVarint(9<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.StructuredSnippetField))
	case *AttributeFieldMapping_MessageField:
		b.EncodeVarint(10<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.MessageField))
	case *AttributeFieldMapping_PriceField:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.PriceField))
	case *AttributeFieldMapping_PromotionField:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.PromotionField))
	case *AttributeFieldMapping_AdCustomizerField:
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.AdCustomizerField))
	case *AttributeFieldMapping_DsaPageFeedField:
		b.EncodeVarint(14<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.DsaPageFeedField))
	case *AttributeFieldMapping_LocationExtensionTargetingField:
		b.EncodeVarint(15<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.LocationExtensionTargetingField))
	case *AttributeFieldMapping_EducationField:
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.EducationField))
	case *AttributeFieldMapping_FlightField:
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.FlightField))
	case *AttributeFieldMapping_CustomField:
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CustomField))
	case *AttributeFieldMapping_HotelField:
		b.EncodeVarint(19<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.HotelField))
	case *AttributeFieldMapping_RealEstateField:
		b.EncodeVarint(20<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RealEstateField))
	case *AttributeFieldMapping_TravelField:
		b.EncodeVarint(21<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.TravelField))
	case *AttributeFieldMapping_LocalField:
		b.EncodeVarint(22<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.LocalField))
	case *AttributeFieldMapping_JobField:
		b.EncodeVarint(23<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.JobField))
	case nil:
	default:
		return fmt.Errorf("AttributeFieldMapping.Field has unexpected type %T", x)
	}
	return nil
}

func _AttributeFieldMapping_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttributeFieldMapping)
	switch tag {
	case 3: // field.sitelink_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_SitelinkField{enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField(x)}
		return true, err
	case 4: // field.call_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_CallField{enums.CallPlaceholderFieldEnum_CallPlaceholderField(x)}
		return true, err
	case 5: // field.app_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_AppField{enums.AppPlaceholderFieldEnum_AppPlaceholderField(x)}
		return true, err
	case 6: // field.location_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_LocationField{enums.LocationPlaceholderFieldEnum_LocationPlaceholderField(x)}
		return true, err
	case 7: // field.affiliate_location_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_AffiliateLocationField{enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField(x)}
		return true, err
	case 8: // field.callout_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_CalloutField{enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField(x)}
		return true, err
	case 9: // field.structured_snippet_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_StructuredSnippetField{enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField(x)}
		return true, err
	case 10: // field.message_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_MessageField{enums.MessagePlaceholderFieldEnum_MessagePlaceholderField(x)}
		return true, err
	case 11: // field.price_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_PriceField{enums.PricePlaceholderFieldEnum_PricePlaceholderField(x)}
		return true, err
	case 12: // field.promotion_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_PromotionField{enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField(x)}
		return true, err
	case 13: // field.ad_customizer_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_AdCustomizerField{enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField(x)}
		return true, err
	case 14: // field.dsa_page_feed_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_DsaPageFeedField{enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField(x)}
		return true, err
	case 15: // field.location_extension_targeting_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_LocationExtensionTargetingField{enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField(x)}
		return true, err
	case 16: // field.education_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_EducationField{enums.EducationPlaceholderFieldEnum_EducationPlaceholderField(x)}
		return true, err
	case 17: // field.flight_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_FlightField{enums.FlightPlaceholderFieldEnum_FlightPlaceholderField(x)}
		return true, err
	case 18: // field.custom_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_CustomField{enums.CustomPlaceholderFieldEnum_CustomPlaceholderField(x)}
		return true, err
	case 19: // field.hotel_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_HotelField{enums.HotelPlaceholderFieldEnum_HotelPlaceholderField(x)}
		return true, err
	case 20: // field.real_estate_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_RealEstateField{enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField(x)}
		return true, err
	case 21: // field.travel_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_TravelField{enums.TravelPlaceholderFieldEnum_TravelPlaceholderField(x)}
		return true, err
	case 22: // field.local_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_LocalField{enums.LocalPlaceholderFieldEnum_LocalPlaceholderField(x)}
		return true, err
	case 23: // field.job_field
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Field = &AttributeFieldMapping_JobField{enums.JobPlaceholderFieldEnum_JobPlaceholderField(x)}
		return true, err
	default:
		return false, nil
	}
}

func _AttributeFieldMapping_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttributeFieldMapping)
	// field
	switch x := m.Field.(type) {
	case *AttributeFieldMapping_SitelinkField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.SitelinkField))
	case *AttributeFieldMapping_CallField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.CallField))
	case *AttributeFieldMapping_AppField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.AppField))
	case *AttributeFieldMapping_LocationField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.LocationField))
	case *AttributeFieldMapping_AffiliateLocationField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.AffiliateLocationField))
	case *AttributeFieldMapping_CalloutField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.CalloutField))
	case *AttributeFieldMapping_StructuredSnippetField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.StructuredSnippetField))
	case *AttributeFieldMapping_MessageField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.MessageField))
	case *AttributeFieldMapping_PriceField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.PriceField))
	case *AttributeFieldMapping_PromotionField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.PromotionField))
	case *AttributeFieldMapping_AdCustomizerField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.AdCustomizerField))
	case *AttributeFieldMapping_DsaPageFeedField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.DsaPageFeedField))
	case *AttributeFieldMapping_LocationExtensionTargetingField:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.LocationExtensionTargetingField))
	case *AttributeFieldMapping_EducationField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.EducationField))
	case *AttributeFieldMapping_FlightField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.FlightField))
	case *AttributeFieldMapping_CustomField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.CustomField))
	case *AttributeFieldMapping_HotelField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.HotelField))
	case *AttributeFieldMapping_RealEstateField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.RealEstateField))
	case *AttributeFieldMapping_TravelField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.TravelField))
	case *AttributeFieldMapping_LocalField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.LocalField))
	case *AttributeFieldMapping_JobField:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.JobField))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*FeedMapping)(nil), "google.ads.googleads.v1.resources.FeedMapping")
	proto.RegisterType((*AttributeFieldMapping)(nil), "google.ads.googleads.v1.resources.AttributeFieldMapping")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/feed_mapping.proto", fileDescriptor_feed_mapping_f08dc24e8136e1ff)
}

var fileDescriptor_feed_mapping_f08dc24e8136e1ff = []byte{
	// 1316 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x98, 0x4d, 0x6f, 0xe4, 0x44,
	0x13, 0xc7, 0xed, 0x6c, 0x5e, 0x7b, 0xf2, 0x3a, 0x79, 0x36, 0xcf, 0x68, 0x59, 0x41, 0x36, 0x68,
	0xa5, 0x9c, 0x3c, 0x24, 0x44, 0x0b, 0xcc, 0xf2, 0xa2, 0x49, 0x48, 0xe2, 0x44, 0xbb, 0xab, 0x91,
	0x13, 0x45, 0x08, 0x45, 0x8c, 0x7a, 0xc6, 0x3d, 0x13, 0x07, 0x8f, 0x6d, 0xec, 0x76, 0x20, 0x48,
	0x7b, 0xe0, 0x02, 0x37, 0x3e, 0xc4, 0x1e, 0x39, 0xf2, 0x15, 0xb8, 0x71, 0xe6, 0x53, 0xf0, 0x1d,
	0x90, 0x50, 0x77, 0xd9, 0x3d, 0x4e, 0xb6, 0xdb, 0x6d, 0xe6, 0xe6, 0x74, 0xd5, 0xbf, 0x7e, 0x35,
	0xe5, 0xea, 0x76, 0x75, 0xd0, 0xde, 0x30, 0x0c, 0x87, 0x3e, 0x69, 0x62, 0x37, 0x69, 0xc2, 0x23,
	0x7b, 0xba, 0xd9, 0x69, 0xc6, 0x24, 0x09, 0xd3, 0xb8, 0x4f, 0x92, 0xe6, 0x80, 0x10, 0xb7, 0x3b,
	0xc2, 0x51, 0xe4, 0x05, 0x43, 0x2b, 0x8a, 0x43, 0x1a, 0xd6, 0x9f, 0x80, 0xab, 0x85, 0xdd, 0xc4,
	0x12, 0x2a, 0xeb, 0x66, 0xc7, 0x12, 0xaa, 0x47, 0x07, 0xaa, 0xc0, 0x24, 0x48, 0x47, 0x49, 0x13,
	0xbb, 0xdd, 0x7e, 0x9a, 0xd0, 0x70, 0xe4, 0xfd, 0x48, 0xe2, 0x6e, 0xe4, 0xe3, 0x3e, 0xb9, 0x0a,
	0x7d, 0x97, 0xc4, 0xdd, 0x81, 0x47, 0x7c, 0x17, 0x38, 0x8f, 0x6c, 0x4d, 0x90, 0xc1, 0xc0, 0xf3,
	0x3d, 0x4c, 0x49, 0xd7, 0x0f, 0xfb, 0x98, 0x7a, 0x61, 0xa0, 0x8c, 0xf4, 0x89, 0x26, 0x52, 0x14,
	0x29, 0xa5, 0xad, 0x72, 0x69, 0x1f, 0xfb, 0xbe, 0x52, 0xfb, 0x99, 0x5e, 0x1b, 0xa6, 0x54, 0x29,
	0xff, 0x54, 0x23, 0xe7, 0x15, 0x54, 0xaa, 0xdb, 0xe5, 0x6a, 0x37, 0xc1, 0xdd, 0x08, 0x0f, 0x49,
	0x97, 0xbf, 0xe0, 0x7e, 0xec, 0x51, 0x12, 0xb3, 0x12, 0x16, 0x43, 0x7c, 0x51, 0x1e, 0x82, 0xb8,
	0xa9, 0xa6, 0xee, 0x9a, 0x00, 0xc5, 0xde, 0x2a, 0xa4, 0x40, 0x6f, 0x23, 0x92, 0x05, 0xf8, 0xe8,
	0x3f, 0x04, 0x48, 0x28, 0xa6, 0x69, 0x52, 0xad, 0x76, 0x03, 0xdf, 0x1b, 0x5e, 0xa9, 0x2b, 0xff,
	0xbc, 0x5c, 0x7d, 0x15, 0x52, 0xe2, 0x4f, 0xda, 0x6c, 0xd7, 0x61, 0x6f, 0x52, 0x2e, 0xeb, 0x73,
	0x35, 0xb7, 0xa3, 0x17, 0xf3, 0x97, 0x45, 0x7e, 0xa0, 0x24, 0x48, 0x78, 0xa1, 0x71, 0x3c, 0x24,
	0xf4, 0x6e, 0xf1, 0x8b, 0x11, 0x3f, 0xaf, 0x18, 0x71, 0xc2, 0xfe, 0x1f, 0x91, 0x24, 0x61, 0x1d,
	0xa8, 0x92, 0xef, 0x95, 0xcb, 0x8b, 0xb2, 0x42, 0xcb, 0x68, 0x6a, 0x18, 0xc5, 0x5e, 0x9f, 0x4c,
	0xda, 0xb0, 0x51, 0x1c, 0x8e, 0xc2, 0xd2, 0x9f, 0xac, 0xd9, 0x75, 0x31, 0xc1, 0x7e, 0x97, 0xb0,
	0x4e, 0x55, 0xe7, 0xa0, 0xa9, 0x7a, 0xe2, 0x51, 0xe2, 0x7b, 0xc1, 0xb7, 0x93, 0x1e, 0x9b, 0x09,
	0x8d, 0xd3, 0x3e, 0x4d, 0x63, 0xe2, 0x76, 0x93, 0xc0, 0x8b, 0x22, 0x32, 0xf1, 0x01, 0x44, 0x63,
	0x7c, 0x53, 0xb2, 0x0f, 0xde, 0xcd, 0xd4, 0xfc, 0xaf, 0x5e, 0x3a, 0x68, 0x7e, 0x1f, 0xe3, 0x28,
	0x22, 0x71, 0xbe, 0x45, 0x1f, 0xe7, 0xd1, 0x23, 0xaf, 0x89, 0x83, 0x20, 0xa4, 0xbc, 0x99, 0x32,
	0xeb, 0xd6, 0xef, 0xd3, 0xa8, 0x76, 0x44, 0x88, 0xfb, 0x12, 0x76, 0x77, 0xfd, 0x7d, 0xb4, 0x94,
	0x7f, 0x5e, 0xba, 0x01, 0x1e, 0x91, 0x86, 0xb9, 0x69, 0x6e, 0x2f, 0x38, 0x8b, 0xf9, 0xe2, 0x2b,
	0x3c, 0x22, 0xf5, 0x0f, 0xd0, 0x34, 0x3b, 0x12, 0x1a, 0x53, 0x9b, 0xe6, 0x76, 0x6d, 0xf7, 0x71,
	0xf6, 0x75, 0xb2, 0xf2, 0x0c, 0xac, 0x33, 0x1a, 0x7b, 0xc1, 0xf0, 0x02, 0xfb, 0x29, 0x71, 0xb8,
	0x67, 0x3d, 0x46, 0x0d, 0x4c, 0x69, 0xec, 0xf5, 0x52, 0x4a, 0x20, 0xfb, 0xfc, 0x3c, 0x49, 0x1a,
	0x33, 0x9b, 0x0f, 0xb6, 0x6b, 0xbb, 0x1f, 0x5b, 0xda, 0xcf, 0x9d, 0xd5, 0xce, 0x43, 0x1c, 0xb1,
	0x08, 0x59, 0xca, 0xce, 0x06, 0x96, 0x2d, 0x27, 0xf5, 0x6f, 0xd0, 0x2c, 0x9c, 0x55, 0x8d, 0xd9,
	0x4d, 0x73, 0x7b, 0x79, 0xf7, 0x48, 0x49, 0xe0, 0x75, 0xb6, 0x0a, 0x65, 0x38, 0xe3, 0xba, 0xc3,
	0x20, 0x1d, 0xbd, 0xbd, 0xea, 0x64, 0x51, 0xeb, 0x21, 0x5a, 0xbd, 0xbf, 0x37, 0x1a, 0x0f, 0x38,
	0x69, 0x5f, 0x43, 0xea, 0x8c, 0x65, 0xe7, 0xb7, 0x11, 0xe1, 0x9c, 0x7b, 0x6b, 0xb6, 0xe1, 0xac,
	0x44, 0x77, 0x97, 0xea, 0xaf, 0xd1, 0xf2, 0xdd, 0xd3, 0xbb, 0x31, 0xcd, 0x71, 0xe7, 0xd5, 0x7f,
	0xd8, 0x41, 0xae, 0x17, 0x5c, 0x95, 0xd1, 0x36, 0x9c, 0xa5, 0x7e, 0x71, 0x61, 0x7f, 0x1e, 0xcd,
	0xc2, 0x49, 0xb6, 0xf5, 0xd7, 0x06, 0x7a, 0x28, 0x7d, 0x17, 0xf5, 0x63, 0xb4, 0xc6, 0x3f, 0x16,
	0xe3, 0x97, 0xed, 0xb9, 0xbc, 0x85, 0x6a, 0xbb, 0xef, 0xbc, 0xd5, 0x26, 0x27, 0x01, 0x7d, 0xb6,
	0x07, 0x5d, 0xb2, 0xc2, 0x54, 0x22, 0xe4, 0x89, 0x5b, 0x7f, 0x86, 0xe6, 0xa1, 0x4d, 0xbc, 0xbc,
	0xcd, 0x4a, 0xf5, 0x73, 0xdc, 0xf9, 0xc4, 0x65, 0x35, 0x12, 0x3b, 0x97, 0xaf, 0x65, 0xaf, 0x44,
	0x57, 0xa3, 0xb3, 0x4c, 0x54, 0x78, 0x0d, 0xfc, 0x87, 0xf1, 0x1a, 0xa9, 0x8c, 0xac, 0x46, 0x39,
	0x8d, 0x2f, 0xd4, 0x47, 0x08, 0xf1, 0x51, 0x05, 0xd0, 0xf0, 0x7a, 0x5e, 0x68, 0xd0, 0x07, 0xd8,
	0xf7, 0xa5, 0x58, 0x99, 0xc1, 0x36, 0x9c, 0x05, 0x46, 0x00, 0x9c, 0x87, 0x16, 0xd8, 0x50, 0x05,
	0xb4, 0x19, 0x4e, 0x3b, 0xd5, 0xd0, 0xda, 0x51, 0x24, 0x85, 0x49, 0xd6, 0x6d, 0xc3, 0x99, 0xc7,
	0x51, 0x04, 0xa8, 0xd7, 0x68, 0x59, 0x7c, 0x88, 0x80, 0x37, 0x5b, 0xa9, 0xb0, 0x2f, 0x32, 0x91,
	0x14, 0xaa, 0x32, 0xb2, 0xc2, 0xe6, 0x34, 0xc0, 0xbf, 0x31, 0x51, 0x43, 0x32, 0x89, 0x42, 0x26,
	0x73, 0x3c, 0x93, 0x81, 0xee, 0x97, 0xe7, 0xf2, 0xd2, 0x94, 0xb4, 0x5e, 0xb6, 0xe1, 0x6c, 0xe0,
	0xfb, 0x4e, 0x90, 0xe4, 0x2d, 0x5a, 0xca, 0x87, 0x4d, 0x48, 0x6c, 0x9e, 0x27, 0xe6, 0x54, 0x68,
	0x80, 0x30, 0xa5, 0xca, 0x1e, 0x90, 0xd8, 0x6c, 0xc3, 0x59, 0xcc, 0x50, 0xe3, 0xfa, 0x48, 0x3e,
	0x39, 0x90, 0xc6, 0x42, 0xa5, 0xfa, 0x9c, 0x09, 0xf9, 0x19, 0xa8, 0xe5, 0x7b, 0x41, 0xe7, 0xc5,
	0xea, 0x93, 0xdc, 0x77, 0x12, 0xf5, 0xc9, 0x87, 0x11, 0x48, 0x0c, 0x55, 0xaa, 0xcf, 0x4b, 0xd0,
	0x48, 0xd3, 0x51, 0xd8, 0x58, 0x7d, 0x32, 0x14, 0xa0, 0xbf, 0x43, 0x35, 0x18, 0x49, 0x00, 0x5c,
	0xe3, 0xe0, 0x57, 0xba, 0x73, 0x9a, 0x29, 0xa4, 0x58, 0xa9, 0xc5, 0x36, 0x1c, 0xc4, 0x21, 0x80,
	0xfc, 0xc9, 0x44, 0x2b, 0xe3, 0x49, 0x06, 0xb8, 0x8b, 0x9c, 0x7b, 0xa1, 0xe5, 0x66, 0x2a, 0x05,
	0x5b, 0x61, 0xb5, 0x0d, 0x67, 0x59, 0x00, 0x21, 0x87, 0x5f, 0x4d, 0xb4, 0x7e, 0xf7, 0x16, 0x08,
	0x79, 0x2c, 0xf1, 0x3c, 0x2e, 0x75, 0x3b, 0xc6, 0x3d, 0x10, 0x42, 0xf9, 0x66, 0x29, 0x71, 0xb0,
	0x0d, 0x67, 0x0d, 0x17, 0xec, 0x90, 0xd0, 0x2f, 0x26, 0x5a, 0xbf, 0x7b, 0x27, 0x82, 0x84, 0x96,
	0x2b, 0x15, 0xe6, 0xcb, 0x04, 0x77, 0xd8, 0x2b, 0x25, 0xc4, 0x15, 0x1f, 0xab, 0x71, 0x36, 0x4a,
	0xab, 0x6d, 0x38, 0xab, 0xee, 0xd8, 0x08, 0x99, 0xfc, 0x61, 0xa2, 0xad, 0xd2, 0x61, 0x1d, 0x12,
	0x5b, 0xe1, 0x89, 0xd1, 0x8a, 0xa7, 0xdc, 0x61, 0x1e, 0xe7, 0x3c, 0x0f, 0x23, 0xc9, 0xb3, 0xaa,
	0xb3, 0x6d, 0x38, 0xef, 0xf9, 0x4a, 0xdf, 0x71, 0x93, 0x8d, 0x2f, 0x88, 0x90, 0xf2, 0x6a, 0xa5,
	0x5a, 0x1e, 0xe6, 0x2a, 0xe9, 0x9b, 0x55, 0x5a, 0x59, 0x93, 0x09, 0x20, 0xe4, 0x90, 0xa2, 0xc5,
	0xec, 0xa2, 0x07, 0xfc, 0x35, 0xce, 0xef, 0xe8, 0xa6, 0x12, 0x2e, 0x91, 0xc2, 0xe5, 0x26, 0xdb,
	0x70, 0x6a, 0xc0, 0x11, 0xd8, 0xec, 0x6e, 0x0e, 0xd8, 0x7a, 0x25, 0x2c, 0x34, 0xa4, 0xfc, 0xac,
	0x95, 0x9a, 0x18, 0x16, 0x38, 0xe2, 0x24, 0x81, 0x8b, 0x29, 0x50, 0xd7, 0x2b, 0x9d, 0x24, 0x36,
	0x53, 0x48, 0xa1, 0x52, 0x0b, 0x3b, 0x49, 0x38, 0x04, 0x90, 0x3f, 0x9b, 0x68, 0xad, 0x78, 0xa5,
	0x01, 0xf2, 0xff, 0x38, 0xf9, 0x2b, 0x0d, 0xd9, 0x21, 0xd8, 0x3f, 0xe4, 0x32, 0x29, 0x5e, 0x6d,
	0x66, 0x13, 0x68, 0x2c, 0xac, 0xa2, 0xe4, 0xd9, 0x6d, 0x04, 0x52, 0x78, 0x58, 0xa9, 0xe4, 0xe7,
	0x5c, 0x22, 0xc5, 0xcb, 0x4d, 0xac, 0xe4, 0xc0, 0x11, 0x25, 0x87, 0x3b, 0x39, 0x50, 0x37, 0x2a,
	0x95, 0x9c, 0xed, 0x32, 0x5f, 0x39, 0x75, 0x48, 0x4b, 0xce, 0x21, 0x62, 0xb2, 0xba, 0x0e, 0x7b,
	0x19, 0xf0, 0xff, 0x95, 0x26, 0xab, 0xd3, 0xb0, 0x27, 0xc5, 0x49, 0xd6, 0xd9, 0x64, 0x75, 0x1d,
	0xf6, 0xf8, 0xf3, 0xfe, 0x1c, 0x9a, 0xe1, 0x98, 0xfd, 0x7f, 0x4c, 0xf4, 0xb4, 0x1f, 0x8e, 0xf4,
	0x17, 0xa1, 0xfd, 0xd5, 0xc2, 0xd4, 0xde, 0x61, 0xe3, 0x70, 0xc7, 0xfc, 0xfa, 0x34, 0x93, 0x0d,
	0x43, 0x1f, 0x07, 0x43, 0x2b, 0x8c, 0x87, 0xcd, 0x21, 0x09, 0xf8, 0xb0, 0x9c, 0xdf, 0x2a, 0x23,
	0x2f, 0x29, 0xf9, 0x1f, 0xe4, 0x73, 0xf1, 0xf4, 0x66, 0xea, 0xc1, 0x71, 0xbb, 0xfd, 0xdb, 0xd4,
	0x93, 0x63, 0x08, 0xd9, 0x76, 0x13, 0x0b, 0x1e, 0xd9, 0xd3, 0xc5, 0x8e, 0xe5, 0xe4, 0x9e, 0x7f,
	0xe6, 0x3e, 0x97, 0x6d, 0x37, 0xb9, 0x14, 0x3e, 0x97, 0x17, 0x3b, 0x97, 0xc2, 0xe7, 0xef, 0xa9,
	0xa7, 0x60, 0x68, 0xb5, 0xda, 0x6e, 0xd2, 0x6a, 0x09, 0xaf, 0x56, 0xeb, 0x62, 0xa7, 0xd5, 0x12,
	0x7e, 0xbd, 0x59, 0x9e, 0xec, 0x87, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x40, 0x51, 0x6f, 0xf7,
	0x2f, 0x15, 0x00, 0x00,
}
