// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1/cloud_redis.proto

package redis // import "google.golang.org/genproto/googleapis/cloud/redis/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
	// Redis instance is importing data (availability may be affected).
	Instance_IMPORTING Instance_State = 8
	// Redis instance is failing over (availability may be affected).
	Instance_FAILING_OVER Instance_State = 9
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "UPDATING",
	4: "DELETING",
	5: "REPAIRING",
	6: "MAINTENANCE",
	8: "IMPORTING",
	9: "FAILING_OVER",
}
var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
	"IMPORTING":         8,
	"FAILING_OVER":      9,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}
var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}
func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{0, 1}
}

type FailoverInstanceRequest_DataProtectionMode int32

const (
	FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED FailoverInstanceRequest_DataProtectionMode = 0
	// Instance failover will be protected with data loss control. More
	// specifically, the failover will only be performed if the current
	// replication offset diff between master and replica is under a certain
	// threshold.
	FailoverInstanceRequest_LIMITED_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 1
	// Instance failover will be performed without data loss control.
	FailoverInstanceRequest_FORCE_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 2
)

var FailoverInstanceRequest_DataProtectionMode_name = map[int32]string{
	0: "DATA_PROTECTION_MODE_UNSPECIFIED",
	1: "LIMITED_DATA_LOSS",
	2: "FORCE_DATA_LOSS",
}
var FailoverInstanceRequest_DataProtectionMode_value = map[string]int32{
	"DATA_PROTECTION_MODE_UNSPECIFIED": 0,
	"LIMITED_DATA_LOSS":                1,
	"FORCE_DATA_LOSS":                  2,
}

func (x FailoverInstanceRequest_DataProtectionMode) String() string {
	return proto.EnumName(FailoverInstanceRequest_DataProtectionMode_name, int32(x))
}
func (FailoverInstanceRequest_DataProtectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{13, 0}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id] and
	// [alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. If [alternative_location_id] is also provided, it must be
	// different from [location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used. Updating the
	// version will perform an upgrade/downgrade to the new version. Currently,
	// the supported values are:
	//  * `REDIS_4_0` for Redis 4.0 compatibility
	//  * `REDIS_3_2` for Redis 3.2 compatibility
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in an authorized network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed Redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. For Basic
	// Tier instances, this will always be the same as the [location_id]
	// provided by the user at creation time. For Standard Tier instances,
	// this can be either [location_id] or [alternative_location_id] and can
	// change after a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//
	//  Redis 3.2 and above:
	//  * maxmemory-policy
	//  * notify-keyspace-events
	//
	//  Redis 4.0 and above:
	//  * activedefrag
	//  * lfu-log-factor
	//  * lfu-decay-time
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GiB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork string `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	// Output only. Cloud IAM identity used by import / export operations to
	// transfer data to/from Cloud Storage. Format is
	// "serviceAccount:<service_account_email>". The value may change over time
	// for a given instance so should be checked before each import/export
	// operation.
	PersistenceIamIdentity string   `protobuf:"bytes,21,opt,name=persistence_iam_identity,json=persistenceIamIdentity,proto3" json:"persistence_iam_identity,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{0}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (dst *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(dst, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

func (m *Instance) GetPersistenceIamIdentity() string {
	if m != nil {
		return m.PersistenceIamIdentity
	}
	return ""
}

// Request for [ListInstances][google.cloud.redis.v1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudRedis.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{1}
}
func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(dst, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for [ListInstances][google.cloud.redis.v1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the "name" field set to a value of
	// the form projects/{project_id}/locations/{location_id}/instances/- and the
	// "status" field set to ERROR and "status_message" field set to "location not
	// available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{2}
}
func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(dst, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.redis.v1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{3}
}
func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(dst, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for
// [CreateInstance][google.cloud.redis.v1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{4}
}
func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(dst, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for
// [UpdateInstance][google.cloud.redis.v1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][CloudRedis.Instance]:
	//
	//  *   `displayName`
	//  *   `labels`
	//  *   `memorySizeGb`
	//  *   `redisConfig`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{5}
}
func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(dst, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for
// [DeleteInstance][google.cloud.redis.v1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{6}
}
func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(dst, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The GCS location for the input content
type GcsSource struct {
	// Required. Source data URI. (e.g. 'gs://my_bucket/my_object').
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{7}
}
func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (dst *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(dst, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The input content
type InputConfig struct {
	// Required. Specify source location of input data
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source               isInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{8}
}
func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (dst *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(dst, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InputConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InputConfig_OneofMarshaler, _InputConfig_OneofUnmarshaler, _InputConfig_OneofSizer, []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

func _InputConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InputConfig)
	// source
	switch x := m.Source.(type) {
	case *InputConfig_GcsSource:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GcsSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InputConfig.Source has unexpected type %T", x)
	}
	return nil
}

func _InputConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InputConfig)
	switch tag {
	case 1: // source.gcs_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GcsSource)
		err := b.DecodeMessage(msg)
		m.Source = &InputConfig_GcsSource{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InputConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InputConfig)
	// source
	switch x := m.Source.(type) {
	case *InputConfig_GcsSource:
		s := proto.Size(x.GcsSource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request for [Import][google.cloud.redis.v1.CloudRedis.ImportInstance].
type ImportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be imported.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportInstanceRequest) Reset()         { *m = ImportInstanceRequest{} }
func (m *ImportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ImportInstanceRequest) ProtoMessage()    {}
func (*ImportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{9}
}
func (m *ImportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportInstanceRequest.Unmarshal(m, b)
}
func (m *ImportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *ImportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportInstanceRequest.Merge(dst, src)
}
func (m *ImportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ImportInstanceRequest.Size(m)
}
func (m *ImportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportInstanceRequest proto.InternalMessageInfo

func (m *ImportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportInstanceRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// The GCS location for the output content
type GcsDestination struct {
	// Required. Data destination URI (e.g.
	// 'gs://my_bucket/my_object'). Existing files will be overwritten.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{10}
}
func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (dst *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(dst, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The output content
type OutputConfig struct {
	// Required. Specify destination location of output data
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{11}
}
func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (dst *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(dst, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OutputConfig_OneofMarshaler, _OutputConfig_OneofUnmarshaler, _OutputConfig_OneofSizer, []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

func _OutputConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OutputConfig)
	// destination
	switch x := m.Destination.(type) {
	case *OutputConfig_GcsDestination:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GcsDestination); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OutputConfig.Destination has unexpected type %T", x)
	}
	return nil
}

func _OutputConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OutputConfig)
	switch tag {
	case 1: // destination.gcs_destination
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GcsDestination)
		err := b.DecodeMessage(msg)
		m.Destination = &OutputConfig_GcsDestination{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OutputConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OutputConfig)
	// destination
	switch x := m.Destination.(type) {
	case *OutputConfig_GcsDestination:
		s := proto.Size(x.GcsDestination)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request for [Export][google.cloud.redis.v1.CloudRedis.ExportInstance].
type ExportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be exported.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportInstanceRequest) Reset()         { *m = ExportInstanceRequest{} }
func (m *ExportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ExportInstanceRequest) ProtoMessage()    {}
func (*ExportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{12}
}
func (m *ExportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportInstanceRequest.Unmarshal(m, b)
}
func (m *ExportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *ExportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportInstanceRequest.Merge(dst, src)
}
func (m *ExportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ExportInstanceRequest.Size(m)
}
func (m *ExportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportInstanceRequest proto.InternalMessageInfo

func (m *ExportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportInstanceRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request for [Failover][google.cloud.redis.v1.CloudRedis.FailoverInstance].
type FailoverInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Available data protection modes that the user can choose. If it's
	// unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
	DataProtectionMode   FailoverInstanceRequest_DataProtectionMode `protobuf:"varint,2,opt,name=data_protection_mode,json=dataProtectionMode,proto3,enum=google.cloud.redis.v1.FailoverInstanceRequest_DataProtectionMode" json:"data_protection_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *FailoverInstanceRequest) Reset()         { *m = FailoverInstanceRequest{} }
func (m *FailoverInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*FailoverInstanceRequest) ProtoMessage()    {}
func (*FailoverInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{13}
}
func (m *FailoverInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailoverInstanceRequest.Unmarshal(m, b)
}
func (m *FailoverInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailoverInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *FailoverInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailoverInstanceRequest.Merge(dst, src)
}
func (m *FailoverInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_FailoverInstanceRequest.Size(m)
}
func (m *FailoverInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FailoverInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FailoverInstanceRequest proto.InternalMessageInfo

func (m *FailoverInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FailoverInstanceRequest) GetDataProtectionMode() FailoverInstanceRequest_DataProtectionMode {
	if m != nil {
		return m.DataProtectionMode
	}
	return FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED
}

// Represents the v1 metadata of the long-running operation.
type OperationMetadata struct {
	// Creation timestamp.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// End timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Operation target.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Operation verb.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Operation status details.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Specifies if cancellation was requested for the operation.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// API version.
	ApiVersion           string   `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{14}
}
func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (dst *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(dst, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *OperationMetadata) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *OperationMetadata) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

func (m *OperationMetadata) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *OperationMetadata) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *OperationMetadata) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{15}
}
func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (dst *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(dst, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_5a47d8b10cb9ffbe, []int{16}
}
func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (dst *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(dst, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1.DeleteInstanceRequest")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.redis.v1.GcsSource")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.redis.v1.InputConfig")
	proto.RegisterType((*ImportInstanceRequest)(nil), "google.cloud.redis.v1.ImportInstanceRequest")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.redis.v1.GcsDestination")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.redis.v1.OutputConfig")
	proto.RegisterType((*ExportInstanceRequest)(nil), "google.cloud.redis.v1.ExportInstanceRequest")
	proto.RegisterType((*FailoverInstanceRequest)(nil), "google.cloud.redis.v1.FailoverInstanceRequest")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.redis.v1.OperationMetadata")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1.ZoneMetadata")
	proto.RegisterEnum("google.cloud.redis.v1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
	proto.RegisterEnum("google.cloud.redis.v1.FailoverInstanceRequest_DataProtectionMode", FailoverInstanceRequest_DataProtectionMode_name, FailoverInstanceRequest_DataProtectionMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from GCS into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in GCS.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc *grpc.ClientConn
}

func NewCloudRedisClient(cc *grpc.ClientConn) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/ImportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/ExportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/FailoverInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from GCS into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(context.Context, *ImportInstanceRequest) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in GCS.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(context.Context, *ExportInstanceRequest) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(context.Context, *FailoverInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ImportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ImportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/ImportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ImportInstance(ctx, req.(*ImportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ExportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ExportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/ExportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ExportInstance(ctx, req.(*ExportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_FailoverInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).FailoverInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/FailoverInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).FailoverInstance(ctx, req.(*FailoverInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "ImportInstance",
			Handler:    _CloudRedis_ImportInstance_Handler,
		},
		{
			MethodName: "ExportInstance",
			Handler:    _CloudRedis_ExportInstance_Handler,
		},
		{
			MethodName: "FailoverInstance",
			Handler:    _CloudRedis_FailoverInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1/cloud_redis.proto",
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1/cloud_redis.proto", fileDescriptor_cloud_redis_5a47d8b10cb9ffbe)
}

var fileDescriptor_cloud_redis_5a47d8b10cb9ffbe = []byte{
	// 1726 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x41, 0x6f, 0xdb, 0xc8,
	0x15, 0x0e, 0x65, 0xcb, 0x6b, 0x3d, 0xc9, 0xb2, 0x3c, 0xb1, 0xb2, 0xac, 0xda, 0x20, 0x2a, 0x93,
	0xb4, 0x5e, 0x6f, 0x57, 0x42, 0xdc, 0x6e, 0x90, 0xd8, 0x58, 0x2c, 0x64, 0x89, 0xb6, 0x09, 0xd8,
	0x92, 0x40, 0x29, 0x01, 0x9a, 0x0b, 0x31, 0x26, 0xc7, 0xcc, 0xac, 0x29, 0x92, 0x25, 0x47, 0x6a,
	0x9c, 0x62, 0x2f, 0x3d, 0x16, 0x68, 0xd1, 0xa2, 0x0b, 0xf4, 0x56, 0xb4, 0x40, 0x80, 0xfe, 0xa0,
	0xfe, 0x81, 0x1e, 0xfa, 0x43, 0x8a, 0x19, 0x92, 0x12, 0x25, 0x8b, 0x90, 0x7d, 0xe8, 0x8d, 0xf3,
	0xbd, 0xf7, 0x66, 0xbe, 0x79, 0x6f, 0x66, 0xbe, 0x27, 0xc1, 0xcf, 0x6d, 0xcf, 0xb3, 0x1d, 0xd2,
	0x34, 0x1d, 0x6f, 0x6c, 0x35, 0x03, 0x62, 0xd1, 0xb0, 0x39, 0x79, 0x11, 0x0d, 0x0d, 0x31, 0x6c,
	0xf8, 0x81, 0xc7, 0x3c, 0x54, 0x8d, 0x1c, 0x1b, 0xc2, 0xd2, 0x88, 0x2c, 0x93, 0x17, 0xb5, 0x9f,
	0xc4, 0xf1, 0xd8, 0xa7, 0x4d, 0xec, 0xba, 0x1e, 0xc3, 0x8c, 0x7a, 0x6e, 0x1c, 0x54, 0x7b, 0x1a,
	0x5b, 0x1d, 0xcf, 0xb5, 0x83, 0xb1, 0xeb, 0x52, 0xd7, 0x6e, 0x7a, 0x3e, 0x09, 0xe6, 0x9c, 0xea,
	0xb1, 0x93, 0x18, 0x5d, 0x8e, 0xaf, 0x9a, 0x57, 0x94, 0x38, 0x96, 0x31, 0xc2, 0xe1, 0x75, 0xec,
	0xf1, 0x64, 0xd1, 0x83, 0xd1, 0x11, 0x09, 0x19, 0x1e, 0xf9, 0x91, 0x83, 0xf2, 0xb7, 0x02, 0x6c,
	0x6a, 0x6e, 0xc8, 0xb0, 0x6b, 0x12, 0x84, 0x60, 0xdd, 0xc5, 0x23, 0x22, 0x4b, 0x75, 0x69, 0xaf,
	0xa0, 0x8b, 0x6f, 0xf4, 0x53, 0x28, 0x59, 0x34, 0xf4, 0x1d, 0x7c, 0x63, 0x08, 0x5b, 0x4e, 0xd8,
	0x8a, 0x31, 0xd6, 0xe5, 0x2e, 0x6d, 0xd8, 0x70, 0xf0, 0x25, 0x71, 0x42, 0x79, 0xad, 0xbe, 0xb6,
	0x57, 0x3c, 0xf8, 0xb2, 0xb1, 0x74, 0xc7, 0x8d, 0x64, 0x9d, 0xc6, 0xb9, 0xf0, 0x56, 0x5d, 0x16,
	0xdc, 0xe8, 0x71, 0x28, 0x7a, 0x02, 0x45, 0xc7, 0x33, 0xc5, 0xf6, 0x0c, 0x6a, 0xc9, 0xeb, 0x62,
	0x19, 0x48, 0x20, 0xcd, 0x42, 0x2f, 0xe1, 0x73, 0xec, 0x30, 0x12, 0xb8, 0x98, 0xd1, 0x09, 0x31,
	0xd2, 0xce, 0x79, 0xe1, 0x5c, 0x4d, 0x99, 0xcf, 0x67, 0x71, 0x4f, 0x61, 0x4b, 0x30, 0x30, 0x26,
	0x24, 0x08, 0xa9, 0xe7, 0xca, 0x9f, 0x09, 0xef, 0x92, 0x00, 0xdf, 0x46, 0x18, 0xda, 0x87, 0x9d,
	0x80, 0x84, 0x24, 0x98, 0x10, 0xcb, 0xa0, 0xbe, 0x11, 0x60, 0xd7, 0x26, 0x72, 0x41, 0x38, 0x6e,
	0x27, 0x06, 0xcd, 0xd7, 0x39, 0xcc, 0xb3, 0xf4, 0xde, 0x0b, 0x99, 0x0c, 0x51, 0x96, 0xf8, 0x37,
	0xc7, 0x7c, 0x2f, 0x60, 0x72, 0xb1, 0x2e, 0xed, 0xe5, 0x75, 0xf1, 0x8d, 0x1a, 0xf0, 0xd0, 0x1c,
	0x07, 0x01, 0x71, 0xd9, 0x1c, 0xd9, 0x92, 0x08, 0xdb, 0x89, 0x4d, 0x29, 0xa2, 0x47, 0x50, 0x34,
	0x03, 0x82, 0x19, 0x31, 0x78, 0x91, 0xe4, 0xad, 0xba, 0xb4, 0x57, 0x3c, 0xa8, 0x25, 0xb9, 0x4c,
	0x2a, 0xd8, 0x18, 0x26, 0x15, 0xd4, 0x21, 0x72, 0xe7, 0x00, 0x3a, 0x82, 0x7c, 0xc8, 0x30, 0x23,
	0x72, 0xb9, 0x2e, 0xed, 0x95, 0x0f, 0x9e, 0xaf, 0x2a, 0xc1, 0x80, 0x3b, 0xeb, 0x51, 0x0c, 0x7a,
	0x0e, 0x65, 0xfe, 0x31, 0x0e, 0x8d, 0x11, 0x09, 0x43, 0x6c, 0x13, 0x79, 0x5b, 0x90, 0xdc, 0x8a,
	0xd0, 0x8b, 0x08, 0x44, 0x6f, 0x93, 0x4c, 0x9a, 0x9e, 0x7b, 0x45, 0xed, 0x50, 0xae, 0x88, 0x72,
	0xbf, 0x58, 0xb5, 0x96, 0xce, 0x91, 0x76, 0x14, 0x13, 0x15, 0x3d, 0x4a, 0x7e, 0x0c, 0xa1, 0x57,
	0xb0, 0xce, 0x28, 0x09, 0xe4, 0x1d, 0x41, 0xfd, 0xd9, 0xaa, 0xe9, 0x86, 0x94, 0x04, 0xba, 0x88,
	0x40, 0xcf, 0xa0, 0x3c, 0x22, 0x23, 0x2f, 0xb8, 0x31, 0x42, 0xfa, 0x91, 0x18, 0xf6, 0xa5, 0x8c,
	0x44, 0x01, 0x4a, 0x11, 0x3a, 0xa0, 0x1f, 0xc9, 0xe9, 0x25, 0xfa, 0x0a, 0x10, 0x1e, 0xb3, 0xf7,
	0x5e, 0x40, 0x3f, 0x12, 0xcb, 0x70, 0x09, 0xfb, 0xad, 0x17, 0x5c, 0xcb, 0xbb, 0x51, 0x1d, 0x66,
	0x96, 0x6e, 0x64, 0x40, 0xaf, 0x40, 0xf6, 0xf9, 0xb1, 0x08, 0x19, 0x71, 0x4d, 0x62, 0x50, 0x3c,
	0x32, 0xa8, 0x45, 0x5c, 0x46, 0xd9, 0x8d, 0x5c, 0x15, 0x41, 0x8f, 0x52, 0x76, 0x0d, 0x8f, 0xb4,
	0xd8, 0x5a, 0x7b, 0x0d, 0xc5, 0xd4, 0xd1, 0x46, 0x15, 0x58, 0xbb, 0x26, 0x37, 0xf1, 0x6d, 0xe2,
	0x9f, 0x68, 0x17, 0xf2, 0x13, 0xec, 0x8c, 0x93, 0x5b, 0x14, 0x0d, 0x0e, 0x73, 0xaf, 0xa4, 0xda,
	0xb7, 0xb0, 0x73, 0x2b, 0x4d, 0xf7, 0x99, 0x40, 0xf9, 0x41, 0x82, 0xbc, 0x28, 0x2a, 0xaa, 0xc2,
	0xce, 0x60, 0xd8, 0x1a, 0xaa, 0xc6, 0x9b, 0xee, 0xa0, 0xaf, 0xb6, 0xb5, 0x13, 0x4d, 0xed, 0x54,
	0x1e, 0xa0, 0x12, 0x6c, 0xb6, 0x75, 0xb5, 0x35, 0xd4, 0xba, 0xa7, 0x15, 0x09, 0x15, 0x20, 0xaf,
	0xab, 0xad, 0xce, 0xaf, 0x2b, 0x39, 0x6e, 0x78, 0xd3, 0xef, 0x44, 0x86, 0x35, 0x3e, 0xea, 0xa8,
	0xe7, 0xaa, 0x18, 0xad, 0xa3, 0x2d, 0x28, 0xe8, 0x6a, 0xbf, 0xa5, 0xe9, 0x7c, 0x98, 0x47, 0xdb,
	0x50, 0xbc, 0x68, 0x69, 0xdd, 0xa1, 0xda, 0x6d, 0x75, 0xdb, 0x6a, 0x65, 0x83, 0xdb, 0xb5, 0x8b,
	0x7e, 0x4f, 0x17, 0xee, 0x9b, 0xa8, 0x02, 0xa5, 0x93, 0x96, 0x76, 0xae, 0x75, 0x4f, 0x8d, 0xde,
	0x5b, 0x55, 0xaf, 0x14, 0x94, 0x57, 0xb0, 0xce, 0xeb, 0x85, 0x76, 0xa1, 0x32, 0xd4, 0x54, 0x7d,
	0x81, 0x53, 0x01, 0xf2, 0xc7, 0xad, 0x81, 0xd6, 0xae, 0x48, 0x7c, 0xea, 0xc1, 0xb0, 0xd5, 0xed,
	0xb4, 0xf4, 0x8e, 0x71, 0xd6, 0xaa, 0xac, 0x29, 0xdf, 0xc1, 0xee, 0x39, 0x0d, 0x59, 0x52, 0xf6,
	0x50, 0x27, 0xbf, 0x19, 0x93, 0x90, 0xa1, 0x47, 0xb0, 0xe1, 0x63, 0x7e, 0x75, 0xe2, 0xbc, 0xc4,
	0x23, 0xf4, 0x63, 0x28, 0xf8, 0xd8, 0x26, 0xe2, 0x24, 0x88, 0xf4, 0xe4, 0xf5, 0x4d, 0x0e, 0xf0,
	0x43, 0x80, 0x1e, 0x03, 0x08, 0x23, 0xf3, 0xae, 0x89, 0x2b, 0xaf, 0x89, 0x40, 0xe1, 0x3e, 0xe4,
	0x80, 0xf2, 0x0f, 0x09, 0xaa, 0x0b, 0x8b, 0x85, 0xbe, 0xe7, 0x86, 0x04, 0x7d, 0x03, 0x05, 0x9a,
	0x80, 0xb2, 0x24, 0xce, 0xfb, 0x93, 0x15, 0x07, 0x54, 0x9f, 0x45, 0xa0, 0x9f, 0xc1, 0xb6, 0x4b,
	0x3e, 0x30, 0x23, 0xb5, 0x78, 0x54, 0xb9, 0x2d, 0x0e, 0xf7, 0x13, 0x02, 0xa8, 0x0e, 0xc5, 0xb1,
	0x1b, 0x10, 0x6c, 0xbe, 0xc7, 0x97, 0x0e, 0x11, 0xef, 0x68, 0x41, 0x4f, 0x43, 0xca, 0x1e, 0xa0,
	0x53, 0x32, 0x25, 0x98, 0x24, 0x63, 0xc9, 0x8b, 0xad, 0xfc, 0x51, 0x82, 0x6a, 0x5b, 0xbc, 0x0c,
	0x8b, 0xde, 0x59, 0xa9, 0x7b, 0x02, 0xc5, 0x84, 0x32, 0x7f, 0xa1, 0x22, 0x86, 0x90, 0x40, 0xe2,
	0x69, 0xda, 0x4c, 0x46, 0x22, 0x79, 0x77, 0x48, 0xc2, 0x34, 0x40, 0xf9, 0x8b, 0x04, 0xd5, 0x37,
	0xbe, 0xb5, 0x84, 0xcf, 0x11, 0x14, 0xc7, 0xc2, 0x20, 0x24, 0x4b, 0x90, 0x5a, 0xf6, 0xe2, 0x9d,
	0x70, 0x55, 0xbb, 0xc0, 0xe1, 0xb5, 0x0e, 0x91, 0x3b, 0xff, 0x9e, 0xe3, 0x94, 0xbb, 0x2f, 0xa7,
	0x2f, 0xa1, 0xda, 0x21, 0x0e, 0xb9, 0x4d, 0x69, 0x59, 0x42, 0x1f, 0x43, 0xe1, 0xd4, 0x0c, 0x07,
	0xde, 0x38, 0x30, 0x09, 0xbf, 0x93, 0xe3, 0x80, 0x26, 0x77, 0x72, 0x1c, 0x50, 0xe5, 0x1d, 0x14,
	0x35, 0xd7, 0x1f, 0xb3, 0xe8, 0xea, 0xa2, 0x16, 0x80, 0x6d, 0x86, 0x46, 0x28, 0xdc, 0xe3, 0x3d,
	0xd5, 0x33, 0x98, 0x4d, 0xa7, 0x3d, 0x7b, 0xa0, 0x17, 0xec, 0x64, 0x70, 0xbc, 0x09, 0x1b, 0x51,
	0xb8, 0x12, 0x40, 0x55, 0x1b, 0x71, 0x35, 0xb9, 0x03, 0x4f, 0xa4, 0x42, 0x89, 0x72, 0x22, 0xf1,
	0xfb, 0x1c, 0x57, 0x4a, 0xc9, 0xcc, 0xca, 0x94, 0xb3, 0x5e, 0xa4, 0xb3, 0x81, 0xa2, 0x40, 0xf9,
	0xd4, 0x0c, 0x3b, 0x24, 0x64, 0xd4, 0x15, 0xda, 0xb4, 0x64, 0xcf, 0x1e, 0x94, 0x7a, 0x63, 0x36,
	0xdb, 0x74, 0x1f, 0xb6, 0xf9, 0xa6, 0xad, 0x59, 0x50, 0xbc, 0xf3, 0xe7, 0xd9, 0x3b, 0x4f, 0xad,
	0x70, 0xf6, 0x40, 0x2f, 0xdb, 0x73, 0xc8, 0xf1, 0x16, 0x14, 0x53, 0xb3, 0x29, 0x63, 0xa8, 0xaa,
	0x1f, 0xee, 0x9a, 0x88, 0x33, 0xd8, 0xf2, 0x04, 0xbb, 0xf9, 0x4c, 0x3c, 0xcd, 0xe0, 0x92, 0xde,
	0x89, 0x5e, 0xf2, 0x52, 0x23, 0xe5, 0x0f, 0x39, 0xf8, 0xfc, 0x04, 0x53, 0xc7, 0x9b, 0x90, 0xe0,
	0x2e, 0x2b, 0x87, 0xb0, 0x6b, 0x61, 0x86, 0x0d, 0x7e, 0x76, 0x89, 0x29, 0x24, 0x7f, 0xe4, 0x59,
	0xd1, 0x01, 0x2d, 0x1f, 0xb4, 0x32, 0x08, 0x64, 0xac, 0xd0, 0xe8, 0x60, 0x86, 0xfb, 0xd3, 0x99,
	0x2e, 0x3c, 0x8b, 0xe8, 0xc8, 0xba, 0x85, 0x29, 0x57, 0x80, 0x6e, 0x7b, 0xa2, 0x67, 0x50, 0xef,
	0xb4, 0x86, 0x2d, 0xa3, 0xaf, 0xf7, 0x86, 0x6a, 0x7b, 0xa8, 0xf5, 0xba, 0xc6, 0x45, 0xaf, 0xb3,
	0xa8, 0x0a, 0x55, 0xd8, 0x39, 0xd7, 0x2e, 0xb4, 0xa1, 0xda, 0x31, 0x84, 0xf7, 0x79, 0x6f, 0x30,
	0xa8, 0x48, 0xe8, 0x21, 0x6c, 0x9f, 0xf4, 0xf4, 0xb6, 0x9a, 0x02, 0x73, 0xca, 0xa7, 0x1c, 0xec,
	0xf4, 0x92, 0x1e, 0xf4, 0x82, 0x30, 0xcc, 0xb9, 0x2c, 0xb6, 0x2d, 0xd2, 0xbd, 0xda, 0x96, 0xaf,
	0x61, 0x93, 0xb8, 0x56, 0x14, 0x99, 0x5b, 0x19, 0xf9, 0x19, 0x71, 0x2d, 0x11, 0xf6, 0x08, 0x36,
	0x18, 0x0e, 0x6c, 0xc2, 0xe2, 0xa7, 0x3c, 0x1e, 0xf1, 0x92, 0x4c, 0x48, 0x70, 0x19, 0x77, 0x8f,
	0xe2, 0x9b, 0xf7, 0x7f, 0x71, 0x73, 0x63, 0x11, 0x86, 0xa9, 0x13, 0x77, 0x8b, 0xa5, 0x08, 0xec,
	0x08, 0x0c, 0x7d, 0x01, 0x15, 0x93, 0x67, 0xde, 0x31, 0x82, 0x28, 0xf7, 0xc4, 0x92, 0x37, 0xea,
	0xd2, 0xde, 0xa6, 0xbe, 0x1d, 0xe1, 0x7a, 0x02, 0xf3, 0xc7, 0x12, 0xfb, 0x74, 0xa1, 0x9b, 0x04,
	0xec, 0xd3, 0xb8, 0x97, 0x54, 0xfe, 0x23, 0x41, 0x25, 0x69, 0xeb, 0xa6, 0x59, 0xb2, 0x60, 0x1b,
	0x4f, 0x30, 0x75, 0xf8, 0x5b, 0x6e, 0x7c, 0xf4, 0xdc, 0xa9, 0x9a, 0x1c, 0x65, 0x9c, 0x89, 0xc5,
	0x19, 0x1a, 0xad, 0x24, 0xfc, 0x1d, 0x8f, 0x8e, 0xfa, 0xa8, 0x32, 0x9e, 0x03, 0x6b, 0x57, 0xf0,
	0x70, 0x89, 0xdb, 0x92, 0x3e, 0xe2, 0x75, 0xba, 0x8f, 0xc8, 0xbe, 0x19, 0x7c, 0x8e, 0x84, 0x40,
	0xba, 0xd9, 0x28, 0x43, 0x29, 0x6d, 0x3a, 0xf8, 0x13, 0x00, 0xb4, 0x79, 0xa8, 0xe8, 0x61, 0xd0,
	0x3f, 0x25, 0xd8, 0x9a, 0x93, 0x53, 0x94, 0xf5, 0x93, 0x60, 0x99, 0xc2, 0xd7, 0x7e, 0x71, 0x37,
	0xe7, 0x48, 0xa1, 0x95, 0xaf, 0x7f, 0xff, 0xef, 0xff, 0xfe, 0x35, 0xd7, 0x44, 0x5f, 0xf1, 0x5f,
	0x5f, 0xbf, 0x8b, 0x14, 0xed, 0x1b, 0x3f, 0xf0, 0xbe, 0x23, 0x26, 0x0b, 0x9b, 0xfb, 0xcd, 0xa4,
	0xf7, 0x0e, 0x9b, 0xfb, 0xdf, 0x37, 0x67, 0xca, 0xfc, 0x67, 0x09, 0x8a, 0x29, 0x41, 0x45, 0x5f,
	0x64, 0x3d, 0x54, 0xb7, 0x44, 0xb7, 0xb6, 0x4a, 0x67, 0x16, 0x28, 0xf1, 0x87, 0x21, 0x83, 0xd0,
	0x8c, 0x4f, 0x73, 0xff, 0x7b, 0xf4, 0x77, 0x09, 0xca, 0xf3, 0xc2, 0x8d, 0xb2, 0x52, 0xb1, 0x54,
	0xdf, 0x6b, 0x8f, 0x13, 0xef, 0xd4, 0xaf, 0xc6, 0xc6, 0xf4, 0xc6, 0x2a, 0xdf, 0x0a, 0x5a, 0xaf,
	0x95, 0xfb, 0x65, 0xea, 0x70, 0xaa, 0x9a, 0xe8, 0x5f, 0x12, 0x94, 0xe7, 0x95, 0x3c, 0x93, 0xe0,
	0x52, 0xc1, 0x5f, 0x45, 0xf0, 0x4c, 0x10, 0x3c, 0x3e, 0x78, 0x29, 0x08, 0x26, 0xcb, 0x36, 0xee,
	0x9a, 0xc0, 0x14, 0x53, 0x9e, 0xca, 0x79, 0xe1, 0xcc, 0x64, 0xba, 0x54, 0x5f, 0xef, 0x9a, 0xca,
	0x5f, 0xdd, 0xab, 0xc2, 0x87, 0x54, 0xac, 0x75, 0x28, 0xed, 0x0b, 0x82, 0xf3, 0x82, 0x96, 0x49,
	0x70, 0xa9, 0xee, 0xfd, 0x9f, 0x08, 0x92, 0x0f, 0x09, 0xc1, 0x4f, 0x12, 0x54, 0x16, 0x75, 0x09,
	0x35, 0xee, 0x27, 0x60, 0xab, 0x48, 0xb6, 0x04, 0xc9, 0x23, 0xe5, 0xe5, 0xfd, 0x48, 0x5e, 0xc5,
	0xab, 0x71, 0x9a, 0x3f, 0x48, 0x50, 0x9e, 0xef, 0xe4, 0x32, 0xf3, 0xb8, 0xb4, 0xe1, 0x5b, 0x45,
	0x31, 0xbe, 0xca, 0xfb, 0xf7, 0xbb, 0xca, 0xc7, 0x21, 0xfc, 0xc8, 0xf4, 0x46, 0xcb, 0x89, 0x1c,
	0xcb, 0xb3, 0xa7, 0x72, 0x40, 0x82, 0x09, 0x35, 0xc9, 0xdb, 0x17, 0x5c, 0xbc, 0xbd, 0xbe, 0xf4,
	0xee, 0x30, 0x0e, 0xb1, 0x3d, 0x07, 0xbb, 0x76, 0xc3, 0x0b, 0xec, 0xa6, 0x4d, 0x5c, 0xa1, 0x85,
	0xcd, 0xc8, 0x84, 0x7d, 0x1a, 0x2e, 0xfc, 0xe9, 0x74, 0x24, 0x3e, 0x2e, 0x37, 0x84, 0xdb, 0x2f,
	0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x83, 0x65, 0xec, 0xfd, 0x9a, 0x12, 0x00, 0x00,
}
