// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/orgpolicy/v2/constraint.proto

package orgpolicypb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the default behavior in the absence of any policy for the
// constraint. This must not be `CONSTRAINT_DEFAULT_UNSPECIFIED`.
//
// Immutable after creation.
type Constraint_ConstraintDefault int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	Constraint_CONSTRAINT_DEFAULT_UNSPECIFIED Constraint_ConstraintDefault = 0
	// Indicate that all values are allowed for list constraints.
	// Indicate that enforcement is off for boolean constraints.
	Constraint_ALLOW Constraint_ConstraintDefault = 1
	// Indicate that all values are denied for list constraints.
	// Indicate that enforcement is on for boolean constraints.
	Constraint_DENY Constraint_ConstraintDefault = 2
)

// Enum value maps for Constraint_ConstraintDefault.
var (
	Constraint_ConstraintDefault_name = map[int32]string{
		0: "CONSTRAINT_DEFAULT_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	Constraint_ConstraintDefault_value = map[string]int32{
		"CONSTRAINT_DEFAULT_UNSPECIFIED": 0,
		"ALLOW":                          1,
		"DENY":                           2,
	}
)

func (x Constraint_ConstraintDefault) Enum() *Constraint_ConstraintDefault {
	p := new(Constraint_ConstraintDefault)
	*p = x
	return p
}

func (x Constraint_ConstraintDefault) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Constraint_ConstraintDefault) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[0].Descriptor()
}

func (Constraint_ConstraintDefault) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[0]
}

func (x Constraint_ConstraintDefault) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Constraint_ConstraintDefault.Descriptor instead.
func (Constraint_ConstraintDefault) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 0}
}

// The operation for which this constraint will be applied. To apply this
// constraint only when creating new resources, the `method_types` should be
// `CREATE` only. To apply this constraint when creating or deleting
// resources, the `method_types` should be `CREATE` and `DELETE`.
//
// `UPDATE`-only custom constraints are not supported. Use `CREATE` or
// `CREATE, UPDATE`.
type Constraint_CustomConstraintDefinition_MethodType int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	Constraint_CustomConstraintDefinition_METHOD_TYPE_UNSPECIFIED Constraint_CustomConstraintDefinition_MethodType = 0
	// Constraint applied when creating the resource.
	Constraint_CustomConstraintDefinition_CREATE Constraint_CustomConstraintDefinition_MethodType = 1
	// Constraint applied when updating the resource.
	Constraint_CustomConstraintDefinition_UPDATE Constraint_CustomConstraintDefinition_MethodType = 2
	// Constraint applied when deleting the resource.
	// Not currently supported.
	Constraint_CustomConstraintDefinition_DELETE Constraint_CustomConstraintDefinition_MethodType = 3
	// Constraint applied when removing an IAM grant.
	Constraint_CustomConstraintDefinition_REMOVE_GRANT Constraint_CustomConstraintDefinition_MethodType = 4
	// Constraint applied when enforcing forced tagging.
	Constraint_CustomConstraintDefinition_GOVERN_TAGS Constraint_CustomConstraintDefinition_MethodType = 5
)

// Enum value maps for Constraint_CustomConstraintDefinition_MethodType.
var (
	Constraint_CustomConstraintDefinition_MethodType_name = map[int32]string{
		0: "METHOD_TYPE_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
		4: "REMOVE_GRANT",
		5: "GOVERN_TAGS",
	}
	Constraint_CustomConstraintDefinition_MethodType_value = map[string]int32{
		"METHOD_TYPE_UNSPECIFIED": 0,
		"CREATE":                  1,
		"UPDATE":                  2,
		"DELETE":                  3,
		"REMOVE_GRANT":            4,
		"GOVERN_TAGS":             5,
	}
)

func (x Constraint_CustomConstraintDefinition_MethodType) Enum() *Constraint_CustomConstraintDefinition_MethodType {
	p := new(Constraint_CustomConstraintDefinition_MethodType)
	*p = x
	return p
}

func (x Constraint_CustomConstraintDefinition_MethodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Constraint_CustomConstraintDefinition_MethodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[1].Descriptor()
}

func (Constraint_CustomConstraintDefinition_MethodType) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[1]
}

func (x Constraint_CustomConstraintDefinition_MethodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition_MethodType.Descriptor instead.
func (Constraint_CustomConstraintDefinition_MethodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Allow or deny type.
type Constraint_CustomConstraintDefinition_ActionType int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	Constraint_CustomConstraintDefinition_ACTION_TYPE_UNSPECIFIED Constraint_CustomConstraintDefinition_ActionType = 0
	// Allowed action type.
	Constraint_CustomConstraintDefinition_ALLOW Constraint_CustomConstraintDefinition_ActionType = 1
	// Deny action type.
	Constraint_CustomConstraintDefinition_DENY Constraint_CustomConstraintDefinition_ActionType = 2
)

// Enum value maps for Constraint_CustomConstraintDefinition_ActionType.
var (
	Constraint_CustomConstraintDefinition_ActionType_name = map[int32]string{
		0: "ACTION_TYPE_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	Constraint_CustomConstraintDefinition_ActionType_value = map[string]int32{
		"ACTION_TYPE_UNSPECIFIED": 0,
		"ALLOW":                   1,
		"DENY":                    2,
	}
)

func (x Constraint_CustomConstraintDefinition_ActionType) Enum() *Constraint_CustomConstraintDefinition_ActionType {
	p := new(Constraint_CustomConstraintDefinition_ActionType)
	*p = x
	return p
}

func (x Constraint_CustomConstraintDefinition_ActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Constraint_CustomConstraintDefinition_ActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[2].Descriptor()
}

func (Constraint_CustomConstraintDefinition_ActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[2]
}

func (x Constraint_CustomConstraintDefinition_ActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition_ActionType.Descriptor instead.
func (Constraint_CustomConstraintDefinition_ActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1, 1}
}

// All valid types of parameter.
type Constraint_CustomConstraintDefinition_Parameter_Type int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	Constraint_CustomConstraintDefinition_Parameter_TYPE_UNSPECIFIED Constraint_CustomConstraintDefinition_Parameter_Type = 0
	// List parameter type.
	Constraint_CustomConstraintDefinition_Parameter_LIST Constraint_CustomConstraintDefinition_Parameter_Type = 1
	// String parameter type.
	Constraint_CustomConstraintDefinition_Parameter_STRING Constraint_CustomConstraintDefinition_Parameter_Type = 2
	// Boolean parameter type.
	Constraint_CustomConstraintDefinition_Parameter_BOOLEAN Constraint_CustomConstraintDefinition_Parameter_Type = 3
)

// Enum value maps for Constraint_CustomConstraintDefinition_Parameter_Type.
var (
	Constraint_CustomConstraintDefinition_Parameter_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LIST",
		2: "STRING",
		3: "BOOLEAN",
	}
	Constraint_CustomConstraintDefinition_Parameter_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LIST":             1,
		"STRING":           2,
		"BOOLEAN":          3,
	}
)

func (x Constraint_CustomConstraintDefinition_Parameter_Type) Enum() *Constraint_CustomConstraintDefinition_Parameter_Type {
	p := new(Constraint_CustomConstraintDefinition_Parameter_Type)
	*p = x
	return p
}

func (x Constraint_CustomConstraintDefinition_Parameter_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Constraint_CustomConstraintDefinition_Parameter_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[3].Descriptor()
}

func (Constraint_CustomConstraintDefinition_Parameter_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[3]
}

func (x Constraint_CustomConstraintDefinition_Parameter_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition_Parameter_Type.Descriptor instead.
func (Constraint_CustomConstraintDefinition_Parameter_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

// The operation for which this constraint will be applied. To apply this
// constraint only when creating new resources, the `method_types` should be
// `CREATE` only. To apply this constraint when creating or deleting
// resources, the `method_types` should be `CREATE` and `DELETE`.
//
// `UPDATE` only custom constraints are not supported. Use `CREATE` or
// `CREATE, UPDATE`.
type CustomConstraint_MethodType int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	CustomConstraint_METHOD_TYPE_UNSPECIFIED CustomConstraint_MethodType = 0
	// Constraint applied when creating the resource.
	CustomConstraint_CREATE CustomConstraint_MethodType = 1
	// Constraint applied when updating the resource.
	CustomConstraint_UPDATE CustomConstraint_MethodType = 2
	// Constraint applied when deleting the resource.
	// Not currently supported.
	CustomConstraint_DELETE CustomConstraint_MethodType = 3
	// Constraint applied when removing an IAM grant.
	CustomConstraint_REMOVE_GRANT CustomConstraint_MethodType = 4
	// Constraint applied when enforcing forced tagging.
	CustomConstraint_GOVERN_TAGS CustomConstraint_MethodType = 5
)

// Enum value maps for CustomConstraint_MethodType.
var (
	CustomConstraint_MethodType_name = map[int32]string{
		0: "METHOD_TYPE_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
		4: "REMOVE_GRANT",
		5: "GOVERN_TAGS",
	}
	CustomConstraint_MethodType_value = map[string]int32{
		"METHOD_TYPE_UNSPECIFIED": 0,
		"CREATE":                  1,
		"UPDATE":                  2,
		"DELETE":                  3,
		"REMOVE_GRANT":            4,
		"GOVERN_TAGS":             5,
	}
)

func (x CustomConstraint_MethodType) Enum() *CustomConstraint_MethodType {
	p := new(CustomConstraint_MethodType)
	*p = x
	return p
}

func (x CustomConstraint_MethodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomConstraint_MethodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[4].Descriptor()
}

func (CustomConstraint_MethodType) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[4]
}

func (x CustomConstraint_MethodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomConstraint_MethodType.Descriptor instead.
func (CustomConstraint_MethodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{1, 0}
}

// Allow or deny type.
type CustomConstraint_ActionType int32

const (
	// This is only used for distinguishing unset values and should never be
	// used. Results in an error.
	CustomConstraint_ACTION_TYPE_UNSPECIFIED CustomConstraint_ActionType = 0
	// Allowed action type.
	CustomConstraint_ALLOW CustomConstraint_ActionType = 1
	// Deny action type.
	CustomConstraint_DENY CustomConstraint_ActionType = 2
)

// Enum value maps for CustomConstraint_ActionType.
var (
	CustomConstraint_ActionType_name = map[int32]string{
		0: "ACTION_TYPE_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	CustomConstraint_ActionType_value = map[string]int32{
		"ACTION_TYPE_UNSPECIFIED": 0,
		"ALLOW":                   1,
		"DENY":                    2,
	}
)

func (x CustomConstraint_ActionType) Enum() *CustomConstraint_ActionType {
	p := new(CustomConstraint_ActionType)
	*p = x
	return p
}

func (x CustomConstraint_ActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomConstraint_ActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[5].Descriptor()
}

func (CustomConstraint_ActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes[5]
}

func (x CustomConstraint_ActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomConstraint_ActionType.Descriptor instead.
func (CustomConstraint_ActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{1, 1}
}

// A constraint describes a way to restrict resource's configuration. For
// example, you could enforce a constraint that controls which Google Cloud
// services can be activated across an organization, or whether a Compute Engine
// instance can have serial port connections established. Constraints can be
// configured by the organization policy administrator to fit the needs of the
// organization by setting a policy that includes constraints at different
// locations in the organization's resource hierarchy. Policies are inherited
// down the resource hierarchy from higher levels, but can also be overridden.
// For details about the inheritance rules, see
// [`Policy`][google.cloud.orgpolicy.v2.Policy].
//
// Constraints have a default behavior determined by the `constraint_default`
// field, which is the enforcement behavior that is used in the absence of a
// policy being defined or inherited for the resource in question.
type Constraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the constraint. Must be in one of
	// the following forms:
	//
	// * `projects/{project_number}/constraints/{constraint_name}`
	// * `folders/{folder_id}/constraints/{constraint_name}`
	// * `organizations/{organization_id}/constraints/{constraint_name}`
	//
	// For example, "/projects/123/constraints/compute.disableSerialPortAccess".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name.
	//
	// Mutable.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Detailed description of what this constraint controls as well as how and
	// where it is enforced.
	//
	// Mutable.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The evaluation behavior of this constraint in the absence of a policy.
	ConstraintDefault Constraint_ConstraintDefault `protobuf:"varint,4,opt,name=constraint_default,json=constraintDefault,proto3,enum=google.cloud.orgpolicy.v2.Constraint_ConstraintDefault" json:"constraint_default,omitempty"`
	// The type of restrictions for this `Constraint`.
	//
	// Immutable after creation.
	//
	// Types that are assignable to ConstraintType:
	//
	//	*Constraint_ListConstraint_
	//	*Constraint_BooleanConstraint_
	ConstraintType isConstraint_ConstraintType `protobuf_oneof:"constraint_type"`
	// Shows if dry run is supported for this constraint or not.
	SupportsDryRun bool `protobuf:"varint,7,opt,name=supports_dry_run,json=supportsDryRun,proto3" json:"supports_dry_run,omitempty"`
	// Managed constraint and canned constraint sometimes can have
	// equivalents. This field is used to store the equivalent constraint name.
	EquivalentConstraint string `protobuf:"bytes,8,opt,name=equivalent_constraint,json=equivalentConstraint,proto3" json:"equivalent_constraint,omitempty"`
	// Shows if simulation is supported for this constraint or not.
	SupportsSimulation bool `protobuf:"varint,9,opt,name=supports_simulation,json=supportsSimulation,proto3" json:"supports_simulation,omitempty"`
}

func (x *Constraint) Reset() {
	*x = Constraint{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint) ProtoMessage() {}

func (x *Constraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint.ProtoReflect.Descriptor instead.
func (*Constraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0}
}

func (x *Constraint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Constraint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Constraint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Constraint) GetConstraintDefault() Constraint_ConstraintDefault {
	if x != nil {
		return x.ConstraintDefault
	}
	return Constraint_CONSTRAINT_DEFAULT_UNSPECIFIED
}

func (m *Constraint) GetConstraintType() isConstraint_ConstraintType {
	if m != nil {
		return m.ConstraintType
	}
	return nil
}

func (x *Constraint) GetListConstraint() *Constraint_ListConstraint {
	if x, ok := x.GetConstraintType().(*Constraint_ListConstraint_); ok {
		return x.ListConstraint
	}
	return nil
}

func (x *Constraint) GetBooleanConstraint() *Constraint_BooleanConstraint {
	if x, ok := x.GetConstraintType().(*Constraint_BooleanConstraint_); ok {
		return x.BooleanConstraint
	}
	return nil
}

func (x *Constraint) GetSupportsDryRun() bool {
	if x != nil {
		return x.SupportsDryRun
	}
	return false
}

func (x *Constraint) GetEquivalentConstraint() string {
	if x != nil {
		return x.EquivalentConstraint
	}
	return ""
}

func (x *Constraint) GetSupportsSimulation() bool {
	if x != nil {
		return x.SupportsSimulation
	}
	return false
}

type isConstraint_ConstraintType interface {
	isConstraint_ConstraintType()
}

type Constraint_ListConstraint_ struct {
	// Defines this constraint as being a list constraint.
	ListConstraint *Constraint_ListConstraint `protobuf:"bytes,5,opt,name=list_constraint,json=listConstraint,proto3,oneof"`
}

type Constraint_BooleanConstraint_ struct {
	// Defines this constraint as being a boolean constraint.
	BooleanConstraint *Constraint_BooleanConstraint `protobuf:"bytes,6,opt,name=boolean_constraint,json=booleanConstraint,proto3,oneof"`
}

func (*Constraint_ListConstraint_) isConstraint_ConstraintType() {}

func (*Constraint_BooleanConstraint_) isConstraint_ConstraintType() {}

// A custom constraint defined by customers which can *only* be applied to the
// given resource types and organization.
//
// By creating a custom constraint, customers can apply policies of this
// custom constraint. *Creating a custom constraint itself does NOT apply any
// policy enforcement*.
type CustomConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Name of the constraint. This is unique within the organization.
	// Format of the name should be
	//
	// * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	//
	// Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
	//
	// The max length is 70 characters and the minimum length is 1. Note that the
	// prefix `organizations/{organization_id}/customConstraints/` is not counted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The resource instance type on which this policy applies. Format
	// will be of the form : `<service name>/<type>` Example:
	//
	//   - `compute.googleapis.com/Instance`.
	ResourceTypes []string `protobuf:"bytes,2,rep,name=resource_types,json=resourceTypes,proto3" json:"resource_types,omitempty"`
	// All the operations being applied for this constraint.
	MethodTypes []CustomConstraint_MethodType `protobuf:"varint,3,rep,packed,name=method_types,json=methodTypes,proto3,enum=google.cloud.orgpolicy.v2.CustomConstraint_MethodType" json:"method_types,omitempty"`
	// A Common Expression Language (CEL) condition which is used in the
	// evaluation of the constraint. For example:
	// `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
	// `resource.management.auto_upgrade == true`
	//
	// The max length of the condition is 1000 characters.
	Condition string `protobuf:"bytes,4,opt,name=condition,proto3" json:"condition,omitempty"`
	// Allow or deny type.
	ActionType CustomConstraint_ActionType `protobuf:"varint,5,opt,name=action_type,json=actionType,proto3,enum=google.cloud.orgpolicy.v2.CustomConstraint_ActionType" json:"action_type,omitempty"`
	// One line display name for the UI.
	// The max length of the display_name is 200 characters.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Detailed information about this custom policy constraint.
	// The max length of the description is 2000 characters.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The last time this custom constraint was updated. This
	// represents the last time that the `CreateCustomConstraint` or
	// `UpdateCustomConstraint` methods were called.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CustomConstraint) Reset() {
	*x = CustomConstraint{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomConstraint) ProtoMessage() {}

func (x *CustomConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomConstraint.ProtoReflect.Descriptor instead.
func (*CustomConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{1}
}

func (x *CustomConstraint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomConstraint) GetResourceTypes() []string {
	if x != nil {
		return x.ResourceTypes
	}
	return nil
}

func (x *CustomConstraint) GetMethodTypes() []CustomConstraint_MethodType {
	if x != nil {
		return x.MethodTypes
	}
	return nil
}

func (x *CustomConstraint) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *CustomConstraint) GetActionType() CustomConstraint_ActionType {
	if x != nil {
		return x.ActionType
	}
	return CustomConstraint_ACTION_TYPE_UNSPECIFIED
}

func (x *CustomConstraint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CustomConstraint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CustomConstraint) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A constraint type that allows or disallows a list of string values, which
// are configured in the
// [`PolicyRule`][google.cloud.orgpolicy.v2.PolicySpec.PolicyRule].
type Constraint_ListConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether values grouped into categories can be used in
	// `Policy.allowed_values` and `Policy.denied_values`. For example,
	// `"in:Python"` would match any value in the 'Python' group.
	SupportsIn bool `protobuf:"varint,1,opt,name=supports_in,json=supportsIn,proto3" json:"supports_in,omitempty"`
	// Indicates whether subtrees of the Resource Manager resource hierarchy
	// can be used in `Policy.allowed_values` and `Policy.denied_values`. For
	// example, `"under:folders/123"` would match any resource under the
	// 'folders/123' folder.
	SupportsUnder bool `protobuf:"varint,2,opt,name=supports_under,json=supportsUnder,proto3" json:"supports_under,omitempty"`
}

func (x *Constraint_ListConstraint) Reset() {
	*x = Constraint_ListConstraint{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint_ListConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint_ListConstraint) ProtoMessage() {}

func (x *Constraint_ListConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint_ListConstraint.ProtoReflect.Descriptor instead.
func (*Constraint_ListConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Constraint_ListConstraint) GetSupportsIn() bool {
	if x != nil {
		return x.SupportsIn
	}
	return false
}

func (x *Constraint_ListConstraint) GetSupportsUnder() bool {
	if x != nil {
		return x.SupportsUnder
	}
	return false
}

// Custom constraint definition. Defines this as a managed constraint.
type Constraint_CustomConstraintDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource instance type on which this policy applies. Format will be
	// of the form : `<service name>/<type>` Example:
	//
	//   - `compute.googleapis.com/Instance`.
	ResourceTypes []string `protobuf:"bytes,1,rep,name=resource_types,json=resourceTypes,proto3" json:"resource_types,omitempty"`
	// All the operations being applied for this constraint.
	MethodTypes []Constraint_CustomConstraintDefinition_MethodType `protobuf:"varint,2,rep,packed,name=method_types,json=methodTypes,proto3,enum=google.cloud.orgpolicy.v2.Constraint_CustomConstraintDefinition_MethodType" json:"method_types,omitempty"`
	// Org policy condition/expression. For example:
	// `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
	// `resource.management.auto_upgrade == true`
	//
	// The max length of the condition is 1000 characters.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Allow or deny type.
	ActionType Constraint_CustomConstraintDefinition_ActionType `protobuf:"varint,4,opt,name=action_type,json=actionType,proto3,enum=google.cloud.orgpolicy.v2.Constraint_CustomConstraintDefinition_ActionType" json:"action_type,omitempty"`
	// Stores the structure of
	// [`Parameters`][google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter]
	// used by the constraint condition. The key of `map` represents the name of
	// the parameter.
	Parameters map[string]*Constraint_CustomConstraintDefinition_Parameter `protobuf:"bytes,5,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Constraint_CustomConstraintDefinition) Reset() {
	*x = Constraint_CustomConstraintDefinition{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint_CustomConstraintDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint_CustomConstraintDefinition) ProtoMessage() {}

func (x *Constraint_CustomConstraintDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition.ProtoReflect.Descriptor instead.
func (*Constraint_CustomConstraintDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Constraint_CustomConstraintDefinition) GetResourceTypes() []string {
	if x != nil {
		return x.ResourceTypes
	}
	return nil
}

func (x *Constraint_CustomConstraintDefinition) GetMethodTypes() []Constraint_CustomConstraintDefinition_MethodType {
	if x != nil {
		return x.MethodTypes
	}
	return nil
}

func (x *Constraint_CustomConstraintDefinition) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Constraint_CustomConstraintDefinition) GetActionType() Constraint_CustomConstraintDefinition_ActionType {
	if x != nil {
		return x.ActionType
	}
	return Constraint_CustomConstraintDefinition_ACTION_TYPE_UNSPECIFIED
}

func (x *Constraint_CustomConstraintDefinition) GetParameters() map[string]*Constraint_CustomConstraintDefinition_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// A constraint type is enforced or not enforced, which is configured in the
// [`PolicyRule`][google.cloud.orgpolicy.v2.PolicySpec.PolicyRule].
//
// If `customConstraintDefinition` is defined, this constraint is a managed
// constraint.
type Constraint_BooleanConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom constraint definition. Defines this as a managed constraint.
	CustomConstraintDefinition *Constraint_CustomConstraintDefinition `protobuf:"bytes,1,opt,name=custom_constraint_definition,json=customConstraintDefinition,proto3" json:"custom_constraint_definition,omitempty"`
}

func (x *Constraint_BooleanConstraint) Reset() {
	*x = Constraint_BooleanConstraint{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint_BooleanConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint_BooleanConstraint) ProtoMessage() {}

func (x *Constraint_BooleanConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint_BooleanConstraint.ProtoReflect.Descriptor instead.
func (*Constraint_BooleanConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Constraint_BooleanConstraint) GetCustomConstraintDefinition() *Constraint_CustomConstraintDefinition {
	if x != nil {
		return x.CustomConstraintDefinition
	}
	return nil
}

// Defines a parameter structure.
type Constraint_CustomConstraintDefinition_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the parameter.
	Type Constraint_CustomConstraintDefinition_Parameter_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.orgpolicy.v2.Constraint_CustomConstraintDefinition_Parameter_Type" json:"type,omitempty"`
	// Sets the value of the parameter in an assignment if no value is given.
	DefaultValue *structpb.Value `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Provides a CEL expression to specify the acceptable parameter values
	// during assignment.
	// For example, parameterName in ("parameterValue1", "parameterValue2")
	ValidValuesExpr string `protobuf:"bytes,3,opt,name=valid_values_expr,json=validValuesExpr,proto3" json:"valid_values_expr,omitempty"`
	// Defines subproperties primarily used by the UI to display user-friendly
	// information.
	Metadata *Constraint_CustomConstraintDefinition_Parameter_Metadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Determines the parameter's value structure.
	// For example, `LIST<STRING>` can be specified by defining `type: LIST`,
	// and `item: STRING`.
	Item Constraint_CustomConstraintDefinition_Parameter_Type `protobuf:"varint,5,opt,name=item,proto3,enum=google.cloud.orgpolicy.v2.Constraint_CustomConstraintDefinition_Parameter_Type" json:"item,omitempty"`
}

func (x *Constraint_CustomConstraintDefinition_Parameter) Reset() {
	*x = Constraint_CustomConstraintDefinition_Parameter{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint_CustomConstraintDefinition_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint_CustomConstraintDefinition_Parameter) ProtoMessage() {}

func (x *Constraint_CustomConstraintDefinition_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition_Parameter.ProtoReflect.Descriptor instead.
func (*Constraint_CustomConstraintDefinition_Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Constraint_CustomConstraintDefinition_Parameter) GetType() Constraint_CustomConstraintDefinition_Parameter_Type {
	if x != nil {
		return x.Type
	}
	return Constraint_CustomConstraintDefinition_Parameter_TYPE_UNSPECIFIED
}

func (x *Constraint_CustomConstraintDefinition_Parameter) GetDefaultValue() *structpb.Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

func (x *Constraint_CustomConstraintDefinition_Parameter) GetValidValuesExpr() string {
	if x != nil {
		return x.ValidValuesExpr
	}
	return ""
}

func (x *Constraint_CustomConstraintDefinition_Parameter) GetMetadata() *Constraint_CustomConstraintDefinition_Parameter_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Constraint_CustomConstraintDefinition_Parameter) GetItem() Constraint_CustomConstraintDefinition_Parameter_Type {
	if x != nil {
		return x.Item
	}
	return Constraint_CustomConstraintDefinition_Parameter_TYPE_UNSPECIFIED
}

// Defines Metadata structure.
type Constraint_CustomConstraintDefinition_Parameter_Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detailed description of what this `parameter` is and use of it.
	// Mutable.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Constraint_CustomConstraintDefinition_Parameter_Metadata) Reset() {
	*x = Constraint_CustomConstraintDefinition_Parameter_Metadata{}
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Constraint_CustomConstraintDefinition_Parameter_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint_CustomConstraintDefinition_Parameter_Metadata) ProtoMessage() {}

func (x *Constraint_CustomConstraintDefinition_Parameter_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint_CustomConstraintDefinition_Parameter_Metadata.ProtoReflect.Descriptor instead.
func (*Constraint_CustomConstraintDefinition_Parameter_Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

func (x *Constraint_CustomConstraintDefinition_Parameter_Metadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

var File_google_cloud_orgpolicy_v2_constraint_proto protoreflect.FileDescriptor

var file_google_cloud_orgpolicy_v2_constraint_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd1, 0x12, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x66, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x5f, 0x0a, 0x0f, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x68, 0x0a, 0x12, 0x62, 0x6f, 0x6f, 0x6c,
	0x65, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x65, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x11, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x64,
	0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x44, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12, 0x33, 0x0a, 0x15,
	0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x71, 0x75,
	0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x58, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x5f, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x49, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x1a, 0x90, 0x0a, 0x0a,
	0x1a, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x6e, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6c, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x70,
	0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x1a, 0x9e, 0x04, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x63,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x2a, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x5f, 0x65, 0x78, 0x70, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x78, 0x70, 0x72, 0x12, 0x6f, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x63, 0x0a,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x69, 0x74,
	0x65, 0x6d, 0x1a, 0x2c, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x3f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10,
	0x03, 0x1a, 0x89, 0x01, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x60, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x70, 0x0a,
	0x0a, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4d,
	0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c,
	0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0f,
	0x0a, 0x0b, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x5f, 0x54, 0x41, 0x47, 0x53, 0x10, 0x05, 0x22,
	0x3e, 0x0a, 0x0a, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c,
	0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x02, 0x1a,
	0x98, 0x01, 0x0a, 0x11, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x0a, 0x11, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12,
	0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x44, 0x45,
	0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x02, 0x3a, 0xb8, 0x01, 0xea, 0x41, 0xb4, 0x01, 0x0a,
	0x23, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x7d, 0x12, 0x29, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0x35, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x7d, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xd6, 0x05, 0x0a, 0x10, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x59, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0b, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x0a, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x48, 0x4f,
	0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x4d, 0x4f,
	0x56, 0x45, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x4f,
	0x56, 0x45, 0x52, 0x4e, 0x5f, 0x54, 0x41, 0x47, 0x53, 0x10, 0x05, 0x22, 0x3e, 0x0a, 0x0a, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x02, 0x3a, 0x72, 0xea, 0x41, 0x6f,
	0x0a, 0x29, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x42, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x7d, 0x42,
	0xc6, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76,
	0x32, 0x42, 0x0f, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x70, 0x62, 0x3b, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x70,
	0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x19,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x72, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x72, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_orgpolicy_v2_constraint_proto_rawDescOnce sync.Once
	file_google_cloud_orgpolicy_v2_constraint_proto_rawDescData = file_google_cloud_orgpolicy_v2_constraint_proto_rawDesc
)

func file_google_cloud_orgpolicy_v2_constraint_proto_rawDescGZIP() []byte {
	file_google_cloud_orgpolicy_v2_constraint_proto_rawDescOnce.Do(func() {
		file_google_cloud_orgpolicy_v2_constraint_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_orgpolicy_v2_constraint_proto_rawDescData)
	})
	return file_google_cloud_orgpolicy_v2_constraint_proto_rawDescData
}

var file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_orgpolicy_v2_constraint_proto_goTypes = []any{
	(Constraint_ConstraintDefault)(0),                         // 0: google.cloud.orgpolicy.v2.Constraint.ConstraintDefault
	(Constraint_CustomConstraintDefinition_MethodType)(0),     // 1: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.MethodType
	(Constraint_CustomConstraintDefinition_ActionType)(0),     // 2: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.ActionType
	(Constraint_CustomConstraintDefinition_Parameter_Type)(0), // 3: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.Type
	(CustomConstraint_MethodType)(0),                          // 4: google.cloud.orgpolicy.v2.CustomConstraint.MethodType
	(CustomConstraint_ActionType)(0),                          // 5: google.cloud.orgpolicy.v2.CustomConstraint.ActionType
	(*Constraint)(nil),                                        // 6: google.cloud.orgpolicy.v2.Constraint
	(*CustomConstraint)(nil),                                  // 7: google.cloud.orgpolicy.v2.CustomConstraint
	(*Constraint_ListConstraint)(nil),                         // 8: google.cloud.orgpolicy.v2.Constraint.ListConstraint
	(*Constraint_CustomConstraintDefinition)(nil),             // 9: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition
	(*Constraint_BooleanConstraint)(nil),                      // 10: google.cloud.orgpolicy.v2.Constraint.BooleanConstraint
	(*Constraint_CustomConstraintDefinition_Parameter)(nil),   // 11: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter
	nil, // 12: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.ParametersEntry
	(*Constraint_CustomConstraintDefinition_Parameter_Metadata)(nil), // 13: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.Metadata
	(*timestamppb.Timestamp)(nil),                                    // 14: google.protobuf.Timestamp
	(*structpb.Value)(nil),                                           // 15: google.protobuf.Value
}
var file_google_cloud_orgpolicy_v2_constraint_proto_depIdxs = []int32{
	0,  // 0: google.cloud.orgpolicy.v2.Constraint.constraint_default:type_name -> google.cloud.orgpolicy.v2.Constraint.ConstraintDefault
	8,  // 1: google.cloud.orgpolicy.v2.Constraint.list_constraint:type_name -> google.cloud.orgpolicy.v2.Constraint.ListConstraint
	10, // 2: google.cloud.orgpolicy.v2.Constraint.boolean_constraint:type_name -> google.cloud.orgpolicy.v2.Constraint.BooleanConstraint
	4,  // 3: google.cloud.orgpolicy.v2.CustomConstraint.method_types:type_name -> google.cloud.orgpolicy.v2.CustomConstraint.MethodType
	5,  // 4: google.cloud.orgpolicy.v2.CustomConstraint.action_type:type_name -> google.cloud.orgpolicy.v2.CustomConstraint.ActionType
	14, // 5: google.cloud.orgpolicy.v2.CustomConstraint.update_time:type_name -> google.protobuf.Timestamp
	1,  // 6: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.method_types:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.MethodType
	2,  // 7: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.action_type:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.ActionType
	12, // 8: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.parameters:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.ParametersEntry
	9,  // 9: google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.custom_constraint_definition:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition
	3,  // 10: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.type:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.Type
	15, // 11: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.default_value:type_name -> google.protobuf.Value
	13, // 12: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.metadata:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.Metadata
	3,  // 13: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.item:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter.Type
	11, // 14: google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.ParametersEntry.value:type_name -> google.cloud.orgpolicy.v2.Constraint.CustomConstraintDefinition.Parameter
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_orgpolicy_v2_constraint_proto_init() }
func file_google_cloud_orgpolicy_v2_constraint_proto_init() {
	if File_google_cloud_orgpolicy_v2_constraint_proto != nil {
		return
	}
	file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes[0].OneofWrappers = []any{
		(*Constraint_ListConstraint_)(nil),
		(*Constraint_BooleanConstraint_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_orgpolicy_v2_constraint_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_orgpolicy_v2_constraint_proto_goTypes,
		DependencyIndexes: file_google_cloud_orgpolicy_v2_constraint_proto_depIdxs,
		EnumInfos:         file_google_cloud_orgpolicy_v2_constraint_proto_enumTypes,
		MessageInfos:      file_google_cloud_orgpolicy_v2_constraint_proto_msgTypes,
	}.Build()
	File_google_cloud_orgpolicy_v2_constraint_proto = out.File
	file_google_cloud_orgpolicy_v2_constraint_proto_rawDesc = nil
	file_google_cloud_orgpolicy_v2_constraint_proto_goTypes = nil
	file_google_cloud_orgpolicy_v2_constraint_proto_depIdxs = nil
}
