// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/automl/v1beta1/data_stats.proto

package automlpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The data statistics of a series of values that share the same DataType.
type DataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data statistics specific to a DataType.
	//
	// Types that are assignable to Stats:
	//
	//	*DataStats_Float64Stats
	//	*DataStats_StringStats
	//	*DataStats_TimestampStats
	//	*DataStats_ArrayStats
	//	*DataStats_StructStats
	//	*DataStats_CategoryStats
	Stats isDataStats_Stats `protobuf_oneof:"stats"`
	// The number of distinct values.
	DistinctValueCount int64 `protobuf:"varint,1,opt,name=distinct_value_count,json=distinctValueCount,proto3" json:"distinct_value_count,omitempty"`
	// The number of values that are null.
	NullValueCount int64 `protobuf:"varint,2,opt,name=null_value_count,json=nullValueCount,proto3" json:"null_value_count,omitempty"`
	// The number of values that are valid.
	ValidValueCount int64 `protobuf:"varint,9,opt,name=valid_value_count,json=validValueCount,proto3" json:"valid_value_count,omitempty"`
}

func (x *DataStats) Reset() {
	*x = DataStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStats) ProtoMessage() {}

func (x *DataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStats.ProtoReflect.Descriptor instead.
func (*DataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{0}
}

func (m *DataStats) GetStats() isDataStats_Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (x *DataStats) GetFloat64Stats() *Float64Stats {
	if x, ok := x.GetStats().(*DataStats_Float64Stats); ok {
		return x.Float64Stats
	}
	return nil
}

func (x *DataStats) GetStringStats() *StringStats {
	if x, ok := x.GetStats().(*DataStats_StringStats); ok {
		return x.StringStats
	}
	return nil
}

func (x *DataStats) GetTimestampStats() *TimestampStats {
	if x, ok := x.GetStats().(*DataStats_TimestampStats); ok {
		return x.TimestampStats
	}
	return nil
}

func (x *DataStats) GetArrayStats() *ArrayStats {
	if x, ok := x.GetStats().(*DataStats_ArrayStats); ok {
		return x.ArrayStats
	}
	return nil
}

func (x *DataStats) GetStructStats() *StructStats {
	if x, ok := x.GetStats().(*DataStats_StructStats); ok {
		return x.StructStats
	}
	return nil
}

func (x *DataStats) GetCategoryStats() *CategoryStats {
	if x, ok := x.GetStats().(*DataStats_CategoryStats); ok {
		return x.CategoryStats
	}
	return nil
}

func (x *DataStats) GetDistinctValueCount() int64 {
	if x != nil {
		return x.DistinctValueCount
	}
	return 0
}

func (x *DataStats) GetNullValueCount() int64 {
	if x != nil {
		return x.NullValueCount
	}
	return 0
}

func (x *DataStats) GetValidValueCount() int64 {
	if x != nil {
		return x.ValidValueCount
	}
	return 0
}

type isDataStats_Stats interface {
	isDataStats_Stats()
}

type DataStats_Float64Stats struct {
	// The statistics for FLOAT64 DataType.
	Float64Stats *Float64Stats `protobuf:"bytes,3,opt,name=float64_stats,json=float64Stats,proto3,oneof"`
}

type DataStats_StringStats struct {
	// The statistics for STRING DataType.
	StringStats *StringStats `protobuf:"bytes,4,opt,name=string_stats,json=stringStats,proto3,oneof"`
}

type DataStats_TimestampStats struct {
	// The statistics for TIMESTAMP DataType.
	TimestampStats *TimestampStats `protobuf:"bytes,5,opt,name=timestamp_stats,json=timestampStats,proto3,oneof"`
}

type DataStats_ArrayStats struct {
	// The statistics for ARRAY DataType.
	ArrayStats *ArrayStats `protobuf:"bytes,6,opt,name=array_stats,json=arrayStats,proto3,oneof"`
}

type DataStats_StructStats struct {
	// The statistics for STRUCT DataType.
	StructStats *StructStats `protobuf:"bytes,7,opt,name=struct_stats,json=structStats,proto3,oneof"`
}

type DataStats_CategoryStats struct {
	// The statistics for CATEGORY DataType.
	CategoryStats *CategoryStats `protobuf:"bytes,8,opt,name=category_stats,json=categoryStats,proto3,oneof"`
}

func (*DataStats_Float64Stats) isDataStats_Stats() {}

func (*DataStats_StringStats) isDataStats_Stats() {}

func (*DataStats_TimestampStats) isDataStats_Stats() {}

func (*DataStats_ArrayStats) isDataStats_Stats() {}

func (*DataStats_StructStats) isDataStats_Stats() {}

func (*DataStats_CategoryStats) isDataStats_Stats() {}

// The data statistics of a series of FLOAT64 values.
type Float64Stats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mean of the series.
	Mean float64 `protobuf:"fixed64,1,opt,name=mean,proto3" json:"mean,omitempty"`
	// The standard deviation of the series.
	StandardDeviation float64 `protobuf:"fixed64,2,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Ordered from 0 to k k-quantile values of the data series of n values.
	// The value at index i is, approximately, the i*n/k-th smallest value in the
	// series; for i = 0 and i = k these are, respectively, the min and max
	// values.
	Quantiles []float64 `protobuf:"fixed64,3,rep,packed,name=quantiles,proto3" json:"quantiles,omitempty"`
	// Histogram buckets of the data series. Sorted by the min value of the
	// bucket, ascendingly, and the number of the buckets is dynamically
	// generated. The buckets are non-overlapping and completely cover whole
	// FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
	// the last one being `"Infinity"`.
	HistogramBuckets []*Float64Stats_HistogramBucket `protobuf:"bytes,4,rep,name=histogram_buckets,json=histogramBuckets,proto3" json:"histogram_buckets,omitempty"`
}

func (x *Float64Stats) Reset() {
	*x = Float64Stats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Float64Stats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Float64Stats) ProtoMessage() {}

func (x *Float64Stats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Float64Stats.ProtoReflect.Descriptor instead.
func (*Float64Stats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{1}
}

func (x *Float64Stats) GetMean() float64 {
	if x != nil {
		return x.Mean
	}
	return 0
}

func (x *Float64Stats) GetStandardDeviation() float64 {
	if x != nil {
		return x.StandardDeviation
	}
	return 0
}

func (x *Float64Stats) GetQuantiles() []float64 {
	if x != nil {
		return x.Quantiles
	}
	return nil
}

func (x *Float64Stats) GetHistogramBuckets() []*Float64Stats_HistogramBucket {
	if x != nil {
		return x.HistogramBuckets
	}
	return nil
}

// The data statistics of a series of STRING values.
type StringStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The statistics of the top 20 unigrams, ordered by
	// [count][google.cloud.automl.v1beta1.StringStats.UnigramStats.count].
	TopUnigramStats []*StringStats_UnigramStats `protobuf:"bytes,1,rep,name=top_unigram_stats,json=topUnigramStats,proto3" json:"top_unigram_stats,omitempty"`
}

func (x *StringStats) Reset() {
	*x = StringStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringStats) ProtoMessage() {}

func (x *StringStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringStats.ProtoReflect.Descriptor instead.
func (*StringStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{2}
}

func (x *StringStats) GetTopUnigramStats() []*StringStats_UnigramStats {
	if x != nil {
		return x.TopUnigramStats
	}
	return nil
}

// The data statistics of a series of TIMESTAMP values.
type TimestampStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The string key is the pre-defined granularity. Currently supported:
	// hour_of_day, day_of_week, month_of_year.
	// Granularities finer that the granularity of timestamp data are not
	// populated (e.g. if timestamps are at day granularity, then hour_of_day
	// is not populated).
	GranularStats map[string]*TimestampStats_GranularStats `protobuf:"bytes,1,rep,name=granular_stats,json=granularStats,proto3" json:"granular_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TimestampStats) Reset() {
	*x = TimestampStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimestampStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampStats) ProtoMessage() {}

func (x *TimestampStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampStats.ProtoReflect.Descriptor instead.
func (*TimestampStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{3}
}

func (x *TimestampStats) GetGranularStats() map[string]*TimestampStats_GranularStats {
	if x != nil {
		return x.GranularStats
	}
	return nil
}

// The data statistics of a series of ARRAY values.
type ArrayStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stats of all the values of all arrays, as if they were a single long
	// series of data. The type depends on the element type of the array.
	MemberStats *DataStats `protobuf:"bytes,2,opt,name=member_stats,json=memberStats,proto3" json:"member_stats,omitempty"`
}

func (x *ArrayStats) Reset() {
	*x = ArrayStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArrayStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayStats) ProtoMessage() {}

func (x *ArrayStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayStats.ProtoReflect.Descriptor instead.
func (*ArrayStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{4}
}

func (x *ArrayStats) GetMemberStats() *DataStats {
	if x != nil {
		return x.MemberStats
	}
	return nil
}

// The data statistics of a series of STRUCT values.
type StructStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map from a field name of the struct to data stats aggregated over series
	// of all data in that field across all the structs.
	FieldStats map[string]*DataStats `protobuf:"bytes,1,rep,name=field_stats,json=fieldStats,proto3" json:"field_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *StructStats) Reset() {
	*x = StructStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StructStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructStats) ProtoMessage() {}

func (x *StructStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructStats.ProtoReflect.Descriptor instead.
func (*StructStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{5}
}

func (x *StructStats) GetFieldStats() map[string]*DataStats {
	if x != nil {
		return x.FieldStats
	}
	return nil
}

// The data statistics of a series of CATEGORY values.
type CategoryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The statistics of the top 20 CATEGORY values, ordered by
	//
	// [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
	TopCategoryStats []*CategoryStats_SingleCategoryStats `protobuf:"bytes,1,rep,name=top_category_stats,json=topCategoryStats,proto3" json:"top_category_stats,omitempty"`
}

func (x *CategoryStats) Reset() {
	*x = CategoryStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CategoryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CategoryStats) ProtoMessage() {}

func (x *CategoryStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CategoryStats.ProtoReflect.Descriptor instead.
func (*CategoryStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{6}
}

func (x *CategoryStats) GetTopCategoryStats() []*CategoryStats_SingleCategoryStats {
	if x != nil {
		return x.TopCategoryStats
	}
	return nil
}

// A correlation statistics between two series of DataType values. The series
// may have differing DataType-s, but within a single series the DataType must
// be the same.
type CorrelationStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The correlation value using the Cramer's V measure.
	CramersV float64 `protobuf:"fixed64,1,opt,name=cramers_v,json=cramersV,proto3" json:"cramers_v,omitempty"`
}

func (x *CorrelationStats) Reset() {
	*x = CorrelationStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorrelationStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorrelationStats) ProtoMessage() {}

func (x *CorrelationStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorrelationStats.ProtoReflect.Descriptor instead.
func (*CorrelationStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{7}
}

func (x *CorrelationStats) GetCramersV() float64 {
	if x != nil {
		return x.CramersV
	}
	return 0
}

// A bucket of a histogram.
type Float64Stats_HistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum value of the bucket, inclusive.
	Min float64 `protobuf:"fixed64,1,opt,name=min,proto3" json:"min,omitempty"`
	// The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
	// which case it's inclusive.
	Max float64 `protobuf:"fixed64,2,opt,name=max,proto3" json:"max,omitempty"`
	// The number of data values that are in the bucket, i.e. are between
	// min and max values.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Float64Stats_HistogramBucket) Reset() {
	*x = Float64Stats_HistogramBucket{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Float64Stats_HistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Float64Stats_HistogramBucket) ProtoMessage() {}

func (x *Float64Stats_HistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Float64Stats_HistogramBucket.ProtoReflect.Descriptor instead.
func (*Float64Stats_HistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Float64Stats_HistogramBucket) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *Float64Stats_HistogramBucket) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

func (x *Float64Stats_HistogramBucket) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// The statistics of a unigram.
type StringStats_UnigramStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unigram.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of occurrences of this unigram in the series.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *StringStats_UnigramStats) Reset() {
	*x = StringStats_UnigramStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringStats_UnigramStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringStats_UnigramStats) ProtoMessage() {}

func (x *StringStats_UnigramStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringStats_UnigramStats.ProtoReflect.Descriptor instead.
func (*StringStats_UnigramStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{2, 0}
}

func (x *StringStats_UnigramStats) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *StringStats_UnigramStats) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Stats split by a defined in context granularity.
type TimestampStats_GranularStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A map from granularity key to example count for that key.
	// E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
	Buckets map[int32]int64 `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *TimestampStats_GranularStats) Reset() {
	*x = TimestampStats_GranularStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimestampStats_GranularStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampStats_GranularStats) ProtoMessage() {}

func (x *TimestampStats_GranularStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampStats_GranularStats.ProtoReflect.Descriptor instead.
func (*TimestampStats_GranularStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{3, 0}
}

func (x *TimestampStats_GranularStats) GetBuckets() map[int32]int64 {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// The statistics of a single CATEGORY value.
type CategoryStats_SingleCategoryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CATEGORY value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of occurrences of this value in the series.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *CategoryStats_SingleCategoryStats) Reset() {
	*x = CategoryStats_SingleCategoryStats{}
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CategoryStats_SingleCategoryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CategoryStats_SingleCategoryStats) ProtoMessage() {}

func (x *CategoryStats_SingleCategoryStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CategoryStats_SingleCategoryStats.ProtoReflect.Descriptor instead.
func (*CategoryStats_SingleCategoryStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP(), []int{6, 0}
}

func (x *CategoryStats_SingleCategoryStats) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *CategoryStats_SingleCategoryStats) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

var File_google_cloud_automl_v1beta1_data_stats_proto protoreflect.FileDescriptor

var file_google_cloud_automl_v1beta1_data_stats_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x22, 0x85, 0x05, 0x0a, 0x09,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x66, 0x6c, 0x6f,
	0x61, 0x74, 0x36, 0x34, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46,
	0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x66,
	0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x56, 0x0a, 0x0f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x4d,
	0x0a, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00,
	0x52, 0x0b, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x53, 0x0a,
	0x0e, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x12, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e,
	0x6e, 0x75, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a,
	0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x22, 0xa4, 0x02, 0x0a, 0x0c, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x6e, 0x74,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x01, 0x52, 0x09, 0x71, 0x75, 0x61, 0x6e,
	0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46,
	0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x10, 0x68, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x4b, 0x0a,
	0x0f, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d,
	0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x03, 0x6d, 0x61, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xac, 0x01, 0x0a, 0x0b, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x74, 0x6f,
	0x70, 0x5f, 0x75, 0x6e, 0x69, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e,
	0x55, 0x6e, 0x69, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0f, 0x74, 0x6f,
	0x70, 0x55, 0x6e, 0x69, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0x3a, 0x0a,
	0x0c, 0x55, 0x6e, 0x69, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa4, 0x03, 0x0a, 0x0e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x65, 0x0a, 0x0e,
	0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x1a, 0xad, 0x01, 0x0a, 0x0d, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x60, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x7b, 0x0a, 0x12, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x57, 0x0a, 0x0a, 0x41, 0x72, 0x72, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x49,
	0x0a, 0x0c, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0b, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0xcf, 0x01, 0x0a, 0x0b, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x0b, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x1a, 0x65, 0x0a, 0x0f, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc0, 0x01, 0x0a, 0x0d,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x6c, 0x0a,
	0x12, 0x74, 0x6f, 0x70, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x10, 0x74, 0x6f, 0x70, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0x41, 0x0a, 0x13, 0x53,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x2f,
	0x0a, 0x10, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x72, 0x61, 0x6d, 0x65, 0x72, 0x73, 0x5f, 0x76, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x63, 0x72, 0x61, 0x6d, 0x65, 0x72, 0x73, 0x56, 0x42,
	0x9b, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x70, 0x62, 0x3b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70, 0x62, 0xca, 0x02,
	0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x6c, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x4c, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_automl_v1beta1_data_stats_proto_rawDescOnce sync.Once
	file_google_cloud_automl_v1beta1_data_stats_proto_rawDescData = file_google_cloud_automl_v1beta1_data_stats_proto_rawDesc
)

func file_google_cloud_automl_v1beta1_data_stats_proto_rawDescGZIP() []byte {
	file_google_cloud_automl_v1beta1_data_stats_proto_rawDescOnce.Do(func() {
		file_google_cloud_automl_v1beta1_data_stats_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_automl_v1beta1_data_stats_proto_rawDescData)
	})
	return file_google_cloud_automl_v1beta1_data_stats_proto_rawDescData
}

var file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_automl_v1beta1_data_stats_proto_goTypes = []any{
	(*DataStats)(nil),                    // 0: google.cloud.automl.v1beta1.DataStats
	(*Float64Stats)(nil),                 // 1: google.cloud.automl.v1beta1.Float64Stats
	(*StringStats)(nil),                  // 2: google.cloud.automl.v1beta1.StringStats
	(*TimestampStats)(nil),               // 3: google.cloud.automl.v1beta1.TimestampStats
	(*ArrayStats)(nil),                   // 4: google.cloud.automl.v1beta1.ArrayStats
	(*StructStats)(nil),                  // 5: google.cloud.automl.v1beta1.StructStats
	(*CategoryStats)(nil),                // 6: google.cloud.automl.v1beta1.CategoryStats
	(*CorrelationStats)(nil),             // 7: google.cloud.automl.v1beta1.CorrelationStats
	(*Float64Stats_HistogramBucket)(nil), // 8: google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
	(*StringStats_UnigramStats)(nil),     // 9: google.cloud.automl.v1beta1.StringStats.UnigramStats
	(*TimestampStats_GranularStats)(nil), // 10: google.cloud.automl.v1beta1.TimestampStats.GranularStats
	nil,                                  // 11: google.cloud.automl.v1beta1.TimestampStats.GranularStatsEntry
	nil,                                  // 12: google.cloud.automl.v1beta1.TimestampStats.GranularStats.BucketsEntry
	nil,                                  // 13: google.cloud.automl.v1beta1.StructStats.FieldStatsEntry
	(*CategoryStats_SingleCategoryStats)(nil), // 14: google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
}
var file_google_cloud_automl_v1beta1_data_stats_proto_depIdxs = []int32{
	1,  // 0: google.cloud.automl.v1beta1.DataStats.float64_stats:type_name -> google.cloud.automl.v1beta1.Float64Stats
	2,  // 1: google.cloud.automl.v1beta1.DataStats.string_stats:type_name -> google.cloud.automl.v1beta1.StringStats
	3,  // 2: google.cloud.automl.v1beta1.DataStats.timestamp_stats:type_name -> google.cloud.automl.v1beta1.TimestampStats
	4,  // 3: google.cloud.automl.v1beta1.DataStats.array_stats:type_name -> google.cloud.automl.v1beta1.ArrayStats
	5,  // 4: google.cloud.automl.v1beta1.DataStats.struct_stats:type_name -> google.cloud.automl.v1beta1.StructStats
	6,  // 5: google.cloud.automl.v1beta1.DataStats.category_stats:type_name -> google.cloud.automl.v1beta1.CategoryStats
	8,  // 6: google.cloud.automl.v1beta1.Float64Stats.histogram_buckets:type_name -> google.cloud.automl.v1beta1.Float64Stats.HistogramBucket
	9,  // 7: google.cloud.automl.v1beta1.StringStats.top_unigram_stats:type_name -> google.cloud.automl.v1beta1.StringStats.UnigramStats
	11, // 8: google.cloud.automl.v1beta1.TimestampStats.granular_stats:type_name -> google.cloud.automl.v1beta1.TimestampStats.GranularStatsEntry
	0,  // 9: google.cloud.automl.v1beta1.ArrayStats.member_stats:type_name -> google.cloud.automl.v1beta1.DataStats
	13, // 10: google.cloud.automl.v1beta1.StructStats.field_stats:type_name -> google.cloud.automl.v1beta1.StructStats.FieldStatsEntry
	14, // 11: google.cloud.automl.v1beta1.CategoryStats.top_category_stats:type_name -> google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats
	12, // 12: google.cloud.automl.v1beta1.TimestampStats.GranularStats.buckets:type_name -> google.cloud.automl.v1beta1.TimestampStats.GranularStats.BucketsEntry
	10, // 13: google.cloud.automl.v1beta1.TimestampStats.GranularStatsEntry.value:type_name -> google.cloud.automl.v1beta1.TimestampStats.GranularStats
	0,  // 14: google.cloud.automl.v1beta1.StructStats.FieldStatsEntry.value:type_name -> google.cloud.automl.v1beta1.DataStats
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_automl_v1beta1_data_stats_proto_init() }
func file_google_cloud_automl_v1beta1_data_stats_proto_init() {
	if File_google_cloud_automl_v1beta1_data_stats_proto != nil {
		return
	}
	file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes[0].OneofWrappers = []any{
		(*DataStats_Float64Stats)(nil),
		(*DataStats_StringStats)(nil),
		(*DataStats_TimestampStats)(nil),
		(*DataStats_ArrayStats)(nil),
		(*DataStats_StructStats)(nil),
		(*DataStats_CategoryStats)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_automl_v1beta1_data_stats_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_automl_v1beta1_data_stats_proto_goTypes,
		DependencyIndexes: file_google_cloud_automl_v1beta1_data_stats_proto_depIdxs,
		MessageInfos:      file_google_cloud_automl_v1beta1_data_stats_proto_msgTypes,
	}.Build()
	File_google_cloud_automl_v1beta1_data_stats_proto = out.File
	file_google_cloud_automl_v1beta1_data_stats_proto_rawDesc = nil
	file_google_cloud_automl_v1beta1_data_stats_proto_goTypes = nil
	file_google_cloud_automl_v1beta1_data_stats_proto_depIdxs = nil
}
