// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package documentai provides access to the Cloud Document AI API.
//
// For product documentation, see: https://cloud.google.com/document-ai/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/documentai/v1beta3"
//	...
//	ctx := context.Background()
//	documentaiService, err := documentai.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	documentaiService, err := documentai.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	documentaiService, err := documentai.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package documentai // import "google.golang.org/api/documentai/v1beta3"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "documentai:v1beta3"
const apiName = "documentai"
const apiVersion = "v1beta3"
const basePath = "https://documentai.googleapis.com/"
const basePathTemplate = "https://documentai.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://documentai.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.ProcessorTypes = NewProjectsLocationsProcessorTypesService(s)
	rs.Processors = NewProjectsLocationsProcessorsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Operations *ProjectsLocationsOperationsService

	ProcessorTypes *ProjectsLocationsProcessorTypesService

	Processors *ProjectsLocationsProcessorsService
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsProcessorTypesService(s *Service) *ProjectsLocationsProcessorTypesService {
	rs := &ProjectsLocationsProcessorTypesService{s: s}
	return rs
}

type ProjectsLocationsProcessorTypesService struct {
	s *Service
}

func NewProjectsLocationsProcessorsService(s *Service) *ProjectsLocationsProcessorsService {
	rs := &ProjectsLocationsProcessorsService{s: s}
	rs.Dataset = NewProjectsLocationsProcessorsDatasetService(s)
	rs.HumanReviewConfig = NewProjectsLocationsProcessorsHumanReviewConfigService(s)
	rs.ProcessorVersions = NewProjectsLocationsProcessorsProcessorVersionsService(s)
	return rs
}

type ProjectsLocationsProcessorsService struct {
	s *Service

	Dataset *ProjectsLocationsProcessorsDatasetService

	HumanReviewConfig *ProjectsLocationsProcessorsHumanReviewConfigService

	ProcessorVersions *ProjectsLocationsProcessorsProcessorVersionsService
}

func NewProjectsLocationsProcessorsDatasetService(s *Service) *ProjectsLocationsProcessorsDatasetService {
	rs := &ProjectsLocationsProcessorsDatasetService{s: s}
	return rs
}

type ProjectsLocationsProcessorsDatasetService struct {
	s *Service
}

func NewProjectsLocationsProcessorsHumanReviewConfigService(s *Service) *ProjectsLocationsProcessorsHumanReviewConfigService {
	rs := &ProjectsLocationsProcessorsHumanReviewConfigService{s: s}
	return rs
}

type ProjectsLocationsProcessorsHumanReviewConfigService struct {
	s *Service
}

func NewProjectsLocationsProcessorsProcessorVersionsService(s *Service) *ProjectsLocationsProcessorsProcessorVersionsService {
	rs := &ProjectsLocationsProcessorsProcessorVersionsService{s: s}
	rs.Evaluations = NewProjectsLocationsProcessorsProcessorVersionsEvaluationsService(s)
	return rs
}

type ProjectsLocationsProcessorsProcessorVersionsService struct {
	s *Service

	Evaluations *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService
}

func NewProjectsLocationsProcessorsProcessorVersionsEvaluationsService(s *Service) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService {
	rs := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsService{s: s}
	return rs
}

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsService struct {
	s *Service
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata: Metadata of
// the auto-labeling documents operation.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// IndividualAutoLabelStatuses: The list of individual auto-labeling
	// statuses of the dataset documents.
	IndividualAutoLabelStatuses []*GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus `json:"individualAutoLabelStatuses,omitempty"`

	// TotalDocumentCount: Total number of the auto-labeling documents.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAuto
// LabelStatus: The status of individual documents in the auto-labeling
// process.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus struct {
	// DocumentId: The document id of the auto-labeled document. This will
	// replace the gcs_uri.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// Status: The status of the document auto-labeling.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse: The
// response proto of AutoLabelDocuments method.
type GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ErrorDocumentCount: Total number of documents that failed to be
	// deleted in storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`

	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`

	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBa
// tchDeleteStatus: The status of each individual document in the batch
// delete process.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse: Response
// of the delete documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// DestDatasetType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not
	// set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestDatasetType string `json:"destDatasetType,omitempty"`

	// DestSplitType: The destination dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not
	// set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DestSplitType string `json:"destSplitType,omitempty"`

	// IndividualBatchMoveStatuses: The list of response details of each
	// document.
	IndividualBatchMoveStatuses []*GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus `json:"individualBatchMoveStatuses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatc
// hMoveStatus: The status of each individual document in the batch move
// process.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// Status: The status of moving the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse: Response of
// the batch move documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// IndividualBatchUpdateStatuses: The list of response details of each
	// document.
	IndividualBatchUpdateStatuses []*GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus `json:"individualBatchUpdateStatuses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBa
// tchUpdateStatus: The status of each individual document in the batch
// update process.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// Status: The status of updating the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse: Response
// of the batch update documents operation.
type GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata: The common
// metadata for long running operations.
type GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`

	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata: The
// long-running operation metadata for the CreateLabelerPool method.
type GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata: The
// long-running operation metadata for DeleteLabelerPool.
type GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata: The
// long-running operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata: The
// long-running operation metadata for the DeleteProcessorVersion
// method.
type GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata: The
// long-running operation metadata for the DeployProcessorVersion
// method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse:
// Response message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata: The
// long-running operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse: Response
// message for the DisableProcessor method. Intentionally empty proto
// for adding fields in future.
type GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiUiv1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`

	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiUiv1beta3RevisionRef `json:"revisionRef,omitempty"`

	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsManagedDocId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId:
// Identifies a document uniquely within the scope of a dataset in the
// user-managed Cloud Storage option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`

	// GcsUri: Required. The Cloud Storage URI where the actual document is
	// stored.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CwDocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CwDocId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId:
// Identifies a document uniquely within the scope of a dataset in
// unmanaged option.
type GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata: The
// long-running operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse: Response
// message for the EnableProcessor method. Intentionally empty proto for
// adding fields in future.
type GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata:
// Metadata of the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse:
// Response of the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Evaluation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata: Metadata of
// the batch export documents operation.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// IndividualExportStatuses: The list of response details of each
	// document.
	IndividualExportStatuses []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus `json:"individualExportStatuses,omitempty"`

	// SplitExportStats: The list of statistics for each dataset split type.
	SplitExportStats []*GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat `json:"splitExportStats,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportS
// tatus: The status of each individual document in the export process.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus struct {
	// DocumentId: The path to source docproto of the document.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// OutputGcsDestination: The output_gcs_destination of the exported
	// document if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`

	// Status: The status of the exporting of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat:
// The statistic representing a dataset split type for this export.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat struct {
	// SplitType: The dataset split type.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not
	// set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	SplitType string `json:"splitType,omitempty"`

	// TotalDocumentCount: Total number of documents with the given dataset
	// split type to be exported.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SplitType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SplitType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse: The response
// proto of ExportDocuments method.
type GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata:
// Metadata message associated with the ExportProcessorVersion
// operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata struct {
	// CommonMetadata: The common metadata about the operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse:
// Response message associated with the ExportProcessorVersion
// operation.
type GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse struct {
	// GcsUri: The Cloud Storage URI containing the output artifacts.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata: Metadata of
// the import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ImportConfigValidationResults: Validation statuses of the batch
	// documents import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`

	// IndividualImportStatuses: The list of response details of each
	// document.
	IndividualImportStatuses []*GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`

	// TotalDocumentCount: Total number of the documents that are qualified
	// for importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValid
// ationResult: The validation status of each import config. Status is
// set to an error if there are no documents to import in the
// `import_config`, or `OK` if the operation will try to proceed with at
// least one document.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import
	// config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputGcsSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportS
// tatus: The status of each individual document in the import process.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// OutputDocumentId: The document id of imported document if it was
	// successful, otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"outputDocumentId,omitempty"`

	// OutputGcsDestination: The output_gcs_destination of the processed
	// document if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`

	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputGcsSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse: Response of
// the import document operation.
type GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata: The
// long-running operation metadata for the ImportProcessorVersion
// method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse: The
// response message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata: The metadata
// proto of `ResyncDataset` method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// DatasetResyncStatuses: The list of dataset resync statuses. Not
	// checked when ResyncDatasetRequest.dataset_documents is specified.
	DatasetResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus `json:"datasetResyncStatuses,omitempty"`

	// IndividualDocumentResyncStatuses: The list of document resync
	// statuses. The same document could have multiple
	// `individual_document_resync_statuses` if it has multiple
	// inconsistencies.
	IndividualDocumentResyncStatuses []*GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus `json:"individualDocumentResyncStatuses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus
// : Resync status against inconsistency types on the dataset level.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus struct {
	// DatasetInconsistencyType: The type of the inconsistency of the
	// dataset.
	//
	// Possible values:
	//   "DATASET_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DATASET_INCONSISTENCY_TYPE_NO_STORAGE_MARKER" - The marker file
	// under the dataset folder is not found.
	DatasetInconsistencyType string `json:"datasetInconsistencyType,omitempty"`

	// Status: The status of resyncing the dataset with regards to the
	// detected inconsistency. Empty if ResyncDatasetRequest.validate_only
	// is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DatasetInconsistencyType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetInconsistencyType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentR
// esyncStatus: Resync status for each document per inconsistency type.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus struct {
	// DocumentId: The document identifier.
	DocumentId *GoogleCloudDocumentaiUiv1beta3DocumentId `json:"documentId,omitempty"`

	// DocumentInconsistencyType: The type of document inconsistency.
	//
	// Possible values:
	//   "DOCUMENT_INCONSISTENCY_TYPE_UNSPECIFIED" - Default value.
	//   "DOCUMENT_INCONSISTENCY_TYPE_INVALID_DOCPROTO" - The document proto
	// is invalid.
	//   "DOCUMENT_INCONSISTENCY_TYPE_MISMATCHED_METADATA" - Indexed
	// docproto metadata is mismatched.
	//   "DOCUMENT_INCONSISTENCY_TYPE_NO_PAGE_IMAGE" - The page image or
	// thumbnails are missing.
	DocumentInconsistencyType string `json:"documentInconsistencyType,omitempty"`

	// Status: The status of resyncing the document with regards to the
	// detected inconsistency. Empty if ResyncDatasetRequest.validate_only
	// is `true`.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse: The response
// proto of ResyncDataset method.
type GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3RevisionRef: The revision reference
// specifies which revision on the document to read.
type GoogleCloudDocumentaiUiv1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor
	// version.
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`

	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read
	// the `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`

	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LatestProcessorVersion") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestProcessorVersion")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3RevisionRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata: Metadata of
// the sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse: Response of
// the sample documents operation.
type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse struct {
	// SampleTestStatus: The status of sampling documents in test split.
	SampleTestStatus *GoogleRpcStatus `json:"sampleTestStatus,omitempty"`

	// SampleTrainingStatus: The status of sampling documents in training
	// split.
	SampleTrainingStatus *GoogleRpcStatus `json:"sampleTrainingStatus,omitempty"`

	// SelectedDocuments: The result of the sampling process.
	SelectedDocuments []*GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument `json:"selectedDocuments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SampleTestStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SampleTestStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument struct {
	// DocumentId: An internal identifier for document.
	DocumentId string `json:"documentId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion
// method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse:
// Response message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata: The
// metadata that represents a processor version being created.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`

	// TrainingDatasetValidation: The training dataset validation
	// information.
	TrainingDatasetValidation *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetVali
// dation: The dataset validation information. This includes any and all
// errors with documents and the dataset.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`

	// DatasetErrors: Error information for the dataset as a whole. A
	// maximum of 10 dataset errors will be returned. A single dataset error
	// is terminal for training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`

	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`

	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with
	// errors will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetErrorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse: The
// response for TrainProcessorVersion.
type GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced
	// by training.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion
// method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse:
// Response message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata: The
// long-running operation metadata for updating the human review
// configuration.
type GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata: The
// long-running operation metadata for UpdateLabelerPool.
type GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadata: The long-running
// operation metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// IndividualProcessStatuses: The list of response details of each
	// document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`

	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the error message if the operation
	// is failed.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus:
// The status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewStatus: The status of human review on the processed
	// document.
	HumanReviewStatus *GoogleCloudDocumentaiV1HumanReviewStatus `json:"humanReviewStatus,omitempty"`

	// InputGcsSource: The source of the document, same as the
	// input_gcs_source field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// OutputGcsDestination: The Cloud Storage output destination (in the
	// request as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the
	// processed document if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`

	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HumanReviewStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HumanReviewStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BatchProcessResponse: Response message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1CommonOperationMetadata: The common metadata
// for long running operations.
type GoogleCloudDocumentaiV1CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`

	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1CommonOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata: The
// long-running operation metadata for the DeleteProcessorVersion
// method.
type GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionMetadata: The
// long-running operation metadata for the DeployProcessorVersion
// method.
type GoogleCloudDocumentaiV1DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DeployProcessorVersionResponse: Response
// message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1DisableProcessorMetadata: The long-running
// operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DisableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DisableProcessorResponse: Response message for
// the DisableProcessor method. Intentionally empty proto for adding
// fields in future.
type GoogleCloudDocumentaiV1DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EnableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EnableProcessorResponse: Response message for
// the EnableProcessor method. Intentionally empty proto for adding
// fields in future.
type GoogleCloudDocumentaiV1EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata: Metadata of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse: Response of
// the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Evaluation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1HumanReviewStatus: The status of human review
// on a processed document.
type GoogleCloudDocumentaiV1HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the
	// processed document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and
	// metadata as the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`

	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most
	// likely due to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can
	// happen because human review isn't enabled on the processor or the
	// processing request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and
	// passed, so no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the
	// document is under review.
	//   "ERROR" - Some error happened during triggering human review, see
	// the state_message for details.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the human review
	// state.
	StateMessage string `json:"stateMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HumanReviewOperation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HumanReviewOperation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1HumanReviewStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata: The
// long-running operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1ReviewDocumentResponse: Response message for
// the ReviewDocument method.
type GoogleCloudDocumentaiV1ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document
	// if the review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`

	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`

	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1ReviewDocumentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion
// method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse: Response
// message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadata: The metadata
// that represents a processor version being created.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`

	// TrainingDatasetValidation: The training dataset validation
	// information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation:
//
//	The dataset validation information. This includes any and all errors
//
// with documents and the dataset.
type GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`

	// DatasetErrors: Error information for the dataset as a whole. A
	// maximum of 10 dataset errors will be returned. A single dataset error
	// is terminal for training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`

	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`

	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with
	// errors will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetErrorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1TrainProcessorVersionResponse: The response
// for TrainProcessorVersion.
type GoogleCloudDocumentaiV1TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced
	// by training.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1TrainProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion
// method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1UndeployProcessorVersionResponse: Response
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1UndeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta1Barcode: Encodes the detailed information
// of a barcode.
type GoogleCloudDocumentaiV1beta1Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`:
	// Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type.
	// - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. -
	// `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. -
	// `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E
	// type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. -
	// `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`

	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`

	// ValueFormat: Value format describes the format of the value that a
	// barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact
	// information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. -
	// `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. -
	// `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi
	// information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar
	// event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Barcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse: Response
// to an batch document processing request. This is returned in the LRO
// Operation after the operation is complete.
type GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse struct {
	// Responses: Responses for each individual document.
	Responses []*GoogleCloudDocumentaiV1beta1ProcessDocumentResponse `json:"responses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Responses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1BatchProcessDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1BoundingPoly: A bounding polygon for the
// detected image annotation.
type GoogleCloudDocumentaiV1beta1BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1beta1NormalizedVertex `json:"normalizedVertices,omitempty"`

	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1beta1Vertex `json:"vertices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NormalizedVertices")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NormalizedVertices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1BoundingPoly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1Document: Document represents the
// canonical document resource in Document AI. It is an interchange
// format that provides insights into documents and allows for
// collaboration between users and Document AI to iterate and optimize
// for quality.
type GoogleCloudDocumentaiV1beta1Document struct {
	// Content: Optional. Inline document content, represented as a stream
	// of bytes. Note: As with all `bytes` fields, protobuffers use a pure
	// binary representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`

	// Entities: A list of entities detected on Document.text. For document
	// shards, entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1beta1DocumentEntity `json:"entities,omitempty"`

	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1beta1DocumentEntityRelation `json:"entityRelations,omitempty"`

	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`

	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1beta1DocumentPage `json:"pages,omitempty"`

	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1beta1DocumentRevision `json:"revisions,omitempty"`

	// ShardInfo: Information about the sharding if this document is sharded
	// part of a larger document. If the document is not sharded, this
	// message is not specified.
	ShardInfo *GoogleCloudDocumentaiV1beta1DocumentShardInfo `json:"shardInfo,omitempty"`

	// Text: Optional. UTF-8 encoded text in reading order from the
	// document.
	Text string `json:"text,omitempty"`

	// TextChanges: Placeholder. A list of text corrections made to
	// Document.text. This is usually used for annotating corrections to OCR
	// mistakes. Text changes for a given revision may not overlap with each
	// other.
	TextChanges []*GoogleCloudDocumentaiV1beta1DocumentTextChange `json:"textChanges,omitempty"`

	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1beta1DocumentStyle `json:"textStyles,omitempty"`

	// Uri: Optional. Currently supports Google Cloud Storage URI of the
	// form `gs://bucket_name/object_name`. Object versioning is not
	// supported. For more information, refer to Google Cloud Storage
	// Request URIs (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Document
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentEntity: An entity that could be a
// phrase in the text or a property that belongs to the document. It is
// a known entity type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1beta1DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range
	// `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Id: Optional. Canonical id. This will be a unique value in the entity
	// list for this document.
	Id string `json:"id,omitempty"`

	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`

	// MentionText: Optional. Text value of the entity e.g. `1600
	// Amphitheatre Pkwy`.
	MentionText string `json:"mentionText,omitempty"`

	// NormalizedValue: Optional. Normalized entity value. Absent if the
	// extracted value could not be converted or the type (e.g. address) is
	// not supported for certain parsers. This field is also only populated
	// for certain supported document types.
	NormalizedValue *GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`

	// PageAnchor: Optional. Represents the provenance of this entity wrt.
	// the location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1beta1DocumentPageAnchor `json:"pageAnchor,omitempty"`

	// Properties: Optional. Entities can be nested to form a hierarchical
	// data structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1beta1DocumentEntity `json:"properties,omitempty"`

	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`

	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing
	// into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`

	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue: Parsed and
// normalized entity value.
type GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`

	// BooleanValue: Boolean value. Can be used for entities with binary
	// values, or for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`

	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`

	// DatetimeValue: DateTime value. Includes date, time, and timezone. See
	// also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`

	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`

	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`

	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`

	// Text: Optional. An optional field to store a normalized string. For
	// some entity types, one of respective `structured_value` fields may
	// also be populated. Also not all the types of `structured_value` will
	// be normalized. For example, some processors may not generate `float`
	// or `integer` normalized text by default. Below are sample formats
	// mapped to structured values. - Money/Currency type (`money_value`) is
	// in the ISO 4217 text format. - Date type (`date_value`) is in the ISO
	// 8601 text format. - Datetime type (`datetime_value`) is in the ISO
	// 8601 text format.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentEntityRelation: Relationship
// between Entities.
type GoogleCloudDocumentaiV1beta1DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`

	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`

	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentEntityRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1beta1DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block
	// has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*GoogleCloudDocumentaiV1beta1DocumentPageBlock `json:"blocks,omitempty"`

	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1beta1DocumentPageDimension `json:"dimension,omitempty"`

	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1beta1DocumentPageFormField `json:"formFields,omitempty"`

	// Image: Rendered image for this page. This image is preprocessed to
	// remove any skew, rotation, and distortions such that the annotation
	// bounding boxes can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1beta1DocumentPageImage `json:"image,omitempty"`

	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`

	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Lines: A list of visually detected text lines on the page. A
	// collection of tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1beta1DocumentPageLine `json:"lines,omitempty"`

	// PageNumber: 1-based index for current Page in a parent Document.
	// Useful when a page is taken out of a Document for individual
	// processing.
	PageNumber int64 `json:"pageNumber,omitempty"`

	// Paragraphs: A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1beta1DocumentPageParagraph `json:"paragraphs,omitempty"`

	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1beta1DocumentPageSymbol `json:"symbols,omitempty"`

	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1beta1DocumentPageTable `json:"tables,omitempty"`

	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1beta1DocumentPageToken `json:"tokens,omitempty"`

	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1beta1DocumentPageMatrix `json:"transforms,omitempty"`

	// VisualElements: A list of detected non-text visual elements e.g.
	// checkbox, signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1beta1DocumentPageVisualElement `json:"visualElements,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Blocks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageAnchor: Referencing the
// visual context of the entity in the Document.pages. Page anchors can
// be cross-page, consist of multiple bounding polygons and optionally
// reference specific layout element types.
type GoogleCloudDocumentaiV1beta1DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageRefs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef: Represents a
// weak reference to a page element within a document.
type GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout
	// element on the page.
	BoundingPoly *GoogleCloudDocumentaiV1beta1BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Optional. Confidence of detected page element, if
	// applicable. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`

	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`

	// Page: Required. Index into the Document.pages element, for example
	// using `Document.pages` to locate the related page element. This field
	// is skipped when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageBlock: A block has a set of
// lines (collected into paragraphs) that have a common line-spacing and
// orientation.
type GoogleCloudDocumentaiV1beta1DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageBlock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode: A detected
// barcode.
type GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1beta1Barcode `json:"barcode,omitempty"`

	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Barcode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Barcode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedBarcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage: Detected
// language for a structural component.
type GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier),
	// such as `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageDimension: Dimension for the
// page.
type GoogleCloudDocumentaiV1beta1DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`

	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`

	// Width: Page width.
	Width float64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageFormField: A form field
// detected on the page.
type GoogleCloudDocumentaiV1beta1DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If
	// corrections were made to the text identified by the
	// `field_name.text_anchor`, this field will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`

	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`

	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`,
	// `Grand total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"fieldName,omitempty"`

	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"fieldValue,omitempty"`

	// NameDetectedLanguages: A list of detected languages for name together
	// with confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// ValueDetectedLanguages: A list of detected languages for value
	// together with confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`

	// ValueType: If the value is non-textual, this field represents the
	// type. Current valid values are: - blank (this indicates the
	// `field_value` is normal text) - `unfilled_checkbox` -
	// `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorrectedKeyText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageFormField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageImage: Rendered image
// contents for this page.
type GoogleCloudDocumentaiV1beta1DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`

	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`

	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for
	// the image.
	MimeType string `json:"mimeType,omitempty"`

	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores: Image
// quality scores for the page image.
type GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`

	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is
	// perfect quality.
	QualityScore float64 `json:"qualityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedDefects") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefe
// ct: Image Quality Defects
type GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`

	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` -
	// `quality/defect_dark` - `quality/defect_faint` -
	// `quality/defect_text_too_small` - `quality/defect_document_cutoff` -
	// `quality/defect_text_cutoff` - `quality/defect_glare`
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageLayout: Visual element
// describing a layout unit on a page.
type GoogleCloudDocumentaiV1beta1DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1beta1BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Confidence of the current Layout within context of the
	// object this layout is for. e.g. confidence can be for a single token,
	// a table, a visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the
	// head 90 degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head
	// 180 degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head
	// 90 degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLayout
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageLine: A collection of tokens
// that a human would perceive as a line. Does not cross column
// boundaries, can be horizontal, vertical, etc.
type GoogleCloudDocumentaiV1beta1DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageLine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageMatrix: Representation for
// transformation matrix, intended to be compatible and used with OpenCV
// format for image manipulation.
type GoogleCloudDocumentaiV1beta1DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`

	// Data: The matrix data.
	Data string `json:"data,omitempty"`

	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`

	// Type: This encodes information about what data type the matrix uses.
	// For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
	// of OpenCV primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cols") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cols") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageMatrix
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageParagraph: A collection of
// lines that a human would perceive as a paragraph.
type GoogleCloudDocumentaiV1beta1DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageParagraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1beta1DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageSymbol
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTable: A table representation
// similar to HTML table structure.
type GoogleCloudDocumentaiV1beta1DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow `json:"bodyRows,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow `json:"headerRows,omitempty"`

	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BodyRows") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell: A cell
// representation inside the table.
type GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColSpan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColSpan") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow: A row of table
// cells.
type GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1beta1DocumentPageTableTableCell `json:"cells,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTableTableRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1beta1DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedBreak") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageToken
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak: Detected
// break at the end of a Token.
type GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split
	// across lines.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenDetectedBreak
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo: Font and
// other text style attributes.
type GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`

	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`

	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`

	// FontWeight: TrueType weight on a scale `100` (thin) to `1000`
	// (ultra-heavy). Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`

	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`

	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`

	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`

	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`

	// Smallcaps: Whether the text is in small caps.
	Smallcaps bool `json:"smallcaps,omitempty"`

	// Strikeout: Whether the text is strikethrough.
	Strikeout bool `json:"strikeout,omitempty"`

	// Subscript: Whether the text is a subscript.
	Subscript bool `json:"subscript,omitempty"`

	// Superscript: Whether the text is a superscript.
	Superscript bool `json:"superscript,omitempty"`

	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`

	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentPageVisualElement: Detected
// non-text visual elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1beta1DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1beta1DocumentPageLayout `json:"layout,omitempty"`

	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentPageVisualElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentProvenance: Structure to identify
// provenance relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1beta1DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of
	// the revision.
	Id int64 `json:"id,omitempty"`

	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1beta1DocumentProvenanceParent `json:"parents,omitempty"`

	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`

	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no
	// operation is specified a provenance entry is simply used to match
	// against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of
	// the message. It overwrites the fields rather than replacing them. Use
	// this when you want to update a field value of an entity without also
	// updating all the child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by
	// `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at
	// human review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation
	// process.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentProvenance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentProvenanceParent: The parent
// element the current element is based on. Used for
// referencing/aligning, removal and replacement operations.
type GoogleCloudDocumentaiV1beta1DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`

	// Index: The index of the parent item in the corresponding item list
	// (eg. list of entities, properties within entities, etc.) in the
	// parent revision.
	Index int64 `json:"index,omitempty"`

	// Revision: The index of the index into current revision's parent_ids
	// list.
	Revision int64 `json:"revision,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentProvenanceParent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentRevision: Contains past or
// forward revisions of this document.
type GoogleCloudDocumentaiV1beta1DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of
	// that person.
	Agent string `json:"agent,omitempty"`

	// CreateTime: The time that the revision was created, internally
	// generated by doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`

	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview `json:"humanReview,omitempty"`

	// Id: Id of the revision, internally generated by doc proto storage.
	// Unique within the context of the document.
	Id string `json:"id,omitempty"`

	// Parent: The revisions that this revision is based on. This can
	// include one or more parent (when documents are merged.) This field
	// represents the index into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`

	// ParentIds: The revisions that this revision is based on. Must include
	// all the ids that have anything to do with this revision - eg. there
	// are `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`

	// Processor: If the annotation was made by processor identify the
	// processor by its resource name.
	Processor string `json:"processor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Agent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview: Human Review
// information of the document.
type GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the rejection reason when the state
	// is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentRevisionHumanReview
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentShardInfo: For a large document,
// sharding may be performed to produce several document shards. Each
// document shard contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1beta1DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`

	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`

	// TextOffset: The index of the first character in Document.text in the
	// overall document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShardCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentShardInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentStyle: Annotation for common text
// style attributes. This adheres to CSS conventions as much as
// possible.
type GoogleCloudDocumentaiV1beta1DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`

	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`

	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1beta1DocumentStyleFontSize `json:"fontSize,omitempty"`

	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible
	// values are `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`

	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
	// Follows CSS standard.
	TextDecoration string `json:"textDecoration,omitempty"`

	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible
	// values are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentStyleFontSize: Font size with
// unit.
type GoogleCloudDocumentaiV1beta1DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`

	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`,
	// and `pt`).
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Size") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Size") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyleFontSize
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1beta1DocumentTextAnchor: Text reference
// indexing into the Document.text.
type GoogleCloudDocumentaiV1beta1DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not
	// have to look it up in the text_segments. It is always populated for
	// formFields.
	Content string `json:"content,omitempty"`

	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment: A text
// segment in the Document.text. The indices may be out of bounds which
// indicate that the text extends into another document shard for large
// sharded documents. See ShardInfo.text_offset
type GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the
	// Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`

	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextAnchorTextSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1DocumentTextChange: This message is used
// for text changes aka. OCR corrections.
type GoogleCloudDocumentaiV1beta1DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`

	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1beta1DocumentProvenance `json:"provenance,omitempty"`

	// TextAnchor: Provenance of the correction. Text anchor indexing into
	// the Document.text. There can only be a single
	// `TextAnchor.text_segments` element. If the start and end index of the
	// text segment are the same, the text change is inserted before that
	// index.
	TextAnchor *GoogleCloudDocumentaiV1beta1DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangedText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1DocumentTextChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1GcsDestination: The Google Cloud Storage
// location where the output file will be written to.
type GoogleCloudDocumentaiV1beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1GcsDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1GcsSource: The Google Cloud Storage
// location where the input file will be read from.
type GoogleCloudDocumentaiV1beta1GcsSource struct {
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1GcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1InputConfig: The desired input location
// and metadata.
type GoogleCloudDocumentaiV1beta1InputConfig struct {
	// GcsSource: The Google Cloud Storage location to read the input from.
	// This must be a single file.
	GcsSource *GoogleCloudDocumentaiV1beta1GcsSource `json:"gcsSource,omitempty"`

	// MimeType: Required. Mimetype of the input. Current supported
	// mimetypes are application/pdf, image/tiff, and image/gif. In
	// addition, application/json type is supported for requests with
	// ProcessDocumentRequest.automl_params field set. The JSON file needs
	// to be in Document format.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1InputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1NormalizedVertex: A vertex represents a
// 2D point in the image. NOTE: the normalized vertex coordinates are
// relative to the original image and range from 0 to 1.
type GoogleCloudDocumentaiV1beta1NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1NormalizedVertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta1NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta1NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1beta1OperationMetadata: Contains metadata for
// the BatchProcessDocuments operation.
type GoogleCloudDocumentaiV1beta1OperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "ACCEPTED" - Request is received.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1OutputConfig: The desired output location
// and metadata.
type GoogleCloudDocumentaiV1beta1OutputConfig struct {
	// GcsDestination: The Google Cloud Storage location to write the output
	// to.
	GcsDestination *GoogleCloudDocumentaiV1beta1GcsDestination `json:"gcsDestination,omitempty"`

	// PagesPerShard: The max number of pages to include into each output
	// Document shard JSON on Google Cloud Storage. The valid range is [1,
	// 100]. If not specified, the default value is 20. For example, for one
	// pdf file with 100 pages, 100 parsed pages will be produced. If
	// `pages_per_shard` = 20, then 5 Document shard JSON files each
	// containing 20 parsed pages will be written under the prefix
	// OutputConfig.gcs_destination.uri and suffix pages-x-to-y.json where x
	// and y are 1-indexed page numbers. Example GCS outputs with 157 pages
	// and pages_per_shard = 50: pages-001-to-050.json pages-051-to-100.json
	// pages-101-to-150.json pages-151-to-157.json
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1OutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1ProcessDocumentResponse: Response to a
// single document processing request.
type GoogleCloudDocumentaiV1beta1ProcessDocumentResponse struct {
	// InputConfig: Information about the input file. This is the same as
	// the corresponding input config in the request.
	InputConfig *GoogleCloudDocumentaiV1beta1InputConfig `json:"inputConfig,omitempty"`

	// OutputConfig: The output location of the parsed responses. The
	// responses are written to this location as JSON-serialized `Document`
	// objects.
	OutputConfig *GoogleCloudDocumentaiV1beta1OutputConfig `json:"outputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1ProcessDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1ProcessDocumentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta1Vertex: A vertex represents a 2D point in
// the image. NOTE: the vertex coordinates are in the same scale as the
// original image.
type GoogleCloudDocumentaiV1beta1Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta1Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta1Vertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Barcode: Encodes the detailed information
// of a barcode.
type GoogleCloudDocumentaiV1beta2Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`:
	// Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type.
	// - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. -
	// `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. -
	// `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E
	// type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. -
	// `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`

	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`

	// ValueFormat: Value format describes the format of the value that a
	// barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact
	// information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. -
	// `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. -
	// `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi
	// information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar
	// event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Barcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse: Response
// to an batch document processing request. This is returned in the LRO
// Operation after the operation is complete.
type GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse struct {
	// Responses: Responses for each individual document.
	Responses []*GoogleCloudDocumentaiV1beta2ProcessDocumentResponse `json:"responses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Responses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2BatchProcessDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2BoundingPoly: A bounding polygon for the
// detected image annotation.
type GoogleCloudDocumentaiV1beta2BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1beta2NormalizedVertex `json:"normalizedVertices,omitempty"`

	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1beta2Vertex `json:"vertices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NormalizedVertices")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NormalizedVertices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2BoundingPoly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Document: Document represents the
// canonical document resource in Document AI. It is an interchange
// format that provides insights into documents and allows for
// collaboration between users and Document AI to iterate and optimize
// for quality.
type GoogleCloudDocumentaiV1beta2Document struct {
	// Content: Optional. Inline document content, represented as a stream
	// of bytes. Note: As with all `bytes` fields, protobuffers use a pure
	// binary representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`

	// Entities: A list of entities detected on Document.text. For document
	// shards, entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1beta2DocumentEntity `json:"entities,omitempty"`

	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1beta2DocumentEntityRelation `json:"entityRelations,omitempty"`

	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Labels: Labels for this document.
	Labels []*GoogleCloudDocumentaiV1beta2DocumentLabel `json:"labels,omitempty"`

	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`

	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1beta2DocumentPage `json:"pages,omitempty"`

	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1beta2DocumentRevision `json:"revisions,omitempty"`

	// ShardInfo: Information about the sharding if this document is sharded
	// part of a larger document. If the document is not sharded, this
	// message is not specified.
	ShardInfo *GoogleCloudDocumentaiV1beta2DocumentShardInfo `json:"shardInfo,omitempty"`

	// Text: Optional. UTF-8 encoded text in reading order from the
	// document.
	Text string `json:"text,omitempty"`

	// TextChanges: Placeholder. A list of text corrections made to
	// Document.text. This is usually used for annotating corrections to OCR
	// mistakes. Text changes for a given revision may not overlap with each
	// other.
	TextChanges []*GoogleCloudDocumentaiV1beta2DocumentTextChange `json:"textChanges,omitempty"`

	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1beta2DocumentStyle `json:"textStyles,omitempty"`

	// Uri: Optional. Currently supports Google Cloud Storage URI of the
	// form `gs://bucket_name/object_name`. Object versioning is not
	// supported. For more information, refer to Google Cloud Storage
	// Request URIs (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Document
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentEntity: An entity that could be a
// phrase in the text or a property that belongs to the document. It is
// a known entity type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1beta2DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range
	// `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Id: Optional. Canonical id. This will be a unique value in the entity
	// list for this document.
	Id string `json:"id,omitempty"`

	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`

	// MentionText: Optional. Text value of the entity e.g. `1600
	// Amphitheatre Pkwy`.
	MentionText string `json:"mentionText,omitempty"`

	// NormalizedValue: Optional. Normalized entity value. Absent if the
	// extracted value could not be converted or the type (e.g. address) is
	// not supported for certain parsers. This field is also only populated
	// for certain supported document types.
	NormalizedValue *GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`

	// PageAnchor: Optional. Represents the provenance of this entity wrt.
	// the location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1beta2DocumentPageAnchor `json:"pageAnchor,omitempty"`

	// Properties: Optional. Entities can be nested to form a hierarchical
	// data structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1beta2DocumentEntity `json:"properties,omitempty"`

	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`

	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing
	// into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`

	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue: Parsed and
// normalized entity value.
type GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`

	// BooleanValue: Boolean value. Can be used for entities with binary
	// values, or for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`

	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`

	// DatetimeValue: DateTime value. Includes date, time, and timezone. See
	// also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`

	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`

	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`

	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`

	// Text: Optional. An optional field to store a normalized string. For
	// some entity types, one of respective `structured_value` fields may
	// also be populated. Also not all the types of `structured_value` will
	// be normalized. For example, some processors may not generate `float`
	// or `integer` normalized text by default. Below are sample formats
	// mapped to structured values. - Money/Currency type (`money_value`) is
	// in the ISO 4217 text format. - Date type (`date_value`) is in the ISO
	// 8601 text format. - Datetime type (`datetime_value`) is in the ISO
	// 8601 text format.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentEntityRelation: Relationship
// between Entities.
type GoogleCloudDocumentaiV1beta2DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`

	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`

	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentEntityRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentLabel: Label attaches schema
// information and/or other metadata to segments within a Document.
// Multiple Labels on a single field can denote either different labels,
// different instances of the same label created at different times, or
// some combination of both.
type GoogleCloudDocumentaiV1beta2DocumentLabel struct {
	// AutomlModel: Label is generated AutoML model. This field stores the
	// full resource name of the AutoML model. Format:
	// `projects/{project-id}/locations/{location-id}/models/{model-id}`
	AutomlModel string `json:"automlModel,omitempty"`

	// Confidence: Confidence score between 0 and 1 for label assignment.
	Confidence float64 `json:"confidence,omitempty"`

	// Name: Name of the label. When the label is generated from AutoML Text
	// Classification model, this field represents the name of the category.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutomlModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutomlModel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentLabel) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentLabel
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1beta2DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block
	// has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*GoogleCloudDocumentaiV1beta2DocumentPageBlock `json:"blocks,omitempty"`

	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1beta2DocumentPageDimension `json:"dimension,omitempty"`

	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1beta2DocumentPageFormField `json:"formFields,omitempty"`

	// Image: Rendered image for this page. This image is preprocessed to
	// remove any skew, rotation, and distortions such that the annotation
	// bounding boxes can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1beta2DocumentPageImage `json:"image,omitempty"`

	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`

	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Lines: A list of visually detected text lines on the page. A
	// collection of tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1beta2DocumentPageLine `json:"lines,omitempty"`

	// PageNumber: 1-based index for current Page in a parent Document.
	// Useful when a page is taken out of a Document for individual
	// processing.
	PageNumber int64 `json:"pageNumber,omitempty"`

	// Paragraphs: A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1beta2DocumentPageParagraph `json:"paragraphs,omitempty"`

	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1beta2DocumentPageSymbol `json:"symbols,omitempty"`

	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1beta2DocumentPageTable `json:"tables,omitempty"`

	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1beta2DocumentPageToken `json:"tokens,omitempty"`

	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1beta2DocumentPageMatrix `json:"transforms,omitempty"`

	// VisualElements: A list of detected non-text visual elements e.g.
	// checkbox, signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1beta2DocumentPageVisualElement `json:"visualElements,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Blocks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageAnchor: Referencing the
// visual context of the entity in the Document.pages. Page anchors can
// be cross-page, consist of multiple bounding polygons and optionally
// reference specific layout element types.
type GoogleCloudDocumentaiV1beta2DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageRefs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef: Represents a
// weak reference to a page element within a document.
type GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout
	// element on the page.
	BoundingPoly *GoogleCloudDocumentaiV1beta2BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Optional. Confidence of detected page element, if
	// applicable. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`

	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`

	// Page: Required. Index into the Document.pages element, for example
	// using `Document.pages` to locate the related page element. This field
	// is skipped when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageBlock: A block has a set of
// lines (collected into paragraphs) that have a common line-spacing and
// orientation.
type GoogleCloudDocumentaiV1beta2DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageBlock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode: A detected
// barcode.
type GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1beta2Barcode `json:"barcode,omitempty"`

	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Barcode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Barcode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedBarcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage: Detected
// language for a structural component.
type GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier),
	// such as `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageDimension: Dimension for the
// page.
type GoogleCloudDocumentaiV1beta2DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`

	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`

	// Width: Page width.
	Width float64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageFormField: A form field
// detected on the page.
type GoogleCloudDocumentaiV1beta2DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If
	// corrections were made to the text identified by the
	// `field_name.text_anchor`, this field will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`

	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`

	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`,
	// `Grand total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"fieldName,omitempty"`

	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"fieldValue,omitempty"`

	// NameDetectedLanguages: A list of detected languages for name together
	// with confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// ValueDetectedLanguages: A list of detected languages for value
	// together with confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`

	// ValueType: If the value is non-textual, this field represents the
	// type. Current valid values are: - blank (this indicates the
	// `field_value` is normal text) - `unfilled_checkbox` -
	// `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorrectedKeyText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageFormField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageImage: Rendered image
// contents for this page.
type GoogleCloudDocumentaiV1beta2DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`

	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`

	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for
	// the image.
	MimeType string `json:"mimeType,omitempty"`

	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores: Image
// quality scores for the page image.
type GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`

	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is
	// perfect quality.
	QualityScore float64 `json:"qualityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedDefects") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefe
// ct: Image Quality Defects
type GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`

	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` -
	// `quality/defect_dark` - `quality/defect_faint` -
	// `quality/defect_text_too_small` - `quality/defect_document_cutoff` -
	// `quality/defect_text_cutoff` - `quality/defect_glare`
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageLayout: Visual element
// describing a layout unit on a page.
type GoogleCloudDocumentaiV1beta2DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1beta2BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Confidence of the current Layout within context of the
	// object this layout is for. e.g. confidence can be for a single token,
	// a table, a visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the
	// head 90 degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head
	// 180 degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head
	// 90 degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLayout
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageLine: A collection of tokens
// that a human would perceive as a line. Does not cross column
// boundaries, can be horizontal, vertical, etc.
type GoogleCloudDocumentaiV1beta2DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageLine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageMatrix: Representation for
// transformation matrix, intended to be compatible and used with OpenCV
// format for image manipulation.
type GoogleCloudDocumentaiV1beta2DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`

	// Data: The matrix data.
	Data string `json:"data,omitempty"`

	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`

	// Type: This encodes information about what data type the matrix uses.
	// For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
	// of OpenCV primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cols") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cols") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageMatrix
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageParagraph: A collection of
// lines that a human would perceive as a paragraph.
type GoogleCloudDocumentaiV1beta2DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageParagraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1beta2DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageSymbol
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTable: A table representation
// similar to HTML table structure.
type GoogleCloudDocumentaiV1beta2DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow `json:"bodyRows,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow `json:"headerRows,omitempty"`

	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BodyRows") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell: A cell
// representation inside the table.
type GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColSpan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColSpan") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow: A row of table
// cells.
type GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1beta2DocumentPageTableTableCell `json:"cells,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTableTableRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1beta2DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedBreak") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageToken
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak: Detected
// break at the end of a Token.
type GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split
	// across lines.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenDetectedBreak
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo: Font and
// other text style attributes.
type GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`

	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`

	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`

	// FontWeight: TrueType weight on a scale `100` (thin) to `1000`
	// (ultra-heavy). Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`

	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`

	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`

	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`

	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`

	// Smallcaps: Whether the text is in small caps.
	Smallcaps bool `json:"smallcaps,omitempty"`

	// Strikeout: Whether the text is strikethrough.
	Strikeout bool `json:"strikeout,omitempty"`

	// Subscript: Whether the text is a subscript.
	Subscript bool `json:"subscript,omitempty"`

	// Superscript: Whether the text is a superscript.
	Superscript bool `json:"superscript,omitempty"`

	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`

	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentPageVisualElement: Detected
// non-text visual elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1beta2DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta2DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1beta2DocumentPageLayout `json:"layout,omitempty"`

	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentPageVisualElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentProvenance: Structure to identify
// provenance relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1beta2DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of
	// the revision.
	Id int64 `json:"id,omitempty"`

	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1beta2DocumentProvenanceParent `json:"parents,omitempty"`

	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`

	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no
	// operation is specified a provenance entry is simply used to match
	// against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of
	// the message. It overwrites the fields rather than replacing them. Use
	// this when you want to update a field value of an entity without also
	// updating all the child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by
	// `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at
	// human review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation
	// process.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentProvenance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentProvenanceParent: The parent
// element the current element is based on. Used for
// referencing/aligning, removal and replacement operations.
type GoogleCloudDocumentaiV1beta2DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`

	// Index: The index of the parent item in the corresponding item list
	// (eg. list of entities, properties within entities, etc.) in the
	// parent revision.
	Index int64 `json:"index,omitempty"`

	// Revision: The index of the index into current revision's parent_ids
	// list.
	Revision int64 `json:"revision,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentProvenanceParent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentRevision: Contains past or
// forward revisions of this document.
type GoogleCloudDocumentaiV1beta2DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of
	// that person.
	Agent string `json:"agent,omitempty"`

	// CreateTime: The time that the revision was created, internally
	// generated by doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`

	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview `json:"humanReview,omitempty"`

	// Id: Id of the revision, internally generated by doc proto storage.
	// Unique within the context of the document.
	Id string `json:"id,omitempty"`

	// Parent: The revisions that this revision is based on. This can
	// include one or more parent (when documents are merged.) This field
	// represents the index into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`

	// ParentIds: The revisions that this revision is based on. Must include
	// all the ids that have anything to do with this revision - eg. there
	// are `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`

	// Processor: If the annotation was made by processor identify the
	// processor by its resource name.
	Processor string `json:"processor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Agent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview: Human Review
// information of the document.
type GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the rejection reason when the state
	// is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentRevisionHumanReview
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentShardInfo: For a large document,
// sharding may be performed to produce several document shards. Each
// document shard contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1beta2DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`

	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`

	// TextOffset: The index of the first character in Document.text in the
	// overall document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShardCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentShardInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentStyle: Annotation for common text
// style attributes. This adheres to CSS conventions as much as
// possible.
type GoogleCloudDocumentaiV1beta2DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`

	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`

	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1beta2DocumentStyleFontSize `json:"fontSize,omitempty"`

	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible
	// values are `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`

	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
	// Follows CSS standard.
	TextDecoration string `json:"textDecoration,omitempty"`

	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible
	// values are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentStyleFontSize: Font size with
// unit.
type GoogleCloudDocumentaiV1beta2DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`

	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`,
	// and `pt`).
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Size") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Size") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyleFontSize
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1beta2DocumentTextAnchor: Text reference
// indexing into the Document.text.
type GoogleCloudDocumentaiV1beta2DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not
	// have to look it up in the text_segments. It is always populated for
	// formFields.
	Content string `json:"content,omitempty"`

	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment: A text
// segment in the Document.text. The indices may be out of bounds which
// indicate that the text extends into another document shard for large
// sharded documents. See ShardInfo.text_offset
type GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the
	// Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`

	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextAnchorTextSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2DocumentTextChange: This message is used
// for text changes aka. OCR corrections.
type GoogleCloudDocumentaiV1beta2DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`

	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1beta2DocumentProvenance `json:"provenance,omitempty"`

	// TextAnchor: Provenance of the correction. Text anchor indexing into
	// the Document.text. There can only be a single
	// `TextAnchor.text_segments` element. If the start and end index of the
	// text segment are the same, the text change is inserted before that
	// index.
	TextAnchor *GoogleCloudDocumentaiV1beta2DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangedText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2DocumentTextChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2GcsDestination: The Google Cloud Storage
// location where the output file will be written to.
type GoogleCloudDocumentaiV1beta2GcsDestination struct {
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2GcsDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2GcsSource: The Google Cloud Storage
// location where the input file will be read from.
type GoogleCloudDocumentaiV1beta2GcsSource struct {
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2GcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2InputConfig: The desired input location
// and metadata.
type GoogleCloudDocumentaiV1beta2InputConfig struct {
	// Contents: Content in bytes, represented as a stream of bytes. Note:
	// As with all `bytes` fields, proto buffer messages use a pure binary
	// representation, whereas JSON representations use base64. This field
	// only works for synchronous ProcessDocument method.
	Contents string `json:"contents,omitempty"`

	// GcsSource: The Google Cloud Storage location to read the input from.
	// This must be a single file.
	GcsSource *GoogleCloudDocumentaiV1beta2GcsSource `json:"gcsSource,omitempty"`

	// MimeType: Required. Mimetype of the input. Current supported
	// mimetypes are application/pdf, image/tiff, and image/gif. In
	// addition, application/json type is supported for requests with
	// ProcessDocumentRequest.automl_params field set. The JSON file needs
	// to be in Document format.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2InputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2NormalizedVertex: A vertex represents a
// 2D point in the image. NOTE: the normalized vertex coordinates are
// relative to the original image and range from 0 to 1.
type GoogleCloudDocumentaiV1beta2NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2NormalizedVertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta2NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta2NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1beta2OperationMetadata: Contains metadata for
// the BatchProcessDocuments operation.
type GoogleCloudDocumentaiV1beta2OperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "ACCEPTED" - Request is received.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2OutputConfig: The desired output location
// and metadata.
type GoogleCloudDocumentaiV1beta2OutputConfig struct {
	// GcsDestination: The Google Cloud Storage location to write the output
	// to.
	GcsDestination *GoogleCloudDocumentaiV1beta2GcsDestination `json:"gcsDestination,omitempty"`

	// PagesPerShard: The max number of pages to include into each output
	// Document shard JSON on Google Cloud Storage. The valid range is [1,
	// 100]. If not specified, the default value is 20. For example, for one
	// pdf file with 100 pages, 100 parsed pages will be produced. If
	// `pages_per_shard` = 20, then 5 Document shard JSON files each
	// containing 20 parsed pages will be written under the prefix
	// OutputConfig.gcs_destination.uri and suffix pages-x-to-y.json where x
	// and y are 1-indexed page numbers. Example GCS outputs with 157 pages
	// and pages_per_shard = 50: pages-001-to-050.json pages-051-to-100.json
	// pages-101-to-150.json pages-151-to-157.json
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2OutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2ProcessDocumentResponse: Response to a
// single document processing request.
type GoogleCloudDocumentaiV1beta2ProcessDocumentResponse struct {
	// InputConfig: Information about the input file. This is the same as
	// the corresponding input config in the request.
	InputConfig *GoogleCloudDocumentaiV1beta2InputConfig `json:"inputConfig,omitempty"`

	// OutputConfig: The output location of the parsed responses. The
	// responses are written to this location as JSON-serialized `Document`
	// objects.
	OutputConfig *GoogleCloudDocumentaiV1beta2OutputConfig `json:"outputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2ProcessDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2ProcessDocumentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta2Vertex: A vertex represents a 2D point in
// the image. NOTE: the vertex coordinates are in the same scale as the
// original image.
type GoogleCloudDocumentaiV1beta2Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta2Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta2Vertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Barcode: Encodes the detailed information
// of a barcode.
type GoogleCloudDocumentaiV1beta3Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`:
	// Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type.
	// - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. -
	// `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. -
	// `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E
	// type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. -
	// `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`

	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`

	// ValueFormat: Value format describes the format of the value that a
	// barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact
	// information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. -
	// `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. -
	// `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi
	// information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar
	// event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Barcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDatasetDocuments: Dataset documents
// that the batch operation will be applied to.
type GoogleCloudDocumentaiV1beta3BatchDatasetDocuments struct {
	// Filter: A filter matching the documents. Follows the same format and
	// restriction as
	// [google.cloud.documentai.master.ListDocumentsRequest.filter].
	Filter string `json:"filter,omitempty"`

	// IndividualDocumentIds: Document identifiers.
	IndividualDocumentIds *GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds `json:"individualDocumentIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDatasetDocuments) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDatasetDocuments
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds
// : List of individual DocumentIds.
type GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds struct {
	// DocumentIds: Required. List of Document IDs indicating where the
	// actual documents are stored.
	DocumentIds []*GoogleCloudDocumentaiV1beta3DocumentId `json:"documentIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentIds") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ErrorDocumentCount: Total number of documents that failed to be
	// deleted in storage.
	ErrorDocumentCount int64 `json:"errorDocumentCount,omitempty"`

	// IndividualBatchDeleteStatuses: The list of response details of each
	// document.
	IndividualBatchDeleteStatuses []*GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus `json:"individualBatchDeleteStatuses,omitempty"`

	// TotalDocumentCount: Total number of documents deleting from dataset.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatc
// hDeleteStatus: The status of each individual document in the batch
// delete process.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus struct {
	// DocumentId: The document id of the document.
	DocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"documentId,omitempty"`

	// Status: The status of deleting the document in storage.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest struct {
	// DatasetDocuments: Required. Dataset documents input. If given
	// `filter`, all documents satisfying the filter will be deleted. If
	// given documentIds, a maximum of 50 documents can be deleted in a
	// batch. The request will be rejected if more than 50 document_ids are
	// provided.
	DatasetDocuments *GoogleCloudDocumentaiV1beta3BatchDatasetDocuments `json:"datasetDocuments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DatasetDocuments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetDocuments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse: Response of
// the delete documents operation.
type GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig: The common
// config to specify a set of documents used as input.
type GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig struct {
	// GcsDocuments: The set of documents individually specified on Cloud
	// Storage.
	GcsDocuments *GoogleCloudDocumentaiV1beta3GcsDocuments `json:"gcsDocuments,omitempty"`

	// GcsPrefix: The set of documents that match the specified Cloud
	// Storage `gcs_prefix`.
	GcsPrefix *GoogleCloudDocumentaiV1beta3GcsPrefix `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDocuments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDocuments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadata: The long-running
// operation metadata for BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// IndividualProcessStatuses: The list of response details of each
	// document.
	IndividualProcessStatuses []*GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus `json:"individualProcessStatuses,omitempty"`

	// State: The state of the current batch processing.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "WAITING" - Request operation is waiting for scheduling.
	//   "RUNNING" - Request is being processed.
	//   "SUCCEEDED" - The batch processing completed successfully.
	//   "CANCELLING" - The batch processing was being cancelled.
	//   "CANCELLED" - The batch processing was cancelled.
	//   "FAILED" - The batch processing has failed.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the error message if the operation
	// is failed.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchProcessMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatu
// s: The status of a each individual document in the batch process.
type GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the
	// processed document. If the human review process isn't triggered, this
	// field will be empty. It has the same response type and metadata as
	// the long-running operation returned by the ReviewDocument method.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`

	// HumanReviewStatus: The status of human review on the processed
	// document.
	HumanReviewStatus *GoogleCloudDocumentaiV1beta3HumanReviewStatus `json:"humanReviewStatus,omitempty"`

	// InputGcsSource: The source of the document, same as the
	// input_gcs_source field in the request when the batch process started.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// OutputGcsDestination: The Cloud Storage output destination (in the
	// request as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the
	// processed document if it was successful, otherwise empty.
	OutputGcsDestination string `json:"outputGcsDestination,omitempty"`

	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HumanReviewOperation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HumanReviewOperation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessRequest: Request message for
// BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessRequest struct {
	// DocumentOutputConfig: The output configuration for the
	// BatchProcessDocuments method.
	DocumentOutputConfig *GoogleCloudDocumentaiV1beta3DocumentOutputConfig `json:"documentOutputConfig,omitempty"`

	// InputConfigs: The input config for each single document in the batch
	// process.
	InputConfigs []*GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig `json:"inputConfigs,omitempty"`

	// InputDocuments: The input documents for the BatchProcessDocuments
	// method.
	InputDocuments *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig `json:"inputDocuments,omitempty"`

	// Labels: Optional. The labels with user-defined metadata for the
	// request. Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. Label values are optional. Label keys must start with a
	// letter.
	Labels map[string]string `json:"labels,omitempty"`

	// OutputConfig: The overall output config for batch process.
	OutputConfig *GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig `json:"outputConfig,omitempty"`

	// ProcessOptions: Inference-time options for the process API
	ProcessOptions *GoogleCloudDocumentaiV1beta3ProcessOptions `json:"processOptions,omitempty"`

	// SkipHumanReview: Whether human review should be skipped for this
	// request. Default to `false`.
	SkipHumanReview bool `json:"skipHumanReview,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DocumentOutputConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentOutputConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchProcessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig: The
// message for input config in batch process.
type GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig struct {
	// GcsSource: The Cloud Storage location as the source of the document.
	GcsSource string `json:"gcsSource,omitempty"`

	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) of
	// the input. If the input is a raw document, refer to supported file
	// types (https://cloud.google.com/document-ai/docs/file-types) for the
	// list of media types. If the input is a Document, the type should be
	// `application/json`.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig: The
// output configuration in the BatchProcessDocuments method.
type GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig struct {
	// GcsDestination: The output Cloud Storage directory to put the
	// processed documents.
	GcsDestination string `json:"gcsDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3BatchProcessResponse: Response message
// for BatchProcessDocuments.
type GoogleCloudDocumentaiV1beta3BatchProcessResponse struct {
}

// GoogleCloudDocumentaiV1beta3BoundingPoly: A bounding polygon for the
// detected image annotation.
type GoogleCloudDocumentaiV1beta3BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1beta3NormalizedVertex `json:"normalizedVertices,omitempty"`

	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1beta3Vertex `json:"vertices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NormalizedVertices")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NormalizedVertices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3BoundingPoly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3CommonOperationMetadata: The common
// metadata for long running operations.
type GoogleCloudDocumentaiV1beta3CommonOperationMetadata struct {
	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// Resource: A related resource to this operation.
	Resource string `json:"resource,omitempty"`

	// State: The state of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3CommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3CommonOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Dataset: A singleton resource under a
// Processor which configures a collection of documents.
type GoogleCloudDocumentaiV1beta3Dataset struct {
	// DocumentWarehouseConfig: Optional. Deprecated. Warehouse-based
	// dataset configuration is not supported.
	DocumentWarehouseConfig *GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig `json:"documentWarehouseConfig,omitempty"`

	// GcsManagedConfig: Optional. User-managed Cloud Storage dataset
	// configuration. Use this configuration if the dataset documents are
	// stored under a user-managed Cloud Storage location.
	GcsManagedConfig *GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig `json:"gcsManagedConfig,omitempty"`

	// Name: Dataset resource name. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/datase
	// t`
	Name string `json:"name,omitempty"`

	// SpannerIndexingConfig: Optional. A lightweight indexing source with
	// low latency and high reliability, but lacking advanced features like
	// CMEK and content-based search.
	SpannerIndexingConfig *GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig `json:"spannerIndexingConfig,omitempty"`

	// State: Required. State of the dataset. Ignored when updating dataset.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified enum, should not be used.
	//   "UNINITIALIZED" - Dataset has not been initialized.
	//   "INITIALIZING" - Dataset is being initialized.
	//   "INITIALIZED" - Dataset has been initialized.
	State string `json:"state,omitempty"`

	// UnmanagedDatasetConfig: Optional. Unmanaged dataset configuration.
	// Use this configuration if the dataset documents are managed by the
	// document service internally (not user-managed).
	UnmanagedDatasetConfig *GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig `json:"unmanagedDatasetConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DocumentWarehouseConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentWarehouseConfig")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Dataset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig:
// Configuration specific to the Document AI Warehouse-based
// implementation.
type GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig struct {
	// Collection: Output only. The collection in Document AI Warehouse
	// associated with the dataset.
	Collection string `json:"collection,omitempty"`

	// Schema: Output only. The schema in Document AI Warehouse associated
	// with the dataset.
	Schema string `json:"schema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Collection") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig: Configuration
// specific to the Cloud Storage-based implementation.
type GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig struct {
	// GcsPrefix: Required. The Cloud Storage URI (a directory) where the
	// documents belonging to the dataset must be stored.
	GcsPrefix *GoogleCloudDocumentaiV1beta3GcsPrefix `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetSchema: Dataset Schema.
type GoogleCloudDocumentaiV1beta3DatasetSchema struct {
	// DocumentSchema: Optional. Schema of the dataset.
	DocumentSchema *GoogleCloudDocumentaiV1beta3DocumentSchema `json:"documentSchema,omitempty"`

	// Name: Dataset schema resource name. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/datase
	// t/datasetSchema`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DocumentSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentSchema") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DatasetSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DatasetSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig:
// Configuration specific to spanner-based indexing.
type GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig struct {
}

// GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig:
// Configuration specific to an unmanaged dataset.
type GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig struct {
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata: The long-running
// operation metadata for the DeleteProcessor method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata: The
// long-running operation metadata for the DeleteProcessorVersion
// method.
type GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata: The
// long-running operation metadata for the DeployProcessorVersion
// method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest: Request
// message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest struct {
}

// GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse: Response
// message for the DeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3DisableProcessorMetadata: The
// long-running operation metadata for the DisableProcessor method.
type GoogleCloudDocumentaiV1beta3DisableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DisableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DisableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DisableProcessorRequest: Request message
// for the DisableProcessor method.
type GoogleCloudDocumentaiV1beta3DisableProcessorRequest struct {
}

// GoogleCloudDocumentaiV1beta3DisableProcessorResponse: Response
// message for the DisableProcessor method. Intentionally empty proto
// for adding fields in future.
type GoogleCloudDocumentaiV1beta3DisableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3Document: Document represents the
// canonical document resource in Document AI. It is an interchange
// format that provides insights into documents and allows for
// collaboration between users and Document AI to iterate and optimize
// for quality.
type GoogleCloudDocumentaiV1beta3Document struct {
	// Content: Optional. Inline document content, represented as a stream
	// of bytes. Note: As with all `bytes` fields, protobuffers use a pure
	// binary representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`

	// Entities: A list of entities detected on Document.text. For document
	// shards, entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1beta3DocumentEntity `json:"entities,omitempty"`

	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1beta3DocumentEntityRelation `json:"entityRelations,omitempty"`

	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`

	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1beta3DocumentPage `json:"pages,omitempty"`

	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1beta3DocumentRevision `json:"revisions,omitempty"`

	// ShardInfo: Information about the sharding if this document is sharded
	// part of a larger document. If the document is not sharded, this
	// message is not specified.
	ShardInfo *GoogleCloudDocumentaiV1beta3DocumentShardInfo `json:"shardInfo,omitempty"`

	// Text: Optional. UTF-8 encoded text in reading order from the
	// document.
	Text string `json:"text,omitempty"`

	// TextChanges: Placeholder. A list of text corrections made to
	// Document.text. This is usually used for annotating corrections to OCR
	// mistakes. Text changes for a given revision may not overlap with each
	// other.
	TextChanges []*GoogleCloudDocumentaiV1beta3DocumentTextChange `json:"textChanges,omitempty"`

	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1beta3DocumentStyle `json:"textStyles,omitempty"`

	// Uri: Optional. Currently supports Google Cloud Storage URI of the
	// form `gs://bucket_name/object_name`. Object versioning is not
	// supported. For more information, refer to Google Cloud Storage
	// Request URIs (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Document
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentEntity: An entity that could be a
// phrase in the text or a property that belongs to the document. It is
// a known entity type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1beta3DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range
	// `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Id: Optional. Canonical id. This will be a unique value in the entity
	// list for this document.
	Id string `json:"id,omitempty"`

	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`

	// MentionText: Optional. Text value of the entity e.g. `1600
	// Amphitheatre Pkwy`.
	MentionText string `json:"mentionText,omitempty"`

	// NormalizedValue: Optional. Normalized entity value. Absent if the
	// extracted value could not be converted or the type (e.g. address) is
	// not supported for certain parsers. This field is also only populated
	// for certain supported document types.
	NormalizedValue *GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`

	// PageAnchor: Optional. Represents the provenance of this entity wrt.
	// the location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1beta3DocumentPageAnchor `json:"pageAnchor,omitempty"`

	// Properties: Optional. Entities can be nested to form a hierarchical
	// data structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1beta3DocumentEntity `json:"properties,omitempty"`

	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`

	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing
	// into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta3DocumentTextAnchor `json:"textAnchor,omitempty"`

	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue: Parsed and
// normalized entity value.
type GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`

	// BooleanValue: Boolean value. Can be used for entities with binary
	// values, or for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`

	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`

	// DatetimeValue: DateTime value. Includes date, time, and timezone. See
	// also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`

	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`

	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`

	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`

	// Text: Optional. An optional field to store a normalized string. For
	// some entity types, one of respective `structured_value` fields may
	// also be populated. Also not all the types of `structured_value` will
	// be normalized. For example, some processors may not generate `float`
	// or `integer` normalized text by default. Below are sample formats
	// mapped to structured values. - Money/Currency type (`money_value`) is
	// in the ISO 4217 text format. - Date type (`date_value`) is in the ISO
	// 8601 text format. - Datetime type (`datetime_value`) is in the ISO
	// 8601 text format.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentEntityRelation: Relationship
// between Entities.
type GoogleCloudDocumentaiV1beta3DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`

	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`

	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentEntityRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentId: Document Identifier.
type GoogleCloudDocumentaiV1beta3DocumentId struct {
	// GcsManagedDocId: A document id within user-managed Cloud Storage.
	GcsManagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId `json:"gcsManagedDocId,omitempty"`

	// RevisionRef: Points to a specific revision of the document if set.
	RevisionRef *GoogleCloudDocumentaiV1beta3RevisionRef `json:"revisionRef,omitempty"`

	// UnmanagedDocId: A document id within unmanaged dataset.
	UnmanagedDocId *GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId `json:"unmanagedDocId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsManagedDocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsManagedDocId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId:
// Identifies a document uniquely within the scope of a dataset in the
// user-managed Cloud Storage option.
type GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId struct {
	// CwDocId: Id of the document (indexed) managed by Content Warehouse.
	CwDocId string `json:"cwDocId,omitempty"`

	// GcsUri: Required. The Cloud Storage URI where the actual document is
	// stored.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CwDocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CwDocId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId: Identifies
// a document uniquely within the scope of a dataset in unmanaged
// option.
type GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId struct {
	// DocId: Required. The id of the document.
	DocId string `json:"docId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentMetadata: Metadata about a
// document.
type GoogleCloudDocumentaiV1beta3DocumentMetadata struct {
	// DatasetType: Type of the dataset split to which the document belongs.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not
	// set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DatasetType string `json:"datasetType,omitempty"`

	// DisplayName: The display name of the document.
	DisplayName string `json:"displayName,omitempty"`

	// DocumentId: Document identifier.
	DocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"documentId,omitempty"`

	// LabelingState: Labeling state of the document.
	//
	// Possible values:
	//   "DOCUMENT_LABELING_STATE_UNSPECIFIED" - Default value if the enum
	// is not set.
	//   "DOCUMENT_LABELED" - Document has been labeled.
	//   "DOCUMENT_UNLABELED" - Document has not been labeled.
	//   "DOCUMENT_AUTO_LABELED" - Document has been auto-labeled.
	LabelingState string `json:"labelingState,omitempty"`

	// PageCount: Number of pages in the document.
	PageCount int64 `json:"pageCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DatasetType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentOutputConfig: Config that
// controls the output of documents. All documents will be written as a
// JSON file.
type GoogleCloudDocumentaiV1beta3DocumentOutputConfig struct {
	// GcsOutputConfig: Output config to write the results to Cloud Storage.
	GcsOutputConfig *GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig `json:"gcsOutputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsOutputConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsOutputConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig: The
// configuration used when outputting documents.
type GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig struct {
	// FieldMask: Specifies which fields to include in the output documents.
	// Only supports top level document and pages field so it must be in the
	// form of `{document_field_name}` or `pages.{page_field_name}`.
	FieldMask string `json:"fieldMask,omitempty"`

	// GcsUri: The Cloud Storage uri (a directory) of the output.
	GcsUri string `json:"gcsUri,omitempty"`

	// ShardingConfig: Specifies the sharding config for the output
	// document.
	ShardingConfig *GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig `json:"shardingConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldMask") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldMask") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardin
// gConfig: The sharding config for the output document.
type GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig struct {
	// PagesOverlap: The number of overlapping pages between consecutive
	// shards.
	PagesOverlap int64 `json:"pagesOverlap,omitempty"`

	// PagesPerShard: The number of pages per shard.
	PagesPerShard int64 `json:"pagesPerShard,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PagesOverlap") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PagesOverlap") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1beta3DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block
	// has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*GoogleCloudDocumentaiV1beta3DocumentPageBlock `json:"blocks,omitempty"`

	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1beta3DocumentPageDimension `json:"dimension,omitempty"`

	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1beta3DocumentPageFormField `json:"formFields,omitempty"`

	// Image: Rendered image for this page. This image is preprocessed to
	// remove any skew, rotation, and distortions such that the annotation
	// bounding boxes can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1beta3DocumentPageImage `json:"image,omitempty"`

	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`

	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Lines: A list of visually detected text lines on the page. A
	// collection of tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1beta3DocumentPageLine `json:"lines,omitempty"`

	// PageNumber: 1-based index for current Page in a parent Document.
	// Useful when a page is taken out of a Document for individual
	// processing.
	PageNumber int64 `json:"pageNumber,omitempty"`

	// Paragraphs: A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1beta3DocumentPageParagraph `json:"paragraphs,omitempty"`

	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1beta3DocumentPageSymbol `json:"symbols,omitempty"`

	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1beta3DocumentPageTable `json:"tables,omitempty"`

	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1beta3DocumentPageToken `json:"tokens,omitempty"`

	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1beta3DocumentPageMatrix `json:"transforms,omitempty"`

	// VisualElements: A list of detected non-text visual elements e.g.
	// checkbox, signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1beta3DocumentPageVisualElement `json:"visualElements,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Blocks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageAnchor: Referencing the
// visual context of the entity in the Document.pages. Page anchors can
// be cross-page, consist of multiple bounding polygons and optionally
// reference specific layout element types.
type GoogleCloudDocumentaiV1beta3DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageRefs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef: Represents a
// weak reference to a page element within a document.
type GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout
	// element on the page.
	BoundingPoly *GoogleCloudDocumentaiV1beta3BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Optional. Confidence of detected page element, if
	// applicable. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`

	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`

	// Page: Required. Index into the Document.pages element, for example
	// using `Document.pages` to locate the related page element. This field
	// is skipped when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageBlock: A block has a set of
// lines (collected into paragraphs) that have a common line-spacing and
// orientation.
type GoogleCloudDocumentaiV1beta3DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageBlock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode: A detected
// barcode.
type GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1beta3Barcode `json:"barcode,omitempty"`

	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Barcode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Barcode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage: Detected
// language for a structural component.
type GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier),
	// such as `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageDimension: Dimension for the
// page.
type GoogleCloudDocumentaiV1beta3DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`

	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`

	// Width: Page width.
	Width float64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageFormField: A form field
// detected on the page.
type GoogleCloudDocumentaiV1beta3DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If
	// corrections were made to the text identified by the
	// `field_name.text_anchor`, this field will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`

	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`

	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`,
	// `Grand total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"fieldName,omitempty"`

	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"fieldValue,omitempty"`

	// NameDetectedLanguages: A list of detected languages for name together
	// with confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// ValueDetectedLanguages: A list of detected languages for value
	// together with confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`

	// ValueType: If the value is non-textual, this field represents the
	// type. Current valid values are: - blank (this indicates the
	// `field_value` is normal text) - `unfilled_checkbox` -
	// `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorrectedKeyText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageFormField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageImage: Rendered image
// contents for this page.
type GoogleCloudDocumentaiV1beta3DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`

	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`

	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for
	// the image.
	MimeType string `json:"mimeType,omitempty"`

	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores: Image
// quality scores for the page image.
type GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`

	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is
	// perfect quality.
	QualityScore float64 `json:"qualityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedDefects") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefe
// ct: Image Quality Defects
type GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`

	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` -
	// `quality/defect_dark` - `quality/defect_faint` -
	// `quality/defect_text_too_small` - `quality/defect_document_cutoff` -
	// `quality/defect_text_cutoff` - `quality/defect_glare`
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageLayout: Visual element
// describing a layout unit on a page.
type GoogleCloudDocumentaiV1beta3DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1beta3BoundingPoly `json:"boundingPoly,omitempty"`

	// Confidence: Confidence of the current Layout within context of the
	// object this layout is for. e.g. confidence can be for a single token,
	// a table, a visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`

	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the
	// head 90 degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head
	// 180 degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head
	// 90 degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta3DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoundingPoly") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageLayout
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageLine: A collection of tokens
// that a human would perceive as a line. Does not cross column
// boundaries, can be horizontal, vertical, etc.
type GoogleCloudDocumentaiV1beta3DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageLine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageMatrix: Representation for
// transformation matrix, intended to be compatible and used with OpenCV
// format for image manipulation.
type GoogleCloudDocumentaiV1beta3DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`

	// Data: The matrix data.
	Data string `json:"data,omitempty"`

	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`

	// Type: This encodes information about what data type the matrix uses.
	// For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
	// of OpenCV primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cols") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cols") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageMatrix
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageParagraph: A collection of
// lines that a human would perceive as a paragraph.
type GoogleCloudDocumentaiV1beta3DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageParagraph
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1beta3DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageSymbol
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageTable: A table representation
// similar to HTML table structure.
type GoogleCloudDocumentaiV1beta3DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow `json:"bodyRows,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow `json:"headerRows,omitempty"`

	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BodyRows") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTable
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell: A cell
// representation inside the table.
type GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColSpan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColSpan") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow: A row of table
// cells.
type GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell `json:"cells,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1beta3DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`

	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedBreak") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageToken
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak: Detected
// break at the end of a Token.
type GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split
	// across lines.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo: Font and
// other text style attributes.
type GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`

	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`

	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`

	// FontWeight: TrueType weight on a scale `100` (thin) to `1000`
	// (ultra-heavy). Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`

	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`

	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`

	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`

	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`

	// Smallcaps: Whether the text is in small caps.
	Smallcaps bool `json:"smallcaps,omitempty"`

	// Strikeout: Whether the text is strikethrough.
	Strikeout bool `json:"strikeout,omitempty"`

	// Subscript: Whether the text is a subscript.
	Subscript bool `json:"subscript,omitempty"`

	// Superscript: Whether the text is a superscript.
	Superscript bool `json:"superscript,omitempty"`

	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`

	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentPageVisualElement: Detected
// non-text visual elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1beta3DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with
	// confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`

	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1beta3DocumentPageLayout `json:"layout,omitempty"`

	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DetectedLanguages")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectedLanguages") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentPageVisualElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentProvenance: Structure to identify
// provenance relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1beta3DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of
	// the revision.
	Id int64 `json:"id,omitempty"`

	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1beta3DocumentProvenanceParent `json:"parents,omitempty"`

	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`

	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no
	// operation is specified a provenance entry is simply used to match
	// against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of
	// the message. It overwrites the fields rather than replacing them. Use
	// this when you want to update a field value of an entity without also
	// updating all the child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by
	// `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at
	// human review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation
	// process.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentProvenance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentProvenanceParent: The parent
// element the current element is based on. Used for
// referencing/aligning, removal and replacement operations.
type GoogleCloudDocumentaiV1beta3DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`

	// Index: The index of the parent item in the corresponding item list
	// (eg. list of entities, properties within entities, etc.) in the
	// parent revision.
	Index int64 `json:"index,omitempty"`

	// Revision: The index of the index into current revision's parent_ids
	// list.
	Revision int64 `json:"revision,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentProvenanceParent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentRevision: Contains past or
// forward revisions of this document.
type GoogleCloudDocumentaiV1beta3DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of
	// that person.
	Agent string `json:"agent,omitempty"`

	// CreateTime: The time that the revision was created, internally
	// generated by doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`

	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview `json:"humanReview,omitempty"`

	// Id: Id of the revision, internally generated by doc proto storage.
	// Unique within the context of the document.
	Id string `json:"id,omitempty"`

	// Parent: The revisions that this revision is based on. This can
	// include one or more parent (when documents are merged.) This field
	// represents the index into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`

	// ParentIds: The revisions that this revision is based on. Must include
	// all the ids that have anything to do with this revision - eg. there
	// are `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`

	// Processor: If the annotation was made by processor identify the
	// processor by its resource name.
	Processor string `json:"processor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Agent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview: Human Review
// information of the document.
type GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the rejection reason when the state
	// is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentSchema: The schema defines the
// output of the processed document by a processor.
type GoogleCloudDocumentaiV1beta3DocumentSchema struct {
	// Description: Description of the schema.
	Description string `json:"description,omitempty"`

	// DisplayName: Display name to show to users.
	DisplayName string `json:"displayName,omitempty"`

	// EntityTypes: Entity types of the schema.
	EntityTypes []*GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType `json:"entityTypes,omitempty"`

	// Metadata: Metadata of the schema.
	Metadata *GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType: EntityType is
// the wrapper of a label of the corresponding model with detailed
// attributes and limitations for entity-based processors. Multiple
// types can also compose a dependency tree to represent nested types.
type GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType struct {
	// BaseTypes: The entity type that this type is derived from. For now,
	// one and only one should be set.
	BaseTypes []string `json:"baseTypes,omitempty"`

	// DisplayName: User defined name for the type.
	DisplayName string `json:"displayName,omitempty"`

	// EntityTypeMetadata: Metadata for the entity type.
	EntityTypeMetadata *GoogleCloudDocumentaiV1beta3EntityTypeMetadata `json:"entityTypeMetadata,omitempty"`

	// EnumValues: If specified, lists all the possible values for this
	// entity. This should not be more than a handful of values. If the
	// number of values is >10 or could change frequently use the
	// `EntityType.value_ontology` field and specify a list of all possible
	// values in a value ontology file.
	EnumValues *GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues `json:"enumValues,omitempty"`

	// Name: Name of the type. It must be unique within the schema file and
	// cannot be a "Common Type". The following naming conventions are used:
	// - Use `snake_casing`. - Name matching is case-sensitive. - Maximum 64
	// characters. - Must start with a letter. - Allowed characters: ASCII
	// letters `[a-z0-9_-]`. (For backward compatibility internal
	// infrastructure and tooling can handle any ascii character.) - The `/`
	// is sometimes used to denote a property of a type. For example
	// `line_item/amount`. This convention is deprecated, but will still be
	// honored for backward compatibility.
	Name string `json:"name,omitempty"`

	// Properties: Description the nested structure, or composition of an
	// entity.
	Properties []*GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseTypes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues:
// Defines the a list of enum values.
type GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues struct {
	// Values: The individual values that this enum values type can include.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty: Defines
// properties that can be part of the entity type.
type GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty struct {
	// Name: The name of the property. Follows the same guidelines as the
	// EntityType name.
	Name string `json:"name,omitempty"`

	// OccurrenceType: Occurrence type limits the number of instances an
	// entity type appears in the document.
	//
	// Possible values:
	//   "OCCURRENCE_TYPE_UNSPECIFIED" - Unspecified occurrence type.
	//   "OPTIONAL_ONCE" - There will be zero or one instance of this entity
	// type. The same entity instance may be mentioned multiple times.
	//   "OPTIONAL_MULTIPLE" - The entity type will appear zero or multiple
	// times.
	//   "REQUIRED_ONCE" - The entity type will only appear exactly once.
	// The same entity instance may be mentioned multiple times.
	//   "REQUIRED_MULTIPLE" - The entity type will appear once or more
	// times.
	OccurrenceType string `json:"occurrenceType,omitempty"`

	// PropertyMetadata: Any additional metadata about the property can be
	// added here.
	PropertyMetadata *GoogleCloudDocumentaiV1beta3PropertyMetadata `json:"propertyMetadata,omitempty"`

	// ValueType: A reference to the value type of the property. This type
	// is subject to the same conventions as the `Entity.base_types` field.
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata: Metadata for
// global schema behavior.
type GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata struct {
	// DocumentAllowMultipleLabels: If true, on a given page, there can be
	// multiple `document` annotations covering it.
	DocumentAllowMultipleLabels bool `json:"documentAllowMultipleLabels,omitempty"`

	// DocumentSplitter: If true, a `document` entity type can be applied to
	// subdocument (splitting). Otherwise, it can only be applied to the
	// entire document (classification).
	DocumentSplitter bool `json:"documentSplitter,omitempty"`

	// PrefixedNamingOnProperties: If set, all the nested entities must be
	// prefixed with the parents.
	PrefixedNamingOnProperties bool `json:"prefixedNamingOnProperties,omitempty"`

	// SkipNamingValidation: If set, we will skip the naming format
	// validation in the schema. So the string values in
	// `DocumentSchema.EntityType.name` and
	// `DocumentSchema.EntityType.Property.name` will not be checked.
	SkipNamingValidation bool `json:"skipNamingValidation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DocumentAllowMultipleLabels") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DocumentAllowMultipleLabels") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentShardInfo: For a large document,
// sharding may be performed to produce several document shards. Each
// document shard contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1beta3DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`

	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`

	// TextOffset: The index of the first character in Document.text in the
	// overall document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ShardCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentShardInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentStyle: Annotation for common text
// style attributes. This adheres to CSS conventions as much as
// possible.
type GoogleCloudDocumentaiV1beta3DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`

	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`

	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1beta3DocumentStyleFontSize `json:"fontSize,omitempty"`

	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible
	// values are `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`

	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1beta3DocumentTextAnchor `json:"textAnchor,omitempty"`

	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
	// Follows CSS standard.
	TextDecoration string `json:"textDecoration,omitempty"`

	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible
	// values are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentStyleFontSize: Font size with
// unit.
type GoogleCloudDocumentaiV1beta3DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`

	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`,
	// and `pt`).
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Size") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Size") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentStyleFontSize
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1beta3DocumentTextAnchor: Text reference
// indexing into the Document.text.
type GoogleCloudDocumentaiV1beta3DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not
	// have to look it up in the text_segments. It is always populated for
	// formFields.
	Content string `json:"content,omitempty"`

	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentTextAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment: A text
// segment in the Document.text. The indices may be out of bounds which
// indicate that the text extends into another document shard for large
// sharded documents. See ShardInfo.text_offset
type GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the
	// Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`

	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3DocumentTextChange: This message is used
// for text changes aka. OCR corrections.
type GoogleCloudDocumentaiV1beta3DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`

	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1beta3DocumentProvenance `json:"provenance,omitempty"`

	// TextAnchor: Provenance of the correction. Text anchor indexing into
	// the Document.text. There can only be a single
	// `TextAnchor.text_segments` element. If the start and end index of the
	// text segment are the same, the text change is inserted before that
	// index.
	TextAnchor *GoogleCloudDocumentaiV1beta3DocumentTextAnchor `json:"textAnchor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangedText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3DocumentTextChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorMetadata: The long-running
// operation metadata for the EnableProcessor method.
type GoogleCloudDocumentaiV1beta3EnableProcessorMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EnableProcessorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EnableProcessorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EnableProcessorRequest: Request message
// for the EnableProcessor method.
type GoogleCloudDocumentaiV1beta3EnableProcessorRequest struct {
}

// GoogleCloudDocumentaiV1beta3EnableProcessorResponse: Response message
// for the EnableProcessor method. Intentionally empty proto for adding
// fields in future.
type GoogleCloudDocumentaiV1beta3EnableProcessorResponse struct {
}

// GoogleCloudDocumentaiV1beta3EntityTypeMetadata: Metadata about an
// entity type.
type GoogleCloudDocumentaiV1beta3EntityTypeMetadata struct {
	// Inactive: Whether the entity type should be considered inactive.
	Inactive bool `json:"inactive,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Inactive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inactive") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EntityTypeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EntityTypeMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata:
// Metadata of the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest:
// Evaluates the given ProcessorVersion against the supplied documents.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest struct {
	// EvaluationDocuments: Optional. The documents used in the evaluation.
	// If unspecified, use the processor's dataset as evaluation input.
	EvaluationDocuments *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig `json:"evaluationDocuments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EvaluationDocuments")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EvaluationDocuments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse:
// Response of the EvaluateProcessorVersion method.
type GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse struct {
	// Evaluation: The resource name of the created evaluation.
	Evaluation string `json:"evaluation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Evaluation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Evaluation: An evaluation of a
// ProcessorVersion's performance.
type GoogleCloudDocumentaiV1beta3Evaluation struct {
	// AllEntitiesMetrics: Metrics for all the entities in aggregate.
	AllEntitiesMetrics *GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics `json:"allEntitiesMetrics,omitempty"`

	// CreateTime: The time that the evaluation was created.
	CreateTime string `json:"createTime,omitempty"`

	// DocumentCounters: Counters for the documents used in the evaluation.
	DocumentCounters *GoogleCloudDocumentaiV1beta3EvaluationCounters `json:"documentCounters,omitempty"`

	// EntityMetrics: Metrics across confidence levels, for different
	// entities.
	EntityMetrics map[string]GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics `json:"entityMetrics,omitempty"`

	// KmsKeyName: The KMS key name used for encryption.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// KmsKeyVersionName: The KMS key version with which data is encrypted.
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`

	// Name: The resource name of the evaluation. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processor_version}/evaluations/{evaluation}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AllEntitiesMetrics")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllEntitiesMetrics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Evaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Evaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics:
// Evaluations metrics, at a specific confidence level.
type GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics struct {
	// ConfidenceLevel: The confidence level.
	ConfidenceLevel float64 `json:"confidenceLevel,omitempty"`

	// Metrics: The metrics at the specific confidence level.
	Metrics *GoogleCloudDocumentaiV1beta3EvaluationMetrics `json:"metrics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceLevel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceLevel") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics
	var s1 struct {
		ConfidenceLevel gensupport.JSONFloat64 `json:"confidenceLevel"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceLevel = float64(s1.ConfidenceLevel)
	return nil
}

// GoogleCloudDocumentaiV1beta3EvaluationCounters: Evaluation counters
// for the documents that were used.
type GoogleCloudDocumentaiV1beta3EvaluationCounters struct {
	// EvaluatedDocumentsCount: How many documents were used in the
	// evaluation.
	EvaluatedDocumentsCount int64 `json:"evaluatedDocumentsCount,omitempty"`

	// FailedDocumentsCount: How many documents were not included in the
	// evaluation as Document AI failed to process them.
	FailedDocumentsCount int64 `json:"failedDocumentsCount,omitempty"`

	// InputDocumentsCount: How many documents were sent for evaluation.
	InputDocumentsCount int64 `json:"inputDocumentsCount,omitempty"`

	// InvalidDocumentsCount: How many documents were not included in the
	// evaluation as they didn't pass validation.
	InvalidDocumentsCount int64 `json:"invalidDocumentsCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EvaluatedDocumentsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EvaluatedDocumentsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationCounters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationCounters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3EvaluationMetrics: Evaluation metrics,
// either in aggregate or about a specific entity.
type GoogleCloudDocumentaiV1beta3EvaluationMetrics struct {
	// F1Score: The calculated f1 score.
	F1Score float64 `json:"f1Score,omitempty"`

	// FalseNegativesCount: The amount of false negatives.
	FalseNegativesCount int64 `json:"falseNegativesCount,omitempty"`

	// FalsePositivesCount: The amount of false positives.
	FalsePositivesCount int64 `json:"falsePositivesCount,omitempty"`

	// GroundTruthDocumentCount: The amount of documents with a ground truth
	// occurrence.
	GroundTruthDocumentCount int64 `json:"groundTruthDocumentCount,omitempty"`

	// GroundTruthOccurrencesCount: The amount of occurrences in ground
	// truth documents.
	GroundTruthOccurrencesCount int64 `json:"groundTruthOccurrencesCount,omitempty"`

	// Precision: The calculated precision.
	Precision float64 `json:"precision,omitempty"`

	// PredictedDocumentCount: The amount of documents with a predicted
	// occurrence.
	PredictedDocumentCount int64 `json:"predictedDocumentCount,omitempty"`

	// PredictedOccurrencesCount: The amount of occurrences in predicted
	// documents.
	PredictedOccurrencesCount int64 `json:"predictedOccurrencesCount,omitempty"`

	// Recall: The calculated recall.
	Recall float64 `json:"recall,omitempty"`

	// TotalDocumentsCount: The amount of documents that had an occurrence
	// of this label.
	TotalDocumentsCount int64 `json:"totalDocumentsCount,omitempty"`

	// TruePositivesCount: The amount of true positives.
	TruePositivesCount int64 `json:"truePositivesCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "F1Score") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "F1Score") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationMetrics
	var s1 struct {
		F1Score   gensupport.JSONFloat64 `json:"f1Score"`
		Precision gensupport.JSONFloat64 `json:"precision"`
		Recall    gensupport.JSONFloat64 `json:"recall"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.F1Score = float64(s1.F1Score)
	s.Precision = float64(s1.Precision)
	s.Recall = float64(s1.Recall)
	return nil
}

// GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics: Metrics
// across multiple confidence levels.
type GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics struct {
	// Auprc: The calculated area under the precision recall curve (AUPRC),
	// computed by integrating over all confidence thresholds.
	Auprc float64 `json:"auprc,omitempty"`

	// AuprcExact: The AUPRC for metrics with fuzzy matching disabled, i.e.,
	// exact matching only.
	AuprcExact float64 `json:"auprcExact,omitempty"`

	// ConfidenceLevelMetrics: Metrics across confidence levels with fuzzy
	// matching enabled.
	ConfidenceLevelMetrics []*GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics `json:"confidenceLevelMetrics,omitempty"`

	// ConfidenceLevelMetricsExact: Metrics across confidence levels with
	// only exact matching.
	ConfidenceLevelMetricsExact []*GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics `json:"confidenceLevelMetricsExact,omitempty"`

	// EstimatedCalibrationError: The Estimated Calibration Error (ECE) of
	// the confidence of the predicted entities.
	EstimatedCalibrationError float64 `json:"estimatedCalibrationError,omitempty"`

	// EstimatedCalibrationErrorExact: The ECE for the predicted entities
	// with fuzzy matching disabled, i.e., exact matching only.
	EstimatedCalibrationErrorExact float64 `json:"estimatedCalibrationErrorExact,omitempty"`

	// MetricsType: The metrics type for the label.
	//
	// Possible values:
	//   "METRICS_TYPE_UNSPECIFIED" - The metrics type is unspecified. By
	// default, metrics without a particular specification are for leaf
	// entity types (i.e., top-level entity types without child types, or
	// child types which are not parent types themselves).
	//   "AGGREGATE" - Indicates whether metrics for this particular label
	// type represent an aggregate of metrics for other types instead of
	// being based on actual TP/FP/FN values for the label type. Metrics for
	// parent (i.e., non-leaf) entity types are an aggregate of metrics for
	// their children.
	MetricsType string `json:"metricsType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Auprc") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Auprc") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics
	var s1 struct {
		Auprc                          gensupport.JSONFloat64 `json:"auprc"`
		AuprcExact                     gensupport.JSONFloat64 `json:"auprcExact"`
		EstimatedCalibrationError      gensupport.JSONFloat64 `json:"estimatedCalibrationError"`
		EstimatedCalibrationErrorExact gensupport.JSONFloat64 `json:"estimatedCalibrationErrorExact"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Auprc = float64(s1.Auprc)
	s.AuprcExact = float64(s1.AuprcExact)
	s.EstimatedCalibrationError = float64(s1.EstimatedCalibrationError)
	s.EstimatedCalibrationErrorExact = float64(s1.EstimatedCalibrationErrorExact)
	return nil
}

// GoogleCloudDocumentaiV1beta3EvaluationReference: Gives a short
// summary of an evaluation, and links to the evaluation itself.
type GoogleCloudDocumentaiV1beta3EvaluationReference struct {
	// AggregateMetrics: An aggregate of the statistics for the evaluation
	// with fuzzy matching on.
	AggregateMetrics *GoogleCloudDocumentaiV1beta3EvaluationMetrics `json:"aggregateMetrics,omitempty"`

	// AggregateMetricsExact: An aggregate of the statistics for the
	// evaluation with fuzzy matching off.
	AggregateMetricsExact *GoogleCloudDocumentaiV1beta3EvaluationMetrics `json:"aggregateMetricsExact,omitempty"`

	// Evaluation: The resource name of the evaluation.
	Evaluation string `json:"evaluation,omitempty"`

	// Operation: The resource name of the Long Running Operation for the
	// evaluation.
	Operation string `json:"operation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregateMetrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregateMetrics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3EvaluationReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3EvaluationReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse: Response
// message for the FetchProcessorTypes method.
type GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse struct {
	// ProcessorTypes: The list of processor types.
	ProcessorTypes []*GoogleCloudDocumentaiV1beta3ProcessorType `json:"processorTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ProcessorTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3FieldExtractionMetadata: Metadata for how
// this field value is extracted.
type GoogleCloudDocumentaiV1beta3FieldExtractionMetadata struct {
	// SummaryOptions: Summary options config.
	SummaryOptions *GoogleCloudDocumentaiV1beta3SummaryOptions `json:"summaryOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SummaryOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SummaryOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3FieldExtractionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3FieldExtractionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3GcsDocument: Specifies a document stored
// on Cloud Storage.
type GoogleCloudDocumentaiV1beta3GcsDocument struct {
	// GcsUri: The Cloud Storage object uri.
	GcsUri string `json:"gcsUri,omitempty"`

	// MimeType: An IANA MIME type (RFC6838) of the content.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3GcsDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GcsDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3GcsDocuments: Specifies a set of
// documents on Cloud Storage.
type GoogleCloudDocumentaiV1beta3GcsDocuments struct {
	// Documents: The list of documents.
	Documents []*GoogleCloudDocumentaiV1beta3GcsDocument `json:"documents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Documents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3GcsDocuments) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GcsDocuments
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3GcsPrefix: Specifies all documents on
// Cloud Storage with a common prefix.
type GoogleCloudDocumentaiV1beta3GcsPrefix struct {
	// GcsUriPrefix: The URI prefix.
	GcsUriPrefix string `json:"gcsUriPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsUriPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsUriPrefix") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3GcsPrefix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GcsPrefix
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3GetDocumentResponse struct {
	Document *GoogleCloudDocumentaiV1beta3Document `json:"document,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3GetDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3GetDocumentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3HumanReviewStatus: The status of human
// review on a processed document.
type GoogleCloudDocumentaiV1beta3HumanReviewStatus struct {
	// HumanReviewOperation: The name of the operation triggered by the
	// processed document. This field is populated only when the state is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and
	// metadata as the long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`

	// State: The state of human review on the processing request.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Human review state is unspecified. Most
	// likely due to an internal error.
	//   "SKIPPED" - Human review is skipped for the document. This can
	// happen because human review isn't enabled on the processor or the
	// processing request has been set to skip this document.
	//   "VALIDATION_PASSED" - Human review validation is triggered and
	// passed, so no review is needed.
	//   "IN_PROGRESS" - Human review validation is triggered and the
	// document is under review.
	//   "ERROR" - Some error happened during triggering human review, see
	// the state_message for details.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the human review
	// state.
	StateMessage string `json:"stateMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HumanReviewOperation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HumanReviewOperation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3HumanReviewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3HumanReviewStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata: Metadata of the
// import document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ImportConfigValidationResults: Validation statuses of the batch
	// documents import config.
	ImportConfigValidationResults []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult `json:"importConfigValidationResults,omitempty"`

	// IndividualImportStatuses: The list of response details of each
	// document.
	IndividualImportStatuses []*GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus `json:"individualImportStatuses,omitempty"`

	// TotalDocumentCount: Total number of the documents that are qualified
	// for importing.
	TotalDocumentCount int64 `json:"totalDocumentCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidat
// ionResult: The validation status of each import config. Status is set
// to an error if there are no documents to import in the
// `import_config`, or `OK` if the operation will try to proceed with at
// least one document.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult struct {
	// InputGcsSource: The source Cloud Storage URI specified in the import
	// config.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// Status: The validation status of import config.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputGcsSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportSta
// tus: The status of each individual document in the import process.
type GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus struct {
	// InputGcsSource: The source Cloud Storage URI of the document.
	InputGcsSource string `json:"inputGcsSource,omitempty"`

	// OutputDocumentId: The document id of imported document if it was
	// successful, otherwise empty.
	OutputDocumentId *GoogleCloudDocumentaiV1beta3DocumentId `json:"outputDocumentId,omitempty"`

	// Status: The status of the importing of the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputGcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputGcsSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3ImportDocumentsRequest struct {
	// BatchDocumentsImportConfigs: Required. The Cloud Storage uri
	// containing raw documents that must be imported.
	BatchDocumentsImportConfigs []*GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig `json:"batchDocumentsImportConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BatchDocumentsImportConfigs") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BatchDocumentsImportConfigs") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImport
// Config: Config for importing documents. Each batch can have its own
// dataset split type.
type GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig struct {
	// AutoSplitConfig: If set, documents will be automatically split into
	// training and test split category with the specified ratio.
	AutoSplitConfig *GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig `json:"autoSplitConfig,omitempty"`

	// BatchInputConfig: The common config to specify a set of documents
	// used as input.
	BatchInputConfig *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig `json:"batchInputConfig,omitempty"`

	// DatasetSplit: Target dataset split where the documents must be
	// stored.
	//
	// Possible values:
	//   "DATASET_SPLIT_TYPE_UNSPECIFIED" - Default value if the enum is not
	// set.
	//   "DATASET_SPLIT_TRAIN" - Identifies the train documents.
	//   "DATASET_SPLIT_TEST" - Identifies the test documents.
	//   "DATASET_SPLIT_UNASSIGNED" - Identifies the unassigned documents.
	DatasetSplit string `json:"datasetSplit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoSplitConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoSplitConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImport
// ConfigAutoSplitConfig: The config for auto-split.
type GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig struct {
	// TrainingSplitRatio: Ratio of training dataset split.
	TrainingSplitRatio float64 `json:"trainingSplitRatio,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TrainingSplitRatio")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TrainingSplitRatio") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig
	var s1 struct {
		TrainingSplitRatio gensupport.JSONFloat64 `json:"trainingSplitRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TrainingSplitRatio = float64(s1.TrainingSplitRatio)
	return nil
}

// GoogleCloudDocumentaiV1beta3ImportDocumentsResponse: Response of the
// import document operation.
type GoogleCloudDocumentaiV1beta3ImportDocumentsResponse struct {
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata: The
// long-running operation metadata for the ImportProcessorVersion
// method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata for the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest: The
// request message for the ImportProcessorVersion method. The Document
// AI Service Agent (https://cloud.google.com/iam/docs/service-agents)
// of the destination project must have Document AI Editor role
// (https://cloud.google.com/document-ai/docs/access-control/iam-roles)
// on the source project. The destination project is specified as part
// of the parent field. The source project is specified as part of the
// source or external_processor_version_source field.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest struct {
	// ExternalProcessorVersionSource: The source processor version to
	// import from. It can be from a different environment and region than
	// the destination processor.
	ExternalProcessorVersionSource *GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource `json:"externalProcessorVersionSource,omitempty"`

	// ProcessorVersionSource: The source processor version to import from.
	// The source processor version and destination processor need to be in
	// the same environment and region.
	ProcessorVersionSource string `json:"processorVersionSource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExternalProcessorVersionSource") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ExternalProcessorVersionSource") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProce
// ssorVersionSource: The external source processor version.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource struct {
	// ProcessorVersion: Required. The processor version name. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processorVersion}`
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ServiceEndpoint: Optional. The Document AI service endpoint. For
	// example, 'https://us-documentai.googleapis.com'
	ServiceEndpoint string `json:"serviceEndpoint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse: The
// response message for the ImportProcessorVersion method.
type GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse struct {
	// ProcessorVersion: The destination processor version name.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3ListDocumentsRequest struct {
	// Filter: Optional. Query to filter the documents based on
	// https://google.aip.dev/160. ## Currently support query strings are:
	// `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSI
	// GNED` -
	// `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABEL
	// ED` - `DisplayName=\"file_name.pdf\" - `EntityType=abc/def` -
	// `TagName=\"auto-labeling-running\"|\"sampled\" Note: - Only `AND`,
	// `=` and `!=` are supported. e.g. `DisplayName=file_name AND
	// EntityType!=abc` IS supported. - Wildcard `*` is supported only in
	// `DisplayName` filter - No duplicate filter keys are allowed, e.g.
	// `EntityType=a AND EntityType=b` is NOT supported. - String match is
	// case sensitive (for filter `DisplayName` & `EntityType`).
	Filter string `json:"filter,omitempty"`

	// PageSize: The maximum number of documents to return. The service may
	// return fewer than this value. If unspecified, at most 20 documents
	// will be returned. The maximum value is 100; values above 100 will be
	// coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous `ListDocuments`
	// call. Provide this to retrieve the subsequent page. When paginating,
	// all other parameters provided to `ListDocuments` must match the call
	// that provided the page token.
	PageToken string `json:"pageToken,omitempty"`

	// ReturnTotalSize: Optional. Controls if the request requires a total
	// size of matched documents. See ListDocumentsResponse.total_size.
	// Enabling this flag may adversely impact performance. Defaults to
	// false.
	ReturnTotalSize bool `json:"returnTotalSize,omitempty"`

	// Skip: Optional. Number of results to skip beginning from the
	// `page_token` if provided.
	// https://google.aip.dev/158#skipping-results. It must be a
	// non-negative integer. Negative values will be rejected. Note that
	// this is not the number of pages to skip. If this value causes the
	// cursor to move past the end of results,
	// ListDocumentsResponse.document_metadata and
	// ListDocumentsResponse.next_page_token will be empty.
	Skip int64 `json:"skip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDocumentaiV1beta3ListDocumentsResponse struct {
	// DocumentMetadata: Document metadata corresponding to the listed
	// documents.
	DocumentMetadata []*GoogleCloudDocumentaiV1beta3DocumentMetadata `json:"documentMetadata,omitempty"`

	// NextPageToken: A token, which can be sent as
	// ListDocumentsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total count of documents queried.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DocumentMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ListEvaluationsResponse: The response
// from `ListEvaluations`.
type GoogleCloudDocumentaiV1beta3ListEvaluationsResponse struct {
	// Evaluations: The evaluations requested.
	Evaluations []*GoogleCloudDocumentaiV1beta3Evaluation `json:"evaluations,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Evaluations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Evaluations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListEvaluationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse: Response
// message for the ListProcessorTypes method.
type GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse struct {
	// NextPageToken: Points to the next page, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ProcessorTypes: The processor types.
	ProcessorTypes []*GoogleCloudDocumentaiV1beta3ProcessorType `json:"processorTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse: Response
// message for the ListProcessorVersions method.
type GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse struct {
	// NextPageToken: Points to the next processor, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ProcessorVersions: The list of processors.
	ProcessorVersions []*GoogleCloudDocumentaiV1beta3ProcessorVersion `json:"processorVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ListProcessorsResponse: Response message
// for the ListProcessors method.
type GoogleCloudDocumentaiV1beta3ListProcessorsResponse struct {
	// NextPageToken: Points to the next processor, otherwise empty.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Processors: The list of processors.
	Processors []*GoogleCloudDocumentaiV1beta3Processor `json:"processors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ListProcessorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ListProcessorsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3NormalizedVertex: A vertex represents a
// 2D point in the image. NOTE: the normalized vertex coordinates are
// relative to the original image and range from 0 to 1.
type GoogleCloudDocumentaiV1beta3NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3NormalizedVertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1beta3OcrConfig: Config for Document OCR.
type GoogleCloudDocumentaiV1beta3OcrConfig struct {
	// AdvancedOcrOptions: A list of advanced OCR options to further
	// fine-tune OCR behavior. Current valid values are: - `legacy_layout`:
	// a heuristics layout detection algorithm, which serves as an
	// alternative to the current ML-based layout detection algorithm.
	// Customers can choose the best suitable layout algorithm based on
	// their situation.
	AdvancedOcrOptions []string `json:"advancedOcrOptions,omitempty"`

	// ComputeStyleInfo: Turn on font identification model and return font
	// style information. Deprecated, use PremiumFeatures.compute_style_info
	// instead.
	ComputeStyleInfo bool `json:"computeStyleInfo,omitempty"`

	// DisableCharacterBoxesDetection: Turn off character box detector in
	// OCR engine. Character box detection is enabled by default in OCR 2.0
	// (and later) processors.
	DisableCharacterBoxesDetection bool `json:"disableCharacterBoxesDetection,omitempty"`

	// EnableImageQualityScores: Enables intelligent document quality scores
	// after OCR. Can help with diagnosing why OCR responses are of poor
	// quality for a given input. Adds additional latency comparable to
	// regular OCR to the process call.
	EnableImageQualityScores bool `json:"enableImageQualityScores,omitempty"`

	// EnableNativePdfParsing: Enables special handling for PDFs with
	// existing text information. Results in better text extraction quality
	// in such PDF inputs.
	EnableNativePdfParsing bool `json:"enableNativePdfParsing,omitempty"`

	// EnableSymbol: Includes symbol level OCR information if set to true.
	EnableSymbol bool `json:"enableSymbol,omitempty"`

	// Hints: Hints for the OCR model.
	Hints *GoogleCloudDocumentaiV1beta3OcrConfigHints `json:"hints,omitempty"`

	// PremiumFeatures: Configurations for premium OCR features.
	PremiumFeatures *GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures `json:"premiumFeatures,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdvancedOcrOptions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedOcrOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3OcrConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3OcrConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3OcrConfigHints: Hints for OCR Engine
type GoogleCloudDocumentaiV1beta3OcrConfigHints struct {
	// LanguageHints: List of BCP-47 language codes to use for OCR. In most
	// cases, not specifying it yields the best results since it enables
	// automatic language detection. For languages based on the Latin
	// alphabet, setting hints is not needed. In rare cases, when the
	// language of the text in the image is known, setting a hint will help
	// get better results (although it will be a significant hindrance if
	// the hint is wrong).
	LanguageHints []string `json:"languageHints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageHints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageHints") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3OcrConfigHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3OcrConfigHints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures: Configurations
// for premium OCR features.
type GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures struct {
	// ComputeStyleInfo: Turn on font identification model and return font
	// style information.
	ComputeStyleInfo bool `json:"computeStyleInfo,omitempty"`

	// EnableMathOcr: Turn on the model that can extract LaTeX math
	// formulas.
	EnableMathOcr bool `json:"enableMathOcr,omitempty"`

	// EnableSelectionMarkDetection: Turn on selection mark detector in OCR
	// engine. Only available in OCR 2.0 (and later) processors.
	EnableSelectionMarkDetection bool `json:"enableSelectionMarkDetection,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ComputeStyleInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ComputeStyleInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessOptions: Options for Process API
type GoogleCloudDocumentaiV1beta3ProcessOptions struct {
	// FromEnd: Only process certain pages from the end, same as above.
	FromEnd int64 `json:"fromEnd,omitempty"`

	// FromStart: Only process certain pages from the start. Process all if
	// the document has fewer pages.
	FromStart int64 `json:"fromStart,omitempty"`

	// IndividualPageSelector: Which pages to process (1-indexed).
	IndividualPageSelector *GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector `json:"individualPageSelector,omitempty"`

	// OcrConfig: Only applicable to `OCR_PROCESSOR` and
	// `FORM_PARSER_PROCESSOR`. Returns error if set on other processor
	// types.
	OcrConfig *GoogleCloudDocumentaiV1beta3OcrConfig `json:"ocrConfig,omitempty"`

	// SchemaOverride: Optional. Override the schema of the
	// ProcessorVersion. Will return an Invalid Argument error if this field
	// is set when the underlying ProcessorVersion doesn't support schema
	// override.
	SchemaOverride *GoogleCloudDocumentaiV1beta3DocumentSchema `json:"schemaOverride,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FromEnd") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FromEnd") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector: A
// list of individual page numbers.
type GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector struct {
	// Pages: Optional. Indices of the pages (starting from 1).
	Pages []int64 `json:"pages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Pages") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Pages") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessRequest: Request message for the
// ProcessDocument method.
type GoogleCloudDocumentaiV1beta3ProcessRequest struct {
	// Document: The document payload, the content and mime_type fields must
	// be set.
	Document *GoogleCloudDocumentaiV1beta3Document `json:"document,omitempty"`

	// FieldMask: Specifies which fields to include in the
	// ProcessResponse.document output. Only supports top-level document and
	// pages field, so it must be in the form of `{document_field_name}` or
	// `pages.{page_field_name}`.
	FieldMask string `json:"fieldMask,omitempty"`

	// GcsDocument: A raw document on Google Cloud Storage.
	GcsDocument *GoogleCloudDocumentaiV1beta3GcsDocument `json:"gcsDocument,omitempty"`

	// InlineDocument: An inline document proto.
	InlineDocument *GoogleCloudDocumentaiV1beta3Document `json:"inlineDocument,omitempty"`

	// Labels: Optional. The labels with user-defined metadata for the
	// request. Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are
	// allowed. Label values are optional. Label keys must start with a
	// letter.
	Labels map[string]string `json:"labels,omitempty"`

	// ProcessOptions: Inference-time options for the process API
	ProcessOptions *GoogleCloudDocumentaiV1beta3ProcessOptions `json:"processOptions,omitempty"`

	// RawDocument: A raw document content (bytes).
	RawDocument *GoogleCloudDocumentaiV1beta3RawDocument `json:"rawDocument,omitempty"`

	// SkipHumanReview: Whether human review should be skipped for this
	// request. Default to `false`.
	SkipHumanReview bool `json:"skipHumanReview,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessResponse: Response message for the
// ProcessDocument method.
type GoogleCloudDocumentaiV1beta3ProcessResponse struct {
	// Document: The document payload, will populate fields based on the
	// processor's behavior.
	Document *GoogleCloudDocumentaiV1beta3Document `json:"document,omitempty"`

	// HumanReviewOperation: The name of the operation triggered by the
	// processed document. If the human review process isn't triggered, this
	// field is empty. It has the same response type and metadata as the
	// long-running operation returned by ReviewDocument.
	HumanReviewOperation string `json:"humanReviewOperation,omitempty"`

	// HumanReviewStatus: The status of human review on the processed
	// document.
	HumanReviewStatus *GoogleCloudDocumentaiV1beta3HumanReviewStatus `json:"humanReviewStatus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Processor: The first-class citizen for
// Document AI. Each processor defines how to extract structural
// information from a document.
type GoogleCloudDocumentaiV1beta3Processor struct {
	// CreateTime: The time the processor was created.
	CreateTime string `json:"createTime,omitempty"`

	// DefaultProcessorVersion: The default processor version.
	DefaultProcessorVersion string `json:"defaultProcessorVersion,omitempty"`

	// DisplayName: The display name of the processor.
	DisplayName string `json:"displayName,omitempty"`

	// KmsKeyName: The KMS key
	// (https://cloud.google.com/security-key-management) used for
	// encryption and decryption in CMEK scenarios.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// Name: Output only. Immutable. The resource name of the processor.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}`
	Name string `json:"name,omitempty"`

	// ProcessEndpoint: Output only. Immutable. The http endpoint that can
	// be called to invoke processing.
	ProcessEndpoint string `json:"processEndpoint,omitempty"`

	// ProcessorVersionAliases: Output only. The processor version aliases.
	ProcessorVersionAliases []*GoogleCloudDocumentaiV1beta3ProcessorVersionAlias `json:"processorVersionAliases,omitempty"`

	// State: Output only. The state of the processor.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The processor is in an unspecified state.
	//   "ENABLED" - The processor is enabled, i.e., has an enabled version
	// which can currently serve processing requests and all the feature
	// dependencies have been successfully initialized.
	//   "DISABLED" - The processor is disabled.
	//   "ENABLING" - The processor is being enabled, will become `ENABLED`
	// if successful.
	//   "DISABLING" - The processor is being disabled, will become
	// `DISABLED` if successful.
	//   "CREATING" - The processor is being created, will become either
	// `ENABLED` (for successful creation) or `FAILED` (for failed ones).
	// Once a processor is in this state, it can then be used for document
	// processing, but the feature dependencies of the processor might not
	// be fully created yet.
	//   "FAILED" - The processor failed during creation or initialization
	// of feature dependencies. The user should delete the processor and
	// recreate one as all the functionalities of the processor are
	// disabled.
	//   "DELETING" - The processor is being deleted, will be removed if
	// successful.
	State string `json:"state,omitempty"`

	// Type: The processor type, such as: `OCR_PROCESSOR`,
	// `INVOICE_PROCESSOR`. To get a list of processor types, see
	// FetchProcessorTypes.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Processor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Processor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessorType: A processor type is
// responsible for performing a certain document understanding task on a
// certain type of document.
type GoogleCloudDocumentaiV1beta3ProcessorType struct {
	// AllowCreation: Whether the processor type allows creation. If true,
	// users can create a processor of this processor type. Otherwise, users
	// need to request access.
	AllowCreation bool `json:"allowCreation,omitempty"`

	// AvailableLocations: The locations in which this processor is
	// available.
	AvailableLocations []*GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo `json:"availableLocations,omitempty"`

	// Category: The processor category, used by UI to group processor
	// types.
	Category string `json:"category,omitempty"`

	// LaunchStage: Launch stage of the processor type
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not
	// use it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed
	// group of testers. To use these features, you must sign up in advance
	// and sign a Trusted Tester agreement (which includes confidentiality
	// provisions). These features may be unstable, changed in
	// backward-incompatible ways, and are not guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before
	// they are cleared for widespread use. By Alpha, all significant design
	// issues are resolved and we are in the process of verifying
	// functionality. Alpha customers need to apply for access, agree to
	// applicable terms, and have their projects allowlisted. Alpha releases
	// don't have to be feature complete, no SLAs are provided, and there
	// are no technical support obligations, but they will be far enough
	// along that customers can actually use them in test environments or
	// for limited-use tests -- just like they would in normal production
	// cases.
	//   "BETA" - Beta is the point at which we are ready to open a release
	// for any customer to use. There are no SLA or technical support
	// obligations in a Beta release. Products will be complete from a
	// feature perspective, but may have some open outstanding issues. Beta
	// releases are suitable for limited production use cases.
	//   "GA" - GA features are open to all developers and are considered
	// stable and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down
	// and removed. For more information, see the "Deprecation Policy"
	// section of our [Terms of Service](https://cloud.google.com/terms/)
	// and the [Google Cloud Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`

	// Name: The resource name of the processor type. Format:
	// `projects/{project}/processorTypes/{processor_type}`
	Name string `json:"name,omitempty"`

	// SampleDocumentUris: A set of Cloud Storage URIs of sample documents
	// for this processor.
	SampleDocumentUris []string `json:"sampleDocumentUris,omitempty"`

	// Type: The processor type, such as: `OCR_PROCESSOR`,
	// `INVOICE_PROCESSOR`.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AllowCreation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowCreation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessorType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessorType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo: The location
// information about where the processor is available.
type GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo struct {
	// LocationId: The location ID. For supported locations, refer to
	// regional and multi-regional support (/document-ai/docs/regions).
	LocationId string `json:"locationId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessorVersion: A processor version is
// an implementation of a processor. Each processor can have multiple
// versions, pretrained by Google internally or uptrained by the
// customer. A processor can only have one default version at a time.
// Its document-processing behavior is defined by that version.
type GoogleCloudDocumentaiV1beta3ProcessorVersion struct {
	// CreateTime: The time the processor version was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeprecationInfo: If set, information about the eventual deprecation
	// of this version.
	DeprecationInfo *GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo `json:"deprecationInfo,omitempty"`

	// DisplayName: The display name of the processor version.
	DisplayName string `json:"displayName,omitempty"`

	// DocumentSchema: The schema of the processor version. Describes the
	// output.
	DocumentSchema *GoogleCloudDocumentaiV1beta3DocumentSchema `json:"documentSchema,omitempty"`

	// GoogleManaged: Output only. Denotes that this `ProcessorVersion` is
	// managed by Google.
	GoogleManaged bool `json:"googleManaged,omitempty"`

	// KmsKeyName: The KMS key name used for encryption.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// KmsKeyVersionName: The KMS key version with which data is encrypted.
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`

	// LatestEvaluation: The most recently invoked evaluation for the
	// processor version.
	LatestEvaluation *GoogleCloudDocumentaiV1beta3EvaluationReference `json:"latestEvaluation,omitempty"`

	// Name: The resource name of the processor version. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processor_version}`
	Name string `json:"name,omitempty"`

	// State: The state of the processor version.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The processor version is in an unspecified
	// state.
	//   "DEPLOYED" - The processor version is deployed and can be used for
	// processing.
	//   "DEPLOYING" - The processor version is being deployed.
	//   "UNDEPLOYED" - The processor version is not deployed and cannot be
	// used for processing.
	//   "UNDEPLOYING" - The processor version is being undeployed.
	//   "CREATING" - The processor version is being created.
	//   "DELETING" - The processor version is being deleted.
	//   "FAILED" - The processor version failed and is in an indeterminate
	// state.
	//   "IMPORTING" - The processor version is being imported.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessorVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessorVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessorVersionAlias: Contains the alias
// and the aliased resource name of processor version.
type GoogleCloudDocumentaiV1beta3ProcessorVersionAlias struct {
	// Alias: The alias in the form of `processor_version` resource name.
	Alias string `json:"alias,omitempty"`

	// ProcessorVersion: The resource name of aliased processor version.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessorVersionAlias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessorVersionAlias
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo:
// Information about the upcoming deprecation of this processor version.
type GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo struct {
	// DeprecationTime: The time at which this processor version will be
	// deprecated.
	DeprecationTime string `json:"deprecationTime,omitempty"`

	// ReplacementProcessorVersion: If set, the processor version that will
	// be used as a replacement.
	ReplacementProcessorVersion string `json:"replacementProcessorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeprecationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeprecationTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3PropertyMetadata: Metadata about a
// property.
type GoogleCloudDocumentaiV1beta3PropertyMetadata struct {
	// FieldExtractionMetadata: Field extraction metadata on the property.
	FieldExtractionMetadata *GoogleCloudDocumentaiV1beta3FieldExtractionMetadata `json:"fieldExtractionMetadata,omitempty"`

	// Inactive: Whether the property should be considered as "inactive".
	Inactive bool `json:"inactive,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FieldExtractionMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldExtractionMetadata")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3PropertyMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3PropertyMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3RawDocument: Payload message of raw
// document content (bytes).
type GoogleCloudDocumentaiV1beta3RawDocument struct {
	// Content: Inline document content.
	Content string `json:"content,omitempty"`

	// DisplayName: The display name of the document, it supports all
	// Unicode characters except the following: `*`, `?`, `[`, `]`, `%`,
	// `{`, `}`,`'`, `\", `,` `~`, `=` and `:` are reserved. If not
	// specified, a default ID is generated.
	DisplayName string `json:"displayName,omitempty"`

	// MimeType: An IANA MIME type (RFC6838) indicating the nature and
	// format of the content.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3RawDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3RawDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata: The
// long-running operation metadata for the ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// CreateTime: The creation time of the operation.
	CreateTime string `json:"createTime,omitempty"`

	// QuestionId: The Crowd Compute question ID.
	QuestionId string `json:"questionId,omitempty"`

	// State: Used only when Operation.done is false.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RUNNING" - Operation is still running.
	//   "CANCELLING" - Operation is being cancelled.
	//   "SUCCEEDED" - Operation succeeded.
	//   "FAILED" - Operation failed.
	//   "CANCELLED" - Operation is cancelled.
	State string `json:"state,omitempty"`

	// StateMessage: A message providing more details about the current
	// state of processing. For example, the error message if the operation
	// is failed.
	StateMessage string `json:"stateMessage,omitempty"`

	// UpdateTime: The last update time of the operation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentRequest: Request message
// for the ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentRequest struct {
	// Document: The document that needs human review.
	Document *GoogleCloudDocumentaiV1beta3Document `json:"document,omitempty"`

	// DocumentSchema: The document schema of the human review task.
	DocumentSchema *GoogleCloudDocumentaiV1beta3DocumentSchema `json:"documentSchema,omitempty"`

	// EnableSchemaValidation: Whether the validation should be performed on
	// the ad-hoc review request.
	EnableSchemaValidation bool `json:"enableSchemaValidation,omitempty"`

	// InlineDocument: An inline document proto.
	InlineDocument *GoogleCloudDocumentaiV1beta3Document `json:"inlineDocument,omitempty"`

	// Priority: The priority of the human review task.
	//
	// Possible values:
	//   "DEFAULT" - The default priority level.
	//   "URGENT" - The urgent priority level. The labeling manager should
	// allocate labeler resource to the urgent task queue to respect this
	// priority level.
	Priority string `json:"priority,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ReviewDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3ReviewDocumentResponse: Response message
// for the ReviewDocument method.
type GoogleCloudDocumentaiV1beta3ReviewDocumentResponse struct {
	// GcsDestination: The Cloud Storage uri for the human reviewed document
	// if the review is succeeded.
	GcsDestination string `json:"gcsDestination,omitempty"`

	// RejectionReason: The reason why the review is rejected by reviewer.
	RejectionReason string `json:"rejectionReason,omitempty"`

	// State: The state of the review operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "REJECTED" - The review operation is rejected by the reviewer.
	//   "SUCCEEDED" - The review operation is succeeded.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3ReviewDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3ReviewDocumentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3RevisionRef: The revision reference
// specifies which revision on the document to read.
type GoogleCloudDocumentaiV1beta3RevisionRef struct {
	// LatestProcessorVersion: Reads the revision generated by the processor
	// version. The format takes the full resource name of processor
	// version.
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processorVersion}`
	LatestProcessorVersion string `json:"latestProcessorVersion,omitempty"`

	// RevisionCase: Reads the revision by the predefined case.
	//
	// Possible values:
	//   "REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read
	// the `LATEST_HUMAN_REVIEW`.
	//   "LATEST_HUMAN_REVIEW" - The latest revision made by a human.
	//   "LATEST_TIMESTAMP" - The latest revision based on timestamp.
	//   "BASE_OCR_REVISION" - The first (OCR) revision.
	RevisionCase string `json:"revisionCase,omitempty"`

	// RevisionId: Reads the revision given by the id.
	RevisionId string `json:"revisionId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LatestProcessorVersion") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestProcessorVersion")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3RevisionRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3RevisionRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata: The
// long-running operation metadata for the SetDefaultProcessorVersion
// method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest:
// Request message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest struct {
	// DefaultProcessorVersion: Required. The resource name of child
	// ProcessorVersion to use as default. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{version}`
	DefaultProcessorVersion string `json:"defaultProcessorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DefaultProcessorVersion") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultProcessorVersion")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse:
// Response message for the SetDefaultProcessorVersion method.
type GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse struct {
}

// GoogleCloudDocumentaiV1beta3SummaryOptions: Metadata for document
// summarization.
type GoogleCloudDocumentaiV1beta3SummaryOptions struct {
	// Format: The format the summary should be in.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Default.
	//   "PARAGRAPH" - Format the output in paragraphs.
	//   "BULLETS" - Format the output in bullets.
	Format string `json:"format,omitempty"`

	// Length: How long the summary should be.
	//
	// Possible values:
	//   "LENGTH_UNSPECIFIED" - Default.
	//   "BRIEF" - A brief summary of one or two sentences.
	//   "MODERATE" - A paragraph-length summary.
	//   "COMPREHENSIVE" - The longest option available.
	Length string `json:"length,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3SummaryOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3SummaryOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata: The
// metadata that represents a processor version being created.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// TestDatasetValidation: The test dataset validation information.
	TestDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"testDatasetValidation,omitempty"`

	// TrainingDatasetValidation: The training dataset validation
	// information.
	TrainingDatasetValidation *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation `json:"trainingDatasetValidation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValida
// tion: The dataset validation information. This includes any and all
// errors with documents and the dataset.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation struct {
	// DatasetErrorCount: The total number of dataset errors.
	DatasetErrorCount int64 `json:"datasetErrorCount,omitempty"`

	// DatasetErrors: Error information for the dataset as a whole. A
	// maximum of 10 dataset errors will be returned. A single dataset error
	// is terminal for training.
	DatasetErrors []*GoogleRpcStatus `json:"datasetErrors,omitempty"`

	// DocumentErrorCount: The total number of document errors.
	DocumentErrorCount int64 `json:"documentErrorCount,omitempty"`

	// DocumentErrors: Error information pertaining to specific documents. A
	// maximum of 10 document errors will be returned. Any document with
	// errors will not be used throughout training.
	DocumentErrors []*GoogleRpcStatus `json:"documentErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DatasetErrorCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatasetErrorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest: Request
// message for the TrainProcessorVersion method.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest struct {
	// BaseProcessorVersion: Optional. The processor version to use as a
	// base for training. This processor version must be a child of
	// `parent`. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/proces
	// sorVersions/{processorVersion}`.
	BaseProcessorVersion string `json:"baseProcessorVersion,omitempty"`

	// CustomDocumentExtractionOptions: Options to control Custom Document
	// Extraction (CDE) Processor.
	CustomDocumentExtractionOptions *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions `json:"customDocumentExtractionOptions,omitempty"`

	// DocumentSchema: Optional. The schema the processor version will be
	// trained with.
	DocumentSchema *GoogleCloudDocumentaiV1beta3DocumentSchema `json:"documentSchema,omitempty"`

	// FoundationModelTuningOptions: Options to control foundation model
	// tuning of a processor.
	FoundationModelTuningOptions *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions `json:"foundationModelTuningOptions,omitempty"`

	// InputData: Optional. The input data used to train the
	// ProcessorVersion.
	InputData *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData `json:"inputData,omitempty"`

	// ProcessorVersion: Required. The processor version to be created.
	ProcessorVersion *GoogleCloudDocumentaiV1beta3ProcessorVersion `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BaseProcessorVersion") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocument
// ExtractionOptions: Options to control the training of the Custom
// Document Extraction (CDE) Processor.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions struct {
	// TrainingMethod: Training method to use for CDE training.
	//
	// Possible values:
	//   "TRAINING_METHOD_UNSPECIFIED"
	//   "MODEL_BASED"
	//   "TEMPLATE_BASED"
	TrainingMethod string `json:"trainingMethod,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TrainingMethod") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TrainingMethod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationMode
// lTuningOptions: Options to control foundation model tuning of the
// processor.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions struct {
	// LearningRateMultiplier: Optional. The multiplier to apply to the
	// recommended learning rate. Valid values are between 0.1 and 10. If
	// not provided, recommended learning rate will be used.
	LearningRateMultiplier float64 `json:"learningRateMultiplier,omitempty"`

	// TrainSteps: Optional. The number of steps to run for model tuning.
	// Valid values are between 1 and 400. If not provided, recommended
	// steps will be used.
	TrainSteps int64 `json:"trainSteps,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LearningRateMultiplier") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LearningRateMultiplier")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions
	var s1 struct {
		LearningRateMultiplier gensupport.JSONFloat64 `json:"learningRateMultiplier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LearningRateMultiplier = float64(s1.LearningRateMultiplier)
	return nil
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData:
// The input data used to train a new ProcessorVersion.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData struct {
	// TestDocuments: The documents used for testing the trained version.
	TestDocuments *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig `json:"testDocuments,omitempty"`

	// TrainingDocuments: The documents used for training the new version.
	TrainingDocuments *GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig `json:"trainingDocuments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestDocuments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestDocuments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse: The
// response for TrainProcessorVersion.
type GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse struct {
	// ProcessorVersion: The resource name of the processor version produced
	// by training.
	ProcessorVersion string `json:"processorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProcessorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProcessorVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata: The
// long-running operation metadata for the UndeployProcessorVersion
// method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest: Request
// message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest struct {
}

// GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse:
// Response message for the UndeployProcessorVersion method.
type GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse struct {
}

type GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata struct {
	// CommonMetadata: The basic metadata of the long-running operation.
	CommonMetadata *GoogleCloudDocumentaiV1beta3CommonOperationMetadata `json:"commonMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CommonMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommonMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1beta3Vertex: A vertex represents a 2D point in
// the image. NOTE: the vertex coordinates are in the same scale as the
// original image.
type GoogleCloudDocumentaiV1beta3Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`

	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDocumentaiV1beta3Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1beta3Vertex
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationListLocationsResponse: The response message for
// Locations.ListLocations.
type GoogleCloudLocationListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents a Google
// Cloud location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeColor: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to and from
// color representations in various languages over compactness. For
// example, the fields of this representation can be trivially provided
// to the constructor of `java.awt.Color` in Java; it can also be
// trivially provided to UIColor's `+colorWithRed:green:blue:alpha`
// method in iOS; and, with just a little work, it can be easily
// formatted into a CSS `rgba()` string in JavaScript. This reference
// page doesn't have information about the absolute color space that
// should be used to interpret the RGB value—for example, sRGB, Adobe
// RGB, DCI-P3, and BT.2020. By default, applications should assume the
// sRGB color space. When color equality needs to be decided,
// implementations, unless documented otherwise, treat two colors as
// equal if all their red, green, blue, and alpha values each differ by
// at most `1e-5`. Example (Java): import com.google.type.Color; // ...
// public static java.awt.Color fromProto(Color protocolor) { float
// alpha = protocolor.hasAlpha() ? protocolor.getAlpha().getValue() :
// 1.0; return new java.awt.Color( protocolor.getRed(),
// protocolor.getGreen(), protocolor.getBlue(), alpha); } public static
// Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue =
// (float) color.getBlue(); float denominator = 255.0; Color.Builder
// resultBuilder = Color .newBuilder() .setRed(red / denominator)
// .setGreen(green / denominator) .setBlue(blue / denominator); int
// alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha(
// FloatValue .newBuilder() .setValue(((float) alpha) / denominator)
// .build()); } return resultBuilder.build(); } // ... Example (iOS /
// Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float
// red = [protocolor red]; float green = [protocolor green]; float blue
// = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha];
// float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper
// value]; } return [UIColor colorWithRed:red green:green blue:blue
// alpha:alpha]; } static Color* toProto(UIColor* color) { CGFloat red,
// green, blue, alpha; if (![color getRed:&red green:&green blue:&blue
// alpha:&alpha]) { return nil; } Color* result = [[Color alloc] init];
// [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result
// setAlpha:floatWrapperWithValue(alpha)]; } [result autorelease];
// return result; } // ... Example (JavaScript): // ... var
// protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red
// || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac =
// rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green
// = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255);
// if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green,
// blue); } var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams
// = [red, green, blue].join(','); return ['rgba(', rgbParams, ',',
// alphaFrac, ')'].join(”); }; var rgbToCssColor = function(red, green,
// blue) { var rgbNumber = new Number((red << 16) | (green << 8) |
// blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 -
// hexString.length; var resultBuilder = ['#']; for (var i = 0; i <
// missingZeros; i++) { resultBuilder.push('0'); }
// resultBuilder.push(hexString); return resultBuilder.join(”); }; //
// ...
type GoogleTypeColor struct {
	// Alpha: The fraction of this color that should be applied to the
	// pixel. That is, the final pixel color is defined by the equation:
	// `pixel color = alpha * (this color) + (1.0 - alpha) * (background
	// color)` This means that a value of 1.0 corresponds to a solid color,
	// whereas a value of 0.0 corresponds to a completely transparent color.
	// This uses a wrapper message rather than a simple float scalar so that
	// it is possible to distinguish between a default value and the value
	// being unset. If omitted, this color object is rendered as a solid
	// color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`

	// Blue: The amount of blue in the color as a value in the interval [0,
	// 1].
	Blue float64 `json:"blue,omitempty"`

	// Green: The amount of green in the color as a value in the interval
	// [0, 1].
	Green float64 `json:"green,omitempty"`

	// Red: The amount of red in the color as a value in the interval [0,
	// 1].
	Red float64 `json:"red,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alpha") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeColor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeColor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeColor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical
// time). This type can represent a civil time in one of a few possible
// ways: * When utc_offset is set and time_zone is unset: a civil time
// on a calendar day with a particular offset from UTC. * When time_zone
// is set and utc_offset is unset: a civil time on a calendar day in a
// particular time zone. * When neither time_zone nor utc_offset is set:
// a civil time on a calendar day in local time. The date is relative to
// the Proleptic Gregorian Calendar. If year, month, or day are 0, the
// DateTime is considered not to have a specific year, month, or day
// respectively. This type may also be used to represent a physical time
// if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for
// physical time instead. If your use case also would like to store the
// user's timezone, that can be done in another field. This type is more
// flexible than some applications may want. Make sure to document and
// validate your application's limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the
	// year and month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`

	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to
	// 23, defaults to 0 (midnight). An API may choose to allow the value
	// "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`

	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59,
	// defaults to 0.
	Minutes int64 `json:"minutes,omitempty"`

	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if
	// specifying a datetime without a month.
	Month int64 `json:"month,omitempty"`

	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0
	// to 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Optional. Seconds of minutes of the time. Must normally be
	// from 0 to 59, defaults to 0. An API may allow the value 60 if it
	// allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`

	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`

	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and
	// +18 hours. For example, a UTC offset of -4:00 would be represented as
	// { seconds: -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`

	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if
	// specifying a datetime without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency
// type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Nanos: Number of nano (10^-9) units of the amount. The value must be
	// between -999,999,999 and +999,999,999 inclusive. If `units` is
	// positive, `nanos` must be positive or zero. If `units` is zero,
	// `nanos` can be positive, zero, or negative. If `units` is negative,
	// `nanos` must be negative or zero. For example $-1.75 is represented
	// as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`

	// Units: The whole units of the amount. For example if `currencyCode`
	// is "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypePostalAddress: Represents a postal address, e.g. for postal
// delivery or payments addresses. Given a postal address, a postal
// service can deliver items to a premise, P.O. Box or similar. It is
// not intended to model geographical locations (roads, towns,
// mountains). In typical usage an address would be created via user
// input or from importing existing data, depending on the type of
// process. Advice on address input / editing: - Use an
// internationalization-ready address widget such as
// https://github.com/google/libaddressinput) - Users should not be
// presented with UI elements for input or editing of fields outside
// countries where that field is used. For more guidance on how to use
// this schema, please see:
// https://support.google.com/business/answer/6397478
type GoogleTypePostalAddress struct {
	// AddressLines: Unstructured address lines describing the lower levels
	// of an address. Because values in address_lines do not have type
	// information and may sometimes contain multiple values in a single
	// field (e.g. "Austin, TX"), it is important that the line order is
	// clear. The order of address lines should be "envelope order" for the
	// country/region of the address. In places where this can vary (e.g.
	// Japan), address_language is used to make it explicit (e.g. "ja" for
	// large-to-small ordering and "ja-Latn" or "en" for small-to-large).
	// This way, the most specific line of an address can be selected based
	// on the language. The minimum permitted structural representation of
	// an address consists of a region_code with all remaining information
	// placed in the address_lines. It would be possible to format such an
	// address very approximately without geocoding, but no semantic
	// reasoning could be made about any of the address components until it
	// was at least partially resolved. Creating an address only containing
	// a region_code and address_lines, and then geocoding is the
	// recommended way to handle completely unstructured addresses (as
	// opposed to guessing which parts of the address should be localities
	// or administrative areas).
	AddressLines []string `json:"addressLines,omitempty"`

	// AdministrativeArea: Optional. Highest administrative subdivision
	// which is used for postal addresses of a country or region. For
	// example, this can be a state, a province, an oblast, or a prefecture.
	// Specifically, for Spain this is the province and not the autonomous
	// community (e.g. "Barcelona" and not "Catalonia"). Many countries
	// don't use an administrative area in postal addresses. E.g. in
	// Switzerland this should be left unpopulated.
	AdministrativeArea string `json:"administrativeArea,omitempty"`

	// LanguageCode: Optional. BCP-47 language code of the contents of this
	// address (if known). This is often the UI language of the input form
	// or is expected to match one of the languages used in the address'
	// country/region, or their transliterated equivalents. This can affect
	// formatting in certain countries, but is not critical to the
	// correctness of the data and will never affect any validation or other
	// non-formatting related operations. If this value is not known, it
	// should be omitted (rather than specifying a possibly incorrect
	// default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
	LanguageCode string `json:"languageCode,omitempty"`

	// Locality: Optional. Generally refers to the city/town portion of the
	// address. Examples: US city, IT comune, UK post town. In regions of
	// the world where localities are not well defined or do not fit into
	// this structure well, leave locality empty and use address_lines.
	Locality string `json:"locality,omitempty"`

	// Organization: Optional. The name of the organization at the address.
	Organization string `json:"organization,omitempty"`

	// PostalCode: Optional. Postal code of the address. Not all countries
	// use or require postal codes to be present, but where they are used,
	// they may trigger additional validation with other parts of the
	// address (e.g. state/zip validation in the U.S.A.).
	PostalCode string `json:"postalCode,omitempty"`

	// Recipients: Optional. The recipient at the address. This field may,
	// under certain circumstances, contain multiline information. For
	// example, it might contain "care of" information.
	Recipients []string `json:"recipients,omitempty"`

	// RegionCode: Required. CLDR region code of the country/region of the
	// address. This is never inferred and it is up to the user to ensure
	// the value is correct. See https://cldr.unicode.org/ and
	// https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `json:"regionCode,omitempty"`

	// Revision: The schema revision of the `PostalAddress`. This must be
	// set to 0, which is the latest revision. All new revisions **must** be
	// backward compatible with old revisions.
	Revision int64 `json:"revision,omitempty"`

	// SortingCode: Optional. Additional, country-specific, sorting code.
	// This is not used in most regions. Where it is used, the value is
	// either a string like "CEDEX", optionally followed by a number (e.g.
	// "CEDEX 7"), or just a number alone, representing the "sector code"
	// (Jamaica), "delivery area indicator" (Malawi) or "post office
	// indicator" (e.g. Côte d'Ivoire).
	SortingCode string `json:"sortingCode,omitempty"`

	// Sublocality: Optional. Sublocality of the address. For example, this
	// can be neighborhoods, boroughs, districts.
	Sublocality string `json:"sublocality,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressLines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressLines") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypePostalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypePostalAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone
// Database (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`

	// Version: Optional. IANA Time Zone Database version number, e.g.
	// "2019a".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "documentai.projects.locations.fetchProcessorTypes":

type ProjectsLocationsFetchProcessorTypesCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchProcessorTypes: Fetches processor types. Note that we don't use
// ListProcessorTypes here, because it isn't paginated.
//
//   - parent: The location of processor types to list. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsService) FetchProcessorTypes(parent string) *ProjectsLocationsFetchProcessorTypesCall {
	c := &ProjectsLocationsFetchProcessorTypesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsFetchProcessorTypesCall) Fields(s ...googleapi.Field) *ProjectsLocationsFetchProcessorTypesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsFetchProcessorTypesCall) IfNoneMatch(entityTag string) *ProjectsLocationsFetchProcessorTypesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsFetchProcessorTypesCall) Context(ctx context.Context) *ProjectsLocationsFetchProcessorTypesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsFetchProcessorTypesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsFetchProcessorTypesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}:fetchProcessorTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.fetchProcessorTypes" call.
// Exactly one of
// *GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsFetchProcessorTypesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Fetches processor types. Note that we don't use ListProcessorTypes here, because it isn't paginated.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}:fetchProcessorTypes",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.fetchProcessorTypes",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The location of processor types to list. Format: `projects/{project}/locations/{location}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}:fetchProcessorTypes",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.get" call.
// Exactly one of *GoogleCloudLocationLocation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudLocationLocation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
//
//   - name: The resource that owns the locations collection, if
//     applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down
// results to a preferred subset. The filtering language accepts strings
// like "displayName=tokyo", and is documented in more detail in
// AIP-160 (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// received from the `next_page_token` field in the response. Send that
// page token to receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.list" call.
// Exactly one of *GoogleCloudLocationListLocationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to narrow down results to a preferred subset. The filtering language accepts strings like `\"displayName=tokyo\"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return. If not set, the service selects a default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}/locations",
	//   "response": {
	//     "$ref": "GoogleCloudLocationListLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "documentai.projects.locations.operations.cancel":

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation.
// The server makes a best effort to cancel the operation, but success
// is not guaranteed. If the server doesn't support this method, it
// returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
// Operations.GetOperation or other methods to check whether the
// cancellation succeeded or whether the operation completed despite
// cancellation. On successful cancellation, the operation is not
// deleted; instead, it becomes an operation with an Operation.error
// value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.cancel" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.operations.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be cancelled.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:cancel",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "documentai.projects.locations.processorTypes.get":

type ProjectsLocationsProcessorTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor type detail.
//
// - name: The processor type resource name.
func (r *ProjectsLocationsProcessorTypesService) Get(name string) *ProjectsLocationsProcessorTypesGetCall {
	c := &ProjectsLocationsProcessorTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorTypesGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processorTypes.get" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ProcessorType or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ProcessorType.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ProcessorType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ProcessorType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a processor type detail.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processorTypes/{processorTypesId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processorTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor type resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processorTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessorType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processorTypes.list":

type ProjectsLocationsProcessorTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the processor types that exist.
//
//   - parent: The location of processor types to list. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorTypesService) List(parent string) *ProjectsLocationsProcessorTypesListCall {
	c := &ProjectsLocationsProcessorTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of processor types to return. If unspecified, at most `100` processor
// types will be returned. The maximum value is `500`. Values above
// `500` will be coerced to `500`.
func (c *ProjectsLocationsProcessorTypesListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Used to retrieve
// the next page of results, empty if at the end of the list.
func (c *ProjectsLocationsProcessorTypesListCall) PageToken(pageToken string) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorTypesListCall) Context(ctx context.Context) *ProjectsLocationsProcessorTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processorTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processorTypes.list" call.
// Exactly one of
// *GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the processor types that exist.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processorTypes",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processorTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of processor types to return. If unspecified, at most `100` processor types will be returned. The maximum value is `500`. Values above `500` will be coerced to `500`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Used to retrieve the next page of results, empty if at the end of the list.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The location of processor types to list. Format: `projects/{project}/locations/{location}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processorTypes",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "documentai.projects.locations.processors.batchProcess":

type ProjectsLocationsProcessorsBatchProcessCall struct {
	s                                               *Service
	name                                            string
	googleclouddocumentaiv1beta3batchprocessrequest *GoogleCloudDocumentaiV1beta3BatchProcessRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The
// output is written to Cloud Storage as JSON in the [Document] format.
//
//   - name: The resource name of Processor or ProcessorVersion. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`,
//     or
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsService) BatchProcess(name string, googleclouddocumentaiv1beta3batchprocessrequest *GoogleCloudDocumentaiV1beta3BatchProcessRequest) *ProjectsLocationsProcessorsBatchProcessCall {
	c := &ProjectsLocationsProcessorsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3batchprocessrequest = googleclouddocumentaiv1beta3batchprocessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3batchprocessrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.batchProcess" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "LRO endpoint to batch process many documents. The output is written to Cloud Storage as JSON in the [Document] format.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}:batchProcess",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.batchProcess",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project}/locations/{location}/processors/{processor}`, or `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:batchProcess",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3BatchProcessRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.create":

type ProjectsLocationsProcessorsCreateCall struct {
	s                                     *Service
	parent                                string
	googleclouddocumentaiv1beta3processor *GoogleCloudDocumentaiV1beta3Processor
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a processor from the ProcessorType provided. The
// processor will be at `ENABLED` state by default after its creation.
//
//   - parent: The parent (project and location) under which to create the
//     processor. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorsService) Create(parent string, googleclouddocumentaiv1beta3processor *GoogleCloudDocumentaiV1beta3Processor) *ProjectsLocationsProcessorsCreateCall {
	c := &ProjectsLocationsProcessorsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta3processor = googleclouddocumentaiv1beta3processor
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsCreateCall) Context(ctx context.Context) *ProjectsLocationsProcessorsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3processor)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.create" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3Processor or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDocumentaiV1beta3Processor.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3Processor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3Processor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a processor from the ProcessorType provided. The processor will be at `ENABLED` state by default after its creation.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent (project and location) under which to create the processor. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processors",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3Processor"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3Processor"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.delete":

type ProjectsLocationsProcessorsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the processor, unloads all deployed model artifacts
// if it was enabled and then deletes all artifacts associated with this
// processor.
//
// - name: The processor resource name to be deleted.
func (r *ProjectsLocationsProcessorsService) Delete(name string) *ProjectsLocationsProcessorsDeleteCall {
	c := &ProjectsLocationsProcessorsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDeleteCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the processor, unloads all deployed model artifacts if it was enabled and then deletes all artifacts associated with this processor.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}",
	//   "httpMethod": "DELETE",
	//   "id": "documentai.projects.locations.processors.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor resource name to be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.disable":

type ProjectsLocationsProcessorsDisableCall struct {
	s                                                   *Service
	name                                                string
	googleclouddocumentaiv1beta3disableprocessorrequest *GoogleCloudDocumentaiV1beta3DisableProcessorRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Disable: Disables a processor
//
// - name: The processor resource name to be disabled.
func (r *ProjectsLocationsProcessorsService) Disable(name string, googleclouddocumentaiv1beta3disableprocessorrequest *GoogleCloudDocumentaiV1beta3DisableProcessorRequest) *ProjectsLocationsProcessorsDisableCall {
	c := &ProjectsLocationsProcessorsDisableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3disableprocessorrequest = googleclouddocumentaiv1beta3disableprocessorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDisableCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDisableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDisableCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDisableCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDisableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDisableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3disableprocessorrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:disable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.disable" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDisableCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Disables a processor",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}:disable",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.disable",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor resource name to be disabled.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:disable",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3DisableProcessorRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.enable":

type ProjectsLocationsProcessorsEnableCall struct {
	s                                                  *Service
	name                                               string
	googleclouddocumentaiv1beta3enableprocessorrequest *GoogleCloudDocumentaiV1beta3EnableProcessorRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Enable: Enables a processor
//
// - name: The processor resource name to be enabled.
func (r *ProjectsLocationsProcessorsService) Enable(name string, googleclouddocumentaiv1beta3enableprocessorrequest *GoogleCloudDocumentaiV1beta3EnableProcessorRequest) *ProjectsLocationsProcessorsEnableCall {
	c := &ProjectsLocationsProcessorsEnableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3enableprocessorrequest = googleclouddocumentaiv1beta3enableprocessorrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsEnableCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsEnableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsEnableCall) Context(ctx context.Context) *ProjectsLocationsProcessorsEnableCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsEnableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsEnableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3enableprocessorrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:enable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.enable" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsEnableCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enables a processor",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}:enable",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.enable",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor resource name to be enabled.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:enable",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3EnableProcessorRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.get":

type ProjectsLocationsProcessorsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor detail.
//
// - name: The processor resource name.
func (r *ProjectsLocationsProcessorsService) Get(name string) *ProjectsLocationsProcessorsGetCall {
	c := &ProjectsLocationsProcessorsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.get" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3Processor or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDocumentaiV1beta3Processor.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3Processor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3Processor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a processor detail.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3Processor"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.list":

type ProjectsLocationsProcessorsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all processors which belong to this project.
//
//   - parent: The parent (project and location) which owns this
//     collection of Processors. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsProcessorsService) List(parent string) *ProjectsLocationsProcessorsListCall {
	c := &ProjectsLocationsProcessorsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of processors to return. If unspecified, at most `50` processors will
// be returned. The maximum value is `100`. Values above `100` will be
// coerced to `100`.
func (c *ProjectsLocationsProcessorsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": We will return the
// processors sorted by creation time. The page token will point to the
// next processor.
func (c *ProjectsLocationsProcessorsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.list" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ListProcessorsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ListProcessorsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ListProcessorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ListProcessorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all processors which belong to this project.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of processors to return. If unspecified, at most `50` processors will be returned. The maximum value is `100`. Values above `100` will be coerced to `100`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "We will return the processors sorted by creation time. The page token will point to the next processor.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent (project and location) which owns this collection of Processors. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processors",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListProcessorsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1beta3ListProcessorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "documentai.projects.locations.processors.process":

type ProjectsLocationsProcessorsProcessCall struct {
	s                                          *Service
	name                                       string
	googleclouddocumentaiv1beta3processrequest *GoogleCloudDocumentaiV1beta3ProcessRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Process: Processes a single document.
//
//   - name: The resource name of the Processor or ProcessorVersion to use
//     for processing. If a Processor is specified, the server will use
//     its default version. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`,
//     or
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsService) Process(name string, googleclouddocumentaiv1beta3processrequest *GoogleCloudDocumentaiV1beta3ProcessRequest) *ProjectsLocationsProcessorsProcessCall {
	c := &ProjectsLocationsProcessorsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3processrequest = googleclouddocumentaiv1beta3processrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3processrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.process" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ProcessResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ProcessResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ProcessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ProcessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Processes a single document.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}:process",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.process",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project}/locations/{location}/processors/{processor}`, or `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:process",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.setDefaultProcessorVersion":

type ProjectsLocationsProcessorsSetDefaultProcessorVersionCall struct {
	s                                                             *Service
	processor                                                     string
	googleclouddocumentaiv1beta3setdefaultprocessorversionrequest *GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// SetDefaultProcessorVersion: Set the default (active) version of a
// Processor that will be used in ProcessDocument and
// BatchProcessDocuments.
//
//   - processor: The resource name of the Processor to change default
//     version.
func (r *ProjectsLocationsProcessorsService) SetDefaultProcessorVersion(processor string, googleclouddocumentaiv1beta3setdefaultprocessorversionrequest *GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c := &ProjectsLocationsProcessorsSetDefaultProcessorVersionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.processor = processor
	c.googleclouddocumentaiv1beta3setdefaultprocessorversionrequest = googleclouddocumentaiv1beta3setdefaultprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Context(ctx context.Context) *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3setdefaultprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+processor}:setDefaultProcessorVersion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"processor": c.processor,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.setDefaultProcessorVersion" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsSetDefaultProcessorVersionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Set the default (active) version of a Processor that will be used in ProcessDocument and BatchProcessDocuments.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}:setDefaultProcessorVersion",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.setDefaultProcessorVersion",
	//   "parameterOrder": [
	//     "processor"
	//   ],
	//   "parameters": {
	//     "processor": {
	//       "description": "Required. The resource name of the Processor to change default version.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+processor}:setDefaultProcessorVersion",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.updateDataset":

type ProjectsLocationsProcessorsUpdateDatasetCall struct {
	s                                   *Service
	name                                string
	googleclouddocumentaiv1beta3dataset *GoogleCloudDocumentaiV1beta3Dataset
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// UpdateDataset: Updates metadata associated with a dataset.
//
//   - name: Dataset resource name. Format:
//     `projects/{project}/locations/{location}/processors/{processor}/data
//     set`.
func (r *ProjectsLocationsProcessorsService) UpdateDataset(name string, googleclouddocumentaiv1beta3dataset *GoogleCloudDocumentaiV1beta3Dataset) *ProjectsLocationsProcessorsUpdateDatasetCall {
	c := &ProjectsLocationsProcessorsUpdateDatasetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3dataset = googleclouddocumentaiv1beta3dataset
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// applies to the resource.
func (c *ProjectsLocationsProcessorsUpdateDatasetCall) UpdateMask(updateMask string) *ProjectsLocationsProcessorsUpdateDatasetCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsUpdateDatasetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsUpdateDatasetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsUpdateDatasetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsUpdateDatasetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsUpdateDatasetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsUpdateDatasetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3dataset)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.updateDataset" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsUpdateDatasetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates metadata associated with a dataset.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset",
	//   "httpMethod": "PATCH",
	//   "id": "documentai.projects.locations.processors.updateDataset",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Dataset resource name. Format: `projects/{project}/locations/{location}/processors/{processor}/dataset`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The update mask applies to the resource.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3Dataset"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.dataset.batchDeleteDocuments":

type ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall struct {
	s                                                       *Service
	dataset                                                 string
	googleclouddocumentaiv1beta3batchdeletedocumentsrequest *GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// BatchDeleteDocuments: Deletes a set of documents.
//
//   - dataset: The dataset resource name. Format:
//     projects/{project}/locations/{location}/processors/{processor}/datas
//     et.
func (r *ProjectsLocationsProcessorsDatasetService) BatchDeleteDocuments(dataset string, googleclouddocumentaiv1beta3batchdeletedocumentsrequest *GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest) *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall {
	c := &ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	c.googleclouddocumentaiv1beta3batchdeletedocumentsrequest = googleclouddocumentaiv1beta3batchdeletedocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3batchdeletedocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+dataset}:batchDeleteDocuments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.batchDeleteDocuments" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDatasetBatchDeleteDocumentsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a set of documents.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset:batchDeleteDocuments",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.dataset.batchDeleteDocuments",
	//   "parameterOrder": [
	//     "dataset"
	//   ],
	//   "parameters": {
	//     "dataset": {
	//       "description": "Required. The dataset resource name. Format: projects/{project}/locations/{location}/processors/{processor}/dataset",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+dataset}:batchDeleteDocuments",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.dataset.getDatasetSchema":

type ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDatasetSchema: Gets the `DatasetSchema` of a `Dataset`.
//
//   - name: The dataset schema resource name. Format:
//     projects/{project}/locations/{location}/processors/{processor}/datas
//     et/datasetSchema.
func (r *ProjectsLocationsProcessorsDatasetService) GetDatasetSchema(name string) *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall {
	c := &ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// VisibleFieldsOnly sets the optional parameter "visibleFieldsOnly": If
// set, only returns the visible fields of the schema.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) VisibleFieldsOnly(visibleFieldsOnly bool) *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall {
	c.urlParams_.Set("visibleFieldsOnly", fmt.Sprint(visibleFieldsOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.getDatasetSchema" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3DatasetSchema or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3DatasetSchema.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsDatasetGetDatasetSchemaCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3DatasetSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3DatasetSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the `DatasetSchema` of a `Dataset`.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset/datasetSchema",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.dataset.getDatasetSchema",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The dataset schema resource name. Format: projects/{project}/locations/{location}/processors/{processor}/dataset/datasetSchema",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset/datasetSchema$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "visibleFieldsOnly": {
	//       "description": "If set, only returns the visible fields of the schema.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3DatasetSchema"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.dataset.getDocument":

type ProjectsLocationsProcessorsDatasetGetDocumentCall struct {
	s            *Service
	dataset      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDocument: Returns relevant fields present in the requested
// document.
//
//   - dataset: The resource name of the dataset that the document belongs
//     to . Format:
//     projects/{project}/locations/{location}/processors/{processor}/datas
//     et.
func (r *ProjectsLocationsProcessorsDatasetService) GetDocument(dataset string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c := &ProjectsLocationsProcessorsDatasetGetDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	return c
}

// DocumentIdGcsManagedDocIdCwDocId sets the optional parameter
// "documentId.gcsManagedDocId.cwDocId": Id of the document (indexed)
// managed by Content Warehouse.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdGcsManagedDocIdCwDocId(documentIdGcsManagedDocIdCwDocId string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.gcsManagedDocId.cwDocId", documentIdGcsManagedDocIdCwDocId)
	return c
}

// DocumentIdGcsManagedDocIdGcsUri sets the optional parameter
// "documentId.gcsManagedDocId.gcsUri": Required. The Cloud Storage URI
// where the actual document is stored.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdGcsManagedDocIdGcsUri(documentIdGcsManagedDocIdGcsUri string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.gcsManagedDocId.gcsUri", documentIdGcsManagedDocIdGcsUri)
	return c
}

// DocumentIdRevisionRefLatestProcessorVersion sets the optional
// parameter "documentId.revisionRef.latestProcessorVersion": Reads the
// revision generated by the processor version. The format takes the
// full resource name of processor version.
// `projects/{project}/locations/{location}/processors/{processor}/proces
// sorVersions/{processorVersion}`
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdRevisionRefLatestProcessorVersion(documentIdRevisionRefLatestProcessorVersion string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.revisionRef.latestProcessorVersion", documentIdRevisionRefLatestProcessorVersion)
	return c
}

// DocumentIdRevisionRefRevisionCase sets the optional parameter
// "documentId.revisionRef.revisionCase": Reads the revision by the
// predefined case.
//
// Possible values:
//
//	"REVISION_CASE_UNSPECIFIED" - Unspecified case, fall back to read
//
// the `LATEST_HUMAN_REVIEW`.
//
//	"LATEST_HUMAN_REVIEW" - The latest revision made by a human.
//	"LATEST_TIMESTAMP" - The latest revision based on timestamp.
//	"BASE_OCR_REVISION" - The first (OCR) revision.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdRevisionRefRevisionCase(documentIdRevisionRefRevisionCase string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.revisionRef.revisionCase", documentIdRevisionRefRevisionCase)
	return c
}

// DocumentIdRevisionRefRevisionId sets the optional parameter
// "documentId.revisionRef.revisionId": Reads the revision given by the
// id.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdRevisionRefRevisionId(documentIdRevisionRefRevisionId string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.revisionRef.revisionId", documentIdRevisionRefRevisionId)
	return c
}

// DocumentIdUnmanagedDocIdDocId sets the optional parameter
// "documentId.unmanagedDocId.docId": Required. The id of the document.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) DocumentIdUnmanagedDocIdDocId(documentIdUnmanagedDocIdDocId string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("documentId.unmanagedDocId.docId", documentIdUnmanagedDocIdDocId)
	return c
}

// PageRangeEnd sets the optional parameter "pageRange.end": Last page
// number (one-based index) to be returned.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) PageRangeEnd(pageRangeEnd int64) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("pageRange.end", fmt.Sprint(pageRangeEnd))
	return c
}

// PageRangeStart sets the optional parameter "pageRange.start": First
// page number (one-based index) to be returned.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) PageRangeStart(pageRangeStart int64) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("pageRange.start", fmt.Sprint(pageRangeStart))
	return c
}

// ReadMask sets the optional parameter "readMask": If set, only fields
// listed here will be returned. Otherwise, all fields will be returned
// by default.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) ReadMask(readMask string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetGetDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+dataset}:getDocument")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.getDocument" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3GetDocumentResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3GetDocumentResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsDatasetGetDocumentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3GetDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3GetDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns relevant fields present in the requested document.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset:getDocument",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.dataset.getDocument",
	//   "parameterOrder": [
	//     "dataset"
	//   ],
	//   "parameters": {
	//     "dataset": {
	//       "description": "Required. The resource name of the dataset that the document belongs to . Format: projects/{project}/locations/{location}/processors/{processor}/dataset",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "documentId.gcsManagedDocId.cwDocId": {
	//       "deprecated": true,
	//       "description": "Id of the document (indexed) managed by Content Warehouse.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "documentId.gcsManagedDocId.gcsUri": {
	//       "description": "Required. The Cloud Storage URI where the actual document is stored.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "documentId.revisionRef.latestProcessorVersion": {
	//       "description": "Reads the revision generated by the processor version. The format takes the full resource name of processor version. `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "documentId.revisionRef.revisionCase": {
	//       "description": "Reads the revision by the predefined case.",
	//       "enum": [
	//         "REVISION_CASE_UNSPECIFIED",
	//         "LATEST_HUMAN_REVIEW",
	//         "LATEST_TIMESTAMP",
	//         "BASE_OCR_REVISION"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified case, fall back to read the `LATEST_HUMAN_REVIEW`.",
	//         "The latest revision made by a human.",
	//         "The latest revision based on timestamp.",
	//         "The first (OCR) revision."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "documentId.revisionRef.revisionId": {
	//       "description": "Reads the revision given by the id.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "documentId.unmanagedDocId.docId": {
	//       "description": "Required. The id of the document.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageRange.end": {
	//       "description": "Last page number (one-based index) to be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageRange.start": {
	//       "description": "First page number (one-based index) to be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "readMask": {
	//       "description": "If set, only fields listed here will be returned. Otherwise, all fields will be returned by default.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+dataset}:getDocument",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3GetDocumentResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.dataset.importDocuments":

type ProjectsLocationsProcessorsDatasetImportDocumentsCall struct {
	s                                                  *Service
	dataset                                            string
	googleclouddocumentaiv1beta3importdocumentsrequest *GoogleCloudDocumentaiV1beta3ImportDocumentsRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// ImportDocuments: Import documents into a dataset.
//
//   - dataset: The dataset resource name. Format:
//     projects/{project}/locations/{location}/processors/{processor}/datas
//     et.
func (r *ProjectsLocationsProcessorsDatasetService) ImportDocuments(dataset string, googleclouddocumentaiv1beta3importdocumentsrequest *GoogleCloudDocumentaiV1beta3ImportDocumentsRequest) *ProjectsLocationsProcessorsDatasetImportDocumentsCall {
	c := &ProjectsLocationsProcessorsDatasetImportDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	c.googleclouddocumentaiv1beta3importdocumentsrequest = googleclouddocumentaiv1beta3importdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetImportDocumentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetImportDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetImportDocumentsCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetImportDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetImportDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetImportDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3importdocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+dataset}:importDocuments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.importDocuments" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsDatasetImportDocumentsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Import documents into a dataset.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset:importDocuments",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.dataset.importDocuments",
	//   "parameterOrder": [
	//     "dataset"
	//   ],
	//   "parameters": {
	//     "dataset": {
	//       "description": "Required. The dataset resource name. Format: projects/{project}/locations/{location}/processors/{processor}/dataset",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+dataset}:importDocuments",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ImportDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.dataset.listDocuments":

type ProjectsLocationsProcessorsDatasetListDocumentsCall struct {
	s                                                *Service
	dataset                                          string
	googleclouddocumentaiv1beta3listdocumentsrequest *GoogleCloudDocumentaiV1beta3ListDocumentsRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// ListDocuments: Returns a list of documents present in the dataset.
//
//   - dataset: The resource name of the dataset to be listed. Format:
//     projects/{project}/locations/{location}/processors/{processor}/datas
//     et.
func (r *ProjectsLocationsProcessorsDatasetService) ListDocuments(dataset string, googleclouddocumentaiv1beta3listdocumentsrequest *GoogleCloudDocumentaiV1beta3ListDocumentsRequest) *ProjectsLocationsProcessorsDatasetListDocumentsCall {
	c := &ProjectsLocationsProcessorsDatasetListDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	c.googleclouddocumentaiv1beta3listdocumentsrequest = googleclouddocumentaiv1beta3listdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetListDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetListDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3listdocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+dataset}:listDocuments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.listDocuments" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ListDocumentsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ListDocumentsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of documents present in the dataset.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset:listDocuments",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.dataset.listDocuments",
	//   "parameterOrder": [
	//     "dataset"
	//   ],
	//   "parameters": {
	//     "dataset": {
	//       "description": "Required. The resource name of the dataset to be listed. Format: projects/{project}/locations/{location}/processors/{processor}/dataset",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+dataset}:listDocuments",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListDocumentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsDatasetListDocumentsCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1beta3ListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleclouddocumentaiv1beta3listdocumentsrequest.PageToken = pt }(c.googleclouddocumentaiv1beta3listdocumentsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleclouddocumentaiv1beta3listdocumentsrequest.PageToken = x.NextPageToken
	}
}

// method id "documentai.projects.locations.processors.dataset.updateDatasetSchema":

type ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall struct {
	s                                         *Service
	name                                      string
	googleclouddocumentaiv1beta3datasetschema *GoogleCloudDocumentaiV1beta3DatasetSchema
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// UpdateDatasetSchema: Updates a `DatasetSchema`.
//
//   - name: Dataset schema resource name. Format:
//     `projects/{project}/locations/{location}/processors/{processor}/data
//     set/datasetSchema`.
func (r *ProjectsLocationsProcessorsDatasetService) UpdateDatasetSchema(name string, googleclouddocumentaiv1beta3datasetschema *GoogleCloudDocumentaiV1beta3DatasetSchema) *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall {
	c := &ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3datasetschema = googleclouddocumentaiv1beta3datasetschema
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// applies to the resource.
func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) UpdateMask(updateMask string) *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) Context(ctx context.Context) *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3datasetschema)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.dataset.updateDatasetSchema" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3DatasetSchema or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3DatasetSchema.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsDatasetUpdateDatasetSchemaCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3DatasetSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3DatasetSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a `DatasetSchema`.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/dataset/datasetSchema",
	//   "httpMethod": "PATCH",
	//   "id": "documentai.projects.locations.processors.dataset.updateDatasetSchema",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Dataset schema resource name. Format: `projects/{project}/locations/{location}/processors/{processor}/dataset/datasetSchema`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/dataset/datasetSchema$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The update mask applies to the resource.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3DatasetSchema"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3DatasetSchema"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.humanReviewConfig.reviewDocument":

type ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall struct {
	s                                                 *Service
	humanReviewConfig                                 string
	googleclouddocumentaiv1beta3reviewdocumentrequest *GoogleCloudDocumentaiV1beta3ReviewDocumentRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// ReviewDocument: Send a document for Human Review. The input document
// should be processed by the specified processor.
//
//   - humanReviewConfig: The resource name of the HumanReviewConfig that
//     the document will be reviewed with.
func (r *ProjectsLocationsProcessorsHumanReviewConfigService) ReviewDocument(humanReviewConfig string, googleclouddocumentaiv1beta3reviewdocumentrequest *GoogleCloudDocumentaiV1beta3ReviewDocumentRequest) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c := &ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.humanReviewConfig = humanReviewConfig
	c.googleclouddocumentaiv1beta3reviewdocumentrequest = googleclouddocumentaiv1beta3reviewdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Context(ctx context.Context) *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3reviewdocumentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+humanReviewConfig}:reviewDocument")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"humanReviewConfig": c.humanReviewConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.humanReviewConfig.reviewDocument" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsHumanReviewConfigReviewDocumentCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Send a document for Human Review. The input document should be processed by the specified processor.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/humanReviewConfig:reviewDocument",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.humanReviewConfig.reviewDocument",
	//   "parameterOrder": [
	//     "humanReviewConfig"
	//   ],
	//   "parameters": {
	//     "humanReviewConfig": {
	//       "description": "Required. The resource name of the HumanReviewConfig that the document will be reviewed with.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/humanReviewConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+humanReviewConfig}:reviewDocument",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ReviewDocumentRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.batchProcess":

type ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall struct {
	s                                               *Service
	name                                            string
	googleclouddocumentaiv1beta3batchprocessrequest *GoogleCloudDocumentaiV1beta3BatchProcessRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// BatchProcess: LRO endpoint to batch process many documents. The
// output is written to Cloud Storage as JSON in the [Document] format.
//
//   - name: The resource name of Processor or ProcessorVersion. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`,
//     or
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) BatchProcess(name string, googleclouddocumentaiv1beta3batchprocessrequest *GoogleCloudDocumentaiV1beta3BatchProcessRequest) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3batchprocessrequest = googleclouddocumentaiv1beta3batchprocessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3batchprocessrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:batchProcess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.batchProcess" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsBatchProcessCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "LRO endpoint to batch process many documents. The output is written to Cloud Storage as JSON in the [Document] format.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}:batchProcess",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.batchProcess",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project}/locations/{location}/processors/{processor}`, or `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:batchProcess",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3BatchProcessRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.delete":

type ProjectsLocationsProcessorsProcessorVersionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the processor version, all artifacts under the
// processor version will be deleted.
//
// - name: The processor version resource name to be deleted.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Delete(name string) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the processor version, all artifacts under the processor version will be deleted.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}",
	//   "httpMethod": "DELETE",
	//   "id": "documentai.projects.locations.processors.processorVersions.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor version resource name to be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.deploy":

type ProjectsLocationsProcessorsProcessorVersionsDeployCall struct {
	s                                                         *Service
	name                                                      string
	googleclouddocumentaiv1beta3deployprocessorversionrequest *GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Deploy: Deploys the processor version.
//
// - name: The processor version resource name to be deployed.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Deploy(name string, googleclouddocumentaiv1beta3deployprocessorversionrequest *GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3deployprocessorversionrequest = googleclouddocumentaiv1beta3deployprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3deployprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.deploy" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsDeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deploys the processor version.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}:deploy",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.deploy",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor version resource name to be deployed.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:deploy",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion":

type ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall struct {
	s                                                           *Service
	processorVersion                                            string
	googleclouddocumentaiv1beta3evaluateprocessorversionrequest *GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// EvaluateProcessorVersion: Evaluates a ProcessorVersion against
// annotated documents, producing an Evaluation.
//
//   - processorVersion: The resource name of the ProcessorVersion to
//     evaluate.
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) EvaluateProcessorVersion(processorVersion string, googleclouddocumentaiv1beta3evaluateprocessorversionrequest *GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.processorVersion = processorVersion
	c.googleclouddocumentaiv1beta3evaluateprocessorversionrequest = googleclouddocumentaiv1beta3evaluateprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3evaluateprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+processorVersion}:evaluateProcessorVersion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"processorVersion": c.processorVersion,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluateProcessorVersionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Evaluates a ProcessorVersion against annotated documents, producing an Evaluation.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}:evaluateProcessorVersion",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion",
	//   "parameterOrder": [
	//     "processorVersion"
	//   ],
	//   "parameters": {
	//     "processorVersion": {
	//       "description": "Required. The resource name of the ProcessorVersion to evaluate. `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+processorVersion}:evaluateProcessorVersion",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.get":

type ProjectsLocationsProcessorsProcessorVersionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a processor version detail.
//
// - name: The processor resource name.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Get(name string) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.get" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ProcessorVersion or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ProcessorVersion.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ProcessorVersion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ProcessorVersion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a processor version detail.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.processorVersions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessorVersion"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.importProcessorVersion":

type ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall struct {
	s                                                         *Service
	parent                                                    string
	googleclouddocumentaiv1beta3importprocessorversionrequest *GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// ImportProcessorVersion: Imports a processor version from source
// processor version.
//
//   - parent: The destination processor name to create the processor
//     version in. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) ImportProcessorVersion(parent string, googleclouddocumentaiv1beta3importprocessorversionrequest *GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta3importprocessorversionrequest = googleclouddocumentaiv1beta3importprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3importprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processorVersions:importProcessorVersion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.importProcessorVersion" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsImportProcessorVersionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Imports a processor version from source processor version.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions:importProcessorVersion",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.importProcessorVersion",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The destination processor name to create the processor version in. Format: `projects/{project}/locations/{location}/processors/{processor}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processorVersions:importProcessorVersion",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.list":

type ProjectsLocationsProcessorsProcessorVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all versions of a processor.
//
//   - parent: The parent (project, location and processor) to list all
//     versions. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) List(parent string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of processor versions to return. If unspecified, at most `10`
// processor versions will be returned. The maximum value is `20`.
// Values above `20` will be coerced to `20`.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": We will return the
// processor versions sorted by creation time. The page token will point
// to the next processor version.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processorVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.list" call.
// Exactly one of
// *GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all versions of a processor.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.processorVersions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of processor versions to return. If unspecified, at most `10` processor versions will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "We will return the processor versions sorted by creation time. The page token will point to the next processor version.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent (project, location and processor) to list all versions. Format: `projects/{project}/locations/{location}/processors/{processor}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processorVersions",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsProcessorVersionsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "documentai.projects.locations.processors.processorVersions.process":

type ProjectsLocationsProcessorsProcessorVersionsProcessCall struct {
	s                                          *Service
	name                                       string
	googleclouddocumentaiv1beta3processrequest *GoogleCloudDocumentaiV1beta3ProcessRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Process: Processes a single document.
//
//   - name: The resource name of the Processor or ProcessorVersion to use
//     for processing. If a Processor is specified, the server will use
//     its default version. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`,
//     or
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Process(name string, googleclouddocumentaiv1beta3processrequest *GoogleCloudDocumentaiV1beta3ProcessRequest) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsProcessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3processrequest = googleclouddocumentaiv1beta3processrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsProcessCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3processrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:process")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.process" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ProcessResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDocumentaiV1beta3ProcessResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsProcessCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ProcessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ProcessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Processes a single document.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}:process",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.process",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project}/locations/{location}/processors/{processor}`, or `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:process",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ProcessResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.train":

type ProjectsLocationsProcessorsProcessorVersionsTrainCall struct {
	s                                                        *Service
	parent                                                   string
	googleclouddocumentaiv1beta3trainprocessorversionrequest *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Train: Trains a new processor version. Operation metadata is returned
// as TrainProcessorVersionMetadata.
//
//   - parent: The parent (project, location and processor) to create the
//     new version for. Format:
//     `projects/{project}/locations/{location}/processors/{processor}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Train(parent string, googleclouddocumentaiv1beta3trainprocessorversionrequest *GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsTrainCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddocumentaiv1beta3trainprocessorversionrequest = googleclouddocumentaiv1beta3trainprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsTrainCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3trainprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/processorVersions:train")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.train" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsTrainCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Trains a new processor version. Operation metadata is returned as TrainProcessorVersionMetadata.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions:train",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.train",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent (project, location and processor) to create the new version for. Format: `projects/{project}/locations/{location}/processors/{processor}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/processorVersions:train",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.undeploy":

type ProjectsLocationsProcessorsProcessorVersionsUndeployCall struct {
	s                                                           *Service
	name                                                        string
	googleclouddocumentaiv1beta3undeployprocessorversionrequest *GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Undeploy: Undeploys the processor version.
//
// - name: The processor version resource name to be undeployed.
func (r *ProjectsLocationsProcessorsProcessorVersionsService) Undeploy(name string, googleclouddocumentaiv1beta3undeployprocessorversionrequest *GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsUndeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddocumentaiv1beta3undeployprocessorversionrequest = googleclouddocumentaiv1beta3undeployprocessorversionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsUndeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddocumentaiv1beta3undeployprocessorversionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}:undeploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.undeploy" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsUndeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Undeploys the processor version.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}:undeploy",
	//   "httpMethod": "POST",
	//   "id": "documentai.projects.locations.processors.processorVersions.undeploy",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The processor version resource name to be undeployed.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}:undeploy",
	//   "request": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.evaluations.get":

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a specific evaluation.
//
//   - name: The resource name of the Evaluation to get.
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}/evaluations/{evaluation}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService) Get(name string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluations.get" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3Evaluation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDocumentaiV1beta3Evaluation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3Evaluation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3Evaluation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a specific evaluation.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}/evaluations/{evaluationsId}",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.processorVersions.evaluations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Evaluation to get. `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}/evaluations/{evaluation}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+/evaluations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3Evaluation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "documentai.projects.locations.processors.processorVersions.evaluations.list":

type ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a set of evaluations for a given processor version.
//
//   - parent: The resource name of the ProcessorVersion to list
//     evaluations for.
//     `projects/{project}/locations/{location}/processors/{processor}/proc
//     essorVersions/{processorVersion}`.
func (r *ProjectsLocationsProcessorsProcessorVersionsEvaluationsService) List(parent string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c := &ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size. If unspecified, at most `5` evaluations are returned. The
// maximum value is `100`. Values above `100` are coerced to `100`.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) PageSize(pageSize int64) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListEvaluations` call. Provide this to
// retrieve the subsequent page.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) PageToken(pageToken string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Context(ctx context.Context) *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/{+parent}/evaluations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "documentai.projects.locations.processors.processorVersions.evaluations.list" call.
// Exactly one of *GoogleCloudDocumentaiV1beta3ListEvaluationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDocumentaiV1beta3ListEvaluationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDocumentaiV1beta3ListEvaluationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDocumentaiV1beta3ListEvaluationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a set of evaluations for a given processor version.",
	//   "flatPath": "v1beta3/projects/{projectsId}/locations/{locationsId}/processors/{processorsId}/processorVersions/{processorVersionsId}/evaluations",
	//   "httpMethod": "GET",
	//   "id": "documentai.projects.locations.processors.processorVersions.evaluations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The standard list page size. If unspecified, at most `5` evaluations are returned. The maximum value is `100`. Values above `100` are coerced to `100`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListEvaluations` call. Provide this to retrieve the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the ProcessorVersion to list evaluations for. `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/processors/[^/]+/processorVersions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta3/{+parent}/evaluations",
	//   "response": {
	//     "$ref": "GoogleCloudDocumentaiV1beta3ListEvaluationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsProcessorsProcessorVersionsEvaluationsListCall) Pages(ctx context.Context, f func(*GoogleCloudDocumentaiV1beta3ListEvaluationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
