// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package vmwareengine provides access to the VMware Engine API.
//
// For product documentation, see: https://cloud.google.com/solutions/vmware-as-a-service
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/vmwareengine/v1"
//	...
//	ctx := context.Background()
//	vmwareengineService, err := vmwareengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	vmwareengineService, err := vmwareengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	vmwareengineService, err := vmwareengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package vmwareengine // import "google.golang.org/api/vmwareengine/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "vmwareengine:v1"
const apiName = "vmwareengine"
const apiVersion = "v1"
const basePath = "https://vmwareengine.googleapis.com/"
const basePathTemplate = "https://vmwareengine.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://vmwareengine.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Global = NewProjectsLocationsGlobalService(s)
	rs.NetworkPolicies = NewProjectsLocationsNetworkPoliciesService(s)
	rs.NodeTypes = NewProjectsLocationsNodeTypesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PrivateClouds = NewProjectsLocationsPrivateCloudsService(s)
	rs.PrivateConnections = NewProjectsLocationsPrivateConnectionsService(s)
	rs.VmwareEngineNetworks = NewProjectsLocationsVmwareEngineNetworksService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Global *ProjectsLocationsGlobalService

	NetworkPolicies *ProjectsLocationsNetworkPoliciesService

	NodeTypes *ProjectsLocationsNodeTypesService

	Operations *ProjectsLocationsOperationsService

	PrivateClouds *ProjectsLocationsPrivateCloudsService

	PrivateConnections *ProjectsLocationsPrivateConnectionsService

	VmwareEngineNetworks *ProjectsLocationsVmwareEngineNetworksService
}

func NewProjectsLocationsGlobalService(s *Service) *ProjectsLocationsGlobalService {
	rs := &ProjectsLocationsGlobalService{s: s}
	rs.DnsBindPermission = NewProjectsLocationsGlobalDnsBindPermissionService(s)
	rs.NetworkPeerings = NewProjectsLocationsGlobalNetworkPeeringsService(s)
	return rs
}

type ProjectsLocationsGlobalService struct {
	s *Service

	DnsBindPermission *ProjectsLocationsGlobalDnsBindPermissionService

	NetworkPeerings *ProjectsLocationsGlobalNetworkPeeringsService
}

func NewProjectsLocationsGlobalDnsBindPermissionService(s *Service) *ProjectsLocationsGlobalDnsBindPermissionService {
	rs := &ProjectsLocationsGlobalDnsBindPermissionService{s: s}
	return rs
}

type ProjectsLocationsGlobalDnsBindPermissionService struct {
	s *Service
}

func NewProjectsLocationsGlobalNetworkPeeringsService(s *Service) *ProjectsLocationsGlobalNetworkPeeringsService {
	rs := &ProjectsLocationsGlobalNetworkPeeringsService{s: s}
	rs.PeeringRoutes = NewProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService(s)
	return rs
}

type ProjectsLocationsGlobalNetworkPeeringsService struct {
	s *Service

	PeeringRoutes *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService
}

func NewProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService(s *Service) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService {
	rs := &ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService{s: s}
	return rs
}

type ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService struct {
	s *Service
}

func NewProjectsLocationsNetworkPoliciesService(s *Service) *ProjectsLocationsNetworkPoliciesService {
	rs := &ProjectsLocationsNetworkPoliciesService{s: s}
	rs.ExternalAccessRules = NewProjectsLocationsNetworkPoliciesExternalAccessRulesService(s)
	return rs
}

type ProjectsLocationsNetworkPoliciesService struct {
	s *Service

	ExternalAccessRules *ProjectsLocationsNetworkPoliciesExternalAccessRulesService
}

func NewProjectsLocationsNetworkPoliciesExternalAccessRulesService(s *Service) *ProjectsLocationsNetworkPoliciesExternalAccessRulesService {
	rs := &ProjectsLocationsNetworkPoliciesExternalAccessRulesService{s: s}
	return rs
}

type ProjectsLocationsNetworkPoliciesExternalAccessRulesService struct {
	s *Service
}

func NewProjectsLocationsNodeTypesService(s *Service) *ProjectsLocationsNodeTypesService {
	rs := &ProjectsLocationsNodeTypesService{s: s}
	return rs
}

type ProjectsLocationsNodeTypesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsService(s *Service) *ProjectsLocationsPrivateCloudsService {
	rs := &ProjectsLocationsPrivateCloudsService{s: s}
	rs.Clusters = NewProjectsLocationsPrivateCloudsClustersService(s)
	rs.ExternalAddresses = NewProjectsLocationsPrivateCloudsExternalAddressesService(s)
	rs.HcxActivationKeys = NewProjectsLocationsPrivateCloudsHcxActivationKeysService(s)
	rs.LoggingServers = NewProjectsLocationsPrivateCloudsLoggingServersService(s)
	rs.ManagementDnsZoneBindings = NewProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService(s)
	rs.Subnets = NewProjectsLocationsPrivateCloudsSubnetsService(s)
	return rs
}

type ProjectsLocationsPrivateCloudsService struct {
	s *Service

	Clusters *ProjectsLocationsPrivateCloudsClustersService

	ExternalAddresses *ProjectsLocationsPrivateCloudsExternalAddressesService

	HcxActivationKeys *ProjectsLocationsPrivateCloudsHcxActivationKeysService

	LoggingServers *ProjectsLocationsPrivateCloudsLoggingServersService

	ManagementDnsZoneBindings *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService

	Subnets *ProjectsLocationsPrivateCloudsSubnetsService
}

func NewProjectsLocationsPrivateCloudsClustersService(s *Service) *ProjectsLocationsPrivateCloudsClustersService {
	rs := &ProjectsLocationsPrivateCloudsClustersService{s: s}
	rs.Nodes = NewProjectsLocationsPrivateCloudsClustersNodesService(s)
	return rs
}

type ProjectsLocationsPrivateCloudsClustersService struct {
	s *Service

	Nodes *ProjectsLocationsPrivateCloudsClustersNodesService
}

func NewProjectsLocationsPrivateCloudsClustersNodesService(s *Service) *ProjectsLocationsPrivateCloudsClustersNodesService {
	rs := &ProjectsLocationsPrivateCloudsClustersNodesService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsClustersNodesService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsExternalAddressesService(s *Service) *ProjectsLocationsPrivateCloudsExternalAddressesService {
	rs := &ProjectsLocationsPrivateCloudsExternalAddressesService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsExternalAddressesService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsHcxActivationKeysService(s *Service) *ProjectsLocationsPrivateCloudsHcxActivationKeysService {
	rs := &ProjectsLocationsPrivateCloudsHcxActivationKeysService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsHcxActivationKeysService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsLoggingServersService(s *Service) *ProjectsLocationsPrivateCloudsLoggingServersService {
	rs := &ProjectsLocationsPrivateCloudsLoggingServersService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsLoggingServersService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService(s *Service) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService {
	rs := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService struct {
	s *Service
}

func NewProjectsLocationsPrivateCloudsSubnetsService(s *Service) *ProjectsLocationsPrivateCloudsSubnetsService {
	rs := &ProjectsLocationsPrivateCloudsSubnetsService{s: s}
	return rs
}

type ProjectsLocationsPrivateCloudsSubnetsService struct {
	s *Service
}

func NewProjectsLocationsPrivateConnectionsService(s *Service) *ProjectsLocationsPrivateConnectionsService {
	rs := &ProjectsLocationsPrivateConnectionsService{s: s}
	rs.PeeringRoutes = NewProjectsLocationsPrivateConnectionsPeeringRoutesService(s)
	return rs
}

type ProjectsLocationsPrivateConnectionsService struct {
	s *Service

	PeeringRoutes *ProjectsLocationsPrivateConnectionsPeeringRoutesService
}

func NewProjectsLocationsPrivateConnectionsPeeringRoutesService(s *Service) *ProjectsLocationsPrivateConnectionsPeeringRoutesService {
	rs := &ProjectsLocationsPrivateConnectionsPeeringRoutesService{s: s}
	return rs
}

type ProjectsLocationsPrivateConnectionsPeeringRoutesService struct {
	s *Service
}

func NewProjectsLocationsVmwareEngineNetworksService(s *Service) *ProjectsLocationsVmwareEngineNetworksService {
	rs := &ProjectsLocationsVmwareEngineNetworksService{s: s}
	return rs
}

type ProjectsLocationsVmwareEngineNetworksService struct {
	s *Service
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must
// have one or more AuditLogConfigs. If there are AuditConfigs for both
// `allServices` and a specific service, the union of the two
// AuditConfigs is used for that service: the log_types specified in
// each AuditConfig are enabled, and the exempted_members in each
// AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// `jose@example.com` from DATA_READ logging, and `aliya@example.com`
// from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_
	// id}/subject/{subject_attribute_value}`: A single identity in a
	// workforce identity pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/attribute.{attribute_name}/{attribute_value}`: All workforce
	// identities with a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/*`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/gl
	// obal/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}
	// `: A single identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/group/{group_id}`: A workload
	// identity pool group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{at
	// tribute_value}`: All identities in a workload identity pool with a
	// certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/*`: All identities in a
	// workload identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered
	// user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/{pool_id}/subject/{subject_attribute_value}`: Deleted single
	// identity in a workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/my-pool-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cluster: A cluster in a private cloud.
type Cluster struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Management: Output only. True if the cluster is a management cluster;
	// false otherwise. There can only be one management cluster in a
	// private cloud and it has to be the first one.
	Management bool `json:"management,omitempty"`

	// Name: Output only. The resource name of this cluster. Resource names
	// are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/cl
	// usters/my-cluster`
	Name string `json:"name,omitempty"`

	// NodeTypeConfigs: Required. The map of cluster node types in this
	// cluster, where the key is canonical identifier of the node type
	// (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]NodeTypeConfig `json:"nodeTypeConfigs,omitempty"`

	// State: Output only. State of the resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - The Cluster is operational and can be used by the user.
	//   "CREATING" - The Cluster is being deployed.
	//   "UPDATING" - Adding or removing of a node to the cluster, any other
	// cluster specific updates.
	//   "DELETING" - The Cluster is being deleted.
	//   "REPAIRING" - The Cluster is undergoing maintenance, for example: a
	// failed node is getting replaced.
	State string `json:"state,omitempty"`

	// StretchedClusterConfig: Optional. Configuration of a stretched
	// cluster. Required for clusters that belong to a STRETCHED private
	// cloud.
	StretchedClusterConfig *StretchedClusterConfig `json:"stretchedClusterConfig,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Credentials: Credentials for a private cloud.
type Credentials struct {
	// Password: Initial password.
	Password string `json:"password,omitempty"`

	// Username: Initial username.
	Username string `json:"username,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Password") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Password") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Credentials) MarshalJSON() ([]byte, error) {
	type NoMethod Credentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DnsBindPermission: DnsBindPermission resource that contains the
// accounts having the consumer DNS bind permission on the corresponding
// intranet VPC of the consumer project.
type DnsBindPermission struct {
	// Name: Required. Output only. The name of the resource which stores
	// the users/service accounts having the permission to bind to the
	// corresponding intranet VPC of the consumer project. DnsBindPermission
	// is a global resource. Resource names are schemeless URIs that follow
	// the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global/dnsBindPermission`
	Name string `json:"name,omitempty"`

	// Principals: Output only. Users/Service accounts which have access for
	// binding on the intranet VPC project corresponding to the consumer
	// project.
	Principals []*Principal `json:"principals,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DnsBindPermission) MarshalJSON() ([]byte, error) {
	type NoMethod DnsBindPermission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DnsForwarding: DNS forwarding config. This config defines a list of
// domain to name server mappings, and is attached to the private cloud
// for custom domain resolution.
type DnsForwarding struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// ForwardingRules: Required. List of domain mappings to configure
	ForwardingRules []*ForwardingRule `json:"forwardingRules,omitempty"`

	// Name: Output only. The resource name of this DNS profile. Resource
	// names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dn
	// sForwarding`
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DnsForwarding) MarshalJSON() ([]byte, error) {
	type NoMethod DnsForwarding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalAccessRule: External access firewall rules for filtering
// incoming traffic destined to `ExternalAddress` resources.
type ExternalAccessRule struct {
	// Action: The action that the external access rule performs.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - Defaults to allow.
	//   "ALLOW" - Allows connections that match the other specified
	// components.
	//   "DENY" - Blocks connections that match the other specified
	// components.
	Action string `json:"action,omitempty"`

	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: User-provided description for this external access rule.
	Description string `json:"description,omitempty"`

	// DestinationIpRanges: If destination ranges are specified, the
	// external access rule applies only to the traffic that has a
	// destination IP address in these ranges. The specified IP addresses
	// must have reserved external IP addresses in the scope of the parent
	// network policy. To match all external IP addresses in the scope of
	// the parent network policy, specify `0.0.0.0/0`. To match a specific
	// external IP address, specify it using the `IpRange.external_address`
	// property.
	DestinationIpRanges []*IpRange `json:"destinationIpRanges,omitempty"`

	// DestinationPorts: A list of destination ports to which the external
	// access rule applies. This field is only applicable for the UDP or TCP
	// protocol. Each entry must be either an integer or a range. For
	// example: `["22"]`, `["80","443"]`, or `["12345-12349"]`. To match all
	// destination ports, specify `["0-65535"]`.
	DestinationPorts []string `json:"destinationPorts,omitempty"`

	// IpProtocol: The IP protocol to which the external access rule
	// applies. This value can be one of the following three protocol
	// strings (not case-sensitive): `tcp`, `udp`, or `icmp`.
	IpProtocol string `json:"ipProtocol,omitempty"`

	// Name: Output only. The resource name of this external access rule.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-policy/e
	// xternalAccessRules/my-rule`
	Name string `json:"name,omitempty"`

	// Priority: External access rule priority, which determines the
	// external access rule to use when multiple rules apply. If multiple
	// rules have the same priority, their ordering is non-deterministic. If
	// specific ordering is required, assign unique priorities to enforce
	// such ordering. The external access rule priority is an integer from
	// 100 to 4096, both inclusive. Lower integers indicate higher
	// precedence. For example, a rule with priority `100` has higher
	// precedence than a rule with priority `101`.
	Priority int64 `json:"priority,omitempty"`

	// SourceIpRanges: If source ranges are specified, the external access
	// rule applies only to traffic that has a source IP address in these
	// ranges. These ranges can either be expressed in the CIDR format or as
	// an IP address. As only inbound rules are supported, `ExternalAddress`
	// resources cannot be the source IP addresses of an external access
	// rule. To match all source addresses, specify `0.0.0.0/0`.
	SourceIpRanges []*IpRange `json:"sourceIpRanges,omitempty"`

	// SourcePorts: A list of source ports to which the external access rule
	// applies. This field is only applicable for the UDP or TCP protocol.
	// Each entry must be either an integer or a range. For example:
	// `["22"]`, `["80","443"]`, or `["12345-12349"]`. To match all source
	// ports, specify `["0-65535"]`.
	SourcePorts []string `json:"sourcePorts,omitempty"`

	// State: Output only. The state of the resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "ACTIVE" - The rule is ready.
	//   "CREATING" - The rule is being created.
	//   "UPDATING" - The rule is being updated.
	//   "DELETING" - The rule is being deleted.
	State string `json:"state,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalAccessRule) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalAccessRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalAddress: Represents an allocated external IP address and its
// corresponding internal IP address in a private cloud.
type ExternalAddress struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: User-provided description for this resource.
	Description string `json:"description,omitempty"`

	// ExternalIp: Output only. The external IP address of a workload VM.
	ExternalIp string `json:"externalIp,omitempty"`

	// InternalIp: The internal IP address of a workload VM.
	InternalIp string `json:"internalIp,omitempty"`

	// Name: Output only. The resource name of this external IP address.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/ex
	// ternalAddresses/my-address`
	Name string `json:"name,omitempty"`

	// State: Output only. The state of the resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - The address is ready.
	//   "CREATING" - The address is being created.
	//   "UPDATING" - The address is being updated.
	//   "DELETING" - The address is being deleted.
	State string `json:"state,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FetchNetworkPolicyExternalAddressesResponse: Response message for
// VmwareEngine.FetchNetworkPolicyExternalAddresses
type FetchNetworkPolicyExternalAddressesResponse struct {
	// ExternalAddresses: A list of external IP addresses assigned to VMware
	// workload VMs within the scope of the given network policy.
	ExternalAddresses []*ExternalAddress `json:"externalAddresses,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExternalAddresses")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAddresses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FetchNetworkPolicyExternalAddressesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FetchNetworkPolicyExternalAddressesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRule: A forwarding rule is a mapping of a `domain` to
// `name_servers`. This mapping allows VMware Engine to resolve domains
// for attached private clouds by forwarding DNS requests for a given
// domain to the specified nameservers.
type ForwardingRule struct {
	// Domain: Required. Domain used to resolve a `name_servers` list.
	Domain string `json:"domain,omitempty"`

	// NameServers: Required. List of DNS servers to use for domain
	// resolution
	NameServers []string `json:"nameServers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRule) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GrantDnsBindPermissionRequest: Request message for
// VmwareEngine.GrantDnsBindPermission
type GrantDnsBindPermissionRequest struct {
	// Principal: Required. The consumer provided user/service account which
	// needs to be granted permission to bind with the intranet VPC
	// corresponding to the consumer project.
	Principal *Principal `json:"principal,omitempty"`

	// RequestId: Optional. A request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server
	// will know to ignore the request if it has already been completed. The
	// server guarantees that a request doesn't result in creation of
	// duplicate commitments for at least 60 minutes. For example, consider
	// a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the
	// server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments. The request
	// ID must be a valid UUID with the exception that zero UUID is not
	// supported (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Principal") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Principal") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GrantDnsBindPermissionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GrantDnsBindPermissionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Hcx: Details about a HCX Cloud Manager appliance.
type Hcx struct {
	// Fqdn: Fully qualified domain name of the appliance.
	Fqdn string `json:"fqdn,omitempty"`

	// InternalIp: Internal IP address of the appliance.
	InternalIp string `json:"internalIp,omitempty"`

	// State: Output only. The state of the appliance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified appliance state. This is the
	// default value.
	//   "ACTIVE" - The appliance is operational and can be used.
	//   "CREATING" - The appliance is being deployed.
	State string `json:"state,omitempty"`

	// Version: Version of the appliance.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fqdn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fqdn") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Hcx) MarshalJSON() ([]byte, error) {
	type NoMethod Hcx
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HcxActivationKey: HCX activation key. A default key is created during
// private cloud provisioning, but this behavior is subject to change
// and you should always verify active keys. Use
// VmwareEngine.ListHcxActivationKeys to retrieve existing keys and
// VmwareEngine.CreateHcxActivationKey to create new ones.
type HcxActivationKey struct {
	// ActivationKey: Output only. HCX activation key.
	ActivationKey string `json:"activationKey,omitempty"`

	// CreateTime: Output only. Creation time of HCX activation key.
	CreateTime string `json:"createTime,omitempty"`

	// Name: Output only. The resource name of this HcxActivationKey.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxA
	// ctivationKeys/my-key`
	Name string `json:"name,omitempty"`

	// State: Output only. State of HCX activation key.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "AVAILABLE" - State of a newly generated activation key.
	//   "CONSUMED" - State of key when it has been used to activate HCX
	// appliance.
	//   "CREATING" - State of key when it is being created.
	State string `json:"state,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ActivationKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivationKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HcxActivationKey) MarshalJSON() ([]byte, error) {
	type NoMethod HcxActivationKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IpRange: An IP range provided in any one of the supported formats.
type IpRange struct {
	// ExternalAddress: The name of an `ExternalAddress` resource. The
	// external address must have been reserved in the scope of this
	// external access rule's parent network policy. Provide the external
	// address name in the form of
	// `projects/{project}/locations/{location}/privateClouds/{private_cloud}
	// /externalAddresses/{external_address}`. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/ex
	// ternalAddresses/my-address`.
	ExternalAddress string `json:"externalAddress,omitempty"`

	// IpAddress: A single IP address. For example: `10.0.0.5`.
	IpAddress string `json:"ipAddress,omitempty"`

	// IpAddressRange: An IP address range in the CIDR format. For example:
	// `10.0.0.0/24`.
	IpAddressRange string `json:"ipAddressRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternalAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAddress") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IpRange) MarshalJSON() ([]byte, error) {
	type NoMethod IpRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListClustersResponse: Response message for VmwareEngine.ListClusters
type ListClustersResponse struct {
	// Clusters: A list of private cloud clusters.
	Clusters []*Cluster `json:"clusters,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Clusters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClustersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListExternalAccessRulesResponse: Response message for
// VmwareEngine.ListExternalAccessRules
type ListExternalAccessRulesResponse struct {
	// ExternalAccessRules: A list of external access firewall rules.
	ExternalAccessRules []*ExternalAccessRule `json:"externalAccessRules,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExternalAccessRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAccessRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListExternalAccessRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExternalAccessRulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListExternalAddressesResponse: Response message for
// VmwareEngine.ListExternalAddresses
type ListExternalAddressesResponse struct {
	// ExternalAddresses: A list of external IP addresses.
	ExternalAddresses []*ExternalAddress `json:"externalAddresses,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExternalAddresses")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAddresses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListExternalAddressesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExternalAddressesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListHcxActivationKeysResponse: Response message for
// VmwareEngine.ListHcxActivationKeys
type ListHcxActivationKeysResponse struct {
	// HcxActivationKeys: List of HCX activation keys.
	HcxActivationKeys []*HcxActivationKey `json:"hcxActivationKeys,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "HcxActivationKeys")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HcxActivationKeys") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListHcxActivationKeysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHcxActivationKeysResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for
// Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*Location `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLoggingServersResponse: Response message for
// VmwareEngine.ListLoggingServers
type ListLoggingServersResponse struct {
	// LoggingServers: A list of Logging Servers.
	LoggingServers []*LoggingServer `json:"loggingServers,omitempty"`

	// NextPageToken: A token, which can be send as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "LoggingServers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoggingServers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListLoggingServersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLoggingServersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListManagementDnsZoneBindingsResponse: Response message for
// VmwareEngine.ListManagementDnsZoneBindings
type ListManagementDnsZoneBindingsResponse struct {
	// ManagementDnsZoneBindings: A list of management DNS zone bindings.
	ManagementDnsZoneBindings []*ManagementDnsZoneBinding `json:"managementDnsZoneBindings,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ManagementDnsZoneBindings") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ManagementDnsZoneBindings") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListManagementDnsZoneBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListManagementDnsZoneBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListNetworkPeeringsResponse: Response message for
// VmwareEngine.ListNetworkPeerings
type ListNetworkPeeringsResponse struct {
	// NetworkPeerings: A list of network peerings.
	NetworkPeerings []*NetworkPeering `json:"networkPeerings,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Unreachable resources.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NetworkPeerings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkPeerings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListNetworkPeeringsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNetworkPeeringsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListNetworkPoliciesResponse: Response message for
// VmwareEngine.ListNetworkPolicies
type ListNetworkPoliciesResponse struct {
	// NetworkPolicies: A list of network policies.
	NetworkPolicies []*NetworkPolicy `json:"networkPolicies,omitempty"`

	// NextPageToken: A token, which can be send as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NetworkPolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkPolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListNetworkPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNetworkPoliciesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListNodeTypesResponse: Response message for
// VmwareEngine.ListNodeTypes
type ListNodeTypesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// NodeTypes: A list of Node Types.
	NodeTypes []*NodeType `json:"nodeTypes,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListNodeTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNodeTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListNodesResponse: Response message for VmwareEngine.ListNodes
type ListNodesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Nodes: The nodes.
	Nodes []*Node `json:"nodes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListNodesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListNodesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPeeringRoutesResponse: Response message for
// VmwareEngine.ListPeeringRoutes
type ListPeeringRoutesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PeeringRoutes: A list of peering routes.
	PeeringRoutes []*PeeringRoute `json:"peeringRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPeeringRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPeeringRoutesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPrivateCloudsResponse: Response message for
// VmwareEngine.ListPrivateClouds
type ListPrivateCloudsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PrivateClouds: A list of private clouds.
	PrivateClouds []*PrivateCloud `json:"privateClouds,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPrivateCloudsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrivateCloudsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPrivateConnectionPeeringRoutesResponse: Response message for
// VmwareEngine.ListPrivateConnectionPeeringRoutes
type ListPrivateConnectionPeeringRoutesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PeeringRoutes: A list of peering routes.
	PeeringRoutes []*PeeringRoute `json:"peeringRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPrivateConnectionPeeringRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrivateConnectionPeeringRoutesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPrivateConnectionsResponse: Response message for
// VmwareEngine.ListPrivateConnections
type ListPrivateConnectionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PrivateConnections: A list of private connections.
	PrivateConnections []*PrivateConnection `json:"privateConnections,omitempty"`

	// Unreachable: Unreachable resources.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPrivateConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrivateConnectionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSubnetsResponse: Response message for VmwareEngine.ListSubnets
type ListSubnetsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Subnets: A list of subnets.
	Subnets []*Subnet `json:"subnets,omitempty"`

	// Unreachable: Locations that could not be reached when making an
	// aggregated query using wildcards.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSubnetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSubnetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListVmwareEngineNetworksResponse: Response message for
// VmwareEngine.ListVmwareEngineNetworks
type ListVmwareEngineNetworksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Unreachable resources.
	Unreachable []string `json:"unreachable,omitempty"`

	// VmwareEngineNetworks: A list of VMware Engine networks.
	VmwareEngineNetworks []*VmwareEngineNetwork `json:"vmwareEngineNetworks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListVmwareEngineNetworksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVmwareEngineNetworksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocationMetadata: VmwareEngine specific metadata for the given
// google.cloud.location.Location. It is returned as a content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Capabilities: Output only. Capabilities of this location.
	//
	// Possible values:
	//   "CAPABILITY_UNSPECIFIED" - The default value. This value is used if
	// the capability is omitted or unknown.
	//   "STRETCHED_CLUSTERS" - Stretch clusters are supported in this
	// location.
	Capabilities []string `json:"capabilities,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Capabilities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Capabilities") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LocationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoggingServer: Logging server to receive vCenter or ESXi logs.
type LoggingServer struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Hostname: Required. Fully-qualified domain name (FQDN) or IP Address
	// of the logging server.
	Hostname string `json:"hostname,omitempty"`

	// Name: Output only. The resource name of this logging server. Resource
	// names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/lo
	// ggingServers/my-logging-server`
	Name string `json:"name,omitempty"`

	// Port: Required. Port number at which the logging server receives
	// logs.
	Port int64 `json:"port,omitempty"`

	// Protocol: Required. Protocol used by vCenter to send logs to a
	// logging server.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Unspecified communications protocol. This
	// is the default value.
	//   "UDP" - UDP
	//   "TCP" - TCP
	Protocol string `json:"protocol,omitempty"`

	// SourceType: Required. The type of component that produces logs that
	// will be forwarded to this logging server.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - The default value. This value should
	// never be used.
	//   "ESXI" - Logs produced by ESXI hosts
	//   "VCSA" - Logs produced by vCenter server
	SourceType string `json:"sourceType,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoggingServer) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingServer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ManagementCluster: Management cluster configuration.
type ManagementCluster struct {
	// ClusterId: Required. The user-provided identifier of the new
	// `Cluster`. The identifier must meet the following requirements: *
	// Only contains 1-63 alphanumeric characters and hyphens * Begins with
	// an alphabetical character * Ends with a non-hyphen character * Not
	// formatted as a UUID * Complies with RFC 1034
	// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
	ClusterId string `json:"clusterId,omitempty"`

	// NodeTypeConfigs: Required. The map of cluster node types in this
	// cluster, where the key is canonical identifier of the node type
	// (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]NodeTypeConfig `json:"nodeTypeConfigs,omitempty"`

	// StretchedClusterConfig: Optional. Configuration of a stretched
	// cluster. Required for STRETCHED private clouds.
	StretchedClusterConfig *StretchedClusterConfig `json:"stretchedClusterConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ManagementCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ManagementCluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ManagementDnsZoneBinding: Represents a binding between a network and
// the management DNS zone. A management DNS zone is the Cloud DNS
// cross-project binding zone that VMware Engine creates for each
// private cloud. It contains FQDNs and corresponding IP addresses for
// the private cloud's ESXi hosts and management VM appliances like
// vCenter and NSX Manager.
type ManagementDnsZoneBinding struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: User-provided description for this resource.
	Description string `json:"description,omitempty"`

	// Name: Output only. The resource name of this binding. Resource names
	// are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/ma
	// nagementDnsZoneBindings/my-management-dns-zone-binding`
	Name string `json:"name,omitempty"`

	// State: Output only. The state of the resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - The binding is ready.
	//   "CREATING" - The binding is being created.
	//   "UPDATING" - The binding is being updated.
	//   "DELETING" - The binding is being deleted.
	//   "FAILED" - The binding has failed.
	State string `json:"state,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// VmwareEngineNetwork: Network to bind is a VMware Engine network.
	// Specify the name in the following form for VMware engine network:
	// `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engi
	// ne_network_id}`. `{project}` can either be a project number or a
	// project ID.
	VmwareEngineNetwork string `json:"vmwareEngineNetwork,omitempty"`

	// VpcNetwork: Network to bind is a standard consumer VPC. Specify the
	// name in the following form for consumer VPC network:
	// `projects/{project}/global/networks/{network_id}`. `{project}` can
	// either be a project number or a project ID.
	VpcNetwork string `json:"vpcNetwork,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ManagementDnsZoneBinding) MarshalJSON() ([]byte, error) {
	type NoMethod ManagementDnsZoneBinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NetworkConfig: Network configuration in the consumer project with
// which the peering has to be done.
type NetworkConfig struct {
	// DnsServerIp: Output only. DNS Server IP of the Private Cloud. All DNS
	// queries can be forwarded to this address for name resolution of
	// Private Cloud's management entities like vCenter, NSX-T Manager and
	// ESXi hosts.
	DnsServerIp string `json:"dnsServerIp,omitempty"`

	// ManagementCidr: Required. Management CIDR used by VMware management
	// appliances.
	ManagementCidr string `json:"managementCidr,omitempty"`

	// ManagementIpAddressLayoutVersion: Output only. The IP address layout
	// version of the management IP address range. Possible versions
	// include: * `managementIpAddressLayoutVersion=1`: Indicates the legacy
	// IP address layout used by some existing private clouds. This is no
	// longer supported for new private clouds as it does not support all
	// features. * `managementIpAddressLayoutVersion=2`: Indicates the
	// latest IP address layout used by all newly created private clouds.
	// This version supports all current features.
	ManagementIpAddressLayoutVersion int64 `json:"managementIpAddressLayoutVersion,omitempty"`

	// VmwareEngineNetwork: Optional. The relative resource name of the
	// VMware Engine network attached to the private cloud. Specify the name
	// in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_
	// engine_network_id}` where `{project}` can either be a project number
	// or a project ID.
	VmwareEngineNetwork string `json:"vmwareEngineNetwork,omitempty"`

	// VmwareEngineNetworkCanonical: Output only. The canonical name of the
	// VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{
	// vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `json:"vmwareEngineNetworkCanonical,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DnsServerIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DnsServerIp") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NetworkPeering: Details of a network peering.
type NetworkPeering struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. User-provided description for this network
	// peering.
	Description string `json:"description,omitempty"`

	// ExchangeSubnetRoutes: Optional. True if full mesh connectivity is
	// created and managed automatically between peered networks; false
	// otherwise. Currently this field is always true because Google Compute
	// Engine automatically creates and manages subnetwork routes between
	// two VPC networks when peering state is 'ACTIVE'.
	ExchangeSubnetRoutes bool `json:"exchangeSubnetRoutes,omitempty"`

	// ExportCustomRoutes: Optional. True if custom routes are exported to
	// the peered network; false otherwise. The default value is true.
	ExportCustomRoutes bool `json:"exportCustomRoutes,omitempty"`

	// ExportCustomRoutesWithPublicIp: Optional. True if all subnet routes
	// with a public IP address range are exported; false otherwise. The
	// default value is true. IPv4 special-use ranges
	// (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
	// exported to peers and are not controlled by this field.
	ExportCustomRoutesWithPublicIp bool `json:"exportCustomRoutesWithPublicIp,omitempty"`

	// ImportCustomRoutes: Optional. True if custom routes are imported from
	// the peered network; false otherwise. The default value is true.
	ImportCustomRoutes bool `json:"importCustomRoutes,omitempty"`

	// ImportCustomRoutesWithPublicIp: Optional. True if all subnet routes
	// with public IP address range are imported; false otherwise. The
	// default value is true. IPv4 special-use ranges
	// (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
	// imported to peers and are not controlled by this field.
	ImportCustomRoutesWithPublicIp bool `json:"importCustomRoutesWithPublicIp,omitempty"`

	// Name: Output only. The resource name of the network peering. Resource
	// names are scheme-less URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global/networkPeerings/my-peering`
	Name string `json:"name,omitempty"`

	// PeerMtu: Optional. Maximum transmission unit (MTU) in bytes. The
	// default value is `1500`. If a value of `0` is provided for this
	// field, VMware Engine uses the default value instead.
	PeerMtu int64 `json:"peerMtu,omitempty"`

	// PeerNetwork: Required. The relative resource name of the network to
	// peer with a standard VMware Engine network. The provided network can
	// be a consumer VPC network or another standard VMware Engine network.
	// If the `peer_network_type` is VMWARE_ENGINE_NETWORK, specify the name
	// in the form:
	// `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engi
	// ne_network_id}`. Otherwise specify the name in the form:
	// `projects/{project}/global/networks/{network_id}`, where `{project}`
	// can either be a project number or a project ID.
	PeerNetwork string `json:"peerNetwork,omitempty"`

	// PeerNetworkType: Required. The type of the network to peer with the
	// VMware Engine network.
	//
	// Possible values:
	//   "PEER_NETWORK_TYPE_UNSPECIFIED" - Unspecified
	//   "STANDARD" - Peering connection used for connecting to another VPC
	// network established by the same user. For example, a peering
	// connection to another VPC network in the same project or to an
	// on-premises network.
	//   "VMWARE_ENGINE_NETWORK" - Peering connection used for connecting to
	// another VMware Engine network.
	//   "PRIVATE_SERVICES_ACCESS" - Peering connection used for
	// establishing [private services
	// access](https://cloud.google.com/vpc/docs/private-services-access).
	//   "NETAPP_CLOUD_VOLUMES" - Peering connection used for connecting to
	// NetApp Cloud Volumes.
	//   "THIRD_PARTY_SERVICE" - Peering connection used for connecting to
	// third-party services. Most third-party services require manual setup
	// of reverse peering on the VPC network associated with the third-party
	// service.
	//   "DELL_POWERSCALE" - Peering connection used for connecting to Dell
	// PowerScale Filers
	PeerNetworkType string `json:"peerNetworkType,omitempty"`

	// State: Output only. State of the network peering. This field has a
	// value of 'ACTIVE' when there's a matching configuration in the peer
	// network. New values may be added to this enum when appropriate.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified network peering state. This is
	// the default value.
	//   "INACTIVE" - The peering is not active.
	//   "ACTIVE" - The peering is active.
	//   "CREATING" - The peering is being created.
	//   "DELETING" - The peering is being deleted.
	State string `json:"state,omitempty"`

	// StateDetails: Output only. Output Only. Details about the current
	// state of the network peering.
	StateDetails string `json:"stateDetails,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// VmwareEngineNetwork: Required. The relative resource name of the
	// VMware Engine network. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_
	// engine_network_id}` where `{project}` can either be a project number
	// or a project ID.
	VmwareEngineNetwork string `json:"vmwareEngineNetwork,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NetworkPeering) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkPeering
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NetworkPolicy: Represents a network policy resource. Network policies
// are regional resources. You can use a network policy to enable or
// disable internet access and external IP access. Network policies are
// associated with a VMware Engine network, which might span across
// regions. For a given region, a network policy applies to all private
// clouds in the VMware Engine network associated with the policy.
type NetworkPolicy struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. User-provided description for this network
	// policy.
	Description string `json:"description,omitempty"`

	// EdgeServicesCidr: Required. IP address range in CIDR notation used to
	// create internet access and external IP access. An RFC 1918 CIDR
	// block, with a "/26" prefix, is required. The range cannot overlap
	// with any prefixes either in the consumer VPC network or in use by the
	// private clouds attached to that VPC network.
	EdgeServicesCidr string `json:"edgeServicesCidr,omitempty"`

	// ExternalIp: Network service that allows External IP addresses to be
	// assigned to VMware workloads. This service can only be enabled when
	// `internet_access` is also enabled.
	ExternalIp *NetworkService `json:"externalIp,omitempty"`

	// InternetAccess: Network service that allows VMware workloads to
	// access the internet.
	InternetAccess *NetworkService `json:"internetAccess,omitempty"`

	// Name: Output only. The resource name of this network policy. Resource
	// names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-
	// policy`
	Name string `json:"name,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// VmwareEngineNetwork: Optional. The relative resource name of the
	// VMware Engine network. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_
	// engine_network_id}` where `{project}` can either be a project number
	// or a project ID.
	VmwareEngineNetwork string `json:"vmwareEngineNetwork,omitempty"`

	// VmwareEngineNetworkCanonical: Output only. The canonical name of the
	// VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{
	// vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `json:"vmwareEngineNetworkCanonical,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NetworkPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NetworkService: Represents a network service that is managed by a
// `NetworkPolicy` resource. A network service provides a way to control
// an aspect of external access to VMware workloads. For example,
// whether the VMware workloads in the private clouds governed by a
// network policy can access or be accessed from the internet.
type NetworkService struct {
	// Enabled: True if the service is enabled; false otherwise.
	Enabled bool `json:"enabled,omitempty"`

	// State: Output only. State of the service. New values may be added to
	// this enum when appropriate.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified service state. This is the
	// default value.
	//   "UNPROVISIONED" - Service is not provisioned.
	//   "RECONCILING" - Service is in the process of being
	// provisioned/deprovisioned.
	//   "ACTIVE" - Service is active.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NetworkService) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Node: Node in a cluster.
type Node struct {
	// CustomCoreCount: Output only. Customized number of cores
	CustomCoreCount int64 `json:"customCoreCount,omitempty,string"`

	// Fqdn: Output only. Fully qualified domain name of the node.
	Fqdn string `json:"fqdn,omitempty"`

	// InternalIp: Output only. Internal IP address of the node.
	InternalIp string `json:"internalIp,omitempty"`

	// Name: Output only. The resource name of this node. Resource names are
	// schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clu
	// sters/my-cluster/nodes/my-node
	Name string `json:"name,omitempty"`

	// NodeTypeId: Output only. The canonical identifier of the node type
	// (corresponds to the `NodeType`). For example: standard-72.
	NodeTypeId string `json:"nodeTypeId,omitempty"`

	// State: Output only. The state of the appliance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - Node is operational and can be used by the user.
	//   "CREATING" - Node is being provisioned.
	//   "FAILED" - Node is in a failed state.
	//   "UPGRADING" - Node is undergoing maintenance, e.g.: during private
	// cloud upgrade.
	State string `json:"state,omitempty"`

	// Version: Output only. The version number of the VMware ESXi
	// management component in this cluster.
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomCoreCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomCoreCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Node) MarshalJSON() ([]byte, error) {
	type NoMethod Node
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NodeType: Describes node type.
type NodeType struct {
	// AvailableCustomCoreCounts: Output only. List of possible values of
	// custom core count.
	AvailableCustomCoreCounts []int64 `json:"availableCustomCoreCounts,omitempty"`

	// Capabilities: Output only. Capabilities of this node type.
	//
	// Possible values:
	//   "CAPABILITY_UNSPECIFIED" - The default value. This value is used if
	// the capability is omitted or unknown.
	//   "STRETCHED_CLUSTERS" - This node type supports stretch clusters.
	Capabilities []string `json:"capabilities,omitempty"`

	// DiskSizeGb: Output only. The amount of storage available, defined in
	// GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty"`

	// DisplayName: Output only. The friendly name for this node type. For
	// example: ve1-standard-72
	DisplayName string `json:"displayName,omitempty"`

	// Families: Output only. Families of the node type. For node types to
	// be in the same cluster they must share at least one element in the
	// `families`.
	Families []string `json:"families,omitempty"`

	// Kind: Output only. The type of the resource.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "STANDARD" - Standard HCI node.
	//   "STORAGE_ONLY" - Storage only Node.
	Kind string `json:"kind,omitempty"`

	// MemoryGb: Output only. The amount of physical memory available,
	// defined in GB.
	MemoryGb int64 `json:"memoryGb,omitempty"`

	// Name: Output only. The resource name of this node type. Resource
	// names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
	Name string `json:"name,omitempty"`

	// NodeTypeId: Output only. The canonical identifier of the node type
	// (corresponds to the `NodeType`). For example: standard-72.
	NodeTypeId string `json:"nodeTypeId,omitempty"`

	// TotalCoreCount: Output only. The total number of CPU cores in a
	// single node.
	TotalCoreCount int64 `json:"totalCoreCount,omitempty"`

	// VirtualCpuCount: Output only. The total number of virtual CPUs in a
	// single node.
	VirtualCpuCount int64 `json:"virtualCpuCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AvailableCustomCoreCounts") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AvailableCustomCoreCounts") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NodeType) MarshalJSON() ([]byte, error) {
	type NoMethod NodeType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NodeTypeConfig: Information about the type and number of nodes
// associated with the cluster.
type NodeTypeConfig struct {
	// CustomCoreCount: Optional. Customized number of cores available to
	// each node of the type. This number must always be one of
	// `nodeType.availableCustomCoreCounts`. If zero is provided max value
	// from `nodeType.availableCustomCoreCounts` will be used.
	CustomCoreCount int64 `json:"customCoreCount,omitempty"`

	// NodeCount: Required. The number of nodes of this type in the cluster
	NodeCount int64 `json:"nodeCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomCoreCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomCoreCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *NodeTypeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NodeTypeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Nsx: Details about a NSX Manager appliance.
type Nsx struct {
	// Fqdn: Fully qualified domain name of the appliance.
	Fqdn string `json:"fqdn,omitempty"`

	// InternalIp: Internal IP address of the appliance.
	InternalIp string `json:"internalIp,omitempty"`

	// State: Output only. The state of the appliance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified appliance state. This is the
	// default value.
	//   "ACTIVE" - The appliance is operational and can be used.
	//   "CREATING" - The appliance is being deployed.
	State string `json:"state,omitempty"`

	// Version: Version of the appliance.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fqdn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fqdn") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Nsx) MarshalJSON() ([]byte, error) {
	type NoMethod Nsx
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running
// operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`

	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// RequestedCancellation: Output only. True if the user has requested
	// cancellation of the operation; false otherwise. Operations that have
	// successfully been cancelled have Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`

	// StatusMessage: Output only. Human-readable status of the operation,
	// if any.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Target: Output only. Server-defined resource path for the target of
	// the operation.
	Target string `json:"target,omitempty"`

	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PeeringRoute: Exchanged network peering route.
type PeeringRoute struct {
	// DestRange: Output only. Destination range of the peering route in
	// CIDR notation.
	DestRange string `json:"destRange,omitempty"`

	// Direction: Output only. Direction of the routes exchanged with the
	// peer network, from the VMware Engine network perspective: * Routes of
	// direction `INCOMING` are imported from the peer network. * Routes of
	// direction `OUTGOING` are exported from the intranet VPC network of
	// the VMware Engine network.
	//
	// Possible values:
	//   "DIRECTION_UNSPECIFIED" - Unspecified exchanged routes direction.
	// This is default.
	//   "INCOMING" - Routes imported from the peer network.
	//   "OUTGOING" - Routes exported to the peer network.
	Direction string `json:"direction,omitempty"`

	// Imported: Output only. True if the peering route has been imported
	// from a peered VPC network; false otherwise. The import happens if the
	// field `NetworkPeering.importCustomRoutes` is true for this network,
	// `NetworkPeering.exportCustomRoutes` is true for the peer VPC network,
	// and the import does not result in a route conflict.
	Imported bool `json:"imported,omitempty"`

	// NextHopRegion: Output only. Region containing the next hop of the
	// peering route. This field only applies to dynamic routes in the peer
	// VPC network.
	NextHopRegion string `json:"nextHopRegion,omitempty"`

	// Priority: Output only. The priority of the peering route.
	Priority int64 `json:"priority,omitempty,string"`

	// Type: Output only. Type of the route in the peer VPC network.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified peering route type. This is the
	// default value.
	//   "DYNAMIC_PEERING_ROUTE" - Dynamic routes in the peer network.
	//   "STATIC_PEERING_ROUTE" - Static routes in the peer network.
	//   "SUBNET_PEERING_ROUTE" - Created, updated, and removed
	// automatically by Google Cloud when subnets are created, modified, or
	// deleted in the peer network.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PeeringRoute) MarshalJSON() ([]byte, error) {
	type NoMethod PeeringRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts,
// service accounts, Google groups, and domains (such as G Suite). A
// `role` is a named list of permissions; each `role` can be an IAM
// predefined role or a user-created custom role. For some types of
// Google Cloud resources, a `binding` can also specify a `condition`,
// which is a logical expression that allows access to a resource only
// if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or
// both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ```
// bindings: - members: - user:mike@example.com -
// group:admins@example.com - domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// ``` For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members`, or principals, with a
	// `role`. Optionally, may specify a `condition` that determines how and
	// when the `bindings` are applied. Each of the `bindings` must contain
	// at least one principal. The `bindings` in a `Policy` can refer to up
	// to 1,500 principals; up to 250 of these principals can be Google
	// groups. Each occurrence of a principal counts towards these limits.
	// For example, if the `bindings` grant 50 different roles to
	// `user:alice@example.com`, and not to any other principal, then you
	// can add another 1,450 principals to the `bindings` in the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Principal: Users/Service accounts which have access for DNS binding
// on the intranet VPC corresponding to the consumer project.
type Principal struct {
	// ServiceAccount: The service account which needs to be granted the
	// permission.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// User: The user who needs to be granted permission.
	User string `json:"user,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ServiceAccount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Principal) MarshalJSON() ([]byte, error) {
	type NoMethod Principal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrivateCloud: Represents a private cloud resource. Private clouds of
// type `STANDARD` and `TIME_LIMITED` are zonal resources, `STRETCHED`
// private clouds are regional.
type PrivateCloud struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// DeleteTime: Output only. Time when the resource was scheduled for
	// deletion.
	DeleteTime string `json:"deleteTime,omitempty"`

	// Description: User-provided description for this private cloud.
	Description string `json:"description,omitempty"`

	// ExpireTime: Output only. Time when the resource will be irreversibly
	// deleted.
	ExpireTime string `json:"expireTime,omitempty"`

	// Hcx: Output only. HCX appliance.
	Hcx *Hcx `json:"hcx,omitempty"`

	// ManagementCluster: Required. Input only. The management cluster for
	// this private cloud. This field is required during creation of the
	// private cloud to provide details for the default cluster. The
	// following fields can't be changed after private cloud creation:
	// `ManagementCluster.clusterId`, `ManagementCluster.nodeTypeId`.
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`

	// Name: Output only. The resource name of this private cloud. Resource
	// names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `json:"name,omitempty"`

	// NetworkConfig: Required. Network configuration of the private cloud.
	NetworkConfig *NetworkConfig `json:"networkConfig,omitempty"`

	// Nsx: Output only. NSX appliance.
	Nsx *Nsx `json:"nsx,omitempty"`

	// State: Output only. State of the resource. New values may be added to
	// this enum when appropriate.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - The private cloud is ready.
	//   "CREATING" - The private cloud is being created.
	//   "UPDATING" - The private cloud is being updated.
	//   "FAILED" - The private cloud is in failed state.
	//   "DELETED" - The private cloud is scheduled for deletion. The
	// deletion process can be cancelled by using the corresponding undelete
	// method.
	//   "PURGING" - The private cloud is irreversibly deleted and is being
	// removed from the system.
	State string `json:"state,omitempty"`

	// Type: Optional. Type of the private cloud. Defaults to STANDARD.
	//
	// Possible values:
	//   "STANDARD" - Standard private is a zonal resource, with 3+ nodes.
	// Default type.
	//   "TIME_LIMITED" - Time limited private cloud is a zonal resource,
	// can have only 1 node and has limited life span. Will be deleted after
	// defined period of time, can be converted into standard private cloud
	// by expanding it up to 3 or more nodes.
	//   "STRETCHED" - Stretched private cloud is a regional resource with
	// redundancy, with a minimum of 6 nodes, nodes count has to be even.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// Vcenter: Output only. Vcenter appliance.
	Vcenter *Vcenter `json:"vcenter,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrivateCloud) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateCloud
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrivateConnection: Private connection resource that provides
// connectivity for VMware Engine private clouds.
type PrivateConnection struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. User-provided description for this private
	// connection.
	Description string `json:"description,omitempty"`

	// Name: Output only. The resource name of the private connection.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1/privateConnections/my-conne
	// ction`
	Name string `json:"name,omitempty"`

	// PeeringId: Output only. VPC network peering id between given network
	// VPC and VMwareEngineNetwork.
	PeeringId string `json:"peeringId,omitempty"`

	// PeeringState: Output only. Peering state between service network and
	// VMware Engine network.
	//
	// Possible values:
	//   "PEERING_STATE_UNSPECIFIED" - The default value. This value is used
	// if the peering state is omitted or unknown.
	//   "PEERING_ACTIVE" - The peering is in active state.
	//   "PEERING_INACTIVE" - The peering is in inactive state.
	PeeringState string `json:"peeringState,omitempty"`

	// RoutingMode: Optional. Routing Mode. Default value is set to GLOBAL.
	// For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
	// REGIONAL, for other types only GLOBAL is supported.
	//
	// Possible values:
	//   "ROUTING_MODE_UNSPECIFIED" - The default value. This value should
	// never be used.
	//   "GLOBAL" - Global Routing Mode
	//   "REGIONAL" - Regional Routing Mode
	RoutingMode string `json:"routingMode,omitempty"`

	// ServiceNetwork: Required. Service network to create private
	// connection. Specify the name in the following form:
	// `projects/{project}/global/networks/{network_id}` For type =
	// PRIVATE_SERVICE_ACCESS, this field represents servicenetworking VPC,
	// e.g. projects/project-tp/global/networks/servicenetworking. For type
	// = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC, e.g.
	// projects/project-tp/global/networks/netapp-tenant-vpc. For type =
	// DELL_POWERSCALE, this field represent Dell service VPC, e.g.
	// projects/project-tp/global/networks/dell-tenant-vpc. For type=
	// THIRD_PARTY_SERVICE, this field could represent a consumer VPC or any
	// other producer VPC to which the VMware Engine Network needs to be
	// connected, e.g. projects/project/global/networks/vpc.
	ServiceNetwork string `json:"serviceNetwork,omitempty"`

	// State: Output only. State of the private connection.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "CREATING" - The private connection is being created.
	//   "ACTIVE" - The private connection is ready.
	//   "UPDATING" - The private connection is being updated.
	//   "DELETING" - The private connection is being deleted.
	//   "UNPROVISIONED" - The private connection is not provisioned, since
	// no private cloud is present for which this private connection is
	// needed.
	//   "FAILED" - The private connection is in failed state.
	State string `json:"state,omitempty"`

	// Type: Required. Private connection type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "PRIVATE_SERVICE_ACCESS" - Connection used for establishing
	// [private services
	// access](https://cloud.google.com/vpc/docs/private-services-access).
	//   "NETAPP_CLOUD_VOLUMES" - Connection used for connecting to NetApp
	// Cloud Volumes.
	//   "DELL_POWERSCALE" - Connection used for connecting to Dell
	// PowerScale.
	//   "THIRD_PARTY_SERVICE" - Connection used for connecting to
	// third-party services.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// VmwareEngineNetwork: Required. The relative resource name of Legacy
	// VMware Engine network. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_
	// engine_network_id}` where `{project}`, `{location}` will be same as
	// specified in private connection resource name and
	// `{vmware_engine_network_id}` will be in the form of
	// `{location}`-default e.g.
	// projects/project/locations/us-central1/vmwareEngineNetworks/us-central
	// 1-default.
	VmwareEngineNetwork string `json:"vmwareEngineNetwork,omitempty"`

	// VmwareEngineNetworkCanonical: Output only. The canonical name of the
	// VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{
	// vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `json:"vmwareEngineNetworkCanonical,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PrivateConnection) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateConnection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RepairManagementDnsZoneBindingRequest: Request message for
// VmwareEngine.RepairManagementDnsZoneBindings
type RepairManagementDnsZoneBindingRequest struct {
	// RequestId: Optional. A request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server
	// will know to ignore the request if it has already been completed. The
	// server guarantees that a request doesn't result in creation of
	// duplicate commitments for at least 60 minutes. For example, consider
	// a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the
	// server can check if the original operation with the same request ID
	// was received, and if so, will ignore the second request. This
	// prevents clients from accidentally creating duplicate commitments.
	// The request ID must be a valid UUID with the exception that zero UUID
	// is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RepairManagementDnsZoneBindingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RepairManagementDnsZoneBindingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResetNsxCredentialsRequest: Request message for
// VmwareEngine.ResetNsxCredentials
type ResetNsxCredentialsRequest struct {
	// RequestId: Optional. A request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server
	// will know to ignore the request if it has already been completed. The
	// server guarantees that a request doesn't result in creation of
	// duplicate commitments for at least 60 minutes. For example, consider
	// a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the
	// server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments. The request
	// ID must be a valid UUID with the exception that zero UUID is not
	// supported (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResetNsxCredentialsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ResetNsxCredentialsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResetVcenterCredentialsRequest: Request message for
// VmwareEngine.ResetVcenterCredentials
type ResetVcenterCredentialsRequest struct {
	// RequestId: Optional. A request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server
	// will know to ignore the request if it has already been completed. The
	// server guarantees that a request doesn't result in creation of
	// duplicate commitments for at least 60 minutes. For example, consider
	// a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the
	// server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments. The request
	// ID must be a valid UUID with the exception that zero UUID is not
	// supported (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// Username: Optional. The username of the user to be to reset the
	// credentials. The default value of this field is CloudOwner@gve.local.
	// The provided value should be one of the following:
	// solution-user-01@gve.local, solution-user-02@gve.local,
	// solution-user-03@gve.local, solution-user-04@gve.local,
	// solution-user-05@gve.local, zertoadmin@gve.local.
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResetVcenterCredentialsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ResetVcenterCredentialsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RevokeDnsBindPermissionRequest: Request message for
// VmwareEngine.RevokeDnsBindPermission
type RevokeDnsBindPermissionRequest struct {
	// Principal: Required. The consumer provided user/service account which
	// needs to be granted permission to bind with the intranet VPC
	// corresponding to the consumer project.
	Principal *Principal `json:"principal,omitempty"`

	// RequestId: Optional. A request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server
	// will know to ignore the request if it has already been completed. The
	// server guarantees that a request doesn't result in creation of
	// duplicate commitments for at least 60 minutes. For example, consider
	// a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the
	// server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments. The request
	// ID must be a valid UUID with the exception that zero UUID is not
	// supported (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Principal") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Principal") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RevokeDnsBindPermissionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevokeDnsBindPermissionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the
	// `resource`. The size of the policy is limited to a few 10s of KB. An
	// empty policy is a valid policy but certain Google Cloud services
	// (such as Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the
	// policy to modify. Only the fields in the mask will be modified. If no
	// mask is provided, the following default mask is used: `paths:
	// "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StretchedClusterConfig: Configuration of a stretched cluster.
type StretchedClusterConfig struct {
	// PreferredLocation: Required. Zone that will remain operational when
	// connection between the two zones is lost. Specify the resource name
	// of a zone that belongs to the region of the private cloud. For
	// example: `projects/{project}/locations/europe-west3-a` where
	// `{project}` can either be a project number or a project ID.
	PreferredLocation string `json:"preferredLocation,omitempty"`

	// SecondaryLocation: Required. Additional zone for a higher level of
	// availability and load balancing. Specify the resource name of a zone
	// that belongs to the region of the private cloud. For example:
	// `projects/{project}/locations/europe-west3-b` where `{project}` can
	// either be a project number or a project ID.
	SecondaryLocation string `json:"secondaryLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PreferredLocation")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PreferredLocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *StretchedClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StretchedClusterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Subnet: Subnet in a private cloud. Either `management` subnets (such
// as vMotion) that are read-only, or `userDefined`, which can also be
// updated.
type Subnet struct {
	// GatewayIp: The IP address of the gateway of this subnet. Must fall
	// within the IP prefix defined above.
	GatewayIp string `json:"gatewayIp,omitempty"`

	// IpCidrRange: The IP address range of the subnet in CIDR format
	// '10.0.0.0/24'.
	IpCidrRange string `json:"ipCidrRange,omitempty"`

	// Name: Output only. The resource name of this subnet. Resource names
	// are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/su
	// bnets/my-subnet`
	Name string `json:"name,omitempty"`

	// State: Output only. The state of the resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "ACTIVE" - The subnet is ready.
	//   "CREATING" - The subnet is being created.
	//   "UPDATING" - The subnet is being updated.
	//   "DELETING" - The subnet is being deleted.
	//   "RECONCILING" - Changes requested in the last operation are being
	// propagated.
	//   "FAILED" - Last operation on the subnet did not succeed. Subnet's
	// payload is reverted back to its most recent working state.
	State string `json:"state,omitempty"`

	// Type: Output only. The type of the subnet. For example "management"
	// or "userDefined".
	Type string `json:"type,omitempty"`

	// VlanId: Output only. VLAN ID of the VLAN on which the subnet is
	// configured
	VlanId int64 `json:"vlanId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GatewayIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GatewayIp") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Subnet) MarshalJSON() ([]byte, error) {
	type NoMethod Subnet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions`
// method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`.
	// Permissions with wildcards (such as `*` or `storage.*`) are not
	// allowed. For more information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that
	// the caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UndeletePrivateCloudRequest: Request message for
// VmwareEngine.UndeletePrivateCloud
type UndeletePrivateCloudRequest struct {
	// RequestId: Optional. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UndeletePrivateCloudRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeletePrivateCloudRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Vcenter: Details about a vCenter Server management appliance.
type Vcenter struct {
	// Fqdn: Fully qualified domain name of the appliance.
	Fqdn string `json:"fqdn,omitempty"`

	// InternalIp: Internal IP address of the appliance.
	InternalIp string `json:"internalIp,omitempty"`

	// State: Output only. The state of the appliance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified appliance state. This is the
	// default value.
	//   "ACTIVE" - The appliance is operational and can be used.
	//   "CREATING" - The appliance is being deployed.
	State string `json:"state,omitempty"`

	// Version: Version of the appliance.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fqdn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fqdn") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Vcenter) MarshalJSON() ([]byte, error) {
	type NoMethod Vcenter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareEngineNetwork: VMware Engine network resource that provides
// connectivity for VMware Engine private clouds.
type VmwareEngineNetwork struct {
	// CreateTime: Output only. Creation time of this resource.
	CreateTime string `json:"createTime,omitempty"`

	// Description: User-provided description for this VMware Engine
	// network.
	Description string `json:"description,omitempty"`

	// Etag: Checksum that may be sent on update and delete requests to
	// ensure that the user-provided value is up to date before the server
	// processes a request. The server computes checksums based on the value
	// of other fields in the request.
	Etag string `json:"etag,omitempty"`

	// Name: Output only. The resource name of the VMware Engine network.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `json:"name,omitempty"`

	// State: Output only. State of the VMware Engine network.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "CREATING" - The VMware Engine network is being created.
	//   "ACTIVE" - The VMware Engine network is ready.
	//   "UPDATING" - The VMware Engine network is being updated.
	//   "DELETING" - The VMware Engine network is being deleted.
	State string `json:"state,omitempty"`

	// Type: Required. VMware Engine network type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "LEGACY" - Network type used by private clouds created in projects
	// without a network of type `STANDARD`. This network type is no longer
	// used for new VMware Engine private cloud deployments.
	//   "STANDARD" - Standard network type used for private cloud
	// connectivity.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System-generated unique identifier for the
	// resource.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. Last update time of this resource.
	UpdateTime string `json:"updateTime,omitempty"`

	// VpcNetworks: Output only. VMware Engine service VPC networks that
	// provide connectivity from a private cloud to customer projects, the
	// internet, and other Google Cloud services.
	VpcNetworks []*VpcNetwork `json:"vpcNetworks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareEngineNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareEngineNetwork
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VpcNetwork: Represents a VMware Engine VPC network that is managed by
// a VMware Engine network resource.
type VpcNetwork struct {
	// Network: Output only. The relative resource name of the service VPC
	// network this VMware Engine network is attached to. For example:
	// `projects/123123/global/networks/my-network`
	Network string `json:"network,omitempty"`

	// Type: Output only. Type of VPC network (INTRANET, INTERNET, or
	// GOOGLE_CLOUD)
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The default value. This value should never be
	// used.
	//   "INTRANET" - VPC network that will be peered with a consumer VPC
	// network or the intranet VPC of another VMware Engine network. Access
	// a private cloud through Compute Engine VMs on a peered VPC network or
	// an on-premises resource connected to a peered consumer VPC network.
	//   "INTERNET" - VPC network used for internet access to and from a
	// private cloud.
	//   "GOOGLE_CLOUD" - VPC network used for access to Google Cloud
	// services like Cloud Storage.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Network") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Network") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VpcNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod VpcNetwork
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "vmwareengine.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.get" call.
// Exactly one of *Location or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Location"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
//
//   - name: The resource that owns the locations collection, if
//     applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down
// results to a preferred subset. The filtering language accepts strings
// like "displayName=tokyo", and is documented in more detail in
// AIP-160 (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// received from the `next_page_token` field in the response. Send that
// page token to receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.list" call.
// Exactly one of *ListLocationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v1/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to narrow down results to a preferred subset. The filtering language accepts strings like `\"displayName=tokyo\"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return. If not set, the service selects a default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/locations",
	//   "response": {
	//     "$ref": "ListLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.global.getDnsBindPermission":

type ProjectsLocationsGlobalGetDnsBindPermissionCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDnsBindPermission: Gets all the principals having bind permission
// on the intranet VPC associated with the consumer project granted by
// the Grant API.
//
//   - name: The name of the resource which stores the users/service
//     accounts having the permission to bind to the corresponding
//     intranet VPC of the consumer project. DnsBindPermission is a global
//     resource. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/global/dnsBindPermission`.
func (r *ProjectsLocationsGlobalService) GetDnsBindPermission(name string) *ProjectsLocationsGlobalGetDnsBindPermissionCall {
	c := &ProjectsLocationsGlobalGetDnsBindPermissionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalGetDnsBindPermissionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalGetDnsBindPermissionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) Context(ctx context.Context) *ProjectsLocationsGlobalGetDnsBindPermissionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.getDnsBindPermission" call.
// Exactly one of *DnsBindPermission or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *DnsBindPermission.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalGetDnsBindPermissionCall) Do(opts ...googleapi.CallOption) (*DnsBindPermission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DnsBindPermission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets all the principals having bind permission on the intranet VPC associated with the consumer project granted by the Grant API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/dnsBindPermission",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.global.getDnsBindPermission",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the resource which stores the users/service accounts having the permission to bind to the corresponding intranet VPC of the consumer project. DnsBindPermission is a global resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/dnsBindPermission`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/dnsBindPermission$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "DnsBindPermission"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.dnsBindPermission.grant":

type ProjectsLocationsGlobalDnsBindPermissionGrantCall struct {
	s                             *Service
	name                          string
	grantdnsbindpermissionrequest *GrantDnsBindPermissionRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Grant: Grants the bind permission to the customer provided
// principal(user / service account) to bind their DNS zone with the
// intranet VPC associated with the project.
//
//   - name: The name of the resource which stores the users/service
//     accounts having the permission to bind to the corresponding
//     intranet VPC of the consumer project. DnsBindPermission is a global
//     resource. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/global/dnsBindPermission`.
func (r *ProjectsLocationsGlobalDnsBindPermissionService) Grant(name string, grantdnsbindpermissionrequest *GrantDnsBindPermissionRequest) *ProjectsLocationsGlobalDnsBindPermissionGrantCall {
	c := &ProjectsLocationsGlobalDnsBindPermissionGrantCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.grantdnsbindpermissionrequest = grantdnsbindpermissionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalDnsBindPermissionGrantCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalDnsBindPermissionGrantCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalDnsBindPermissionGrantCall) Context(ctx context.Context) *ProjectsLocationsGlobalDnsBindPermissionGrantCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalDnsBindPermissionGrantCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalDnsBindPermissionGrantCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.grantdnsbindpermissionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:grant")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.dnsBindPermission.grant" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalDnsBindPermissionGrantCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Grants the bind permission to the customer provided principal(user / service account) to bind their DNS zone with the intranet VPC associated with the project.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/dnsBindPermission:grant",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.global.dnsBindPermission.grant",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the resource which stores the users/service accounts having the permission to bind to the corresponding intranet VPC of the consumer project. DnsBindPermission is a global resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/dnsBindPermission`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/dnsBindPermission$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:grant",
	//   "request": {
	//     "$ref": "GrantDnsBindPermissionRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.dnsBindPermission.revoke":

type ProjectsLocationsGlobalDnsBindPermissionRevokeCall struct {
	s                              *Service
	name                           string
	revokednsbindpermissionrequest *RevokeDnsBindPermissionRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Revoke: Revokes the bind permission from the customer provided
// principal(user / service account) on the intranet VPC associated with
// the consumer project.
//
//   - name: The name of the resource which stores the users/service
//     accounts having the permission to bind to the corresponding
//     intranet VPC of the consumer project. DnsBindPermission is a global
//     resource. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/global/dnsBindPermission`.
func (r *ProjectsLocationsGlobalDnsBindPermissionService) Revoke(name string, revokednsbindpermissionrequest *RevokeDnsBindPermissionRequest) *ProjectsLocationsGlobalDnsBindPermissionRevokeCall {
	c := &ProjectsLocationsGlobalDnsBindPermissionRevokeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.revokednsbindpermissionrequest = revokednsbindpermissionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalDnsBindPermissionRevokeCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalDnsBindPermissionRevokeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalDnsBindPermissionRevokeCall) Context(ctx context.Context) *ProjectsLocationsGlobalDnsBindPermissionRevokeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalDnsBindPermissionRevokeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalDnsBindPermissionRevokeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.revokednsbindpermissionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:revoke")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.dnsBindPermission.revoke" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalDnsBindPermissionRevokeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Revokes the bind permission from the customer provided principal(user / service account) on the intranet VPC associated with the consumer project.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/dnsBindPermission:revoke",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.global.dnsBindPermission.revoke",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the resource which stores the users/service accounts having the permission to bind to the corresponding intranet VPC of the consumer project. DnsBindPermission is a global resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/dnsBindPermission`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/dnsBindPermission$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:revoke",
	//   "request": {
	//     "$ref": "RevokeDnsBindPermissionRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.networkPeerings.create":

type ProjectsLocationsGlobalNetworkPeeringsCreateCall struct {
	s              *Service
	parent         string
	networkpeering *NetworkPeering
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new network peering between the peer network and
// VMware Engine network provided in a `NetworkPeering` resource.
//
//   - parent: The resource name of the location to create the new network
//     peering in. This value is always `global`, because `NetworkPeering`
//     is a global resource. Resource names are schemeless URIs that
//     follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global`.
func (r *ProjectsLocationsGlobalNetworkPeeringsService) Create(parent string, networkpeering *NetworkPeering) *ProjectsLocationsGlobalNetworkPeeringsCreateCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.networkpeering = networkpeering
	return c
}

// NetworkPeeringId sets the optional parameter "networkPeeringId":
// Required. The user-provided identifier of the new `NetworkPeering`.
// This identifier must be unique among `NetworkPeering` resources
// within the parent and becomes the final token in the name URI. The
// identifier must meet the following requirements: * Only contains 1-63
// alphanumeric characters and hyphens * Begins with an alphabetical
// character * Ends with a non-hyphen character * Not formatted as a
// UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) NetworkPeeringId(networkPeeringId string) *ProjectsLocationsGlobalNetworkPeeringsCreateCall {
	c.urlParams_.Set("networkPeeringId", networkPeeringId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) RequestId(requestId string) *ProjectsLocationsGlobalNetworkPeeringsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.networkpeering)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/networkPeerings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new network peering between the peer network and VMware Engine network provided in a `NetworkPeering` resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "networkPeeringId": {
	//       "description": "Required. The user-provided identifier of the new `NetworkPeering`. This identifier must be unique among `NetworkPeering` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location to create the new network peering in. This value is always `global`, because `NetworkPeering` is a global resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/networkPeerings",
	//   "request": {
	//     "$ref": "NetworkPeering"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.networkPeerings.delete":

type ProjectsLocationsGlobalNetworkPeeringsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `NetworkPeering` resource. When a network peering
// is deleted for a VMware Engine network, the peer network becomes
// inaccessible to that VMware Engine network.
//
//   - name: The resource name of the network peering to be deleted.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/networkPeerings/my-peering`.
func (r *ProjectsLocationsGlobalNetworkPeeringsService) Delete(name string) *ProjectsLocationsGlobalNetworkPeeringsDeleteCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) RequestId(requestId string) *ProjectsLocationsGlobalNetworkPeeringsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `NetworkPeering` resource. When a network peering is deleted for a VMware Engine network, the peer network becomes inaccessible to that VMware Engine network.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings/{networkPeeringsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the network peering to be deleted. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/networkPeerings/my-peering`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/networkPeerings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.networkPeerings.get":

type ProjectsLocationsGlobalNetworkPeeringsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `NetworkPeering` resource by its resource name. The
// resource contains details of the network peering, such as peered
// networks, import and export custom route configurations, and peering
// state.
//
//   - name: The resource name of the network peering to retrieve.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/networkPeerings/my-peering`.
func (r *ProjectsLocationsGlobalNetworkPeeringsService) Get(name string) *ProjectsLocationsGlobalNetworkPeeringsGetCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalNetworkPeeringsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.get" call.
// Exactly one of *NetworkPeering or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *NetworkPeering.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsGetCall) Do(opts ...googleapi.CallOption) (*NetworkPeering, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPeering{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `NetworkPeering` resource by its resource name. The resource contains details of the network peering, such as peered networks, import and export custom route configurations, and peering state.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings/{networkPeeringsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the network peering to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/networkPeerings/my-peering`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/networkPeerings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "NetworkPeering"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.networkPeerings.list":

type ProjectsLocationsGlobalNetworkPeeringsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `NetworkPeering` resources in a given project.
//
//   - parent: The resource name of the location (global) to query for
//     network peerings. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global`.
func (r *ProjectsLocationsGlobalNetworkPeeringsService) List(parent string) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of network peerings, you can
// exclude the ones named `example-peering` by specifying `name !=
// "example-peering". To filter on multiple expressions, provide each
// separate expression within parentheses. For example: ``` (name =
// "example-peering") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-peering-1") AND (createTime > "2021-04-12T08:15:10.40Z")
// OR (name = "example-peering-2") ```
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Filter(filter string) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) OrderBy(orderBy string) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of network peerings to return in one page. The maximum value is
// coerced to 1000. The default value of this field is 500.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) PageSize(pageSize int64) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListNetworkPeerings` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListNetworkPeerings` must match the call that provided
// the page token.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) PageToken(pageToken string) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/networkPeerings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.list" call.
// Exactly one of *ListNetworkPeeringsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListNetworkPeeringsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Do(opts ...googleapi.CallOption) (*ListNetworkPeeringsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNetworkPeeringsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `NetworkPeering` resources in a given project.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of network peerings, you can exclude the ones named `example-peering` by specifying `name != \"example-peering\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-peering\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-peering-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-peering-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of network peerings to return in one page. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListNetworkPeerings` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListNetworkPeerings` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location (global) to query for network peerings. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/networkPeerings",
	//   "response": {
	//     "$ref": "ListNetworkPeeringsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlobalNetworkPeeringsListCall) Pages(ctx context.Context, f func(*ListNetworkPeeringsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.global.networkPeerings.patch":

type ProjectsLocationsGlobalNetworkPeeringsPatchCall struct {
	s              *Service
	name           string
	networkpeering *NetworkPeering
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Modifies a `NetworkPeering` resource. Only the `description`
// field can be updated. Only fields specified in `updateMask` are
// applied.
//
//   - name: Output only. The resource name of the network peering.
//     Resource names are scheme-less URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/networkPeerings/my-peering`.
func (r *ProjectsLocationsGlobalNetworkPeeringsService) Patch(name string, networkpeering *NetworkPeering) *ProjectsLocationsGlobalNetworkPeeringsPatchCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.networkpeering = networkpeering
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) RequestId(requestId string) *ProjectsLocationsGlobalNetworkPeeringsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `NetworkPeering` resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGlobalNetworkPeeringsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.networkpeering)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a `NetworkPeering` resource. Only the `description` field can be updated. Only fields specified in `updateMask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings/{networkPeeringsId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of the network peering. Resource names are scheme-less URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/networkPeerings/my-peering`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/networkPeerings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `NetworkPeering` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "NetworkPeering"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.global.networkPeerings.peeringRoutes.list":

type ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the network peering routes exchanged over a peering
// connection.
//
//   - parent: The resource name of the network peering to retrieve
//     peering routes from. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/networkPeerings/my-peering`.
func (r *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesService) List(parent string) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c := &ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. Currently, only filtering
// on the `direction` field is supported. To return routes imported from
// the peer network, provide "direction=INCOMING". To return routes
// exported from the VMware Engine network, provide
// "direction=OUTGOING". Other filter expressions return an error.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Filter(filter string) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of peering routes to return in one page. The service may return fewer
// than this value. The maximum value is coerced to 1000. The default
// value of this field is 500.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPeeringRoutes` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListPeeringRoutes` must match the call that provided the
// page token.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) PageToken(pageToken string) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Context(ctx context.Context) *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/peeringRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.global.networkPeerings.peeringRoutes.list" call.
// Exactly one of *ListPeeringRoutesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListPeeringRoutesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Do(opts ...googleapi.CallOption) (*ListPeeringRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPeeringRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the network peering routes exchanged over a peering connection.",
	//   "flatPath": "v1/projects/{projectsId}/locations/global/networkPeerings/{networkPeeringsId}/peeringRoutes",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.global.networkPeerings.peeringRoutes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. Currently, only filtering on the `direction` field is supported. To return routes imported from the peer network, provide \"direction=INCOMING\". To return routes exported from the VMware Engine network, provide \"direction=OUTGOING\". Other filter expressions return an error.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of peering routes to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListPeeringRoutes` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPeeringRoutes` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the network peering to retrieve peering routes from. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/networkPeerings/my-peering`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/global/networkPeerings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/peeringRoutes",
	//   "response": {
	//     "$ref": "ListPeeringRoutesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlobalNetworkPeeringsPeeringRoutesListCall) Pages(ctx context.Context, f func(*ListPeeringRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.networkPolicies.create":

type ProjectsLocationsNetworkPoliciesCreateCall struct {
	s             *Service
	parent        string
	networkpolicy *NetworkPolicy
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a new network policy in a given VMware Engine network
// of a project and location (region). A new network policy cannot be
// created if another network policy already exists in the same scope.
//
//   - parent: The resource name of the location (region) to create the
//     new network policy in. Resource names are schemeless URIs that
//     follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1`.
func (r *ProjectsLocationsNetworkPoliciesService) Create(parent string, networkpolicy *NetworkPolicy) *ProjectsLocationsNetworkPoliciesCreateCall {
	c := &ProjectsLocationsNetworkPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.networkpolicy = networkpolicy
	return c
}

// NetworkPolicyId sets the optional parameter "networkPolicyId":
// Required. The user-provided identifier of the network policy to be
// created. This identifier must be unique within parent
// `projects/{my-project}/locations/{us-central1}/networkPolicies` and
// becomes the final token in the name URI. The identifier must meet the
// following requirements: * Only contains 1-63 alphanumeric characters
// and hyphens * Begins with an alphabetical character * Ends with a
// non-hyphen character * Not formatted as a UUID * Complies with RFC
// 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsNetworkPoliciesCreateCall) NetworkPolicyId(networkPolicyId string) *ProjectsLocationsNetworkPoliciesCreateCall {
	c.urlParams_.Set("networkPolicyId", networkPolicyId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesCreateCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.networkpolicy)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/networkPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new network policy in a given VMware Engine network of a project and location (region). A new network policy cannot be created if another network policy already exists in the same scope.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.networkPolicies.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "networkPolicyId": {
	//       "description": "Required. The user-provided identifier of the network policy to be created. This identifier must be unique within parent `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location (region) to create the new network policy in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/networkPolicies",
	//   "request": {
	//     "$ref": "NetworkPolicy"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.delete":

type ProjectsLocationsNetworkPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `NetworkPolicy` resource. A network policy cannot
// be deleted when `NetworkService.state` is set to `RECONCILING` for
// either its external IP or internet access service.
//
//   - name: The resource name of the network policy to delete. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-networ
//     k-policy`.
func (r *ProjectsLocationsNetworkPoliciesService) Delete(name string) *ProjectsLocationsNetworkPoliciesDeleteCall {
	c := &ProjectsLocationsNetworkPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesDeleteCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `NetworkPolicy` resource. A network policy cannot be deleted when `NetworkService.state` is set to `RECONCILING` for either its external IP or internet access service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.networkPolicies.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the network policy to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.fetchExternalAddresses":

type ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall struct {
	s             *Service
	networkPolicy string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// FetchExternalAddresses: Lists external IP addresses assigned to
// VMware workload VMs within the scope of the given network policy.
//
//   - networkPolicy: The resource name of the network policy to query for
//     assigned external IP addresses. Resource names are schemeless URIs
//     that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     `.
func (r *ProjectsLocationsNetworkPoliciesService) FetchExternalAddresses(networkPolicy string) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c := &ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.networkPolicy = networkPolicy
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of external IP addresses to return in one page. The service may
// return fewer than this value. The maximum value is coerced to 1000.
// The default value of this field is 500.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) PageSize(pageSize int64) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `FetchNetworkPolicyExternalAddresses` call.
// Provide this to retrieve the subsequent page. When paginating, all
// parameters provided to `FetchNetworkPolicyExternalAddresses`, except
// for `page_size` and `page_token`, must match the call that provided
// the page token.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) PageToken(pageToken string) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) IfNoneMatch(entityTag string) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+networkPolicy}:fetchExternalAddresses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"networkPolicy": c.networkPolicy,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.fetchExternalAddresses" call.
// Exactly one of *FetchNetworkPolicyExternalAddressesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *FetchNetworkPolicyExternalAddressesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) Do(opts ...googleapi.CallOption) (*FetchNetworkPolicyExternalAddressesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FetchNetworkPolicyExternalAddressesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists external IP addresses assigned to VMware workload VMs within the scope of the given network policy.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}:fetchExternalAddresses",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.networkPolicies.fetchExternalAddresses",
	//   "parameterOrder": [
	//     "networkPolicy"
	//   ],
	//   "parameters": {
	//     "networkPolicy": {
	//       "description": "Required. The resource name of the network policy to query for assigned external IP addresses. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of external IP addresses to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `FetchNetworkPolicyExternalAddresses` call. Provide this to retrieve the subsequent page. When paginating, all parameters provided to `FetchNetworkPolicyExternalAddresses`, except for `page_size` and `page_token`, must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+networkPolicy}:fetchExternalAddresses",
	//   "response": {
	//     "$ref": "FetchNetworkPolicyExternalAddressesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsNetworkPoliciesFetchExternalAddressesCall) Pages(ctx context.Context, f func(*FetchNetworkPolicyExternalAddressesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.networkPolicies.get":

type ProjectsLocationsNetworkPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `NetworkPolicy` resource by its resource name.
//
//   - name: The resource name of the network policy to retrieve. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-networ
//     k-policy`.
func (r *ProjectsLocationsNetworkPoliciesService) Get(name string) *ProjectsLocationsNetworkPoliciesGetCall {
	c := &ProjectsLocationsNetworkPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNetworkPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsNetworkPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.get" call.
// Exactly one of *NetworkPolicy or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *NetworkPolicy.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesGetCall) Do(opts ...googleapi.CallOption) (*NetworkPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `NetworkPolicy` resource by its resource name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.networkPolicies.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the network policy to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "NetworkPolicy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.list":

type ProjectsLocationsNetworkPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `NetworkPolicy` resources in a specified project and
// location.
//
//   - parent: The resource name of the location (region) to query for
//     network policies. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1`.
func (r *ProjectsLocationsNetworkPoliciesService) List(parent string) *ProjectsLocationsNetworkPoliciesListCall {
	c := &ProjectsLocationsNetworkPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of network policies, you can
// exclude the ones named `example-policy` by specifying `name !=
// "example-policy". To filter on multiple expressions, provide each
// separate expression within parentheses. For example: ``` (name =
// "example-policy") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-policy-1") AND (createTime > "2021-04-12T08:15:10.40Z") OR
// (name = "example-policy-2") ```
func (c *ProjectsLocationsNetworkPoliciesListCall) Filter(filter string) *ProjectsLocationsNetworkPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsNetworkPoliciesListCall) OrderBy(orderBy string) *ProjectsLocationsNetworkPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of network policies to return in one page. The service may return
// fewer than this value. The maximum value is coerced to 1000. The
// default value of this field is 500.
func (c *ProjectsLocationsNetworkPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsNetworkPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListNetworkPolicies` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListNetworkPolicies` must match the call that provided
// the page token.
func (c *ProjectsLocationsNetworkPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsNetworkPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNetworkPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsNetworkPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/networkPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.list" call.
// Exactly one of *ListNetworkPoliciesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListNetworkPoliciesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListNetworkPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNetworkPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `NetworkPolicy` resources in a specified project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.networkPolicies.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of network policies, you can exclude the ones named `example-policy` by specifying `name != \"example-policy\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-policy\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-policy-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-policy-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of network policies to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListNetworkPolicies` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListNetworkPolicies` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location (region) to query for network policies. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/networkPolicies",
	//   "response": {
	//     "$ref": "ListNetworkPoliciesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsNetworkPoliciesListCall) Pages(ctx context.Context, f func(*ListNetworkPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.networkPolicies.patch":

type ProjectsLocationsNetworkPoliciesPatchCall struct {
	s             *Service
	name          string
	networkpolicy *NetworkPolicy
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Modifies a `NetworkPolicy` resource. Only the following fields
// can be updated: `internet_access`, `external_ip`,
// `edge_services_cidr`. Only fields specified in `updateMask` are
// applied. When updating a network policy, the external IP network
// service can only be disabled if there are no external IP addresses
// present in the scope of the policy. Also, a `NetworkService` cannot
// be updated when `NetworkService.state` is set to `RECONCILING`.
// During operation processing, the resource is temporarily in the
// `ACTIVE` state before the operation fully completes. For that period
// of time, you can't update the resource. Use the operation status to
// determine when the processing fully completes.
//
//   - name: Output only. The resource name of this network policy.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-networ
//     k-policy`.
func (r *ProjectsLocationsNetworkPoliciesService) Patch(name string, networkpolicy *NetworkPolicy) *ProjectsLocationsNetworkPoliciesPatchCall {
	c := &ProjectsLocationsNetworkPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.networkpolicy = networkpolicy
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesPatchCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `NetworkPolicy` resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsNetworkPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsNetworkPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.networkpolicy)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a `NetworkPolicy` resource. Only the following fields can be updated: `internet_access`, `external_ip`, `edge_services_cidr`. Only fields specified in `updateMask` are applied. When updating a network policy, the external IP network service can only be disabled if there are no external IP addresses present in the scope of the policy. Also, a `NetworkService` cannot be updated when `NetworkService.state` is set to `RECONCILING`. During operation processing, the resource is temporarily in the `ACTIVE` state before the operation fully completes. For that period of time, you can't update the resource. Use the operation status to determine when the processing fully completes.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.networkPolicies.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this network policy. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `NetworkPolicy` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "NetworkPolicy"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.externalAccessRules.create":

type ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall struct {
	s                  *Service
	parent             string
	externalaccessrule *ExternalAccessRule
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a new external access rule in a given network policy.
//
//   - parent: The resource name of the network policy to create a new
//     external access firewall rule in. Resource names are schemeless
//     URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     `.
func (r *ProjectsLocationsNetworkPoliciesExternalAccessRulesService) Create(parent string, externalaccessrule *ExternalAccessRule) *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall {
	c := &ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.externalaccessrule = externalaccessrule
	return c
}

// ExternalAccessRuleId sets the optional parameter
// "externalAccessRuleId": Required. The user-provided identifier of the
// `ExternalAccessRule` to be created. This identifier must be unique
// among `ExternalAccessRule` resources within the parent and becomes
// the final token in the name URI. The identifier must meet the
// following requirements: * Only contains 1-63 alphanumeric characters
// and hyphens * Begins with an alphabetical character * Ends with a
// non-hyphen character * Not formatted as a UUID * Complies with RFC
// 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) ExternalAccessRuleId(externalAccessRuleId string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall {
	c.urlParams_.Set("externalAccessRuleId", externalAccessRuleId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.externalaccessrule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalAccessRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.externalAccessRules.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new external access rule in a given network policy.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}/externalAccessRules",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.networkPolicies.externalAccessRules.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "externalAccessRuleId": {
	//       "description": "Required. The user-provided identifier of the `ExternalAccessRule` to be created. This identifier must be unique among `ExternalAccessRule` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the network policy to create a new external access firewall rule in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/externalAccessRules",
	//   "request": {
	//     "$ref": "ExternalAccessRule"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.externalAccessRules.delete":

type ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single external access rule.
//
//   - name: The resource name of the external access firewall rule to
//     delete. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     /externalAccessRules/my-rule`.
func (r *ProjectsLocationsNetworkPoliciesExternalAccessRulesService) Delete(name string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall {
	c := &ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.externalAccessRules.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single external access rule.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}/externalAccessRules/{externalAccessRulesId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.networkPolicies.externalAccessRules.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the external access firewall rule to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+/externalAccessRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.externalAccessRules.get":

type ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single external access rule.
//
//   - name: The resource name of the external access firewall rule to
//     retrieve. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     /externalAccessRules/my-rule`.
func (r *ProjectsLocationsNetworkPoliciesExternalAccessRulesService) Get(name string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall {
	c := &ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.externalAccessRules.get" call.
// Exactly one of *ExternalAccessRule or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExternalAccessRule.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesGetCall) Do(opts ...googleapi.CallOption) (*ExternalAccessRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExternalAccessRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single external access rule.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}/externalAccessRules/{externalAccessRulesId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.networkPolicies.externalAccessRules.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the external access firewall rule to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+/externalAccessRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "ExternalAccessRule"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.networkPolicies.externalAccessRules.list":

type ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `ExternalAccessRule` resources in the specified network
// policy.
//
//   - parent: The resource name of the network policy to query for
//     external access firewall rules. Resource names are schemeless URIs
//     that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     `.
func (r *ProjectsLocationsNetworkPoliciesExternalAccessRulesService) List(parent string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c := &ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of external access rules, you
// can exclude the ones named `example-rule` by specifying `name !=
// "example-rule". To filter on multiple expressions, provide each
// separate expression within parentheses. For example: ``` (name =
// "example-rule") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-rule-1") AND (createTime > "2021-04-12T08:15:10.40Z") OR
// (name = "example-rule-2") ```
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Filter(filter string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) OrderBy(orderBy string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of external access rules to return in one page. The service may
// return fewer than this value. The maximum value is coerced to 1000.
// The default value of this field is 500.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) PageSize(pageSize int64) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListExternalAccessRulesRequest` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `ListExternalAccessRulesRequest` must
// match the call that provided the page token.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) PageToken(pageToken string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalAccessRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.externalAccessRules.list" call.
// Exactly one of *ListExternalAccessRulesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListExternalAccessRulesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Do(opts ...googleapi.CallOption) (*ListExternalAccessRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExternalAccessRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `ExternalAccessRule` resources in the specified network policy.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}/externalAccessRules",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.networkPolicies.externalAccessRules.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of external access rules, you can exclude the ones named `example-rule` by specifying `name != \"example-rule\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-rule\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-rule-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-rule-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of external access rules to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListExternalAccessRulesRequest` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListExternalAccessRulesRequest` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the network policy to query for external access firewall rules. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/externalAccessRules",
	//   "response": {
	//     "$ref": "ListExternalAccessRulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesListCall) Pages(ctx context.Context, f func(*ListExternalAccessRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.networkPolicies.externalAccessRules.patch":

type ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall struct {
	s                  *Service
	name               string
	externalaccessrule *ExternalAccessRule
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates the parameters of a single external access rule. Only
// fields specified in `update_mask` are applied.
//
//   - name: Output only. The resource name of this external access rule.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/networkPolicies/my-policy
//     /externalAccessRules/my-rule`.
func (r *ProjectsLocationsNetworkPoliciesExternalAccessRulesService) Patch(name string, externalaccessrule *ExternalAccessRule) *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall {
	c := &ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.externalaccessrule = externalaccessrule
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) RequestId(requestId string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `ExternalAccessRule` resource by the update. The fields specified in
// the `update_mask` are relative to the resource, not the full request.
// A field will be overwritten if it is in the mask. If the user does
// not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.externalaccessrule)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.networkPolicies.externalAccessRules.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNetworkPoliciesExternalAccessRulesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single external access rule. Only fields specified in `update_mask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/networkPolicies/{networkPoliciesId}/externalAccessRules/{externalAccessRulesId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.networkPolicies.externalAccessRules.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this external access rule. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/networkPolicies/[^/]+/externalAccessRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `ExternalAccessRule` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "ExternalAccessRule"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.nodeTypes.get":

type ProjectsLocationsNodeTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single `NodeType`.
//
//   - name: The resource name of the node type to retrieve. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`.
func (r *ProjectsLocationsNodeTypesService) Get(name string) *ProjectsLocationsNodeTypesGetCall {
	c := &ProjectsLocationsNodeTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNodeTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsNodeTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNodeTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsNodeTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNodeTypesGetCall) Context(ctx context.Context) *ProjectsLocationsNodeTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNodeTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNodeTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.nodeTypes.get" call.
// Exactly one of *NodeType or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *NodeType.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsNodeTypesGetCall) Do(opts ...googleapi.CallOption) (*NodeType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NodeType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single `NodeType`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/nodeTypes/{nodeTypesId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.nodeTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the node type to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/nodeTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "NodeType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.nodeTypes.list":

type ProjectsLocationsNodeTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists node types
//
//   - parent: The resource name of the location to be queried for node
//     types. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example: `projects/my-project/locations/us-central1-a`.
func (r *ProjectsLocationsNodeTypesService) List(parent string) *ProjectsLocationsNodeTypesListCall {
	c := &ProjectsLocationsNodeTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of node types, you can exclude
// the ones named `standard-72` by specifying `name != "standard-72".
// To filter on multiple expressions, provide each separate expression
// within parentheses. For example: ``` (name = "standard-72")
// (virtual_cpu_count > 2) ``` By default, each expression is an `AND`
// expression. However, you can include `AND` and `OR` expressions
// explicitly. For example: ``` (name = "standard-96") AND
// (virtual_cpu_count > 2) OR (name = "standard-72") ```
func (c *ProjectsLocationsNodeTypesListCall) Filter(filter string) *ProjectsLocationsNodeTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of node types to return in one page. The service may return fewer
// than this value. The maximum value is coerced to 1000. The default
// value of this field is 500.
func (c *ProjectsLocationsNodeTypesListCall) PageSize(pageSize int64) *ProjectsLocationsNodeTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListNodeTypes` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListNodeTypes` must match the call that provided the
// page token.
func (c *ProjectsLocationsNodeTypesListCall) PageToken(pageToken string) *ProjectsLocationsNodeTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsNodeTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsNodeTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsNodeTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsNodeTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsNodeTypesListCall) Context(ctx context.Context) *ProjectsLocationsNodeTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsNodeTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsNodeTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/nodeTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.nodeTypes.list" call.
// Exactly one of *ListNodeTypesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListNodeTypesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsNodeTypesListCall) Do(opts ...googleapi.CallOption) (*ListNodeTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNodeTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists node types",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/nodeTypes",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.nodeTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of node types, you can exclude the ones named `standard-72` by specifying `name != \"standard-72\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"standard-72\") (virtual_cpu_count \u003e 2) ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"standard-96\") AND (virtual_cpu_count \u003e 2) OR (name = \"standard-72\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of node types to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListNodeTypes` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListNodeTypes` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location to be queried for node types. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/nodeTypes",
	//   "response": {
	//     "$ref": "ListNodeTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsNodeTypesListCall) Pages(ctx context.Context, f func(*ListNodeTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.operations.delete":

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that
// the client is no longer interested in the operation result. It does
// not cancel the operation. If the server doesn't support this method,
// it returns `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.operations.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.operations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.create":

type ProjectsLocationsPrivateCloudsCreateCall struct {
	s            *Service
	parent       string
	privatecloud *PrivateCloud
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new `PrivateCloud` resource in a given project and
// location. Private clouds of type `STANDARD` and `TIME_LIMITED` are
// zonal resources, `STRETCHED` private clouds are regional. Creating a
// private cloud also creates a management cluster
// (https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
// for that private cloud.
//
//   - parent: The resource name of the location to create the new private
//     cloud in. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example: `projects/my-project/locations/us-central1-a`.
func (r *ProjectsLocationsPrivateCloudsService) Create(parent string, privatecloud *PrivateCloud) *ProjectsLocationsPrivateCloudsCreateCall {
	c := &ProjectsLocationsPrivateCloudsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.privatecloud = privatecloud
	return c
}

// PrivateCloudId sets the optional parameter "privateCloudId":
// Required. The user-provided identifier of the private cloud to be
// created. This identifier must be unique among each `PrivateCloud`
// within the parent and becomes the final token in the name URI. The
// identifier must meet the following requirements: * Only contains 1-63
// alphanumeric characters and hyphens * Begins with an alphabetical
// character * Ends with a non-hyphen character * Not formatted as a
// UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsCreateCall) PrivateCloudId(privateCloudId string) *ProjectsLocationsPrivateCloudsCreateCall {
	c.urlParams_.Set("privateCloudId", privateCloudId)
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": True if you
// want the request to be validated and not executed; false otherwise.
func (c *ProjectsLocationsPrivateCloudsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsPrivateCloudsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.privatecloud)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/privateClouds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new `PrivateCloud` resource in a given project and location. Private clouds of type `STANDARD` and `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are regional. Creating a private cloud also creates a [management cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components) for that private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the location to create the new private cloud in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "privateCloudId": {
	//       "description": "Required. The user-provided identifier of the private cloud to be created. This identifier must be unique among each `PrivateCloud` within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. True if you want the request to be validated and not executed; false otherwise.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/privateClouds",
	//   "request": {
	//     "$ref": "PrivateCloud"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.delete":

type ProjectsLocationsPrivateCloudsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Schedules a `PrivateCloud` resource for deletion. A
// `PrivateCloud` resource scheduled for deletion has
// `PrivateCloud.state` set to `DELETED` and `expireTime` set to the
// time when deletion is final and can no longer be reversed. The delete
// operation is marked as done as soon as the `PrivateCloud` is
// successfully scheduled for deletion (this also applies when
// `delayHours` is set to zero), and the operation is not kept in
// pending state until `PrivateCloud` is purged. `PrivateCloud` can be
// restored using `UndeletePrivateCloud` method before the `expireTime`
// elapses. When `expireTime` is reached, deletion is final and all
// private cloud resources are irreversibly removed and billing stops.
// During the final removal process, `PrivateCloud.state` is set to
// `PURGING`. `PrivateCloud` can be polled using standard `GET` method
// for the whole period of deletion and purging. It will not be returned
// only when it is completely purged.
//
//   - name: The resource name of the private cloud to delete. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) Delete(name string) *ProjectsLocationsPrivateCloudsDeleteCall {
	c := &ProjectsLocationsPrivateCloudsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// DelayHours sets the optional parameter "delayHours": Time delay of
// the deletion specified in hours. The default value is `3`. Specifying
// a non-zero value for this field changes the value of
// `PrivateCloud.state` to `DELETED` and sets `expire_time` to the
// planned deletion time. Deletion can be cancelled before `expire_time`
// elapses using VmwareEngine.UndeletePrivateCloud. Specifying a value
// of `0` for this field instead begins the deletion process and ceases
// billing immediately. During the final deletion process, the value of
// `PrivateCloud.state` becomes `PURGING`.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) DelayHours(delayHours int64) *ProjectsLocationsPrivateCloudsDeleteCall {
	c.urlParams_.Set("delayHours", fmt.Sprint(delayHours))
	return c
}

// Force sets the optional parameter "force": If set to true, cascade
// delete is enabled and all children of this private cloud resource are
// also deleted. When this flag is set to false, the private cloud will
// not be deleted if there are any children other than the management
// cluster. The management cluster is always deleted.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) Force(force bool) *ProjectsLocationsPrivateCloudsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Schedules a `PrivateCloud` resource for deletion. A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state` set to `DELETED` and `expireTime` set to the time when deletion is final and can no longer be reversed. The delete operation is marked as done as soon as the `PrivateCloud` is successfully scheduled for deletion (this also applies when `delayHours` is set to zero), and the operation is not kept in pending state until `PrivateCloud` is purged. `PrivateCloud` can be restored using `UndeletePrivateCloud` method before the `expireTime` elapses. When `expireTime` is reached, deletion is final and all private cloud resources are irreversibly removed and billing stops. During the final removal process, `PrivateCloud.state` is set to `PURGING`. `PrivateCloud` can be polled using standard `GET` method for the whole period of deletion and purging. It will not be returned only when it is completely purged.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateClouds.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "delayHours": {
	//       "description": "Optional. Time delay of the deletion specified in hours. The default value is `3`. Specifying a non-zero value for this field changes the value of `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned deletion time. Deletion can be cancelled before `expire_time` elapses using VmwareEngine.UndeletePrivateCloud. Specifying a value of `0` for this field instead begins the deletion process and ceases billing immediately. During the final deletion process, the value of `PrivateCloud.state` becomes `PURGING`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "force": {
	//       "description": "Optional. If set to true, cascade delete is enabled and all children of this private cloud resource are also deleted. When this flag is set to false, the private cloud will not be deleted if there are any children other than the management cluster. The management cluster is always deleted.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the private cloud to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.get":

type ProjectsLocationsPrivateCloudsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `PrivateCloud` resource by its resource name.
//
//   - name: The resource name of the private cloud to retrieve. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) Get(name string) *ProjectsLocationsPrivateCloudsGetCall {
	c := &ProjectsLocationsPrivateCloudsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.get" call.
// Exactly one of *PrivateCloud or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *PrivateCloud.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsGetCall) Do(opts ...googleapi.CallOption) (*PrivateCloud, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PrivateCloud{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `PrivateCloud` resource by its resource name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the private cloud to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "PrivateCloud"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.getDnsForwarding":

type ProjectsLocationsPrivateCloudsGetDnsForwardingCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDnsForwarding: Gets details of the `DnsForwarding` config.
//
//   - name: The resource name of a `DnsForwarding` to retrieve. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     dnsForwarding`.
func (r *ProjectsLocationsPrivateCloudsService) GetDnsForwarding(name string) *ProjectsLocationsPrivateCloudsGetDnsForwardingCall {
	c := &ProjectsLocationsPrivateCloudsGetDnsForwardingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsGetDnsForwardingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsGetDnsForwardingCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsGetDnsForwardingCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.getDnsForwarding" call.
// Exactly one of *DnsForwarding or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *DnsForwarding.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsGetDnsForwardingCall) Do(opts ...googleapi.CallOption) (*DnsForwarding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DnsForwarding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of the `DnsForwarding` config.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/dnsForwarding",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.getDnsForwarding",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of a `DnsForwarding` to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/dnsForwarding$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "DnsForwarding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.getIamPolicy":

type ProjectsLocationsPrivateCloudsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsService) GetIamPolicy(resource string) *ProjectsLocationsPrivateCloudsGetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsPrivateCloudsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.list":

type ProjectsLocationsPrivateCloudsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `PrivateCloud` resources in a given project and location.
//
//   - parent: The resource name of the private cloud to be queried for
//     clusters. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example: `projects/my-project/locations/us-central1-a`.
func (r *ProjectsLocationsPrivateCloudsService) List(parent string) *ProjectsLocationsPrivateCloudsListCall {
	c := &ProjectsLocationsPrivateCloudsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of private clouds, you can
// exclude the ones named `example-pc` by specifying `name !=
// "example-pc". You can also filter nested fields. For example, you
// could specify `networkConfig.managementCidr = "192.168.0.0/24" to
// include private clouds only if they have a matching address in their
// network configuration. To filter on multiple expressions, provide
// each separate expression within parentheses. For example: ``` (name =
// "example-pc") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "private-cloud-1") AND (createTime > "2021-04-12T08:15:10.40Z") OR
// (name = "private-cloud-2") ```
func (c *ProjectsLocationsPrivateCloudsListCall) Filter(filter string) *ProjectsLocationsPrivateCloudsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateCloudsListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateCloudsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of private clouds to return in one page. The service may return fewer
// than this value. The maximum value is coerced to 1000. The default
// value of this field is 500.
func (c *ProjectsLocationsPrivateCloudsListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPrivateClouds` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListPrivateClouds` must match the call that provided the
// page token.
func (c *ProjectsLocationsPrivateCloudsListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/privateClouds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.list" call.
// Exactly one of *ListPrivateCloudsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListPrivateCloudsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsListCall) Do(opts ...googleapi.CallOption) (*ListPrivateCloudsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrivateCloudsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `PrivateCloud` resources in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of private clouds, you can exclude the ones named `example-pc` by specifying `name != \"example-pc\"`. You can also filter nested fields. For example, you could specify `networkConfig.managementCidr = \"192.168.0.0/24\"` to include private clouds only if they have a matching address in their network configuration. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-pc\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"private-cloud-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"private-cloud-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of private clouds to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListPrivateClouds` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPrivateClouds` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for clusters. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/privateClouds",
	//   "response": {
	//     "$ref": "ListPrivateCloudsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsListCall) Pages(ctx context.Context, f func(*ListPrivateCloudsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.patch":

type ProjectsLocationsPrivateCloudsPatchCall struct {
	s            *Service
	name         string
	privatecloud *PrivateCloud
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Modifies a `PrivateCloud` resource. Only the following fields
// can be updated: `description`. Only fields specified in `updateMask`
// are applied. During operation processing, the resource is temporarily
// in the `ACTIVE` state before the operation fully completes. For that
// period of time, you can't update the resource. Use the operation
// status to determine when the processing fully completes.
//
//   - name: Output only. The resource name of this private cloud.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) Patch(name string, privatecloud *PrivateCloud) *ProjectsLocationsPrivateCloudsPatchCall {
	c := &ProjectsLocationsPrivateCloudsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.privatecloud = privatecloud
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `PrivateCloud` resource by the update. The fields specified in
// `updateMask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.privatecloud)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a `PrivateCloud` resource. Only the following fields can be updated: `description`. Only fields specified in `updateMask` are applied. During operation processing, the resource is temporarily in the `ACTIVE` state before the operation fully completes. For that period of time, you can't update the resource. Use the operation status to determine when the processing fully completes.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this private cloud. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `PrivateCloud` resource by the update. The fields specified in `updateMask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "PrivateCloud"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.resetNsxCredentials":

type ProjectsLocationsPrivateCloudsResetNsxCredentialsCall struct {
	s                          *Service
	privateCloud               string
	resetnsxcredentialsrequest *ResetNsxCredentialsRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// ResetNsxCredentials: Resets credentials of the NSX appliance.
//
//   - privateCloud: The resource name of the private cloud to reset
//     credentials for. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) ResetNsxCredentials(privateCloud string, resetnsxcredentialsrequest *ResetNsxCredentialsRequest) *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall {
	c := &ProjectsLocationsPrivateCloudsResetNsxCredentialsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.privateCloud = privateCloud
	c.resetnsxcredentialsrequest = resetnsxcredentialsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.resetnsxcredentialsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+privateCloud}:resetNsxCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"privateCloud": c.privateCloud,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.resetNsxCredentials" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsResetNsxCredentialsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Resets credentials of the NSX appliance.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:resetNsxCredentials",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.resetNsxCredentials",
	//   "parameterOrder": [
	//     "privateCloud"
	//   ],
	//   "parameters": {
	//     "privateCloud": {
	//       "description": "Required. The resource name of the private cloud to reset credentials for. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+privateCloud}:resetNsxCredentials",
	//   "request": {
	//     "$ref": "ResetNsxCredentialsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.resetVcenterCredentials":

type ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall struct {
	s                              *Service
	privateCloud                   string
	resetvcentercredentialsrequest *ResetVcenterCredentialsRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// ResetVcenterCredentials: Resets credentials of the Vcenter appliance.
//
//   - privateCloud: The resource name of the private cloud to reset
//     credentials for. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) ResetVcenterCredentials(privateCloud string, resetvcentercredentialsrequest *ResetVcenterCredentialsRequest) *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall {
	c := &ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.privateCloud = privateCloud
	c.resetvcentercredentialsrequest = resetvcentercredentialsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.resetvcentercredentialsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+privateCloud}:resetVcenterCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"privateCloud": c.privateCloud,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.resetVcenterCredentials" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsResetVcenterCredentialsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Resets credentials of the Vcenter appliance.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:resetVcenterCredentials",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.resetVcenterCredentials",
	//   "parameterOrder": [
	//     "privateCloud"
	//   ],
	//   "parameters": {
	//     "privateCloud": {
	//       "description": "Required. The resource name of the private cloud to reset credentials for. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+privateCloud}:resetVcenterCredentials",
	//   "request": {
	//     "$ref": "ResetVcenterCredentialsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.setIamPolicy":

type ProjectsLocationsPrivateCloudsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsPrivateCloudsSetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.showNsxCredentials":

type ProjectsLocationsPrivateCloudsShowNsxCredentialsCall struct {
	s            *Service
	privateCloud string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ShowNsxCredentials: Gets details of credentials for NSX appliance.
//
//   - privateCloud: The resource name of the private cloud to be queried
//     for credentials. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) ShowNsxCredentials(privateCloud string) *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall {
	c := &ProjectsLocationsPrivateCloudsShowNsxCredentialsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.privateCloud = privateCloud
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+privateCloud}:showNsxCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"privateCloud": c.privateCloud,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.showNsxCredentials" call.
// Exactly one of *Credentials or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Credentials.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsShowNsxCredentialsCall) Do(opts ...googleapi.CallOption) (*Credentials, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Credentials{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of credentials for NSX appliance.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:showNsxCredentials",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.showNsxCredentials",
	//   "parameterOrder": [
	//     "privateCloud"
	//   ],
	//   "parameters": {
	//     "privateCloud": {
	//       "description": "Required. The resource name of the private cloud to be queried for credentials. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+privateCloud}:showNsxCredentials",
	//   "response": {
	//     "$ref": "Credentials"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.showVcenterCredentials":

type ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall struct {
	s            *Service
	privateCloud string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ShowVcenterCredentials: Gets details of credentials for Vcenter
// appliance.
//
//   - privateCloud: The resource name of the private cloud to be queried
//     for credentials. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) ShowVcenterCredentials(privateCloud string) *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall {
	c := &ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.privateCloud = privateCloud
	return c
}

// Username sets the optional parameter "username": The username of the
// user to be queried for credentials. The default value of this field
// is CloudOwner@gve.local. The provided value must be one of the
// following: CloudOwner@gve.local, solution-user-01@gve.local,
// solution-user-02@gve.local, solution-user-03@gve.local,
// solution-user-04@gve.local, solution-user-05@gve.local,
// zertoadmin@gve.local.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) Username(username string) *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall {
	c.urlParams_.Set("username", username)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+privateCloud}:showVcenterCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"privateCloud": c.privateCloud,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.showVcenterCredentials" call.
// Exactly one of *Credentials or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Credentials.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsShowVcenterCredentialsCall) Do(opts ...googleapi.CallOption) (*Credentials, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Credentials{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of credentials for Vcenter appliance.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:showVcenterCredentials",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.showVcenterCredentials",
	//   "parameterOrder": [
	//     "privateCloud"
	//   ],
	//   "parameters": {
	//     "privateCloud": {
	//       "description": "Required. The resource name of the private cloud to be queried for credentials. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "username": {
	//       "description": "Optional. The username of the user to be queried for credentials. The default value of this field is CloudOwner@gve.local. The provided value must be one of the following: CloudOwner@gve.local, solution-user-01@gve.local, solution-user-02@gve.local, solution-user-03@gve.local, solution-user-04@gve.local, solution-user-05@gve.local, zertoadmin@gve.local.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+privateCloud}:showVcenterCredentials",
	//   "response": {
	//     "$ref": "Credentials"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.testIamPermissions":

type ProjectsLocationsPrivateCloudsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsPrivateCloudsTestIamPermissionsCall {
	c := &ProjectsLocationsPrivateCloudsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.undelete":

type ProjectsLocationsPrivateCloudsUndeleteCall struct {
	s                           *Service
	name                        string
	undeleteprivatecloudrequest *UndeletePrivateCloudRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Undelete: Restores a private cloud that was previously scheduled for
// deletion by `DeletePrivateCloud`. A `PrivateCloud` resource scheduled
// for deletion has `PrivateCloud.state` set to `DELETED` and
// `PrivateCloud.expireTime` set to the time when deletion can no longer
// be reversed.
//
//   - name: The resource name of the private cloud scheduled for
//     deletion. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsService) Undelete(name string, undeleteprivatecloudrequest *UndeletePrivateCloudRequest) *ProjectsLocationsPrivateCloudsUndeleteCall {
	c := &ProjectsLocationsPrivateCloudsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.undeleteprivatecloudrequest = undeleteprivatecloudrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsUndeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsUndeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.undeleteprivatecloudrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.undelete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsUndeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Restores a private cloud that was previously scheduled for deletion by `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to the time when deletion can no longer be reversed.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}:undelete",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.undelete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the private cloud scheduled for deletion. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:undelete",
	//   "request": {
	//     "$ref": "UndeletePrivateCloudRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.updateDnsForwarding":

type ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall struct {
	s             *Service
	name          string
	dnsforwarding *DnsForwarding
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// UpdateDnsForwarding: Updates the parameters of the `DnsForwarding`
// config, like associated domains. Only fields specified in
// `update_mask` are applied.
//
//   - name: Output only. The resource name of this DNS profile. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     dnsForwarding`.
func (r *ProjectsLocationsPrivateCloudsService) UpdateDnsForwarding(name string, dnsforwarding *DnsForwarding) *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall {
	c := &ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dnsforwarding = dnsforwarding
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `DnsForwarding` resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.dnsforwarding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.updateDnsForwarding" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsUpdateDnsForwardingCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of the `DnsForwarding` config, like associated domains. Only fields specified in `update_mask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/dnsForwarding",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.updateDnsForwarding",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this DNS profile. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/dnsForwarding$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `DnsForwarding` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "DnsForwarding"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.create":

type ProjectsLocationsPrivateCloudsClustersCreateCall struct {
	s          *Service
	parent     string
	cluster    *Cluster
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new cluster in a given private cloud. Creating a
// new cluster provides additional nodes for use in the parent private
// cloud and requires sufficient node quota
// (https://cloud.google.com/vmware-engine/quotas).
//
//   - parent: The resource name of the private cloud to create a new
//     cluster in. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsClustersService) Create(parent string, cluster *Cluster) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c := &ProjectsLocationsPrivateCloudsClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.cluster = cluster
	return c
}

// ClusterId sets the optional parameter "clusterId": Required. The
// user-provided identifier of the new `Cluster`. This identifier must
// be unique among clusters within the parent and becomes the final
// token in the name URI. The identifier must meet the following
// requirements: * Only contains 1-63 alphanumeric characters and
// hyphens * Begins with an alphabetical character * Ends with a
// non-hyphen character * Not formatted as a UUID * Complies with RFC
// 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) ClusterId(clusterId string) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c.urlParams_.Set("clusterId", clusterId)
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": True if you
// want the request to be validated and not executed; false otherwise.
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new cluster in a given private cloud. Creating a new cluster provides additional nodes for use in the parent private cloud and requires sufficient [node quota](https://cloud.google.com/vmware-engine/quotas).",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "clusterId": {
	//       "description": "Required. The user-provided identifier of the new `Cluster`. This identifier must be unique among clusters within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to create a new cluster in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. True if you want the request to be validated and not executed; false otherwise.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/clusters",
	//   "request": {
	//     "$ref": "Cluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.delete":

type ProjectsLocationsPrivateCloudsClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Cluster` resource. To avoid unintended data loss,
// migrate or gracefully shut down any workloads running on the cluster
// before deletion. You cannot delete the management cluster of a
// private cloud using this method.
//
//   - name: The resource name of the cluster to delete. Resource names
//     are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     clusters/my-cluster`.
func (r *ProjectsLocationsPrivateCloudsClustersService) Delete(name string) *ProjectsLocationsPrivateCloudsClustersDeleteCall {
	c := &ProjectsLocationsPrivateCloudsClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsClustersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `Cluster` resource. To avoid unintended data loss, migrate or gracefully shut down any workloads running on the cluster before deletion. You cannot delete the management cluster of a private cloud using this method.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the cluster to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.get":

type ProjectsLocationsPrivateCloudsClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `Cluster` resource by its resource name.
//
//   - name: The cluster resource name to retrieve. Resource names are
//     schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     clusters/my-cluster`.
func (r *ProjectsLocationsPrivateCloudsClustersService) Get(name string) *ProjectsLocationsPrivateCloudsClustersGetCall {
	c := &ProjectsLocationsPrivateCloudsClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.get" call.
// Exactly one of *Cluster or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Cluster.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsClustersGetCall) Do(opts ...googleapi.CallOption) (*Cluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Cluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `Cluster` resource by its resource name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The cluster resource name to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Cluster"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.getIamPolicy":

type ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsClustersService) GetIamPolicy(resource string) *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.list":

type ProjectsLocationsPrivateCloudsClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `Cluster` resources in a given private cloud.
//
//   - parent: The resource name of the private cloud to query for
//     clusters. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsClustersService) List(parent string) *ProjectsLocationsPrivateCloudsClustersListCall {
	c := &ProjectsLocationsPrivateCloudsClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": To filter on multiple
// expressions, provide each separate expression within parentheses. For
// example: ``` (name = "example-cluster") (nodeCount = "3") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-cluster-1") AND (createTime > "2021-04-12T08:15:10.40Z")
// OR (name = "example-cluster-2") ```
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Filter(filter string) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of clusters to return in one page. The service may return fewer than
// this value. The maximum value is coerced to 1000. The default value
// of this field is 500.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListClusters` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListClusters` must match the call that provided the page
// token.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.list" call.
// Exactly one of *ListClustersResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListClustersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Do(opts ...googleapi.CallOption) (*ListClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `Cluster` resources in a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": " To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-cluster\") (nodeCount = \"3\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-cluster-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-cluster-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of clusters to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListClusters` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListClusters` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to query for clusters. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/clusters",
	//   "response": {
	//     "$ref": "ListClustersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsClustersListCall) Pages(ctx context.Context, f func(*ListClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.clusters.patch":

type ProjectsLocationsPrivateCloudsClustersPatchCall struct {
	s          *Service
	name       string
	cluster    *Cluster
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Modifies a `Cluster` resource. Only fields specified in
// `updateMask` are applied. During operation processing, the resource
// is temporarily in the `ACTIVE` state before the operation fully
// completes. For that period of time, you can't update the resource.
// Use the operation status to determine when the processing fully
// completes.
//
//   - name: Output only. The resource name of this cluster. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     clusters/my-cluster`.
func (r *ProjectsLocationsPrivateCloudsClustersService) Patch(name string, cluster *Cluster) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c := &ProjectsLocationsPrivateCloudsClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cluster = cluster
	return c
}

// RequestId sets the optional parameter "requestId": The request ID
// must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the `Cluster`
// resource by the update. The fields specified in the `updateMask` are
// relative to the resource, not the full request. A field will be
// overwritten if it is in the mask. If the user does not provide a mask
// then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": True if you
// want the request to be validated and not executed; false otherwise.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a `Cluster` resource. Only fields specified in `updateMask` are applied. During operation processing, the resource is temporarily in the `ACTIVE` state before the operation fully completes. For that period of time, you can't update the resource. Use the operation status to determine when the processing fully completes.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this cluster. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `Cluster` resource by the update. The fields specified in the `updateMask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. True if you want the request to be validated and not executed; false otherwise.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "Cluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.setIamPolicy":

type ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.testIamPermissions":

type ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsClustersService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall {
	c := &ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.nodes.get":

type ProjectsLocationsPrivateCloudsClustersNodesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single node.
//
//   - name: The resource name of the node to retrieve. For example:
//     `projects/{project}/locations/{location}/privateClouds/{private_clou
//     d}/clusters/{cluster}/nodes/{node}`.
func (r *ProjectsLocationsPrivateCloudsClustersNodesService) Get(name string) *ProjectsLocationsPrivateCloudsClustersNodesGetCall {
	c := &ProjectsLocationsPrivateCloudsClustersNodesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersNodesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsClustersNodesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersNodesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.nodes.get" call.
// Exactly one of *Node or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Node.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPrivateCloudsClustersNodesGetCall) Do(opts ...googleapi.CallOption) (*Node, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Node{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single node.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}/nodes/{nodesId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.nodes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the node to retrieve. For example: `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+/nodes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Node"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.clusters.nodes.list":

type ProjectsLocationsPrivateCloudsClustersNodesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists nodes in a given cluster.
//
//   - parent: The resource name of the cluster to be queried for nodes.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     clusters/my-cluster`.
func (r *ProjectsLocationsPrivateCloudsClustersNodesService) List(parent string) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c := &ProjectsLocationsPrivateCloudsClustersNodesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of nodes to return in one page. The service may return fewer than
// this value. The maximum value is coerced to 1000. The default value
// of this field is 500.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListNodes` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to `ListNodes` must match the call that provided the page token.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsClustersNodesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/nodes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.clusters.nodes.list" call.
// Exactly one of *ListNodesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListNodesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) Do(opts ...googleapi.CallOption) (*ListNodesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListNodesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists nodes in a given cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/clusters/{clustersId}/nodes",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.clusters.nodes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of nodes to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListNodes` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListNodes` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the cluster to be queried for nodes. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/clusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/nodes",
	//   "response": {
	//     "$ref": "ListNodesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsClustersNodesListCall) Pages(ctx context.Context, f func(*ListNodesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.externalAddresses.create":

type ProjectsLocationsPrivateCloudsExternalAddressesCreateCall struct {
	s               *Service
	parent          string
	externaladdress *ExternalAddress
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new `ExternalAddress` resource in a given private
// cloud. The network policy that corresponds to the private cloud must
// have the external IP address network service enabled
// (`NetworkPolicy.external_ip`).
//
//   - parent: The resource name of the private cloud to create a new
//     external IP address in. Resource names are schemeless URIs that
//     follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsExternalAddressesService) Create(parent string, externaladdress *ExternalAddress) *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall {
	c := &ProjectsLocationsPrivateCloudsExternalAddressesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.externaladdress = externaladdress
	return c
}

// ExternalAddressId sets the optional parameter "externalAddressId":
// Required. The user-provided identifier of the `ExternalAddress` to be
// created. This identifier must be unique among `ExternalAddress`
// resources within the parent and becomes the final token in the name
// URI. The identifier must meet the following requirements: * Only
// contains 1-63 alphanumeric characters and hyphens * Begins with an
// alphabetical character * Ends with a non-hyphen character * Not
// formatted as a UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) ExternalAddressId(externalAddressId string) *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall {
	c.urlParams_.Set("externalAddressId", externalAddressId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.externaladdress)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalAddresses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.externalAddresses.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new `ExternalAddress` resource in a given private cloud. The network policy that corresponds to the private cloud must have the external IP address network service enabled (`NetworkPolicy.external_ip`).",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/externalAddresses",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.externalAddresses.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "externalAddressId": {
	//       "description": "Required. The user-provided identifier of the `ExternalAddress` to be created. This identifier must be unique among `ExternalAddress` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to create a new external IP address in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/externalAddresses",
	//   "request": {
	//     "$ref": "ExternalAddress"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.externalAddresses.delete":

type ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single external IP address. When you delete an
// external IP address, connectivity between the external IP address and
// the corresponding internal IP address is lost.
//
//   - name: The resource name of the external IP address to delete.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     externalAddresses/my-ip`.
func (r *ProjectsLocationsPrivateCloudsExternalAddressesService) Delete(name string) *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall {
	c := &ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.externalAddresses.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single external IP address. When you delete an external IP address, connectivity between the external IP address and the corresponding internal IP address is lost.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/externalAddresses/{externalAddressesId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateClouds.externalAddresses.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the external IP address to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/externalAddresses/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.externalAddresses.get":

type ProjectsLocationsPrivateCloudsExternalAddressesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single external IP address.
//
//   - name: The resource name of the external IP address to retrieve.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     externalAddresses/my-ip`.
func (r *ProjectsLocationsPrivateCloudsExternalAddressesService) Get(name string) *ProjectsLocationsPrivateCloudsExternalAddressesGetCall {
	c := &ProjectsLocationsPrivateCloudsExternalAddressesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsExternalAddressesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsExternalAddressesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsExternalAddressesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.externalAddresses.get" call.
// Exactly one of *ExternalAddress or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ExternalAddress.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesGetCall) Do(opts ...googleapi.CallOption) (*ExternalAddress, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExternalAddress{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single external IP address.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/externalAddresses/{externalAddressesId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.externalAddresses.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the external IP address to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/externalAddresses/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "ExternalAddress"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.externalAddresses.list":

type ProjectsLocationsPrivateCloudsExternalAddressesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists external IP addresses assigned to VMware workload VMs in
// a given private cloud.
//
//   - parent: The resource name of the private cloud to be queried for
//     external IP addresses. Resource names are schemeless URIs that
//     follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsExternalAddressesService) List(parent string) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c := &ProjectsLocationsPrivateCloudsExternalAddressesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of IP addresses, you can exclude
// the ones named `example-ip` by specifying `name != "example-ip". To
// filter on multiple expressions, provide each separate expression
// within parentheses. For example: ``` (name = "example-ip")
// (createTime > "2021-04-12T08:15:10.40Z") ``` By default, each
// expression is an `AND` expression. However, you can include `AND` and
// `OR` expressions explicitly. For example: ``` (name = "example-ip-1")
// AND (createTime > "2021-04-12T08:15:10.40Z") OR (name =
// "example-ip-2") ```
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Filter(filter string) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of external IP addresses to return in one page. The service may
// return fewer than this value. The maximum value is coerced to 1000.
// The default value of this field is 500.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListExternalAddresses` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListExternalAddresses` must match the call
// that provided the page token.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsExternalAddressesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalAddresses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.externalAddresses.list" call.
// Exactly one of *ListExternalAddressesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListExternalAddressesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Do(opts ...googleapi.CallOption) (*ListExternalAddressesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExternalAddressesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists external IP addresses assigned to VMware workload VMs in a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/externalAddresses",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.externalAddresses.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of IP addresses, you can exclude the ones named `example-ip` by specifying `name != \"example-ip\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-ip\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-ip-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-ip-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of external IP addresses to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListExternalAddresses` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListExternalAddresses` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for external IP addresses. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/externalAddresses",
	//   "response": {
	//     "$ref": "ListExternalAddressesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesListCall) Pages(ctx context.Context, f func(*ListExternalAddressesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.externalAddresses.patch":

type ProjectsLocationsPrivateCloudsExternalAddressesPatchCall struct {
	s               *Service
	name            string
	externaladdress *ExternalAddress
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of a single external IP address. Only
// fields specified in `update_mask` are applied. During operation
// processing, the resource is temporarily in the `ACTIVE` state before
// the operation fully completes. For that period of time, you can't
// update the resource. Use the operation status to determine when the
// processing fully completes.
//
//   - name: Output only. The resource name of this external IP address.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     externalAddresses/my-address`.
func (r *ProjectsLocationsPrivateCloudsExternalAddressesService) Patch(name string, externaladdress *ExternalAddress) *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall {
	c := &ProjectsLocationsPrivateCloudsExternalAddressesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.externaladdress = externaladdress
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `ExternalAddress` resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.externaladdress)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.externalAddresses.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsExternalAddressesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single external IP address. Only fields specified in `update_mask` are applied. During operation processing, the resource is temporarily in the `ACTIVE` state before the operation fully completes. For that period of time, you can't update the resource. Use the operation status to determine when the processing fully completes.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/externalAddresses/{externalAddressesId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.externalAddresses.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this external IP address. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-address`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/externalAddresses/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `ExternalAddress` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "ExternalAddress"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.create":

type ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall struct {
	s                *Service
	parent           string
	hcxactivationkey *HcxActivationKey
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new HCX activation key in a given private cloud.
//
//   - parent: The resource name of the private cloud to create the key
//     for. Resource names are schemeless URIs that follow the conventions
//     in https://cloud.google.com/apis/design/resource_names. For
//     example:
//     `projects/my-project/locations/us-central1/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) Create(parent string, hcxactivationkey *HcxActivationKey) *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.hcxactivationkey = hcxactivationkey
	return c
}

// HcxActivationKeyId sets the optional parameter "hcxActivationKeyId":
// Required. The user-provided identifier of the `HcxActivationKey` to
// be created. This identifier must be unique among `HcxActivationKey`
// resources within the parent and becomes the final token in the name
// URI. The identifier must meet the following requirements: * Only
// contains 1-63 alphanumeric characters and hyphens * Begins with an
// alphabetical character * Ends with a non-hyphen character * Not
// formatted as a UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) HcxActivationKeyId(hcxActivationKeyId string) *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall {
	c.urlParams_.Set("hcxActivationKeyId", hcxActivationKeyId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.hcxactivationkey)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/hcxActivationKeys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new HCX activation key in a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "hcxActivationKeyId": {
	//       "description": "Required. The user-provided identifier of the `HcxActivationKey` to be created. This identifier must be unique among `HcxActivationKey` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to create the key for. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/hcxActivationKeys",
	//   "request": {
	//     "$ref": "HcxActivationKey"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.get":

type ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `HcxActivationKey` resource by its resource name.
//
//   - name: The resource name of the HCX activation key to retrieve.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/privateClouds/my-cloud/hc
//     xActivationKeys/my-key`.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) Get(name string) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.get" call.
// Exactly one of *HcxActivationKey or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *HcxActivationKey.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetCall) Do(opts ...googleapi.CallOption) (*HcxActivationKey, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HcxActivationKey{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `HcxActivationKey` resource by its resource name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys/{hcxActivationKeysId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the HCX activation key to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/hcxActivationKeys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "HcxActivationKey"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.getIamPolicy":

type ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) GetIamPolicy(resource string) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys/{hcxActivationKeysId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/hcxActivationKeys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.list":

type ProjectsLocationsPrivateCloudsHcxActivationKeysListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `HcxActivationKey` resources in a given private cloud.
//
//   - parent: The resource name of the private cloud to be queried for
//     HCX activation keys. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) List(parent string) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of HCX activation keys to return in one page. The service may return
// fewer than this value. The maximum value is coerced to 1000. The
// default value of this field is 500.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListHcxActivationKeys` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListHcxActivationKeys` must match the call
// that provided the page token.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/hcxActivationKeys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.list" call.
// Exactly one of *ListHcxActivationKeysResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListHcxActivationKeysResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) Do(opts ...googleapi.CallOption) (*ListHcxActivationKeysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListHcxActivationKeysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `HcxActivationKey` resources in a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of HCX activation keys to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListHcxActivationKeys` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListHcxActivationKeys` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for HCX activation keys. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/hcxActivationKeys",
	//   "response": {
	//     "$ref": "ListHcxActivationKeysResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysListCall) Pages(ctx context.Context, f func(*ListHcxActivationKeysResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.setIamPolicy":

type ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys/{hcxActivationKeysId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/hcxActivationKeys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.testIamPermissions":

type ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsPrivateCloudsHcxActivationKeysService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall {
	c := &ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsHcxActivationKeysTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/hcxActivationKeys/{hcxActivationKeysId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.hcxActivationKeys.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/hcxActivationKeys/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.loggingServers.create":

type ProjectsLocationsPrivateCloudsLoggingServersCreateCall struct {
	s             *Service
	parent        string
	loggingserver *LoggingServer
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Create a new logging server for a given private cloud.
//
//   - parent: The resource name of the private cloud to create a new
//     Logging Server in. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsLoggingServersService) Create(parent string, loggingserver *LoggingServer) *ProjectsLocationsPrivateCloudsLoggingServersCreateCall {
	c := &ProjectsLocationsPrivateCloudsLoggingServersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.loggingserver = loggingserver
	return c
}

// LoggingServerId sets the optional parameter "loggingServerId":
// Required. The user-provided identifier of the `LoggingServer` to be
// created. This identifier must be unique among `LoggingServer`
// resources within the parent and becomes the final token in the name
// URI. The identifier must meet the following requirements: * Only
// contains 1-63 alphanumeric characters and hyphens * Begins with an
// alphabetical character * Ends with a non-hyphen character * Not
// formatted as a UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) LoggingServerId(loggingServerId string) *ProjectsLocationsPrivateCloudsLoggingServersCreateCall {
	c.urlParams_.Set("loggingServerId", loggingServerId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsLoggingServersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsLoggingServersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsLoggingServersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loggingserver)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/loggingServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.loggingServers.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsLoggingServersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a new logging server for a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/loggingServers",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.loggingServers.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "loggingServerId": {
	//       "description": "Required. The user-provided identifier of the `LoggingServer` to be created. This identifier must be unique among `LoggingServer` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to create a new Logging Server in. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/loggingServers",
	//   "request": {
	//     "$ref": "LoggingServer"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.loggingServers.delete":

type ProjectsLocationsPrivateCloudsLoggingServersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single logging server.
//
//   - name: The resource name of the logging server to delete. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     loggingServers/my-logging-server`.
func (r *ProjectsLocationsPrivateCloudsLoggingServersService) Delete(name string) *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall {
	c := &ProjectsLocationsPrivateCloudsLoggingServersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.loggingServers.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsLoggingServersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single logging server.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/loggingServers/{loggingServersId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateClouds.loggingServers.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the logging server to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/loggingServers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.loggingServers.get":

type ProjectsLocationsPrivateCloudsLoggingServersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a logging server.
//
//   - name: The resource name of the Logging Server to retrieve. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     loggingServers/my-logging-server`.
func (r *ProjectsLocationsPrivateCloudsLoggingServersService) Get(name string) *ProjectsLocationsPrivateCloudsLoggingServersGetCall {
	c := &ProjectsLocationsPrivateCloudsLoggingServersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsLoggingServersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsLoggingServersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsLoggingServersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.loggingServers.get" call.
// Exactly one of *LoggingServer or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *LoggingServer.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsLoggingServersGetCall) Do(opts ...googleapi.CallOption) (*LoggingServer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoggingServer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a logging server.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/loggingServers/{loggingServersId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.loggingServers.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Logging Server to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/loggingServers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "LoggingServer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.loggingServers.list":

type ProjectsLocationsPrivateCloudsLoggingServersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists logging servers configured for a given private cloud.
//
//   - parent: The resource name of the private cloud to be queried for
//     logging servers. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsLoggingServersService) List(parent string) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c := &ProjectsLocationsPrivateCloudsLoggingServersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of logging servers, you can
// exclude the ones named `example-server` by specifying `name !=
// "example-server". To filter on multiple expressions, provide each
// separate expression within parentheses. For example: ``` (name =
// "example-server") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-server-1") AND (createTime > "2021-04-12T08:15:10.40Z") OR
// (name = "example-server-2") ```
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Filter(filter string) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of logging servers to return in one page. The service may return
// fewer than this value. The maximum value is coerced to 1000. The
// default value of this field is 500.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListLoggingServersRequest` call. Provide
// this to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListLoggingServersRequest` must match the
// call that provided the page token.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsLoggingServersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/loggingServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.loggingServers.list" call.
// Exactly one of *ListLoggingServersResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListLoggingServersResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Do(opts ...googleapi.CallOption) (*ListLoggingServersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLoggingServersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists logging servers configured for a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/loggingServers",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.loggingServers.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of logging servers, you can exclude the ones named `example-server` by specifying `name != \"example-server\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-server\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-server-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-server-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of logging servers to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListLoggingServersRequest` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListLoggingServersRequest` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for logging servers. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/loggingServers",
	//   "response": {
	//     "$ref": "ListLoggingServersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsLoggingServersListCall) Pages(ctx context.Context, f func(*ListLoggingServersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.loggingServers.patch":

type ProjectsLocationsPrivateCloudsLoggingServersPatchCall struct {
	s             *Service
	name          string
	loggingserver *LoggingServer
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the parameters of a single logging server. Only fields
// specified in `update_mask` are applied.
//
//   - name: Output only. The resource name of this logging server.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     loggingServers/my-logging-server`.
func (r *ProjectsLocationsPrivateCloudsLoggingServersService) Patch(name string, loggingserver *LoggingServer) *ProjectsLocationsPrivateCloudsLoggingServersPatchCall {
	c := &ProjectsLocationsPrivateCloudsLoggingServersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.loggingserver = loggingserver
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsLoggingServersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `LoggingServer` resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsLoggingServersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsLoggingServersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsLoggingServersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loggingserver)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.loggingServers.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsLoggingServersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single logging server. Only fields specified in `update_mask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/loggingServers/{loggingServersId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.loggingServers.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this logging server. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/loggingServers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `LoggingServer` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "LoggingServer"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.create":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall struct {
	s                        *Service
	parent                   string
	managementdnszonebinding *ManagementDnsZoneBinding
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Create: Creates a new `ManagementDnsZoneBinding` resource in a
// private cloud. This RPC creates the DNS binding and the resource that
// represents the DNS binding of the consumer VPC network to the
// management DNS zone. A management DNS zone is the Cloud DNS
// cross-project binding zone that VMware Engine creates for each
// private cloud. It contains FQDNs and corresponding IP addresses for
// the private cloud's ESXi hosts and management VM appliances like
// vCenter and NSX Manager.
//
//   - parent: The resource name of the private cloud to create a new
//     management DNS zone binding for. Resource names are schemeless URIs
//     that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) Create(parent string, managementdnszonebinding *ManagementDnsZoneBinding) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.managementdnszonebinding = managementdnszonebinding
	return c
}

// ManagementDnsZoneBindingId sets the optional parameter
// "managementDnsZoneBindingId": Required. The user-provided identifier
// of the `ManagementDnsZoneBinding` resource to be created. This
// identifier must be unique among `ManagementDnsZoneBinding` resources
// within the parent and becomes the final token in the name URI. The
// identifier must meet the following requirements: * Only contains 1-63
// alphanumeric characters and hyphens * Begins with an alphabetical
// character * Ends with a non-hyphen character * Not formatted as a
// UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) ManagementDnsZoneBindingId(managementDnsZoneBindingId string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall {
	c.urlParams_.Set("managementDnsZoneBindingId", managementDnsZoneBindingId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.managementdnszonebinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/managementDnsZoneBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new `ManagementDnsZoneBinding` resource in a private cloud. This RPC creates the DNS binding and the resource that represents the DNS binding of the consumer VPC network to the management DNS zone. A management DNS zone is the Cloud DNS cross-project binding zone that VMware Engine creates for each private cloud. It contains FQDNs and corresponding IP addresses for the private cloud's ESXi hosts and management VM appliances like vCenter and NSX Manager.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "managementDnsZoneBindingId": {
	//       "description": "Required. The user-provided identifier of the `ManagementDnsZoneBinding` resource to be created. This identifier must be unique among `ManagementDnsZoneBinding` resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to create a new management DNS zone binding for. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/managementDnsZoneBindings",
	//   "request": {
	//     "$ref": "ManagementDnsZoneBinding"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.delete":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `ManagementDnsZoneBinding` resource. When a
// management DNS zone binding is deleted, the corresponding consumer
// VPC network is no longer bound to the management DNS zone.
//
//   - name: The resource name of the management DNS zone binding to
//     delete. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     managementDnsZoneBindings/my-management-dns-zone-binding`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) Delete(name string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone binding is deleted, the corresponding consumer VPC network is no longer bound to the management DNS zone.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings/{managementDnsZoneBindingsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the management DNS zone binding to delete. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/managementDnsZoneBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.get":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a 'ManagementDnsZoneBinding' resource by its resource
// name.
//
//   - name: The resource name of the management DNS zone binding to
//     retrieve. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     managementDnsZoneBindings/my-management-dns-zone-binding`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) Get(name string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.get" call.
// Exactly one of *ManagementDnsZoneBinding or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ManagementDnsZoneBinding.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsGetCall) Do(opts ...googleapi.CallOption) (*ManagementDnsZoneBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ManagementDnsZoneBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings/{managementDnsZoneBindingsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the management DNS zone binding to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/managementDnsZoneBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "ManagementDnsZoneBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.list":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Consumer VPCs bound to Management DNS Zone of a given
// private cloud.
//
//   - parent: The resource name of the private cloud to be queried for
//     management DNS zone bindings. Resource names are schemeless URIs
//     that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) List(parent string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of Management DNS Zone Bindings,
// you can exclude the ones named `example-management-dns-zone-binding`
// by specifying `name != "example-management-dns-zone-binding". To
// filter on multiple expressions, provide each separate expression
// within parentheses. For example: ``` (name =
// "example-management-dns-zone-binding") (createTime >
// "2021-04-12T08:15:10.40Z") ``` By default, each expression is an
// `AND` expression. However, you can include `AND` and `OR` expressions
// explicitly. For example: ``` (name =
// "example-management-dns-zone-binding-1") AND (createTime >
// "2021-04-12T08:15:10.40Z") OR (name =
// "example-management-dns-zone-binding-2") ```
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Filter(filter string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of management DNS zone bindings to return in one page. The service
// may return fewer than this value. The maximum value is coerced to
// 1000. The default value of this field is 500.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListManagementDnsZoneBindings` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `ListManagementDnsZoneBindings` must
// match the call that provided the page token.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/managementDnsZoneBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.list" call.
// Exactly one of *ListManagementDnsZoneBindingsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *ListManagementDnsZoneBindingsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Do(opts ...googleapi.CallOption) (*ListManagementDnsZoneBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListManagementDnsZoneBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of Management DNS Zone Bindings, you can exclude the ones named `example-management-dns-zone-binding` by specifying `name != \"example-management-dns-zone-binding\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-management-dns-zone-binding\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-management-dns-zone-binding-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-management-dns-zone-binding-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of management DNS zone bindings to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListManagementDnsZoneBindings` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListManagementDnsZoneBindings` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for management DNS zone bindings. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/managementDnsZoneBindings",
	//   "response": {
	//     "$ref": "ListManagementDnsZoneBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsListCall) Pages(ctx context.Context, f func(*ListManagementDnsZoneBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.patch":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall struct {
	s                        *Service
	name                     string
	managementdnszonebinding *ManagementDnsZoneBinding
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Patch: Updates a `ManagementDnsZoneBinding` resource. Only fields
// specified in `update_mask` are applied.
//
//   - name: Output only. The resource name of this binding. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     managementDnsZoneBindings/my-management-dns-zone-binding`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) Patch(name string, managementdnszonebinding *ManagementDnsZoneBinding) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.managementdnszonebinding = managementdnszonebinding
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if the original operation
// with the same request ID was received, and if so, will ignore the
// second request. This prevents clients from accidentally creating
// duplicate commitments. The request ID must be a valid UUID with the
// exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `ManagementDnsZoneBinding` resource by the update. The fields
// specified in the `update_mask` are relative to the resource, not the
// full request. A field will be overwritten if it is in the mask. If
// the user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.managementdnszonebinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a `ManagementDnsZoneBinding` resource. Only fields specified in `update_mask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings/{managementDnsZoneBindingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this binding. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/managementDnsZoneBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if the original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `ManagementDnsZoneBinding` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "ManagementDnsZoneBinding"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.repair":

type ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall struct {
	s                                     *Service
	name                                  string
	repairmanagementdnszonebindingrequest *RepairManagementDnsZoneBindingRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Repair: Retries to create a `ManagementDnsZoneBinding` resource that
// is in failed state.
//
//   - name: The resource name of the management DNS zone binding to
//     repair. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     managementDnsZoneBindings/my-management-dns-zone-binding`.
func (r *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsService) Repair(name string, repairmanagementdnszonebindingrequest *RepairManagementDnsZoneBindingRequest) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall {
	c := &ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.repairmanagementdnszonebindingrequest = repairmanagementdnszonebindingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.repairmanagementdnszonebindingrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:repair")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.repair" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsManagementDnsZoneBindingsRepairCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retries to create a `ManagementDnsZoneBinding` resource that is in failed state.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/managementDnsZoneBindings/{managementDnsZoneBindingsId}:repair",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateClouds.managementDnsZoneBindings.repair",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the management DNS zone binding to repair. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/managementDnsZoneBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:repair",
	//   "request": {
	//     "$ref": "RepairManagementDnsZoneBindingRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.subnets.get":

type ProjectsLocationsPrivateCloudsSubnetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single subnet.
//
//   - name: The resource name of the subnet to retrieve. Resource names
//     are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     subnets/my-subnet`.
func (r *ProjectsLocationsPrivateCloudsSubnetsService) Get(name string) *ProjectsLocationsPrivateCloudsSubnetsGetCall {
	c := &ProjectsLocationsPrivateCloudsSubnetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsSubnetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsSubnetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsSubnetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.subnets.get" call.
// Exactly one of *Subnet or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Subnet.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsPrivateCloudsSubnetsGetCall) Do(opts ...googleapi.CallOption) (*Subnet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subnet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single subnet.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/subnets/{subnetsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.subnets.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the subnet to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/subnets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Subnet"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateClouds.subnets.list":

type ProjectsLocationsPrivateCloudsSubnetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists subnets in a given private cloud.
//
//   - parent: The resource name of the private cloud to be queried for
//     subnets. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`.
func (r *ProjectsLocationsPrivateCloudsSubnetsService) List(parent string) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c := &ProjectsLocationsPrivateCloudsSubnetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of subnets to return in one page. The service may return fewer than
// this value. The maximum value is coerced to 1000. The default value
// of this field is 500.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListSubnetsRequest` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListSubnetsRequest` must match the call that provided
// the page token.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) PageToken(pageToken string) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsSubnetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/subnets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.subnets.list" call.
// Exactly one of *ListSubnetsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListSubnetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) Do(opts ...googleapi.CallOption) (*ListSubnetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSubnetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists subnets in a given private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/subnets",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateClouds.subnets.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of subnets to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListSubnetsRequest` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSubnetsRequest` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private cloud to be queried for subnets. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/subnets",
	//   "response": {
	//     "$ref": "ListSubnetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateCloudsSubnetsListCall) Pages(ctx context.Context, f func(*ListSubnetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateClouds.subnets.patch":

type ProjectsLocationsPrivateCloudsSubnetsPatchCall struct {
	s          *Service
	name       string
	subnet     *Subnet
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single subnet. Only fields
// specified in `update_mask` are applied. *Note*: This API is
// synchronous and always returns a successful
// `google.longrunning.Operation` (LRO). The returned LRO will only have
// `done` and `response` fields.
//
//   - name: Output only. The resource name of this subnet. Resource names
//     are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/
//     subnets/my-subnet`.
func (r *ProjectsLocationsPrivateCloudsSubnetsService) Patch(name string, subnet *Subnet) *ProjectsLocationsPrivateCloudsSubnetsPatchCall {
	c := &ProjectsLocationsPrivateCloudsSubnetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.subnet = subnet
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the `Subnet`
// resource by the update. The fields specified in the `update_mask` are
// relative to the resource, not the full request. A field will be
// overwritten if it is in the mask. If the user does not provide a mask
// then all fields will be overwritten.
func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateCloudsSubnetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateCloudsSubnetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateCloudsSubnetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subnet)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateClouds.subnets.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateCloudsSubnetsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single subnet. Only fields specified in `update_mask` are applied. *Note*: This API is synchronous and always returns a successful `google.longrunning.Operation` (LRO). The returned LRO will only have `done` and `response` fields.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateClouds/{privateCloudsId}/subnets/{subnetsId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateClouds.subnets.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of this subnet. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateClouds/[^/]+/subnets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `Subnet` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "Subnet"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateConnections.create":

type ProjectsLocationsPrivateConnectionsCreateCall struct {
	s                 *Service
	parent            string
	privateconnection *PrivateConnection
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new private connection that can be used for
// accessing private Clouds.
//
//   - parent: The resource name of the location to create the new private
//     connection in. Private connection is a regional resource. Resource
//     names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1`.
func (r *ProjectsLocationsPrivateConnectionsService) Create(parent string, privateconnection *PrivateConnection) *ProjectsLocationsPrivateConnectionsCreateCall {
	c := &ProjectsLocationsPrivateConnectionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.privateconnection = privateconnection
	return c
}

// PrivateConnectionId sets the optional parameter
// "privateConnectionId": Required. The user-provided identifier of the
// new private connection. This identifier must be unique among private
// connection resources within the parent and becomes the final token in
// the name URI. The identifier must meet the following requirements: *
// Only contains 1-63 alphanumeric characters and hyphens * Begins with
// an alphabetical character * Ends with a non-hyphen character * Not
// formatted as a UUID * Complies with RFC 1034
// (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsPrivateConnectionsCreateCall) PrivateConnectionId(privateConnectionId string) *ProjectsLocationsPrivateConnectionsCreateCall {
	c.urlParams_.Set("privateConnectionId", privateConnectionId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateConnectionsCreateCall) RequestId(requestId string) *ProjectsLocationsPrivateConnectionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsCreateCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.privateconnection)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/privateConnections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateConnectionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new private connection that can be used for accessing private Clouds.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.privateConnections.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the location to create the new private connection in. Private connection is a regional resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "privateConnectionId": {
	//       "description": "Required. The user-provided identifier of the new private connection. This identifier must be unique among private connection resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/privateConnections",
	//   "request": {
	//     "$ref": "PrivateConnection"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateConnections.delete":

type ProjectsLocationsPrivateConnectionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `PrivateConnection` resource. When a private
// connection is deleted for a VMware Engine network, the connected
// network becomes inaccessible to that VMware Engine network.
//
//   - name: The resource name of the private connection to be deleted.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/privateConnections/my-con
//     nection`.
func (r *ProjectsLocationsPrivateConnectionsService) Delete(name string) *ProjectsLocationsPrivateConnectionsDeleteCall {
	c := &ProjectsLocationsPrivateConnectionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateConnectionsDeleteCall) RequestId(requestId string) *ProjectsLocationsPrivateConnectionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateConnectionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `PrivateConnection` resource. When a private connection is deleted for a VMware Engine network, the connected network becomes inaccessible to that VMware Engine network.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections/{privateConnectionsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.privateConnections.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the private connection to be deleted. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateConnections/my-connection`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateConnections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateConnections.get":

type ProjectsLocationsPrivateConnectionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `PrivateConnection` resource by its resource name.
// The resource contains details of the private connection, such as
// connected network, routing mode and state.
//
//   - name: The resource name of the private connection to retrieve.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/privateConnections/my-con
//     nection`.
func (r *ProjectsLocationsPrivateConnectionsService) Get(name string) *ProjectsLocationsPrivateConnectionsGetCall {
	c := &ProjectsLocationsPrivateConnectionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateConnectionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateConnectionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsGetCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.get" call.
// Exactly one of *PrivateConnection or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *PrivateConnection.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateConnectionsGetCall) Do(opts ...googleapi.CallOption) (*PrivateConnection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PrivateConnection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `PrivateConnection` resource by its resource name. The resource contains details of the private connection, such as connected network, routing mode and state.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections/{privateConnectionsId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateConnections.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the private connection to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateConnections/my-connection`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateConnections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "PrivateConnection"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateConnections.list":

type ProjectsLocationsPrivateConnectionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `PrivateConnection` resources in a given project and
// location.
//
//   - parent: The resource name of the location to query for private
//     connections. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example: `projects/my-project/locations/us-central1`.
func (r *ProjectsLocationsPrivateConnectionsService) List(parent string) *ProjectsLocationsPrivateConnectionsListCall {
	c := &ProjectsLocationsPrivateConnectionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of private connections, you can
// exclude the ones named `example-connection` by specifying `name !=
// "example-connection". To filter on multiple expressions, provide
// each separate expression within parentheses. For example: ``` (name =
// "example-connection") (createTime > "2022-09-22T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-connection-1") AND (createTime >
// "2021-04-12T08:15:10.40Z") OR (name = "example-connection-2") ```
func (c *ProjectsLocationsPrivateConnectionsListCall) Filter(filter string) *ProjectsLocationsPrivateConnectionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsPrivateConnectionsListCall) OrderBy(orderBy string) *ProjectsLocationsPrivateConnectionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of private connections to return in one page. The maximum value is
// coerced to 1000. The default value of this field is 500.
func (c *ProjectsLocationsPrivateConnectionsListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateConnectionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPrivateConnections` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListPrivateConnections` must match the call
// that provided the page token.
func (c *ProjectsLocationsPrivateConnectionsListCall) PageToken(pageToken string) *ProjectsLocationsPrivateConnectionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateConnectionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateConnectionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsListCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/privateConnections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.list" call.
// Exactly one of *ListPrivateConnectionsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListPrivateConnectionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateConnectionsListCall) Do(opts ...googleapi.CallOption) (*ListPrivateConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrivateConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `PrivateConnection` resources in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateConnections.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of private connections, you can exclude the ones named `example-connection` by specifying `name != \"example-connection\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-connection\") (createTime \u003e \"2022-09-22T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-connection-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-connection-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of private connections to return in one page. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListPrivateConnections` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPrivateConnections` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location to query for private connections. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/privateConnections",
	//   "response": {
	//     "$ref": "ListPrivateConnectionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateConnectionsListCall) Pages(ctx context.Context, f func(*ListPrivateConnectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.privateConnections.patch":

type ProjectsLocationsPrivateConnectionsPatchCall struct {
	s                 *Service
	name              string
	privateconnection *PrivateConnection
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Modifies a `PrivateConnection` resource. Only `description`
// and `routing_mode` fields can be updated. Only fields specified in
// `updateMask` are applied.
//
//   - name: Output only. The resource name of the private connection.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-central1/privateConnections/my-con
//     nection`.
func (r *ProjectsLocationsPrivateConnectionsService) Patch(name string, privateconnection *PrivateConnection) *ProjectsLocationsPrivateConnectionsPatchCall {
	c := &ProjectsLocationsPrivateConnectionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.privateconnection = privateconnection
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPrivateConnectionsPatchCall) RequestId(requestId string) *ProjectsLocationsPrivateConnectionsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// `PrivateConnection` resource by the update. The fields specified in
// the `update_mask` are relative to the resource, not the full request.
// A field will be overwritten if it is in the mask. If the user does
// not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsPrivateConnectionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPrivateConnectionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsPatchCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.privateconnection)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPrivateConnectionsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a `PrivateConnection` resource. Only `description` and `routing_mode` fields can be updated. Only fields specified in `updateMask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections/{privateConnectionsId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.privateConnections.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of the private connection. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-central1/privateConnections/my-connection`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateConnections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the `PrivateConnection` resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "PrivateConnection"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.privateConnections.peeringRoutes.list":

type ProjectsLocationsPrivateConnectionsPeeringRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the private connection routes exchanged over a peering
// connection.
//
//   - parent: The resource name of the private connection to retrieve
//     peering routes from. Resource names are schemeless URIs that follow
//     the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/us-west1/privateConnections/my-connec
//     tion`.
func (r *ProjectsLocationsPrivateConnectionsPeeringRoutesService) List(parent string) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c := &ProjectsLocationsPrivateConnectionsPeeringRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of peering routes to return in one page. The service may return fewer
// than this value. The maximum value is coerced to 1000. The default
// value of this field is 500.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPrivateConnectionPeeringRoutes` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `ListPrivateConnectionPeeringRoutes`
// must match the call that provided the page token.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) PageToken(pageToken string) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) Context(ctx context.Context) *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/peeringRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.privateConnections.peeringRoutes.list" call.
// Exactly one of *ListPrivateConnectionPeeringRoutesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *ListPrivateConnectionPeeringRoutesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) Do(opts ...googleapi.CallOption) (*ListPrivateConnectionPeeringRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrivateConnectionPeeringRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the private connection routes exchanged over a peering connection.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/privateConnections/{privateConnectionsId}/peeringRoutes",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.privateConnections.peeringRoutes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of peering routes to return in one page. The service may return fewer than this value. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListPrivateConnectionPeeringRoutes` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPrivateConnectionPeeringRoutes` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the private connection to retrieve peering routes from. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/us-west1/privateConnections/my-connection`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/privateConnections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/peeringRoutes",
	//   "response": {
	//     "$ref": "ListPrivateConnectionPeeringRoutesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPrivateConnectionsPeeringRoutesListCall) Pages(ctx context.Context, f func(*ListPrivateConnectionPeeringRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.vmwareEngineNetworks.create":

type ProjectsLocationsVmwareEngineNetworksCreateCall struct {
	s                   *Service
	parent              string
	vmwareenginenetwork *VmwareEngineNetwork
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a new VMware Engine network that can be used by a
// private cloud.
//
//   - parent: The resource name of the location to create the new VMware
//     Engine network in. A VMware Engine network of type `LEGACY` is a
//     regional resource, and a VMware Engine network of type `STANDARD`
//     is a global resource. Resource names are schemeless URIs that
//     follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global`.
func (r *ProjectsLocationsVmwareEngineNetworksService) Create(parent string, vmwareenginenetwork *VmwareEngineNetwork) *ProjectsLocationsVmwareEngineNetworksCreateCall {
	c := &ProjectsLocationsVmwareEngineNetworksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.vmwareenginenetwork = vmwareenginenetwork
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) RequestId(requestId string) *ProjectsLocationsVmwareEngineNetworksCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// VmwareEngineNetworkId sets the optional parameter
// "vmwareEngineNetworkId": Required. The user-provided identifier of
// the new VMware Engine network. This identifier must be unique among
// VMware Engine network resources within the parent and becomes the
// final token in the name URI. The identifier must meet the following
// requirements: * For networks of type LEGACY, adheres to the format:
// `{region-id}-default`. Replace `{region-id}` with the region where
// you want to create the VMware Engine network. For example,
// "us-central1-default". * Only contains 1-63 alphanumeric characters
// and hyphens * Begins with an alphabetical character * Ends with a
// non-hyphen character * Not formatted as a UUID * Complies with RFC
// 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) VmwareEngineNetworkId(vmwareEngineNetworkId string) *ProjectsLocationsVmwareEngineNetworksCreateCall {
	c.urlParams_.Set("vmwareEngineNetworkId", vmwareEngineNetworkId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareEngineNetworksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) Context(ctx context.Context) *ProjectsLocationsVmwareEngineNetworksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwareenginenetwork)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareEngineNetworks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.vmwareEngineNetworks.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareEngineNetworksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new VMware Engine network that can be used by a private cloud.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareEngineNetworks",
	//   "httpMethod": "POST",
	//   "id": "vmwareengine.projects.locations.vmwareEngineNetworks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the location to create the new VMware Engine network in. A VMware Engine network of type `LEGACY` is a regional resource, and a VMware Engine network of type `STANDARD` is a global resource. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "vmwareEngineNetworkId": {
	//       "description": "Required. The user-provided identifier of the new VMware Engine network. This identifier must be unique among VMware Engine network resources within the parent and becomes the final token in the name URI. The identifier must meet the following requirements: * For networks of type LEGACY, adheres to the format: `{region-id}-default`. Replace `{region-id}` with the region where you want to create the VMware Engine network. For example, \"us-central1-default\". * Only contains 1-63 alphanumeric characters and hyphens * Begins with an alphabetical character * Ends with a non-hyphen character * Not formatted as a UUID * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareEngineNetworks",
	//   "request": {
	//     "$ref": "VmwareEngineNetwork"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.vmwareEngineNetworks.delete":

type ProjectsLocationsVmwareEngineNetworksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `VmwareEngineNetwork` resource. You can only delete
// a VMware Engine network after all resources that refer to it are
// deleted. For example, a private cloud, a network peering, and a
// network policy can all refer to the same VMware Engine network.
//
//   - name: The resource name of the VMware Engine network to be deleted.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/vmwareEngineNetworks/my-networ
//     k`.
func (r *ProjectsLocationsVmwareEngineNetworksService) Delete(name string) *ProjectsLocationsVmwareEngineNetworksDeleteCall {
	c := &ProjectsLocationsVmwareEngineNetworksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": Checksum used to ensure that
// the user-provided value is up to date before the server processes the
// request. The server compares provided checksum with the current
// checksum of the resource. If the user-provided value is out of date,
// this request returns an `ABORTED` error.
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) Etag(etag string) *ProjectsLocationsVmwareEngineNetworksDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) RequestId(requestId string) *ProjectsLocationsVmwareEngineNetworksDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareEngineNetworksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) Context(ctx context.Context) *ProjectsLocationsVmwareEngineNetworksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.vmwareEngineNetworks.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareEngineNetworksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware Engine network after all resources that refer to it are deleted. For example, a private cloud, a network peering, and a network policy can all refer to the same VMware Engine network.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareEngineNetworks/{vmwareEngineNetworksId}",
	//   "httpMethod": "DELETE",
	//   "id": "vmwareengine.projects.locations.vmwareEngineNetworks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. Checksum used to ensure that the user-provided value is up to date before the server processes the request. The server compares provided checksum with the current checksum of the resource. If the user-provided value is out of date, this request returns an `ABORTED` error.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the VMware Engine network to be deleted. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/vmwareEngineNetworks/my-network`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareEngineNetworks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.vmwareEngineNetworks.get":

type ProjectsLocationsVmwareEngineNetworksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `VmwareEngineNetwork` resource by its resource name.
// The resource contains details of the VMware Engine network, such as
// its VMware Engine network type, peered networks in a service project,
// and state (for example, `CREATING`, `ACTIVE`, `DELETING`).
//
//   - name: The resource name of the VMware Engine network to retrieve.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/vmwareEngineNetworks/my-networ
//     k`.
func (r *ProjectsLocationsVmwareEngineNetworksService) Get(name string) *ProjectsLocationsVmwareEngineNetworksGetCall {
	c := &ProjectsLocationsVmwareEngineNetworksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareEngineNetworksGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareEngineNetworksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareEngineNetworksGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareEngineNetworksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareEngineNetworksGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareEngineNetworksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareEngineNetworksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareEngineNetworksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.vmwareEngineNetworks.get" call.
// Exactly one of *VmwareEngineNetwork or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *VmwareEngineNetwork.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareEngineNetworksGetCall) Do(opts ...googleapi.CallOption) (*VmwareEngineNetwork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VmwareEngineNetwork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `VmwareEngineNetwork` resource by its resource name. The resource contains details of the VMware Engine network, such as its VMware Engine network type, peered networks in a service project, and state (for example, `CREATING`, `ACTIVE`, `DELETING`).",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareEngineNetworks/{vmwareEngineNetworksId}",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.vmwareEngineNetworks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the VMware Engine network to retrieve. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/vmwareEngineNetworks/my-network`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareEngineNetworks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "VmwareEngineNetwork"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "vmwareengine.projects.locations.vmwareEngineNetworks.list":

type ProjectsLocationsVmwareEngineNetworksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `VmwareEngineNetwork` resources in a given project and
// location.
//
//   - parent: The resource name of the location to query for VMware
//     Engine networks. Resource names are schemeless URIs that follow the
//     conventions in https://cloud.google.com/apis/design/resource_names.
//     For example: `projects/my-project/locations/global`.
func (r *ProjectsLocationsVmwareEngineNetworksService) List(parent string) *ProjectsLocationsVmwareEngineNetworksListCall {
	c := &ProjectsLocationsVmwareEngineNetworksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// matches resources returned in the response. The expression must
// specify the field name, a comparison operator, and the value that you
// want to use for filtering. The value must be a string, a number, or a
// boolean. The comparison operator must be `=`, `!=`, `>`, or `<`. For
// example, if you are filtering a list of network peerings, you can
// exclude the ones named `example-network` by specifying `name !=
// "example-network". To filter on multiple expressions, provide each
// separate expression within parentheses. For example: ``` (name =
// "example-network") (createTime > "2021-04-12T08:15:10.40Z") ``` By
// default, each expression is an `AND` expression. However, you can
// include `AND` and `OR` expressions explicitly. For example: ``` (name
// = "example-network-1") AND (createTime > "2021-04-12T08:15:10.40Z")
// OR (name = "example-network-2") ```
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Filter(filter string) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by
// a certain order. By default, returned results are ordered by `name`
// in ascending order. You can also sort results in descending order
// based on the `name` value using `orderBy="name desc". Currently,
// only ordering by `name` is supported.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) OrderBy(orderBy string) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return in one page. The maximum value is coerced to
// 1000. The default value of this field is 500.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListVmwareEngineNetworks` call. Provide
// this to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListVmwareEngineNetworks` must match the call
// that provided the page token.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) PageToken(pageToken string) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Context(ctx context.Context) *ProjectsLocationsVmwareEngineNetworksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareEngineNetworksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareEngineNetworks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.vmwareEngineNetworks.list" call.
// Exactly one of *ListVmwareEngineNetworksResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListVmwareEngineNetworksResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Do(opts ...googleapi.CallOption) (*ListVmwareEngineNetworksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVmwareEngineNetworksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists `VmwareEngineNetwork` resources in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareEngineNetworks",
	//   "httpMethod": "GET",
	//   "id": "vmwareengine.projects.locations.vmwareEngineNetworks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter expression that matches resources returned in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be `=`, `!=`, `\u003e`, or `\u003c`. For example, if you are filtering a list of network peerings, you can exclude the ones named `example-network` by specifying `name != \"example-network\"`. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (name = \"example-network\") (createTime \u003e \"2021-04-12T08:15:10.40Z\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (name = \"example-network-1\") AND (createTime \u003e \"2021-04-12T08:15:10.40Z\") OR (name = \"example-network-2\") ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Sorts list results by a certain order. By default, returned results are ordered by `name` in ascending order. You can also sort results in descending order based on the `name` value using `orderBy=\"name desc\"`. Currently, only ordering by `name` is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return in one page. The maximum value is coerced to 1000. The default value of this field is 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListVmwareEngineNetworks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListVmwareEngineNetworks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the location to query for VMware Engine networks. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareEngineNetworks",
	//   "response": {
	//     "$ref": "ListVmwareEngineNetworksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareEngineNetworksListCall) Pages(ctx context.Context, f func(*ListVmwareEngineNetworksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vmwareengine.projects.locations.vmwareEngineNetworks.patch":

type ProjectsLocationsVmwareEngineNetworksPatchCall struct {
	s                   *Service
	name                string
	vmwareenginenetwork *VmwareEngineNetwork
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Modifies a VMware Engine network resource. Only the following
// fields can be updated: `description`. Only fields specified in
// `updateMask` are applied.
//
//   - name: Output only. The resource name of the VMware Engine network.
//     Resource names are schemeless URIs that follow the conventions in
//     https://cloud.google.com/apis/design/resource_names. For example:
//     `projects/my-project/locations/global/vmwareEngineNetworks/my-networ
//     k`.
func (r *ProjectsLocationsVmwareEngineNetworksService) Patch(name string, vmwareenginenetwork *VmwareEngineNetwork) *ProjectsLocationsVmwareEngineNetworksPatchCall {
	c := &ProjectsLocationsVmwareEngineNetworksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.vmwareenginenetwork = vmwareenginenetwork
	return c
}

// RequestId sets the optional parameter "requestId": A request ID to
// identify requests. Specify a unique request ID so that if you must
// retry your request, the server will know to ignore the request if it
// has already been completed. The server guarantees that a request
// doesn't result in creation of duplicate commitments for at least 60
// minutes. For example, consider a situation where you make an initial
// request and the request times out. If you make the request again with
// the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second
// request. This prevents clients from accidentally creating duplicate
// commitments. The request ID must be a valid UUID with the exception
// that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) RequestId(requestId string) *ProjectsLocationsVmwareEngineNetworksPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the VMware
// Engine network resource by the update. The fields specified in the
// `update_mask` are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all fields will be overwritten. Only the
// following fields can be updated: `description`.
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVmwareEngineNetworksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareEngineNetworksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) Context(ctx context.Context) *ProjectsLocationsVmwareEngineNetworksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwareenginenetwork)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vmwareengine.projects.locations.vmwareEngineNetworks.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareEngineNetworksPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies a VMware Engine network resource. Only the following fields can be updated: `description`. Only fields specified in `updateMask` are applied.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareEngineNetworks/{vmwareEngineNetworksId}",
	//   "httpMethod": "PATCH",
	//   "id": "vmwareengine.projects.locations.vmwareEngineNetworks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of the VMware Engine network. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. For example: `projects/my-project/locations/global/vmwareEngineNetworks/my-network`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareEngineNetworks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "requestId": {
	//       "description": "Optional. A request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server guarantees that a request doesn't result in creation of duplicate commitments for at least 60 minutes. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the VMware Engine network resource by the update. The fields specified in the `update_mask` are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all fields will be overwritten. Only the following fields can be updated: `description`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "VmwareEngineNetwork"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
