// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package datalabelingpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies where the annotation comes from (whether it was provided by a
// human labeler or a different source).
type AnnotationSource int32

const (
	AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED AnnotationSource = 0
	// Answer is provided by a human contributor.
	AnnotationSource_OPERATOR AnnotationSource = 3
)

// Enum value maps for AnnotationSource.
var (
	AnnotationSource_name = map[int32]string{
		0: "ANNOTATION_SOURCE_UNSPECIFIED",
		3: "OPERATOR",
	}
	AnnotationSource_value = map[string]int32{
		"ANNOTATION_SOURCE_UNSPECIFIED": 0,
		"OPERATOR":                      3,
	}
)

func (x AnnotationSource) Enum() *AnnotationSource {
	p := new(AnnotationSource)
	*p = x
	return p
}

func (x AnnotationSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotationSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[0].Descriptor()
}

func (AnnotationSource) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[0]
}

func (x AnnotationSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotationSource.Descriptor instead.
func (AnnotationSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{0}
}

type AnnotationSentiment int32

const (
	AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED AnnotationSentiment = 0
	// This annotation describes negatively about the data.
	AnnotationSentiment_NEGATIVE AnnotationSentiment = 1
	// This label describes positively about the data.
	AnnotationSentiment_POSITIVE AnnotationSentiment = 2
)

// Enum value maps for AnnotationSentiment.
var (
	AnnotationSentiment_name = map[int32]string{
		0: "ANNOTATION_SENTIMENT_UNSPECIFIED",
		1: "NEGATIVE",
		2: "POSITIVE",
	}
	AnnotationSentiment_value = map[string]int32{
		"ANNOTATION_SENTIMENT_UNSPECIFIED": 0,
		"NEGATIVE":                         1,
		"POSITIVE":                         2,
	}
)

func (x AnnotationSentiment) Enum() *AnnotationSentiment {
	p := new(AnnotationSentiment)
	*p = x
	return p
}

func (x AnnotationSentiment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotationSentiment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[1].Descriptor()
}

func (AnnotationSentiment) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[1]
}

func (x AnnotationSentiment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotationSentiment.Descriptor instead.
func (AnnotationSentiment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{1}
}

type AnnotationType int32

const (
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED AnnotationType = 0
	// Classification annotations in an image. Allowed for continuous evaluation.
	AnnotationType_IMAGE_CLASSIFICATION_ANNOTATION AnnotationType = 1
	// Bounding box annotations in an image. A form of image object detection.
	// Allowed for continuous evaluation.
	AnnotationType_IMAGE_BOUNDING_BOX_ANNOTATION AnnotationType = 2
	// Oriented bounding box. The box does not have to be parallel to horizontal
	// line.
	AnnotationType_IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION AnnotationType = 13
	// Bounding poly annotations in an image.
	AnnotationType_IMAGE_BOUNDING_POLY_ANNOTATION AnnotationType = 10
	// Polyline annotations in an image.
	AnnotationType_IMAGE_POLYLINE_ANNOTATION AnnotationType = 11
	// Segmentation annotations in an image.
	AnnotationType_IMAGE_SEGMENTATION_ANNOTATION AnnotationType = 12
	// Classification annotations in video shots.
	AnnotationType_VIDEO_SHOTS_CLASSIFICATION_ANNOTATION AnnotationType = 3
	// Video object tracking annotation.
	AnnotationType_VIDEO_OBJECT_TRACKING_ANNOTATION AnnotationType = 4
	// Video object detection annotation.
	AnnotationType_VIDEO_OBJECT_DETECTION_ANNOTATION AnnotationType = 5
	// Video event annotation.
	AnnotationType_VIDEO_EVENT_ANNOTATION AnnotationType = 6
	// Classification for text. Allowed for continuous evaluation.
	AnnotationType_TEXT_CLASSIFICATION_ANNOTATION AnnotationType = 8
	// Entity extraction for text.
	AnnotationType_TEXT_ENTITY_EXTRACTION_ANNOTATION AnnotationType = 9
	// General classification. Allowed for continuous evaluation.
	AnnotationType_GENERAL_CLASSIFICATION_ANNOTATION AnnotationType = 14
)

// Enum value maps for AnnotationType.
var (
	AnnotationType_name = map[int32]string{
		0:  "ANNOTATION_TYPE_UNSPECIFIED",
		1:  "IMAGE_CLASSIFICATION_ANNOTATION",
		2:  "IMAGE_BOUNDING_BOX_ANNOTATION",
		13: "IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION",
		10: "IMAGE_BOUNDING_POLY_ANNOTATION",
		11: "IMAGE_POLYLINE_ANNOTATION",
		12: "IMAGE_SEGMENTATION_ANNOTATION",
		3:  "VIDEO_SHOTS_CLASSIFICATION_ANNOTATION",
		4:  "VIDEO_OBJECT_TRACKING_ANNOTATION",
		5:  "VIDEO_OBJECT_DETECTION_ANNOTATION",
		6:  "VIDEO_EVENT_ANNOTATION",
		8:  "TEXT_CLASSIFICATION_ANNOTATION",
		9:  "TEXT_ENTITY_EXTRACTION_ANNOTATION",
		14: "GENERAL_CLASSIFICATION_ANNOTATION",
	}
	AnnotationType_value = map[string]int32{
		"ANNOTATION_TYPE_UNSPECIFIED":            0,
		"IMAGE_CLASSIFICATION_ANNOTATION":        1,
		"IMAGE_BOUNDING_BOX_ANNOTATION":          2,
		"IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION": 13,
		"IMAGE_BOUNDING_POLY_ANNOTATION":         10,
		"IMAGE_POLYLINE_ANNOTATION":              11,
		"IMAGE_SEGMENTATION_ANNOTATION":          12,
		"VIDEO_SHOTS_CLASSIFICATION_ANNOTATION":  3,
		"VIDEO_OBJECT_TRACKING_ANNOTATION":       4,
		"VIDEO_OBJECT_DETECTION_ANNOTATION":      5,
		"VIDEO_EVENT_ANNOTATION":                 6,
		"TEXT_CLASSIFICATION_ANNOTATION":         8,
		"TEXT_ENTITY_EXTRACTION_ANNOTATION":      9,
		"GENERAL_CLASSIFICATION_ANNOTATION":      14,
	}
)

func (x AnnotationType) Enum() *AnnotationType {
	p := new(AnnotationType)
	*p = x
	return p
}

func (x AnnotationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[2].Descriptor()
}

func (AnnotationType) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes[2]
}

func (x AnnotationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotationType.Descriptor instead.
func (AnnotationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{2}
}

// Annotation for Example. Each example may have one or more annotations. For
// example in image classification problem, each image might have one or more
// labels. We call labels binded with this image an Annotation.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique name of this annotation, format is:
	//
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The source of the annotation.
	AnnotationSource AnnotationSource `protobuf:"varint,2,opt,name=annotation_source,json=annotationSource,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSource" json:"annotation_source,omitempty"`
	// Output only. This is the actual annotation value, e.g classification,
	// bounding box values are stored here.
	AnnotationValue *AnnotationValue `protobuf:"bytes,3,opt,name=annotation_value,json=annotationValue,proto3" json:"annotation_value,omitempty"`
	// Output only. Annotation metadata, including information like votes
	// for labels.
	AnnotationMetadata *AnnotationMetadata `protobuf:"bytes,4,opt,name=annotation_metadata,json=annotationMetadata,proto3" json:"annotation_metadata,omitempty"`
	// Output only. Sentiment for this annotation.
	AnnotationSentiment AnnotationSentiment `protobuf:"varint,6,opt,name=annotation_sentiment,json=annotationSentiment,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSentiment" json:"annotation_sentiment,omitempty"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{0}
}

func (x *Annotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Annotation) GetAnnotationSource() AnnotationSource {
	if x != nil {
		return x.AnnotationSource
	}
	return AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
}

func (x *Annotation) GetAnnotationValue() *AnnotationValue {
	if x != nil {
		return x.AnnotationValue
	}
	return nil
}

func (x *Annotation) GetAnnotationMetadata() *AnnotationMetadata {
	if x != nil {
		return x.AnnotationMetadata
	}
	return nil
}

func (x *Annotation) GetAnnotationSentiment() AnnotationSentiment {
	if x != nil {
		return x.AnnotationSentiment
	}
	return AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED
}

// Annotation value for an example.
type AnnotationValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ValueType:
	//
	//	*AnnotationValue_ImageClassificationAnnotation
	//	*AnnotationValue_ImageBoundingPolyAnnotation
	//	*AnnotationValue_ImagePolylineAnnotation
	//	*AnnotationValue_ImageSegmentationAnnotation
	//	*AnnotationValue_TextClassificationAnnotation
	//	*AnnotationValue_TextEntityExtractionAnnotation
	//	*AnnotationValue_VideoClassificationAnnotation
	//	*AnnotationValue_VideoObjectTrackingAnnotation
	//	*AnnotationValue_VideoEventAnnotation
	ValueType isAnnotationValue_ValueType `protobuf_oneof:"value_type"`
}

func (x *AnnotationValue) Reset() {
	*x = AnnotationValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationValue) ProtoMessage() {}

func (x *AnnotationValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationValue.ProtoReflect.Descriptor instead.
func (*AnnotationValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{1}
}

func (m *AnnotationValue) GetValueType() isAnnotationValue_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (x *AnnotationValue) GetImageClassificationAnnotation() *ImageClassificationAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_ImageClassificationAnnotation); ok {
		return x.ImageClassificationAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetImageBoundingPolyAnnotation() *ImageBoundingPolyAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_ImageBoundingPolyAnnotation); ok {
		return x.ImageBoundingPolyAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetImagePolylineAnnotation() *ImagePolylineAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_ImagePolylineAnnotation); ok {
		return x.ImagePolylineAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetImageSegmentationAnnotation() *ImageSegmentationAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_ImageSegmentationAnnotation); ok {
		return x.ImageSegmentationAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetTextClassificationAnnotation() *TextClassificationAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_TextClassificationAnnotation); ok {
		return x.TextClassificationAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetTextEntityExtractionAnnotation() *TextEntityExtractionAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_TextEntityExtractionAnnotation); ok {
		return x.TextEntityExtractionAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetVideoClassificationAnnotation() *VideoClassificationAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_VideoClassificationAnnotation); ok {
		return x.VideoClassificationAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetVideoObjectTrackingAnnotation() *VideoObjectTrackingAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_VideoObjectTrackingAnnotation); ok {
		return x.VideoObjectTrackingAnnotation
	}
	return nil
}

func (x *AnnotationValue) GetVideoEventAnnotation() *VideoEventAnnotation {
	if x, ok := x.GetValueType().(*AnnotationValue_VideoEventAnnotation); ok {
		return x.VideoEventAnnotation
	}
	return nil
}

type isAnnotationValue_ValueType interface {
	isAnnotationValue_ValueType()
}

type AnnotationValue_ImageClassificationAnnotation struct {
	// Annotation value for image classification case.
	ImageClassificationAnnotation *ImageClassificationAnnotation `protobuf:"bytes,1,opt,name=image_classification_annotation,json=imageClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_ImageBoundingPolyAnnotation struct {
	// Annotation value for image bounding box, oriented bounding box
	// and polygon cases.
	ImageBoundingPolyAnnotation *ImageBoundingPolyAnnotation `protobuf:"bytes,2,opt,name=image_bounding_poly_annotation,json=imageBoundingPolyAnnotation,proto3,oneof"`
}

type AnnotationValue_ImagePolylineAnnotation struct {
	// Annotation value for image polyline cases.
	// Polyline here is different from BoundingPoly. It is formed by
	// line segments connected to each other but not closed form(Bounding Poly).
	// The line segments can cross each other.
	ImagePolylineAnnotation *ImagePolylineAnnotation `protobuf:"bytes,8,opt,name=image_polyline_annotation,json=imagePolylineAnnotation,proto3,oneof"`
}

type AnnotationValue_ImageSegmentationAnnotation struct {
	// Annotation value for image segmentation.
	ImageSegmentationAnnotation *ImageSegmentationAnnotation `protobuf:"bytes,9,opt,name=image_segmentation_annotation,json=imageSegmentationAnnotation,proto3,oneof"`
}

type AnnotationValue_TextClassificationAnnotation struct {
	// Annotation value for text classification case.
	TextClassificationAnnotation *TextClassificationAnnotation `protobuf:"bytes,3,opt,name=text_classification_annotation,json=textClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_TextEntityExtractionAnnotation struct {
	// Annotation value for text entity extraction case.
	TextEntityExtractionAnnotation *TextEntityExtractionAnnotation `protobuf:"bytes,10,opt,name=text_entity_extraction_annotation,json=textEntityExtractionAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoClassificationAnnotation struct {
	// Annotation value for video classification case.
	VideoClassificationAnnotation *VideoClassificationAnnotation `protobuf:"bytes,4,opt,name=video_classification_annotation,json=videoClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoObjectTrackingAnnotation struct {
	// Annotation value for video object detection and tracking case.
	VideoObjectTrackingAnnotation *VideoObjectTrackingAnnotation `protobuf:"bytes,5,opt,name=video_object_tracking_annotation,json=videoObjectTrackingAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoEventAnnotation struct {
	// Annotation value for video event case.
	VideoEventAnnotation *VideoEventAnnotation `protobuf:"bytes,6,opt,name=video_event_annotation,json=videoEventAnnotation,proto3,oneof"`
}

func (*AnnotationValue_ImageClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImageBoundingPolyAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImagePolylineAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImageSegmentationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_TextClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_TextEntityExtractionAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoObjectTrackingAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoEventAnnotation) isAnnotationValue_ValueType() {}

// Image classification annotation definition.
type ImageClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label of image.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *ImageClassificationAnnotation) Reset() {
	*x = ImageClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageClassificationAnnotation) ProtoMessage() {}

func (x *ImageClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*ImageClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{2}
}

func (x *ImageClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

// A vertex represents a 2D point in the image.
// NOTE: the vertex coordinates are in the same scale as the original image.
type Vertex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// X coordinate.
	X int32 `protobuf:"varint,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y int32 `protobuf:"varint,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *Vertex) Reset() {
	*x = Vertex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vertex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vertex) ProtoMessage() {}

func (x *Vertex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vertex.ProtoReflect.Descriptor instead.
func (*Vertex) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{3}
}

func (x *Vertex) GetX() int32 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *Vertex) GetY() int32 {
	if x != nil {
		return x.Y
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y float32 `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *NormalizedVertex) Reset() {
	*x = NormalizedVertex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedVertex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedVertex) ProtoMessage() {}

func (x *NormalizedVertex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedVertex.ProtoReflect.Descriptor instead.
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{4}
}

func (x *NormalizedVertex) GetX() float32 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *NormalizedVertex) GetY() float32 {
	if x != nil {
		return x.Y
	}
	return 0
}

// A bounding polygon in the image.
type BoundingPoly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon vertices.
	Vertices []*Vertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
}

func (x *BoundingPoly) Reset() {
	*x = BoundingPoly{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingPoly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingPoly) ProtoMessage() {}

func (x *BoundingPoly) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingPoly.ProtoReflect.Descriptor instead.
func (*BoundingPoly) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{5}
}

func (x *BoundingPoly) GetVertices() []*Vertex {
	if x != nil {
		return x.Vertices
	}
	return nil
}

// Normalized bounding polygon.
type NormalizedBoundingPoly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon normalized vertices.
	NormalizedVertices []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
}

func (x *NormalizedBoundingPoly) Reset() {
	*x = NormalizedBoundingPoly{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedBoundingPoly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedBoundingPoly) ProtoMessage() {}

func (x *NormalizedBoundingPoly) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedBoundingPoly.ProtoReflect.Descriptor instead.
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{6}
}

func (x *NormalizedBoundingPoly) GetNormalizedVertices() []*NormalizedVertex {
	if x != nil {
		return x.NormalizedVertices
	}
	return nil
}

// Image bounding poly annotation. It represents a polygon including
// bounding box in the image.
type ImageBoundingPolyAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The region of the polygon. If it is a bounding box, it is guaranteed to be
	// four points.
	//
	// Types that are assignable to BoundedArea:
	//
	//	*ImageBoundingPolyAnnotation_BoundingPoly
	//	*ImageBoundingPolyAnnotation_NormalizedBoundingPoly
	BoundedArea isImageBoundingPolyAnnotation_BoundedArea `protobuf_oneof:"bounded_area"`
	// Label of object in this bounding polygon.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *ImageBoundingPolyAnnotation) Reset() {
	*x = ImageBoundingPolyAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageBoundingPolyAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageBoundingPolyAnnotation) ProtoMessage() {}

func (x *ImageBoundingPolyAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageBoundingPolyAnnotation.ProtoReflect.Descriptor instead.
func (*ImageBoundingPolyAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{7}
}

func (m *ImageBoundingPolyAnnotation) GetBoundedArea() isImageBoundingPolyAnnotation_BoundedArea {
	if m != nil {
		return m.BoundedArea
	}
	return nil
}

func (x *ImageBoundingPolyAnnotation) GetBoundingPoly() *BoundingPoly {
	if x, ok := x.GetBoundedArea().(*ImageBoundingPolyAnnotation_BoundingPoly); ok {
		return x.BoundingPoly
	}
	return nil
}

func (x *ImageBoundingPolyAnnotation) GetNormalizedBoundingPoly() *NormalizedBoundingPoly {
	if x, ok := x.GetBoundedArea().(*ImageBoundingPolyAnnotation_NormalizedBoundingPoly); ok {
		return x.NormalizedBoundingPoly
	}
	return nil
}

func (x *ImageBoundingPolyAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

type isImageBoundingPolyAnnotation_BoundedArea interface {
	isImageBoundingPolyAnnotation_BoundedArea()
}

type ImageBoundingPolyAnnotation_BoundingPoly struct {
	BoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=bounding_poly,json=boundingPoly,proto3,oneof"`
}

type ImageBoundingPolyAnnotation_NormalizedBoundingPoly struct {
	NormalizedBoundingPoly *NormalizedBoundingPoly `protobuf:"bytes,3,opt,name=normalized_bounding_poly,json=normalizedBoundingPoly,proto3,oneof"`
}

func (*ImageBoundingPolyAnnotation_BoundingPoly) isImageBoundingPolyAnnotation_BoundedArea() {}

func (*ImageBoundingPolyAnnotation_NormalizedBoundingPoly) isImageBoundingPolyAnnotation_BoundedArea() {
}

// A line with multiple line segments.
type Polyline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The polyline vertices.
	Vertices []*Vertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
}

func (x *Polyline) Reset() {
	*x = Polyline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Polyline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Polyline) ProtoMessage() {}

func (x *Polyline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Polyline.ProtoReflect.Descriptor instead.
func (*Polyline) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{8}
}

func (x *Polyline) GetVertices() []*Vertex {
	if x != nil {
		return x.Vertices
	}
	return nil
}

// Normalized polyline.
type NormalizedPolyline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The normalized polyline vertices.
	NormalizedVertices []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
}

func (x *NormalizedPolyline) Reset() {
	*x = NormalizedPolyline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedPolyline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedPolyline) ProtoMessage() {}

func (x *NormalizedPolyline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedPolyline.ProtoReflect.Descriptor instead.
func (*NormalizedPolyline) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{9}
}

func (x *NormalizedPolyline) GetNormalizedVertices() []*NormalizedVertex {
	if x != nil {
		return x.NormalizedVertices
	}
	return nil
}

// A polyline for the image annotation.
type ImagePolylineAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Poly:
	//
	//	*ImagePolylineAnnotation_Polyline
	//	*ImagePolylineAnnotation_NormalizedPolyline
	Poly isImagePolylineAnnotation_Poly `protobuf_oneof:"poly"`
	// Label of this polyline.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *ImagePolylineAnnotation) Reset() {
	*x = ImagePolylineAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImagePolylineAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImagePolylineAnnotation) ProtoMessage() {}

func (x *ImagePolylineAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImagePolylineAnnotation.ProtoReflect.Descriptor instead.
func (*ImagePolylineAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{10}
}

func (m *ImagePolylineAnnotation) GetPoly() isImagePolylineAnnotation_Poly {
	if m != nil {
		return m.Poly
	}
	return nil
}

func (x *ImagePolylineAnnotation) GetPolyline() *Polyline {
	if x, ok := x.GetPoly().(*ImagePolylineAnnotation_Polyline); ok {
		return x.Polyline
	}
	return nil
}

func (x *ImagePolylineAnnotation) GetNormalizedPolyline() *NormalizedPolyline {
	if x, ok := x.GetPoly().(*ImagePolylineAnnotation_NormalizedPolyline); ok {
		return x.NormalizedPolyline
	}
	return nil
}

func (x *ImagePolylineAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

type isImagePolylineAnnotation_Poly interface {
	isImagePolylineAnnotation_Poly()
}

type ImagePolylineAnnotation_Polyline struct {
	Polyline *Polyline `protobuf:"bytes,2,opt,name=polyline,proto3,oneof"`
}

type ImagePolylineAnnotation_NormalizedPolyline struct {
	NormalizedPolyline *NormalizedPolyline `protobuf:"bytes,3,opt,name=normalized_polyline,json=normalizedPolyline,proto3,oneof"`
}

func (*ImagePolylineAnnotation_Polyline) isImagePolylineAnnotation_Poly() {}

func (*ImagePolylineAnnotation_NormalizedPolyline) isImagePolylineAnnotation_Poly() {}

// Image segmentation annotation.
type ImageSegmentationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mapping between rgb color and annotation spec. The key is the rgb
	// color represented in format of rgb(0, 0, 0). The value is the
	// AnnotationSpec.
	AnnotationColors map[string]*AnnotationSpec `protobuf:"bytes,1,rep,name=annotation_colors,json=annotationColors,proto3" json:"annotation_colors,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Image format.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// A byte string of a full image's color map.
	ImageBytes []byte `protobuf:"bytes,3,opt,name=image_bytes,json=imageBytes,proto3" json:"image_bytes,omitempty"`
}

func (x *ImageSegmentationAnnotation) Reset() {
	*x = ImageSegmentationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationAnnotation) ProtoMessage() {}

func (x *ImageSegmentationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationAnnotation.ProtoReflect.Descriptor instead.
func (*ImageSegmentationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{11}
}

func (x *ImageSegmentationAnnotation) GetAnnotationColors() map[string]*AnnotationSpec {
	if x != nil {
		return x.AnnotationColors
	}
	return nil
}

func (x *ImageSegmentationAnnotation) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *ImageSegmentationAnnotation) GetImageBytes() []byte {
	if x != nil {
		return x.ImageBytes
	}
	return nil
}

// Text classification annotation.
type TextClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label of the text.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *TextClassificationAnnotation) Reset() {
	*x = TextClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextClassificationAnnotation) ProtoMessage() {}

func (x *TextClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*TextClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{12}
}

func (x *TextClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

// Text entity extraction annotation.
type TextEntityExtractionAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label of the text entities.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// Position of the entity.
	SequentialSegment *SequentialSegment `protobuf:"bytes,2,opt,name=sequential_segment,json=sequentialSegment,proto3" json:"sequential_segment,omitempty"`
}

func (x *TextEntityExtractionAnnotation) Reset() {
	*x = TextEntityExtractionAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextEntityExtractionAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextEntityExtractionAnnotation) ProtoMessage() {}

func (x *TextEntityExtractionAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextEntityExtractionAnnotation.ProtoReflect.Descriptor instead.
func (*TextEntityExtractionAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{13}
}

func (x *TextEntityExtractionAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *TextEntityExtractionAnnotation) GetSequentialSegment() *SequentialSegment {
	if x != nil {
		return x.SequentialSegment
	}
	return nil
}

// Start and end position in a sequence (e.g. text segment).
type SequentialSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start position (inclusive).
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// End position (exclusive).
	End int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *SequentialSegment) Reset() {
	*x = SequentialSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequentialSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequentialSegment) ProtoMessage() {}

func (x *SequentialSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequentialSegment.ProtoReflect.Descriptor instead.
func (*SequentialSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{14}
}

func (x *SequentialSegment) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *SequentialSegment) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

// A time period inside of an example that has a time dimension (e.g. video).
type TimeSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the time segment (inclusive), represented as the duration since
	// the example start.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End of the time segment (exclusive), represented as the duration since the
	// example start.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *TimeSegment) Reset() {
	*x = TimeSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSegment) ProtoMessage() {}

func (x *TimeSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSegment.ProtoReflect.Descriptor instead.
func (*TimeSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{15}
}

func (x *TimeSegment) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *TimeSegment) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// Video classification annotation.
type VideoClassificationAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time segment of the video to which the annotation applies.
	TimeSegment *TimeSegment `protobuf:"bytes,1,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// Label of the segment specified by time_segment.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,2,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *VideoClassificationAnnotation) Reset() {
	*x = VideoClassificationAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationAnnotation) ProtoMessage() {}

func (x *VideoClassificationAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationAnnotation.ProtoReflect.Descriptor instead.
func (*VideoClassificationAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{16}
}

func (x *VideoClassificationAnnotation) GetTimeSegment() *TimeSegment {
	if x != nil {
		return x.TimeSegment
	}
	return nil
}

func (x *VideoClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

// Video frame level annotation for object detection and tracking.
type ObjectTrackingFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding box location of this object track for the frame.
	//
	// Types that are assignable to BoundedArea:
	//
	//	*ObjectTrackingFrame_BoundingPoly
	//	*ObjectTrackingFrame_NormalizedBoundingPoly
	BoundedArea isObjectTrackingFrame_BoundedArea `protobuf_oneof:"bounded_area"`
	// The time offset of this frame relative to the beginning of the video.
	TimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
}

func (x *ObjectTrackingFrame) Reset() {
	*x = ObjectTrackingFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectTrackingFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectTrackingFrame) ProtoMessage() {}

func (x *ObjectTrackingFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectTrackingFrame.ProtoReflect.Descriptor instead.
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{17}
}

func (m *ObjectTrackingFrame) GetBoundedArea() isObjectTrackingFrame_BoundedArea {
	if m != nil {
		return m.BoundedArea
	}
	return nil
}

func (x *ObjectTrackingFrame) GetBoundingPoly() *BoundingPoly {
	if x, ok := x.GetBoundedArea().(*ObjectTrackingFrame_BoundingPoly); ok {
		return x.BoundingPoly
	}
	return nil
}

func (x *ObjectTrackingFrame) GetNormalizedBoundingPoly() *NormalizedBoundingPoly {
	if x, ok := x.GetBoundedArea().(*ObjectTrackingFrame_NormalizedBoundingPoly); ok {
		return x.NormalizedBoundingPoly
	}
	return nil
}

func (x *ObjectTrackingFrame) GetTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

type isObjectTrackingFrame_BoundedArea interface {
	isObjectTrackingFrame_BoundedArea()
}

type ObjectTrackingFrame_BoundingPoly struct {
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3,oneof"`
}

type ObjectTrackingFrame_NormalizedBoundingPoly struct {
	NormalizedBoundingPoly *NormalizedBoundingPoly `protobuf:"bytes,2,opt,name=normalized_bounding_poly,json=normalizedBoundingPoly,proto3,oneof"`
}

func (*ObjectTrackingFrame_BoundingPoly) isObjectTrackingFrame_BoundedArea() {}

func (*ObjectTrackingFrame_NormalizedBoundingPoly) isObjectTrackingFrame_BoundedArea() {}

// Video object tracking annotation.
type VideoObjectTrackingAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label of the object tracked in this annotation.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// The time segment of the video to which object tracking applies.
	TimeSegment *TimeSegment `protobuf:"bytes,2,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// The list of frames where this object track appears.
	ObjectTrackingFrames []*ObjectTrackingFrame `protobuf:"bytes,3,rep,name=object_tracking_frames,json=objectTrackingFrames,proto3" json:"object_tracking_frames,omitempty"`
}

func (x *VideoObjectTrackingAnnotation) Reset() {
	*x = VideoObjectTrackingAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingAnnotation) ProtoMessage() {}

func (x *VideoObjectTrackingAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingAnnotation.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{18}
}

func (x *VideoObjectTrackingAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *VideoObjectTrackingAnnotation) GetTimeSegment() *TimeSegment {
	if x != nil {
		return x.TimeSegment
	}
	return nil
}

func (x *VideoObjectTrackingAnnotation) GetObjectTrackingFrames() []*ObjectTrackingFrame {
	if x != nil {
		return x.ObjectTrackingFrames
	}
	return nil
}

// Video event annotation.
type VideoEventAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label of the event in this annotation.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// The time segment of the video to which the annotation applies.
	TimeSegment *TimeSegment `protobuf:"bytes,2,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
}

func (x *VideoEventAnnotation) Reset() {
	*x = VideoEventAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoEventAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoEventAnnotation) ProtoMessage() {}

func (x *VideoEventAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoEventAnnotation.ProtoReflect.Descriptor instead.
func (*VideoEventAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{19}
}

func (x *VideoEventAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *VideoEventAnnotation) GetTimeSegment() *TimeSegment {
	if x != nil {
		return x.TimeSegment
	}
	return nil
}

// Additional information associated with the annotation.
type AnnotationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata related to human labeling.
	OperatorMetadata *OperatorMetadata `protobuf:"bytes,2,opt,name=operator_metadata,json=operatorMetadata,proto3" json:"operator_metadata,omitempty"`
}

func (x *AnnotationMetadata) Reset() {
	*x = AnnotationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationMetadata) ProtoMessage() {}

func (x *AnnotationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationMetadata.ProtoReflect.Descriptor instead.
func (*AnnotationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{20}
}

func (x *AnnotationMetadata) GetOperatorMetadata() *OperatorMetadata {
	if x != nil {
		return x.OperatorMetadata
	}
	return nil
}

// General information useful for labels coming from contributors.
type OperatorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Confidence score corresponding to a label. For examle, if 3 contributors
	// have answered the question and 2 of them agree on the final label, the
	// confidence score will be 0.67 (2/3).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// The total number of contributors that answer this question.
	TotalVotes int32 `protobuf:"varint,2,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// The total number of contributors that choose this label.
	LabelVotes int32 `protobuf:"varint,3,opt,name=label_votes,json=labelVotes,proto3" json:"label_votes,omitempty"`
	// Comments from contributors.
	Comments []string `protobuf:"bytes,4,rep,name=comments,proto3" json:"comments,omitempty"`
}

func (x *OperatorMetadata) Reset() {
	*x = OperatorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorMetadata) ProtoMessage() {}

func (x *OperatorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorMetadata.ProtoReflect.Descriptor instead.
func (*OperatorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP(), []int{21}
}

func (x *OperatorMetadata) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *OperatorMetadata) GetTotalVotes() int32 {
	if x != nil {
		return x.TotalVotes
	}
	return 0
}

func (x *OperatorMetadata) GetLabelVotes() int32 {
	if x != nil {
		return x.LabelVotes
	}
	return 0
}

func (x *OperatorMetadata) GetComments() []string {
	if x != nil {
		return x.Comments
	}
	return nil
}

var File_google_cloud_datalabeling_v1beta1_annotation_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb4, 0x03, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x10, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x69, 0x0a, 0x14, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xdc, 0x09, 0x0a, 0x0f,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x8a, 0x01, 0x0a, 0x1f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1d, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a,
	0x1e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x6f, 0x6c, 0x79, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x19, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x84,
	0x01, 0x0a, 0x1d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x87, 0x01, 0x0a, 0x1e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x1c, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x8e, 0x01, 0x0a, 0x21, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x1e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x8a, 0x01, 0x0a, 0x1f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1d,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8b, 0x01,
	0x0a, 0x20, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1d, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x16, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x7b, 0x0a, 0x1d, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x24, 0x0a, 0x06, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x01, 0x78, 0x12,
	0x0c, 0x0a, 0x01, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x01, 0x79, 0x22, 0x2e, 0x0a,
	0x10, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x78, 0x12,
	0x0c, 0x0a, 0x01, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x79, 0x22, 0x55, 0x0a,
	0x0c, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x45, 0x0a,
	0x08, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x08, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x63, 0x65, 0x73, 0x22, 0x7e, 0x0a, 0x16, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x64,
	0x0a, 0x13, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x52, 0x12, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74,
	0x69, 0x63, 0x65, 0x73, 0x22, 0xd8, 0x02, 0x0a, 0x1b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x0c,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x75, 0x0a, 0x18,
	0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x16, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x79, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42,
	0x0e, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x22,
	0x51, 0x0a, 0x08, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x08, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63,
	0x65, 0x73, 0x22, 0x7a, 0x0a, 0x12, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x6e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x12, 0x6e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x22, 0xb2,
	0x02, 0x0a, 0x17, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x08, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x08, 0x70, 0x6f, 0x6c,
	0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x12, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0x0a, 0x04, 0x70,
	0x6f, 0x6c, 0x79, 0x22, 0xd7, 0x02, 0x0a, 0x1b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x81, 0x01, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x76, 0x0a, 0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a, 0x0a,
	0x1c, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a,
	0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0xe1, 0x01, 0x0a, 0x1e, 0x54, 0x65,
	0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x63, 0x0a, 0x12, 0x73, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x73, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3b, 0x0a,
	0x11, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x0b, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x22, 0xce, 0x01, 0x0a, 0x1d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x74, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0xb0, 0x02, 0x0a, 0x13, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a,
	0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x75, 0x0a, 0x18, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x79, 0x48, 0x00, 0x52, 0x16, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x3a, 0x0a, 0x0b,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x22, 0xbc, 0x02, 0x0a, 0x1d, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x51, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x74, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x16, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x52, 0x14, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xc5, 0x01, 0x0a, 0x14, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x51, 0x0a, 0x0c,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x76, 0x0a, 0x12, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x60, 0x0a, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x86, 0x01, 0x0a, 0x10, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x76, 0x6f, 0x74, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x56, 0x6f,
	0x74, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x76, 0x6f, 0x74,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x56,
	0x6f, 0x74, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2a, 0x43, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x50, 0x45, 0x52, 0x41,
	0x54, 0x4f, 0x52, 0x10, 0x03, 0x2a, 0x57, 0x0a, 0x13, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20,
	0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x4e, 0x54, 0x49,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x45, 0x47, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x2a, 0x91,
	0x04, 0x0a, 0x0e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4d, 0x41, 0x47, 0x45,
	0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4f, 0x58, 0x5f, 0x41, 0x4e,
	0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x2a, 0x0a, 0x26, 0x49, 0x4d,
	0x41, 0x47, 0x45, 0x5f, 0x4f, 0x52, 0x49, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x4f, 0x55,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4f, 0x58, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x22, 0x0a, 0x1e, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f,
	0x42, 0x4f, 0x55, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x59, 0x5f, 0x41, 0x4e,
	0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4d,
	0x41, 0x47, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x59, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x41, 0x4e, 0x4e,
	0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4d, 0x41,
	0x47, 0x45, 0x5f, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x29, 0x0a, 0x25,
	0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x53, 0x48, 0x4f, 0x54, 0x53, 0x5f, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x24, 0x0a, 0x20, 0x56, 0x49, 0x44, 0x45, 0x4f,
	0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47,
	0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x25, 0x0a,
	0x21, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x44, 0x45,
	0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06,
	0x12, 0x22, 0x0a, 0x1e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46,
	0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x08, 0x12, 0x25, 0x0a, 0x21, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x45, 0x4e, 0x54,
	0x49, 0x54, 0x59, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41,
	0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x25, 0x0a, 0x21, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x41, 0x4c, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x0e, 0x42, 0xe3, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x49,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_datalabeling_v1beta1_annotation_proto_goTypes = []interface{}{
	(AnnotationSource)(0),                  // 0: google.cloud.datalabeling.v1beta1.AnnotationSource
	(AnnotationSentiment)(0),               // 1: google.cloud.datalabeling.v1beta1.AnnotationSentiment
	(AnnotationType)(0),                    // 2: google.cloud.datalabeling.v1beta1.AnnotationType
	(*Annotation)(nil),                     // 3: google.cloud.datalabeling.v1beta1.Annotation
	(*AnnotationValue)(nil),                // 4: google.cloud.datalabeling.v1beta1.AnnotationValue
	(*ImageClassificationAnnotation)(nil),  // 5: google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
	(*Vertex)(nil),                         // 6: google.cloud.datalabeling.v1beta1.Vertex
	(*NormalizedVertex)(nil),               // 7: google.cloud.datalabeling.v1beta1.NormalizedVertex
	(*BoundingPoly)(nil),                   // 8: google.cloud.datalabeling.v1beta1.BoundingPoly
	(*NormalizedBoundingPoly)(nil),         // 9: google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly
	(*ImageBoundingPolyAnnotation)(nil),    // 10: google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
	(*Polyline)(nil),                       // 11: google.cloud.datalabeling.v1beta1.Polyline
	(*NormalizedPolyline)(nil),             // 12: google.cloud.datalabeling.v1beta1.NormalizedPolyline
	(*ImagePolylineAnnotation)(nil),        // 13: google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation
	(*ImageSegmentationAnnotation)(nil),    // 14: google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
	(*TextClassificationAnnotation)(nil),   // 15: google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
	(*TextEntityExtractionAnnotation)(nil), // 16: google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
	(*SequentialSegment)(nil),              // 17: google.cloud.datalabeling.v1beta1.SequentialSegment
	(*TimeSegment)(nil),                    // 18: google.cloud.datalabeling.v1beta1.TimeSegment
	(*VideoClassificationAnnotation)(nil),  // 19: google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
	(*ObjectTrackingFrame)(nil),            // 20: google.cloud.datalabeling.v1beta1.ObjectTrackingFrame
	(*VideoObjectTrackingAnnotation)(nil),  // 21: google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
	(*VideoEventAnnotation)(nil),           // 22: google.cloud.datalabeling.v1beta1.VideoEventAnnotation
	(*AnnotationMetadata)(nil),             // 23: google.cloud.datalabeling.v1beta1.AnnotationMetadata
	(*OperatorMetadata)(nil),               // 24: google.cloud.datalabeling.v1beta1.OperatorMetadata
	nil,                                    // 25: google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.AnnotationColorsEntry
	(*AnnotationSpec)(nil),                 // 26: google.cloud.datalabeling.v1beta1.AnnotationSpec
	(*durationpb.Duration)(nil),            // 27: google.protobuf.Duration
}
var file_google_cloud_datalabeling_v1beta1_annotation_proto_depIdxs = []int32{
	0,  // 0: google.cloud.datalabeling.v1beta1.Annotation.annotation_source:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSource
	4,  // 1: google.cloud.datalabeling.v1beta1.Annotation.annotation_value:type_name -> google.cloud.datalabeling.v1beta1.AnnotationValue
	23, // 2: google.cloud.datalabeling.v1beta1.Annotation.annotation_metadata:type_name -> google.cloud.datalabeling.v1beta1.AnnotationMetadata
	1,  // 3: google.cloud.datalabeling.v1beta1.Annotation.annotation_sentiment:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSentiment
	5,  // 4: google.cloud.datalabeling.v1beta1.AnnotationValue.image_classification_annotation:type_name -> google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
	10, // 5: google.cloud.datalabeling.v1beta1.AnnotationValue.image_bounding_poly_annotation:type_name -> google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
	13, // 6: google.cloud.datalabeling.v1beta1.AnnotationValue.image_polyline_annotation:type_name -> google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation
	14, // 7: google.cloud.datalabeling.v1beta1.AnnotationValue.image_segmentation_annotation:type_name -> google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
	15, // 8: google.cloud.datalabeling.v1beta1.AnnotationValue.text_classification_annotation:type_name -> google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
	16, // 9: google.cloud.datalabeling.v1beta1.AnnotationValue.text_entity_extraction_annotation:type_name -> google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
	19, // 10: google.cloud.datalabeling.v1beta1.AnnotationValue.video_classification_annotation:type_name -> google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
	21, // 11: google.cloud.datalabeling.v1beta1.AnnotationValue.video_object_tracking_annotation:type_name -> google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
	22, // 12: google.cloud.datalabeling.v1beta1.AnnotationValue.video_event_annotation:type_name -> google.cloud.datalabeling.v1beta1.VideoEventAnnotation
	26, // 13: google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	6,  // 14: google.cloud.datalabeling.v1beta1.BoundingPoly.vertices:type_name -> google.cloud.datalabeling.v1beta1.Vertex
	7,  // 15: google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.normalized_vertices:type_name -> google.cloud.datalabeling.v1beta1.NormalizedVertex
	8,  // 16: google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.bounding_poly:type_name -> google.cloud.datalabeling.v1beta1.BoundingPoly
	9,  // 17: google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.normalized_bounding_poly:type_name -> google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly
	26, // 18: google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	6,  // 19: google.cloud.datalabeling.v1beta1.Polyline.vertices:type_name -> google.cloud.datalabeling.v1beta1.Vertex
	7,  // 20: google.cloud.datalabeling.v1beta1.NormalizedPolyline.normalized_vertices:type_name -> google.cloud.datalabeling.v1beta1.NormalizedVertex
	11, // 21: google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.polyline:type_name -> google.cloud.datalabeling.v1beta1.Polyline
	12, // 22: google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.normalized_polyline:type_name -> google.cloud.datalabeling.v1beta1.NormalizedPolyline
	26, // 23: google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	25, // 24: google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.annotation_colors:type_name -> google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.AnnotationColorsEntry
	26, // 25: google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	26, // 26: google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	17, // 27: google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.sequential_segment:type_name -> google.cloud.datalabeling.v1beta1.SequentialSegment
	27, // 28: google.cloud.datalabeling.v1beta1.TimeSegment.start_time_offset:type_name -> google.protobuf.Duration
	27, // 29: google.cloud.datalabeling.v1beta1.TimeSegment.end_time_offset:type_name -> google.protobuf.Duration
	18, // 30: google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.time_segment:type_name -> google.cloud.datalabeling.v1beta1.TimeSegment
	26, // 31: google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	8,  // 32: google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.bounding_poly:type_name -> google.cloud.datalabeling.v1beta1.BoundingPoly
	9,  // 33: google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.normalized_bounding_poly:type_name -> google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly
	27, // 34: google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.time_offset:type_name -> google.protobuf.Duration
	26, // 35: google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	18, // 36: google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.time_segment:type_name -> google.cloud.datalabeling.v1beta1.TimeSegment
	20, // 37: google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.object_tracking_frames:type_name -> google.cloud.datalabeling.v1beta1.ObjectTrackingFrame
	26, // 38: google.cloud.datalabeling.v1beta1.VideoEventAnnotation.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	18, // 39: google.cloud.datalabeling.v1beta1.VideoEventAnnotation.time_segment:type_name -> google.cloud.datalabeling.v1beta1.TimeSegment
	24, // 40: google.cloud.datalabeling.v1beta1.AnnotationMetadata.operator_metadata:type_name -> google.cloud.datalabeling.v1beta1.OperatorMetadata
	26, // 41: google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.AnnotationColorsEntry.value:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	42, // [42:42] is the sub-list for method output_type
	42, // [42:42] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_annotation_proto_init() }
func file_google_cloud_datalabeling_v1beta1_annotation_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_annotation_proto != nil {
		return
	}
	file_google_cloud_datalabeling_v1beta1_annotation_spec_set_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vertex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedVertex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundingPoly); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedBoundingPoly); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageBoundingPolyAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Polyline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedPolyline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImagePolylineAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextEntityExtractionAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequentialSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectTrackingFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoEventAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AnnotationValue_ImageClassificationAnnotation)(nil),
		(*AnnotationValue_ImageBoundingPolyAnnotation)(nil),
		(*AnnotationValue_ImagePolylineAnnotation)(nil),
		(*AnnotationValue_ImageSegmentationAnnotation)(nil),
		(*AnnotationValue_TextClassificationAnnotation)(nil),
		(*AnnotationValue_TextEntityExtractionAnnotation)(nil),
		(*AnnotationValue_VideoClassificationAnnotation)(nil),
		(*AnnotationValue_VideoObjectTrackingAnnotation)(nil),
		(*AnnotationValue_VideoEventAnnotation)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ImageBoundingPolyAnnotation_BoundingPoly)(nil),
		(*ImageBoundingPolyAnnotation_NormalizedBoundingPoly)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ImagePolylineAnnotation_Polyline)(nil),
		(*ImagePolylineAnnotation_NormalizedPolyline)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*ObjectTrackingFrame_BoundingPoly)(nil),
		(*ObjectTrackingFrame_NormalizedBoundingPoly)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_annotation_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_annotation_proto_depIdxs,
		EnumInfos:         file_google_cloud_datalabeling_v1beta1_annotation_proto_enumTypes,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_annotation_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_annotation_proto = out.File
	file_google_cloud_datalabeling_v1beta1_annotation_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_annotation_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_annotation_proto_depIdxs = nil
}
