// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/user_event_service.proto

package recommendationengine

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	_ "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for PurgeUserEvents method.
type PurgeUserEventsRequest struct {
	// Required. The resource name of the event_store under which the events are
	// created. The format is
	// "projects/${projectId}/locations/global/catalogs/${catalogId}/eventStores/${eventStoreId}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter string to specify the events to be deleted. Empty
	// string filter is not allowed. This filter can also be used with
	// ListUserEvents API to list events that will be deleted. The eligible fields
	// for filtering are:
	// * eventType - UserEvent.eventType field of type string.
	// * eventTime - in ISO 8601 "zulu" format.
	// * visitorId - field of type string. Specifying this will delete all events
	// associated with a visitor.
	// * userId - field of type string. Specifying this will delete all events
	// associated with a user.
	// Example 1: Deleting all events in a time range.
	// `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
	// "2012-04-23T18:30:43.511Z"`
	// Example 2: Deleting specific eventType in time range.
	// `eventTime > "2012-04-23T18:25:43.511Z" eventType = "detail-page-view"`
	// Example 3: Deleting all events for a specific visitor
	// `visitorId = visitor1024`
	// The filtering fields are assumed to have an implicit AND.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The default value is false. Override this flag to true to
	// actually perform the purge. If the field is not set to true, a sampling of
	// events to be deleted will be returned.
	Force                bool     `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PurgeUserEventsRequest) Reset()         { *m = PurgeUserEventsRequest{} }
func (m *PurgeUserEventsRequest) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsRequest) ProtoMessage()    {}
func (*PurgeUserEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{0}
}

func (m *PurgeUserEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsRequest.Unmarshal(m, b)
}
func (m *PurgeUserEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsRequest.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsRequest.Merge(m, src)
}
func (m *PurgeUserEventsRequest) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsRequest.Size(m)
}
func (m *PurgeUserEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsRequest proto.InternalMessageInfo

func (m *PurgeUserEventsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *PurgeUserEventsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *PurgeUserEventsRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Metadata related to the progress of the PurgeUserEvents operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type PurgeUserEventsMetadata struct {
	// The ID of the request / operation.
	OperationName string `protobuf:"bytes,1,opt,name=operation_name,json=operationName,proto3" json:"operation_name,omitempty"`
	// Operation create time.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PurgeUserEventsMetadata) Reset()         { *m = PurgeUserEventsMetadata{} }
func (m *PurgeUserEventsMetadata) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsMetadata) ProtoMessage()    {}
func (*PurgeUserEventsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{1}
}

func (m *PurgeUserEventsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsMetadata.Unmarshal(m, b)
}
func (m *PurgeUserEventsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsMetadata.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsMetadata.Merge(m, src)
}
func (m *PurgeUserEventsMetadata) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsMetadata.Size(m)
}
func (m *PurgeUserEventsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsMetadata proto.InternalMessageInfo

func (m *PurgeUserEventsMetadata) GetOperationName() string {
	if m != nil {
		return m.OperationName
	}
	return ""
}

func (m *PurgeUserEventsMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Response of the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type PurgeUserEventsResponse struct {
	// The total count of events purged as a result of the operation.
	PurgedEventsCount int64 `protobuf:"varint,1,opt,name=purged_events_count,json=purgedEventsCount,proto3" json:"purged_events_count,omitempty"`
	// A sampling of events deleted (or will be deleted) depending on the `force`
	// property in the request. Max of 500 items will be returned.
	UserEventsSample     []*UserEvent `protobuf:"bytes,2,rep,name=user_events_sample,json=userEventsSample,proto3" json:"user_events_sample,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PurgeUserEventsResponse) Reset()         { *m = PurgeUserEventsResponse{} }
func (m *PurgeUserEventsResponse) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsResponse) ProtoMessage()    {}
func (*PurgeUserEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{2}
}

func (m *PurgeUserEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsResponse.Unmarshal(m, b)
}
func (m *PurgeUserEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsResponse.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsResponse.Merge(m, src)
}
func (m *PurgeUserEventsResponse) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsResponse.Size(m)
}
func (m *PurgeUserEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsResponse proto.InternalMessageInfo

func (m *PurgeUserEventsResponse) GetPurgedEventsCount() int64 {
	if m != nil {
		return m.PurgedEventsCount
	}
	return 0
}

func (m *PurgeUserEventsResponse) GetUserEventsSample() []*UserEvent {
	if m != nil {
		return m.UserEventsSample
	}
	return nil
}

// Request message for WriteUserEvent method.
type WriteUserEventRequest struct {
	// Required. The parent eventStore resource name, such as
	// "projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User event to write.
	UserEvent            *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *WriteUserEventRequest) Reset()         { *m = WriteUserEventRequest{} }
func (m *WriteUserEventRequest) String() string { return proto.CompactTextString(m) }
func (*WriteUserEventRequest) ProtoMessage()    {}
func (*WriteUserEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{3}
}

func (m *WriteUserEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteUserEventRequest.Unmarshal(m, b)
}
func (m *WriteUserEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteUserEventRequest.Marshal(b, m, deterministic)
}
func (m *WriteUserEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteUserEventRequest.Merge(m, src)
}
func (m *WriteUserEventRequest) XXX_Size() int {
	return xxx_messageInfo_WriteUserEventRequest.Size(m)
}
func (m *WriteUserEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteUserEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteUserEventRequest proto.InternalMessageInfo

func (m *WriteUserEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *WriteUserEventRequest) GetUserEvent() *UserEvent {
	if m != nil {
		return m.UserEvent
	}
	return nil
}

// Request message for CollectUserEvent method.
type CollectUserEventRequest struct {
	// Required. The parent eventStore name, such as
	// "projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. URL encoded UserEvent proto.
	UserEvent string `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// Optional. The url including cgi-parameters but excluding the hash fragment. The URL
	// must be truncated to 1.5K bytes to conservatively be under the 2K bytes.
	// This is often more useful than the referer url, because many browsers only
	// send the domain for 3rd party requests.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The event timestamp in milliseconds. This prevents browser caching of
	// otherwise identical get requests. The name is abbreviated to reduce the
	// payload bytes.
	Ets                  int64    `protobuf:"varint,4,opt,name=ets,proto3" json:"ets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CollectUserEventRequest) Reset()         { *m = CollectUserEventRequest{} }
func (m *CollectUserEventRequest) String() string { return proto.CompactTextString(m) }
func (*CollectUserEventRequest) ProtoMessage()    {}
func (*CollectUserEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{4}
}

func (m *CollectUserEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CollectUserEventRequest.Unmarshal(m, b)
}
func (m *CollectUserEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CollectUserEventRequest.Marshal(b, m, deterministic)
}
func (m *CollectUserEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectUserEventRequest.Merge(m, src)
}
func (m *CollectUserEventRequest) XXX_Size() int {
	return xxx_messageInfo_CollectUserEventRequest.Size(m)
}
func (m *CollectUserEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectUserEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CollectUserEventRequest proto.InternalMessageInfo

func (m *CollectUserEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CollectUserEventRequest) GetUserEvent() string {
	if m != nil {
		return m.UserEvent
	}
	return ""
}

func (m *CollectUserEventRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *CollectUserEventRequest) GetEts() int64 {
	if m != nil {
		return m.Ets
	}
	return 0
}

// Request message for ListUserEvents method.
type ListUserEventsRequest struct {
	// Required. The parent eventStore resource name, such as
	// "projects/*/locations/*/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of results to return per page. If zero, the
	// service will choose a reasonable default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The previous ListUserEventsResponse.next_page_token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering expression to specify restrictions over
	// returned events. This is a sequence of terms, where each term applies some
	// kind of a restriction to the returned user events. Use this expression to
	// restrict results to a specific time range, or filter events by eventType.
	//    eg: eventTime > "2012-04-23T18:25:43.511Z" eventsMissingCatalogItems
	//    eventTime<"2012-04-23T18:25:43.511Z" eventType=search
	//
	//   We expect only 3 types of fields:
	//
	//    * eventTime: this can be specified a maximum of 2 times, once with a
	//      less than operator and once with a greater than operator. The
	//      eventTime restrict should result in one contiguous valid eventTime
	//      range.
	//
	//    * eventType: only 1 eventType restriction can be specified.
	//
	//    * eventsMissingCatalogItems: specififying this will restrict results
	//      to events for which catalog items were not found in the catalog. The
	//      default behavior is to return only those events for which catalog
	//      items were found.
	//
	//   Some examples of valid filters expressions:
	//
	//   * Example 1: eventTime > "2012-04-23T18:25:43.511Z"
	//             eventTime < "2012-04-23T18:30:43.511Z"
	//   * Example 2: eventTime > "2012-04-23T18:25:43.511Z"
	//             eventType = detail-page-view
	//   * Example 3: eventsMissingCatalogItems
	//             eventType = search eventTime < "2018-04-23T18:30:43.511Z"
	//   * Example 4: eventTime > "2012-04-23T18:25:43.511Z"
	//   * Example 5: eventType = search
	//   * Example 6: eventsMissingCatalogItems
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUserEventsRequest) Reset()         { *m = ListUserEventsRequest{} }
func (m *ListUserEventsRequest) String() string { return proto.CompactTextString(m) }
func (*ListUserEventsRequest) ProtoMessage()    {}
func (*ListUserEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{5}
}

func (m *ListUserEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUserEventsRequest.Unmarshal(m, b)
}
func (m *ListUserEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUserEventsRequest.Marshal(b, m, deterministic)
}
func (m *ListUserEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUserEventsRequest.Merge(m, src)
}
func (m *ListUserEventsRequest) XXX_Size() int {
	return xxx_messageInfo_ListUserEventsRequest.Size(m)
}
func (m *ListUserEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUserEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUserEventsRequest proto.InternalMessageInfo

func (m *ListUserEventsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListUserEventsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListUserEventsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListUserEventsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response message for ListUserEvents method.
type ListUserEventsResponse struct {
	// The user events.
	UserEvents []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
	// If empty, the list is complete. If nonempty, the token to pass to the next
	// request's ListUserEvents.page_token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUserEventsResponse) Reset()         { *m = ListUserEventsResponse{} }
func (m *ListUserEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListUserEventsResponse) ProtoMessage()    {}
func (*ListUserEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{6}
}

func (m *ListUserEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUserEventsResponse.Unmarshal(m, b)
}
func (m *ListUserEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUserEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListUserEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUserEventsResponse.Merge(m, src)
}
func (m *ListUserEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListUserEventsResponse.Size(m)
}
func (m *ListUserEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUserEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListUserEventsResponse proto.InternalMessageInfo

func (m *ListUserEventsResponse) GetUserEvents() []*UserEvent {
	if m != nil {
		return m.UserEvents
	}
	return nil
}

func (m *ListUserEventsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*PurgeUserEventsRequest)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsRequest")
	proto.RegisterType((*PurgeUserEventsMetadata)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsMetadata")
	proto.RegisterType((*PurgeUserEventsResponse)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsResponse")
	proto.RegisterType((*WriteUserEventRequest)(nil), "google.cloud.recommendationengine.v1beta1.WriteUserEventRequest")
	proto.RegisterType((*CollectUserEventRequest)(nil), "google.cloud.recommendationengine.v1beta1.CollectUserEventRequest")
	proto.RegisterType((*ListUserEventsRequest)(nil), "google.cloud.recommendationengine.v1beta1.ListUserEventsRequest")
	proto.RegisterType((*ListUserEventsResponse)(nil), "google.cloud.recommendationengine.v1beta1.ListUserEventsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/user_event_service.proto", fileDescriptor_b2db17806dba696a)
}

var fileDescriptor_b2db17806dba696a = []byte{
	// 975 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xd6, 0xd8, 0x4d, 0x55, 0x8f, 0x45, 0x1a, 0x06, 0x92, 0xb8, 0x06, 0x44, 0xb4, 0x15, 0x28,
	0xb5, 0xd4, 0x1d, 0x25, 0x20, 0x84, 0x5c, 0x21, 0x61, 0x47, 0x11, 0x54, 0x2a, 0x25, 0x5a, 0xa7,
	0x4d, 0x85, 0x40, 0x66, 0xbc, 0x7e, 0xde, 0x2c, 0xec, 0xee, 0x2c, 0x33, 0xb3, 0x09, 0x29, 0x2a,
	0x07, 0x0e, 0x88, 0x13, 0x17, 0x0e, 0xdc, 0x39, 0x22, 0xf1, 0x2f, 0x38, 0xe5, 0x48, 0x0f, 0x9c,
	0x10, 0x1c, 0x90, 0x38, 0x70, 0xe1, 0x27, 0xa0, 0xd9, 0x19, 0xdb, 0x1b, 0xc7, 0x95, 0x6c, 0x27,
	0xb7, 0xdd, 0xf7, 0xde, 0x7c, 0xef, 0x7b, 0x6f, 0xbe, 0x99, 0x79, 0xb8, 0x1d, 0x70, 0x1e, 0x44,
	0x40, 0xfd, 0x88, 0x67, 0x7d, 0x2a, 0xc0, 0xe7, 0x71, 0x0c, 0x49, 0x9f, 0xa9, 0x90, 0x27, 0x90,
	0x04, 0x61, 0x02, 0xf4, 0x68, 0xab, 0x07, 0x8a, 0x6d, 0xd1, 0x4c, 0x82, 0xe8, 0xc2, 0x11, 0x24,
	0xaa, 0x2b, 0x41, 0x1c, 0x85, 0x3e, 0xb8, 0xa9, 0xe0, 0x8a, 0x93, 0x5b, 0x06, 0xc3, 0xcd, 0x31,
	0xdc, 0x69, 0x18, 0xae, 0xc5, 0xa8, 0xbf, 0x6c, 0xd3, 0xb1, 0x34, 0xa4, 0x2c, 0x49, 0xb8, 0xca,
	0x83, 0xa4, 0x01, 0xaa, 0xbf, 0x5a, 0xf0, 0x0e, 0x42, 0x88, 0xfa, 0xdd, 0x1e, 0x1c, 0xb2, 0xa3,
	0x90, 0x0b, 0x1b, 0x70, 0xa3, 0x10, 0x70, 0xa8, 0x54, 0xda, 0xe3, 0xfd, 0x13, 0xeb, 0x7a, 0x6b,
	0xf6, 0x42, 0xc2, 0x38, 0xe5, 0x42, 0xd9, 0x75, 0xcd, 0x45, 0x1a, 0x60, 0xd7, 0xde, 0xb4, 0x6b,
	0x23, 0x9e, 0x04, 0x22, 0x4b, 0x92, 0x30, 0x09, 0x28, 0x4f, 0x41, 0x4c, 0x2d, 0x2a, 0xff, 0xeb,
	0x65, 0x03, 0xaa, 0xc2, 0x18, 0xa4, 0x62, 0x71, 0x6a, 0x03, 0xd6, 0x6c, 0x80, 0x3a, 0x49, 0x81,
	0xf6, 0x99, 0xb2, 0x6d, 0xad, 0xaf, 0x17, 0x8a, 0xf5, 0xa3, 0x70, 0x94, 0xd6, 0x89, 0xf1, 0xda,
	0x5e, 0x26, 0x02, 0x78, 0x20, 0x41, 0xec, 0x6a, 0x3a, 0xd2, 0x83, 0x2f, 0x32, 0x90, 0x8a, 0xbc,
	0x84, 0xaf, 0xa6, 0x4c, 0x40, 0xa2, 0x6a, 0x68, 0x03, 0x6d, 0x56, 0xda, 0xe5, 0xbf, 0x5a, 0x25,
	0xcf, 0x9a, 0xb4, 0x73, 0x10, 0x46, 0x0a, 0x44, 0xad, 0x54, 0x70, 0x1a, 0x13, 0xb9, 0x81, 0x97,
	0x06, 0x5c, 0xf8, 0x50, 0x2b, 0x6f, 0xa0, 0xcd, 0x6b, 0xda, 0x87, 0x3c, 0x63, 0x71, 0x9e, 0xe0,
	0xf5, 0x89, 0x74, 0x1f, 0x80, 0x62, 0x7d, 0xa6, 0x18, 0x79, 0x0d, 0x2f, 0x8f, 0xea, 0xed, 0x26,
	0x2c, 0x06, 0x93, 0xd7, 0x7b, 0x6e, 0x64, 0xbd, 0xcf, 0x62, 0x20, 0x77, 0x70, 0xd5, 0x17, 0xc0,
	0x14, 0x74, 0x75, 0xed, 0x79, 0xfa, 0xea, 0x76, 0xdd, 0xb5, 0xb2, 0x19, 0x36, 0xc6, 0xdd, 0x1f,
	0x36, 0xc6, 0xc3, 0x26, 0x5c, 0x1b, 0x9c, 0x5f, 0xd0, 0xb9, 0xfc, 0x1e, 0xc8, 0x94, 0x27, 0x12,
	0x88, 0x8b, 0x5f, 0x48, 0xb5, 0xab, 0x6f, 0xb6, 0x45, 0x76, 0x7d, 0x9e, 0xd9, 0xe2, 0xcb, 0xde,
	0xf3, 0xc6, 0x65, 0x96, 0xec, 0x68, 0x07, 0xe9, 0x61, 0x32, 0xde, 0x44, 0xd9, 0x95, 0x2c, 0x4e,
	0x23, 0xcd, 0xa7, 0xbc, 0x59, 0xdd, 0x7e, 0xd3, 0x9d, 0x59, 0xc6, 0xee, 0x88, 0x8a, 0xb7, 0x92,
	0x8d, 0x58, 0x75, 0x72, 0x34, 0xe7, 0x7b, 0x84, 0x57, 0x0f, 0x44, 0xa8, 0xc6, 0x7c, 0x67, 0xda,
	0x9d, 0x47, 0x18, 0x8f, 0xa9, 0xd9, 0x16, 0x2d, 0x44, 0xc9, 0xc0, 0x56, 0x46, 0xbc, 0x9c, 0xef,
	0x10, 0x5e, 0xdf, 0xe1, 0x51, 0x04, 0xbe, 0x9a, 0x8f, 0x92, 0x73, 0x8e, 0x52, 0x65, 0x12, 0x9c,
	0xac, 0xe2, 0x72, 0x26, 0xc2, 0x5c, 0x35, 0x15, 0xa3, 0x1a, 0xfd, 0xaf, 0xcd, 0xa0, 0x64, 0xed,
	0x8a, 0xde, 0x08, 0x6b, 0x06, 0x25, 0x9d, 0x1f, 0x11, 0x5e, 0xbd, 0x17, 0x4a, 0x35, 0xa7, 0x72,
	0x37, 0x70, 0x25, 0x65, 0x01, 0x74, 0x65, 0xf8, 0xd8, 0xa8, 0x67, 0xc9, 0x60, 0x5e, 0xd3, 0xd6,
	0x4e, 0xf8, 0x18, 0x34, 0xd5, 0x3c, 0x42, 0xf1, 0xcf, 0x21, 0x29, 0xb2, 0xc9, 0x17, 0xee, 0x6b,
	0x6b, 0x41, 0xff, 0x57, 0xc6, 0x7e, 0x6b, 0xd2, 0xcc, 0xd6, 0x26, 0x99, 0x59, 0x91, 0x3d, 0xc0,
	0xd5, 0x82, 0x68, 0x6a, 0xe8, 0x02, 0x6a, 0xc1, 0x63, 0xb5, 0x90, 0xd7, 0xf1, 0xf5, 0x04, 0xbe,
	0x54, 0xdd, 0x02, 0xef, 0x92, 0x39, 0x3c, 0xda, 0xbc, 0x37, 0xa4, 0xbd, 0xfd, 0xb4, 0x8a, 0x57,
	0x46, 0x08, 0x1d, 0x73, 0xf1, 0x92, 0xff, 0x10, 0x5e, 0x3e, 0x2b, 0x32, 0xf2, 0xee, 0x1c, 0x8c,
	0xa6, 0xea, 0xb3, 0xbe, 0x50, 0x4d, 0xce, 0xe0, 0x9b, 0xa7, 0x7f, 0xff, 0x50, 0xfa, 0xd4, 0xf1,
	0x46, 0xf7, 0xe4, 0x57, 0x66, 0xdb, 0xde, 0x49, 0x05, 0xff, 0x0c, 0x7c, 0x25, 0x69, 0x83, 0x46,
	0xdc, 0x37, 0x97, 0x22, 0x6d, 0x50, 0x9f, 0x29, 0x16, 0xf1, 0x40, 0x7f, 0xe6, 0x2d, 0xed, 0x28,
	0x2e, 0x40, 0xd2, 0xc6, 0x13, 0x3a, 0xee, 0x4e, 0xf3, 0x58, 0x33, 0x6c, 0x16, 0xf4, 0x47, 0x4e,
	0x11, 0x5e, 0x99, 0x94, 0x31, 0x69, 0xcf, 0x41, 0xf9, 0x19, 0x67, 0xa0, 0xfe, 0xe2, 0x10, 0x83,
	0xa5, 0xa1, 0xfb, 0xbe, 0x52, 0x69, 0x9b, 0xf7, 0x4f, 0x9c, 0x8f, 0xf3, 0xb2, 0x1e, 0x92, 0xfd,
	0x4b, 0x2d, 0xcb, 0x37, 0x1c, 0xc8, 0xbf, 0x08, 0x2f, 0x9f, 0x95, 0xdb, 0x5c, 0xfb, 0x37, 0xf5,
	0x0c, 0xd5, 0x5b, 0x17, 0x40, 0x30, 0x5a, 0x77, 0xf6, 0xf3, 0xaa, 0xef, 0x93, 0x7b, 0x97, 0x59,
	0x35, 0xf9, 0xa3, 0x84, 0xaf, 0x4f, 0x5c, 0xe1, 0x64, 0x1e, 0xb2, 0xd3, 0x5f, 0xbb, 0xfa, 0x2b,
	0x43, 0x88, 0xc2, 0xfb, 0xeb, 0x7e, 0x38, 0x7c, 0x79, 0x9c, 0x7f, 0xd0, 0x69, 0xeb, 0x5b, 0x84,
	0x5b, 0x17, 0xc8, 0x63, 0x6f, 0x80, 0xc5, 0x21, 0x86, 0x2f, 0x65, 0xde, 0xd6, 0x83, 0x4b, 0x3e,
	0x23, 0xf9, 0xfb, 0xd6, 0x44, 0x0d, 0xf2, 0x7b, 0x09, 0xaf, 0xdc, 0xcd, 0x87, 0x9a, 0x42, 0x83,
	0xe7, 0x39, 0x1a, 0x93, 0x8b, 0x67, 0xec, 0xf0, 0x9f, 0xe8, 0xb4, 0xf5, 0xf5, 0x70, 0x84, 0x5c,
	0x2c, 0x8f, 0xed, 0xf0, 0xdb, 0xf3, 0x62, 0x9c, 0x69, 0xec, 0x23, 0xa7, 0x73, 0xa9, 0x8d, 0x35,
	0x03, 0x62, 0x13, 0x35, 0xea, 0x07, 0xa7, 0xad, 0x9b, 0x53, 0xd9, 0x18, 0xbe, 0x2c, 0x0d, 0xa5,
	0xeb, 0xf3, 0xf8, 0xb7, 0x96, 0xab, 0xc7, 0x51, 0xd9, 0xa4, 0xf4, 0xf8, 0xf8, 0x78, 0xc2, 0x49,
	0x59, 0xa6, 0x0e, 0xcd, 0x7c, 0x79, 0x3b, 0x8d, 0x98, 0x1a, 0x70, 0x11, 0xb7, 0x7f, 0x45, 0xf8,
	0xb6, 0xcf, 0xe3, 0xd9, 0xf7, 0x68, 0x0f, 0x7d, 0xf4, 0x89, 0x0d, 0x0e, 0x78, 0xc4, 0x92, 0xc0,
	0xe5, 0x22, 0xa0, 0x01, 0x24, 0xf9, 0xf8, 0x44, 0xc7, 0x29, 0x67, 0x98, 0x64, 0xef, 0x4c, 0x73,
	0xfe, 0x54, 0x5a, 0xf2, 0x76, 0x77, 0x5a, 0x77, 0x7f, 0x2e, 0xdd, 0x7a, 0xcf, 0xe4, 0xd9, 0xc9,
	0x49, 0x79, 0x67, 0x62, 0x77, 0x0d, 0xa9, 0x87, 0x5b, 0x6d, 0x0d, 0xd4, 0xbb, 0x9a, 0x67, 0x7f,
	0xe3, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x4d, 0xb1, 0xaf, 0x84, 0x47, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// UserEventServiceClient is the client API for UserEventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserEventServiceClient interface {
	// Writes a single user event.
	WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type userEventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserEventServiceClient(cc grpc.ClientConnInterface) UserEventServiceClient {
	return &userEventServiceClient{cc}
}

func (c *userEventServiceClient) WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error) {
	out := new(UserEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/WriteUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/CollectUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error) {
	out := new(ListUserEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/ListUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/PurgeUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/ImportUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserEventServiceServer is the server API for UserEventService service.
type UserEventServiceServer interface {
	// Writes a single user event.
	WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(context.Context, *ListUserEventsRequest) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunning.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunning.Operation, error)
}

// UnimplementedUserEventServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUserEventServiceServer struct {
}

func (*UnimplementedUserEventServiceServer) WriteUserEvent(ctx context.Context, req *WriteUserEventRequest) (*UserEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) CollectUserEvent(ctx context.Context, req *CollectUserEventRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CollectUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) ListUserEvents(ctx context.Context, req *ListUserEventsRequest) (*ListUserEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) PurgeUserEvents(ctx context.Context, req *PurgeUserEventsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) ImportUserEvents(ctx context.Context, req *ImportUserEventsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportUserEvents not implemented")
}

func RegisterUserEventServiceServer(s *grpc.Server, srv UserEventServiceServer) {
	s.RegisterService(&_UserEventService_serviceDesc, srv)
}

func _UserEventService_WriteUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/WriteUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, req.(*WriteUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_CollectUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/CollectUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, req.(*CollectUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ListUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/ListUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, req.(*ListUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_PurgeUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/PurgeUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, req.(*PurgeUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ImportUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/ImportUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, req.(*ImportUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserEventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.UserEventService",
	HandlerType: (*UserEventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "WriteUserEvent",
			Handler:    _UserEventService_WriteUserEvent_Handler,
		},
		{
			MethodName: "CollectUserEvent",
			Handler:    _UserEventService_CollectUserEvent_Handler,
		},
		{
			MethodName: "ListUserEvents",
			Handler:    _UserEventService_ListUserEvents_Handler,
		},
		{
			MethodName: "PurgeUserEvents",
			Handler:    _UserEventService_PurgeUserEvents_Handler,
		},
		{
			MethodName: "ImportUserEvents",
			Handler:    _UserEventService_ImportUserEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/user_event_service.proto",
}
