// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/asset_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AssetService.GetAsset][google.ads.googleads.v1.services.AssetService.GetAsset]
type GetAssetRequest struct {
	// The resource name of the asset to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAssetRequest) Reset()         { *m = GetAssetRequest{} }
func (m *GetAssetRequest) String() string { return proto.CompactTextString(m) }
func (*GetAssetRequest) ProtoMessage()    {}
func (*GetAssetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6e6d3ab580fb9b, []int{0}
}

func (m *GetAssetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAssetRequest.Unmarshal(m, b)
}
func (m *GetAssetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAssetRequest.Marshal(b, m, deterministic)
}
func (m *GetAssetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAssetRequest.Merge(m, src)
}
func (m *GetAssetRequest) XXX_Size() int {
	return xxx_messageInfo_GetAssetRequest.Size(m)
}
func (m *GetAssetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAssetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAssetRequest proto.InternalMessageInfo

func (m *GetAssetRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AssetService.MutateAssets][google.ads.googleads.v1.services.AssetService.MutateAssets]
type MutateAssetsRequest struct {
	// The ID of the customer whose assets are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual assets.
	Operations           []*AssetOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MutateAssetsRequest) Reset()         { *m = MutateAssetsRequest{} }
func (m *MutateAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAssetsRequest) ProtoMessage()    {}
func (*MutateAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6e6d3ab580fb9b, []int{1}
}

func (m *MutateAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAssetsRequest.Unmarshal(m, b)
}
func (m *MutateAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAssetsRequest.Marshal(b, m, deterministic)
}
func (m *MutateAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAssetsRequest.Merge(m, src)
}
func (m *MutateAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAssetsRequest.Size(m)
}
func (m *MutateAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAssetsRequest proto.InternalMessageInfo

func (m *MutateAssetsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAssetsRequest) GetOperations() []*AssetOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation to create an asset. Supported asset types are
// YoutubeVideoAsset, MediaBundleAsset and ImageAsset. TextAsset should be
// created with Ad inline.
type AssetOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AssetOperation_Create
	Operation            isAssetOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AssetOperation) Reset()         { *m = AssetOperation{} }
func (m *AssetOperation) String() string { return proto.CompactTextString(m) }
func (*AssetOperation) ProtoMessage()    {}
func (*AssetOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6e6d3ab580fb9b, []int{2}
}

func (m *AssetOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssetOperation.Unmarshal(m, b)
}
func (m *AssetOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssetOperation.Marshal(b, m, deterministic)
}
func (m *AssetOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssetOperation.Merge(m, src)
}
func (m *AssetOperation) XXX_Size() int {
	return xxx_messageInfo_AssetOperation.Size(m)
}
func (m *AssetOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AssetOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AssetOperation proto.InternalMessageInfo

type isAssetOperation_Operation interface {
	isAssetOperation_Operation()
}

type AssetOperation_Create struct {
	Create *resources.Asset `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

func (*AssetOperation_Create) isAssetOperation_Operation() {}

func (m *AssetOperation) GetOperation() isAssetOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AssetOperation) GetCreate() *resources.Asset {
	if x, ok := m.GetOperation().(*AssetOperation_Create); ok {
		return x.Create
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AssetOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AssetOperation_Create)(nil),
	}
}

// Response message for an asset mutate.
type MutateAssetsResponse struct {
	// All results for the mutate.
	Results              []*MutateAssetResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MutateAssetsResponse) Reset()         { *m = MutateAssetsResponse{} }
func (m *MutateAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAssetsResponse) ProtoMessage()    {}
func (*MutateAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6e6d3ab580fb9b, []int{3}
}

func (m *MutateAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAssetsResponse.Unmarshal(m, b)
}
func (m *MutateAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAssetsResponse.Marshal(b, m, deterministic)
}
func (m *MutateAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAssetsResponse.Merge(m, src)
}
func (m *MutateAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAssetsResponse.Size(m)
}
func (m *MutateAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAssetsResponse proto.InternalMessageInfo

func (m *MutateAssetsResponse) GetResults() []*MutateAssetResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the asset mutate.
type MutateAssetResult struct {
	// The resource name returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAssetResult) Reset()         { *m = MutateAssetResult{} }
func (m *MutateAssetResult) String() string { return proto.CompactTextString(m) }
func (*MutateAssetResult) ProtoMessage()    {}
func (*MutateAssetResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6e6d3ab580fb9b, []int{4}
}

func (m *MutateAssetResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAssetResult.Unmarshal(m, b)
}
func (m *MutateAssetResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAssetResult.Marshal(b, m, deterministic)
}
func (m *MutateAssetResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAssetResult.Merge(m, src)
}
func (m *MutateAssetResult) XXX_Size() int {
	return xxx_messageInfo_MutateAssetResult.Size(m)
}
func (m *MutateAssetResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAssetResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAssetResult proto.InternalMessageInfo

func (m *MutateAssetResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAssetRequest)(nil), "google.ads.googleads.v1.services.GetAssetRequest")
	proto.RegisterType((*MutateAssetsRequest)(nil), "google.ads.googleads.v1.services.MutateAssetsRequest")
	proto.RegisterType((*AssetOperation)(nil), "google.ads.googleads.v1.services.AssetOperation")
	proto.RegisterType((*MutateAssetsResponse)(nil), "google.ads.googleads.v1.services.MutateAssetsResponse")
	proto.RegisterType((*MutateAssetResult)(nil), "google.ads.googleads.v1.services.MutateAssetResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/asset_service.proto", fileDescriptor_4a6e6d3ab580fb9b)
}

var fileDescriptor_4a6e6d3ab580fb9b = []byte{
	// 542 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xbf, 0x8e, 0xd3, 0x4c,
	0x10, 0xff, 0xec, 0x93, 0xee, 0xe3, 0x36, 0x01, 0x74, 0x0b, 0x12, 0x51, 0x40, 0x22, 0x32, 0x57,
	0x44, 0x41, 0xac, 0xe3, 0x1c, 0x44, 0x68, 0xd1, 0x15, 0x4e, 0x93, 0xa3, 0x38, 0x88, 0x8c, 0x94,
	0x02, 0x45, 0x8a, 0x16, 0x7b, 0x65, 0x59, 0x8a, 0xbd, 0xc1, 0xb3, 0x4e, 0x73, 0xba, 0x86, 0x8a,
	0x9e, 0x8a, 0x96, 0x92, 0x9e, 0x97, 0xb8, 0x96, 0x57, 0xa0, 0xe2, 0x09, 0xe8, 0x40, 0xf6, 0x7a,
	0x1d, 0x07, 0x14, 0xe5, 0xae, 0x1b, 0xef, 0xcc, 0xef, 0xcf, 0xce, 0xcc, 0x1a, 0x3d, 0x0d, 0x85,
	0x08, 0x17, 0xdc, 0x66, 0x01, 0xd8, 0x2a, 0xcc, 0xa3, 0x95, 0x63, 0x03, 0x4f, 0x57, 0x91, 0xcf,
	0xc1, 0x66, 0x00, 0x5c, 0xce, 0xcb, 0x4f, 0xb2, 0x4c, 0x85, 0x14, 0xb8, 0xa3, 0x4a, 0x09, 0x0b,
	0x80, 0x54, 0x28, 0xb2, 0x72, 0x88, 0x46, 0xb5, 0x9f, 0x6c, 0xe3, 0x4d, 0x39, 0x88, 0x2c, 0xad,
	0x88, 0x15, 0x61, 0xfb, 0x81, 0x2e, 0x5f, 0x46, 0x36, 0x4b, 0x12, 0x21, 0x99, 0x8c, 0x44, 0x02,
	0x65, 0xf6, 0x5e, 0x2d, 0xeb, 0x2f, 0x22, 0x9e, 0x94, 0x30, 0x6b, 0x88, 0x6e, 0x8f, 0xb9, 0x74,
	0x73, 0x22, 0x8f, 0xbf, 0xcf, 0x38, 0x48, 0xfc, 0x08, 0xdd, 0xd4, 0x12, 0xf3, 0x84, 0xc5, 0xbc,
	0x65, 0x74, 0x8c, 0xee, 0x81, 0xd7, 0xd4, 0x87, 0xaf, 0x58, 0xcc, 0xad, 0x8f, 0x06, 0xba, 0x73,
	0x96, 0x49, 0x26, 0x79, 0x81, 0x05, 0x0d, 0x7e, 0x88, 0x1a, 0x7e, 0x06, 0x52, 0xc4, 0x3c, 0x9d,
	0x47, 0x41, 0x09, 0x45, 0xfa, 0xe8, 0x65, 0x80, 0x27, 0x08, 0x89, 0x25, 0x4f, 0x95, 0xbb, 0x96,
	0xd9, 0xd9, 0xeb, 0x36, 0x06, 0x7d, 0xb2, 0xab, 0x1b, 0xa4, 0x50, 0x79, 0xad, 0x81, 0x5e, 0x8d,
	0xc3, 0x62, 0xe8, 0xd6, 0x66, 0x16, 0x8f, 0xd0, 0xbe, 0x9f, 0x72, 0x26, 0x95, 0xf5, 0xc6, 0xa0,
	0xbb, 0x95, 0xbf, 0xea, 0xa5, 0x12, 0x38, 0xfd, 0xcf, 0x2b, 0x91, 0xa3, 0x06, 0x3a, 0xa8, 0x34,
	0x2c, 0x8e, 0xee, 0x6e, 0x5e, 0x16, 0x96, 0x22, 0x01, 0x8e, 0xcf, 0xd0, 0xff, 0x29, 0x87, 0x6c,
	0x21, 0xf5, 0x4d, 0x8e, 0x77, 0xdf, 0xa4, 0x46, 0xe4, 0x15, 0x58, 0x4f, 0x73, 0x58, 0xcf, 0xd1,
	0xe1, 0x3f, 0xd9, 0x2b, 0x8d, 0x63, 0xf0, 0xdb, 0x44, 0xcd, 0x02, 0xf4, 0x46, 0xc9, 0xe0, 0xcf,
	0x06, 0xba, 0xa1, 0x07, 0x8b, 0x9d, 0xdd, 0xae, 0xfe, 0x5a, 0x82, 0xf6, 0x95, 0x5b, 0x66, 0xf5,
	0x3f, 0x7c, 0xff, 0xf1, 0xc9, 0xec, 0xe1, 0x6e, 0xbe, 0x9b, 0xe7, 0x1b, 0x56, 0x4f, 0xf4, 0xdc,
	0xc1, 0xee, 0xa9, 0x65, 0x05, 0xbb, 0x77, 0x81, 0xbf, 0x19, 0xa8, 0x59, 0x6f, 0x27, 0x7e, 0x76,
	0xad, 0xae, 0xe9, 0x5d, 0x6b, 0x0f, 0xaf, 0x0b, 0x53, 0x53, 0xb3, 0x86, 0x85, 0xe3, 0xbe, 0xf5,
	0x38, 0x77, 0xbc, 0xb6, 0x78, 0x5e, 0x5b, 0xdc, 0x93, 0xde, 0x45, 0x69, 0x98, 0xc6, 0x05, 0x05,
	0x35, 0x7a, 0xed, 0xfb, 0x97, 0x6e, 0x6b, 0x2d, 0x53, 0x46, 0xcb, 0x08, 0x88, 0x2f, 0xe2, 0xd1,
	0x2f, 0x03, 0x1d, 0xf9, 0x22, 0xde, 0x69, 0x69, 0x74, 0x58, 0x9f, 0xd3, 0x24, 0x7f, 0x84, 0x13,
	0xe3, 0xed, 0x69, 0x09, 0x0b, 0xc5, 0x82, 0x25, 0x21, 0x11, 0x69, 0x68, 0x87, 0x3c, 0x29, 0x9e,
	0xa8, 0xbd, 0x16, 0xda, 0xfe, 0x8f, 0x79, 0xa1, 0x83, 0x2f, 0xe6, 0xde, 0xd8, 0x75, 0xbf, 0x9a,
	0x9d, 0xb1, 0x22, 0x74, 0x03, 0x20, 0x2a, 0xcc, 0xa3, 0xa9, 0x43, 0x4a, 0x61, 0xb8, 0xd4, 0x25,
	0x33, 0x37, 0x80, 0x59, 0x55, 0x32, 0x9b, 0x3a, 0x33, 0x5d, 0xf2, 0xd3, 0x3c, 0x52, 0xe7, 0x94,
	0xba, 0x01, 0x50, 0x5a, 0x15, 0x51, 0x3a, 0x75, 0x28, 0xd5, 0x65, 0xef, 0xf6, 0x0b, 0x9f, 0xc7,
	0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x6f, 0xfe, 0xfd, 0x45, 0x0a, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Returns the requested asset in full detail.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*resources.Asset, error)
	// Creates assets. Operation statuses are returned.
	MutateAssets(ctx context.Context, in *MutateAssetsRequest, opts ...grpc.CallOption) (*MutateAssetsResponse, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*resources.Asset, error) {
	out := new(resources.Asset)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AssetService/GetAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) MutateAssets(ctx context.Context, in *MutateAssetsRequest, opts ...grpc.CallOption) (*MutateAssetsResponse, error) {
	out := new(MutateAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AssetService/MutateAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Returns the requested asset in full detail.
	GetAsset(context.Context, *GetAssetRequest) (*resources.Asset, error)
	// Creates assets. Operation statuses are returned.
	MutateAssets(context.Context, *MutateAssetsRequest) (*MutateAssetsResponse, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) GetAsset(ctx context.Context, req *GetAssetRequest) (*resources.Asset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (*UnimplementedAssetServiceServer) MutateAssets(ctx context.Context, req *MutateAssetsRequest) (*MutateAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateAssets not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AssetService/GetAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_MutateAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).MutateAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AssetService/MutateAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).MutateAssets(ctx, req.(*MutateAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAsset",
			Handler:    _AssetService_GetAsset_Handler,
		},
		{
			MethodName: "MutateAssets",
			Handler:    _AssetService_MutateAssets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/asset_service.proto",
}
