// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/user_list_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [UserListService.GetUserList][google.ads.googleads.v1.services.UserListService.GetUserList].
type GetUserListRequest struct {
	// The resource name of the user list to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUserListRequest) Reset()         { *m = GetUserListRequest{} }
func (m *GetUserListRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserListRequest) ProtoMessage()    {}
func (*GetUserListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7187e04d3c35e864, []int{0}
}

func (m *GetUserListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetUserListRequest.Unmarshal(m, b)
}
func (m *GetUserListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetUserListRequest.Marshal(b, m, deterministic)
}
func (m *GetUserListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUserListRequest.Merge(m, src)
}
func (m *GetUserListRequest) XXX_Size() int {
	return xxx_messageInfo_GetUserListRequest.Size(m)
}
func (m *GetUserListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUserListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUserListRequest proto.InternalMessageInfo

func (m *GetUserListRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [UserListService.MutateUserLists][google.ads.googleads.v1.services.UserListService.MutateUserLists].
type MutateUserListsRequest struct {
	// The ID of the customer whose user lists are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual user lists.
	Operations []*UserListOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateUserListsRequest) Reset()         { *m = MutateUserListsRequest{} }
func (m *MutateUserListsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateUserListsRequest) ProtoMessage()    {}
func (*MutateUserListsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7187e04d3c35e864, []int{1}
}

func (m *MutateUserListsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListsRequest.Unmarshal(m, b)
}
func (m *MutateUserListsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListsRequest.Marshal(b, m, deterministic)
}
func (m *MutateUserListsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListsRequest.Merge(m, src)
}
func (m *MutateUserListsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateUserListsRequest.Size(m)
}
func (m *MutateUserListsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListsRequest proto.InternalMessageInfo

func (m *MutateUserListsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateUserListsRequest) GetOperations() []*UserListOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateUserListsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateUserListsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update) on a user list.
type UserListOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*UserListOperation_Create
	//	*UserListOperation_Update
	//	*UserListOperation_Remove
	Operation            isUserListOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UserListOperation) Reset()         { *m = UserListOperation{} }
func (m *UserListOperation) String() string { return proto.CompactTextString(m) }
func (*UserListOperation) ProtoMessage()    {}
func (*UserListOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7187e04d3c35e864, []int{2}
}

func (m *UserListOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListOperation.Unmarshal(m, b)
}
func (m *UserListOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListOperation.Marshal(b, m, deterministic)
}
func (m *UserListOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListOperation.Merge(m, src)
}
func (m *UserListOperation) XXX_Size() int {
	return xxx_messageInfo_UserListOperation.Size(m)
}
func (m *UserListOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListOperation.DiscardUnknown(m)
}

var xxx_messageInfo_UserListOperation proto.InternalMessageInfo

func (m *UserListOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isUserListOperation_Operation interface {
	isUserListOperation_Operation()
}

type UserListOperation_Create struct {
	Create *resources.UserList `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type UserListOperation_Update struct {
	Update *resources.UserList `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type UserListOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*UserListOperation_Create) isUserListOperation_Operation() {}

func (*UserListOperation_Update) isUserListOperation_Operation() {}

func (*UserListOperation_Remove) isUserListOperation_Operation() {}

func (m *UserListOperation) GetOperation() isUserListOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *UserListOperation) GetCreate() *resources.UserList {
	if x, ok := m.GetOperation().(*UserListOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *UserListOperation) GetUpdate() *resources.UserList {
	if x, ok := m.GetOperation().(*UserListOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *UserListOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*UserListOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UserListOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UserListOperation_Create)(nil),
		(*UserListOperation_Update)(nil),
		(*UserListOperation_Remove)(nil),
	}
}

// Response message for user list mutate.
type MutateUserListsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateUserListResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *MutateUserListsResponse) Reset()         { *m = MutateUserListsResponse{} }
func (m *MutateUserListsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateUserListsResponse) ProtoMessage()    {}
func (*MutateUserListsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7187e04d3c35e864, []int{3}
}

func (m *MutateUserListsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListsResponse.Unmarshal(m, b)
}
func (m *MutateUserListsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListsResponse.Marshal(b, m, deterministic)
}
func (m *MutateUserListsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListsResponse.Merge(m, src)
}
func (m *MutateUserListsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateUserListsResponse.Size(m)
}
func (m *MutateUserListsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListsResponse proto.InternalMessageInfo

func (m *MutateUserListsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateUserListsResponse) GetResults() []*MutateUserListResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the user list mutate.
type MutateUserListResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateUserListResult) Reset()         { *m = MutateUserListResult{} }
func (m *MutateUserListResult) String() string { return proto.CompactTextString(m) }
func (*MutateUserListResult) ProtoMessage()    {}
func (*MutateUserListResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_7187e04d3c35e864, []int{4}
}

func (m *MutateUserListResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateUserListResult.Unmarshal(m, b)
}
func (m *MutateUserListResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateUserListResult.Marshal(b, m, deterministic)
}
func (m *MutateUserListResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateUserListResult.Merge(m, src)
}
func (m *MutateUserListResult) XXX_Size() int {
	return xxx_messageInfo_MutateUserListResult.Size(m)
}
func (m *MutateUserListResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateUserListResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateUserListResult proto.InternalMessageInfo

func (m *MutateUserListResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetUserListRequest)(nil), "google.ads.googleads.v1.services.GetUserListRequest")
	proto.RegisterType((*MutateUserListsRequest)(nil), "google.ads.googleads.v1.services.MutateUserListsRequest")
	proto.RegisterType((*UserListOperation)(nil), "google.ads.googleads.v1.services.UserListOperation")
	proto.RegisterType((*MutateUserListsResponse)(nil), "google.ads.googleads.v1.services.MutateUserListsResponse")
	proto.RegisterType((*MutateUserListResult)(nil), "google.ads.googleads.v1.services.MutateUserListResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/user_list_service.proto", fileDescriptor_7187e04d3c35e864)
}

var fileDescriptor_7187e04d3c35e864 = []byte{
	// 721 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4f, 0x6b, 0xd4, 0x4e,
	0x18, 0xfe, 0x25, 0xfb, 0xa3, 0xda, 0x49, 0xb5, 0x38, 0x56, 0x1b, 0x56, 0xc1, 0x25, 0x16, 0x2c,
	0x5b, 0x9c, 0xb0, 0xbb, 0x22, 0x6d, 0x4a, 0x0f, 0x5b, 0xe8, 0x1f, 0xc1, 0xda, 0x92, 0x62, 0x0f,
	0xb2, 0x10, 0xa6, 0xc9, 0x74, 0x09, 0x4d, 0x32, 0x71, 0x66, 0xb2, 0x50, 0x4a, 0x2f, 0x82, 0x9f,
	0xc0, 0x9b, 0x47, 0xc1, 0x8b, 0x57, 0x3f, 0x81, 0xd7, 0x5e, 0xbd, 0x7a, 0xf4, 0xe4, 0x57, 0xf0,
	0x22, 0xc9, 0x64, 0x76, 0xbb, 0x5b, 0x97, 0xb5, 0xbd, 0xbd, 0xfb, 0xe6, 0x79, 0x9e, 0xf7, 0x99,
	0xf7, 0x9d, 0x77, 0x16, 0x2c, 0x77, 0x29, 0xed, 0x46, 0xc4, 0xc6, 0x01, 0xb7, 0x65, 0x98, 0x47,
	0xbd, 0x86, 0xcd, 0x09, 0xeb, 0x85, 0x3e, 0xe1, 0x76, 0xc6, 0x09, 0xf3, 0xa2, 0x90, 0x0b, 0xaf,
	0x4c, 0xa1, 0x94, 0x51, 0x41, 0x61, 0x4d, 0xc2, 0x11, 0x0e, 0x38, 0xea, 0x33, 0x51, 0xaf, 0x81,
	0x14, 0xb3, 0xda, 0x18, 0xa7, 0xcd, 0x08, 0xa7, 0x19, 0x1b, 0x12, 0x97, 0xa2, 0xd5, 0x87, 0x8a,
	0x92, 0x86, 0x36, 0x4e, 0x12, 0x2a, 0xb0, 0x08, 0x69, 0xc2, 0xcb, 0xaf, 0x65, 0x49, 0xbb, 0xf8,
	0x75, 0x98, 0x1d, 0xd9, 0x47, 0x21, 0x89, 0x02, 0x2f, 0xc6, 0xfc, 0xb8, 0x44, 0xcc, 0x97, 0x08,
	0x96, 0xfa, 0x36, 0x17, 0x58, 0x64, 0x7c, 0xe4, 0x43, 0x2e, 0xec, 0x47, 0x21, 0x49, 0xca, 0x8a,
	0xd6, 0x0a, 0x80, 0x5b, 0x44, 0xbc, 0xe6, 0x84, 0xbd, 0x0c, 0xb9, 0x70, 0xc9, 0xdb, 0x8c, 0x70,
	0x01, 0x1f, 0x83, 0x5b, 0xca, 0xa4, 0x97, 0xe0, 0x98, 0x98, 0x5a, 0x4d, 0x5b, 0x9c, 0x76, 0x67,
	0x54, 0xf2, 0x15, 0x8e, 0x89, 0xf5, 0x43, 0x03, 0xf7, 0x77, 0x32, 0x81, 0x05, 0x51, 0x74, 0xae,
	0xf8, 0x8f, 0x80, 0xe1, 0x67, 0x5c, 0xd0, 0x98, 0x30, 0x2f, 0x0c, 0x4a, 0x36, 0x50, 0xa9, 0x17,
	0x01, 0xdc, 0x07, 0x80, 0xa6, 0x84, 0xc9, 0xe3, 0x99, 0x7a, 0xad, 0xb2, 0x68, 0x34, 0x5b, 0x68,
	0x52, 0x4b, 0x91, 0x2a, 0xb4, 0xab, 0xb8, 0xee, 0x05, 0x19, 0xf8, 0x04, 0xcc, 0xa6, 0x98, 0x89,
	0x10, 0x47, 0xde, 0x11, 0x0e, 0xa3, 0x8c, 0x11, 0xb3, 0x52, 0xd3, 0x16, 0x6f, 0xba, 0xb7, 0xcb,
	0xf4, 0xa6, 0xcc, 0xe6, 0xc7, 0xeb, 0xe1, 0x28, 0x0c, 0xb0, 0x20, 0x1e, 0x4d, 0xa2, 0x13, 0xf3,
	0xff, 0x02, 0x36, 0xa3, 0x92, 0xbb, 0x49, 0x74, 0x62, 0xbd, 0xd7, 0xc1, 0x9d, 0x4b, 0xf5, 0xe0,
	0x2a, 0x30, 0xb2, 0xb4, 0x20, 0xe6, 0x6d, 0x2f, 0x88, 0x46, 0xb3, 0xaa, 0x9c, 0xab, 0xc9, 0xa0,
	0xcd, 0x7c, 0x32, 0x3b, 0x98, 0x1f, 0xbb, 0x40, 0xc2, 0xf3, 0x18, 0x6e, 0x80, 0x29, 0x9f, 0x11,
	0x2c, 0x64, 0x3f, 0x8d, 0xe6, 0xd2, 0xd8, 0x13, 0xf7, 0xaf, 0x48, 0xff, 0xc8, 0xdb, 0xff, 0xb9,
	0x25, 0x39, 0x97, 0x91, 0xa2, 0xa6, 0x7e, 0x2d, 0x19, 0x49, 0x86, 0x26, 0x98, 0x62, 0x24, 0xa6,
	0x3d, 0xd9, 0xa5, 0xe9, 0xfc, 0x8b, 0xfc, 0xbd, 0x6e, 0x80, 0xe9, 0x7e, 0x5b, 0xad, 0xaf, 0x1a,
	0x98, 0xbf, 0x34, 0x66, 0x9e, 0xd2, 0x84, 0x13, 0xb8, 0x09, 0xee, 0x8d, 0x74, 0xdc, 0x23, 0x8c,
	0x51, 0x56, 0x28, 0x1a, 0x4d, 0xa8, 0x8c, 0xb1, 0xd4, 0x47, 0xfb, 0xc5, 0x7d, 0x74, 0xef, 0x0e,
	0xcf, 0x62, 0x23, 0x87, 0xc3, 0x3d, 0x70, 0x83, 0x11, 0x9e, 0x45, 0x42, 0xdd, 0x85, 0xe7, 0x93,
	0xef, 0xc2, 0xb0, 0x27, 0xb7, 0xa0, 0xbb, 0x4a, 0xc6, 0x5a, 0x05, 0x73, 0x7f, 0x03, 0xfc, 0xd3,
	0xcd, 0x6e, 0x7e, 0xac, 0x80, 0x59, 0xc5, 0xdb, 0x97, 0xf5, 0xe0, 0x67, 0x0d, 0x18, 0x17, 0x36,
	0x05, 0x3e, 0x9b, 0xec, 0xf0, 0xf2, 0x62, 0x55, 0xaf, 0x32, 0x2a, 0xab, 0xf5, 0xee, 0xfb, 0xcf,
	0x0f, 0xfa, 0x53, 0xb8, 0x94, 0x3f, 0x1a, 0xa7, 0x43, 0xb6, 0xd7, 0xd4, 0x2e, 0x71, 0xbb, 0x5e,
	0xbc, 0x22, 0xc5, 0x5c, 0xec, 0xfa, 0x19, 0xfc, 0xa6, 0x81, 0xd9, 0x91, 0x71, 0xc1, 0xe5, 0xab,
	0x76, 0x53, 0x2d, 0x72, 0x75, 0xe5, 0x1a, 0x4c, 0x79, 0x37, 0xac, 0x95, 0xc2, 0x7d, 0xcb, 0x42,
	0xb9, 0xfb, 0x81, 0xdd, 0xd3, 0x0b, 0x0f, 0xc3, 0x5a, 0xfd, 0x6c, 0x60, 0xde, 0x89, 0x0b, 0x21,
	0x47, 0xab, 0x57, 0x1f, 0x9c, 0xb7, 0xcd, 0x41, 0xb1, 0x32, 0x4a, 0x43, 0x8e, 0x7c, 0x1a, 0xaf,
	0xff, 0xd6, 0xc0, 0x82, 0x4f, 0xe3, 0x89, 0xc6, 0xd6, 0xe7, 0x46, 0x46, 0xb8, 0x97, 0x2f, 0xe7,
	0x9e, 0xf6, 0x66, 0xbb, 0x64, 0x76, 0x69, 0x84, 0x93, 0x2e, 0xa2, 0xac, 0x6b, 0x77, 0x49, 0x52,
	0xac, 0xae, 0x3d, 0xa8, 0x35, 0xfe, 0x2f, 0x61, 0x55, 0x05, 0x9f, 0xf4, 0xca, 0x56, 0xbb, 0xfd,
	0x45, 0xaf, 0x6d, 0x49, 0xc1, 0x76, 0xc0, 0x91, 0x0c, 0xf3, 0xe8, 0xa0, 0x81, 0xca, 0xc2, 0xfc,
	0x5c, 0x41, 0x3a, 0xed, 0x80, 0x77, 0xfa, 0x90, 0xce, 0x41, 0xa3, 0xa3, 0x20, 0xbf, 0xf4, 0x05,
	0x99, 0x77, 0x9c, 0x76, 0xc0, 0x1d, 0xa7, 0x0f, 0x72, 0x9c, 0x83, 0x86, 0xe3, 0x28, 0xd8, 0xe1,
	0x54, 0xe1, 0xb3, 0xf5, 0x27, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x3d, 0x6e, 0x49, 0xb9, 0x06, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// UserListServiceClient is the client API for UserListService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserListServiceClient interface {
	// Returns the requested user list.
	GetUserList(ctx context.Context, in *GetUserListRequest, opts ...grpc.CallOption) (*resources.UserList, error)
	// Creates or updates user lists. Operation statuses are returned.
	MutateUserLists(ctx context.Context, in *MutateUserListsRequest, opts ...grpc.CallOption) (*MutateUserListsResponse, error)
}

type userListServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserListServiceClient(cc grpc.ClientConnInterface) UserListServiceClient {
	return &userListServiceClient{cc}
}

func (c *userListServiceClient) GetUserList(ctx context.Context, in *GetUserListRequest, opts ...grpc.CallOption) (*resources.UserList, error) {
	out := new(resources.UserList)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.UserListService/GetUserList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userListServiceClient) MutateUserLists(ctx context.Context, in *MutateUserListsRequest, opts ...grpc.CallOption) (*MutateUserListsResponse, error) {
	out := new(MutateUserListsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.UserListService/MutateUserLists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserListServiceServer is the server API for UserListService service.
type UserListServiceServer interface {
	// Returns the requested user list.
	GetUserList(context.Context, *GetUserListRequest) (*resources.UserList, error)
	// Creates or updates user lists. Operation statuses are returned.
	MutateUserLists(context.Context, *MutateUserListsRequest) (*MutateUserListsResponse, error)
}

// UnimplementedUserListServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUserListServiceServer struct {
}

func (*UnimplementedUserListServiceServer) GetUserList(ctx context.Context, req *GetUserListRequest) (*resources.UserList, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetUserList not implemented")
}
func (*UnimplementedUserListServiceServer) MutateUserLists(ctx context.Context, req *MutateUserListsRequest) (*MutateUserListsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateUserLists not implemented")
}

func RegisterUserListServiceServer(s *grpc.Server, srv UserListServiceServer) {
	s.RegisterService(&_UserListService_serviceDesc, srv)
}

func _UserListService_GetUserList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserListServiceServer).GetUserList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.UserListService/GetUserList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserListServiceServer).GetUserList(ctx, req.(*GetUserListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserListService_MutateUserLists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateUserListsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserListServiceServer).MutateUserLists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.UserListService/MutateUserLists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserListServiceServer).MutateUserLists(ctx, req.(*MutateUserListsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserListService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.UserListService",
	HandlerType: (*UserListServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetUserList",
			Handler:    _UserListService_GetUserList_Handler,
		},
		{
			MethodName: "MutateUserLists",
			Handler:    _UserListService_MutateUserLists_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/user_list_service.proto",
}
