//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// ActivityLogsServer is a fake server for instances of the armmonitor.ActivityLogsClient type.
type ActivityLogsServer struct {
	// NewListPager is the fake for method ActivityLogsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(filter string, options *armmonitor.ActivityLogsClientListOptions) (resp azfake.PagerResponder[armmonitor.ActivityLogsClientListResponse])
}

// NewActivityLogsServerTransport creates a new instance of ActivityLogsServerTransport with the provided implementation.
// The returned ActivityLogsServerTransport instance is connected to an instance of armmonitor.ActivityLogsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewActivityLogsServerTransport(srv *ActivityLogsServer) *ActivityLogsServerTransport {
	return &ActivityLogsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmonitor.ActivityLogsClientListResponse]](),
	}
}

// ActivityLogsServerTransport connects instances of armmonitor.ActivityLogsClient to instances of ActivityLogsServer.
// Don't use this type directly, use NewActivityLogsServerTransport instead.
type ActivityLogsServerTransport struct {
	srv          *ActivityLogsServer
	newListPager *tracker[azfake.PagerResponder[armmonitor.ActivityLogsClientListResponse]]
}

// Do implements the policy.Transporter interface for ActivityLogsServerTransport.
func (a *ActivityLogsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ActivityLogsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ActivityLogsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/eventtypes/management/values`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		var options *armmonitor.ActivityLogsClientListOptions
		if selectParam != nil {
			options = &armmonitor.ActivityLogsClientListOptions{
				Select: selectParam,
			}
		}
		resp := a.srv.NewListPager(filterParam, options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmonitor.ActivityLogsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
