// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/monitoring/dashboard/v1/text.proto

package dashboardpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The format type of the text content.
type Text_Format int32

const (
	// Format is unspecified. Defaults to MARKDOWN.
	Text_FORMAT_UNSPECIFIED Text_Format = 0
	// The text contains Markdown formatting.
	Text_MARKDOWN Text_Format = 1
	// The text contains no special formatting.
	Text_RAW Text_Format = 2
)

// Enum value maps for Text_Format.
var (
	Text_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "MARKDOWN",
		2: "RAW",
	}
	Text_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"MARKDOWN":           1,
		"RAW":                2,
	}
)

func (x Text_Format) Enum() *Text_Format {
	p := new(Text_Format)
	*p = x
	return p
}

func (x Text_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[0].Descriptor()
}

func (Text_Format) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[0]
}

func (x Text_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_Format.Descriptor instead.
func (Text_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0}
}

// The horizontal alignment of both the title and content on a text widget
type Text_TextStyle_HorizontalAlignment int32

const (
	// No horizontal alignment specified, will default to H_LEFT
	Text_TextStyle_HORIZONTAL_ALIGNMENT_UNSPECIFIED Text_TextStyle_HorizontalAlignment = 0
	// Left-align
	Text_TextStyle_H_LEFT Text_TextStyle_HorizontalAlignment = 1
	// Center-align
	Text_TextStyle_H_CENTER Text_TextStyle_HorizontalAlignment = 2
	// Right-align
	Text_TextStyle_H_RIGHT Text_TextStyle_HorizontalAlignment = 3
)

// Enum value maps for Text_TextStyle_HorizontalAlignment.
var (
	Text_TextStyle_HorizontalAlignment_name = map[int32]string{
		0: "HORIZONTAL_ALIGNMENT_UNSPECIFIED",
		1: "H_LEFT",
		2: "H_CENTER",
		3: "H_RIGHT",
	}
	Text_TextStyle_HorizontalAlignment_value = map[string]int32{
		"HORIZONTAL_ALIGNMENT_UNSPECIFIED": 0,
		"H_LEFT":                           1,
		"H_CENTER":                         2,
		"H_RIGHT":                          3,
	}
)

func (x Text_TextStyle_HorizontalAlignment) Enum() *Text_TextStyle_HorizontalAlignment {
	p := new(Text_TextStyle_HorizontalAlignment)
	*p = x
	return p
}

func (x Text_TextStyle_HorizontalAlignment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_TextStyle_HorizontalAlignment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[1].Descriptor()
}

func (Text_TextStyle_HorizontalAlignment) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[1]
}

func (x Text_TextStyle_HorizontalAlignment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_TextStyle_HorizontalAlignment.Descriptor instead.
func (Text_TextStyle_HorizontalAlignment) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The vertical alignment of both the title and content on a text widget
type Text_TextStyle_VerticalAlignment int32

const (
	// No vertical alignment specified, will default to V_TOP
	Text_TextStyle_VERTICAL_ALIGNMENT_UNSPECIFIED Text_TextStyle_VerticalAlignment = 0
	// Top-align
	Text_TextStyle_V_TOP Text_TextStyle_VerticalAlignment = 1
	// Center-align
	Text_TextStyle_V_CENTER Text_TextStyle_VerticalAlignment = 2
	// Bottom-align
	Text_TextStyle_V_BOTTOM Text_TextStyle_VerticalAlignment = 3
)

// Enum value maps for Text_TextStyle_VerticalAlignment.
var (
	Text_TextStyle_VerticalAlignment_name = map[int32]string{
		0: "VERTICAL_ALIGNMENT_UNSPECIFIED",
		1: "V_TOP",
		2: "V_CENTER",
		3: "V_BOTTOM",
	}
	Text_TextStyle_VerticalAlignment_value = map[string]int32{
		"VERTICAL_ALIGNMENT_UNSPECIFIED": 0,
		"V_TOP":                          1,
		"V_CENTER":                       2,
		"V_BOTTOM":                       3,
	}
)

func (x Text_TextStyle_VerticalAlignment) Enum() *Text_TextStyle_VerticalAlignment {
	p := new(Text_TextStyle_VerticalAlignment)
	*p = x
	return p
}

func (x Text_TextStyle_VerticalAlignment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_TextStyle_VerticalAlignment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[2].Descriptor()
}

func (Text_TextStyle_VerticalAlignment) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[2]
}

func (x Text_TextStyle_VerticalAlignment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_TextStyle_VerticalAlignment.Descriptor instead.
func (Text_TextStyle_VerticalAlignment) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0, 1}
}

// Specifies padding size around a text widget
type Text_TextStyle_PaddingSize int32

const (
	// No padding size specified, will default to P_EXTRA_SMALL
	Text_TextStyle_PADDING_SIZE_UNSPECIFIED Text_TextStyle_PaddingSize = 0
	// Extra small padding
	Text_TextStyle_P_EXTRA_SMALL Text_TextStyle_PaddingSize = 1
	// Small padding
	Text_TextStyle_P_SMALL Text_TextStyle_PaddingSize = 2
	// Medium padding
	Text_TextStyle_P_MEDIUM Text_TextStyle_PaddingSize = 3
	// Large padding
	Text_TextStyle_P_LARGE Text_TextStyle_PaddingSize = 4
	// Extra large padding
	Text_TextStyle_P_EXTRA_LARGE Text_TextStyle_PaddingSize = 5
)

// Enum value maps for Text_TextStyle_PaddingSize.
var (
	Text_TextStyle_PaddingSize_name = map[int32]string{
		0: "PADDING_SIZE_UNSPECIFIED",
		1: "P_EXTRA_SMALL",
		2: "P_SMALL",
		3: "P_MEDIUM",
		4: "P_LARGE",
		5: "P_EXTRA_LARGE",
	}
	Text_TextStyle_PaddingSize_value = map[string]int32{
		"PADDING_SIZE_UNSPECIFIED": 0,
		"P_EXTRA_SMALL":            1,
		"P_SMALL":                  2,
		"P_MEDIUM":                 3,
		"P_LARGE":                  4,
		"P_EXTRA_LARGE":            5,
	}
)

func (x Text_TextStyle_PaddingSize) Enum() *Text_TextStyle_PaddingSize {
	p := new(Text_TextStyle_PaddingSize)
	*p = x
	return p
}

func (x Text_TextStyle_PaddingSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_TextStyle_PaddingSize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[3].Descriptor()
}

func (Text_TextStyle_PaddingSize) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[3]
}

func (x Text_TextStyle_PaddingSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_TextStyle_PaddingSize.Descriptor instead.
func (Text_TextStyle_PaddingSize) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0, 2}
}

// Specifies a font size for the title and content of a text widget
type Text_TextStyle_FontSize int32

const (
	// No font size specified, will default to FS_LARGE
	Text_TextStyle_FONT_SIZE_UNSPECIFIED Text_TextStyle_FontSize = 0
	// Extra small font size
	Text_TextStyle_FS_EXTRA_SMALL Text_TextStyle_FontSize = 1
	// Small font size
	Text_TextStyle_FS_SMALL Text_TextStyle_FontSize = 2
	// Medium font size
	Text_TextStyle_FS_MEDIUM Text_TextStyle_FontSize = 3
	// Large font size
	Text_TextStyle_FS_LARGE Text_TextStyle_FontSize = 4
	// Extra large font size
	Text_TextStyle_FS_EXTRA_LARGE Text_TextStyle_FontSize = 5
)

// Enum value maps for Text_TextStyle_FontSize.
var (
	Text_TextStyle_FontSize_name = map[int32]string{
		0: "FONT_SIZE_UNSPECIFIED",
		1: "FS_EXTRA_SMALL",
		2: "FS_SMALL",
		3: "FS_MEDIUM",
		4: "FS_LARGE",
		5: "FS_EXTRA_LARGE",
	}
	Text_TextStyle_FontSize_value = map[string]int32{
		"FONT_SIZE_UNSPECIFIED": 0,
		"FS_EXTRA_SMALL":        1,
		"FS_SMALL":              2,
		"FS_MEDIUM":             3,
		"FS_LARGE":              4,
		"FS_EXTRA_LARGE":        5,
	}
)

func (x Text_TextStyle_FontSize) Enum() *Text_TextStyle_FontSize {
	p := new(Text_TextStyle_FontSize)
	*p = x
	return p
}

func (x Text_TextStyle_FontSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_TextStyle_FontSize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[4].Descriptor()
}

func (Text_TextStyle_FontSize) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[4]
}

func (x Text_TextStyle_FontSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_TextStyle_FontSize.Descriptor instead.
func (Text_TextStyle_FontSize) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0, 3}
}

// Specifies where a visual pointer is placed on a text widget (also
// sometimes called a "tail")
type Text_TextStyle_PointerLocation int32

const (
	// No visual pointer
	Text_TextStyle_POINTER_LOCATION_UNSPECIFIED Text_TextStyle_PointerLocation = 0
	// Placed in the middle of the top of the widget
	Text_TextStyle_PL_TOP Text_TextStyle_PointerLocation = 1
	// Placed in the middle of the right side of the widget
	Text_TextStyle_PL_RIGHT Text_TextStyle_PointerLocation = 2
	// Placed in the middle of the bottom of the widget
	Text_TextStyle_PL_BOTTOM Text_TextStyle_PointerLocation = 3
	// Placed in the middle of the left side of the widget
	Text_TextStyle_PL_LEFT Text_TextStyle_PointerLocation = 4
	// Placed on the left side of the top of the widget
	Text_TextStyle_PL_TOP_LEFT Text_TextStyle_PointerLocation = 5
	// Placed on the right side of the top of the widget
	Text_TextStyle_PL_TOP_RIGHT Text_TextStyle_PointerLocation = 6
	// Placed on the top of the right side of the widget
	Text_TextStyle_PL_RIGHT_TOP Text_TextStyle_PointerLocation = 7
	// Placed on the bottom of the right side of the widget
	Text_TextStyle_PL_RIGHT_BOTTOM Text_TextStyle_PointerLocation = 8
	// Placed on the right side of the bottom of the widget
	Text_TextStyle_PL_BOTTOM_RIGHT Text_TextStyle_PointerLocation = 9
	// Placed on the left side of the bottom of the widget
	Text_TextStyle_PL_BOTTOM_LEFT Text_TextStyle_PointerLocation = 10
	// Placed on the bottom of the left side of the widget
	Text_TextStyle_PL_LEFT_BOTTOM Text_TextStyle_PointerLocation = 11
	// Placed on the top of the left side of the widget
	Text_TextStyle_PL_LEFT_TOP Text_TextStyle_PointerLocation = 12
)

// Enum value maps for Text_TextStyle_PointerLocation.
var (
	Text_TextStyle_PointerLocation_name = map[int32]string{
		0:  "POINTER_LOCATION_UNSPECIFIED",
		1:  "PL_TOP",
		2:  "PL_RIGHT",
		3:  "PL_BOTTOM",
		4:  "PL_LEFT",
		5:  "PL_TOP_LEFT",
		6:  "PL_TOP_RIGHT",
		7:  "PL_RIGHT_TOP",
		8:  "PL_RIGHT_BOTTOM",
		9:  "PL_BOTTOM_RIGHT",
		10: "PL_BOTTOM_LEFT",
		11: "PL_LEFT_BOTTOM",
		12: "PL_LEFT_TOP",
	}
	Text_TextStyle_PointerLocation_value = map[string]int32{
		"POINTER_LOCATION_UNSPECIFIED": 0,
		"PL_TOP":                       1,
		"PL_RIGHT":                     2,
		"PL_BOTTOM":                    3,
		"PL_LEFT":                      4,
		"PL_TOP_LEFT":                  5,
		"PL_TOP_RIGHT":                 6,
		"PL_RIGHT_TOP":                 7,
		"PL_RIGHT_BOTTOM":              8,
		"PL_BOTTOM_RIGHT":              9,
		"PL_BOTTOM_LEFT":               10,
		"PL_LEFT_BOTTOM":               11,
		"PL_LEFT_TOP":                  12,
	}
)

func (x Text_TextStyle_PointerLocation) Enum() *Text_TextStyle_PointerLocation {
	p := new(Text_TextStyle_PointerLocation)
	*p = x
	return p
}

func (x Text_TextStyle_PointerLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Text_TextStyle_PointerLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_text_proto_enumTypes[5].Descriptor()
}

func (Text_TextStyle_PointerLocation) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_text_proto_enumTypes[5]
}

func (x Text_TextStyle_PointerLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Text_TextStyle_PointerLocation.Descriptor instead.
func (Text_TextStyle_PointerLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0, 4}
}

// A widget that displays textual content.
type Text struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text content to be displayed.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// How the text content is formatted.
	Format Text_Format `protobuf:"varint,2,opt,name=format,proto3,enum=google.monitoring.dashboard.v1.Text_Format" json:"format,omitempty"`
	// How the text is styled
	Style *Text_TextStyle `protobuf:"bytes,3,opt,name=style,proto3" json:"style,omitempty"`
}

func (x *Text) Reset() {
	*x = Text{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_text_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Text) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Text) ProtoMessage() {}

func (x *Text) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_text_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Text.ProtoReflect.Descriptor instead.
func (*Text) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0}
}

func (x *Text) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Text) GetFormat() Text_Format {
	if x != nil {
		return x.Format
	}
	return Text_FORMAT_UNSPECIFIED
}

func (x *Text) GetStyle() *Text_TextStyle {
	if x != nil {
		return x.Style
	}
	return nil
}

// Properties that determine how the title and content are styled
type Text_TextStyle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The background color as a hex string. "#RRGGBB" or "#RGB"
	BackgroundColor string `protobuf:"bytes,1,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// The text color as a hex string. "#RRGGBB" or "#RGB"
	TextColor string `protobuf:"bytes,2,opt,name=text_color,json=textColor,proto3" json:"text_color,omitempty"`
	// The horizontal alignment of both the title and content
	HorizontalAlignment Text_TextStyle_HorizontalAlignment `protobuf:"varint,3,opt,name=horizontal_alignment,json=horizontalAlignment,proto3,enum=google.monitoring.dashboard.v1.Text_TextStyle_HorizontalAlignment" json:"horizontal_alignment,omitempty"`
	// The vertical alignment of both the title and content
	VerticalAlignment Text_TextStyle_VerticalAlignment `protobuf:"varint,4,opt,name=vertical_alignment,json=verticalAlignment,proto3,enum=google.monitoring.dashboard.v1.Text_TextStyle_VerticalAlignment" json:"vertical_alignment,omitempty"`
	// The amount of padding around the widget
	Padding Text_TextStyle_PaddingSize `protobuf:"varint,5,opt,name=padding,proto3,enum=google.monitoring.dashboard.v1.Text_TextStyle_PaddingSize" json:"padding,omitempty"`
	// Font sizes for both the title and content. The title will still be larger
	// relative to the content.
	FontSize Text_TextStyle_FontSize `protobuf:"varint,6,opt,name=font_size,json=fontSize,proto3,enum=google.monitoring.dashboard.v1.Text_TextStyle_FontSize" json:"font_size,omitempty"`
	// The pointer location for this widget (also sometimes called a "tail")
	PointerLocation Text_TextStyle_PointerLocation `protobuf:"varint,7,opt,name=pointer_location,json=pointerLocation,proto3,enum=google.monitoring.dashboard.v1.Text_TextStyle_PointerLocation" json:"pointer_location,omitempty"`
}

func (x *Text_TextStyle) Reset() {
	*x = Text_TextStyle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_text_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Text_TextStyle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Text_TextStyle) ProtoMessage() {}

func (x *Text_TextStyle) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_text_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Text_TextStyle.ProtoReflect.Descriptor instead.
func (*Text_TextStyle) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Text_TextStyle) GetBackgroundColor() string {
	if x != nil {
		return x.BackgroundColor
	}
	return ""
}

func (x *Text_TextStyle) GetTextColor() string {
	if x != nil {
		return x.TextColor
	}
	return ""
}

func (x *Text_TextStyle) GetHorizontalAlignment() Text_TextStyle_HorizontalAlignment {
	if x != nil {
		return x.HorizontalAlignment
	}
	return Text_TextStyle_HORIZONTAL_ALIGNMENT_UNSPECIFIED
}

func (x *Text_TextStyle) GetVerticalAlignment() Text_TextStyle_VerticalAlignment {
	if x != nil {
		return x.VerticalAlignment
	}
	return Text_TextStyle_VERTICAL_ALIGNMENT_UNSPECIFIED
}

func (x *Text_TextStyle) GetPadding() Text_TextStyle_PaddingSize {
	if x != nil {
		return x.Padding
	}
	return Text_TextStyle_PADDING_SIZE_UNSPECIFIED
}

func (x *Text_TextStyle) GetFontSize() Text_TextStyle_FontSize {
	if x != nil {
		return x.FontSize
	}
	return Text_TextStyle_FONT_SIZE_UNSPECIFIED
}

func (x *Text_TextStyle) GetPointerLocation() Text_TextStyle_PointerLocation {
	if x != nil {
		return x.PointerLocation
	}
	return Text_TextStyle_POINTER_LOCATION_UNSPECIFIED
}

var File_google_monitoring_dashboard_v1_text_proto protoreflect.FileDescriptor

var file_google_monitoring_dashboard_v1_text_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x22, 0xf8, 0x0b, 0x0a, 0x04,
	0x54, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x52, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x1a, 0x91, 0x0a, 0x0a, 0x09, 0x54, 0x65,
	0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x67,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6c,
	0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x12, 0x75, 0x0a, 0x14, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x2e,
	0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x13, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x41,
	0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x12, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x6c, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c,
	0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x07, 0x70, 0x61, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x2e, 0x50, 0x61, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x07, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x54, 0x0a, 0x09, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x2e, 0x46, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x08, 0x66, 0x6f, 0x6e,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x69, 0x0a, 0x10, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x2e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x62, 0x0a, 0x13, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x41, 0x6c,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x4f, 0x52, 0x49, 0x5a,
	0x4f, 0x4e, 0x54, 0x41, 0x4c, 0x5f, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x48, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x48, 0x5f, 0x43,
	0x45, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x5f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x10, 0x03, 0x22, 0x5e, 0x0a, 0x11, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c,
	0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x56, 0x45, 0x52,
	0x54, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x5f, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x5f, 0x43, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x5f, 0x42, 0x4f, 0x54, 0x54,
	0x4f, 0x4d, 0x10, 0x03, 0x22, 0x79, 0x0a, 0x0b, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x53,
	0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x41, 0x5f, 0x53, 0x4d, 0x41,
	0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d,
	0x50, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x41, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x05, 0x22,
	0x78, 0x0a, 0x08, 0x46, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46,
	0x4f, 0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x53, 0x5f, 0x45, 0x58, 0x54,
	0x52, 0x41, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x53,
	0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x53, 0x5f, 0x4d,
	0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x53, 0x5f, 0x4c, 0x41,
	0x52, 0x47, 0x45, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x53, 0x5f, 0x45, 0x58, 0x54, 0x52,
	0x41, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x05, 0x22, 0x81, 0x02, 0x0a, 0x0f, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x1c, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x50, 0x4c, 0x5f, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50,
	0x4c, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x4c, 0x5f,
	0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4c, 0x5f, 0x4c,
	0x45, 0x46, 0x54, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4c, 0x5f, 0x54, 0x4f, 0x50, 0x5f,
	0x4c, 0x45, 0x46, 0x54, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x4c, 0x5f, 0x54, 0x4f, 0x50,
	0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x4c, 0x5f, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x4c,
	0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x10, 0x08, 0x12,
	0x13, 0x0a, 0x0f, 0x50, 0x4c, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f,
	0x4d, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x5f, 0x4c,
	0x45, 0x46, 0x54, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b,
	0x50, 0x4c, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x10, 0x0c, 0x22, 0x37, 0x0a,
	0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x4d, 0x41, 0x52, 0x4b, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x52, 0x41, 0x57, 0x10, 0x02, 0x42, 0xf2, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x54,
	0x65, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x44, 0x61, 0x73,
	0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x5c, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x44, 0x61,
	0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_monitoring_dashboard_v1_text_proto_rawDescOnce sync.Once
	file_google_monitoring_dashboard_v1_text_proto_rawDescData = file_google_monitoring_dashboard_v1_text_proto_rawDesc
)

func file_google_monitoring_dashboard_v1_text_proto_rawDescGZIP() []byte {
	file_google_monitoring_dashboard_v1_text_proto_rawDescOnce.Do(func() {
		file_google_monitoring_dashboard_v1_text_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_dashboard_v1_text_proto_rawDescData)
	})
	return file_google_monitoring_dashboard_v1_text_proto_rawDescData
}

var file_google_monitoring_dashboard_v1_text_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_monitoring_dashboard_v1_text_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_monitoring_dashboard_v1_text_proto_goTypes = []interface{}{
	(Text_Format)(0),                        // 0: google.monitoring.dashboard.v1.Text.Format
	(Text_TextStyle_HorizontalAlignment)(0), // 1: google.monitoring.dashboard.v1.Text.TextStyle.HorizontalAlignment
	(Text_TextStyle_VerticalAlignment)(0),   // 2: google.monitoring.dashboard.v1.Text.TextStyle.VerticalAlignment
	(Text_TextStyle_PaddingSize)(0),         // 3: google.monitoring.dashboard.v1.Text.TextStyle.PaddingSize
	(Text_TextStyle_FontSize)(0),            // 4: google.monitoring.dashboard.v1.Text.TextStyle.FontSize
	(Text_TextStyle_PointerLocation)(0),     // 5: google.monitoring.dashboard.v1.Text.TextStyle.PointerLocation
	(*Text)(nil),                            // 6: google.monitoring.dashboard.v1.Text
	(*Text_TextStyle)(nil),                  // 7: google.monitoring.dashboard.v1.Text.TextStyle
}
var file_google_monitoring_dashboard_v1_text_proto_depIdxs = []int32{
	0, // 0: google.monitoring.dashboard.v1.Text.format:type_name -> google.monitoring.dashboard.v1.Text.Format
	7, // 1: google.monitoring.dashboard.v1.Text.style:type_name -> google.monitoring.dashboard.v1.Text.TextStyle
	1, // 2: google.monitoring.dashboard.v1.Text.TextStyle.horizontal_alignment:type_name -> google.monitoring.dashboard.v1.Text.TextStyle.HorizontalAlignment
	2, // 3: google.monitoring.dashboard.v1.Text.TextStyle.vertical_alignment:type_name -> google.monitoring.dashboard.v1.Text.TextStyle.VerticalAlignment
	3, // 4: google.monitoring.dashboard.v1.Text.TextStyle.padding:type_name -> google.monitoring.dashboard.v1.Text.TextStyle.PaddingSize
	4, // 5: google.monitoring.dashboard.v1.Text.TextStyle.font_size:type_name -> google.monitoring.dashboard.v1.Text.TextStyle.FontSize
	5, // 6: google.monitoring.dashboard.v1.Text.TextStyle.pointer_location:type_name -> google.monitoring.dashboard.v1.Text.TextStyle.PointerLocation
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_monitoring_dashboard_v1_text_proto_init() }
func file_google_monitoring_dashboard_v1_text_proto_init() {
	if File_google_monitoring_dashboard_v1_text_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_dashboard_v1_text_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Text); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_text_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Text_TextStyle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_dashboard_v1_text_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_dashboard_v1_text_proto_goTypes,
		DependencyIndexes: file_google_monitoring_dashboard_v1_text_proto_depIdxs,
		EnumInfos:         file_google_monitoring_dashboard_v1_text_proto_enumTypes,
		MessageInfos:      file_google_monitoring_dashboard_v1_text_proto_msgTypes,
	}.Build()
	File_google_monitoring_dashboard_v1_text_proto = out.File
	file_google_monitoring_dashboard_v1_text_proto_rawDesc = nil
	file_google_monitoring_dashboard_v1_text_proto_goTypes = nil
	file_google_monitoring_dashboard_v1_text_proto_depIdxs = nil
}
