// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package saasservicemgmt provides access to the SaaS Runtime API.
//
// For product documentation, see: https://cloud.google.com/saas-runtime/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/saasservicemgmt/v1beta1"
//	...
//	ctx := context.Background()
//	saasservicemgmtService, err := saasservicemgmt.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	saasservicemgmtService, err := saasservicemgmt.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	saasservicemgmtService, err := saasservicemgmt.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package saasservicemgmt // import "google.golang.org/api/saasservicemgmt/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "saasservicemgmt:v1beta1"
const apiName = "saasservicemgmt"
const apiVersion = "v1beta1"
const basePath = "https://saasservicemgmt.googleapis.com/"
const basePathTemplate = "https://saasservicemgmt.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://saasservicemgmt.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Releases = NewProjectsLocationsReleasesService(s)
	rs.RolloutKinds = NewProjectsLocationsRolloutKindsService(s)
	rs.Rollouts = NewProjectsLocationsRolloutsService(s)
	rs.Saas = NewProjectsLocationsSaasService(s)
	rs.Tenants = NewProjectsLocationsTenantsService(s)
	rs.UnitKinds = NewProjectsLocationsUnitKindsService(s)
	rs.UnitOperations = NewProjectsLocationsUnitOperationsService(s)
	rs.Units = NewProjectsLocationsUnitsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Releases *ProjectsLocationsReleasesService

	RolloutKinds *ProjectsLocationsRolloutKindsService

	Rollouts *ProjectsLocationsRolloutsService

	Saas *ProjectsLocationsSaasService

	Tenants *ProjectsLocationsTenantsService

	UnitKinds *ProjectsLocationsUnitKindsService

	UnitOperations *ProjectsLocationsUnitOperationsService

	Units *ProjectsLocationsUnitsService
}

func NewProjectsLocationsReleasesService(s *Service) *ProjectsLocationsReleasesService {
	rs := &ProjectsLocationsReleasesService{s: s}
	return rs
}

type ProjectsLocationsReleasesService struct {
	s *Service
}

func NewProjectsLocationsRolloutKindsService(s *Service) *ProjectsLocationsRolloutKindsService {
	rs := &ProjectsLocationsRolloutKindsService{s: s}
	return rs
}

type ProjectsLocationsRolloutKindsService struct {
	s *Service
}

func NewProjectsLocationsRolloutsService(s *Service) *ProjectsLocationsRolloutsService {
	rs := &ProjectsLocationsRolloutsService{s: s}
	return rs
}

type ProjectsLocationsRolloutsService struct {
	s *Service
}

func NewProjectsLocationsSaasService(s *Service) *ProjectsLocationsSaasService {
	rs := &ProjectsLocationsSaasService{s: s}
	return rs
}

type ProjectsLocationsSaasService struct {
	s *Service
}

func NewProjectsLocationsTenantsService(s *Service) *ProjectsLocationsTenantsService {
	rs := &ProjectsLocationsTenantsService{s: s}
	return rs
}

type ProjectsLocationsTenantsService struct {
	s *Service
}

func NewProjectsLocationsUnitKindsService(s *Service) *ProjectsLocationsUnitKindsService {
	rs := &ProjectsLocationsUnitKindsService{s: s}
	return rs
}

type ProjectsLocationsUnitKindsService struct {
	s *Service
}

func NewProjectsLocationsUnitOperationsService(s *Service) *ProjectsLocationsUnitOperationsService {
	rs := &ProjectsLocationsUnitOperationsService{s: s}
	return rs
}

type ProjectsLocationsUnitOperationsService struct {
	s *Service
}

func NewProjectsLocationsUnitsService(s *Service) *ProjectsLocationsUnitsService {
	rs := &ProjectsLocationsUnitsService{s: s}
	return rs
}

type ProjectsLocationsUnitsService struct {
	s *Service
}

// Aggregate: Represents the aggregation of a set of population of like records
// by a certain group. For example, a collection of unit counts can be
// aggregated and grouped by their state.
type Aggregate struct {
	// Count: Required. Number of records in the group.
	Count int64 `json:"count,omitempty"`
	// Group: Required. Group by which to aggregate.
	Group string `json:"group,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Aggregate) MarshalJSON() ([]byte, error) {
	type NoMethod Aggregate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Blueprint: Blueprints are OCI Images that contain all of the artifacts
// needed to provision a unit. Metadata such as, type of the engine used to
// actuate the blueprint (e.g. terraform, helm etc) and version will come from
// the image manifest. If the hostname is omitted, it will be assumed to be the
// regional path to Artifact Registry (eg. us-east1-docker.pkg.dev).
type Blueprint struct {
	// Engine: Output only. Type of the engine used to actuate the blueprint. e.g.
	// terraform, helm etc.
	Engine string `json:"engine,omitempty"`
	// Package: Optional. Immutable. URI to a blueprint used by the Unit (required
	// unless unitKind or release is set).
	Package string `json:"package,omitempty"`
	// Version: Output only. Version metadata if present on the blueprint.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Blueprint) MarshalJSON() ([]byte, error) {
	type NoMethod Blueprint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Dependency: Dependency represent a single dependency with another unit kind
// by alias.
type Dependency struct {
	// Alias: Required. An alias for the dependency. Used for input variable
	// mapping.
	Alias string `json:"alias,omitempty"`
	// UnitKind: Required. Immutable. The unit kind of the dependency.
	UnitKind string `json:"unitKind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dependency) MarshalJSON() ([]byte, error) {
	type NoMethod Dependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Deprovision: Deprovision is the unit operation that deprovision the
// underlying resources represented by a Unit. Can only execute if the Unit is
// currently provisioned.
type Deprovision struct {
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ErrorBudget: The configuration for error budget. If the number of failed
// units exceeds max(allowed_count, allowed_ratio * total_units), the rollout
// will be paused.
type ErrorBudget struct {
	// AllowedCount: Optional. The maximum number of failed units allowed in a
	// location without pausing the rollout.
	AllowedCount int64 `json:"allowedCount,omitempty"`
	// AllowedPercentage: Optional. The maximum percentage of units allowed to fail
	// (0, 100] within a location without pausing the rollout.
	AllowedPercentage int64 `json:"allowedPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ErrorBudget) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorBudget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FromMapping: Output variables whose values will be passed on to dependencies
type FromMapping struct {
	// Dependency: Required. Alias of the dependency that the outputVariable will
	// pass its value to
	Dependency string `json:"dependency,omitempty"`
	// OutputVariable: Required. Name of the outputVariable on the dependency
	OutputVariable string `json:"outputVariable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dependency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dependency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FromMapping) MarshalJSON() ([]byte, error) {
	type NoMethod FromMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents a Google Cloud
// location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReleasesResponse: The response structure for the ListReleases method.
type ListReleasesResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListReleases call to list the next page. If empty, there are no
	// more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Releases: The resulting releases.
	Releases []*Release `json:"releases,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReleasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReleasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRolloutKindsResponse: The response structure for the ListRolloutKinds
// method.
type ListRolloutKindsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListRolloutKinds call to list the next page. If empty, there are
	// no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RolloutKinds: The resulting rollout kinds.
	RolloutKinds []*RolloutKind `json:"rolloutKinds,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRolloutKindsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRolloutKindsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRolloutsResponse: The response structure for the ListRollouts method.
type ListRolloutsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListRollouts call to list the next page. If empty, there are no
	// more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Rollouts: The resulting rollouts.
	Rollouts []*Rollout `json:"rollouts,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRolloutsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRolloutsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSaasResponse: The response structure for the ListSaas method.
type ListSaasResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListSaas call to list the next page. If empty, there are no more
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Saas: The resulting saas.
	Saas []*Saas `json:"saas,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSaasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSaasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTenantsResponse: The response structure for the ListTenants method.
type ListTenantsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListTenants call to list the next page. If empty, there are no
	// more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tenants: The resulting tenants.
	Tenants []*Tenant `json:"tenants,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTenantsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTenantsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUnitKindsResponse: The response structure for the ListUnitKinds method.
type ListUnitKindsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListUnitKinds call to list the next page. If empty, there are no
	// more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UnitKinds: The resulting unit kinds.
	UnitKinds []*UnitKind `json:"unitKinds,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUnitKindsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUnitKindsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUnitOperationsResponse: The response structure for the
// ListUnitOperations method.
type ListUnitOperationsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListUnitOperations call to list the next page. If empty, there
	// are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UnitOperations: The resulting unit operations.
	UnitOperations []*UnitOperation `json:"unitOperations,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUnitOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUnitOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListUnitsResponse: The response structure for the ListUnits method.
type ListUnitsResponse struct {
	// NextPageToken: If present, the next page token can be provided to a
	// subsequent ListUnits call to list the next page. If empty, there are no more
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Units: The resulting units.
	Units []*Unit `json:"units,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUnitsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUnitsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: Location information that the service is available in.
type Location struct {
	// Name: Optional. Name of location.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceSettings: Captures requested directives for performing future
// maintenance on the unit. This includes a request for the unit to skip
// maintenance for a period of time and remain pinned to its current release as
// well as controls for postponing maintenance scheduled in future.
type MaintenanceSettings struct {
	// PinnedUntilTime: Optional. If present, it fixes the release on the unit
	// until the given time; i.e. changes to the release field will be rejected.
	// Rollouts should and will also respect this by not requesting an upgrade in
	// the first place.
	PinnedUntilTime string `json:"pinnedUntilTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PinnedUntilTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PinnedUntilTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Provision: Provision is the unit operation that provision the underlying
// resources represented by a Unit. Can only execute if the Unit is not
// currently provisioned.
type Provision struct {
	// InputVariables: Optional. Set of input variables. Maximum 100. (optional)
	InputVariables []*UnitVariable `json:"inputVariables,omitempty"`
	// Release: Optional. Reference to the Release object to use for the Unit.
	// (optional).
	Release string `json:"release,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputVariables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputVariables") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Provision) MarshalJSON() ([]byte, error) {
	type NoMethod Provision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Release: A new version to be propagated and deployed to units. This includes
// pointers to packaged blueprints for actuation (e.g Helm or Terraform
// configuration packages) via artifact registry.
type Release struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// Blueprint: Optional. Blueprints are OCI Images that contain all of the
	// artifacts needed to provision a unit.
	Blueprint *Blueprint `json:"blueprint,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// InputVariableDefaults: Optional. Mapping of input variables to default
	// values. Maximum 100
	InputVariableDefaults []*UnitVariable `json:"inputVariableDefaults,omitempty"`
	// InputVariables: Optional. Output only. List of input variables declared on
	// the blueprint and can be present with their values on the unit spec
	InputVariables []*UnitVariable `json:"inputVariables,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/releases/{release}"
	Name string `json:"name,omitempty"`
	// OutputVariables: Optional. Output only. List of output variables declared on
	// the blueprint and can be present with their values on the unit status
	OutputVariables []*UnitVariable `json:"outputVariables,omitempty"`
	// ReleaseRequirements: Optional. Set of requirements to be fulfilled on the
	// Unit when using this Release.
	ReleaseRequirements *ReleaseRequirements `json:"releaseRequirements,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UnitKind: Required. Immutable. Reference to the UnitKind this Release
	// corresponds to (required and immutable once created).
	UnitKind string `json:"unitKind,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Release) MarshalJSON() ([]byte, error) {
	type NoMethod Release
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReleaseRequirements: Set of requirements to be fulfilled on the Unit when
// using this Release.
type ReleaseRequirements struct {
	// UpgradeableFromReleases: Optional. A list of releases from which a unit can
	// be upgraded to this one (optional). If left empty no constraints will be
	// applied. When provided, unit upgrade requests to this release will check and
	// enforce this constraint.
	UpgradeableFromReleases []string `json:"upgradeableFromReleases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpgradeableFromReleases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpgradeableFromReleases") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReleaseRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod ReleaseRequirements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Rollout: Represents a single rollout execution and its results
type Rollout struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// Control: Optional. Requested change to the execution of this rollout.
	// Default RolloutControl.action is ROLLOUT_ACTION_RUN meaning the rollout will
	// be executed to completion while progressing through all natural Rollout
	// States (such as RUNNING -> SUCCEEDED or RUNNING -> FAILED). Requests can
	// only be made when the Rollout is in a non-terminal state.
	Control *RolloutControl `json:"control,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Optional. Output only. The time when the rollout finished execution
	// (regardless of success, failure, or cancellation). Will be empty if the
	// rollout hasn't finished yet. Once set, the rollout is in terminal state and
	// all the results are final.
	EndTime string `json:"endTime,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/rollout/{rollout_id}"
	Name string `json:"name,omitempty"`
	// ParentRollout: Optional. Output only. The direct parent rollout that this
	// rollout is stemming from. The resource name (full URI of the resource)
	// following the standard naming scheme:
	// "projects/{project}/locations/{location}/rollouts/{rollout_id}"
	ParentRollout string `json:"parentRollout,omitempty"`
	// Release: Optional. Immutable. Name of the Release that gets rolled out to
	// target Units. Required if no other type of release is specified.
	Release string `json:"release,omitempty"`
	// RolloutKind: Optional. Immutable. Name of the RolloutKind this rollout is
	// stemming from and adhering to.
	RolloutKind string `json:"rolloutKind,omitempty"`
	// RolloutOrchestrationStrategy: Optional. The strategy used for executing this
	// Rollout. This strategy will override whatever strategy is specified in the
	// RolloutType. If not specified on creation, the strategy from RolloutType
	// will be used. There are two supported values strategies which are used to
	// control - "Google.Cloud.Simple.AllAtOnce" -
	// "Google.Cloud.Simple.OneLocationAtATime" A rollout with one of these simple
	// strategies will rollout across all locations defined in the targeted
	// UnitKind's Saas Locations.
	RolloutOrchestrationStrategy string `json:"rolloutOrchestrationStrategy,omitempty"`
	// RootRollout: Optional. Output only. The root rollout that this rollout is
	// stemming from. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/rollouts/{rollout_id}"
	RootRollout string `json:"rootRollout,omitempty"`
	// StartTime: Optional. Output only. The time when the rollout started
	// executing. Will be empty if the rollout hasn't started yet.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. Current state of the rollout.
	//
	// Possible values:
	//   "ROLLOUT_STATE_UNSPECIFIED" - Unspecified state.
	//   "ROLLOUT_STATE_RUNNING" - Rollout is in progress.
	//   "ROLLOUT_STATE_PAUSED" - Rollout has been paused.
	//   "ROLLOUT_STATE_SUCCEEDED" - Rollout completed successfully.
	//   "ROLLOUT_STATE_FAILED" - Rollout has failed.
	//   "ROLLOUT_STATE_CANCELLED" - Rollout has been canceled.
	//   "ROLLOUT_STATE_WAITING" - Rollout is waiting for some condition to be met
	// before starting.
	//   "ROLLOUT_STATE_CANCELLING" - Rollout is being canceled.
	//   "ROLLOUT_STATE_RESUMING" - Rollout is being resumed.
	//   "ROLLOUT_STATE_PAUSING" - Rollout is being paused.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. Human readable message indicating details about
	// the last state transition.
	StateMessage string `json:"stateMessage,omitempty"`
	// StateTransitionTime: Optional. Output only. The time when the rollout
	// transitioned into its current state.
	StateTransitionTime string `json:"stateTransitionTime,omitempty"`
	// Stats: Optional. Output only. Details about the progress of the rollout.
	Stats *RolloutStats `json:"stats,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UnitFilter: Optional. CEL(https://github.com/google/cel-spec) formatted
	// filter string against Unit. The filter will be applied to determine the
	// eligible unit population. This filter can only reduce, but not expand the
	// scope of the rollout. If not provided, the unit_filter from the RolloutType
	// will be used.
	UnitFilter string `json:"unitFilter,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Rollout) MarshalJSON() ([]byte, error) {
	type NoMethod Rollout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutControl: RolloutControl provides a way to request a change to the
// execution of a Rollout by pausing or canceling it.
type RolloutControl struct {
	// Action: Required. Action to be performed on the Rollout. The default
	// behavior is to run the rollout until it naturally reaches a terminal state.
	//
	// Possible values:
	//   "ROLLOUT_ACTION_UNSPECIFIED" - Unspecified action, will be treated as RUN
	// by default.
	//   "ROLLOUT_ACTION_RUN" - Run the Rollout until it naturally reaches a
	// terminal state. A rollout requested to run will progress through all natural
	// Rollout States (such as RUNNING -> SUCCEEDED or RUNNING -> FAILED). If
	// retriable errors are encountered during the rollout, the rollout will paused
	// by default and can be resumed by re-requesting this RUN action.
	//   "ROLLOUT_ACTION_PAUSE" - Pause the Rollout until it is resumed (i.e. RUN
	// is requested).
	//   "ROLLOUT_ACTION_CANCEL" - Cancel the Rollout permanently.
	Action string `json:"action,omitempty"`
	// RunParams: Optional. Parameters for the RUN action. It is an error to
	// specify this if the RolloutAction is not set to RUN. By default, the rollout
	// will retry failed operations when resumed.
	RunParams *RunRolloutActionParams `json:"runParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutControl) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutKind: An object that describes various settings of Rollout execution.
// Includes built-in policies across GCP and GDC, and customizable policies.
type RolloutKind struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// ErrorBudget: Optional. The configuration for error budget. If the number of
	// failed units exceeds max(allowed_count, allowed_ratio * total_units), the
	// rollout will be paused. If not set, all units will be attempted to be
	// updated regardless of the number of failures encountered.
	ErrorBudget *ErrorBudget `json:"errorBudget,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
	Name string `json:"name,omitempty"`
	// RolloutOrchestrationStrategy: Optional. The strategy used for executing a
	// Rollout. This is a required field. There are two supported values strategies
	// which are used to control - "Google.Cloud.Simple.AllAtOnce" -
	// "Google.Cloud.Simple.OneLocationAtATime" A rollout with one of these simple
	// strategies will rollout across all locations defined in the associated
	// UnitKind's Saas Locations.
	RolloutOrchestrationStrategy string `json:"rolloutOrchestrationStrategy,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UnitFilter: Optional. CEL(https://github.com/google/cel-spec) formatted
	// filter string against Unit. The filter will be applied to determine the
	// eligible unit population. This filter can only reduce, but not expand the
	// scope of the rollout.
	UnitFilter string `json:"unitFilter,omitempty"`
	// UnitKind: Required. Immutable. UnitKind that this rollout kind corresponds
	// to. Rollouts stemming from this rollout kind will target the units of this
	// unit kind. In other words, this defines the population of target units to be
	// upgraded by rollouts.
	UnitKind string `json:"unitKind,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`
	// UpdateUnitKindStrategy: Optional. The config for updating the unit kind. By
	// default, the unit kind will be updated on the rollout start.
	//
	// Possible values:
	//   "UPDATE_UNIT_KIND_STRATEGY_UNSPECIFIED" - Strategy unspecified.
	//   "UPDATE_UNIT_KIND_STRATEGY_ON_START" - Update the unit kind strategy on
	// the rollout start.
	//   "UPDATE_UNIT_KIND_STRATEGY_NEVER" - Never update the unit kind.
	UpdateUnitKindStrategy string `json:"updateUnitKindStrategy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutKind) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutKind
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RolloutStats: RolloutStats contains information about the progress of a
// rollout.
type RolloutStats struct {
	// OperationsByState: Output only. A breakdown of the progress of operations
	// triggered by the rollout. Provides a count of Operations by their state.
	// This can be used to determine the number of units which have been updated,
	// or are scheduled to be updated. There will be at most one entry per group.
	// Possible values for operation groups are: - "SCHEDULED" - "PENDING" -
	// "RUNNING" - "SUCCEEDED" - "FAILED" - "CANCELLED"
	OperationsByState []*Aggregate `json:"operationsByState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationsByState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationsByState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RolloutStats) MarshalJSON() ([]byte, error) {
	type NoMethod RolloutStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunRolloutActionParams: Parameters for the RUN action controlling the
// behavior of the rollout when it is resumed from a PAUSED state.
type RunRolloutActionParams struct {
	// RetryFailedOperations: Required. If true, the rollout will retry failed
	// operations when resumed. This is applicable only the current state of the
	// Rollout is PAUSED and the requested action is RUN.
	RetryFailedOperations bool `json:"retryFailedOperations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetryFailedOperations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetryFailedOperations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunRolloutActionParams) MarshalJSON() ([]byte, error) {
	type NoMethod RunRolloutActionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Saas: Saas is a representation of a SaaS service managed by the Producer.
type Saas struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Locations: Optional. Immutable. List of locations that the service is
	// available in. Rollout refers to the list to generate a rollout plan.
	Locations []*Location `json:"locations,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/saas/{saas}"
	Name string `json:"name,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Saas) MarshalJSON() ([]byte, error) {
	type NoMethod Saas
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schedule: A time specification to schedule the maintenance.
type Schedule struct {
	// StartTime: Optional. Start of operation. If not set, will be set to the
	// start of the next window. (optional)
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tenant: Tenant represents the service producer side of an instance of the
// service created based on a request from a consumer. In a typical scenario a
// Tenant has a one-to-one mapping with a resource given out to a service
// consumer. Example: tenant: name:
// "projects/svc1/locations/loc/tenants/inst-068afff8" consumer_resource:
// "projects/gshoe/locations/loc/shoes/black-shoe"
type Tenant struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// ConsumerResource: Optional. Immutable. A reference to the consumer resource
	// this SaaS Tenant is representing. The relationship with a consumer resource
	// can be used by EasySaaS for retrieving consumer-defined settings and
	// policies such as maintenance policies (using Unified Maintenance Policy
	// API).
	ConsumerResource string `json:"consumerResource,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/tenants/{tenant}"
	Name string `json:"name,omitempty"`
	// Saas: Required. Immutable. A reference to the Saas that defines the product
	// (managed service) that the producer wants to manage with EasySaaS. Part of
	// the EasySaaS common data model.
	Saas string `json:"saas,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tenant) MarshalJSON() ([]byte, error) {
	type NoMethod Tenant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToMapping: Input variables whose values will be passed on to dependencies
type ToMapping struct {
	// Dependency: Required. Alias of the dependency that the inputVariable will
	// pass its value to
	Dependency string `json:"dependency,omitempty"`
	// IgnoreForLookup: Optional. Tells EasySaaS if this mapping should be used
	// during lookup or not
	IgnoreForLookup bool `json:"ignoreForLookup,omitempty"`
	// InputVariable: Required. Name of the inputVariable on the dependency
	InputVariable string `json:"inputVariable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dependency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dependency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToMapping) MarshalJSON() ([]byte, error) {
	type NoMethod ToMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Unit: A unit of deployment that has its lifecycle via a CRUD API using an
// actuation engine under the hood (e.g. based on Terraform, Helm or a custom
// implementation provided by a service producer). A building block of a SaaS
// Tenant.
type Unit struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// Conditions: Optional. Output only. A set of conditions which indicate the
	// various conditions this resource can have.
	Conditions []*UnitCondition `json:"conditions,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dependencies: Optional. Output only. Set of dependencies for this unit.
	// Maximum 10.
	Dependencies []*UnitDependency `json:"dependencies,omitempty"`
	// Dependents: Optional. Output only. List of Units that depend on this unit.
	// Unit can only be deprovisioned if this list is empty. Maximum 1000.
	Dependents []*UnitDependency `json:"dependents,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// InputVariables: Optional. Output only. Indicates the current input variables
	// deployed by the unit
	InputVariables []*UnitVariable `json:"inputVariables,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Maintenance: Optional. Captures requested directives for performing future
	// maintenance on the unit. This includes a request for the unit to skip
	// maintenance for a period of time and remain pinned to its current release as
	// well as controls for postponing maintenance scheduled in future.
	Maintenance *MaintenanceSettings `json:"maintenance,omitempty"`
	// ManagementMode: Optional. Immutable. Indicates whether the Unit life cycle
	// is controlled by the user or by the system. Immutable once created.
	//
	// Possible values:
	//   "MANAGEMENT_MODE_UNSPECIFIED"
	//   "MANAGEMENT_MODE_USER" - Unit's lifecycle is managed by the user.
	//   "MANAGEMENT_MODE_SYSTEM" - The system will decide when to deprovision and
	// delete the unit. User still can deprovision or delete the unit manually.
	ManagementMode string `json:"managementMode,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/units/{unit}"
	Name string `json:"name,omitempty"`
	// OngoingOperations: Optional. Output only. List of concurrent UnitOperations
	// that are operating on this Unit.
	OngoingOperations []string `json:"ongoingOperations,omitempty"`
	// OutputVariables: Optional. Output only. Set of key/value pairs corresponding
	// to output variables from execution of actuation templates. The variables are
	// declared in actuation configs (e.g in helm chart or terraform) and the
	// values are fetched and returned by the actuation engine upon completion of
	// execution.
	OutputVariables []*UnitVariable `json:"outputVariables,omitempty"`
	// PendingOperations: Optional. Output only. List of pending (wait to be
	// executed) UnitOperations for this unit.
	PendingOperations []string `json:"pendingOperations,omitempty"`
	// Release: Optional. Output only. The current Release object for this Unit.
	Release string `json:"release,omitempty"`
	// ScheduledOperations: Optional. Output only. List of scheduled UnitOperations
	// for this unit.
	ScheduledOperations []string `json:"scheduledOperations,omitempty"`
	// State: Optional. Output only. Current lifecycle state of the resource (e.g.
	// if it's being created or ready to use).
	//
	// Possible values:
	//   "UNIT_STATE_UNSPECIFIED" - Unspecified state.
	//   "UNIT_STATE_NOT_PROVISIONED" - Unit is not provisioned.
	//   "UNIT_STATE_PROVISIONING" - Unit is being provisioned.
	//   "UNIT_STATE_UPDATING" - Unit is being updated. This is typically when a
	// unit is being upgraded to a new release or some of the input variables on
	// the Unit is being changed. Certain kinds of updates may cause the Unit to
	// become unusable while the update is in progress.
	//   "UNIT_STATE_DEPROVISIONING" - Unit is being deleted.
	//   "UNIT_STATE_READY" - Unit has been provisioned and is ready for use
	//   "UNIT_STATE_ERROR" - Unit has error, when it is not ready and some error
	// operation
	State string `json:"state,omitempty"`
	// SystemCleanupAt: Optional. Output only. If set, indicates the time when the
	// system will start removing the unit.
	SystemCleanupAt string `json:"systemCleanupAt,omitempty"`
	// SystemManagedState: Optional. Output only. Indicates the system managed
	// state of the unit.
	//
	// Possible values:
	//   "SYSTEM_MANAGED_STATE_UNSPECIFIED"
	//   "SYSTEM_MANAGED_STATE_ACTIVE" - Unit has dependents attached.
	//   "SYSTEM_MANAGED_STATE_INACTIVE" - Unit has no dependencies attached, but
	// attachment is allowed.
	//   "SYSTEM_MANAGED_STATE_DECOMMISSIONED" - Unit has no dependencies attached,
	// and attachment is not allowed.
	SystemManagedState string `json:"systemManagedState,omitempty"`
	// Tenant: Optional. Reference to the Saas Tenant resource this unit belongs
	// to. This for example informs the maintenance policies to use for scheduling
	// future updates on a unit. (optional and immutable once created)
	Tenant string `json:"tenant,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UnitKind: Optional. Reference to the UnitKind this Unit belongs to.
	// Immutable once set.
	UnitKind string `json:"unitKind,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Unit) MarshalJSON() ([]byte, error) {
	type NoMethod Unit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitCondition: UnitCondition describes the status of an Unit. UnitCondition
// is individual components that contribute to an overall state.
type UnitCondition struct {
	// LastTransitionTime: Required. Last time the condition transited from one
	// status to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`
	// Message: Required. Human readable message indicating details about the last
	// transition.
	Message string `json:"message,omitempty"`
	// Reason: Required. Brief reason for the condition's last transition.
	Reason string `json:"reason,omitempty"`
	// Status: Required. Status of the condition.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Condition status is unspecified.
	//   "STATUS_UNKNOWN" - Condition is unknown.
	//   "STATUS_TRUE" - Condition is true.
	//   "STATUS_FALSE" - Condition is false.
	Status string `json:"status,omitempty"`
	// Type: Required. Type of the condition.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Condition type is unspecified.
	//   "TYPE_READY" - Condition type is ready.
	//   "TYPE_UPDATING" - Condition type is updating.
	//   "TYPE_PROVISIONED" - Condition type is provisioned.
	//   "TYPE_OPERATION_ERROR" - Condition type is operationError. True when the
	// last unit operation fails with a non-ignorable error.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastTransitionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastTransitionTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitCondition) MarshalJSON() ([]byte, error) {
	type NoMethod UnitCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitDependency: Set of dependencies for this unit. Maximum 10.
type UnitDependency struct {
	// Alias: Output only. Alias for the name of the dependency.
	Alias string `json:"alias,omitempty"`
	// Unit: Output only. A reference to the Unit object.
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitDependency) MarshalJSON() ([]byte, error) {
	type NoMethod UnitDependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitKind: Definition of a Unit. Units belonging to the same UnitKind are
// managed together; for example they follow the same release model
// (blueprints, versions etc.) and are typically rolled out together.
type UnitKind struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultRelease: Optional. A reference to the Release object to use as
	// default for creating new units of this UnitKind (optional). If not
	// specified, a new unit must explicitly reference which release to use for its
	// creation.
	DefaultRelease string `json:"defaultRelease,omitempty"`
	// Dependencies: Optional. Immutable. List of other unit kinds that this
	// release will depend on. Dependencies will be automatically provisioned if
	// not found. Maximum 10.
	Dependencies []*Dependency `json:"dependencies,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// InputVariableMappings: Optional. List of inputVariables for this release
	// that will either be retrieved from a dependency’s outputVariables, or will
	// be passed on to a dependency’s inputVariables. Maximum 100.
	InputVariableMappings []*VariableMapping `json:"inputVariableMappings,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/unitKinds/{unitKind}"
	Name string `json:"name,omitempty"`
	// OutputVariableMappings: Optional. List of outputVariables for this unit kind
	// will be passed to this unit's outputVariables. Maximum 100.
	OutputVariableMappings []*VariableMapping `json:"outputVariableMappings,omitempty"`
	// Saas: Required. Immutable. A reference to the Saas that defines the product
	// (managed service) that the producer wants to manage with EasySaaS. Part of
	// the EasySaaS common data model. Immutable once set.
	Saas string `json:"saas,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitKind) MarshalJSON() ([]byte, error) {
	type NoMethod UnitKind
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitOperation: UnitOperation encapsulates the intent of changing/interacting
// with the service component represented by the specific Unit. Multiple
// UnitOperations can be created (requested) and scheduled in the future,
// however only one will be allowed to execute at a time (that can change in
// the future for non-mutating operations). UnitOperations allow different
// actors interacting with the same unit to focus only on the change they have
// requested. This is a base object that contains the common fields in all unit
// operations.
type UnitOperation struct {
	// Annotations: Optional. Annotations is an unstructured key-value map stored
	// with a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved when
	// modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`
	// Cancel: Optional. When true, attempt to cancel the operation. Cancellation
	// may fail if the operation is already executing. (Optional)
	Cancel bool `json:"cancel,omitempty"`
	// Conditions: Optional. Output only. A set of conditions which indicate the
	// various conditions this resource can have.
	Conditions []*UnitOperationCondition `json:"conditions,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime  string       `json:"createTime,omitempty"`
	Deprovision *Deprovision `json:"deprovision,omitempty"`
	// EngineState: Optional. Output only. The engine state for on-going deployment
	// engine operation(s). This field is opaque for external usage.
	EngineState string `json:"engineState,omitempty"`
	// ErrorCategory: Optional. Output only. UnitOperationErrorCategory describe
	// the error category.
	//
	// Possible values:
	//   "UNIT_OPERATION_ERROR_CATEGORY_UNSPECIFIED" - Unit operation error
	// category is unspecified
	//   "NOT_APPLICABLE" - Unit operation error category is not applicable, or it
	// is not an error
	//   "FATAL" - Unit operation error category is fatal
	//   "RETRIABLE" - Unit operation error category is retriable
	//   "IGNORABLE" - Unit operation error category is ignorable
	//   "STANDARD" - Unit operation error category is standard, counts towards
	// Rollout error budget
	ErrorCategory string `json:"errorCategory,omitempty"`
	// Etag: Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client and
	// server agree on the ordering of a resource being written.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels on the resource, which can be used for
	// categorization. similar to Kubernetes resource labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name (full URI of the resource) following the
	// standard naming scheme:
	// "projects/{project}/locations/{location}/unitOperations/{unitOperation}"
	Name string `json:"name,omitempty"`
	// ParentUnitOperation: Optional. Reference to parent resource: UnitOperation.
	// If an operation needs to create other operations as part of its workflow,
	// each of the child operations should have this field set to the parent. This
	// can be used for tracing. (Optional)
	ParentUnitOperation string     `json:"parentUnitOperation,omitempty"`
	Provision           *Provision `json:"provision,omitempty"`
	// Rollout: Optional. Specifies which rollout created this Unit Operation. This
	// cannot be modified and is used for filtering purposes only. If a dependent
	// unit and unit operation are created as part of another unit operation, they
	// will use the same rolloutId.
	Rollout string `json:"rollout,omitempty"`
	// Schedule: Optional. When to schedule this operation.
	Schedule *Schedule `json:"schedule,omitempty"`
	// State: Optional. Output only. UnitOperationState describes the current state
	// of the unit operation.
	//
	// Possible values:
	//   "UNIT_OPERATION_STATE_UNKNOWN"
	//   "UNIT_OPERATION_STATE_PENDING" - Unit operation is accepted but not ready
	// to run.
	//   "UNIT_OPERATION_STATE_SCHEDULED" - Unit operation is accepted and
	// scheduled.
	//   "UNIT_OPERATION_STATE_RUNNING" - Unit operation is running.
	//   "UNIT_OPERATION_STATE_SUCCEEDED" - Unit operation has completed
	// successfully.
	//   "UNIT_OPERATION_STATE_FAILED" - Unit operation has failed.
	//   "UNIT_OPERATION_STATE_CANCELLED" - Unit operation was cancelled.
	State string `json:"state,omitempty"`
	// Uid: Output only. The unique identifier of the resource. UID is unique in
	// the time and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource and
	// must not be changed. UID is used to uniquely identify resources with
	// resource name reuses. This should be a UUID4.
	Uid string `json:"uid,omitempty"`
	// Unit: Required. Immutable. The Unit a given UnitOperation will act upon.
	Unit string `json:"unit,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	// Any change to the resource made by users must refresh this value. Changes to
	// a resource made by the service should refresh this value.
	UpdateTime string   `json:"updateTime,omitempty"`
	Upgrade    *Upgrade `json:"upgrade,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitOperation) MarshalJSON() ([]byte, error) {
	type NoMethod UnitOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitOperationCondition: UnitOperationCondition describes the status of an
// Unit Operation. UnitOperationCondition is individual components that
// contribute to an overall state.
type UnitOperationCondition struct {
	// LastTransitionTime: Required. Last time the condition transited from one
	// status to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`
	// Message: Required. Human readable message indicating details about the last
	// transition.
	Message string `json:"message,omitempty"`
	// Reason: Required. Brief reason for the condition's last transition.
	Reason string `json:"reason,omitempty"`
	// Status: Required. Status of the condition.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Condition status is unspecified.
	//   "STATUS_UNKNOWN" - Condition is unknown.
	//   "STATUS_TRUE" - Condition is true.
	//   "STATUS_FALSE" - Condition is false.
	Status string `json:"status,omitempty"`
	// Type: Required. Type of the condition.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Condition type is unspecified.
	//   "TYPE_SCHEDULED" - Condition type is scheduled.
	//   "TYPE_RUNNING" - Condition type is running.
	//   "TYPE_SUCCEEDED" - Condition type is succeeded.
	//   "TYPE_CANCELLED" - Condition type is cancelled.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastTransitionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastTransitionTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitOperationCondition) MarshalJSON() ([]byte, error) {
	type NoMethod UnitOperationCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnitVariable: UnitVariable describes a parameter for a Unit.
type UnitVariable struct {
	// Type: Optional. Immutable. Name of a supported variable type. Supported
	// types are string, int, bool.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Variable type is unspecified.
	//   "STRING" - Variable type is string.
	//   "INT" - Variable type is int.
	//   "BOOL" - Variable type is bool.
	Type string `json:"type,omitempty"`
	// Value: Optional. String encoded value for the variable.
	Value string `json:"value,omitempty"`
	// Variable: Required. Immutable. Name of the variable from actuation configs.
	Variable string `json:"variable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnitVariable) MarshalJSON() ([]byte, error) {
	type NoMethod UnitVariable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Upgrade: Upgrade is the unit operation that upgrades a provisioned unit,
// which may also include the underlying resources represented by a Unit. Can
// only execute if the Unit is currently provisioned.
type Upgrade struct {
	// InputVariables: Optional. Set of input variables. Maximum 100. (optional)
	InputVariables []*UnitVariable `json:"inputVariables,omitempty"`
	// Release: Optional. Reference to the Release object to use for the Unit.
	// (optional).
	Release string `json:"release,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputVariables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputVariables") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Upgrade) MarshalJSON() ([]byte, error) {
	type NoMethod Upgrade
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VariableMapping: Mapping of input variables to their respective output
// variable for depedenencies
type VariableMapping struct {
	// From: Optional. Output variables which will get their values from
	// dependencies
	From *FromMapping `json:"from,omitempty"`
	// To: Optional. Input variables whose values will be passed on to
	// dependencies.
	To *ToMapping `json:"to,omitempty"`
	// Variable: Required. name of the variable
	Variable string `json:"variable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "From") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "From") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VariableMapping) MarshalJSON() ([]byte, error) {
	type NoMethod VariableMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReleasesCreateCall struct {
	s          *Service
	parent     string
	release    *Release
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new release.
//
// - parent: The parent of the release.
func (r *ProjectsLocationsReleasesService) Create(parent string, release *Release) *ProjectsLocationsReleasesCreateCall {
	c := &ProjectsLocationsReleasesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.release = release
	return c
}

// ReleaseId sets the optional parameter "releaseId": Required. The ID value
// for the new release.
func (c *ProjectsLocationsReleasesCreateCall) ReleaseId(releaseId string) *ProjectsLocationsReleasesCreateCall {
	c.urlParams_.Set("releaseId", releaseId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReleasesCreateCall) RequestId(requestId string) *ProjectsLocationsReleasesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsReleasesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsReleasesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReleasesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReleasesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReleasesCreateCall) Context(ctx context.Context) *ProjectsLocationsReleasesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReleasesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReleasesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.release)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/releases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.releases.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Release.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReleasesCreateCall) Do(opts ...googleapi.CallOption) (*Release, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Release{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReleasesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single release.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsReleasesService) Delete(name string) *ProjectsLocationsReleasesDeleteCall {
	c := &ProjectsLocationsReleasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the release. This is used with state-changing methods
// to prevent accidental overwrites when multiple user agents might be acting
// in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the release. The Any wildcard
// (`*`) requires that the resource must already exists, and the Not Any
// wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsReleasesDeleteCall) Etag(etag string) *ProjectsLocationsReleasesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReleasesDeleteCall) RequestId(requestId string) *ProjectsLocationsReleasesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsReleasesDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsReleasesDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReleasesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReleasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReleasesDeleteCall) Context(ctx context.Context) *ProjectsLocationsReleasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReleasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReleasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.releases.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReleasesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReleasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single release.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsReleasesService) Get(name string) *ProjectsLocationsReleasesGetCall {
	c := &ProjectsLocationsReleasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReleasesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReleasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReleasesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReleasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReleasesGetCall) Context(ctx context.Context) *ProjectsLocationsReleasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReleasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReleasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.releases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Release.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReleasesGetCall) Do(opts ...googleapi.CallOption) (*Release, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Release{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReleasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of releases.
//
// - parent: The parent of the release.
func (r *ProjectsLocationsReleasesService) List(parent string) *ProjectsLocationsReleasesListCall {
	c := &ProjectsLocationsReleasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsReleasesListCall) Filter(filter string) *ProjectsLocationsReleasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsReleasesListCall) OrderBy(orderBy string) *ProjectsLocationsReleasesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// releases to send per page.
func (c *ProjectsLocationsReleasesListCall) PageSize(pageSize int64) *ProjectsLocationsReleasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsReleasesListCall) PageToken(pageToken string) *ProjectsLocationsReleasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReleasesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReleasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReleasesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReleasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReleasesListCall) Context(ctx context.Context) *ProjectsLocationsReleasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReleasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReleasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/releases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.releases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReleasesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsReleasesListCall) Do(opts ...googleapi.CallOption) (*ListReleasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReleasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReleasesListCall) Pages(ctx context.Context, f func(*ListReleasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReleasesPatchCall struct {
	s          *Service
	name       string
	release    *Release
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single release.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/releases/{release}".
func (r *ProjectsLocationsReleasesService) Patch(name string, release *Release) *ProjectsLocationsReleasesPatchCall {
	c := &ProjectsLocationsReleasesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.release = release
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReleasesPatchCall) RequestId(requestId string) *ProjectsLocationsReleasesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Release resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields in the Release will be
// overwritten.
func (c *ProjectsLocationsReleasesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsReleasesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsReleasesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsReleasesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReleasesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsReleasesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReleasesPatchCall) Context(ctx context.Context) *ProjectsLocationsReleasesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReleasesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReleasesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.release)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.releases.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Release.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReleasesPatchCall) Do(opts ...googleapi.CallOption) (*Release, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Release{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.releases.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutKindsCreateCall struct {
	s           *Service
	parent      string
	rolloutkind *RolloutKind
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Create a new rollout kind.
//
// - parent: The parent of the rollout kind.
func (r *ProjectsLocationsRolloutKindsService) Create(parent string, rolloutkind *RolloutKind) *ProjectsLocationsRolloutKindsCreateCall {
	c := &ProjectsLocationsRolloutKindsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rolloutkind = rolloutkind
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutKindsCreateCall) RequestId(requestId string) *ProjectsLocationsRolloutKindsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// RolloutKindId sets the optional parameter "rolloutKindId": Required. The ID
// value for the new rollout kind.
func (c *ProjectsLocationsRolloutKindsCreateCall) RolloutKindId(rolloutKindId string) *ProjectsLocationsRolloutKindsCreateCall {
	c.urlParams_.Set("rolloutKindId", rolloutKindId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutKindsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutKindsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutKindsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutKindsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutKindsCreateCall) Context(ctx context.Context) *ProjectsLocationsRolloutKindsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutKindsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutKindsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rolloutkind)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/rolloutKinds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rolloutKinds.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *RolloutKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutKindsCreateCall) Do(opts ...googleapi.CallOption) (*RolloutKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RolloutKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutKindsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single rollout kind.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsRolloutKindsService) Delete(name string) *ProjectsLocationsRolloutKindsDeleteCall {
	c := &ProjectsLocationsRolloutKindsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the rollout kind. This is used with state-changing
// methods to prevent accidental overwrites when multiple user agents might be
// acting in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the rollout kind. The Any
// wildcard (`*`) requires that the resource must already exists, and the Not
// Any wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsRolloutKindsDeleteCall) Etag(etag string) *ProjectsLocationsRolloutKindsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutKindsDeleteCall) RequestId(requestId string) *ProjectsLocationsRolloutKindsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutKindsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutKindsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutKindsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutKindsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutKindsDeleteCall) Context(ctx context.Context) *ProjectsLocationsRolloutKindsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutKindsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutKindsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rolloutKinds.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutKindsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutKindsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single rollout kind.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsRolloutKindsService) Get(name string) *ProjectsLocationsRolloutKindsGetCall {
	c := &ProjectsLocationsRolloutKindsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutKindsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutKindsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutKindsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutKindsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutKindsGetCall) Context(ctx context.Context) *ProjectsLocationsRolloutKindsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutKindsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutKindsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rolloutKinds.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RolloutKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutKindsGetCall) Do(opts ...googleapi.CallOption) (*RolloutKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RolloutKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutKindsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of rollout kinds.
//
// - parent: The parent of the rollout kind.
func (r *ProjectsLocationsRolloutKindsService) List(parent string) *ProjectsLocationsRolloutKindsListCall {
	c := &ProjectsLocationsRolloutKindsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsRolloutKindsListCall) Filter(filter string) *ProjectsLocationsRolloutKindsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsRolloutKindsListCall) OrderBy(orderBy string) *ProjectsLocationsRolloutKindsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// rollout kinds to send per page.
func (c *ProjectsLocationsRolloutKindsListCall) PageSize(pageSize int64) *ProjectsLocationsRolloutKindsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsRolloutKindsListCall) PageToken(pageToken string) *ProjectsLocationsRolloutKindsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutKindsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutKindsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutKindsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutKindsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutKindsListCall) Context(ctx context.Context) *ProjectsLocationsRolloutKindsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutKindsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutKindsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/rolloutKinds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rolloutKinds.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRolloutKindsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutKindsListCall) Do(opts ...googleapi.CallOption) (*ListRolloutKindsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRolloutKindsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRolloutKindsListCall) Pages(ctx context.Context, f func(*ListRolloutKindsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRolloutKindsPatchCall struct {
	s           *Service
	name        string
	rolloutkind *RolloutKind
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Update a single rollout kind.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}".
func (r *ProjectsLocationsRolloutKindsService) Patch(name string, rolloutkind *RolloutKind) *ProjectsLocationsRolloutKindsPatchCall {
	c := &ProjectsLocationsRolloutKindsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rolloutkind = rolloutkind
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutKindsPatchCall) RequestId(requestId string) *ProjectsLocationsRolloutKindsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the RolloutKind resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields in the RolloutKind
// will be overwritten.
func (c *ProjectsLocationsRolloutKindsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRolloutKindsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutKindsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutKindsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutKindsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutKindsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutKindsPatchCall) Context(ctx context.Context) *ProjectsLocationsRolloutKindsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutKindsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutKindsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rolloutkind)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rolloutKinds.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *RolloutKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutKindsPatchCall) Do(opts ...googleapi.CallOption) (*RolloutKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RolloutKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rolloutKinds.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsCreateCall struct {
	s          *Service
	parent     string
	rollout    *Rollout
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new rollout.
//
// - parent: The parent of the rollout.
func (r *ProjectsLocationsRolloutsService) Create(parent string, rollout *Rollout) *ProjectsLocationsRolloutsCreateCall {
	c := &ProjectsLocationsRolloutsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.rollout = rollout
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutsCreateCall) RequestId(requestId string) *ProjectsLocationsRolloutsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// RolloutId sets the optional parameter "rolloutId": Required. The ID value
// for the new rollout.
func (c *ProjectsLocationsRolloutsCreateCall) RolloutId(rolloutId string) *ProjectsLocationsRolloutsCreateCall {
	c.urlParams_.Set("rolloutId", rolloutId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsCreateCall) Context(ctx context.Context) *ProjectsLocationsRolloutsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollout)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/rollouts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rollouts.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rollout.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutsCreateCall) Do(opts ...googleapi.CallOption) (*Rollout, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rollout{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single rollout.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsRolloutsService) Delete(name string) *ProjectsLocationsRolloutsDeleteCall {
	c := &ProjectsLocationsRolloutsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the rollout. This is used with state-changing methods
// to prevent accidental overwrites when multiple user agents might be acting
// in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the rollout. The Any wildcard
// (`*`) requires that the resource must already exists, and the Not Any
// wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsRolloutsDeleteCall) Etag(etag string) *ProjectsLocationsRolloutsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutsDeleteCall) RequestId(requestId string) *ProjectsLocationsRolloutsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsDeleteCall) Context(ctx context.Context) *ProjectsLocationsRolloutsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rollouts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single rollout.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsRolloutsService) Get(name string) *ProjectsLocationsRolloutsGetCall {
	c := &ProjectsLocationsRolloutsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsGetCall) Context(ctx context.Context) *ProjectsLocationsRolloutsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rollouts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rollout.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutsGetCall) Do(opts ...googleapi.CallOption) (*Rollout, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rollout{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRolloutsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of rollouts.
//
// - parent: The parent of the rollout.
func (r *ProjectsLocationsRolloutsService) List(parent string) *ProjectsLocationsRolloutsListCall {
	c := &ProjectsLocationsRolloutsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsRolloutsListCall) Filter(filter string) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsRolloutsListCall) OrderBy(orderBy string) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// rollouts to send per page.
func (c *ProjectsLocationsRolloutsListCall) PageSize(pageSize int64) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsRolloutsListCall) PageToken(pageToken string) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRolloutsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRolloutsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsListCall) Context(ctx context.Context) *ProjectsLocationsRolloutsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/rollouts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rollouts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRolloutsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRolloutsListCall) Do(opts ...googleapi.CallOption) (*ListRolloutsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRolloutsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRolloutsListCall) Pages(ctx context.Context, f func(*ListRolloutsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRolloutsPatchCall struct {
	s          *Service
	name       string
	rollout    *Rollout
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single rollout.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/rollout/{rollout_id}".
func (r *ProjectsLocationsRolloutsService) Patch(name string, rollout *Rollout) *ProjectsLocationsRolloutsPatchCall {
	c := &ProjectsLocationsRolloutsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rollout = rollout
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsRolloutsPatchCall) RequestId(requestId string) *ProjectsLocationsRolloutsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Rollout resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields in the Rollout will be
// overwritten.
func (c *ProjectsLocationsRolloutsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRolloutsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsRolloutsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsRolloutsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRolloutsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRolloutsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRolloutsPatchCall) Context(ctx context.Context) *ProjectsLocationsRolloutsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRolloutsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRolloutsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollout)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.rollouts.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Rollout.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRolloutsPatchCall) Do(opts ...googleapi.CallOption) (*Rollout, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Rollout{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.rollouts.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSaasCreateCall struct {
	s          *Service
	parent     string
	saas       *Saas
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new saas.
//
// - parent: The parent of the saas.
func (r *ProjectsLocationsSaasService) Create(parent string, saas *Saas) *ProjectsLocationsSaasCreateCall {
	c := &ProjectsLocationsSaasCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.saas = saas
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSaasCreateCall) RequestId(requestId string) *ProjectsLocationsSaasCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SaasId sets the optional parameter "saasId": Required. The ID value for the
// new saas.
func (c *ProjectsLocationsSaasCreateCall) SaasId(saasId string) *ProjectsLocationsSaasCreateCall {
	c.urlParams_.Set("saasId", saasId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsSaasCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsSaasCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSaasCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSaasCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSaasCreateCall) Context(ctx context.Context) *ProjectsLocationsSaasCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSaasCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSaasCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.saas)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/saas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.saas.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Saas.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSaasCreateCall) Do(opts ...googleapi.CallOption) (*Saas, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Saas{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSaasDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single saas.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsSaasService) Delete(name string) *ProjectsLocationsSaasDeleteCall {
	c := &ProjectsLocationsSaasDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the saas. This is used with state-changing methods to
// prevent accidental overwrites when multiple user agents might be acting in
// parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the saas. The Any wildcard
// (`*`) requires that the resource must already exists, and the Not Any
// wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsSaasDeleteCall) Etag(etag string) *ProjectsLocationsSaasDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSaasDeleteCall) RequestId(requestId string) *ProjectsLocationsSaasDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsSaasDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsSaasDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSaasDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSaasDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSaasDeleteCall) Context(ctx context.Context) *ProjectsLocationsSaasDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSaasDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSaasDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.saas.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSaasDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSaasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single saas.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsSaasService) Get(name string) *ProjectsLocationsSaasGetCall {
	c := &ProjectsLocationsSaasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSaasGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSaasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSaasGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSaasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSaasGetCall) Context(ctx context.Context) *ProjectsLocationsSaasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSaasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSaasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.saas.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Saas.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSaasGetCall) Do(opts ...googleapi.CallOption) (*Saas, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Saas{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSaasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of saas.
//
// - parent: The parent of the saas.
func (r *ProjectsLocationsSaasService) List(parent string) *ProjectsLocationsSaasListCall {
	c := &ProjectsLocationsSaasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsSaasListCall) Filter(filter string) *ProjectsLocationsSaasListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsSaasListCall) OrderBy(orderBy string) *ProjectsLocationsSaasListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of saas
// to send per page.
func (c *ProjectsLocationsSaasListCall) PageSize(pageSize int64) *ProjectsLocationsSaasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsSaasListCall) PageToken(pageToken string) *ProjectsLocationsSaasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSaasListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSaasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSaasListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSaasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSaasListCall) Context(ctx context.Context) *ProjectsLocationsSaasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSaasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSaasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/saas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.saas.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSaasResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSaasListCall) Do(opts ...googleapi.CallOption) (*ListSaasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSaasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSaasListCall) Pages(ctx context.Context, f func(*ListSaasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSaasPatchCall struct {
	s          *Service
	name       string
	saas       *Saas
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single saas.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/saas/{saas}".
func (r *ProjectsLocationsSaasService) Patch(name string, saas *Saas) *ProjectsLocationsSaasPatchCall {
	c := &ProjectsLocationsSaasPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.saas = saas
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSaasPatchCall) RequestId(requestId string) *ProjectsLocationsSaasPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Saas resource by the update. The
// fields specified in the update_mask are relative to the resource, not the
// full request. A field will be overwritten if it is in the mask. If the user
// does not provide a mask then all fields in the Saas will be overwritten.
func (c *ProjectsLocationsSaasPatchCall) UpdateMask(updateMask string) *ProjectsLocationsSaasPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsSaasPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsSaasPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSaasPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsSaasPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSaasPatchCall) Context(ctx context.Context) *ProjectsLocationsSaasPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSaasPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSaasPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.saas)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.saas.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Saas.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSaasPatchCall) Do(opts ...googleapi.CallOption) (*Saas, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Saas{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.saas.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTenantsCreateCall struct {
	s          *Service
	parent     string
	tenant     *Tenant
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new tenant.
//
// - parent: The parent of the tenant.
func (r *ProjectsLocationsTenantsService) Create(parent string, tenant *Tenant) *ProjectsLocationsTenantsCreateCall {
	c := &ProjectsLocationsTenantsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.tenant = tenant
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsTenantsCreateCall) RequestId(requestId string) *ProjectsLocationsTenantsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// TenantId sets the optional parameter "tenantId": Required. The ID value for
// the new tenant.
func (c *ProjectsLocationsTenantsCreateCall) TenantId(tenantId string) *ProjectsLocationsTenantsCreateCall {
	c.urlParams_.Set("tenantId", tenantId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsTenantsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsTenantsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTenantsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsTenantsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTenantsCreateCall) Context(ctx context.Context) *ProjectsLocationsTenantsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTenantsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTenantsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tenant)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tenants")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.tenants.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tenant.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTenantsCreateCall) Do(opts ...googleapi.CallOption) (*Tenant, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tenant{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTenantsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single tenant.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsTenantsService) Delete(name string) *ProjectsLocationsTenantsDeleteCall {
	c := &ProjectsLocationsTenantsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the tenant. This is used with state-changing methods
// to prevent accidental overwrites when multiple user agents might be acting
// in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the tenant. The Any wildcard
// (`*`) requires that the resource must already exists, and the Not Any
// wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsTenantsDeleteCall) Etag(etag string) *ProjectsLocationsTenantsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsTenantsDeleteCall) RequestId(requestId string) *ProjectsLocationsTenantsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsTenantsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsTenantsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTenantsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsTenantsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTenantsDeleteCall) Context(ctx context.Context) *ProjectsLocationsTenantsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTenantsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTenantsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.tenants.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTenantsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTenantsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single tenant.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsTenantsService) Get(name string) *ProjectsLocationsTenantsGetCall {
	c := &ProjectsLocationsTenantsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTenantsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsTenantsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTenantsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsTenantsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTenantsGetCall) Context(ctx context.Context) *ProjectsLocationsTenantsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTenantsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTenantsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.tenants.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tenant.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTenantsGetCall) Do(opts ...googleapi.CallOption) (*Tenant, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tenant{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTenantsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of tenants.
//
// - parent: The parent of the tenant.
func (r *ProjectsLocationsTenantsService) List(parent string) *ProjectsLocationsTenantsListCall {
	c := &ProjectsLocationsTenantsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsTenantsListCall) Filter(filter string) *ProjectsLocationsTenantsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsTenantsListCall) OrderBy(orderBy string) *ProjectsLocationsTenantsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// tenants to send per page.
func (c *ProjectsLocationsTenantsListCall) PageSize(pageSize int64) *ProjectsLocationsTenantsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsTenantsListCall) PageToken(pageToken string) *ProjectsLocationsTenantsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTenantsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsTenantsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTenantsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsTenantsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTenantsListCall) Context(ctx context.Context) *ProjectsLocationsTenantsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTenantsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTenantsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tenants")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.tenants.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTenantsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsTenantsListCall) Do(opts ...googleapi.CallOption) (*ListTenantsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTenantsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsTenantsListCall) Pages(ctx context.Context, f func(*ListTenantsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsTenantsPatchCall struct {
	s          *Service
	name       string
	tenant     *Tenant
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single tenant.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/tenants/{tenant}".
func (r *ProjectsLocationsTenantsService) Patch(name string, tenant *Tenant) *ProjectsLocationsTenantsPatchCall {
	c := &ProjectsLocationsTenantsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.tenant = tenant
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsTenantsPatchCall) RequestId(requestId string) *ProjectsLocationsTenantsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Tenant resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields in the Tenant will be
// overwritten.
func (c *ProjectsLocationsTenantsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsTenantsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsTenantsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsTenantsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTenantsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsTenantsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTenantsPatchCall) Context(ctx context.Context) *ProjectsLocationsTenantsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTenantsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTenantsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tenant)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.tenants.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tenant.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTenantsPatchCall) Do(opts ...googleapi.CallOption) (*Tenant, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tenant{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.tenants.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitKindsCreateCall struct {
	s          *Service
	parent     string
	unitkind   *UnitKind
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new unit kind.
//
// - parent: The parent of the unit kind.
func (r *ProjectsLocationsUnitKindsService) Create(parent string, unitkind *UnitKind) *ProjectsLocationsUnitKindsCreateCall {
	c := &ProjectsLocationsUnitKindsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.unitkind = unitkind
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitKindsCreateCall) RequestId(requestId string) *ProjectsLocationsUnitKindsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UnitKindId sets the optional parameter "unitKindId": Required. The ID value
// for the new unit kind.
func (c *ProjectsLocationsUnitKindsCreateCall) UnitKindId(unitKindId string) *ProjectsLocationsUnitKindsCreateCall {
	c.urlParams_.Set("unitKindId", unitKindId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitKindsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitKindsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitKindsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitKindsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitKindsCreateCall) Context(ctx context.Context) *ProjectsLocationsUnitKindsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitKindsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitKindsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unitkind)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/unitKinds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitKinds.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitKindsCreateCall) Do(opts ...googleapi.CallOption) (*UnitKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitKindsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single unit kind.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitKindsService) Delete(name string) *ProjectsLocationsUnitKindsDeleteCall {
	c := &ProjectsLocationsUnitKindsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the unit kind. This is used with state-changing
// methods to prevent accidental overwrites when multiple user agents might be
// acting in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the unit kind. The Any
// wildcard (`*`) requires that the resource must already exists, and the Not
// Any wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsUnitKindsDeleteCall) Etag(etag string) *ProjectsLocationsUnitKindsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitKindsDeleteCall) RequestId(requestId string) *ProjectsLocationsUnitKindsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitKindsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitKindsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitKindsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitKindsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitKindsDeleteCall) Context(ctx context.Context) *ProjectsLocationsUnitKindsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitKindsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitKindsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitKinds.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitKindsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitKindsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single unit kind.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitKindsService) Get(name string) *ProjectsLocationsUnitKindsGetCall {
	c := &ProjectsLocationsUnitKindsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitKindsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitKindsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitKindsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitKindsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitKindsGetCall) Context(ctx context.Context) *ProjectsLocationsUnitKindsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitKindsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitKindsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitKinds.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitKindsGetCall) Do(opts ...googleapi.CallOption) (*UnitKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitKindsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of unit kinds.
//
// - parent: The parent of the unit kind.
func (r *ProjectsLocationsUnitKindsService) List(parent string) *ProjectsLocationsUnitKindsListCall {
	c := &ProjectsLocationsUnitKindsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsUnitKindsListCall) Filter(filter string) *ProjectsLocationsUnitKindsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsUnitKindsListCall) OrderBy(orderBy string) *ProjectsLocationsUnitKindsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of unit
// kinds to send per page.
func (c *ProjectsLocationsUnitKindsListCall) PageSize(pageSize int64) *ProjectsLocationsUnitKindsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsUnitKindsListCall) PageToken(pageToken string) *ProjectsLocationsUnitKindsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitKindsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitKindsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitKindsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitKindsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitKindsListCall) Context(ctx context.Context) *ProjectsLocationsUnitKindsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitKindsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitKindsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/unitKinds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitKinds.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUnitKindsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsUnitKindsListCall) Do(opts ...googleapi.CallOption) (*ListUnitKindsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUnitKindsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsUnitKindsListCall) Pages(ctx context.Context, f func(*ListUnitKindsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUnitKindsPatchCall struct {
	s          *Service
	name       string
	unitkind   *UnitKind
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single unit kind.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/unitKinds/{unitKind}".
func (r *ProjectsLocationsUnitKindsService) Patch(name string, unitkind *UnitKind) *ProjectsLocationsUnitKindsPatchCall {
	c := &ProjectsLocationsUnitKindsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.unitkind = unitkind
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitKindsPatchCall) RequestId(requestId string) *ProjectsLocationsUnitKindsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the UnitKind resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields in the UnitKind will be
// overwritten.
func (c *ProjectsLocationsUnitKindsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsUnitKindsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitKindsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitKindsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitKindsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitKindsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitKindsPatchCall) Context(ctx context.Context) *ProjectsLocationsUnitKindsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitKindsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitKindsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unitkind)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitKinds.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitKind.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitKindsPatchCall) Do(opts ...googleapi.CallOption) (*UnitKind, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitKind{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitKinds.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitOperationsCreateCall struct {
	s             *Service
	parent        string
	unitoperation *UnitOperation
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Create a new unit operation.
//
// - parent: The parent of the unit operation.
func (r *ProjectsLocationsUnitOperationsService) Create(parent string, unitoperation *UnitOperation) *ProjectsLocationsUnitOperationsCreateCall {
	c := &ProjectsLocationsUnitOperationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.unitoperation = unitoperation
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitOperationsCreateCall) RequestId(requestId string) *ProjectsLocationsUnitOperationsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UnitOperationId sets the optional parameter "unitOperationId": Required. The
// ID value for the new unit operation.
func (c *ProjectsLocationsUnitOperationsCreateCall) UnitOperationId(unitOperationId string) *ProjectsLocationsUnitOperationsCreateCall {
	c.urlParams_.Set("unitOperationId", unitOperationId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitOperationsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitOperationsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitOperationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitOperationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitOperationsCreateCall) Context(ctx context.Context) *ProjectsLocationsUnitOperationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitOperationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitOperationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unitoperation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/unitOperations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitOperations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitOperation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitOperationsCreateCall) Do(opts ...googleapi.CallOption) (*UnitOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single unit operation.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitOperationsService) Delete(name string) *ProjectsLocationsUnitOperationsDeleteCall {
	c := &ProjectsLocationsUnitOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the unit operation. This is used with state-changing
// methods to prevent accidental overwrites when multiple user agents might be
// acting in parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the unit operation. The Any
// wildcard (`*`) requires that the resource must already exists, and the Not
// Any wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsUnitOperationsDeleteCall) Etag(etag string) *ProjectsLocationsUnitOperationsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitOperationsDeleteCall) RequestId(requestId string) *ProjectsLocationsUnitOperationsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitOperationsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitOperationsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsUnitOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitOperations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single unit operation.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitOperationsService) Get(name string) *ProjectsLocationsUnitOperationsGetCall {
	c := &ProjectsLocationsUnitOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsUnitOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitOperations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitOperation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitOperationsGetCall) Do(opts ...googleapi.CallOption) (*UnitOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitOperationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of unit operations.
//
// - parent: The parent of the unit operation.
func (r *ProjectsLocationsUnitOperationsService) List(parent string) *ProjectsLocationsUnitOperationsListCall {
	c := &ProjectsLocationsUnitOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsUnitOperationsListCall) Filter(filter string) *ProjectsLocationsUnitOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsUnitOperationsListCall) OrderBy(orderBy string) *ProjectsLocationsUnitOperationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of unit
// operations to send per page.
func (c *ProjectsLocationsUnitOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsUnitOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsUnitOperationsListCall) PageToken(pageToken string) *ProjectsLocationsUnitOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitOperationsListCall) Context(ctx context.Context) *ProjectsLocationsUnitOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/unitOperations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitOperations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUnitOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitOperationsListCall) Do(opts ...googleapi.CallOption) (*ListUnitOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUnitOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsUnitOperationsListCall) Pages(ctx context.Context, f func(*ListUnitOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUnitOperationsPatchCall struct {
	s             *Service
	name          string
	unitoperation *UnitOperation
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Update a single unit operation.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/unitOperations/{unitOperation}".
func (r *ProjectsLocationsUnitOperationsService) Patch(name string, unitoperation *UnitOperation) *ProjectsLocationsUnitOperationsPatchCall {
	c := &ProjectsLocationsUnitOperationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.unitoperation = unitoperation
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitOperationsPatchCall) RequestId(requestId string) *ProjectsLocationsUnitOperationsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the UnitOperation resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields in the
// UnitOperation will be overwritten.
func (c *ProjectsLocationsUnitOperationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsUnitOperationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitOperationsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitOperationsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitOperationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitOperationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitOperationsPatchCall) Context(ctx context.Context) *ProjectsLocationsUnitOperationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitOperationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitOperationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unitoperation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.unitOperations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *UnitOperation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitOperationsPatchCall) Do(opts ...googleapi.CallOption) (*UnitOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UnitOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.unitOperations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitsCreateCall struct {
	s          *Service
	parent     string
	unit       *Unit
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new unit.
//
// - parent: The parent of the unit.
func (r *ProjectsLocationsUnitsService) Create(parent string, unit *Unit) *ProjectsLocationsUnitsCreateCall {
	c := &ProjectsLocationsUnitsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.unit = unit
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitsCreateCall) RequestId(requestId string) *ProjectsLocationsUnitsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UnitId sets the optional parameter "unitId": Required. The ID value for the
// new unit.
func (c *ProjectsLocationsUnitsCreateCall) UnitId(unitId string) *ProjectsLocationsUnitsCreateCall {
	c.urlParams_.Set("unitId", unitId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitsCreateCall) Context(ctx context.Context) *ProjectsLocationsUnitsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unit)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/units")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.units.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Unit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitsCreateCall) Do(opts ...googleapi.CallOption) (*Unit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Unit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a single unit.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitsService) Delete(name string) *ProjectsLocationsUnitsDeleteCall {
	c := &ProjectsLocationsUnitsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag known to the client for
// the expected state of the unit. This is used with state-changing methods to
// prevent accidental overwrites when multiple user agents might be acting in
// parallel on the same resource. An etag wildcard provide optimistic
// concurrency based on the expected existence of the unit. The Any wildcard
// (`*`) requires that the resource must already exists, and the Not Any
// wildcard (`!*`) requires that it must not.
func (c *ProjectsLocationsUnitsDeleteCall) Etag(etag string) *ProjectsLocationsUnitsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitsDeleteCall) RequestId(requestId string) *ProjectsLocationsUnitsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitsDeleteCall) Context(ctx context.Context) *ProjectsLocationsUnitsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.units.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single unit.
//
// - name: The resource name of the resource within a service.
func (r *ProjectsLocationsUnitsService) Get(name string) *ProjectsLocationsUnitsGetCall {
	c := &ProjectsLocationsUnitsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitsGetCall) Context(ctx context.Context) *ProjectsLocationsUnitsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.units.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Unit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitsGetCall) Do(opts ...googleapi.CallOption) (*Unit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Unit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUnitsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve a collection of units.
//
// - parent: The parent of the unit.
func (r *ProjectsLocationsUnitsService) List(parent string) *ProjectsLocationsUnitsListCall {
	c := &ProjectsLocationsUnitsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsUnitsListCall) Filter(filter string) *ProjectsLocationsUnitsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsUnitsListCall) OrderBy(orderBy string) *ProjectsLocationsUnitsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of units
// to send per page.
func (c *ProjectsLocationsUnitsListCall) PageSize(pageSize int64) *ProjectsLocationsUnitsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token: If the
// next_page_token from a previous response is provided, this request will send
// the subsequent page.
func (c *ProjectsLocationsUnitsListCall) PageToken(pageToken string) *ProjectsLocationsUnitsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsUnitsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsUnitsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitsListCall) Context(ctx context.Context) *ProjectsLocationsUnitsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/units")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.units.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUnitsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsUnitsListCall) Do(opts ...googleapi.CallOption) (*ListUnitsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUnitsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsUnitsListCall) Pages(ctx context.Context, f func(*ListUnitsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUnitsPatchCall struct {
	s          *Service
	name       string
	unit       *Unit
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a single unit.
//
//   - name: Identifier. The resource name (full URI of the resource) following
//     the standard naming scheme:
//     "projects/{project}/locations/{location}/units/{unit}".
func (r *ProjectsLocationsUnitsService) Patch(name string, unit *Unit) *ProjectsLocationsUnitsPatchCall {
	c := &ProjectsLocationsUnitsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.unit = unit
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUnitsPatchCall) RequestId(requestId string) *ProjectsLocationsUnitsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Unit resource by the update. The
// fields specified in the update_mask are relative to the resource, not the
// full request. A field will be overwritten if it is in the mask. If the user
// does not provide a mask then all fields in the Unit will be overwritten.
func (c *ProjectsLocationsUnitsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsUnitsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If "validate_only"
// is set to true, the service will try to validate that this request would
// succeed, but will not actually make changes.
func (c *ProjectsLocationsUnitsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsUnitsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUnitsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsUnitsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUnitsPatchCall) Context(ctx context.Context) *ProjectsLocationsUnitsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUnitsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUnitsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.unit)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "saasservicemgmt.projects.locations.units.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Unit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUnitsPatchCall) Do(opts ...googleapi.CallOption) (*Unit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Unit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "saasservicemgmt.projects.locations.units.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
