// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package oracledatabase provides access to the Oracle Database@Google Cloud API.
//
// For product documentation, see: https://cloud.google.com/oracle/database/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/oracledatabase/v1"
//	...
//	ctx := context.Background()
//	oracledatabaseService, err := oracledatabase.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	oracledatabaseService, err := oracledatabase.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	oracledatabaseService, err := oracledatabase.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package oracledatabase // import "google.golang.org/api/oracledatabase/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "oracledatabase:v1"
const apiName = "oracledatabase"
const apiVersion = "v1"
const basePath = "https://oracledatabase.googleapis.com/"
const basePathTemplate = "https://oracledatabase.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://oracledatabase.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AutonomousDatabaseBackups = NewProjectsLocationsAutonomousDatabaseBackupsService(s)
	rs.AutonomousDatabaseCharacterSets = NewProjectsLocationsAutonomousDatabaseCharacterSetsService(s)
	rs.AutonomousDatabases = NewProjectsLocationsAutonomousDatabasesService(s)
	rs.AutonomousDbVersions = NewProjectsLocationsAutonomousDbVersionsService(s)
	rs.CloudExadataInfrastructures = NewProjectsLocationsCloudExadataInfrastructuresService(s)
	rs.CloudVmClusters = NewProjectsLocationsCloudVmClustersService(s)
	rs.DatabaseCharacterSets = NewProjectsLocationsDatabaseCharacterSetsService(s)
	rs.Databases = NewProjectsLocationsDatabasesService(s)
	rs.DbSystemInitialStorageSizes = NewProjectsLocationsDbSystemInitialStorageSizesService(s)
	rs.DbSystemShapes = NewProjectsLocationsDbSystemShapesService(s)
	rs.DbSystems = NewProjectsLocationsDbSystemsService(s)
	rs.DbVersions = NewProjectsLocationsDbVersionsService(s)
	rs.Entitlements = NewProjectsLocationsEntitlementsService(s)
	rs.ExadbVmClusters = NewProjectsLocationsExadbVmClustersService(s)
	rs.ExascaleDbStorageVaults = NewProjectsLocationsExascaleDbStorageVaultsService(s)
	rs.GiVersions = NewProjectsLocationsGiVersionsService(s)
	rs.OdbNetworks = NewProjectsLocationsOdbNetworksService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PluggableDatabases = NewProjectsLocationsPluggableDatabasesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AutonomousDatabaseBackups *ProjectsLocationsAutonomousDatabaseBackupsService

	AutonomousDatabaseCharacterSets *ProjectsLocationsAutonomousDatabaseCharacterSetsService

	AutonomousDatabases *ProjectsLocationsAutonomousDatabasesService

	AutonomousDbVersions *ProjectsLocationsAutonomousDbVersionsService

	CloudExadataInfrastructures *ProjectsLocationsCloudExadataInfrastructuresService

	CloudVmClusters *ProjectsLocationsCloudVmClustersService

	DatabaseCharacterSets *ProjectsLocationsDatabaseCharacterSetsService

	Databases *ProjectsLocationsDatabasesService

	DbSystemInitialStorageSizes *ProjectsLocationsDbSystemInitialStorageSizesService

	DbSystemShapes *ProjectsLocationsDbSystemShapesService

	DbSystems *ProjectsLocationsDbSystemsService

	DbVersions *ProjectsLocationsDbVersionsService

	Entitlements *ProjectsLocationsEntitlementsService

	ExadbVmClusters *ProjectsLocationsExadbVmClustersService

	ExascaleDbStorageVaults *ProjectsLocationsExascaleDbStorageVaultsService

	GiVersions *ProjectsLocationsGiVersionsService

	OdbNetworks *ProjectsLocationsOdbNetworksService

	Operations *ProjectsLocationsOperationsService

	PluggableDatabases *ProjectsLocationsPluggableDatabasesService
}

func NewProjectsLocationsAutonomousDatabaseBackupsService(s *Service) *ProjectsLocationsAutonomousDatabaseBackupsService {
	rs := &ProjectsLocationsAutonomousDatabaseBackupsService{s: s}
	return rs
}

type ProjectsLocationsAutonomousDatabaseBackupsService struct {
	s *Service
}

func NewProjectsLocationsAutonomousDatabaseCharacterSetsService(s *Service) *ProjectsLocationsAutonomousDatabaseCharacterSetsService {
	rs := &ProjectsLocationsAutonomousDatabaseCharacterSetsService{s: s}
	return rs
}

type ProjectsLocationsAutonomousDatabaseCharacterSetsService struct {
	s *Service
}

func NewProjectsLocationsAutonomousDatabasesService(s *Service) *ProjectsLocationsAutonomousDatabasesService {
	rs := &ProjectsLocationsAutonomousDatabasesService{s: s}
	return rs
}

type ProjectsLocationsAutonomousDatabasesService struct {
	s *Service
}

func NewProjectsLocationsAutonomousDbVersionsService(s *Service) *ProjectsLocationsAutonomousDbVersionsService {
	rs := &ProjectsLocationsAutonomousDbVersionsService{s: s}
	return rs
}

type ProjectsLocationsAutonomousDbVersionsService struct {
	s *Service
}

func NewProjectsLocationsCloudExadataInfrastructuresService(s *Service) *ProjectsLocationsCloudExadataInfrastructuresService {
	rs := &ProjectsLocationsCloudExadataInfrastructuresService{s: s}
	rs.DbServers = NewProjectsLocationsCloudExadataInfrastructuresDbServersService(s)
	return rs
}

type ProjectsLocationsCloudExadataInfrastructuresService struct {
	s *Service

	DbServers *ProjectsLocationsCloudExadataInfrastructuresDbServersService
}

func NewProjectsLocationsCloudExadataInfrastructuresDbServersService(s *Service) *ProjectsLocationsCloudExadataInfrastructuresDbServersService {
	rs := &ProjectsLocationsCloudExadataInfrastructuresDbServersService{s: s}
	return rs
}

type ProjectsLocationsCloudExadataInfrastructuresDbServersService struct {
	s *Service
}

func NewProjectsLocationsCloudVmClustersService(s *Service) *ProjectsLocationsCloudVmClustersService {
	rs := &ProjectsLocationsCloudVmClustersService{s: s}
	rs.DbNodes = NewProjectsLocationsCloudVmClustersDbNodesService(s)
	return rs
}

type ProjectsLocationsCloudVmClustersService struct {
	s *Service

	DbNodes *ProjectsLocationsCloudVmClustersDbNodesService
}

func NewProjectsLocationsCloudVmClustersDbNodesService(s *Service) *ProjectsLocationsCloudVmClustersDbNodesService {
	rs := &ProjectsLocationsCloudVmClustersDbNodesService{s: s}
	return rs
}

type ProjectsLocationsCloudVmClustersDbNodesService struct {
	s *Service
}

func NewProjectsLocationsDatabaseCharacterSetsService(s *Service) *ProjectsLocationsDatabaseCharacterSetsService {
	rs := &ProjectsLocationsDatabaseCharacterSetsService{s: s}
	return rs
}

type ProjectsLocationsDatabaseCharacterSetsService struct {
	s *Service
}

func NewProjectsLocationsDatabasesService(s *Service) *ProjectsLocationsDatabasesService {
	rs := &ProjectsLocationsDatabasesService{s: s}
	return rs
}

type ProjectsLocationsDatabasesService struct {
	s *Service
}

func NewProjectsLocationsDbSystemInitialStorageSizesService(s *Service) *ProjectsLocationsDbSystemInitialStorageSizesService {
	rs := &ProjectsLocationsDbSystemInitialStorageSizesService{s: s}
	return rs
}

type ProjectsLocationsDbSystemInitialStorageSizesService struct {
	s *Service
}

func NewProjectsLocationsDbSystemShapesService(s *Service) *ProjectsLocationsDbSystemShapesService {
	rs := &ProjectsLocationsDbSystemShapesService{s: s}
	return rs
}

type ProjectsLocationsDbSystemShapesService struct {
	s *Service
}

func NewProjectsLocationsDbSystemsService(s *Service) *ProjectsLocationsDbSystemsService {
	rs := &ProjectsLocationsDbSystemsService{s: s}
	return rs
}

type ProjectsLocationsDbSystemsService struct {
	s *Service
}

func NewProjectsLocationsDbVersionsService(s *Service) *ProjectsLocationsDbVersionsService {
	rs := &ProjectsLocationsDbVersionsService{s: s}
	return rs
}

type ProjectsLocationsDbVersionsService struct {
	s *Service
}

func NewProjectsLocationsEntitlementsService(s *Service) *ProjectsLocationsEntitlementsService {
	rs := &ProjectsLocationsEntitlementsService{s: s}
	return rs
}

type ProjectsLocationsEntitlementsService struct {
	s *Service
}

func NewProjectsLocationsExadbVmClustersService(s *Service) *ProjectsLocationsExadbVmClustersService {
	rs := &ProjectsLocationsExadbVmClustersService{s: s}
	rs.DbNodes = NewProjectsLocationsExadbVmClustersDbNodesService(s)
	return rs
}

type ProjectsLocationsExadbVmClustersService struct {
	s *Service

	DbNodes *ProjectsLocationsExadbVmClustersDbNodesService
}

func NewProjectsLocationsExadbVmClustersDbNodesService(s *Service) *ProjectsLocationsExadbVmClustersDbNodesService {
	rs := &ProjectsLocationsExadbVmClustersDbNodesService{s: s}
	return rs
}

type ProjectsLocationsExadbVmClustersDbNodesService struct {
	s *Service
}

func NewProjectsLocationsExascaleDbStorageVaultsService(s *Service) *ProjectsLocationsExascaleDbStorageVaultsService {
	rs := &ProjectsLocationsExascaleDbStorageVaultsService{s: s}
	return rs
}

type ProjectsLocationsExascaleDbStorageVaultsService struct {
	s *Service
}

func NewProjectsLocationsGiVersionsService(s *Service) *ProjectsLocationsGiVersionsService {
	rs := &ProjectsLocationsGiVersionsService{s: s}
	rs.MinorVersions = NewProjectsLocationsGiVersionsMinorVersionsService(s)
	return rs
}

type ProjectsLocationsGiVersionsService struct {
	s *Service

	MinorVersions *ProjectsLocationsGiVersionsMinorVersionsService
}

func NewProjectsLocationsGiVersionsMinorVersionsService(s *Service) *ProjectsLocationsGiVersionsMinorVersionsService {
	rs := &ProjectsLocationsGiVersionsMinorVersionsService{s: s}
	return rs
}

type ProjectsLocationsGiVersionsMinorVersionsService struct {
	s *Service
}

func NewProjectsLocationsOdbNetworksService(s *Service) *ProjectsLocationsOdbNetworksService {
	rs := &ProjectsLocationsOdbNetworksService{s: s}
	rs.OdbSubnets = NewProjectsLocationsOdbNetworksOdbSubnetsService(s)
	return rs
}

type ProjectsLocationsOdbNetworksService struct {
	s *Service

	OdbSubnets *ProjectsLocationsOdbNetworksOdbSubnetsService
}

func NewProjectsLocationsOdbNetworksOdbSubnetsService(s *Service) *ProjectsLocationsOdbNetworksOdbSubnetsService {
	rs := &ProjectsLocationsOdbNetworksOdbSubnetsService{s: s}
	return rs
}

type ProjectsLocationsOdbNetworksOdbSubnetsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPluggableDatabasesService(s *Service) *ProjectsLocationsPluggableDatabasesService {
	rs := &ProjectsLocationsPluggableDatabasesService{s: s}
	return rs
}

type ProjectsLocationsPluggableDatabasesService struct {
	s *Service
}

// AllConnectionStrings: A list of all connection strings that can be used to
// connect to the Autonomous Database.
type AllConnectionStrings struct {
	// High: Output only. The database service provides the highest level of
	// resources to each SQL statement.
	High string `json:"high,omitempty"`
	// Low: Output only. The database service provides the least level of resources
	// to each SQL statement.
	Low string `json:"low,omitempty"`
	// Medium: Output only. The database service provides a lower level of
	// resources to each SQL statement.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "High") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "High") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AllConnectionStrings) MarshalJSON() ([]byte, error) {
	type NoMethod AllConnectionStrings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabase: Details of the Autonomous Database resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabase/
type AutonomousDatabase struct {
	// AdminPassword: Optional. The password for the default ADMIN user.
	AdminPassword string `json:"adminPassword,omitempty"`
	// Cidr: Optional. The subnet CIDR range for the Autonomous Database.
	Cidr string `json:"cidr,omitempty"`
	// CreateTime: Output only. The date and time that the Autonomous Database was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Database: Optional. The name of the Autonomous Database. The database name
	// must be unique in the project. The name must begin with a letter and can
	// contain a maximum of 30 alphanumeric characters.
	Database string `json:"database,omitempty"`
	// DisasterRecoverySupportedLocations: Output only. List of supported GCP
	// region to clone the Autonomous Database for disaster recovery. Format:
	// `project/{project}/locations/{location}`.
	DisasterRecoverySupportedLocations []string `json:"disasterRecoverySupportedLocations,omitempty"`
	// DisplayName: Optional. The display name for the Autonomous Database. The
	// name does not have to be unique within your project.
	DisplayName string `json:"displayName,omitempty"`
	// EntitlementId: Output only. The ID of the subscription entitlement
	// associated with the Autonomous Database.
	EntitlementId string `json:"entitlementId,omitempty"`
	// Labels: Optional. The labels or tags associated with the Autonomous
	// Database.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the Autonomous Database resource in the
	// following format:
	// projects/{project}/locations/{region}/autonomousDatabases/{autonomous_databas
	// e}
	Name string `json:"name,omitempty"`
	// Network: Optional. The name of the VPC network used by the Autonomous
	// Database in the following format:
	// projects/{project}/global/networks/{network}
	Network string `json:"network,omitempty"`
	// OdbNetwork: Optional. The name of the OdbNetwork associated with the
	// Autonomous Database. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
	// optional but if specified, this should match the parent ODBNetwork of the
	// OdbSubnet.
	OdbNetwork string `json:"odbNetwork,omitempty"`
	// OdbSubnet: Optional. The name of the OdbSubnet associated with the
	// Autonomous Database. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	OdbSubnet string `json:"odbSubnet,omitempty"`
	// PeerAutonomousDatabases: Output only. The peer Autonomous Database names of
	// the given Autonomous Database.
	PeerAutonomousDatabases []string `json:"peerAutonomousDatabases,omitempty"`
	// Properties: Optional. The properties of the Autonomous Database.
	Properties *AutonomousDatabaseProperties `json:"properties,omitempty"`
	// SourceConfig: Optional. The source Autonomous Database configuration for the
	// standby Autonomous Database. The source Autonomous Database is configured
	// while creating the Peer Autonomous Database and can't be updated after
	// creation.
	SourceConfig *SourceConfig `json:"sourceConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdminPassword") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminPassword") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabase) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseApex: Oracle APEX Application Development.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseApex
type AutonomousDatabaseApex struct {
	// ApexVersion: Output only. The Oracle APEX Application Development version.
	ApexVersion string `json:"apexVersion,omitempty"`
	// OrdsVersion: Output only. The Oracle REST Data Services (ORDS) version.
	OrdsVersion string `json:"ordsVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApexVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApexVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseApex) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseApex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseBackup: Details of the Autonomous Database Backup
// resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseBackup/
type AutonomousDatabaseBackup struct {
	// AutonomousDatabase: Required. The name of the Autonomous Database resource
	// for which the backup is being created. Format:
	// projects/{project}/locations/{region}/autonomousDatabases/{autonomous_databas
	// e}
	AutonomousDatabase string `json:"autonomousDatabase,omitempty"`
	// DisplayName: Optional. User friendly name for the Backup. The name does not
	// have to be unique.
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Optional. labels or tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the Autonomous Database Backup resource with
	// the format:
	// projects/{project}/locations/{region}/autonomousDatabaseBackups/{autonomous_d
	// atabase_backup}
	Name string `json:"name,omitempty"`
	// Properties: Optional. Various properties of the backup.
	Properties *AutonomousDatabaseBackupProperties `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutonomousDatabase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutonomousDatabase") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseBackup) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseBackup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseBackupProperties: Properties of the Autonomous Database
// Backup resource.
type AutonomousDatabaseBackupProperties struct {
	// AvailableTillTime: Output only. Timestamp until when the backup will be
	// available.
	AvailableTillTime string `json:"availableTillTime,omitempty"`
	// CompartmentId: Output only. The OCID of the compartment.
	CompartmentId string `json:"compartmentId,omitempty"`
	// DatabaseSizeTb: Output only. The quantity of data in the database, in
	// terabytes.
	DatabaseSizeTb float64 `json:"databaseSizeTb,omitempty"`
	// DbVersion: Output only. A valid Oracle Database version for Autonomous
	// Database.
	DbVersion string `json:"dbVersion,omitempty"`
	// EndTime: Output only. The date and time the backup completed.
	EndTime string `json:"endTime,omitempty"`
	// IsAutomaticBackup: Output only. Indicates if the backup is automatic or user
	// initiated.
	IsAutomaticBackup bool `json:"isAutomaticBackup,omitempty"`
	// IsLongTermBackup: Output only. Indicates if the backup is long term backup.
	IsLongTermBackup bool `json:"isLongTermBackup,omitempty"`
	// IsRestorable: Output only. Indicates if the backup can be used to restore
	// the Autonomous Database.
	IsRestorable bool `json:"isRestorable,omitempty"`
	// KeyStoreId: Optional. The OCID of the key store of Oracle Vault.
	KeyStoreId string `json:"keyStoreId,omitempty"`
	// KeyStoreWallet: Optional. The wallet name for Oracle Key Vault.
	KeyStoreWallet string `json:"keyStoreWallet,omitempty"`
	// KmsKeyId: Optional. The OCID of the key container that is used as the master
	// encryption key in database transparent data encryption (TDE) operations.
	KmsKeyId string `json:"kmsKeyId,omitempty"`
	// KmsKeyVersionId: Optional. The OCID of the key container version that is
	// used in database transparent data encryption (TDE) operations KMS Key can
	// have multiple key versions. If none is specified, the current key version
	// (latest) of the Key Id is used for the operation. Autonomous Database
	// Serverless does not use key versions, hence is not applicable for Autonomous
	// Database Serverless instances.
	KmsKeyVersionId string `json:"kmsKeyVersionId,omitempty"`
	// LifecycleDetails: Output only. Additional information about the current
	// lifecycle state.
	LifecycleDetails string `json:"lifecycleDetails,omitempty"`
	// LifecycleState: Output only. The lifecycle state of the backup.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "CREATING" - Indicates that the resource is in creating state.
	//   "ACTIVE" - Indicates that the resource is in active state.
	//   "DELETING" - Indicates that the resource is in deleting state.
	//   "DELETED" - Indicates that the resource is in deleted state.
	//   "FAILED" - Indicates that the resource is in failed state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// Ocid: Output only. OCID of the Autonomous Database backup.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `json:"ocid,omitempty"`
	// RetentionPeriodDays: Optional. Retention period in days for the backup.
	RetentionPeriodDays int64 `json:"retentionPeriodDays,omitempty"`
	// SizeTb: Output only. The backup size in terabytes.
	SizeTb float64 `json:"sizeTb,omitempty"`
	// StartTime: Output only. The date and time the backup started.
	StartTime string `json:"startTime,omitempty"`
	// Type: Output only. The type of the backup.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default unspecified value.
	//   "INCREMENTAL" - Incremental backups.
	//   "FULL" - Full backups.
	//   "LONG_TERM" - Long term backups.
	Type string `json:"type,omitempty"`
	// VaultId: Optional. The OCID of the vault.
	VaultId string `json:"vaultId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableTillTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableTillTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseBackupProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseBackupProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AutonomousDatabaseBackupProperties) UnmarshalJSON(data []byte) error {
	type NoMethod AutonomousDatabaseBackupProperties
	var s1 struct {
		DatabaseSizeTb gensupport.JSONFloat64 `json:"databaseSizeTb"`
		SizeTb         gensupport.JSONFloat64 `json:"sizeTb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DatabaseSizeTb = float64(s1.DatabaseSizeTb)
	s.SizeTb = float64(s1.SizeTb)
	return nil
}

// AutonomousDatabaseCharacterSet: Details of the Autonomous Database character
// set resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/
type AutonomousDatabaseCharacterSet struct {
	// CharacterSet: Output only. The character set name for the Autonomous
	// Database which is the ID in the resource name.
	CharacterSet string `json:"characterSet,omitempty"`
	// CharacterSetType: Output only. The character set type for the Autonomous
	// Database.
	//
	// Possible values:
	//   "CHARACTER_SET_TYPE_UNSPECIFIED" - Character set type is not specified.
	//   "DATABASE" - Character set type is set to database.
	//   "NATIONAL" - Character set type is set to national.
	CharacterSetType string `json:"characterSetType,omitempty"`
	// Name: Identifier. The name of the Autonomous Database Character Set resource
	// in the following format:
	// projects/{project}/locations/{region}/autonomousDatabaseCharacterSets/{autono
	// mous_database_character_set}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseCharacterSet) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseCharacterSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseConnectionStrings: The connection string used to connect
// to the Autonomous Database.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionStrings
type AutonomousDatabaseConnectionStrings struct {
	// AllConnectionStrings: Output only. Returns all connection strings that can
	// be used to connect to the Autonomous Database.
	AllConnectionStrings *AllConnectionStrings `json:"allConnectionStrings,omitempty"`
	// Dedicated: Output only. The database service provides the least level of
	// resources to each SQL statement, but supports the most number of concurrent
	// SQL statements.
	Dedicated string `json:"dedicated,omitempty"`
	// High: Output only. The database service provides the highest level of
	// resources to each SQL statement.
	High string `json:"high,omitempty"`
	// Low: Output only. The database service provides the least level of resources
	// to each SQL statement.
	Low string `json:"low,omitempty"`
	// Medium: Output only. The database service provides a lower level of
	// resources to each SQL statement.
	Medium string `json:"medium,omitempty"`
	// Profiles: Output only. A list of connection string profiles to allow clients
	// to group, filter, and select values based on the structured metadata.
	Profiles []*DatabaseConnectionStringProfile `json:"profiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllConnectionStrings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllConnectionStrings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseConnectionStrings) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseConnectionStrings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseConnectionUrls: The URLs for accessing Oracle Application
// Express (APEX) and SQL Developer Web with a browser from a Compute instance.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionUrls
type AutonomousDatabaseConnectionUrls struct {
	// ApexUri: Output only. Oracle Application Express (APEX) URL.
	ApexUri string `json:"apexUri,omitempty"`
	// DatabaseTransformsUri: Output only. The URL of the Database Transforms for
	// the Autonomous Database.
	DatabaseTransformsUri string `json:"databaseTransformsUri,omitempty"`
	// GraphStudioUri: Output only. The URL of the Graph Studio for the Autonomous
	// Database.
	GraphStudioUri string `json:"graphStudioUri,omitempty"`
	// MachineLearningNotebookUri: Output only. The URL of the Oracle Machine
	// Learning (OML) Notebook for the Autonomous Database.
	MachineLearningNotebookUri string `json:"machineLearningNotebookUri,omitempty"`
	// MachineLearningUserManagementUri: Output only. The URL of Machine Learning
	// user management the Autonomous Database.
	MachineLearningUserManagementUri string `json:"machineLearningUserManagementUri,omitempty"`
	// MongoDbUri: Output only. The URL of the MongoDB API for the Autonomous
	// Database.
	MongoDbUri string `json:"mongoDbUri,omitempty"`
	// OrdsUri: Output only. The Oracle REST Data Services (ORDS) URL of the Web
	// Access for the Autonomous Database.
	OrdsUri string `json:"ordsUri,omitempty"`
	// SqlDevWebUri: Output only. The URL of the Oracle SQL Developer Web for the
	// Autonomous Database.
	SqlDevWebUri string `json:"sqlDevWebUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApexUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApexUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseConnectionUrls) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseConnectionUrls
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDatabaseProperties: The properties of an Autonomous Database.
type AutonomousDatabaseProperties struct {
	// ActualUsedDataStorageSizeTb: Output only. The amount of storage currently
	// being used for user and system data, in terabytes.
	ActualUsedDataStorageSizeTb float64 `json:"actualUsedDataStorageSizeTb,omitempty"`
	// AllocatedStorageSizeTb: Output only. The amount of storage currently
	// allocated for the database tables and billed for, rounded up in terabytes.
	AllocatedStorageSizeTb float64 `json:"allocatedStorageSizeTb,omitempty"`
	// AllowlistedIps: Optional. The list of allowlisted IP addresses for the
	// Autonomous Database.
	AllowlistedIps []string `json:"allowlistedIps,omitempty"`
	// ApexDetails: Output only. The details for the Oracle APEX Application
	// Development.
	ApexDetails *AutonomousDatabaseApex `json:"apexDetails,omitempty"`
	// ArePrimaryAllowlistedIpsUsed: Output only. This field indicates the status
	// of Data Guard and Access control for the Autonomous Database. The field's
	// value is null if Data Guard is disabled or Access Control is disabled. The
	// field's value is TRUE if both Data Guard and Access Control are enabled, and
	// the Autonomous Database is using primary IP access control list (ACL) for
	// standby. The field's value is FALSE if both Data Guard and Access Control
	// are enabled, and the Autonomous Database is using a different IP access
	// control list (ACL) for standby compared to primary.
	ArePrimaryAllowlistedIpsUsed bool `json:"arePrimaryAllowlistedIpsUsed,omitempty"`
	// AutonomousContainerDatabaseId: Output only. The Autonomous Container
	// Database OCID.
	AutonomousContainerDatabaseId string `json:"autonomousContainerDatabaseId,omitempty"`
	// AvailableUpgradeVersions: Output only. The list of available Oracle Database
	// upgrade versions for an Autonomous Database.
	AvailableUpgradeVersions []string `json:"availableUpgradeVersions,omitempty"`
	// BackupRetentionPeriodDays: Optional. The retention period for the Autonomous
	// Database. This field is specified in days, can range from 1 day to 60 days,
	// and has a default value of 60 days.
	BackupRetentionPeriodDays int64 `json:"backupRetentionPeriodDays,omitempty"`
	// CharacterSet: Optional. The character set for the Autonomous Database. The
	// default is AL32UTF8.
	CharacterSet string `json:"characterSet,omitempty"`
	// ComputeCount: Optional. The number of compute servers for the Autonomous
	// Database.
	ComputeCount float64 `json:"computeCount,omitempty"`
	// ConnectionStrings: Output only. The connection strings used to connect to an
	// Autonomous Database.
	ConnectionStrings *AutonomousDatabaseConnectionStrings `json:"connectionStrings,omitempty"`
	// ConnectionUrls: Output only. The Oracle Connection URLs for an Autonomous
	// Database.
	ConnectionUrls *AutonomousDatabaseConnectionUrls `json:"connectionUrls,omitempty"`
	// CpuCoreCount: Optional. The number of CPU cores to be made available to the
	// database.
	CpuCoreCount int64 `json:"cpuCoreCount,omitempty"`
	// CustomerContacts: Optional. The list of customer contacts.
	CustomerContacts []*CustomerContact `json:"customerContacts,omitempty"`
	// DataGuardRoleChangedTime: Output only. The date and time the Autonomous Data
	// Guard role was changed for the standby Autonomous Database.
	DataGuardRoleChangedTime string `json:"dataGuardRoleChangedTime,omitempty"`
	// DataSafeState: Output only. The current state of the Data Safe registration
	// for the Autonomous Database.
	//
	// Possible values:
	//   "DATA_SAFE_STATE_UNSPECIFIED" - Default unspecified value.
	//   "REGISTERING" - Registering data safe state.
	//   "REGISTERED" - Registered data safe state.
	//   "DEREGISTERING" - Deregistering data safe state.
	//   "NOT_REGISTERED" - Not registered data safe state.
	//   "FAILED" - Failed data safe state.
	DataSafeState string `json:"dataSafeState,omitempty"`
	// DataStorageSizeGb: Optional. The size of the data stored in the database, in
	// gigabytes.
	DataStorageSizeGb int64 `json:"dataStorageSizeGb,omitempty"`
	// DataStorageSizeTb: Optional. The size of the data stored in the database, in
	// terabytes.
	DataStorageSizeTb int64 `json:"dataStorageSizeTb,omitempty"`
	// DatabaseManagementState: Output only. The current state of database
	// management for the Autonomous Database.
	//
	// Possible values:
	//   "DATABASE_MANAGEMENT_STATE_UNSPECIFIED" - Default unspecified value.
	//   "ENABLING" - Enabling Database Management state
	//   "ENABLED" - Enabled Database Management state
	//   "DISABLING" - Disabling Database Management state
	//   "NOT_ENABLED" - Not Enabled Database Management state
	//   "FAILED_ENABLING" - Failed enabling Database Management state
	//   "FAILED_DISABLING" - Failed disabling Database Management state
	DatabaseManagementState string `json:"databaseManagementState,omitempty"`
	// DbEdition: Optional. The edition of the Autonomous Databases.
	//
	// Possible values:
	//   "DATABASE_EDITION_UNSPECIFIED" - Default unspecified value.
	//   "STANDARD_EDITION" - Standard Database Edition
	//   "ENTERPRISE_EDITION" - Enterprise Database Edition
	DbEdition string `json:"dbEdition,omitempty"`
	// DbVersion: Optional. The Oracle Database version for the Autonomous
	// Database.
	DbVersion string `json:"dbVersion,omitempty"`
	// DbWorkload: Required. The workload type of the Autonomous Database.
	//
	// Possible values:
	//   "DB_WORKLOAD_UNSPECIFIED" - Default unspecified value.
	//   "OLTP" - Autonomous Transaction Processing database.
	//   "DW" - Autonomous Data Warehouse database.
	//   "AJD" - Autonomous JSON Database.
	//   "APEX" - Autonomous Database with the Oracle APEX Application Development
	// workload type.
	DbWorkload string `json:"dbWorkload,omitempty"`
	// DisasterRecoveryRoleChangedTime: Output only. The date and time the Disaster
	// Recovery role was changed for the standby Autonomous Database.
	DisasterRecoveryRoleChangedTime string `json:"disasterRecoveryRoleChangedTime,omitempty"`
	// EncryptionKey: Optional. The encryption key used to encrypt the Autonomous
	// Database. Updating this field will add a new entry in the
	// `encryption_key_history_entries` field with the former version.
	EncryptionKey *EncryptionKey `json:"encryptionKey,omitempty"`
	// EncryptionKeyHistoryEntries: Output only. The history of the encryption keys
	// used to encrypt the Autonomous Database.
	EncryptionKeyHistoryEntries []*EncryptionKeyHistoryEntry `json:"encryptionKeyHistoryEntries,omitempty"`
	// FailedDataRecoveryDuration: Output only. This field indicates the number of
	// seconds of data loss during a Data Guard failover.
	FailedDataRecoveryDuration string `json:"failedDataRecoveryDuration,omitempty"`
	// IsAutoScalingEnabled: Optional. This field indicates if auto scaling is
	// enabled for the Autonomous Database CPU core count.
	IsAutoScalingEnabled bool `json:"isAutoScalingEnabled,omitempty"`
	// IsLocalDataGuardEnabled: Output only. This field indicates whether the
	// Autonomous Database has local (in-region) Data Guard enabled.
	IsLocalDataGuardEnabled bool `json:"isLocalDataGuardEnabled,omitempty"`
	// IsStorageAutoScalingEnabled: Optional. This field indicates if auto scaling
	// is enabled for the Autonomous Database storage.
	IsStorageAutoScalingEnabled bool `json:"isStorageAutoScalingEnabled,omitempty"`
	// LicenseType: Required. The license type used for the Autonomous Database.
	//
	// Possible values:
	//   "LICENSE_TYPE_UNSPECIFIED" - Unspecified
	//   "LICENSE_INCLUDED" - License included part of offer
	//   "BRING_YOUR_OWN_LICENSE" - Bring your own license
	LicenseType string `json:"licenseType,omitempty"`
	// LifecycleDetails: Output only. The details of the current lifestyle state of
	// the Autonomous Database.
	LifecycleDetails string `json:"lifecycleDetails,omitempty"`
	// LocalAdgAutoFailoverMaxDataLossLimit: Output only. This field indicates the
	// maximum data loss limit for an Autonomous Database, in seconds.
	LocalAdgAutoFailoverMaxDataLossLimit int64 `json:"localAdgAutoFailoverMaxDataLossLimit,omitempty"`
	// LocalDisasterRecoveryType: Output only. This field indicates the local
	// disaster recovery (DR) type of an Autonomous Database.
	//
	// Possible values:
	//   "LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED" - Default unspecified value.
	//   "ADG" - Autonomous Data Guard recovery.
	//   "BACKUP_BASED" - Backup based recovery.
	LocalDisasterRecoveryType string `json:"localDisasterRecoveryType,omitempty"`
	// LocalStandbyDb: Output only. The details of the Autonomous Data Guard
	// standby database.
	LocalStandbyDb *AutonomousDatabaseStandbySummary `json:"localStandbyDb,omitempty"`
	// MaintenanceBeginTime: Output only. The date and time when maintenance will
	// begin.
	MaintenanceBeginTime string `json:"maintenanceBeginTime,omitempty"`
	// MaintenanceEndTime: Output only. The date and time when maintenance will
	// end.
	MaintenanceEndTime string `json:"maintenanceEndTime,omitempty"`
	// MaintenanceScheduleType: Optional. The maintenance schedule of the
	// Autonomous Database.
	//
	// Possible values:
	//   "MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED" - Default unspecified value.
	//   "EARLY" - An EARLY maintenance schedule patches the database before the
	// regular scheduled maintenance.
	//   "REGULAR" - A REGULAR maintenance schedule follows the normal maintenance
	// cycle.
	MaintenanceScheduleType string `json:"maintenanceScheduleType,omitempty"`
	// MemoryPerOracleComputeUnitGbs: Output only. The amount of memory enabled per
	// ECPU, in gigabytes.
	MemoryPerOracleComputeUnitGbs int64 `json:"memoryPerOracleComputeUnitGbs,omitempty"`
	// MemoryTableGbs: Output only. The memory assigned to in-memory tables in an
	// Autonomous Database.
	MemoryTableGbs int64 `json:"memoryTableGbs,omitempty"`
	// MtlsConnectionRequired: Optional. This field specifies if the Autonomous
	// Database requires mTLS connections.
	MtlsConnectionRequired bool `json:"mtlsConnectionRequired,omitempty"`
	// NCharacterSet: Optional. The national character set for the Autonomous
	// Database. The default is AL16UTF16.
	NCharacterSet string `json:"nCharacterSet,omitempty"`
	// NextLongTermBackupTime: Output only. The long term backup schedule of the
	// Autonomous Database.
	NextLongTermBackupTime string `json:"nextLongTermBackupTime,omitempty"`
	// OciUrl: Output only. The Oracle Cloud Infrastructure link for the Autonomous
	// Database.
	OciUrl string `json:"ociUrl,omitempty"`
	// Ocid: Output only. OCID of the Autonomous Database.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `json:"ocid,omitempty"`
	// OpenMode: Output only. This field indicates the current mode of the
	// Autonomous Database.
	//
	// Possible values:
	//   "OPEN_MODE_UNSPECIFIED" - Default unspecified value.
	//   "READ_ONLY" - Read Only Mode
	//   "READ_WRITE" - Read Write Mode
	OpenMode string `json:"openMode,omitempty"`
	// OperationsInsightsState: Output only. This field indicates the state of
	// Operations Insights for the Autonomous Database.
	//
	// Possible values:
	//   "OPERATIONS_INSIGHTS_STATE_UNSPECIFIED" - Default unspecified value.
	//   "ENABLING" - Enabling status for operation insights.
	//   "ENABLED" - Enabled status for operation insights.
	//   "DISABLING" - Disabling status for operation insights.
	//   "NOT_ENABLED" - Not Enabled status for operation insights.
	//   "FAILED_ENABLING" - Failed enabling status for operation insights.
	//   "FAILED_DISABLING" - Failed disabling status for operation insights.
	OperationsInsightsState string `json:"operationsInsightsState,omitempty"`
	// PeerDbIds: Output only. The list of OCIDs of standby databases located in
	// Autonomous Data Guard remote regions that are associated with the source
	// database.
	PeerDbIds []string `json:"peerDbIds,omitempty"`
	// PermissionLevel: Output only. The permission level of the Autonomous
	// Database.
	//
	// Possible values:
	//   "PERMISSION_LEVEL_UNSPECIFIED" - Default unspecified value.
	//   "RESTRICTED" - Restricted mode allows access only by admin users.
	//   "UNRESTRICTED" - Normal access.
	PermissionLevel string `json:"permissionLevel,omitempty"`
	// PrivateEndpoint: Output only. The private endpoint for the Autonomous
	// Database.
	PrivateEndpoint string `json:"privateEndpoint,omitempty"`
	// PrivateEndpointIp: Optional. The private endpoint IP address for the
	// Autonomous Database.
	PrivateEndpointIp string `json:"privateEndpointIp,omitempty"`
	// PrivateEndpointLabel: Optional. The private endpoint label for the
	// Autonomous Database.
	PrivateEndpointLabel string `json:"privateEndpointLabel,omitempty"`
	// RefreshableMode: Output only. The refresh mode of the cloned Autonomous
	// Database.
	//
	// Possible values:
	//   "REFRESHABLE_MODE_UNSPECIFIED" - The default unspecified value.
	//   "AUTOMATIC" - AUTOMATIC indicates that the cloned database is
	// automatically refreshed with data from the source Autonomous Database.
	//   "MANUAL" - MANUAL indicates that the cloned database is manually refreshed
	// with data from the source Autonomous Database.
	RefreshableMode string `json:"refreshableMode,omitempty"`
	// RefreshableState: Output only. The refresh State of the clone.
	//
	// Possible values:
	//   "REFRESHABLE_STATE_UNSPECIFIED" - Default unspecified value.
	//   "REFRESHING" - Refreshing
	//   "NOT_REFRESHING" - Not refreshed
	RefreshableState string `json:"refreshableState,omitempty"`
	// Role: Output only. The Data Guard role of the Autonomous Database.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Default unspecified value.
	//   "PRIMARY" - Primary role
	//   "STANDBY" - Standby role
	//   "DISABLED_STANDBY" - Disabled standby role
	//   "BACKUP_COPY" - Backup copy role
	//   "SNAPSHOT_STANDBY" - Snapshot standby role
	Role string `json:"role,omitempty"`
	// ScheduledOperationDetails: Output only. The list and details of the
	// scheduled operations of the Autonomous Database.
	ScheduledOperationDetails []*ScheduledOperationDetails `json:"scheduledOperationDetails,omitempty"`
	// SecretId: Optional. The ID of the Oracle Cloud Infrastructure vault secret.
	SecretId string `json:"secretId,omitempty"`
	// ServiceAgentEmail: Output only. An Oracle-managed Google Cloud service
	// account on which customers can grant roles to access resources in the
	// customer project.
	ServiceAgentEmail string `json:"serviceAgentEmail,omitempty"`
	// SqlWebDeveloperUrl: Output only. The SQL Web Developer URL for the
	// Autonomous Database.
	SqlWebDeveloperUrl string `json:"sqlWebDeveloperUrl,omitempty"`
	// State: Output only. The current lifecycle state of the Autonomous Database.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the Autonomous Database is in provisioning
	// state.
	//   "AVAILABLE" - Indicates that the Autonomous Database is in available
	// state.
	//   "STOPPING" - Indicates that the Autonomous Database is in stopping state.
	//   "STOPPED" - Indicates that the Autonomous Database is in stopped state.
	//   "STARTING" - Indicates that the Autonomous Database is in starting state.
	//   "TERMINATING" - Indicates that the Autonomous Database is in terminating
	// state.
	//   "TERMINATED" - Indicates that the Autonomous Database is in terminated
	// state.
	//   "UNAVAILABLE" - Indicates that the Autonomous Database is in unavailable
	// state.
	//   "RESTORE_IN_PROGRESS" - Indicates that the Autonomous Database restore is
	// in progress.
	//   "RESTORE_FAILED" - Indicates that the Autonomous Database failed to
	// restore.
	//   "BACKUP_IN_PROGRESS" - Indicates that the Autonomous Database backup is in
	// progress.
	//   "SCALE_IN_PROGRESS" - Indicates that the Autonomous Database scale is in
	// progress.
	//   "AVAILABLE_NEEDS_ATTENTION" - Indicates that the Autonomous Database is
	// available but needs attention state.
	//   "UPDATING" - Indicates that the Autonomous Database is in updating state.
	//   "MAINTENANCE_IN_PROGRESS" - Indicates that the Autonomous Database's
	// maintenance is in progress state.
	//   "RESTARTING" - Indicates that the Autonomous Database is in restarting
	// state.
	//   "RECREATING" - Indicates that the Autonomous Database is in recreating
	// state.
	//   "ROLE_CHANGE_IN_PROGRESS" - Indicates that the Autonomous Database's role
	// change is in progress state.
	//   "UPGRADING" - Indicates that the Autonomous Database is in upgrading
	// state.
	//   "INACCESSIBLE" - Indicates that the Autonomous Database is in inaccessible
	// state.
	//   "STANDBY" - Indicates that the Autonomous Database is in standby state.
	State string `json:"state,omitempty"`
	// SupportedCloneRegions: Output only. The list of available regions that can
	// be used to create a clone for the Autonomous Database.
	SupportedCloneRegions []string `json:"supportedCloneRegions,omitempty"`
	// TotalAutoBackupStorageSizeGbs: Output only. The storage space used by
	// automatic backups of Autonomous Database, in gigabytes.
	TotalAutoBackupStorageSizeGbs float64 `json:"totalAutoBackupStorageSizeGbs,omitempty"`
	// UsedDataStorageSizeTbs: Output only. The storage space used by Autonomous
	// Database, in gigabytes.
	UsedDataStorageSizeTbs int64 `json:"usedDataStorageSizeTbs,omitempty"`
	// VaultId: Optional. The ID of the Oracle Cloud Infrastructure vault.
	VaultId string `json:"vaultId,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ActualUsedDataStorageSizeTb") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActualUsedDataStorageSizeTb") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AutonomousDatabaseProperties) UnmarshalJSON(data []byte) error {
	type NoMethod AutonomousDatabaseProperties
	var s1 struct {
		ActualUsedDataStorageSizeTb   gensupport.JSONFloat64 `json:"actualUsedDataStorageSizeTb"`
		AllocatedStorageSizeTb        gensupport.JSONFloat64 `json:"allocatedStorageSizeTb"`
		ComputeCount                  gensupport.JSONFloat64 `json:"computeCount"`
		TotalAutoBackupStorageSizeGbs gensupport.JSONFloat64 `json:"totalAutoBackupStorageSizeGbs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ActualUsedDataStorageSizeTb = float64(s1.ActualUsedDataStorageSizeTb)
	s.AllocatedStorageSizeTb = float64(s1.AllocatedStorageSizeTb)
	s.ComputeCount = float64(s1.ComputeCount)
	s.TotalAutoBackupStorageSizeGbs = float64(s1.TotalAutoBackupStorageSizeGbs)
	return nil
}

// AutonomousDatabaseStandbySummary: Autonomous Data Guard standby database
// details.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseStandbySummary
type AutonomousDatabaseStandbySummary struct {
	// DataGuardRoleChangedTime: Output only. The date and time the Autonomous Data
	// Guard role was switched for the standby Autonomous Database.
	DataGuardRoleChangedTime string `json:"dataGuardRoleChangedTime,omitempty"`
	// DisasterRecoveryRoleChangedTime: Output only. The date and time the Disaster
	// Recovery role was switched for the standby Autonomous Database.
	DisasterRecoveryRoleChangedTime string `json:"disasterRecoveryRoleChangedTime,omitempty"`
	// LagTimeDuration: Output only. The amount of time, in seconds, that the data
	// of the standby database lags in comparison to the data of the primary
	// database.
	LagTimeDuration string `json:"lagTimeDuration,omitempty"`
	// LifecycleDetails: Output only. The additional details about the current
	// lifecycle state of the Autonomous Database.
	LifecycleDetails string `json:"lifecycleDetails,omitempty"`
	// State: Output only. The current lifecycle state of the Autonomous Database.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the Autonomous Database is in provisioning
	// state.
	//   "AVAILABLE" - Indicates that the Autonomous Database is in available
	// state.
	//   "STOPPING" - Indicates that the Autonomous Database is in stopping state.
	//   "STOPPED" - Indicates that the Autonomous Database is in stopped state.
	//   "STARTING" - Indicates that the Autonomous Database is in starting state.
	//   "TERMINATING" - Indicates that the Autonomous Database is in terminating
	// state.
	//   "TERMINATED" - Indicates that the Autonomous Database is in terminated
	// state.
	//   "UNAVAILABLE" - Indicates that the Autonomous Database is in unavailable
	// state.
	//   "RESTORE_IN_PROGRESS" - Indicates that the Autonomous Database restore is
	// in progress.
	//   "RESTORE_FAILED" - Indicates that the Autonomous Database failed to
	// restore.
	//   "BACKUP_IN_PROGRESS" - Indicates that the Autonomous Database backup is in
	// progress.
	//   "SCALE_IN_PROGRESS" - Indicates that the Autonomous Database scale is in
	// progress.
	//   "AVAILABLE_NEEDS_ATTENTION" - Indicates that the Autonomous Database is
	// available but needs attention state.
	//   "UPDATING" - Indicates that the Autonomous Database is in updating state.
	//   "MAINTENANCE_IN_PROGRESS" - Indicates that the Autonomous Database's
	// maintenance is in progress state.
	//   "RESTARTING" - Indicates that the Autonomous Database is in restarting
	// state.
	//   "RECREATING" - Indicates that the Autonomous Database is in recreating
	// state.
	//   "ROLE_CHANGE_IN_PROGRESS" - Indicates that the Autonomous Database's role
	// change is in progress state.
	//   "UPGRADING" - Indicates that the Autonomous Database is in upgrading
	// state.
	//   "INACCESSIBLE" - Indicates that the Autonomous Database is in inaccessible
	// state.
	//   "STANDBY" - Indicates that the Autonomous Database is in standby state.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataGuardRoleChangedTime")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataGuardRoleChangedTime") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDatabaseStandbySummary) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDatabaseStandbySummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutonomousDbVersion: Details of the Autonomous Database version.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDbVersionSummary/
type AutonomousDbVersion struct {
	// DbWorkload: Output only. The Autonomous Database workload type.
	//
	// Possible values:
	//   "DB_WORKLOAD_UNSPECIFIED" - Default unspecified value.
	//   "OLTP" - Autonomous Transaction Processing database.
	//   "DW" - Autonomous Data Warehouse database.
	//   "AJD" - Autonomous JSON Database.
	//   "APEX" - Autonomous Database with the Oracle APEX Application Development
	// workload type.
	DbWorkload string `json:"dbWorkload,omitempty"`
	// Name: Identifier. The name of the Autonomous Database Version resource with
	// the format:
	// projects/{project}/locations/{region}/autonomousDbVersions/{autonomous_db_ver
	// sion}
	Name string `json:"name,omitempty"`
	// Version: Output only. An Oracle Database version for Autonomous Database.
	Version string `json:"version,omitempty"`
	// WorkloadUri: Output only. A URL that points to a detailed description of the
	// Autonomous Database version.
	WorkloadUri string `json:"workloadUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DbWorkload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbWorkload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutonomousDbVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AutonomousDbVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupDestinationDetails: The details of the database backup destination.
type BackupDestinationDetails struct {
	// Type: Optional. The type of the database backup destination.
	//
	// Possible values:
	//   "BACKUP_DESTINATION_TYPE_UNSPECIFIED" - Default unspecified value.
	//   "NFS" - Backup destination type is NFS.
	//   "RECOVERY_APPLIANCE" - Backup destination type is Recovery Appliance.
	//   "OBJECT_STORE" - Backup destination type is Object Store.
	//   "LOCAL" - Backup destination type is Local.
	//   "DBRS" - Backup destination type is DBRS.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupDestinationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod BackupDestinationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CloudAccountDetails: Details of the OCI Cloud Account.
type CloudAccountDetails struct {
	// AccountCreationUri: Output only. URL to create a new account and link.
	AccountCreationUri string `json:"accountCreationUri,omitempty"`
	// CloudAccount: Output only. OCI account name.
	CloudAccount string `json:"cloudAccount,omitempty"`
	// CloudAccountHomeRegion: Output only. OCI account home region.
	CloudAccountHomeRegion string `json:"cloudAccountHomeRegion,omitempty"`
	// LinkExistingAccountUri: Output only. URL to link an existing account.
	LinkExistingAccountUri string `json:"linkExistingAccountUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountCreationUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountCreationUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAccountDetails) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAccountDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudExadataInfrastructure: Represents CloudExadataInfrastructure resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudExadataInfrastructure/
type CloudExadataInfrastructure struct {
	// CreateTime: Output only. The date and time that the Exadata Infrastructure
	// was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. User friendly name for this resource.
	DisplayName string `json:"displayName,omitempty"`
	// EntitlementId: Output only. Entitlement ID of the private offer against
	// which this infrastructure resource is provisioned.
	EntitlementId string `json:"entitlementId,omitempty"`
	// GcpOracleZone: Optional. The GCP Oracle zone where Oracle Exadata
	// Infrastructure is hosted. Example: us-east4-b-r2. If not specified, the
	// system will pick a zone based on availability.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Labels: Optional. Labels or tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the Exadata Infrastructure resource with the
	// format:
	// projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exad
	// ata_infrastructure}
	Name string `json:"name,omitempty"`
	// Properties: Optional. Various properties of the infra.
	Properties *CloudExadataInfrastructureProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudExadataInfrastructure) MarshalJSON() ([]byte, error) {
	type NoMethod CloudExadataInfrastructure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudExadataInfrastructureProperties: Various properties of Exadata
// Infrastructure.
type CloudExadataInfrastructureProperties struct {
	// ActivatedStorageCount: Output only. The requested number of additional
	// storage servers activated for the Exadata Infrastructure.
	ActivatedStorageCount int64 `json:"activatedStorageCount,omitempty"`
	// AdditionalStorageCount: Output only. The requested number of additional
	// storage servers for the Exadata Infrastructure.
	AdditionalStorageCount int64 `json:"additionalStorageCount,omitempty"`
	// AvailableStorageSizeGb: Output only. The available storage can be allocated
	// to the Exadata Infrastructure resource, in gigabytes (GB).
	AvailableStorageSizeGb int64 `json:"availableStorageSizeGb,omitempty"`
	// ComputeCount: Optional. The number of compute servers for the Exadata
	// Infrastructure.
	ComputeCount int64 `json:"computeCount,omitempty"`
	// ComputeModel: Output only. The compute model of the Exadata Infrastructure.
	//
	// Possible values:
	//   "COMPUTE_MODEL_UNSPECIFIED" - Unspecified compute model.
	//   "COMPUTE_MODEL_ECPU" - Abstract measure of compute resources. ECPUs are
	// based on the number of cores elastically allocated from a pool of compute
	// and storage servers.
	//   "COMPUTE_MODEL_OCPU" - Physical measure of compute resources. OCPUs are
	// based on the physical core of a processor.
	ComputeModel string `json:"computeModel,omitempty"`
	// CpuCount: Output only. The number of enabled CPU cores.
	CpuCount int64 `json:"cpuCount,omitempty"`
	// CustomerContacts: Optional. The list of customer contacts.
	CustomerContacts []*CustomerContact `json:"customerContacts,omitempty"`
	// DataStorageSizeTb: Output only. Size, in terabytes, of the DATA disk group.
	DataStorageSizeTb float64 `json:"dataStorageSizeTb,omitempty"`
	// DatabaseServerType: Output only. The database server type of the Exadata
	// Infrastructure.
	DatabaseServerType string `json:"databaseServerType,omitempty"`
	// DbNodeStorageSizeGb: Output only. The local node storage allocated in GBs.
	DbNodeStorageSizeGb int64 `json:"dbNodeStorageSizeGb,omitempty"`
	// DbServerVersion: Output only. The software version of the database servers
	// (dom0) in the Exadata Infrastructure.
	DbServerVersion string `json:"dbServerVersion,omitempty"`
	// MaintenanceWindow: Optional. Maintenance window for repair.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// MaxCpuCount: Output only. The total number of CPU cores available.
	MaxCpuCount int64 `json:"maxCpuCount,omitempty"`
	// MaxDataStorageTb: Output only. The total available DATA disk group size.
	MaxDataStorageTb float64 `json:"maxDataStorageTb,omitempty"`
	// MaxDbNodeStorageSizeGb: Output only. The total local node storage available
	// in GBs.
	MaxDbNodeStorageSizeGb int64 `json:"maxDbNodeStorageSizeGb,omitempty"`
	// MaxMemoryGb: Output only. The total memory available in GBs.
	MaxMemoryGb int64 `json:"maxMemoryGb,omitempty"`
	// MemorySizeGb: Output only. The memory allocated in GBs.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// MonthlyDbServerVersion: Output only. The monthly software version of the
	// database servers (dom0) in the Exadata Infrastructure. Example: 20.1.15
	MonthlyDbServerVersion string `json:"monthlyDbServerVersion,omitempty"`
	// MonthlyStorageServerVersion: Output only. The monthly software version of
	// the storage servers (cells) in the Exadata Infrastructure. Example: 20.1.15
	MonthlyStorageServerVersion string `json:"monthlyStorageServerVersion,omitempty"`
	// NextMaintenanceRunId: Output only. The OCID of the next maintenance run.
	NextMaintenanceRunId string `json:"nextMaintenanceRunId,omitempty"`
	// NextMaintenanceRunTime: Output only. The time when the next maintenance run
	// will occur.
	NextMaintenanceRunTime string `json:"nextMaintenanceRunTime,omitempty"`
	// NextSecurityMaintenanceRunTime: Output only. The time when the next security
	// maintenance run will occur.
	NextSecurityMaintenanceRunTime string `json:"nextSecurityMaintenanceRunTime,omitempty"`
	// OciUrl: Output only. Deep link to the OCI console to view this resource.
	OciUrl string `json:"ociUrl,omitempty"`
	// Ocid: Output only. OCID of created infra.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `json:"ocid,omitempty"`
	// Shape: Required. The shape of the Exadata Infrastructure. The shape
	// determines the amount of CPU, storage, and memory resources allocated to the
	// instance.
	Shape string `json:"shape,omitempty"`
	// State: Output only. The current lifecycle state of the Exadata
	// Infrastructure.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - The Exadata Infrastructure is being provisioned.
	//   "AVAILABLE" - The Exadata Infrastructure is available for use.
	//   "UPDATING" - The Exadata Infrastructure is being updated.
	//   "TERMINATING" - The Exadata Infrastructure is being terminated.
	//   "TERMINATED" - The Exadata Infrastructure is terminated.
	//   "FAILED" - The Exadata Infrastructure is in failed state.
	//   "MAINTENANCE_IN_PROGRESS" - The Exadata Infrastructure is in maintenance.
	State string `json:"state,omitempty"`
	// StorageCount: Optional. The number of Cloud Exadata storage servers for the
	// Exadata Infrastructure.
	StorageCount int64 `json:"storageCount,omitempty"`
	// StorageServerType: Output only. The storage server type of the Exadata
	// Infrastructure.
	StorageServerType string `json:"storageServerType,omitempty"`
	// StorageServerVersion: Output only. The software version of the storage
	// servers (cells) in the Exadata Infrastructure.
	StorageServerVersion string `json:"storageServerVersion,omitempty"`
	// TotalStorageSizeGb: Optional. The total storage allocated to the Exadata
	// Infrastructure resource, in gigabytes (GB).
	TotalStorageSizeGb int64 `json:"totalStorageSizeGb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivatedStorageCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivatedStorageCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudExadataInfrastructureProperties) MarshalJSON() ([]byte, error) {
	type NoMethod CloudExadataInfrastructureProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudExadataInfrastructureProperties) UnmarshalJSON(data []byte) error {
	type NoMethod CloudExadataInfrastructureProperties
	var s1 struct {
		DataStorageSizeTb gensupport.JSONFloat64 `json:"dataStorageSizeTb"`
		MaxDataStorageTb  gensupport.JSONFloat64 `json:"maxDataStorageTb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DataStorageSizeTb = float64(s1.DataStorageSizeTb)
	s.MaxDataStorageTb = float64(s1.MaxDataStorageTb)
	return nil
}

// CloudVmCluster: Details of the Cloud VM Cluster resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudVmCluster/
type CloudVmCluster struct {
	// BackupOdbSubnet: Optional. The name of the backup OdbSubnet associated with
	// the VM Cluster. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	BackupOdbSubnet string `json:"backupOdbSubnet,omitempty"`
	// BackupSubnetCidr: Optional. CIDR range of the backup subnet.
	BackupSubnetCidr string `json:"backupSubnetCidr,omitempty"`
	// Cidr: Optional. Network settings. CIDR to use for cluster IP allocation.
	Cidr string `json:"cidr,omitempty"`
	// CreateTime: Output only. The date and time that the VM cluster was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. User friendly name for this resource.
	DisplayName string `json:"displayName,omitempty"`
	// ExadataInfrastructure: Required. The name of the Exadata Infrastructure
	// resource on which VM cluster resource is created, in the following format:
	// projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extra
	// data_infrastructure}
	ExadataInfrastructure string `json:"exadataInfrastructure,omitempty"`
	// GcpOracleZone: Output only. The GCP Oracle zone where Oracle CloudVmCluster
	// is hosted. This will be the same as the gcp_oracle_zone of the
	// CloudExadataInfrastructure. Example: us-east4-b-r2.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// IdentityConnector: Output only. The identity connector details which will
	// allow OCI to securely access the resources in the customer project.
	IdentityConnector *IdentityConnector `json:"identityConnector,omitempty"`
	// Labels: Optional. Labels or tags associated with the VM Cluster.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the VM Cluster resource with the format:
	// projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
	Name string `json:"name,omitempty"`
	// Network: Optional. The name of the VPC network. Format:
	// projects/{project}/global/networks/{network}
	Network string `json:"network,omitempty"`
	// OdbNetwork: Optional. The name of the OdbNetwork associated with the VM
	// Cluster. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
	// optional but if specified, this should match the parent ODBNetwork of the
	// odb_subnet and backup_odb_subnet.
	OdbNetwork string `json:"odbNetwork,omitempty"`
	// OdbSubnet: Optional. The name of the OdbSubnet associated with the VM
	// Cluster for IP allocation. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	OdbSubnet string `json:"odbSubnet,omitempty"`
	// Properties: Optional. Various properties of the VM Cluster.
	Properties *CloudVmClusterProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupOdbSubnet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupOdbSubnet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudVmCluster) MarshalJSON() ([]byte, error) {
	type NoMethod CloudVmCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudVmClusterProperties: Various properties and settings associated with
// Exadata VM cluster.
type CloudVmClusterProperties struct {
	// ClusterName: Optional. OCI Cluster name.
	ClusterName string `json:"clusterName,omitempty"`
	// CompartmentId: Output only. Compartment ID of cluster.
	CompartmentId string `json:"compartmentId,omitempty"`
	// ComputeModel: Output only. The compute model of the VM Cluster.
	//
	// Possible values:
	//   "COMPUTE_MODEL_UNSPECIFIED" - Unspecified compute model.
	//   "COMPUTE_MODEL_ECPU" - Abstract measure of compute resources. ECPUs are
	// based on the number of cores elastically allocated from a pool of compute
	// and storage servers.
	//   "COMPUTE_MODEL_OCPU" - Physical measure of compute resources. OCPUs are
	// based on the physical core of a processor.
	ComputeModel string `json:"computeModel,omitempty"`
	// CpuCoreCount: Required. Number of enabled CPU cores.
	CpuCoreCount int64 `json:"cpuCoreCount,omitempty"`
	// DataStorageSizeTb: Optional. The data disk group size to be allocated in
	// TBs.
	DataStorageSizeTb float64 `json:"dataStorageSizeTb,omitempty"`
	// DbNodeStorageSizeGb: Optional. Local storage per VM.
	DbNodeStorageSizeGb int64 `json:"dbNodeStorageSizeGb,omitempty"`
	// DbServerOcids: Optional. OCID of database servers.
	DbServerOcids []string `json:"dbServerOcids,omitempty"`
	// DiagnosticsDataCollectionOptions: Optional. Data collection options for
	// diagnostics.
	DiagnosticsDataCollectionOptions *DataCollectionOptions `json:"diagnosticsDataCollectionOptions,omitempty"`
	// DiskRedundancy: Optional. The type of redundancy.
	//
	// Possible values:
	//   "DISK_REDUNDANCY_UNSPECIFIED" - Unspecified.
	//   "HIGH" - High - 3 way mirror.
	//   "NORMAL" - Normal - 2 way mirror.
	DiskRedundancy string `json:"diskRedundancy,omitempty"`
	// DnsListenerIp: Output only. DNS listener IP.
	DnsListenerIp string `json:"dnsListenerIp,omitempty"`
	// Domain: Output only. Parent DNS domain where SCAN DNS and hosts names are
	// qualified. ex: ocispdelegated.ocisp10jvnet.oraclevcn.com
	Domain string `json:"domain,omitempty"`
	// GiVersion: Optional. Grid Infrastructure Version.
	GiVersion string `json:"giVersion,omitempty"`
	// Hostname: Output only. host name without domain. format: "-" with some
	// suffix. ex: sp2-yi0xq where "sp2" is the hostname_prefix.
	Hostname string `json:"hostname,omitempty"`
	// HostnamePrefix: Optional. Prefix for VM cluster host names.
	HostnamePrefix string `json:"hostnamePrefix,omitempty"`
	// LicenseType: Required. License type of VM Cluster.
	//
	// Possible values:
	//   "LICENSE_TYPE_UNSPECIFIED" - Unspecified
	//   "LICENSE_INCLUDED" - License included part of offer
	//   "BRING_YOUR_OWN_LICENSE" - Bring your own license
	LicenseType string `json:"licenseType,omitempty"`
	// LocalBackupEnabled: Optional. Use local backup.
	LocalBackupEnabled bool `json:"localBackupEnabled,omitempty"`
	// MemorySizeGb: Optional. Memory allocated in GBs.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// NodeCount: Optional. Number of database servers.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// OciUrl: Output only. Deep link to the OCI console to view this resource.
	OciUrl string `json:"ociUrl,omitempty"`
	// Ocid: Output only. Oracle Cloud Infrastructure ID of VM Cluster.
	Ocid string `json:"ocid,omitempty"`
	// OcpuCount: Optional. OCPU count per VM. Minimum is 0.1.
	OcpuCount float64 `json:"ocpuCount,omitempty"`
	// ScanDns: Output only. SCAN DNS name. ex:
	// sp2-yi0xq-scan.ocispdelegated.ocisp10jvnet.oraclevcn.com
	ScanDns string `json:"scanDns,omitempty"`
	// ScanDnsRecordId: Output only. OCID of scan DNS record.
	ScanDnsRecordId string `json:"scanDnsRecordId,omitempty"`
	// ScanIpIds: Output only. OCIDs of scan IPs.
	ScanIpIds []string `json:"scanIpIds,omitempty"`
	// ScanListenerPortTcp: Output only. SCAN listener port - TCP
	ScanListenerPortTcp int64 `json:"scanListenerPortTcp,omitempty"`
	// ScanListenerPortTcpSsl: Output only. SCAN listener port - TLS
	ScanListenerPortTcpSsl int64 `json:"scanListenerPortTcpSsl,omitempty"`
	// Shape: Output only. Shape of VM Cluster.
	Shape string `json:"shape,omitempty"`
	// SparseDiskgroupEnabled: Optional. Use exadata sparse snapshots.
	SparseDiskgroupEnabled bool `json:"sparseDiskgroupEnabled,omitempty"`
	// SshPublicKeys: Optional. SSH public keys to be stored with cluster.
	SshPublicKeys []string `json:"sshPublicKeys,omitempty"`
	// State: Output only. State of the cluster.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "TERMINATED" - Indicates that the resource is in terminated state.
	//   "FAILED" - Indicates that the resource is in failed state.
	//   "MAINTENANCE_IN_PROGRESS" - Indicates that the resource is in maintenance
	// in progress state.
	State string `json:"state,omitempty"`
	// StorageSizeGb: Output only. The storage allocation for the disk group, in
	// gigabytes (GB).
	StorageSizeGb int64 `json:"storageSizeGb,omitempty"`
	// SystemVersion: Optional. Operating system version of the image.
	SystemVersion string `json:"systemVersion,omitempty"`
	// TimeZone: Optional. Time zone of VM Cluster to set. Defaults to UTC if not
	// specified.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudVmClusterProperties) MarshalJSON() ([]byte, error) {
	type NoMethod CloudVmClusterProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudVmClusterProperties) UnmarshalJSON(data []byte) error {
	type NoMethod CloudVmClusterProperties
	var s1 struct {
		DataStorageSizeTb gensupport.JSONFloat64 `json:"dataStorageSizeTb"`
		OcpuCount         gensupport.JSONFloat64 `json:"ocpuCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DataStorageSizeTb = float64(s1.DataStorageSizeTb)
	s.OcpuCount = float64(s1.OcpuCount)
	return nil
}

// CustomerContact: The CustomerContact reference as defined by Oracle.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/CustomerContact
type CustomerContact struct {
	// Email: Required. The email address used by Oracle to send notifications
	// regarding databases and infrastructure.
	Email string `json:"email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerContact) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerContact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataCollectionOptions: Data collection options for diagnostics.
type DataCollectionOptions struct {
	// DiagnosticsEventsEnabled: Optional. Indicates whether diagnostic collection
	// is enabled for the VM cluster
	DiagnosticsEventsEnabled bool `json:"diagnosticsEventsEnabled,omitempty"`
	// HealthMonitoringEnabled: Optional. Indicates whether health monitoring is
	// enabled for the VM cluster
	HealthMonitoringEnabled bool `json:"healthMonitoringEnabled,omitempty"`
	// IncidentLogsEnabled: Optional. Indicates whether incident logs and trace
	// collection are enabled for the VM cluster
	IncidentLogsEnabled bool `json:"incidentLogsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiagnosticsEventsEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiagnosticsEventsEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataCollectionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DataCollectionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataCollectionOptionsCommon: Data collection options for diagnostics.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/DataCollectionOptions
type DataCollectionOptionsCommon struct {
	// IsDiagnosticsEventsEnabled: Optional. Indicates whether to enable data
	// collection for diagnostics.
	IsDiagnosticsEventsEnabled bool `json:"isDiagnosticsEventsEnabled,omitempty"`
	// IsHealthMonitoringEnabled: Optional. Indicates whether to enable health
	// monitoring.
	IsHealthMonitoringEnabled bool `json:"isHealthMonitoringEnabled,omitempty"`
	// IsIncidentLogsEnabled: Optional. Indicates whether to enable incident logs
	// and trace collection.
	IsIncidentLogsEnabled bool `json:"isIncidentLogsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDiagnosticsEventsEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDiagnosticsEventsEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataCollectionOptionsCommon) MarshalJSON() ([]byte, error) {
	type NoMethod DataCollectionOptionsCommon
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataCollectionOptionsDbSystem: Data collection options for DbSystem.
type DataCollectionOptionsDbSystem struct {
	// IsDiagnosticsEventsEnabled: Optional. Indicates whether to enable data
	// collection for diagnostics.
	IsDiagnosticsEventsEnabled bool `json:"isDiagnosticsEventsEnabled,omitempty"`
	// IsIncidentLogsEnabled: Optional. Indicates whether to enable incident logs
	// and trace collection.
	IsIncidentLogsEnabled bool `json:"isIncidentLogsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDiagnosticsEventsEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDiagnosticsEventsEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataCollectionOptionsDbSystem) MarshalJSON() ([]byte, error) {
	type NoMethod DataCollectionOptionsDbSystem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Database: Details of the Database resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/Database/
type Database struct {
	// AdminPassword: Required. The password for the default ADMIN user.
	AdminPassword string `json:"adminPassword,omitempty"`
	// CharacterSet: Optional. The character set for the database. The default is
	// AL32UTF8.
	CharacterSet string `json:"characterSet,omitempty"`
	// CreateTime: Output only. The date and time that the Database was created.
	CreateTime string `json:"createTime,omitempty"`
	// DatabaseId: Optional. The database ID of the Database.
	DatabaseId string `json:"databaseId,omitempty"`
	// DbHomeName: Optional. The name of the DbHome resource associated with the
	// Database.
	DbHomeName string `json:"dbHomeName,omitempty"`
	// DbName: Optional. The database name. The name must begin with an alphabetic
	// character and can contain a maximum of eight alphanumeric characters.
	// Special characters are not permitted.
	DbName string `json:"dbName,omitempty"`
	// DbUniqueName: Optional. The DB_UNIQUE_NAME of the Oracle Database being
	// backed up.
	DbUniqueName string `json:"dbUniqueName,omitempty"`
	// GcpOracleZone: Output only. The GCP Oracle zone where the Database is
	// created.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Name: Identifier. The name of the Database resource in the following format:
	// projects/{project}/locations/{region}/databases/{database}
	Name string `json:"name,omitempty"`
	// NcharacterSet: Optional. The national character set for the database. The
	// default is AL16UTF16.
	NcharacterSet string `json:"ncharacterSet,omitempty"`
	// OciUrl: Output only. HTTPS link to OCI resources exposed to Customer via UI
	// Interface.
	OciUrl string `json:"ociUrl,omitempty"`
	// OpsInsightsStatus: Output only. The Status of Operations Insights for this
	// Database.
	//
	// Possible values:
	//   "OPERATIONS_INSIGHTS_STATUS_UNSPECIFIED" - Default unspecified value.
	//   "ENABLING" - Indicates that the operations insights are being enabled.
	//   "ENABLED" - Indicates that the operations insights are enabled.
	//   "DISABLING" - Indicates that the operations insights are being disabled.
	//   "NOT_ENABLED" - Indicates that the operations insights are not enabled.
	//   "FAILED_ENABLING" - Indicates that the operations insights failed to
	// enable.
	//   "FAILED_DISABLING" - Indicates that the operations insights failed to
	// disable.
	OpsInsightsStatus string `json:"opsInsightsStatus,omitempty"`
	// Properties: Optional. The properties of the Database.
	Properties *DatabaseProperties `json:"properties,omitempty"`
	// TdeWalletPassword: Optional. The TDE wallet password for the database.
	TdeWalletPassword string `json:"tdeWalletPassword,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdminPassword") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminPassword") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Database) MarshalJSON() ([]byte, error) {
	type NoMethod Database
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseCharacterSet: Details of the Database character set resource.
type DatabaseCharacterSet struct {
	// CharacterSet: Output only. The character set name for the Database which is
	// the ID in the resource name.
	CharacterSet string `json:"characterSet,omitempty"`
	// CharacterSetType: Output only. The character set type for the Database.
	//
	// Possible values:
	//   "CHARACTER_SET_TYPE_UNSPECIFIED" - Character set type is not specified.
	//   "DATABASE" - Character set type is set to database.
	//   "NATIONAL" - Character set type is set to national.
	CharacterSetType string `json:"characterSetType,omitempty"`
	// Name: Identifier. The name of the Database Character Set resource in the
	// following format:
	// projects/{project}/locations/{region}/databaseCharacterSets/{database_charact
	// er_set}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseCharacterSet) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseCharacterSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseConnectionStringProfile: The connection string profile to allow
// clients to group.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/DatabaseConnectionStringProfile
type DatabaseConnectionStringProfile struct {
	// ConsumerGroup: Output only. The current consumer group being used by the
	// connection.
	//
	// Possible values:
	//   "CONSUMER_GROUP_UNSPECIFIED" - Default unspecified value.
	//   "HIGH" - High consumer group.
	//   "MEDIUM" - Medium consumer group.
	//   "LOW" - Low consumer group.
	//   "TP" - TP consumer group.
	//   "TPURGENT" - TPURGENT consumer group.
	ConsumerGroup string `json:"consumerGroup,omitempty"`
	// DisplayName: Output only. The display name for the database connection.
	DisplayName string `json:"displayName,omitempty"`
	// HostFormat: Output only. The host name format being currently used in
	// connection string.
	//
	// Possible values:
	//   "HOST_FORMAT_UNSPECIFIED" - Default unspecified value.
	//   "FQDN" - FQDN
	//   "IP" - IP
	HostFormat string `json:"hostFormat,omitempty"`
	// IsRegional: Output only. This field indicates if the connection string is
	// regional and is only applicable for cross-region Data Guard.
	IsRegional bool `json:"isRegional,omitempty"`
	// Protocol: Output only. The protocol being used by the connection.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - Default unspecified value.
	//   "TCP" - Tcp
	//   "TCPS" - Tcps
	Protocol string `json:"protocol,omitempty"`
	// SessionMode: Output only. The current session mode of the connection.
	//
	// Possible values:
	//   "SESSION_MODE_UNSPECIFIED" - Default unspecified value.
	//   "DIRECT" - Direct
	//   "INDIRECT" - Indirect
	SessionMode string `json:"sessionMode,omitempty"`
	// SyntaxFormat: Output only. The syntax of the connection string.
	//
	// Possible values:
	//   "SYNTAX_FORMAT_UNSPECIFIED" - Default unspecified value.
	//   "LONG" - Long
	//   "EZCONNECT" - Ezconnect
	//   "EZCONNECTPLUS" - Ezconnectplus
	SyntaxFormat string `json:"syntaxFormat,omitempty"`
	// TlsAuthentication: Output only. This field indicates the TLS authentication
	// type of the connection.
	//
	// Possible values:
	//   "TLS_AUTHENTICATION_UNSPECIFIED" - Default unspecified value.
	//   "SERVER" - Server
	//   "MUTUAL" - Mutual
	TlsAuthentication string `json:"tlsAuthentication,omitempty"`
	// Value: Output only. The value of the connection string.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumerGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumerGroup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseConnectionStringProfile) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseConnectionStringProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseManagementConfig: The configuration of the Database Management
// service.
type DatabaseManagementConfig struct {
	// ManagementState: Output only. The status of the Database Management service.
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - The status is not specified.
	//   "ENABLING" - The Database Management service is enabling.
	//   "ENABLED" - The Database Management service is enabled.
	//   "DISABLING" - The Database Management service is disabling.
	//   "DISABLED" - The Database Management service is disabled.
	//   "UPDATING" - The Database Management service is updating.
	//   "FAILED_ENABLING" - The Database Management service failed to enable.
	//   "FAILED_DISABLING" - The Database Management service failed to disable.
	//   "FAILED_UPDATING" - The Database Management service failed to update.
	ManagementState string `json:"managementState,omitempty"`
	// ManagementType: Output only. The Database Management type.
	//
	// Possible values:
	//   "MANAGEMENT_TYPE_UNSPECIFIED" - The type is not specified.
	//   "BASIC" - Basic Database Management.
	//   "ADVANCED" - Advanced Database Management.
	ManagementType string `json:"managementType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ManagementState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ManagementState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseManagementConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseManagementConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseProperties: The properties of a Database.
type DatabaseProperties struct {
	// DatabaseManagementConfig: Output only. The Database Management config.
	DatabaseManagementConfig *DatabaseManagementConfig `json:"databaseManagementConfig,omitempty"`
	// DbBackupConfig: Optional. Backup options for the Database.
	DbBackupConfig *DbBackupConfig `json:"dbBackupConfig,omitempty"`
	// DbVersion: Required. The Oracle Database version.
	DbVersion string `json:"dbVersion,omitempty"`
	// State: Output only. State of the Database.
	//
	// Possible values:
	//   "DATABASE_LIFECYCLE_STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	//   "BACKUP_IN_PROGRESS" - Indicates that the resource is in backup in
	// progress state.
	//   "UPGRADING" - Indicates that the resource is in upgrading state.
	//   "CONVERTING" - Indicates that the resource is in converting state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "TERMINATED" - Indicates that the resource is in terminated state.
	//   "RESTORE_FAILED" - Indicates that the resource is in restore failed state.
	//   "FAILED" - Indicates that the resource is in failed state.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseManagementConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseManagementConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbBackupConfig: Backup Options for the Database.
type DbBackupConfig struct {
	// AutoBackupEnabled: Optional. If set to true, enables automatic backups on
	// the database.
	AutoBackupEnabled bool `json:"autoBackupEnabled,omitempty"`
	// AutoFullBackupDay: Optional. The day of the week on which the full backup
	// should be performed on the database. If no value is provided, it will
	// default to Sunday.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	AutoFullBackupDay string `json:"autoFullBackupDay,omitempty"`
	// AutoFullBackupWindow: Optional. The window in which the full backup should
	// be performed on the database. If no value is provided, the default is
	// anytime.
	//
	// Possible values:
	//   "BACKUP_WINDOW_UNSPECIFIED" - Default unspecified value.
	//   "SLOT_ONE" - 12:00 AM - 2:00 AM
	//   "SLOT_TWO" - 2:00 AM - 4:00 AM
	//   "SLOT_THREE" - 4:00 AM - 6:00 AM
	//   "SLOT_FOUR" - 6:00 AM - 8:00 AM
	//   "SLOT_FIVE" - 8:00 AM - 10:00 AM
	//   "SLOT_SIX" - 10:00 AM - 12:00 PM
	//   "SLOT_SEVEN" - 12:00 PM - 2:00 PM
	//   "SLOT_EIGHT" - 2:00 PM - 4:00 PM
	//   "SLOT_NINE" - 4:00 PM - 6:00 PM
	//   "SLOT_TEN" - 6:00 PM - 8:00 PM
	//   "SLOT_ELEVEN" - 8:00 PM - 10:00 PM
	//   "SLOT_TWELVE" - 10:00 PM - 12:00 AM
	AutoFullBackupWindow string `json:"autoFullBackupWindow,omitempty"`
	// AutoIncrementalBackupWindow: Optional. The window in which the incremental
	// backup should be performed on the database. If no value is provided, the
	// default is anytime except the auto full backup day.
	//
	// Possible values:
	//   "BACKUP_WINDOW_UNSPECIFIED" - Default unspecified value.
	//   "SLOT_ONE" - 12:00 AM - 2:00 AM
	//   "SLOT_TWO" - 2:00 AM - 4:00 AM
	//   "SLOT_THREE" - 4:00 AM - 6:00 AM
	//   "SLOT_FOUR" - 6:00 AM - 8:00 AM
	//   "SLOT_FIVE" - 8:00 AM - 10:00 AM
	//   "SLOT_SIX" - 10:00 AM - 12:00 PM
	//   "SLOT_SEVEN" - 12:00 PM - 2:00 PM
	//   "SLOT_EIGHT" - 2:00 PM - 4:00 PM
	//   "SLOT_NINE" - 4:00 PM - 6:00 PM
	//   "SLOT_TEN" - 6:00 PM - 8:00 PM
	//   "SLOT_ELEVEN" - 8:00 PM - 10:00 PM
	//   "SLOT_TWELVE" - 10:00 PM - 12:00 AM
	AutoIncrementalBackupWindow string `json:"autoIncrementalBackupWindow,omitempty"`
	// BackupDeletionPolicy: Optional. This defines when the backups will be
	// deleted after Database termination.
	//
	// Possible values:
	//   "BACKUP_DELETION_POLICY_UNSPECIFIED" - Default unspecified value.
	//   "DELETE_IMMEDIATELY" - Keeps the backup for predefined time i.e. 72 hours
	// and then delete permanently.
	//   "DELETE_AFTER_RETENTION_PERIOD" - Keeps the backups as per the policy
	// defined for database backups.
	BackupDeletionPolicy string `json:"backupDeletionPolicy,omitempty"`
	// BackupDestinationDetails: Optional. Details of the database backup
	// destinations.
	BackupDestinationDetails []*BackupDestinationDetails `json:"backupDestinationDetails,omitempty"`
	// RetentionPeriodDays: Optional. The number of days an automatic backup is
	// retained before being automatically deleted. This value determines the
	// earliest point in time to which a database can be restored. Min: 1, Max: 60.
	RetentionPeriodDays int64 `json:"retentionPeriodDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoBackupEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoBackupEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbBackupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DbBackupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbHome: Details of the Database Home resource.
type DbHome struct {
	// Database: Required. The Database resource.
	Database *Database `json:"database,omitempty"`
	// DbVersion: Required. A valid Oracle Database version. For a list of
	// supported versions, use the ListDbVersions operation.
	DbVersion string `json:"dbVersion,omitempty"`
	// DisplayName: Optional. The display name for the Database Home. The name does
	// not have to be unique within your project.
	DisplayName string `json:"displayName,omitempty"`
	// IsUnifiedAuditingEnabled: Optional. Whether unified auditing is enabled for
	// the Database Home.
	IsUnifiedAuditingEnabled bool `json:"isUnifiedAuditingEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Database") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Database") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbHome) MarshalJSON() ([]byte, error) {
	type NoMethod DbHome
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbNode: Details of the database node resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbNode/
type DbNode struct {
	// Name: Identifier. The name of the database node resource in the following
	// format:
	// projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}/db
	// Nodes/{db_node}
	Name string `json:"name,omitempty"`
	// Properties: Optional. Various properties of the database node.
	Properties *DbNodeProperties `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbNode) MarshalJSON() ([]byte, error) {
	type NoMethod DbNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbNodeProperties: Various properties and settings associated with Db node.
type DbNodeProperties struct {
	// CreateTime: Output only. The date and time that the database node was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DbNodeStorageSizeGb: Optional. Local storage per database node.
	DbNodeStorageSizeGb int64 `json:"dbNodeStorageSizeGb,omitempty"`
	// DbServerOcid: Optional. Database server OCID.
	DbServerOcid string `json:"dbServerOcid,omitempty"`
	// Hostname: Optional. DNS
	Hostname string `json:"hostname,omitempty"`
	// MemorySizeGb: Memory allocated in GBs.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// Ocid: Output only. OCID of database node.
	Ocid string `json:"ocid,omitempty"`
	// OcpuCount: Optional. OCPU count per database node.
	OcpuCount int64 `json:"ocpuCount,omitempty"`
	// State: Output only. State of the database node.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	//   "STOPPING" - Indicates that the resource is in stopping state.
	//   "STOPPED" - Indicates that the resource is in stopped state.
	//   "STARTING" - Indicates that the resource is in starting state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "TERMINATED" - Indicates that the resource is in terminated state.
	//   "FAILED" - Indicates that the resource is in failed state.
	State string `json:"state,omitempty"`
	// TotalCpuCoreCount: Total CPU core count of the database node.
	TotalCpuCoreCount int64 `json:"totalCpuCoreCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbNodeProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DbNodeProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbServer: Details of the database server resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbServer/
type DbServer struct {
	// DisplayName: Optional. User friendly name for this resource.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The name of the database server resource with the format:
	// projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_ex
	// adata_infrastructure}/dbServers/{db_server}
	Name string `json:"name,omitempty"`
	// Properties: Optional. Various properties of the database server.
	Properties *DbServerProperties `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbServer) MarshalJSON() ([]byte, error) {
	type NoMethod DbServer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbServerProperties: Various properties and settings associated with Exadata
// database server.
type DbServerProperties struct {
	// DbNodeIds: Output only. OCID of database nodes associated with the database
	// server.
	DbNodeIds []string `json:"dbNodeIds,omitempty"`
	// DbNodeStorageSizeGb: Optional. Local storage per VM.
	DbNodeStorageSizeGb int64 `json:"dbNodeStorageSizeGb,omitempty"`
	// MaxDbNodeStorageSizeGb: Optional. Maximum local storage per VM.
	MaxDbNodeStorageSizeGb int64 `json:"maxDbNodeStorageSizeGb,omitempty"`
	// MaxMemorySizeGb: Optional. Maximum memory allocated in GBs.
	MaxMemorySizeGb int64 `json:"maxMemorySizeGb,omitempty"`
	// MaxOcpuCount: Optional. Maximum OCPU count per database.
	MaxOcpuCount int64 `json:"maxOcpuCount,omitempty"`
	// MemorySizeGb: Optional. Memory allocated in GBs.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// Ocid: Output only. OCID of database server.
	Ocid string `json:"ocid,omitempty"`
	// OcpuCount: Optional. OCPU count per database.
	OcpuCount int64 `json:"ocpuCount,omitempty"`
	// State: Output only. State of the database server.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "CREATING" - Indicates that the resource is in creating state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UNAVAILABLE" - Indicates that the resource is in unavailable state.
	//   "DELETING" - Indicates that the resource is in deleting state.
	//   "DELETED" - Indicates that the resource is in deleted state.
	State string `json:"state,omitempty"`
	// VmCount: Optional. Vm count per database.
	VmCount int64 `json:"vmCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DbNodeIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbNodeIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbServerProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DbServerProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystem: Details of the DbSystem (BaseDB) resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbSystem/
type DbSystem struct {
	// CreateTime: Output only. The date and time that the DbSystem was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name for the System db. The name does not
	// have to be unique within your project.
	DisplayName string `json:"displayName,omitempty"`
	// EntitlementId: Output only. The ID of the subscription entitlement
	// associated with the DbSystem
	EntitlementId string `json:"entitlementId,omitempty"`
	// GcpOracleZone: Optional. The GCP Oracle zone where Oracle DbSystem is
	// hosted. Example: us-east4-b-r2. If not specified, the system will pick a
	// zone based on availability.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Labels: Optional. The labels or tags associated with the DbSystem.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the DbSystem resource in the following format:
	// projects/{project}/locations/{region}/dbSystems/{db_system}
	Name string `json:"name,omitempty"`
	// OciUrl: Output only. HTTPS link to OCI resources exposed to Customer via UI
	// Interface.
	OciUrl string `json:"ociUrl,omitempty"`
	// OdbNetwork: Optional. The name of the OdbNetwork associated with the
	// DbSystem. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
	// optional but if specified, this should match the parent ODBNetwork of the
	// OdbSubnet.
	OdbNetwork string `json:"odbNetwork,omitempty"`
	// OdbSubnet: Required. The name of the OdbSubnet associated with the DbSystem
	// for IP allocation. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	OdbSubnet string `json:"odbSubnet,omitempty"`
	// Properties: Optional. The properties of the DbSystem.
	Properties *DbSystemProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbSystem) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystemInitialStorageSize: Summary of the DbSystem initial storage size.
type DbSystemInitialStorageSize struct {
	// Name: Output only. The name of the resource.
	Name string `json:"name,omitempty"`
	// Properties: Output only. The properties of the DbSystem initial storage size
	// summary.
	Properties *DbSystemInitialStorageSizeProperties `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbSystemInitialStorageSize) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystemInitialStorageSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystemInitialStorageSizeProperties: The properties of a DbSystem initial
// storage size summary.
type DbSystemInitialStorageSizeProperties struct {
	// LaunchFromBackupStorageSizeDetails: Output only. List of storage disk
	// details available for launches from backup.
	LaunchFromBackupStorageSizeDetails []*StorageSizeDetails `json:"launchFromBackupStorageSizeDetails,omitempty"`
	// ShapeType: Output only. VM shape platform type
	//
	// Possible values:
	//   "SHAPE_TYPE_UNSPECIFIED" - Unspecified shape type.
	//   "STANDARD_X86" - Standard X86.
	ShapeType string `json:"shapeType,omitempty"`
	// StorageManagement: Output only. The storage option used in DB system.
	//
	// Possible values:
	//   "STORAGE_MANAGEMENT_UNSPECIFIED" - Unspecified storage management.
	//   "ASM" - Automatic Storage Management.
	//   "LVM" - Logical Volume Management.
	StorageManagement string `json:"storageManagement,omitempty"`
	// StorageSizeDetails: Output only. List of storage disk details.
	StorageSizeDetails []*StorageSizeDetails `json:"storageSizeDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "LaunchFromBackupStorageSizeDetails") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "LaunchFromBackupStorageSizeDetails") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s DbSystemInitialStorageSizeProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystemInitialStorageSizeProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystemOptions: Details of the DbSystem Options.
type DbSystemOptions struct {
	// StorageManagement: Optional. The storage option used in DB system.
	//
	// Possible values:
	//   "STORAGE_MANAGEMENT_UNSPECIFIED" - The storage management is unspecified.
	//   "ASM" - Automatic storage management.
	//   "LVM" - Logical Volume management.
	StorageManagement string `json:"storageManagement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StorageManagement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StorageManagement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbSystemOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystemOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystemProperties: The properties of a DbSystem.
type DbSystemProperties struct {
	// ComputeCount: Required. The number of CPU cores to enable for the DbSystem.
	ComputeCount int64 `json:"computeCount,omitempty"`
	// ComputeModel: Optional. The compute model of the DbSystem.
	//
	// Possible values:
	//   "COMPUTE_MODEL_UNSPECIFIED" - The compute model is unspecified.
	//   "ECPU" - The compute model is virtual.
	//   "OCPU" - The compute model is physical.
	ComputeModel string `json:"computeModel,omitempty"`
	// DataCollectionOptions: Optional. Data collection options for diagnostics.
	DataCollectionOptions *DataCollectionOptionsDbSystem `json:"dataCollectionOptions,omitempty"`
	// DataStorageSizeGb: Optional. The data storage size in GB that is currently
	// available to DbSystems.
	DataStorageSizeGb int64 `json:"dataStorageSizeGb,omitempty"`
	// DatabaseEdition: Required. The database edition of the DbSystem.
	//
	// Possible values:
	//   "DB_SYSTEM_DATABASE_EDITION_UNSPECIFIED" - The database edition is
	// unspecified.
	//   "STANDARD_EDITION" - The database edition is Standard.
	//   "ENTERPRISE_EDITION" - The database edition is Enterprise.
	//   "ENTERPRISE_EDITION_HIGH_PERFORMANCE" - The database edition is Enterprise
	// Edition.
	DatabaseEdition string `json:"databaseEdition,omitempty"`
	// DbHome: Optional. Details for creating a Database Home.
	DbHome *DbHome `json:"dbHome,omitempty"`
	// DbSystemOptions: Optional. The options for the DbSystem.
	DbSystemOptions *DbSystemOptions `json:"dbSystemOptions,omitempty"`
	// Domain: Optional. The host domain name of the DbSystem.
	Domain string `json:"domain,omitempty"`
	// Hostname: Output only. The hostname of the DbSystem.
	Hostname string `json:"hostname,omitempty"`
	// HostnamePrefix: Optional. Prefix for DB System host names.
	HostnamePrefix string `json:"hostnamePrefix,omitempty"`
	// InitialDataStorageSizeGb: Required. The initial data storage size in GB.
	InitialDataStorageSizeGb int64 `json:"initialDataStorageSizeGb,omitempty"`
	// LicenseModel: Required. The license model of the DbSystem.
	//
	// Possible values:
	//   "LICENSE_MODEL_UNSPECIFIED" - The license model is unspecified.
	//   "LICENSE_INCLUDED" - The license model is included.
	//   "BRING_YOUR_OWN_LICENSE" - The license model is bring your own license.
	LicenseModel string `json:"licenseModel,omitempty"`
	// LifecycleState: Output only. State of the DbSystem.
	//
	// Possible values:
	//   "DB_SYSTEM_LIFECYCLE_STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "TERMINATED" - Indicates that the resource is in terminated state.
	//   "FAILED" - Indicates that the resource is in failed state.
	//   "MIGRATED" - Indicates that the resource has been migrated.
	//   "MAINTENANCE_IN_PROGRESS" - Indicates that the resource is in maintenance
	// in progress state.
	//   "NEEDS_ATTENTION" - Indicates that the resource needs attention.
	//   "UPGRADING" - Indicates that the resource is upgrading.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// MemorySizeGb: Optional. The memory size in GB.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// NodeCount: Optional. The number of nodes in the DbSystem.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// Ocid: Output only. OCID of the DbSystem.
	Ocid string `json:"ocid,omitempty"`
	// PrivateIp: Optional. The private IP address of the DbSystem.
	PrivateIp string `json:"privateIp,omitempty"`
	// RecoStorageSizeGb: Optional. The reco/redo storage size in GB.
	RecoStorageSizeGb int64 `json:"recoStorageSizeGb,omitempty"`
	// Shape: Required. Shape of DB System.
	Shape string `json:"shape,omitempty"`
	// SshPublicKeys: Required. SSH public keys to be stored with the DbSystem.
	SshPublicKeys []string `json:"sshPublicKeys,omitempty"`
	// TimeZone: Optional. Time zone of the DbSystem.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbSystemProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystemProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbSystemShape: Details of the Database System Shapes resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbSystemShapeSummary/
type DbSystemShape struct {
	// AvailableCoreCountPerNode: Optional. Number of cores per node.
	AvailableCoreCountPerNode int64 `json:"availableCoreCountPerNode,omitempty"`
	// AvailableDataStorageTb: Optional. Storage per storage server in terabytes.
	AvailableDataStorageTb int64 `json:"availableDataStorageTb,omitempty"`
	// AvailableMemoryPerNodeGb: Optional. Memory per database server node in
	// gigabytes.
	AvailableMemoryPerNodeGb int64 `json:"availableMemoryPerNodeGb,omitempty"`
	// MaxNodeCount: Optional. Maximum number of database servers.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MaxStorageCount: Optional. Maximum number of storage servers.
	MaxStorageCount int64 `json:"maxStorageCount,omitempty"`
	// MinCoreCountPerNode: Optional. Minimum core count per node.
	MinCoreCountPerNode int64 `json:"minCoreCountPerNode,omitempty"`
	// MinDbNodeStoragePerNodeGb: Optional. Minimum node storage per database
	// server in gigabytes.
	MinDbNodeStoragePerNodeGb int64 `json:"minDbNodeStoragePerNodeGb,omitempty"`
	// MinMemoryPerNodeGb: Optional. Minimum memory per node in gigabytes.
	MinMemoryPerNodeGb int64 `json:"minMemoryPerNodeGb,omitempty"`
	// MinNodeCount: Optional. Minimum number of database servers.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// MinStorageCount: Optional. Minimum number of storage servers.
	MinStorageCount int64 `json:"minStorageCount,omitempty"`
	// Name: Identifier. The name of the Database System Shape resource with the
	// format:
	// projects/{project}/locations/{region}/dbSystemShapes/{db_system_shape}
	Name string `json:"name,omitempty"`
	// Shape: Optional. shape
	Shape string `json:"shape,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableCoreCountPerNode")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableCoreCountPerNode") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbSystemShape) MarshalJSON() ([]byte, error) {
	type NoMethod DbSystemShape
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbVersion: A valid Oracle Database version.
type DbVersion struct {
	// Name: Output only. The name of the DbVersion resource in the following
	// format: projects/{project}/locations/{region}/dbVersions/{db_version}
	Name string `json:"name,omitempty"`
	// Properties: Output only. The properties of the DbVersion.
	Properties *DbVersionProperties `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbVersion) MarshalJSON() ([]byte, error) {
	type NoMethod DbVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DbVersionProperties: The properties of a DbVersion.
type DbVersionProperties struct {
	// IsLatestForMajorVersion: Output only. True if this version of the Oracle
	// Database software is the latest version for a release.
	IsLatestForMajorVersion bool `json:"isLatestForMajorVersion,omitempty"`
	// IsPreviewDbVersion: Output only. True if this version of the Oracle Database
	// software is the preview version.
	IsPreviewDbVersion bool `json:"isPreviewDbVersion,omitempty"`
	// IsUpgradeSupported: Output only. True if this version of the Oracle Database
	// software is supported for Upgrade.
	IsUpgradeSupported bool `json:"isUpgradeSupported,omitempty"`
	// SupportsPdb: Output only. True if this version of the Oracle Database
	// software supports pluggable databases.
	SupportsPdb bool `json:"supportsPdb,omitempty"`
	// Version: Output only. A valid Oracle Database version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsLatestForMajorVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsLatestForMajorVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DbVersionProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DbVersionProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefinedTagValue: Wrapper message for the value of a defined tag.
type DefinedTagValue struct {
	// Tags: The tags within the namespace.
	Tags map[string]string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefinedTagValue) MarshalJSON() ([]byte, error) {
	type NoMethod DefinedTagValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionKey: The encryption key used to encrypt the Autonomous Database.
type EncryptionKey struct {
	// KmsKey: Optional. The KMS key used to encrypt the Autonomous Database. This
	// field is required if the provider is GOOGLE_MANAGED. The name of the KMS key
	// resource in the following format:
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryp
	// to_key}`.
	KmsKey string `json:"kmsKey,omitempty"`
	// Provider: Optional. The provider of the encryption key.
	//
	// Possible values:
	//   "PROVIDER_UNSPECIFIED" - Default unspecified value.
	//   "GOOGLE_MANAGED" - Google Managed KMS key, if selected, please provide the
	// KMS key name.
	//   "ORACLE_MANAGED" - Oracle Managed.
	Provider string `json:"provider,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionKey) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EncryptionKeyHistoryEntry: The history of the encryption keys used to
// encrypt the Autonomous Database.
type EncryptionKeyHistoryEntry struct {
	// ActivationTime: Output only. The date and time when the encryption key was
	// activated on the Autonomous Database..
	ActivationTime string `json:"activationTime,omitempty"`
	// EncryptionKey: Output only. The encryption key used to encrypt the
	// Autonomous Database.
	EncryptionKey *EncryptionKey `json:"encryptionKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionKeyHistoryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionKeyHistoryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Entitlement: Details of the Entitlement resource.
type Entitlement struct {
	// CloudAccountDetails: Details of the OCI Cloud Account.
	CloudAccountDetails *CloudAccountDetails `json:"cloudAccountDetails,omitempty"`
	// EntitlementId: Output only. Google Cloud Marketplace order ID (aka
	// entitlement ID)
	EntitlementId string `json:"entitlementId,omitempty"`
	// Name: Identifier. The name of the Entitlement resource with the format:
	// projects/{project}/locations/{region}/entitlements/{entitlement}
	Name string `json:"name,omitempty"`
	// State: Output only. Entitlement State.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "ACCOUNT_NOT_LINKED" - Account not linked.
	//   "ACCOUNT_NOT_ACTIVE" - Account is linked but not active.
	//   "ACTIVE" - Entitlement and Account are active.
	//   "ACCOUNT_SUSPENDED" - Account is suspended.
	//   "NOT_APPROVED_IN_PRIVATE_MARKETPLACE" - Entitlement is not approved in
	// private marketplace.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudAccountDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudAccountDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entitlement) MarshalJSON() ([]byte, error) {
	type NoMethod Entitlement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExadbVmCluster: ExadbVmCluster represents a cluster of VMs that are used to
// run Exadata workloads.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExadbVmCluster/
type ExadbVmCluster struct {
	// BackupOdbSubnet: Required. Immutable. The name of the backup OdbSubnet
	// associated with the ExadbVmCluster. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	BackupOdbSubnet string `json:"backupOdbSubnet,omitempty"`
	// CreateTime: Output only. The date and time that the ExadbVmCluster was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. Immutable. The display name for the ExadbVmCluster.
	// The name does not have to be unique within your project. The name must be
	// 1-255 characters long and can only contain alphanumeric characters.
	DisplayName string `json:"displayName,omitempty"`
	// EntitlementId: Output only. The ID of the subscription entitlement
	// associated with the ExadbVmCluster.
	EntitlementId string `json:"entitlementId,omitempty"`
	// GcpOracleZone: Output only. Immutable. The GCP Oracle zone where Oracle
	// ExadbVmCluster is hosted. Example: us-east4-b-r2. During creation, the
	// system will pick the zone assigned to the ExascaleDbStorageVault.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Labels: Optional. The labels or tags associated with the ExadbVmCluster.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the ExadbVmCluster resource in the following
	// format:
	// projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
	Name string `json:"name,omitempty"`
	// OdbNetwork: Optional. Immutable. The name of the OdbNetwork associated with
	// the ExadbVmCluster. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
	// optional but if specified, this should match the parent ODBNetwork of the
	// OdbSubnet.
	OdbNetwork string `json:"odbNetwork,omitempty"`
	// OdbSubnet: Required. Immutable. The name of the OdbSubnet associated with
	// the ExadbVmCluster for IP allocation. Format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	OdbSubnet string `json:"odbSubnet,omitempty"`
	// Properties: Required. The properties of the ExadbVmCluster.
	Properties *ExadbVmClusterProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupOdbSubnet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupOdbSubnet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExadbVmCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ExadbVmCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExadbVmClusterProperties: The properties of an ExadbVmCluster.
type ExadbVmClusterProperties struct {
	// AdditionalEcpuCountPerNode: Optional. Immutable. The number of additional
	// ECPUs per node for an Exadata VM cluster on exascale infrastructure.
	AdditionalEcpuCountPerNode int64 `json:"additionalEcpuCountPerNode,omitempty"`
	// ClusterName: Optional. Immutable. The cluster name for Exascale vm cluster.
	// The cluster name must begin with an alphabetic character and may contain
	// hyphens(-) but can not contain underscores(_). It should be not more than 11
	// characters and is not case sensitive. OCI Cluster name.
	ClusterName string `json:"clusterName,omitempty"`
	// DataCollectionOptions: Optional. Immutable. Indicates user preference for
	// data collection options.
	DataCollectionOptions *DataCollectionOptionsCommon `json:"dataCollectionOptions,omitempty"`
	// EnabledEcpuCountPerNode: Required. Immutable. The number of ECPUs enabled
	// per node for an exadata vm cluster on exascale infrastructure.
	EnabledEcpuCountPerNode int64 `json:"enabledEcpuCountPerNode,omitempty"`
	// ExascaleDbStorageVault: Required. Immutable. The name of
	// ExascaleDbStorageVault associated with the ExadbVmCluster. It can refer to
	// an existing ExascaleDbStorageVault. Or a new one can be created during the
	// ExadbVmCluster creation (requires storage_vault_properties to be set).
	// Format:
	// projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascale_db_
	// storage_vault}
	ExascaleDbStorageVault string `json:"exascaleDbStorageVault,omitempty"`
	// GiVersion: Output only. The Oracle Grid Infrastructure (GI) software
	// version.
	GiVersion string `json:"giVersion,omitempty"`
	// GridImageId: Required. Immutable. Grid Infrastructure Version.
	GridImageId string `json:"gridImageId,omitempty"`
	// Hostname: Output only. The hostname of the ExadbVmCluster.
	Hostname string `json:"hostname,omitempty"`
	// HostnamePrefix: Required. Immutable. Prefix for VM cluster host names.
	HostnamePrefix string `json:"hostnamePrefix,omitempty"`
	// LicenseModel: Optional. Immutable. The license type of the ExadbVmCluster.
	//
	// Possible values:
	//   "LICENSE_MODEL_UNSPECIFIED" - Unspecified.
	//   "LICENSE_INCLUDED" - Default is license included.
	//   "BRING_YOUR_OWN_LICENSE" - Bring your own license.
	LicenseModel string `json:"licenseModel,omitempty"`
	// LifecycleState: Output only. State of the cluster.
	//
	// Possible values:
	//   "EXADB_VM_CLUSTER_LIFECYCLE_STATE_UNSPECIFIED" - Default unspecified
	// value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "UPDATING" - Indicates that the resource is in updating state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "TERMINATED" - Indicates that the resource is in terminated state.
	//   "FAILED" - Indicates that the resource is in failed state.
	//   "MAINTENANCE_IN_PROGRESS" - Indicates that the resource is in maintenance
	// in progress state.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// MemorySizeGb: Output only. Memory per VM (GB) (Read-only): Shows the amount
	// of memory allocated to each VM. Memory is calculated based on 2.75 GB per
	// Total ECPUs.
	MemorySizeGb int64 `json:"memorySizeGb,omitempty"`
	// NodeCount: Required. The number of nodes/VMs in the ExadbVmCluster.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// OciUri: Output only. Deep link to the OCI console to view this resource.
	OciUri string `json:"ociUri,omitempty"`
	// ScanListenerPortTcp: Optional. Immutable. SCAN listener port - TCP
	ScanListenerPortTcp int64 `json:"scanListenerPortTcp,omitempty"`
	// ShapeAttribute: Required. Immutable. The shape attribute of the VM cluster.
	// The type of Exascale storage used for Exadata VM cluster. The default is
	// SMART_STORAGE which supports Oracle Database 23ai and later
	//
	// Possible values:
	//   "SHAPE_ATTRIBUTE_UNSPECIFIED" - Default unspecified value.
	//   "SMART_STORAGE" - Indicates that the resource is in smart storage.
	//   "BLOCK_STORAGE" - Indicates that the resource is in block storage.
	ShapeAttribute string `json:"shapeAttribute,omitempty"`
	// SshPublicKeys: Required. Immutable. The SSH public keys for the
	// ExadbVmCluster.
	SshPublicKeys []string `json:"sshPublicKeys,omitempty"`
	// TimeZone: Optional. Immutable. The time zone of the ExadbVmCluster.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// VmFileSystemStorage: Required. Immutable. Total storage details for the
	// ExadbVmCluster.
	VmFileSystemStorage *ExadbVmClusterStorageDetails `json:"vmFileSystemStorage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalEcpuCountPerNode")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalEcpuCountPerNode") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExadbVmClusterProperties) MarshalJSON() ([]byte, error) {
	type NoMethod ExadbVmClusterProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExadbVmClusterStorageDetails: The storage allocation for the exadbvmcluster,
// in gigabytes (GB).
type ExadbVmClusterStorageDetails struct {
	// SizeInGbsPerNode: Required. The storage allocation for the exadbvmcluster
	// per node, in gigabytes (GB). This field is used to calculate the total
	// storage allocation for the exadbvmcluster.
	SizeInGbsPerNode int64 `json:"sizeInGbsPerNode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeInGbsPerNode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeInGbsPerNode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExadbVmClusterStorageDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ExadbVmClusterStorageDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExascaleDbStorageDetails: The storage details of the ExascaleDbStorageVault.
type ExascaleDbStorageDetails struct {
	// AvailableSizeGbs: Output only. The available storage capacity for the
	// ExascaleDbStorageVault, in gigabytes (GB).
	AvailableSizeGbs int64 `json:"availableSizeGbs,omitempty"`
	// TotalSizeGbs: Required. The total storage allocation for the
	// ExascaleDbStorageVault, in gigabytes (GB).
	TotalSizeGbs int64 `json:"totalSizeGbs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableSizeGbs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableSizeGbs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExascaleDbStorageDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ExascaleDbStorageDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExascaleDbStorageVault: ExascaleDbStorageVault represents a storage vault
// exadb vm cluster resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExascaleDbStorageVault/
type ExascaleDbStorageVault struct {
	// CreateTime: Output only. The date and time when the ExascaleDbStorageVault
	// was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name for the ExascaleDbStorageVault. The
	// name does not have to be unique within your project. The name must be 1-255
	// characters long and can only contain alphanumeric characters.
	DisplayName string `json:"displayName,omitempty"`
	// EntitlementId: Output only. The ID of the subscription entitlement
	// associated with the ExascaleDbStorageVault.
	EntitlementId string `json:"entitlementId,omitempty"`
	// GcpOracleZone: Optional. The GCP Oracle zone where Oracle
	// ExascaleDbStorageVault is hosted. Example: us-east4-b-r2. If not specified,
	// the system will pick a zone based on availability.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Labels: Optional. The labels or tags associated with the
	// ExascaleDbStorageVault.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the ExascaleDbStorageVault. Format:
	// projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascale_db_
	// storage_vault}
	Name string `json:"name,omitempty"`
	// Properties: Required. The properties of the ExascaleDbStorageVault.
	Properties *ExascaleDbStorageVaultProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExascaleDbStorageVault) MarshalJSON() ([]byte, error) {
	type NoMethod ExascaleDbStorageVault
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExascaleDbStorageVaultProperties: The properties of the
// ExascaleDbStorageVault. next ID: 12
type ExascaleDbStorageVaultProperties struct {
	// AdditionalFlashCachePercent: Optional. The size of additional flash cache in
	// percentage of high capacity database storage.
	AdditionalFlashCachePercent int64 `json:"additionalFlashCachePercent,omitempty"`
	// AttachedShapeAttributes: Output only. The shape attributes of the VM
	// clusters attached to the ExascaleDbStorageVault.
	//
	// Possible values:
	//   "SHAPE_ATTRIBUTE_UNSPECIFIED" - Default unspecified value.
	//   "SMART_STORAGE" - Indicates that the resource is in smart storage.
	//   "BLOCK_STORAGE" - Indicates that the resource is in block storage.
	AttachedShapeAttributes []string `json:"attachedShapeAttributes,omitempty"`
	// AvailableShapeAttributes: Output only. The shape attributes available for
	// the VM clusters to be attached to the ExascaleDbStorageVault.
	//
	// Possible values:
	//   "SHAPE_ATTRIBUTE_UNSPECIFIED" - Default unspecified value.
	//   "SMART_STORAGE" - Indicates that the resource is in smart storage.
	//   "BLOCK_STORAGE" - Indicates that the resource is in block storage.
	AvailableShapeAttributes []string `json:"availableShapeAttributes,omitempty"`
	// Description: Optional. The description of the ExascaleDbStorageVault.
	Description string `json:"description,omitempty"`
	// ExascaleDbStorageDetails: Required. The storage details of the
	// ExascaleDbStorageVault.
	ExascaleDbStorageDetails *ExascaleDbStorageDetails `json:"exascaleDbStorageDetails,omitempty"`
	// OciUri: Output only. Deep link to the OCI console to view this resource.
	OciUri string `json:"ociUri,omitempty"`
	// Ocid: Output only. The OCID for the ExascaleDbStorageVault.
	Ocid string `json:"ocid,omitempty"`
	// State: Output only. The state of the ExascaleDbStorageVault.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state of the ExascaleDbStorageVault is
	// unspecified.
	//   "PROVISIONING" - The ExascaleDbStorageVault is being provisioned.
	//   "AVAILABLE" - The ExascaleDbStorageVault is available.
	//   "UPDATING" - The ExascaleDbStorageVault is being updated.
	//   "TERMINATING" - The ExascaleDbStorageVault is being deleted.
	//   "TERMINATED" - The ExascaleDbStorageVault has been deleted.
	//   "FAILED" - The ExascaleDbStorageVault has failed.
	State string `json:"state,omitempty"`
	// TimeZone: Output only. The time zone of the ExascaleDbStorageVault.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// VmClusterCount: Output only. The number of VM clusters associated with the
	// ExascaleDbStorageVault.
	VmClusterCount int64 `json:"vmClusterCount,omitempty"`
	// VmClusterIds: Output only. The list of VM cluster OCIDs associated with the
	// ExascaleDbStorageVault.
	VmClusterIds []string `json:"vmClusterIds,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdditionalFlashCachePercent") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalFlashCachePercent") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExascaleDbStorageVaultProperties) MarshalJSON() ([]byte, error) {
	type NoMethod ExascaleDbStorageVaultProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FailoverAutonomousDatabaseRequest: The request for
// `OracleDatabase.FailoverAutonomousDatabase`.
type FailoverAutonomousDatabaseRequest struct {
	// PeerAutonomousDatabase: Required. The peer database name to fail over to.
	PeerAutonomousDatabase string `json:"peerAutonomousDatabase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PeerAutonomousDatabase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PeerAutonomousDatabase") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FailoverAutonomousDatabaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod FailoverAutonomousDatabaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateAutonomousDatabaseWalletRequest: The request for
// `AutonomousDatabase.GenerateWallet`.
type GenerateAutonomousDatabaseWalletRequest struct {
	// IsRegional: Optional. True when requesting regional connection strings in
	// PDB connect info, applicable to cross-region Data Guard only.
	IsRegional bool `json:"isRegional,omitempty"`
	// Password: Required. The password used to encrypt the keys inside the wallet.
	// The password must be a minimum of 8 characters.
	Password string `json:"password,omitempty"`
	// Type: Optional. The type of wallet generation for the Autonomous Database.
	// The default value is SINGLE.
	//
	// Possible values:
	//   "GENERATE_TYPE_UNSPECIFIED" - Default unspecified value.
	//   "ALL" - Used to generate wallet for all databases in the region.
	//   "SINGLE" - Used to generate wallet for a single database.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsRegional") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsRegional") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateAutonomousDatabaseWalletRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateAutonomousDatabaseWalletRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateAutonomousDatabaseWalletResponse: The response for
// `AutonomousDatabase.GenerateWallet`.
type GenerateAutonomousDatabaseWalletResponse struct {
	// ArchiveContent: Output only. The base64 encoded wallet files.
	ArchiveContent string `json:"archiveContent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ArchiveContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateAutonomousDatabaseWalletResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateAutonomousDatabaseWalletResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GiVersion: Details of the Oracle Grid Infrastructure (GI) version resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/GiVersionSummary/
type GiVersion struct {
	// Name: Identifier. The name of the Oracle Grid Infrastructure (GI) version
	// resource with the format:
	// projects/{project}/locations/{region}/giVersions/{gi_versions}
	Name string `json:"name,omitempty"`
	// Version: Optional. version
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GiVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityConnector: The identity connector details which will allow OCI to
// securely access the resources in the customer project.
type IdentityConnector struct {
	// ConnectionState: Output only. The connection state of the identity
	// connector.
	//
	// Possible values:
	//   "CONNECTION_STATE_UNSPECIFIED" - Default unspecified value.
	//   "CONNECTED" - The identity pool connection is connected.
	//   "PARTIALLY_CONNECTED" - The identity pool connection is partially
	// connected.
	//   "DISCONNECTED" - The identity pool connection is disconnected.
	//   "UNKNOWN" - The identity pool connection is in an unknown state.
	ConnectionState string `json:"connectionState,omitempty"`
	// ServiceAgentEmail: Output only. A google managed service account on which
	// customers can grant roles to access resources in the customer project.
	// Example: `p176944527254-55-75119d87fd8f@gcp-sa-oci.iam.gserviceaccount.com`
	ServiceAgentEmail string `json:"serviceAgentEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityConnector) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityConnector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAutonomousDatabaseBackupsResponse: The response for
// `AutonomousDatabaseBackup.List`.
type ListAutonomousDatabaseBackupsResponse struct {
	// AutonomousDatabaseBackups: The list of Autonomous Database Backups.
	AutonomousDatabaseBackups []*AutonomousDatabaseBackup `json:"autonomousDatabaseBackups,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutonomousDatabaseBackups")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutonomousDatabaseBackups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAutonomousDatabaseBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAutonomousDatabaseBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAutonomousDatabaseCharacterSetsResponse: The response for
// `AutonomousDatabaseCharacterSet.List`.
type ListAutonomousDatabaseCharacterSetsResponse struct {
	// AutonomousDatabaseCharacterSets: The list of Autonomous Database Character
	// Sets.
	AutonomousDatabaseCharacterSets []*AutonomousDatabaseCharacterSet `json:"autonomousDatabaseCharacterSets,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AutonomousDatabaseCharacterSets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutonomousDatabaseCharacterSets")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAutonomousDatabaseCharacterSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAutonomousDatabaseCharacterSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAutonomousDatabasesResponse: The response for `AutonomousDatabase.List`.
type ListAutonomousDatabasesResponse struct {
	// AutonomousDatabases: The list of Autonomous Databases.
	AutonomousDatabases []*AutonomousDatabase `json:"autonomousDatabases,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutonomousDatabases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutonomousDatabases") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAutonomousDatabasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAutonomousDatabasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAutonomousDbVersionsResponse: The response for
// `AutonomousDbVersion.List`.
type ListAutonomousDbVersionsResponse struct {
	// AutonomousDbVersions: The list of Autonomous Database versions.
	AutonomousDbVersions []*AutonomousDbVersion `json:"autonomousDbVersions,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutonomousDbVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutonomousDbVersions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAutonomousDbVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAutonomousDbVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCloudExadataInfrastructuresResponse: The response for
// `CloudExadataInfrastructures.list`.
type ListCloudExadataInfrastructuresResponse struct {
	// CloudExadataInfrastructures: The list of Exadata Infrastructures.
	CloudExadataInfrastructures []*CloudExadataInfrastructure `json:"cloudExadataInfrastructures,omitempty"`
	// NextPageToken: A token for fetching next page of response.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "CloudExadataInfrastructures") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudExadataInfrastructures") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCloudExadataInfrastructuresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCloudExadataInfrastructuresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCloudVmClustersResponse: The response for `CloudVmCluster.List`.
type ListCloudVmClustersResponse struct {
	// CloudVmClusters: The list of VM Clusters.
	CloudVmClusters []*CloudVmCluster `json:"cloudVmClusters,omitempty"`
	// NextPageToken: A token to fetch the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudVmClusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudVmClusters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCloudVmClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCloudVmClustersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDatabaseCharacterSetsResponse: The response for
// `DatabaseCharacterSet.List`.
type ListDatabaseCharacterSetsResponse struct {
	// DatabaseCharacterSets: The list of DatabaseCharacterSets.
	DatabaseCharacterSets []*DatabaseCharacterSet `json:"databaseCharacterSets,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DatabaseCharacterSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseCharacterSets") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDatabaseCharacterSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDatabaseCharacterSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDatabasesResponse: The response for `Database.List`.
type ListDatabasesResponse struct {
	// Databases: The list of Databases.
	Databases []*Database `json:"databases,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Databases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Databases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDatabasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDatabasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbNodesResponse: The response for `DbNode.List`.
type ListDbNodesResponse struct {
	// DbNodes: The list of DB Nodes
	DbNodes []*DbNode `json:"dbNodes,omitempty"`
	// NextPageToken: A token identifying a page of results the node should return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DbNodes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbNodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbNodesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbNodesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbServersResponse: The response for `DbServer.List`.
type ListDbServersResponse struct {
	// DbServers: The list of database servers.
	DbServers []*DbServer `json:"dbServers,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DbServers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbServers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbServersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbServersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbSystemInitialStorageSizesResponse: The response for
// `DbSystemInitialStorageSizes.List`.
type ListDbSystemInitialStorageSizesResponse struct {
	// DbSystemInitialStorageSizes: The list of DbSystemInitialStorageSizes.
	DbSystemInitialStorageSizes []*DbSystemInitialStorageSize `json:"dbSystemInitialStorageSizes,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "DbSystemInitialStorageSizes") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbSystemInitialStorageSizes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbSystemInitialStorageSizesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbSystemInitialStorageSizesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbSystemShapesResponse: The response for `DbSystemShape.List`.
type ListDbSystemShapesResponse struct {
	// DbSystemShapes: The list of Database System shapes.
	DbSystemShapes []*DbSystemShape `json:"dbSystemShapes,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DbSystemShapes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbSystemShapes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbSystemShapesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbSystemShapesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbSystemsResponse: The response for `DbSystem.List`.
type ListDbSystemsResponse struct {
	// DbSystems: The list of DbSystems.
	DbSystems []*DbSystem `json:"dbSystems,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DbSystems") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbSystems") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbSystemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbSystemsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDbVersionsResponse: The response for `DbVersions.List`.
type ListDbVersionsResponse struct {
	// DbVersions: The list of DbVersions.
	DbVersions []*DbVersion `json:"dbVersions,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DbVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbVersions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDbVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDbVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEntitlementsResponse: The response for `Entitlement.List`.
type ListEntitlementsResponse struct {
	// Entitlements: The list of Entitlements
	Entitlements []*Entitlement `json:"entitlements,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entitlements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entitlements") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEntitlementsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntitlementsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExadbVmClustersResponse: The response for `ExadbVmCluster.List`.
type ListExadbVmClustersResponse struct {
	// ExadbVmClusters: The list of ExadbVmClusters.
	ExadbVmClusters []*ExadbVmCluster `json:"exadbVmClusters,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExadbVmClusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExadbVmClusters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExadbVmClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExadbVmClustersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExascaleDbStorageVaultsResponse: The response for
// `ExascaleDbStorageVault.List`.
type ListExascaleDbStorageVaultsResponse struct {
	// ExascaleDbStorageVaults: The ExascaleDbStorageVaults.
	ExascaleDbStorageVaults []*ExascaleDbStorageVault `json:"exascaleDbStorageVaults,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return. If present, the next page token can be provided to a subsequent
	// ListExascaleDbStorageVaults call to list the next page. If empty, there are
	// no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExascaleDbStorageVaults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExascaleDbStorageVaults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExascaleDbStorageVaultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExascaleDbStorageVaultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGiVersionsResponse: The response for `GiVersion.List`.
type ListGiVersionsResponse struct {
	// GiVersions: The list of Oracle Grid Infrastructure (GI) versions.
	GiVersions []*GiVersion `json:"giVersions,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GiVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GiVersions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGiVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGiVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMinorVersionsResponse: The response for `MinorVersion.List`.
type ListMinorVersionsResponse struct {
	// MinorVersions: The list of MinorVersions.
	MinorVersions []*MinorVersion `json:"minorVersions,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MinorVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MinorVersions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMinorVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMinorVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOdbNetworksResponse: The response for `OdbNetwork.List`.
type ListOdbNetworksResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OdbNetworks: The list of ODB Networks.
	OdbNetworks []*OdbNetwork `json:"odbNetworks,omitempty"`
	// Unreachable: Unreachable locations when listing resources across all
	// locations using wildcard location '-'.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOdbNetworksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOdbNetworksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOdbSubnetsResponse: The response for `OdbSubnet.List`.
type ListOdbSubnetsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OdbSubnets: The list of ODB Subnets.
	OdbSubnets []*OdbSubnet `json:"odbSubnets,omitempty"`
	// Unreachable: Unreachable locations when listing resources across all
	// locations using wildcard location '-'.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOdbSubnetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOdbSubnetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections e.g. when attempting to list all resources across all supported
	// locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPluggableDatabasesResponse: The response for `PluggableDatabase.List`.
type ListPluggableDatabasesResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PluggableDatabases: The list of PluggableDatabases.
	PluggableDatabases []*PluggableDatabase `json:"pluggableDatabases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPluggableDatabasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPluggableDatabasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocationMetadata: Metadata for a given Location.
type LocationMetadata struct {
	// GcpOracleZones: Output only. Google Cloud Platform Oracle zones in a
	// location.
	GcpOracleZones []string `json:"gcpOracleZones,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcpOracleZones") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcpOracleZones") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceWindow: Maintenance window as defined by Oracle.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/MaintenanceWindow
type MaintenanceWindow struct {
	// CustomActionTimeoutMins: Optional. Determines the amount of time the system
	// will wait before the start of each database server patching operation.
	// Custom action timeout is in minutes and valid value is between 15 to 120
	// (inclusive).
	CustomActionTimeoutMins int64 `json:"customActionTimeoutMins,omitempty"`
	// DaysOfWeek: Optional. Days during the week when maintenance should be
	// performed.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DaysOfWeek []string `json:"daysOfWeek,omitempty"`
	// HoursOfDay: Optional. The window of hours during the day when maintenance
	// should be performed. The window is a 4 hour slot. Valid values are: 0 -
	// represents time slot 0:00 - 3:59 UTC 4 - represents time slot 4:00 - 7:59
	// UTC 8 - represents time slot 8:00 - 11:59 UTC 12 - represents time slot
	// 12:00 - 15:59 UTC 16 - represents time slot 16:00 - 19:59 UTC 20 -
	// represents time slot 20:00 - 23:59 UTC
	HoursOfDay []int64 `json:"hoursOfDay,omitempty"`
	// IsCustomActionTimeoutEnabled: Optional. If true, enables the configuration
	// of a custom action timeout (waiting period) between database server patching
	// operations.
	IsCustomActionTimeoutEnabled bool `json:"isCustomActionTimeoutEnabled,omitempty"`
	// LeadTimeWeek: Optional. Lead time window allows user to set a lead time to
	// prepare for a down time. The lead time is in weeks and valid value is
	// between 1 to 4.
	LeadTimeWeek int64 `json:"leadTimeWeek,omitempty"`
	// Months: Optional. Months during the year when maintenance should be
	// performed.
	//
	// Possible values:
	//   "MONTH_UNSPECIFIED" - The unspecified month.
	//   "JANUARY" - The month of January.
	//   "FEBRUARY" - The month of February.
	//   "MARCH" - The month of March.
	//   "APRIL" - The month of April.
	//   "MAY" - The month of May.
	//   "JUNE" - The month of June.
	//   "JULY" - The month of July.
	//   "AUGUST" - The month of August.
	//   "SEPTEMBER" - The month of September.
	//   "OCTOBER" - The month of October.
	//   "NOVEMBER" - The month of November.
	//   "DECEMBER" - The month of December.
	Months []string `json:"months,omitempty"`
	// PatchingMode: Optional. Cloud CloudExadataInfrastructure node patching
	// method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
	//
	// Possible values:
	//   "PATCHING_MODE_UNSPECIFIED" - Default unspecified value.
	//   "ROLLING" - Updates the Cloud Exadata database server hosts in a rolling
	// fashion.
	//   "NON_ROLLING" - The non-rolling maintenance method first updates your
	// storage servers at the same time, then your database servers at the same
	// time.
	PatchingMode string `json:"patchingMode,omitempty"`
	// Preference: Optional. The maintenance window scheduling preference.
	//
	// Possible values:
	//   "MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED" - Default unspecified value.
	//   "CUSTOM_PREFERENCE" - Custom preference.
	//   "NO_PREFERENCE" - No preference.
	Preference string `json:"preference,omitempty"`
	// WeeksOfMonth: Optional. Weeks during the month when maintenance should be
	// performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the month,
	// and have a duration of 7 days. Weeks start and end based on calendar dates,
	// not days of the week.
	WeeksOfMonth []int64 `json:"weeksOfMonth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomActionTimeoutMins") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomActionTimeoutMins") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MinorVersion: MinorVersion represents a minor version of a GI.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/GiMinorVersionSummary/
type MinorVersion struct {
	// GridImageId: Optional. The ID of the Grid Image.
	GridImageId string `json:"gridImageId,omitempty"`
	// Name: Identifier. The name of the MinorVersion resource with the format:
	// projects/{project}/locations/{region}/giVersions/{gi_version}/minorVersions/{
	// minor_version}
	Name string `json:"name,omitempty"`
	// Version: Optional. The valid Oracle grid infrastructure software version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GridImageId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GridImageId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MinorVersion) MarshalJSON() ([]byte, error) {
	type NoMethod MinorVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OdbNetwork: Represents OdbNetwork resource.
type OdbNetwork struct {
	// CreateTime: Output only. The date and time that the OdbNetwork was created.
	CreateTime string `json:"createTime,omitempty"`
	// EntitlementId: Output only. The ID of the subscription entitlement
	// associated with the OdbNetwork.
	EntitlementId string `json:"entitlementId,omitempty"`
	// GcpOracleZone: Optional. The GCP Oracle zone where OdbNetwork is hosted.
	// Example: us-east4-b-r2. If not specified, the system will pick a zone based
	// on availability.
	GcpOracleZone string `json:"gcpOracleZone,omitempty"`
	// Labels: Optional. Labels or tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the OdbNetwork resource in the following
	// format: projects/{project}/locations/{region}/odbNetworks/{odb_network}
	Name string `json:"name,omitempty"`
	// Network: Required. The name of the VPC network in the following format:
	// projects/{project}/global/networks/{network}
	Network string `json:"network,omitempty"`
	// State: Output only. State of the ODB Network.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "FAILED" - Indicates that the resource is in failed state.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OdbNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod OdbNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OdbSubnet: Represents OdbSubnet resource.
type OdbSubnet struct {
	// CidrRange: Required. The CIDR range of the subnet.
	CidrRange string `json:"cidrRange,omitempty"`
	// CreateTime: Output only. The date and time that the OdbNetwork was created.
	CreateTime string `json:"createTime,omitempty"`
	// Labels: Optional. Labels or tags associated with the resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The name of the OdbSubnet resource in the following
	// format:
	// projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/
	// {odb_subnet}
	Name string `json:"name,omitempty"`
	// Purpose: Required. Purpose of the subnet.
	//
	// Possible values:
	//   "PURPOSE_UNSPECIFIED" - Default unspecified value.
	//   "CLIENT_SUBNET" - Subnet to be used for client connections.
	//   "BACKUP_SUBNET" - Subnet to be used for backup.
	Purpose string `json:"purpose,omitempty"`
	// State: Output only. State of the ODB Subnet.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified value.
	//   "PROVISIONING" - Indicates that the resource is in provisioning state.
	//   "AVAILABLE" - Indicates that the resource is in available state.
	//   "TERMINATING" - Indicates that the resource is in terminating state.
	//   "FAILED" - Indicates that the resource is in failed state.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CidrRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CidrRange") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OdbSubnet) MarshalJSON() ([]byte, error) {
	type NoMethod OdbSubnet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PercentComplete: Output only. An estimated percentage of the operation that
	// has been completed at a given moment of time, between 0 and 100.
	PercentComplete float64 `json:"percentComplete,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. The status of the operation.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *OperationMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod OperationMetadata
	var s1 struct {
		PercentComplete gensupport.JSONFloat64 `json:"percentComplete"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PercentComplete = float64(s1.PercentComplete)
	return nil
}

// PluggableDatabase: The PluggableDatabase resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/PluggableDatabase/
type PluggableDatabase struct {
	// CreateTime: Output only. The date and time that the PluggableDatabase was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the PluggableDatabase resource in the
	// following format:
	// projects/{project}/locations/{region}/pluggableDatabases/{pluggable_database}
	Name string `json:"name,omitempty"`
	// OciUrl: Output only. HTTPS link to OCI resources exposed to Customer via UI
	// Interface.
	OciUrl string `json:"ociUrl,omitempty"`
	// Properties: Optional. The properties of the PluggableDatabase.
	Properties *PluggableDatabaseProperties `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PluggableDatabase) MarshalJSON() ([]byte, error) {
	type NoMethod PluggableDatabase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PluggableDatabaseConnectionStrings: The connection strings used to connect
// to the Oracle Database.
type PluggableDatabaseConnectionStrings struct {
	// AllConnectionStrings: Optional. All connection strings to use to connect to
	// the pluggable database.
	AllConnectionStrings map[string]string `json:"allConnectionStrings,omitempty"`
	// PdbDefault: Optional. The default connection string to use to connect to the
	// pluggable database.
	PdbDefault string `json:"pdbDefault,omitempty"`
	// PdbIpDefault: Optional. The default connection string to use to connect to
	// the pluggable database using IP.
	PdbIpDefault string `json:"pdbIpDefault,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllConnectionStrings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllConnectionStrings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PluggableDatabaseConnectionStrings) MarshalJSON() ([]byte, error) {
	type NoMethod PluggableDatabaseConnectionStrings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PluggableDatabaseNodeLevelDetails: The Pluggable Database Node Level
// Details.
type PluggableDatabaseNodeLevelDetails struct {
	// NodeName: Required. The Node name of the Database home.
	NodeName string `json:"nodeName,omitempty"`
	// OpenMode: Required. The mode that the pluggable database is in to open it.
	//
	// Possible values:
	//   "PLUGGABLE_DATABASE_OPEN_MODE_UNSPECIFIED" - The open mode is unspecified.
	//   "READ_ONLY" - The pluggable database is opened in read-only mode.
	//   "READ_WRITE" - The pluggable database is opened in read-write mode.
	//   "MOUNTED" - The pluggable database is mounted.
	//   "MIGRATE" - The pluggable database is migrated.
	OpenMode string `json:"openMode,omitempty"`
	// PluggableDatabaseId: Required. The OCID of the Pluggable Database.
	PluggableDatabaseId string `json:"pluggableDatabaseId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PluggableDatabaseNodeLevelDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PluggableDatabaseNodeLevelDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PluggableDatabaseProperties: The properties of a PluggableDatabase.
type PluggableDatabaseProperties struct {
	// CompartmentId: Required. The OCID of the compartment.
	CompartmentId string `json:"compartmentId,omitempty"`
	// ConnectionStrings: Optional. The Connection strings used to connect to the
	// Oracle Database.
	ConnectionStrings *PluggableDatabaseConnectionStrings `json:"connectionStrings,omitempty"`
	// ContainerDatabaseOcid: Required. The OCID of the CDB.
	ContainerDatabaseOcid string `json:"containerDatabaseOcid,omitempty"`
	// DatabaseManagementConfig: Output only. The configuration of the Database
	// Management service.
	DatabaseManagementConfig *DatabaseManagementConfig `json:"databaseManagementConfig,omitempty"`
	// DefinedTags: Optional. Defined tags for this resource. Each key is
	// predefined and scoped to a namespace.
	DefinedTags map[string]DefinedTagValue `json:"definedTags,omitempty"`
	// FreeformTags: Optional. Free-form tags for this resource. Each tag is a
	// simple key-value pair with no predefined name, type, or namespace.
	FreeformTags map[string]string `json:"freeformTags,omitempty"`
	// IsRestricted: Optional. The restricted mode of the pluggable database. If a
	// pluggable database is opened in restricted mode, the user needs both create
	// a session and have restricted session privileges to connect to it.
	IsRestricted bool `json:"isRestricted,omitempty"`
	// LifecycleDetails: Output only. Additional information about the current
	// lifecycle state.
	LifecycleDetails string `json:"lifecycleDetails,omitempty"`
	// LifecycleState: Output only. The current state of the pluggable database.
	//
	// Possible values:
	//   "PLUGGABLE_DATABASE_LIFECYCLE_STATE_UNSPECIFIED" - The lifecycle state is
	// unspecified.
	//   "PROVISIONING" - The pluggable database is provisioning.
	//   "AVAILABLE" - The pluggable database is available.
	//   "TERMINATING" - The pluggable database is terminating.
	//   "TERMINATED" - The pluggable database is terminated.
	//   "UPDATING" - The pluggable database is updating.
	//   "FAILED" - The pluggable database is in a failed state.
	//   "RELOCATING" - The pluggable database is relocating.
	//   "RELOCATED" - The pluggable database is relocated.
	//   "REFRESHING" - The pluggable database is refreshing.
	//   "RESTORE_IN_PROGRESS" - The pluggable database is restoring.
	//   "RESTORE_FAILED" - The pluggable database restore failed.
	//   "BACKUP_IN_PROGRESS" - The pluggable database is backing up.
	//   "DISABLED" - The pluggable database is disabled.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// Ocid: Output only. The OCID of the pluggable database.
	Ocid string `json:"ocid,omitempty"`
	// OperationsInsightsState: Output only. The status of Operations Insights for
	// this Database.
	//
	// Possible values:
	//   "OPERATIONS_INSIGHTS_STATE_UNSPECIFIED" - The status is not specified.
	//   "ENABLING" - Operations Insights is enabling.
	//   "ENABLED" - Operations Insights is enabled.
	//   "DISABLING" - Operations Insights is disabling.
	//   "NOT_ENABLED" - Operations Insights is not enabled.
	//   "FAILED_ENABLING" - Operations Insights failed to enable.
	//   "FAILED_DISABLING" - Operations Insights failed to disable.
	OperationsInsightsState string `json:"operationsInsightsState,omitempty"`
	// PdbName: Required. The database name.
	PdbName string `json:"pdbName,omitempty"`
	// PdbNodeLevelDetails: Optional. Pluggable Database Node Level Details
	PdbNodeLevelDetails []*PluggableDatabaseNodeLevelDetails `json:"pdbNodeLevelDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompartmentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompartmentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PluggableDatabaseProperties) MarshalJSON() ([]byte, error) {
	type NoMethod PluggableDatabaseProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveVirtualMachineExadbVmClusterRequest: The request for
// `ExadbVmCluster.RemoveVirtualMachine`.
type RemoveVirtualMachineExadbVmClusterRequest struct {
	// Hostnames: Required. The list of host names of db nodes to be removed from
	// the ExadbVmCluster.
	Hostnames []string `json:"hostnames,omitempty"`
	// RequestId: Optional. An optional ID to identify the request. This value is
	// used to identify duplicate requests. If you make a request with the same
	// request ID and the original request is still in progress or completed, the
	// server ignores the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hostnames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hostnames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveVirtualMachineExadbVmClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveVirtualMachineExadbVmClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestartAutonomousDatabaseRequest: The request for
// `AutonomousDatabase.Restart`.
type RestartAutonomousDatabaseRequest struct {
}

// RestoreAutonomousDatabaseRequest: The request for
// `AutonomousDatabase.Restore`.
type RestoreAutonomousDatabaseRequest struct {
	// RestoreTime: Required. The time and date to restore the database to.
	RestoreTime string `json:"restoreTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RestoreTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RestoreTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestoreAutonomousDatabaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreAutonomousDatabaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScheduledOperationDetails: Details of scheduled operation.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/ScheduledOperationDetails
type ScheduledOperationDetails struct {
	// DayOfWeek: Output only. Day of week.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeek string `json:"dayOfWeek,omitempty"`
	// StartTime: Output only. Auto start time.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// StopTime: Output only. Auto stop time.
	StopTime *TimeOfDay `json:"stopTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayOfWeek") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayOfWeek") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScheduledOperationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ScheduledOperationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SourceConfig: The source configuration for the standby Autonomous Database.
type SourceConfig struct {
	// AutomaticBackupsReplicationEnabled: Optional. This field specifies if the
	// replication of automatic backups is enabled when creating a Data Guard.
	AutomaticBackupsReplicationEnabled bool `json:"automaticBackupsReplicationEnabled,omitempty"`
	// AutonomousDatabase: Optional. The name of the primary Autonomous Database
	// that is used to create a Peer Autonomous Database from a source.
	AutonomousDatabase string `json:"autonomousDatabase,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AutomaticBackupsReplicationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AutomaticBackupsReplicationEnabled") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s SourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartAutonomousDatabaseRequest: The request for `AutonomousDatabase.Start`.
type StartAutonomousDatabaseRequest struct {
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopAutonomousDatabaseRequest: The request for `AutonomousDatabase.Stop`.
type StopAutonomousDatabaseRequest struct {
}

// StorageSizeDetails: The initial storage size, in gigabytes, that is
// applicable for virtual machine DBSystem.
type StorageSizeDetails struct {
	// DataStorageSizeInGbs: Output only. The data storage size, in gigabytes, that
	// is applicable for virtual machine DBSystem.
	DataStorageSizeInGbs int64 `json:"dataStorageSizeInGbs,omitempty"`
	// RecoStorageSizeInGbs: Output only. The RECO/REDO storage size, in gigabytes,
	// that is applicable for virtual machine DBSystem.
	RecoStorageSizeInGbs int64 `json:"recoStorageSizeInGbs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStorageSizeInGbs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStorageSizeInGbs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageSizeDetails) MarshalJSON() ([]byte, error) {
	type NoMethod StorageSizeDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SwitchoverAutonomousDatabaseRequest: The request for
// `OracleDatabase.SwitchoverAutonomousDatabase`.
type SwitchoverAutonomousDatabaseRequest struct {
	// PeerAutonomousDatabase: Required. The peer database name to switch over to.
	PeerAutonomousDatabase string `json:"peerAutonomousDatabase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PeerAutonomousDatabase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PeerAutonomousDatabase") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SwitchoverAutonomousDatabaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SwitchoverAutonomousDatabaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Unless
// explicitly documented otherwise, don't use this unsupported field which is
// primarily intended for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAutonomousDatabaseBackupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the long-term and automatic backups of an Autonomous Database.
//
//   - parent: The parent value for ListAutonomousDatabaseBackups in the
//     following format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsAutonomousDatabaseBackupsService) List(parent string) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c := &ProjectsLocationsAutonomousDatabaseBackupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only the **autonomous_database_id** field is
// supported in the following format:
// `autonomous_database_id="{autonomous_database_id}". The accepted values
// must be a valid Autonomous Database ID, limited to the naming restrictions
// of the ID: ^a-z ([a-z0-9-]{0,61}[a-z0-9])?$). The ID must start with a
// letter, end with a letter or a number, and be a maximum of 63 characters.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Filter(filter string) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 Autonomous DB Backups will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) PageSize(pageSize int64) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) PageToken(pageToken string) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabaseBackupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autonomousDatabaseBackups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabaseBackups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabaseBackups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutonomousDatabaseBackupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Do(opts ...googleapi.CallOption) (*ListAutonomousDatabaseBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutonomousDatabaseBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabaseBackups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAutonomousDatabaseBackupsListCall) Pages(ctx context.Context, f func(*ListAutonomousDatabaseBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAutonomousDatabaseCharacterSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Autonomous Database Character Sets in a given project and
// location.
//
//   - parent: The parent value for the Autonomous Database in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsAutonomousDatabaseCharacterSetsService) List(parent string) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c := &ProjectsLocationsAutonomousDatabaseCharacterSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only the **character_set_type** field is supported
// in the following format: `character_set_type="{characterSetType}". Accepted
// values include `DATABASE` and `NATIONAL`.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Filter(filter string) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 Autonomous DB Character Sets will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) PageSize(pageSize int64) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) PageToken(pageToken string) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autonomousDatabaseCharacterSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabaseCharacterSets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabaseCharacterSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutonomousDatabaseCharacterSetsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Do(opts ...googleapi.CallOption) (*ListAutonomousDatabaseCharacterSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutonomousDatabaseCharacterSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabaseCharacterSets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAutonomousDatabaseCharacterSetsListCall) Pages(ctx context.Context, f func(*ListAutonomousDatabaseCharacterSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAutonomousDatabasesCreateCall struct {
	s                  *Service
	parent             string
	autonomousdatabase *AutonomousDatabase
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a new Autonomous Database in a given project and location.
//
//   - parent: The name of the parent in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsAutonomousDatabasesService) Create(parent string, autonomousdatabase *AutonomousDatabase) *ProjectsLocationsAutonomousDatabasesCreateCall {
	c := &ProjectsLocationsAutonomousDatabasesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.autonomousdatabase = autonomousdatabase
	return c
}

// AutonomousDatabaseId sets the optional parameter "autonomousDatabaseId":
// Required. The ID of the Autonomous Database to create. This value is
// restricted to (^a-z ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63
// characters in length. The value must start with a letter and end with a
// letter or a number.
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) AutonomousDatabaseId(autonomousDatabaseId string) *ProjectsLocationsAutonomousDatabasesCreateCall {
	c.urlParams_.Set("autonomousDatabaseId", autonomousDatabaseId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) RequestId(requestId string) *ProjectsLocationsAutonomousDatabasesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autonomousdatabase)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autonomousDatabases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Autonomous Database.
//
//   - name: The name of the resource in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Delete(name string) *ProjectsLocationsAutonomousDatabasesDeleteCall {
	c := &ProjectsLocationsAutonomousDatabasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) RequestId(requestId string) *ProjectsLocationsAutonomousDatabasesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesFailoverCall struct {
	s                                 *Service
	name                              string
	failoverautonomousdatabaserequest *FailoverAutonomousDatabaseRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Failover: Initiates a failover to target autonomous database from the
// associated primary database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Failover(name string, failoverautonomousdatabaserequest *FailoverAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesFailoverCall {
	c := &ProjectsLocationsAutonomousDatabasesFailoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.failoverautonomousdatabaserequest = failoverautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesFailoverCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesFailoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesFailoverCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesFailoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesFailoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesFailoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.failoverautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:failover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.failover", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.failover" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesFailoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.failover", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesGenerateWalletCall struct {
	s                                       *Service
	name                                    string
	generateautonomousdatabasewalletrequest *GenerateAutonomousDatabaseWalletRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// GenerateWallet: Generates a wallet for an Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) GenerateWallet(name string, generateautonomousdatabasewalletrequest *GenerateAutonomousDatabaseWalletRequest) *ProjectsLocationsAutonomousDatabasesGenerateWalletCall {
	c := &ProjectsLocationsAutonomousDatabasesGenerateWalletCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.generateautonomousdatabasewalletrequest = generateautonomousdatabasewalletrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesGenerateWalletCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesGenerateWalletCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesGenerateWalletCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesGenerateWalletCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesGenerateWalletCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesGenerateWalletCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generateautonomousdatabasewalletrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:generateWallet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.generateWallet", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.generateWallet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateAutonomousDatabaseWalletResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesGenerateWalletCall) Do(opts ...googleapi.CallOption) (*GenerateAutonomousDatabaseWalletResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateAutonomousDatabaseWalletResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.generateWallet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a single Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Get(name string) *ProjectsLocationsAutonomousDatabasesGetCall {
	c := &ProjectsLocationsAutonomousDatabasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutonomousDatabasesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutonomousDatabasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesGetCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutonomousDatabase.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAutonomousDatabasesGetCall) Do(opts ...googleapi.CallOption) (*AutonomousDatabase, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutonomousDatabase{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Autonomous Databases in a given project and location.
//
//   - parent: The parent value for the Autonomous Database in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsAutonomousDatabasesService) List(parent string) *ProjectsLocationsAutonomousDatabasesListCall {
	c := &ProjectsLocationsAutonomousDatabasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Filter(filter string) *ProjectsLocationsAutonomousDatabasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsAutonomousDatabasesListCall) OrderBy(orderBy string) *ProjectsLocationsAutonomousDatabasesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 Autonomous Database will be returned.
// The maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsAutonomousDatabasesListCall) PageSize(pageSize int64) *ProjectsLocationsAutonomousDatabasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsAutonomousDatabasesListCall) PageToken(pageToken string) *ProjectsLocationsAutonomousDatabasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutonomousDatabasesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutonomousDatabasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autonomousDatabases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutonomousDatabasesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Do(opts ...googleapi.CallOption) (*ListAutonomousDatabasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutonomousDatabasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAutonomousDatabasesListCall) Pages(ctx context.Context, f func(*ListAutonomousDatabasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAutonomousDatabasesPatchCall struct {
	s                  *Service
	name               string
	autonomousdatabase *AutonomousDatabase
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates the parameters of a single Autonomous Database.
//
//   - name: Identifier. The name of the Autonomous Database resource in the
//     following format:
//     projects/{project}/locations/{region}/autonomousDatabases/{autonomous_datab
//     ase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Patch(name string, autonomousdatabase *AutonomousDatabase) *ProjectsLocationsAutonomousDatabasesPatchCall {
	c := &ProjectsLocationsAutonomousDatabasesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.autonomousdatabase = autonomousdatabase
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) RequestId(requestId string) *ProjectsLocationsAutonomousDatabasesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Exadata resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAutonomousDatabasesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autonomousdatabase)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesRestartCall struct {
	s                                *Service
	name                             string
	restartautonomousdatabaserequest *RestartAutonomousDatabaseRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Restart: Restarts an Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Restart(name string, restartautonomousdatabaserequest *RestartAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesRestartCall {
	c := &ProjectsLocationsAutonomousDatabasesRestartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.restartautonomousdatabaserequest = restartautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesRestartCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesRestartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesRestartCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesRestartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesRestartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesRestartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.restartautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:restart")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.restart", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.restart" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesRestartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.restart", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesRestoreCall struct {
	s                                *Service
	name                             string
	restoreautonomousdatabaserequest *RestoreAutonomousDatabaseRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Restore: Restores a single Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Restore(name string, restoreautonomousdatabaserequest *RestoreAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesRestoreCall {
	c := &ProjectsLocationsAutonomousDatabasesRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.restoreautonomousdatabaserequest = restoreautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesRestoreCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesRestoreCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.restoreautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.restore", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.restore" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesRestoreCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.restore", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesStartCall struct {
	s                              *Service
	name                           string
	startautonomousdatabaserequest *StartAutonomousDatabaseRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Start: Starts an Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Start(name string, startautonomousdatabaserequest *StartAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesStartCall {
	c := &ProjectsLocationsAutonomousDatabasesStartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.startautonomousdatabaserequest = startautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesStartCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesStartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesStartCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesStartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesStartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesStartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:start")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.start", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.start" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesStartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.start", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesStopCall struct {
	s                             *Service
	name                          string
	stopautonomousdatabaserequest *StopAutonomousDatabaseRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Stop: Stops an Autonomous Database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Stop(name string, stopautonomousdatabaserequest *StopAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesStopCall {
	c := &ProjectsLocationsAutonomousDatabasesStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.stopautonomousdatabaserequest = stopautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesStopCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesStopCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.stopautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.stop", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDatabasesSwitchoverCall struct {
	s                                   *Service
	name                                string
	switchoverautonomousdatabaserequest *SwitchoverAutonomousDatabaseRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Switchover: Initiates a switchover of specified autonomous database to the
// associated peer database.
//
//   - name: The name of the Autonomous Database in the following format:
//     projects/{project}/locations/{location}/autonomousDatabases/{autonomous_dat
//     abase}.
func (r *ProjectsLocationsAutonomousDatabasesService) Switchover(name string, switchoverautonomousdatabaserequest *SwitchoverAutonomousDatabaseRequest) *ProjectsLocationsAutonomousDatabasesSwitchoverCall {
	c := &ProjectsLocationsAutonomousDatabasesSwitchoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.switchoverautonomousdatabaserequest = switchoverautonomousdatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDatabasesSwitchoverCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDatabasesSwitchoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDatabasesSwitchoverCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDatabasesSwitchoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDatabasesSwitchoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDatabasesSwitchoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.switchoverautonomousdatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:switchover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.switchover", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDatabases.switchover" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDatabasesSwitchoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDatabases.switchover", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutonomousDbVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the available Autonomous Database versions for a project and
// location.
//
//   - parent: The parent value for the Autonomous Database in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsAutonomousDbVersionsService) List(parent string) *ProjectsLocationsAutonomousDbVersionsListCall {
	c := &ProjectsLocationsAutonomousDbVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 Autonomous DB Versions will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsAutonomousDbVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) PageToken(pageToken string) *ProjectsLocationsAutonomousDbVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutonomousDbVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutonomousDbVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) Context(ctx context.Context) *ProjectsLocationsAutonomousDbVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutonomousDbVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autonomousDbVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDbVersions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.autonomousDbVersions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutonomousDbVersionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) Do(opts ...googleapi.CallOption) (*ListAutonomousDbVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutonomousDbVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.autonomousDbVersions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAutonomousDbVersionsListCall) Pages(ctx context.Context, f func(*ListAutonomousDbVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCloudExadataInfrastructuresCreateCall struct {
	s                          *Service
	parent                     string
	cloudexadatainfrastructure *CloudExadataInfrastructure
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Create: Creates a new Exadata Infrastructure in a given project and
// location.
//
//   - parent: The parent value for CloudExadataInfrastructure in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsCloudExadataInfrastructuresService) Create(parent string, cloudexadatainfrastructure *CloudExadataInfrastructure) *ProjectsLocationsCloudExadataInfrastructuresCreateCall {
	c := &ProjectsLocationsCloudExadataInfrastructuresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.cloudexadatainfrastructure = cloudexadatainfrastructure
	return c
}

// CloudExadataInfrastructureId sets the optional parameter
// "cloudExadataInfrastructureId": Required. The ID of the Exadata
// Infrastructure to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) CloudExadataInfrastructureId(cloudExadataInfrastructureId string) *ProjectsLocationsCloudExadataInfrastructuresCreateCall {
	c.urlParams_.Set("cloudExadataInfrastructureId", cloudExadataInfrastructureId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) RequestId(requestId string) *ProjectsLocationsCloudExadataInfrastructuresCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudExadataInfrastructuresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) Context(ctx context.Context) *ProjectsLocationsCloudExadataInfrastructuresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cloudexadatainfrastructure)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/cloudExadataInfrastructures")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudExadataInfrastructures.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudExadataInfrastructuresCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudExadataInfrastructuresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Exadata Infrastructure.
//
//   - name: The name of the Cloud Exadata Infrastructure in the following
//     format:
//     projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_
//     exadata_infrastructure}.
func (r *ProjectsLocationsCloudExadataInfrastructuresService) Delete(name string) *ProjectsLocationsCloudExadataInfrastructuresDeleteCall {
	c := &ProjectsLocationsCloudExadataInfrastructuresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all VM clusters
// for this Exadata Infrastructure will be deleted. An Exadata Infrastructure
// can only be deleted once all its VM clusters have been deleted.
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) Force(force bool) *ProjectsLocationsCloudExadataInfrastructuresDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) RequestId(requestId string) *ProjectsLocationsCloudExadataInfrastructuresDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudExadataInfrastructuresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) Context(ctx context.Context) *ProjectsLocationsCloudExadataInfrastructuresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudExadataInfrastructures.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudExadataInfrastructuresDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudExadataInfrastructuresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Exadata Infrastructure.
//
//   - name: The name of the Cloud Exadata Infrastructure in the following
//     format:
//     projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_
//     exadata_infrastructure}.
func (r *ProjectsLocationsCloudExadataInfrastructuresService) Get(name string) *ProjectsLocationsCloudExadataInfrastructuresGetCall {
	c := &ProjectsLocationsCloudExadataInfrastructuresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudExadataInfrastructuresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudExadataInfrastructuresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) Context(ctx context.Context) *ProjectsLocationsCloudExadataInfrastructuresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudExadataInfrastructures.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CloudExadataInfrastructure.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudExadataInfrastructuresGetCall) Do(opts ...googleapi.CallOption) (*CloudExadataInfrastructure, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CloudExadataInfrastructure{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudExadataInfrastructuresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Exadata Infrastructures in a given project and location.
//
//   - parent: The parent value for CloudExadataInfrastructure in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsCloudExadataInfrastructuresService) List(parent string) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c := &ProjectsLocationsCloudExadataInfrastructuresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Filter(filter string) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) OrderBy(orderBy string) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 Exadata infrastructures will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) PageSize(pageSize int64) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) PageToken(pageToken string) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Context(ctx context.Context) *ProjectsLocationsCloudExadataInfrastructuresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/cloudExadataInfrastructures")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudExadataInfrastructures.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCloudExadataInfrastructuresResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Do(opts ...googleapi.CallOption) (*ListCloudExadataInfrastructuresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCloudExadataInfrastructuresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCloudExadataInfrastructuresListCall) Pages(ctx context.Context, f func(*ListCloudExadataInfrastructuresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCloudExadataInfrastructuresDbServersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the database servers of an Exadata Infrastructure instance.
//
//   - parent: The parent value for database server in the following format:
//     projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloudE
//     xadataInfrastructure}.
func (r *ProjectsLocationsCloudExadataInfrastructuresDbServersService) List(parent string) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c := &ProjectsLocationsCloudExadataInfrastructuresDbServersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 db servers will be returned. The
// maximum value is 1000; values above 1000 will be reset to 1000.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) PageSize(pageSize int64) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) PageToken(pageToken string) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) Context(ctx context.Context) *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.dbServers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudExadataInfrastructures.dbServers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbServersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) Do(opts ...googleapi.CallOption) (*ListDbServersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbServersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudExadataInfrastructures.dbServers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCloudExadataInfrastructuresDbServersListCall) Pages(ctx context.Context, f func(*ListDbServersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCloudVmClustersCreateCall struct {
	s              *Service
	parent         string
	cloudvmcluster *CloudVmCluster
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new VM Cluster in a given project and location.
//
//   - parent: The name of the parent in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsCloudVmClustersService) Create(parent string, cloudvmcluster *CloudVmCluster) *ProjectsLocationsCloudVmClustersCreateCall {
	c := &ProjectsLocationsCloudVmClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.cloudvmcluster = cloudvmcluster
	return c
}

// CloudVmClusterId sets the optional parameter "cloudVmClusterId": Required.
// The ID of the VM Cluster to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsCloudVmClustersCreateCall) CloudVmClusterId(cloudVmClusterId string) *ProjectsLocationsCloudVmClustersCreateCall {
	c.urlParams_.Set("cloudVmClusterId", cloudVmClusterId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsCloudVmClustersCreateCall) RequestId(requestId string) *ProjectsLocationsCloudVmClustersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudVmClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudVmClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudVmClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsCloudVmClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudVmClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudVmClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cloudvmcluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/cloudVmClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudVmClusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudVmClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudVmClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single VM Cluster.
//
//   - name: The name of the Cloud VM Cluster in the following format:
//     projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}.
func (r *ProjectsLocationsCloudVmClustersService) Delete(name string) *ProjectsLocationsCloudVmClustersDeleteCall {
	c := &ProjectsLocationsCloudVmClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all child
// resources for the VM Cluster will be deleted. A VM Cluster can only be
// deleted once all its child resources have been deleted.
func (c *ProjectsLocationsCloudVmClustersDeleteCall) Force(force bool) *ProjectsLocationsCloudVmClustersDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsCloudVmClustersDeleteCall) RequestId(requestId string) *ProjectsLocationsCloudVmClustersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudVmClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudVmClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudVmClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsCloudVmClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudVmClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudVmClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudVmClusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudVmClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudVmClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single VM Cluster.
//
//   - name: The name of the Cloud VM Cluster in the following format:
//     projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}.
func (r *ProjectsLocationsCloudVmClustersService) Get(name string) *ProjectsLocationsCloudVmClustersGetCall {
	c := &ProjectsLocationsCloudVmClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudVmClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudVmClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudVmClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudVmClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudVmClustersGetCall) Context(ctx context.Context) *ProjectsLocationsCloudVmClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudVmClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudVmClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudVmClusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CloudVmCluster.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudVmClustersGetCall) Do(opts ...googleapi.CallOption) (*CloudVmCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CloudVmCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCloudVmClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the VM Clusters in a given project and location.
//
//   - parent: The name of the parent in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsCloudVmClustersService) List(parent string) *ProjectsLocationsCloudVmClustersListCall {
	c := &ProjectsLocationsCloudVmClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsCloudVmClustersListCall) Filter(filter string) *ProjectsLocationsCloudVmClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The number of VM clusters
// to return. If unspecified, at most 50 VM clusters will be returned. The
// maximum value is 1,000.
func (c *ProjectsLocationsCloudVmClustersListCall) PageSize(pageSize int64) *ProjectsLocationsCloudVmClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying the
// page of results the server returns.
func (c *ProjectsLocationsCloudVmClustersListCall) PageToken(pageToken string) *ProjectsLocationsCloudVmClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudVmClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudVmClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudVmClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudVmClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudVmClustersListCall) Context(ctx context.Context) *ProjectsLocationsCloudVmClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudVmClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudVmClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/cloudVmClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudVmClusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCloudVmClustersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCloudVmClustersListCall) Do(opts ...googleapi.CallOption) (*ListCloudVmClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCloudVmClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCloudVmClustersListCall) Pages(ctx context.Context, f func(*ListCloudVmClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCloudVmClustersDbNodesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the database nodes of a VM Cluster.
//
//   - parent: The parent value for database node in the following format:
//     projects/{project}/locations/{location}/cloudVmClusters/{cloudVmCluster}.
//     .
func (r *ProjectsLocationsCloudVmClustersDbNodesService) List(parent string) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c := &ProjectsLocationsCloudVmClustersDbNodesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 db nodes will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) PageSize(pageSize int64) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the node should return.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) PageToken(pageToken string) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) Context(ctx context.Context) *ProjectsLocationsCloudVmClustersDbNodesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbNodes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.dbNodes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.cloudVmClusters.dbNodes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbNodesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) Do(opts ...googleapi.CallOption) (*ListDbNodesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbNodesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.cloudVmClusters.dbNodes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCloudVmClustersDbNodesListCall) Pages(ctx context.Context, f func(*ListDbNodesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatabaseCharacterSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List DatabaseCharacterSets for the given project and location.
//
//   - parent: The parent value for DatabaseCharacterSets in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsDatabaseCharacterSetsService) List(parent string) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c := &ProjectsLocationsDatabaseCharacterSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only the **character_set_type** field is supported
// in the following format: `character_set_type="{characterSetType}". Accepted
// values include `DATABASE` and `NATIONAL`.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Filter(filter string) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// DatabaseCharacterSets to return. The service may return fewer than this
// value. If unspecified, at most 50 DatabaseCharacterSets will be returned.
// The maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) PageSize(pageSize int64) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDatabaseCharacterSets` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided to
// `ListDatabaseCharacterSets` must match the call that provided the page
// token.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) PageToken(pageToken string) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Context(ctx context.Context) *ProjectsLocationsDatabaseCharacterSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatabaseCharacterSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/databaseCharacterSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databaseCharacterSets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.databaseCharacterSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDatabaseCharacterSetsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Do(opts ...googleapi.CallOption) (*ListDatabaseCharacterSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDatabaseCharacterSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databaseCharacterSets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatabaseCharacterSetsListCall) Pages(ctx context.Context, f func(*ListDatabaseCharacterSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatabasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Database.
//
//   - name: The name of the Database resource in the following format:
//     projects/{project}/locations/{region}/databases/{database}.
func (r *ProjectsLocationsDatabasesService) Get(name string) *ProjectsLocationsDatabasesGetCall {
	c := &ProjectsLocationsDatabasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatabasesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatabasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatabasesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatabasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatabasesGetCall) Context(ctx context.Context) *ProjectsLocationsDatabasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatabasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatabasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.databases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Database.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatabasesGetCall) Do(opts ...googleapi.CallOption) (*Database, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Database{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatabasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Databases for the given project, location and DbSystem.
//
//   - parent: The parent resource name in the following format:
//     projects/{project}/locations/{region}.
func (r *ProjectsLocationsDatabasesService) List(parent string) *ProjectsLocationsDatabasesListCall {
	c := &ProjectsLocationsDatabasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. list for container databases is supported only with
// a valid dbSystem (full resource name) filter in this format:
// `dbSystem="projects/{project}/locations/{location}/dbSystems/{dbSystemId}"
func (c *ProjectsLocationsDatabasesListCall) Filter(filter string) *ProjectsLocationsDatabasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 Databases will be returned. The
// maximum value is 1000; values above 1000 will be reset to 1000.
func (c *ProjectsLocationsDatabasesListCall) PageSize(pageSize int64) *ProjectsLocationsDatabasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying the
// requested page of results to return. All fields except the filter should
// remain the same as in the request that provided this page token.
func (c *ProjectsLocationsDatabasesListCall) PageToken(pageToken string) *ProjectsLocationsDatabasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatabasesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatabasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatabasesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatabasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatabasesListCall) Context(ctx context.Context) *ProjectsLocationsDatabasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatabasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatabasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/databases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.databases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDatabasesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatabasesListCall) Do(opts ...googleapi.CallOption) (*ListDatabasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDatabasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.databases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatabasesListCall) Pages(ctx context.Context, f func(*ListDatabasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDbSystemInitialStorageSizesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the DbSystemInitialStorageSizes for the given project and
// location.
//
//   - parent: The parent value for the DbSystemInitialStorageSize resource with
//     the format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsDbSystemInitialStorageSizesService) List(parent string) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c := &ProjectsLocationsDbSystemInitialStorageSizesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 DbSystemInitialStorageSizes will
// be returned. The maximum value is 1000; values above 1000 will be reset to
// 1000.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) PageSize(pageSize int64) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying the
// requested page of results to return. All fields except the filter should
// remain the same as in the request that provided this page token.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) PageToken(pageToken string) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) Context(ctx context.Context) *ProjectsLocationsDbSystemInitialStorageSizesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbSystemInitialStorageSizes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystemInitialStorageSizes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystemInitialStorageSizes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbSystemInitialStorageSizesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) Do(opts ...googleapi.CallOption) (*ListDbSystemInitialStorageSizesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbSystemInitialStorageSizesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystemInitialStorageSizes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDbSystemInitialStorageSizesListCall) Pages(ctx context.Context, f func(*ListDbSystemInitialStorageSizesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDbSystemShapesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the database system shapes available for the project and
// location.
//
//   - parent: The parent value for Database System Shapes in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsDbSystemShapesService) List(parent string) *ProjectsLocationsDbSystemShapesListCall {
	c := &ProjectsLocationsDbSystemShapesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only the gcp_oracle_zone_id field is supported in
// this format: `gcp_oracle_zone_id="{gcp_oracle_zone_id}".
func (c *ProjectsLocationsDbSystemShapesListCall) Filter(filter string) *ProjectsLocationsDbSystemShapesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 database system shapes will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsDbSystemShapesListCall) PageSize(pageSize int64) *ProjectsLocationsDbSystemShapesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsDbSystemShapesListCall) PageToken(pageToken string) *ProjectsLocationsDbSystemShapesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemShapesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemShapesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDbSystemShapesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDbSystemShapesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemShapesListCall) Context(ctx context.Context) *ProjectsLocationsDbSystemShapesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemShapesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemShapesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbSystemShapes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystemShapes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystemShapes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbSystemShapesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDbSystemShapesListCall) Do(opts ...googleapi.CallOption) (*ListDbSystemShapesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbSystemShapesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystemShapes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDbSystemShapesListCall) Pages(ctx context.Context, f func(*ListDbSystemShapesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDbSystemsCreateCall struct {
	s          *Service
	parent     string
	dbsystem   *DbSystem
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new DbSystem in a given project and location.
//
//   - parent: The value for parent of the DbSystem in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsDbSystemsService) Create(parent string, dbsystem *DbSystem) *ProjectsLocationsDbSystemsCreateCall {
	c := &ProjectsLocationsDbSystemsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dbsystem = dbsystem
	return c
}

// DbSystemId sets the optional parameter "dbSystemId": Required. The ID of the
// DbSystem to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsDbSystemsCreateCall) DbSystemId(dbSystemId string) *ProjectsLocationsDbSystemsCreateCall {
	c.urlParams_.Set("dbSystemId", dbSystemId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsDbSystemsCreateCall) RequestId(requestId string) *ProjectsLocationsDbSystemsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemsCreateCall) Context(ctx context.Context) *ProjectsLocationsDbSystemsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dbsystem)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbSystems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystems.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDbSystemsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDbSystemsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single DbSystem.
//
//   - name: The name of the DbSystem in the following format:
//     projects/{project}/locations/{location}/dbSystems/{db_system}.
func (r *ProjectsLocationsDbSystemsService) Delete(name string) *ProjectsLocationsDbSystemsDeleteCall {
	c := &ProjectsLocationsDbSystemsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsDbSystemsDeleteCall) RequestId(requestId string) *ProjectsLocationsDbSystemsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDbSystemsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystems.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDbSystemsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDbSystemsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single DbSystem.
//
//   - name: The name of the DbSystem in the following format:
//     projects/{project}/locations/{location}/dbSystems/{db_system}.
func (r *ProjectsLocationsDbSystemsService) Get(name string) *ProjectsLocationsDbSystemsGetCall {
	c := &ProjectsLocationsDbSystemsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDbSystemsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDbSystemsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemsGetCall) Context(ctx context.Context) *ProjectsLocationsDbSystemsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystems.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DbSystem.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDbSystemsGetCall) Do(opts ...googleapi.CallOption) (*DbSystem, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DbSystem{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDbSystemsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the DbSystems for the given project and location.
//
//   - parent: The parent value for DbSystems in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsDbSystemsService) List(parent string) *ProjectsLocationsDbSystemsListCall {
	c := &ProjectsLocationsDbSystemsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsDbSystemsListCall) Filter(filter string) *ProjectsLocationsDbSystemsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsDbSystemsListCall) OrderBy(orderBy string) *ProjectsLocationsDbSystemsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 DbSystems will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDbSystemsListCall) PageSize(pageSize int64) *ProjectsLocationsDbSystemsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsDbSystemsListCall) PageToken(pageToken string) *ProjectsLocationsDbSystemsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbSystemsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbSystemsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDbSystemsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDbSystemsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbSystemsListCall) Context(ctx context.Context) *ProjectsLocationsDbSystemsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbSystemsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbSystemsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbSystems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbSystems.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbSystemsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDbSystemsListCall) Do(opts ...googleapi.CallOption) (*ListDbSystemsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbSystemsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbSystems.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDbSystemsListCall) Pages(ctx context.Context, f func(*ListDbSystemsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDbVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List DbVersions for the given project and location.
//
//   - parent: The parent value for the DbVersion resource with the format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsDbVersionsService) List(parent string) *ProjectsLocationsDbVersionsListCall {
	c := &ProjectsLocationsDbVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression that matches
// a subset of the DbVersions to show. The supported filter for dbSystem
// creation is `db_system_shape = {db_system_shape} AND storage_management =
// {storage_management}`. If no filter is provided, all DbVersions will be
// returned.
func (c *ProjectsLocationsDbVersionsListCall) Filter(filter string) *ProjectsLocationsDbVersionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 DbVersions will be returned. The
// maximum value is 1000; values above 1000 will be reset to 1000.
func (c *ProjectsLocationsDbVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsDbVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying the
// requested page of results to return. All fields except the filter should
// remain the same as in the request that provided this page token.
func (c *ProjectsLocationsDbVersionsListCall) PageToken(pageToken string) *ProjectsLocationsDbVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDbVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDbVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDbVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDbVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDbVersionsListCall) Context(ctx context.Context) *ProjectsLocationsDbVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDbVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDbVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbVersions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.dbVersions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbVersionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDbVersionsListCall) Do(opts ...googleapi.CallOption) (*ListDbVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.dbVersions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDbVersionsListCall) Pages(ctx context.Context, f func(*ListDbVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsEntitlementsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the entitlements in a given project.
//
//   - parent: The parent value for the entitlement in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsEntitlementsService) List(parent string) *ProjectsLocationsEntitlementsListCall {
	c := &ProjectsLocationsEntitlementsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 entitlements will be returned.
// The maximum value is 1000.
func (c *ProjectsLocationsEntitlementsListCall) PageSize(pageSize int64) *ProjectsLocationsEntitlementsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsEntitlementsListCall) PageToken(pageToken string) *ProjectsLocationsEntitlementsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEntitlementsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntitlementsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsEntitlementsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntitlementsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEntitlementsListCall) Context(ctx context.Context) *ProjectsLocationsEntitlementsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEntitlementsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntitlementsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entitlements")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.entitlements.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.entitlements.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEntitlementsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEntitlementsListCall) Do(opts ...googleapi.CallOption) (*ListEntitlementsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEntitlementsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.entitlements.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEntitlementsListCall) Pages(ctx context.Context, f func(*ListEntitlementsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsExadbVmClustersCreateCall struct {
	s              *Service
	parent         string
	exadbvmcluster *ExadbVmCluster
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new Exadb (Exascale) VM Cluster resource.
//
//   - parent: The value for parent of the ExadbVmCluster in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsExadbVmClustersService) Create(parent string, exadbvmcluster *ExadbVmCluster) *ProjectsLocationsExadbVmClustersCreateCall {
	c := &ProjectsLocationsExadbVmClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.exadbvmcluster = exadbvmcluster
	return c
}

// ExadbVmClusterId sets the optional parameter "exadbVmClusterId": Required.
// The ID of the ExadbVmCluster to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsExadbVmClustersCreateCall) ExadbVmClusterId(exadbVmClusterId string) *ProjectsLocationsExadbVmClustersCreateCall {
	c.urlParams_.Set("exadbVmClusterId", exadbVmClusterId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsExadbVmClustersCreateCall) RequestId(requestId string) *ProjectsLocationsExadbVmClustersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exadbvmcluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/exadbVmClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExadbVmClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Exadb (Exascale) VM Cluster.
//
//   - name: The name of the ExadbVmCluster in the following format:
//     projects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}.
func (r *ProjectsLocationsExadbVmClustersService) Delete(name string) *ProjectsLocationsExadbVmClustersDeleteCall {
	c := &ProjectsLocationsExadbVmClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsExadbVmClustersDeleteCall) RequestId(requestId string) *ProjectsLocationsExadbVmClustersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExadbVmClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Exadb (Exascale) VM Cluster.
//
//   - name: The name of the ExadbVmCluster in the following format:
//     projects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}.
func (r *ProjectsLocationsExadbVmClustersService) Get(name string) *ProjectsLocationsExadbVmClustersGetCall {
	c := &ProjectsLocationsExadbVmClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExadbVmClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsExadbVmClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersGetCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExadbVmCluster.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersGetCall) Do(opts ...googleapi.CallOption) (*ExadbVmCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExadbVmCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExadbVmClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Exadb (Exascale) VM Clusters for the given project and
// location.
//
//   - parent: The parent value for ExadbVmClusters in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsExadbVmClustersService) List(parent string) *ProjectsLocationsExadbVmClustersListCall {
	c := &ProjectsLocationsExadbVmClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsExadbVmClustersListCall) Filter(filter string) *ProjectsLocationsExadbVmClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsExadbVmClustersListCall) OrderBy(orderBy string) *ProjectsLocationsExadbVmClustersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 ExadbVmClusters will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsExadbVmClustersListCall) PageSize(pageSize int64) *ProjectsLocationsExadbVmClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsExadbVmClustersListCall) PageToken(pageToken string) *ProjectsLocationsExadbVmClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExadbVmClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsExadbVmClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersListCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/exadbVmClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExadbVmClustersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersListCall) Do(opts ...googleapi.CallOption) (*ListExadbVmClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExadbVmClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsExadbVmClustersListCall) Pages(ctx context.Context, f func(*ListExadbVmClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsExadbVmClustersPatchCall struct {
	s              *Service
	name           string
	exadbvmcluster *ExadbVmCluster
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates a single Exadb (Exascale) VM Cluster. To add virtual machines
// to existing exadb vm cluster, only pass the node count.
//
//   - name: Identifier. The name of the ExadbVmCluster resource in the following
//     format:
//     projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}.
func (r *ProjectsLocationsExadbVmClustersService) Patch(name string, exadbvmcluster *ExadbVmCluster) *ProjectsLocationsExadbVmClustersPatchCall {
	c := &ProjectsLocationsExadbVmClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exadbvmcluster = exadbvmcluster
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsExadbVmClustersPatchCall) RequestId(requestId string) *ProjectsLocationsExadbVmClustersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": A mask specifying which
// fields in th VM Cluster should be updated. A field specified in the mask is
// overwritten. If a mask isn't provided then all the fields in the VM Cluster
// are overwritten.
func (c *ProjectsLocationsExadbVmClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsExadbVmClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exadbvmcluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall struct {
	s                                         *Service
	name                                      string
	removevirtualmachineexadbvmclusterrequest *RemoveVirtualMachineExadbVmClusterRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// RemoveVirtualMachine: Removes virtual machines from an existing exadb vm
// cluster.
//
//   - name: The name of the ExadbVmCluster in the following format:
//     projects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}.
func (r *ProjectsLocationsExadbVmClustersService) RemoveVirtualMachine(name string, removevirtualmachineexadbvmclusterrequest *RemoveVirtualMachineExadbVmClusterRequest) *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall {
	c := &ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.removevirtualmachineexadbvmclusterrequest = removevirtualmachineexadbvmclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removevirtualmachineexadbvmclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:removeVirtualMachine")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.removeVirtualMachine", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.removeVirtualMachine" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExadbVmClustersRemoveVirtualMachineCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.removeVirtualMachine", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExadbVmClustersDbNodesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the database nodes of a VM Cluster.
//
//   - parent: The parent value for database node in the following format:
//     projects/{project}/locations/{location}/cloudVmClusters/{cloudVmCluster}.
//     .
func (r *ProjectsLocationsExadbVmClustersDbNodesService) List(parent string) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c := &ProjectsLocationsExadbVmClustersDbNodesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 db nodes will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) PageSize(pageSize int64) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the node should return.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) PageToken(pageToken string) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) Context(ctx context.Context) *ProjectsLocationsExadbVmClustersDbNodesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dbNodes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.dbNodes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exadbVmClusters.dbNodes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDbNodesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) Do(opts ...googleapi.CallOption) (*ListDbNodesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDbNodesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exadbVmClusters.dbNodes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsExadbVmClustersDbNodesListCall) Pages(ctx context.Context, f func(*ListDbNodesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsExascaleDbStorageVaultsCreateCall struct {
	s                      *Service
	parent                 string
	exascaledbstoragevault *ExascaleDbStorageVault
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Create: Creates a new ExascaleDB Storage Vault resource.
//
//   - parent: The value for parent of the ExascaleDbStorageVault in the
//     following format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsExascaleDbStorageVaultsService) Create(parent string, exascaledbstoragevault *ExascaleDbStorageVault) *ProjectsLocationsExascaleDbStorageVaultsCreateCall {
	c := &ProjectsLocationsExascaleDbStorageVaultsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.exascaledbstoragevault = exascaledbstoragevault
	return c
}

// ExascaleDbStorageVaultId sets the optional parameter
// "exascaleDbStorageVaultId": Required. The ID of the ExascaleDbStorageVault
// to create. This value is restricted to (^a-z ([a-z0-9-]{0,61}[a-z0-9])?$)
// and must be a maximum of 63 characters in length. The value must start with
// a letter and end with a letter or a number.
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) ExascaleDbStorageVaultId(exascaleDbStorageVaultId string) *ProjectsLocationsExascaleDbStorageVaultsCreateCall {
	c.urlParams_.Set("exascaleDbStorageVaultId", exascaleDbStorageVaultId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) RequestId(requestId string) *ProjectsLocationsExascaleDbStorageVaultsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsExascaleDbStorageVaultsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) Context(ctx context.Context) *ProjectsLocationsExascaleDbStorageVaultsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exascaledbstoragevault)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/exascaleDbStorageVaults")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exascaleDbStorageVaults.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExascaleDbStorageVaultsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExascaleDbStorageVaultsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ExascaleDB Storage Vault.
//
//   - name: The name of the ExascaleDbStorageVault in the following format:
//     projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascale_d
//     b_storage_vault}.
func (r *ProjectsLocationsExascaleDbStorageVaultsService) Delete(name string) *ProjectsLocationsExascaleDbStorageVaultsDeleteCall {
	c := &ProjectsLocationsExascaleDbStorageVaultsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) RequestId(requestId string) *ProjectsLocationsExascaleDbStorageVaultsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsExascaleDbStorageVaultsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) Context(ctx context.Context) *ProjectsLocationsExascaleDbStorageVaultsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exascaleDbStorageVaults.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExascaleDbStorageVaultsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExascaleDbStorageVaultsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ExascaleDB Storage Vault.
//
//   - name: The name of the ExascaleDbStorageVault in the following format:
//     projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascale_d
//     b_storage_vault}.
func (r *ProjectsLocationsExascaleDbStorageVaultsService) Get(name string) *ProjectsLocationsExascaleDbStorageVaultsGetCall {
	c := &ProjectsLocationsExascaleDbStorageVaultsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsExascaleDbStorageVaultsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsExascaleDbStorageVaultsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) Context(ctx context.Context) *ProjectsLocationsExascaleDbStorageVaultsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exascaleDbStorageVaults.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExascaleDbStorageVault.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsExascaleDbStorageVaultsGetCall) Do(opts ...googleapi.CallOption) (*ExascaleDbStorageVault, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExascaleDbStorageVault{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExascaleDbStorageVaultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the ExascaleDB Storage Vaults for the given project and
// location.
//
//   - parent: The parent value for ExascaleDbStorageVault in the following
//     format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsExascaleDbStorageVaultsService) List(parent string) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c := &ProjectsLocationsExascaleDbStorageVaultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Filter the list as specified in
// https://google.aip.dev/160.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Filter(filter string) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request. Order results as specified in
// https://google.aip.dev/132.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) OrderBy(orderBy string) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 ExascaleDbStorageVaults will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) PageSize(pageSize int64) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) PageToken(pageToken string) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Context(ctx context.Context) *ProjectsLocationsExascaleDbStorageVaultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/exascaleDbStorageVaults")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.exascaleDbStorageVaults.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExascaleDbStorageVaultsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Do(opts ...googleapi.CallOption) (*ListExascaleDbStorageVaultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExascaleDbStorageVaultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.exascaleDbStorageVaults.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsExascaleDbStorageVaultsListCall) Pages(ctx context.Context, f func(*ListExascaleDbStorageVaultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGiVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the valid Oracle Grid Infrastructure (GI) versions for the
// given project and location.
//
//   - parent: The parent value for Grid Infrastructure Version in the following
//     format: Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsGiVersionsService) List(parent string) *ProjectsLocationsGiVersionsListCall {
	c := &ProjectsLocationsGiVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only the shape, gcp_oracle_zone and gi_version
// fields are supported in this format: `shape="{shape}".
func (c *ProjectsLocationsGiVersionsListCall) Filter(filter string) *ProjectsLocationsGiVersionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 Oracle Grid Infrastructure (GI)
// versions will be returned. The maximum value is 1000; values above 1000 will
// be reset to 1000.
func (c *ProjectsLocationsGiVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsGiVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsGiVersionsListCall) PageToken(pageToken string) *ProjectsLocationsGiVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGiVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGiVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGiVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGiVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGiVersionsListCall) Context(ctx context.Context) *ProjectsLocationsGiVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGiVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGiVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/giVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.giVersions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.giVersions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGiVersionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGiVersionsListCall) Do(opts ...googleapi.CallOption) (*ListGiVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGiVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.giVersions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGiVersionsListCall) Pages(ctx context.Context, f func(*ListGiVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGiVersionsMinorVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the valid minor versions for the given project, location, gi
// version and shape family.
//
//   - parent: The parent value for the MinorVersion resource with the format:
//     projects/{project}/locations/{location}/giVersions/{gi_version}.
func (r *ProjectsLocationsGiVersionsMinorVersionsService) List(parent string) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c := &ProjectsLocationsGiVersionsMinorVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Only shapeFamily and gcp_oracle_zone_id are
// supported in this format: `shape_family="{shapeFamily}" AND
// gcp_oracle_zone_id="{gcp_oracle_zone_id}".
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Filter(filter string) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, a maximum of 50 System Versions will be returned.
// The maximum value is 1000; values above 1000 will be reset to 1000.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying the
// requested page of results to return. All fields except the filter should
// remain the same as in the request that provided this page token.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) PageToken(pageToken string) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Context(ctx context.Context) *ProjectsLocationsGiVersionsMinorVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/minorVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.giVersions.minorVersions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.giVersions.minorVersions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMinorVersionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Do(opts ...googleapi.CallOption) (*ListMinorVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMinorVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.giVersions.minorVersions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGiVersionsMinorVersionsListCall) Pages(ctx context.Context, f func(*ListMinorVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOdbNetworksCreateCall struct {
	s          *Service
	parent     string
	odbnetwork *OdbNetwork
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new ODB Network in a given project and location.
//
//   - parent: The parent value for the OdbNetwork in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsOdbNetworksService) Create(parent string, odbnetwork *OdbNetwork) *ProjectsLocationsOdbNetworksCreateCall {
	c := &ProjectsLocationsOdbNetworksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.odbnetwork = odbnetwork
	return c
}

// OdbNetworkId sets the optional parameter "odbNetworkId": Required. The ID of
// the OdbNetwork to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsOdbNetworksCreateCall) OdbNetworkId(odbNetworkId string) *ProjectsLocationsOdbNetworksCreateCall {
	c.urlParams_.Set("odbNetworkId", odbNetworkId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsOdbNetworksCreateCall) RequestId(requestId string) *ProjectsLocationsOdbNetworksCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksCreateCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.odbnetwork)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/odbNetworks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ODB Network.
//
//   - name: The name of the resource in the following format:
//     projects/{project}/locations/{location}/odbNetworks/{odb_network}.
func (r *ProjectsLocationsOdbNetworksService) Delete(name string) *ProjectsLocationsOdbNetworksDeleteCall {
	c := &ProjectsLocationsOdbNetworksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsOdbNetworksDeleteCall) RequestId(requestId string) *ProjectsLocationsOdbNetworksDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksDeleteCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ODB Network.
//
//   - name: The name of the OdbNetwork in the following format:
//     projects/{project}/locations/{location}/odbNetworks/{odb_network}.
func (r *ProjectsLocationsOdbNetworksService) Get(name string) *ProjectsLocationsOdbNetworksGetCall {
	c := &ProjectsLocationsOdbNetworksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOdbNetworksGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOdbNetworksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksGetCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OdbNetwork.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksGetCall) Do(opts ...googleapi.CallOption) (*OdbNetwork, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OdbNetwork{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the ODB Networks in a given project and location.
//
//   - parent: The parent value for the ODB Network in the following format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsOdbNetworksService) List(parent string) *ProjectsLocationsOdbNetworksListCall {
	c := &ProjectsLocationsOdbNetworksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsOdbNetworksListCall) Filter(filter string) *ProjectsLocationsOdbNetworksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsOdbNetworksListCall) OrderBy(orderBy string) *ProjectsLocationsOdbNetworksListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 ODB Networks will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsOdbNetworksListCall) PageSize(pageSize int64) *ProjectsLocationsOdbNetworksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsOdbNetworksListCall) PageToken(pageToken string) *ProjectsLocationsOdbNetworksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOdbNetworksListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOdbNetworksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksListCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/odbNetworks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOdbNetworksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksListCall) Do(opts ...googleapi.CallOption) (*ListOdbNetworksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOdbNetworksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOdbNetworksListCall) Pages(ctx context.Context, f func(*ListOdbNetworksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOdbNetworksOdbSubnetsCreateCall struct {
	s          *Service
	parent     string
	odbsubnet  *OdbSubnet
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new ODB Subnet in a given ODB Network.
//
//   - parent: The parent value for the OdbSubnet in the following format:
//     projects/{project}/locations/{location}/odbNetworks/{odb_network}.
func (r *ProjectsLocationsOdbNetworksOdbSubnetsService) Create(parent string, odbsubnet *OdbSubnet) *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall {
	c := &ProjectsLocationsOdbNetworksOdbSubnetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.odbsubnet = odbsubnet
	return c
}

// OdbSubnetId sets the optional parameter "odbSubnetId": Required. The ID of
// the OdbSubnet to create. This value is restricted to (^a-z
// ([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63 characters in
// length. The value must start with a letter and end with a letter or a
// number.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) OdbSubnetId(odbSubnetId string) *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall {
	c.urlParams_.Set("odbSubnetId", odbSubnetId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) RequestId(requestId string) *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.odbsubnet)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/odbSubnets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.odbSubnets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ODB Subnet.
//
//   - name: The name of the resource in the following format:
//     projects/{project}/locations/{region}/odbNetworks/{odb_network}/odbSubnets/
//     {odb_subnet}.
func (r *ProjectsLocationsOdbNetworksOdbSubnetsService) Delete(name string) *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall {
	c := &ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional ID to
// identify the request. This value is used to identify duplicate requests. If
// you make a request with the same request ID and the original request is
// still in progress or completed, the server ignores the second request. This
// prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) RequestId(requestId string) *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.odbSubnets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksOdbSubnetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ODB Subnet.
//
//   - name: The name of the OdbSubnet in the following format:
//     projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnet
//     s/{odb_subnet}.
func (r *ProjectsLocationsOdbNetworksOdbSubnetsService) Get(name string) *ProjectsLocationsOdbNetworksOdbSubnetsGetCall {
	c := &ProjectsLocationsOdbNetworksOdbSubnetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksOdbSubnetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOdbNetworksOdbSubnetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksOdbSubnetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.odbSubnets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OdbSubnet.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsGetCall) Do(opts ...googleapi.CallOption) (*OdbSubnet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OdbSubnet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOdbNetworksOdbSubnetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the ODB Subnets in a given ODB Network.
//
//   - parent: The parent value for the OdbSubnet in the following format:
//     projects/{project}/locations/{location}/odbNetworks/{odb_network}.
func (r *ProjectsLocationsOdbNetworksOdbSubnetsService) List(parent string) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c := &ProjectsLocationsOdbNetworksOdbSubnetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Filter(filter string) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An expression for ordering
// the results of the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) OrderBy(orderBy string) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If unspecified, at most 50 ODB Networks will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) PageSize(pageSize int64) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) PageToken(pageToken string) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Context(ctx context.Context) *ProjectsLocationsOdbNetworksOdbSubnetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/odbSubnets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.odbNetworks.odbSubnets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOdbSubnetsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Do(opts ...googleapi.CallOption) (*ListOdbSubnetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOdbSubnetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.odbNetworks.odbSubnets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOdbNetworksOdbSubnetsListCall) Pages(ctx context.Context, f func(*ListOdbSubnetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// [ListOperationsResponse.unreachable] field. This can only be `true` when
// reading across collections e.g. when `parent` is set to
// "projects/example/locations/-". This field is not by default supported and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPluggableDatabasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single PluggableDatabase.
//
//   - name: The name of the PluggableDatabase resource in the following format:
//     projects/{project}/locations/{region}/pluggableDatabases/{pluggable_databas
//     e}.
func (r *ProjectsLocationsPluggableDatabasesService) Get(name string) *ProjectsLocationsPluggableDatabasesGetCall {
	c := &ProjectsLocationsPluggableDatabasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluggableDatabasesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluggableDatabasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluggableDatabasesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluggableDatabasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluggableDatabasesGetCall) Context(ctx context.Context) *ProjectsLocationsPluggableDatabasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluggableDatabasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluggableDatabasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.pluggableDatabases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.pluggableDatabases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PluggableDatabase.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPluggableDatabasesGetCall) Do(opts ...googleapi.CallOption) (*PluggableDatabase, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PluggableDatabase{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.pluggableDatabases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluggableDatabasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the PluggableDatabases for the given project, location and
// Container Database.
//
//   - parent: The parent, which owns this collection of PluggableDatabases.
//     Format: projects/{project}/locations/{location}.
func (r *ProjectsLocationsPluggableDatabasesService) List(parent string) *ProjectsLocationsPluggableDatabasesListCall {
	c := &ProjectsLocationsPluggableDatabasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. List for pluggable databases is supported only with
// a valid container database (full resource name) filter in this format:
// `database="projects/{project}/locations/{location}/databases/{database}"
func (c *ProjectsLocationsPluggableDatabasesListCall) Filter(filter string) *ProjectsLocationsPluggableDatabasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// PluggableDatabases to return. The service may return fewer than this value.
func (c *ProjectsLocationsPluggableDatabasesListCall) PageSize(pageSize int64) *ProjectsLocationsPluggableDatabasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPluggableDatabases` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListPluggableDatabases` must match the call that provided the page token.
func (c *ProjectsLocationsPluggableDatabasesListCall) PageToken(pageToken string) *ProjectsLocationsPluggableDatabasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluggableDatabasesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluggableDatabasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluggableDatabasesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluggableDatabasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluggableDatabasesListCall) Context(ctx context.Context) *ProjectsLocationsPluggableDatabasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluggableDatabasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluggableDatabasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/pluggableDatabases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.pluggableDatabases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "oracledatabase.projects.locations.pluggableDatabases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPluggableDatabasesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluggableDatabasesListCall) Do(opts ...googleapi.CallOption) (*ListPluggableDatabasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPluggableDatabasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "oracledatabase.projects.locations.pluggableDatabases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPluggableDatabasesListCall) Pages(ctx context.Context, f func(*ListPluggableDatabasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
