; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use(i32,...)

define i1 @both_sides_fold_slt(i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @both_sides_fold_slt
; CHECK-SAME: (i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i1 false
;
entry:
  %cond1 = select i1 %cond, i32 1, i32 %param
  %cond6 = select i1 %cond, i32 9, i32 %param
  %cmp = icmp slt i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @both_sides_fold_eq(i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @both_sides_fold_eq
; CHECK-SAME: (i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[NOT_COND:%.*]] = xor i1 [[COND]], true
; CHECK-NEXT:    ret i1 [[NOT_COND]]
;
entry:
  %cond1 = select i1 %cond, i32 1, i32 %param
  %cond6 = select i1 %cond, i32 9, i32 %param
  %cmp = icmp eq i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @one_side_fold_slt(i32 %val1, i32 %val2, i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @one_side_fold_slt
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i32 [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[CMP:%.*]] = select i1 [[COND]], i1 [[TMP0]], i1 false
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %val1, i32 %param
  %cond6 = select i1 %cond, i32 %val2, i32 %param
  %cmp = icmp slt i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @one_side_fold_sgt(i32 %val1, i32 %val2, i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @one_side_fold_sgt
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp sgt i32 [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[NOT_COND:%.*]] = xor i1 [[COND]], true
; CHECK-NEXT:    [[CMP:%.*]] = select i1 [[NOT_COND]], i1 [[TMP0]], i1 false
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %param, i32 %val1
  %cond6 = select i1 %cond, i32 %param, i32 %val2
  %cmp = icmp sgt i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @one_side_fold_eq(i32 %val1, i32 %val2, i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @one_side_fold_eq
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i32 [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[NOT_COND:%.*]] = xor i1 [[COND]], true
; CHECK-NEXT:    [[CMP:%.*]] = select i1 [[NOT_COND]], i1 true, i1 [[TMP0]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %val1, i32 %param
  %cond6 = select i1 %cond, i32 %val2, i32 %param
  %cmp = icmp eq i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @no_side_fold_cond(i32 %val1, i32 %val2, i32 %param, i1 %cond1, i1 %cond2) {
; CHECK-LABEL: define i1 @no_side_fold_cond
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND1:%.*]], i1 [[COND2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND3:%.*]] = select i1 [[COND1]], i32 [[VAL1]], i32 [[PARAM]]
; CHECK-NEXT:    [[COND6:%.*]] = select i1 [[COND2]], i32 [[VAL2]], i32 [[PARAM]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[COND6]], [[COND3]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond3 = select i1 %cond1, i32 %val1, i32 %param
  %cond6 = select i1 %cond2, i32 %val2, i32 %param
  %cmp = icmp sle i32 %cond6, %cond3
  ret i1 %cmp
}

define i1 @no_side_fold_op(i32 %val1, i32 %val2, i32 %val3, i1 %cond) {
; CHECK-LABEL: define i1 @no_side_fold_op
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[VAL3:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND1:%.*]] = select i1 [[COND]], i32 [[VAL1]], i32 [[VAL2]]
; CHECK-NEXT:    [[COND6:%.*]] = select i1 [[COND]], i32 [[VAL2]], i32 [[VAL3]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[COND6]], [[COND1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %val1, i32 %val2
  %cond6 = select i1 %cond, i32 %val2, i32 %val3
  %cmp = icmp sge i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @one_select_mult_use(i32 %val1, i32 %val2, i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @one_select_mult_use
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND1:%.*]] = select i1 [[COND]], i32 [[VAL1]], i32 [[PARAM]]
; CHECK-NEXT:    call void @use(i32 [[COND1]])
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i32 [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[CMP:%.*]] = select i1 [[COND]], i1 [[TMP0]], i1 false
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %val1, i32 %param
  %cond6 = select i1 %cond, i32 %val2, i32 %param
  call void @use(i32 %cond1)
  %cmp = icmp slt i32 %cond6, %cond1
  ret i1 %cmp
}

define i1 @both_select_mult_use(i32 %val1, i32 %val2, i32 %param, i1 %cond) {
; CHECK-LABEL: define i1 @both_select_mult_use
; CHECK-SAME: (i32 [[VAL1:%.*]], i32 [[VAL2:%.*]], i32 [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND1:%.*]] = select i1 [[COND]], i32 [[VAL1]], i32 [[PARAM]]
; CHECK-NEXT:    [[COND6:%.*]] = select i1 [[COND]], i32 [[VAL2]], i32 [[PARAM]]
; CHECK-NEXT:    call void @use(i32 [[COND1]], i32 [[COND6]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[COND6]], [[COND1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %cond1 = select i1 %cond, i32 %val1, i32 %param
  %cond6 = select i1 %cond, i32 %val2, i32 %param
  call void @use(i32 %cond1, i32 %cond6)
  %cmp = icmp slt i32 %cond6, %cond1
  ret i1 %cmp
}

define <4 x i1> @fold_vector_ops(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %param, i1 %cond) {
; CHECK-LABEL: define <4 x i1> @fold_vector_ops
; CHECK-SAME: (<4 x i32> [[VAL1:%.*]], <4 x i32> [[VAL2:%.*]], <4 x i32> [[PARAM:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq <4 x i32> [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[CMP:%.*]] = select i1 [[COND]], <4 x i1> [[TMP0]], <4 x i1> <i1 true, i1 true, i1 true, i1 true>
; CHECK-NEXT:    ret <4 x i1> [[CMP]]
;
entry:
  %cond1 = select i1 %cond, <4 x i32> %val1, <4 x i32> %param
  %cond6 = select i1 %cond, <4 x i32> %val2, <4 x i32> %param
  %cmp = icmp eq <4 x i32> %cond6, %cond1
  ret <4 x i1> %cmp
}

define <8 x i1> @fold_vector_cond_ops(<8 x i32> %val1, <8 x i32> %val2, <8 x i32> %param, <8 x i1> %cond) {
; CHECK-LABEL: define <8 x i1> @fold_vector_cond_ops
; CHECK-SAME: (<8 x i32> [[VAL1:%.*]], <8 x i32> [[VAL2:%.*]], <8 x i32> [[PARAM:%.*]], <8 x i1> [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp sgt <8 x i32> [[VAL2]], [[VAL1]]
; CHECK-NEXT:    [[CMP:%.*]] = select <8 x i1> [[COND]], <8 x i1> [[TMP0]], <8 x i1> zeroinitializer
; CHECK-NEXT:    ret <8 x i1> [[CMP]]
;
entry:
  %cond1 = select <8 x i1> %cond, <8 x i32> %val1, <8 x i32> %param
  %cond6 = select <8 x i1> %cond, <8 x i32> %val2, <8 x i32> %param
  %cmp = icmp sgt <8 x i32> %cond6, %cond1
  ret <8 x i1> %cmp
}
