// DO NOT EDIT: This file is autogenerated via the builtin command.

package discord

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   58,
				},
				File:   "discord.flux",
				Source: "package discord\n\n\nimport \"http\"\nimport \"json\"\n\noption discordURL = \"https://discordapp.com/api/webhooks/\"\n\n// `webhookToken` - string - the secure token of the webhook.\n// `webhookID` - string - the ID of the webhook.\n// `username` - string - username posting the message.\n// `content` - string - the text to display in discord.\n// `avatar_url` -  override the default avatar of the webhook.\nsend = (\n        webhookToken,\n        webhookID,\n        username,\n        content,\n        avatar_url=\"\",\n) => {\n    data = {\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    encode = json.encode(v: data)\n\n    return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to discord for each table row.\n// `webhookToken` - string - the secure token of the webhook.\n// `webhookID` - string - the ID of the webhook.\n// `username` - string - username posting the message.\n// `avatar_url` -  override the default avatar of the webhook.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `content`, as defined in the `send` function arguments.\nendpoint = (webhookToken, webhookID, username, avatar_url=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   7,
						},
						File:   "discord.flux",
						Source: "discordURL = \"https://discordapp.com/api/webhooks/\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   7,
							},
							File:   "discord.flux",
							Source: "discordURL",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "discordURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   7,
							},
							File:   "discord.flux",
							Source: "\"https://discordapp.com/api/webhooks/\"",
							Start: ast.Position{
								Column: 21,
								Line:   7,
							},
						},
					},
					Value: "https://discordapp.com/api/webhooks/",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   7,
					},
					File:   "discord.flux",
					Source: "option discordURL = \"https://discordapp.com/api/webhooks/\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "discord.flux",
					Source: "send = (\n        webhookToken,\n        webhookID,\n        username,\n        content,\n        avatar_url=\"\",\n) => {\n    data = {\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    encode = json.encode(v: data)\n\n    return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `webhookToken` - string - the secure token of the webhook.\n"}, ast.Comment{Text: "// `webhookID` - string - the ID of the webhook.\n"}, ast.Comment{Text: "// `username` - string - username posting the message.\n"}, ast.Comment{Text: "// `content` - string - the text to display in discord.\n"}, ast.Comment{Text: "// `avatar_url` -  override the default avatar of the webhook.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   14,
						},
						File:   "discord.flux",
						Source: "send",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "send",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "discord.flux",
						Source: "(\n        webhookToken,\n        webhookID,\n        username,\n        content,\n        avatar_url=\"\",\n) => {\n    data = {\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    encode = json.encode(v: data)\n\n    return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   14,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   32,
							},
							File:   "discord.flux",
							Source: "{\n    data = {\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    encode = json.encode(v: data)\n\n    return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   20,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   25,
								},
								File:   "discord.flux",
								Source: "data = {\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   21,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   21,
									},
									File:   "discord.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   21,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   25,
									},
									File:   "discord.flux",
									Source: "{\n        username: username,\n        content: content,\n        avatar_url: avatar_url,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   21,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   22,
										},
										File:   "discord.flux",
										Source: "username: username",
										Start: ast.Position{
											Column: 9,
											Line:   22,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   22,
											},
											File:   "discord.flux",
											Source: "username",
											Start: ast.Position{
												Column: 9,
												Line:   22,
											},
										},
									},
									Name: "username",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   22,
											},
											File:   "discord.flux",
											Source: "username",
											Start: ast.Position{
												Column: 19,
												Line:   22,
											},
										},
									},
									Name: "username",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   23,
										},
										File:   "discord.flux",
										Source: "content: content",
										Start: ast.Position{
											Column: 9,
											Line:   23,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   23,
											},
											File:   "discord.flux",
											Source: "content",
											Start: ast.Position{
												Column: 9,
												Line:   23,
											},
										},
									},
									Name: "content",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   23,
											},
											File:   "discord.flux",
											Source: "content",
											Start: ast.Position{
												Column: 18,
												Line:   23,
											},
										},
									},
									Name: "content",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   24,
										},
										File:   "discord.flux",
										Source: "avatar_url: avatar_url",
										Start: ast.Position{
											Column: 9,
											Line:   24,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   24,
											},
											File:   "discord.flux",
											Source: "avatar_url",
											Start: ast.Position{
												Column: 9,
												Line:   24,
											},
										},
									},
									Name: "avatar_url",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   24,
											},
											File:   "discord.flux",
											Source: "avatar_url",
											Start: ast.Position{
												Column: 21,
												Line:   24,
											},
										},
									},
									Name: "avatar_url",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   28,
								},
								File:   "discord.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   26,
									},
									File:   "discord.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   26,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   28,
									},
									File:   "discord.flux",
									Source: "{\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   26,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   27,
										},
										File:   "discord.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   27,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   27,
											},
											File:   "discord.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   27,
											},
											File:   "discord.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   27,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   29,
								},
								File:   "discord.flux",
								Source: "encode = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   29,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   29,
									},
									File:   "discord.flux",
									Source: "encode",
									Start: ast.Position{
										Column: 5,
										Line:   29,
									},
								},
							},
							Name: "encode",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   29,
										},
										File:   "discord.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 26,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   29,
											},
											File:   "discord.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 26,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   29,
												},
												File:   "discord.flux",
												Source: "v",
												Start: ast.Position{
													Column: 26,
													Line:   29,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   29,
												},
												File:   "discord.flux",
												Source: "data",
												Start: ast.Position{
													Column: 29,
													Line:   29,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   29,
									},
									File:   "discord.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 14,
										Line:   29,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   29,
										},
										File:   "discord.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 14,
											Line:   29,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   29,
											},
											File:   "discord.flux",
											Source: "json",
											Start: ast.Position{
												Column: 14,
												Line:   29,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   29,
											},
											File:   "discord.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 19,
												Line:   29,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   31,
										},
										File:   "discord.flux",
										Source: "headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode",
										Start: ast.Position{
											Column: 22,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   31,
											},
											File:   "discord.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   31,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   31,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   31,
											},
											File:   "discord.flux",
											Source: "url: discordURL + webhookID + \"/\" + webhookToken",
											Start: ast.Position{
												Column: 40,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   31,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "discordURL + webhookID + \"/\" + webhookToken",
												Start: ast.Position{
													Column: 45,
													Line:   31,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   31,
													},
													File:   "discord.flux",
													Source: "discordURL + webhookID + \"/\"",
													Start: ast.Position{
														Column: 45,
														Line:   31,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   31,
														},
														File:   "discord.flux",
														Source: "discordURL + webhookID",
														Start: ast.Position{
															Column: 45,
															Line:   31,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   31,
															},
															File:   "discord.flux",
															Source: "discordURL",
															Start: ast.Position{
																Column: 45,
																Line:   31,
															},
														},
													},
													Name: "discordURL",
												},
												Operator: 5,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   31,
															},
															File:   "discord.flux",
															Source: "webhookID",
															Start: ast.Position{
																Column: 58,
																Line:   31,
															},
														},
													},
													Name: "webhookID",
												},
											},
											Operator: 5,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   31,
														},
														File:   "discord.flux",
														Source: "\"/\"",
														Start: ast.Position{
															Column: 70,
															Line:   31,
														},
													},
												},
												Value: "/",
											},
										},
										Operator: 5,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   31,
													},
													File:   "discord.flux",
													Source: "webhookToken",
													Start: ast.Position{
														Column: 76,
														Line:   31,
													},
												},
											},
											Name: "webhookToken",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   31,
											},
											File:   "discord.flux",
											Source: "data: encode",
											Start: ast.Position{
												Column: 90,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "data",
												Start: ast.Position{
													Column: 90,
													Line:   31,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   31,
												},
												File:   "discord.flux",
												Source: "encode",
												Start: ast.Position{
													Column: 96,
													Line:   31,
												},
											},
										},
										Name: "encode",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   31,
									},
									File:   "discord.flux",
									Source: "http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)",
									Start: ast.Position{
										Column: 12,
										Line:   31,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   31,
										},
										File:   "discord.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   31,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   31,
											},
											File:   "discord.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   31,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   31,
											},
											File:   "discord.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   31,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   31,
								},
								File:   "discord.flux",
								Source: "return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   15,
							},
							File:   "discord.flux",
							Source: "webhookToken",
							Start: ast.Position{
								Column: 9,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   15,
								},
								File:   "discord.flux",
								Source: "webhookToken",
								Start: ast.Position{
									Column: 9,
									Line:   15,
								},
							},
						},
						Name: "webhookToken",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   16,
							},
							File:   "discord.flux",
							Source: "webhookID",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   16,
								},
								File:   "discord.flux",
								Source: "webhookID",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "webhookID",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   17,
							},
							File:   "discord.flux",
							Source: "username",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   17,
								},
								File:   "discord.flux",
								Source: "username",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   18,
							},
							File:   "discord.flux",
							Source: "content",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   18,
								},
								File:   "discord.flux",
								Source: "content",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "content",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   19,
							},
							File:   "discord.flux",
							Source: "avatar_url=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   19,
								},
								File:   "discord.flux",
								Source: "avatar_url",
								Start: ast.Position{
									Column: 9,
									Line:   19,
								},
							},
						},
						Name: "avatar_url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   19,
								},
								File:   "discord.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 20,
									Line:   19,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   58,
					},
					File:   "discord.flux",
					Source: "endpoint = (webhookToken, webhookID, username, avatar_url=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to discord for each table row.\n"}, ast.Comment{Text: "// `webhookToken` - string - the secure token of the webhook.\n"}, ast.Comment{Text: "// `webhookID` - string - the ID of the webhook.\n"}, ast.Comment{Text: "// `username` - string - username posting the message.\n"}, ast.Comment{Text: "// `avatar_url` -  override the default avatar of the webhook.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `content`, as defined in the `send` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   41,
						},
						File:   "discord.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   58,
						},
						File:   "discord.flux",
						Source: "(webhookToken, webhookID, username, avatar_url=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   41,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   58,
							},
							File:   "discord.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 66,
								Line:   41,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   58,
								},
								File:   "discord.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 77,
									Line:   41,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   41,
										},
										File:   "discord.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 92,
											Line:   41,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   58,
									},
									File:   "discord.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 92,
										Line:   41,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   57,
											},
											File:   "discord.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   43,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   57,
												},
												File:   "discord.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   43,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   43,
													},
													File:   "discord.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   43,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   57,
													},
													File:   "discord.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   43,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   57,
														},
														File:   "discord.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   43,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   44,
															},
															File:   "discord.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   44,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   44,
																},
																File:   "discord.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   44,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   44,
																	},
																	File:   "discord.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   44,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   44,
																		},
																		File:   "discord.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   44,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   44,
																			},
																			File:   "discord.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   44,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   44,
																			},
																			File:   "discord.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   44,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   44,
																},
																File:   "discord.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   44,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   44,
																	},
																	File:   "discord.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   44,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   56,
																},
																File:   "discord.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   46,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   55,
																	},
																	File:   "discord.flux",
																	Source: "_sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   47,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   47,
																		},
																		File:   "discord.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   47,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   54,
																			},
																			File:   "discord.flux",
																			Source: "v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   48,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   54,
																				},
																				File:   "discord.flux",
																				Source: "v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   48,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   48,
																					},
																					File:   "discord.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   48,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   54,
																					},
																					File:   "discord.flux",
																					Source: "2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   48,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   48,
																						},
																						File:   "discord.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   48,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   54,
																						},
																						File:   "discord.flux",
																						Source: "send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   48,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 45,
																									Line:   53,
																								},
																								File:   "discord.flux",
																								Source: "webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content",
																								Start: ast.Position{
																									Column: 25,
																									Line:   49,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 51,
																										Line:   49,
																									},
																									File:   "discord.flux",
																									Source: "webhookToken: webhookToken",
																									Start: ast.Position{
																										Column: 25,
																										Line:   49,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   49,
																										},
																										File:   "discord.flux",
																										Source: "webhookToken",
																										Start: ast.Position{
																											Column: 25,
																											Line:   49,
																										},
																									},
																								},
																								Name: "webhookToken",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   49,
																										},
																										File:   "discord.flux",
																										Source: "webhookToken",
																										Start: ast.Position{
																											Column: 39,
																											Line:   49,
																										},
																									},
																								},
																								Name: "webhookToken",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   50,
																									},
																									File:   "discord.flux",
																									Source: "webhookID: webhookID",
																									Start: ast.Position{
																										Column: 25,
																										Line:   50,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   50,
																										},
																										File:   "discord.flux",
																										Source: "webhookID",
																										Start: ast.Position{
																											Column: 25,
																											Line:   50,
																										},
																									},
																								},
																								Name: "webhookID",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   50,
																										},
																										File:   "discord.flux",
																										Source: "webhookID",
																										Start: ast.Position{
																											Column: 36,
																											Line:   50,
																										},
																									},
																								},
																								Name: "webhookID",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   51,
																									},
																									File:   "discord.flux",
																									Source: "username: username",
																									Start: ast.Position{
																										Column: 25,
																										Line:   51,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   51,
																										},
																										File:   "discord.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 25,
																											Line:   51,
																										},
																									},
																								},
																								Name: "username",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   51,
																										},
																										File:   "discord.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 35,
																											Line:   51,
																										},
																									},
																								},
																								Name: "username",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   52,
																									},
																									File:   "discord.flux",
																									Source: "avatar_url: avatar_url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   52,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   52,
																										},
																										File:   "discord.flux",
																										Source: "avatar_url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   52,
																										},
																									},
																								},
																								Name: "avatar_url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   52,
																										},
																										File:   "discord.flux",
																										Source: "avatar_url",
																										Start: ast.Position{
																											Column: 37,
																											Line:   52,
																										},
																									},
																								},
																								Name: "avatar_url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   53,
																									},
																									File:   "discord.flux",
																									Source: "content: obj.content",
																									Start: ast.Position{
																										Column: 25,
																										Line:   53,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   53,
																										},
																										File:   "discord.flux",
																										Source: "content",
																										Start: ast.Position{
																											Column: 25,
																											Line:   53,
																										},
																									},
																								},
																								Name: "content",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   53,
																										},
																										File:   "discord.flux",
																										Source: "obj.content",
																										Start: ast.Position{
																											Column: 34,
																											Line:   53,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   53,
																											},
																											File:   "discord.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   53,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   53,
																											},
																											File:   "discord.flux",
																											Source: "content",
																											Start: ast.Position{
																												Column: 38,
																												Line:   53,
																											},
																										},
																									},
																									Name: "content",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   54,
																							},
																							File:   "discord.flux",
																							Source: "send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   48,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 33,
																									Line:   48,
																								},
																								File:   "discord.flux",
																								Source: "send",
																								Start: ast.Position{
																									Column: 29,
																									Line:   48,
																								},
																							},
																						},
																						Name: "send",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   54,
																							},
																							File:   "discord.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   54,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   55,
																		},
																		File:   "discord.flux",
																		Source: "string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   47,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   47,
																			},
																			File:   "discord.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   47,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   46,
																	},
																	File:   "discord.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   46,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   56,
															},
															File:   "discord.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   46,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   43,
														},
														File:   "discord.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   43,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   43,
															},
															File:   "discord.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   43,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   58,
										},
										File:   "discord.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == send(\n                        webhookToken: webhookToken,\n                        webhookID: webhookID,\n                        username: username,\n                        avatar_url: avatar_url,\n                        content: obj.content,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   42,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   42,
											},
											File:   "discord.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   42,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 87,
										Line:   41,
									},
									File:   "discord.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 78,
										Line:   41,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   41,
										},
										File:   "discord.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 78,
											Line:   41,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 87,
										Line:   41,
									},
									File:   "discord.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 85,
										Line:   41,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 67,
									Line:   41,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   41,
									},
									File:   "discord.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 67,
										Line:   41,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   41,
							},
							File:   "discord.flux",
							Source: "webhookToken",
							Start: ast.Position{
								Column: 13,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "webhookToken",
								Start: ast.Position{
									Column: 13,
									Line:   41,
								},
							},
						},
						Name: "webhookToken",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   41,
							},
							File:   "discord.flux",
							Source: "webhookID",
							Start: ast.Position{
								Column: 27,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "webhookID",
								Start: ast.Position{
									Column: 27,
									Line:   41,
								},
							},
						},
						Name: "webhookID",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   41,
							},
							File:   "discord.flux",
							Source: "username",
							Start: ast.Position{
								Column: 38,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "username",
								Start: ast.Position{
									Column: 38,
									Line:   41,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   41,
							},
							File:   "discord.flux",
							Source: "avatar_url=\"\"",
							Start: ast.Position{
								Column: 48,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "avatar_url",
								Start: ast.Position{
									Column: 48,
									Line:   41,
								},
							},
						},
						Name: "avatar_url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   41,
								},
								File:   "discord.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 59,
									Line:   41,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "discord.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "discord.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "discord.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "discord.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "discord.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   1,
					},
					File:   "discord.flux",
					Source: "package discord",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   1,
						},
						File:   "discord.flux",
						Source: "discord",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "discord",
			},
		},
	}},
	Package: "discord",
	Path:    "contrib/chobbs/discord",
}
