// DO NOT EDIT: This file is autogenerated via the builtin command.

package monitor

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   304,
				},
				File:   "monitor.flux",
				Source: "package monitor\n\n\nimport \"experimental\"\nimport \"influxdata/influxdb/v1\"\nimport \"influxdata/influxdb\"\n\nbucket = \"_monitoring\"\n\n// Write persists the check statuses\noption write = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// Log records notification events\noption log = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// logs retrieves notification events stored in the notifications measurement in the _monitoring bucket.\n//\n// ## Parameters\n// - `start` is the earliest time to include in results\n//\n//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n//\n// - `stop` is the latest time to include in results\n//\n//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n//\n// - `fn` is a single argument predicate function that evaluates true or false.\n//\n//      Records or rows (r) that evaluate to true are included in output tables.\n//      Records that evaluate to null or false are not included in output tables.\n//\n// ## Query notification events from the last hour\n// ```\n// import \"influxdata/influxdb/monitor\"\n//\n// monitor.logs(start: -2h, fn: (r) => true)\n// ```\n//\nlogs = (start, stop=now(), fn) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()\n\n// from retrieves check statuses stored in the statuses measurement in the _monitoring bucket.\n//\n// ## Parameters\n// - `start` is the earliest time to include in results\n//\n//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n//\n// - `stop` is the latest time to include in results\n//\n//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n//\n// - `fn` is a single argument predicate function that evaluates true or false.\n//\n//      Records or rows (r) that evaluate to true are included in output tables.\n//      Records that evaluate to null or false are not included in output tables.\n//\n// ## View critical check statuses from the last hour\n// ```\n// import \"influxdata/influxdb/monitor\"\n//\n// monitor.from(\n//  start: -1h,\n//  fn: (r) => r._level == \"crit\"\n// )\n// ```\n//\nfrom = (start, stop=now(), fn=(r) => true) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()\n\n// levels describing the result of a check\nlevelOK = \"ok\"\nlevelInfo = \"info\"\nlevelWarn = \"warn\"\nlevelCrit = \"crit\"\nlevelUnknown = \"unknown\"\n_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel\n    fromLevelFilter = if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel\n\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// Notify will call the endpoint and log the results.\nnotify = (tables=<-, endpoint, data) => tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n    |> log()\n\n// stateChangesOnly takes a stream of tables that contains a _level column\n// and returns a stream of tables where each record represents a state change.\n//\n// ## Return records representing state changes\n// ```\n// import \"influxdata/influxdb/monitor\"\n//\n// monitor.from(start: -1h)\n//  |> monitor.stateChangesOnly()\n//\n// ```\n//\nstateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// stateChanges detects state changes in a stream of data with a _level column and outputs records that change from fromLevel to toLevel.\n//\n// ## Parameters\n// - `fromLevel` is the level to detect a change from. Defaults to \"any\".\n// - `toLevel` is the level to detect a change to. The function output records that change to this level\n//\n// ## Detect when the state changes to critical\n// ```\n// monitor.from(start: -1h)\n//    |> monitor.stateChanges(toLevel: \"crit\")\n// ```\n//\nstateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}\n\n// deadman detects when a group stops reporting data.\n// It takes a stream of tables and reports if groups have been observed since time t.\n//\n//      monitor.deadman() retains the most recent row from each input table and adds a dead column.\n//      If a record appears after time t, monitor.deadman() sets dead to false. Otherwise, dead is set to true.\n//\n// ## Parameters\n// - `t` is the time threshold for the deadman check.\n//\n// ## Detect if a host hasn’t reported in the last five minutes\n// ```\n// import \"influxdata/influxdb/monitor\"\n// import \"experimental\"\n//\n// from(bucket: \"example-bucket\")\n//   |> range(start: -10m)\n//   |> group(columns: [\"host\"])\n//   |> monitor.deadman(t: experimental.subDuration(d: 5m, from: now() ))\n// ```\n//\ndeadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ({r with dead: r._time < t}))\n\n// check checks input data and assigns a level (ok, info, warn, or crit) to each row based on predicate functions.\n//\n//      monitor.check() stores statuses in the _level column and writes results to the statuses measurement in the _monitoring bucket.\n//\n// ## Parameters\n// - `crit` is the predicate function that determines crit status. Default is (r) => false.\n// - `warn` is the predicate function that determines warn status. Default is (r) => false.\n// - `info` is the predicate function that determines info status. Default is (r) => false.\n// - `ok` is the predicate function that determines ok status. Default is (r) => false.\n// - `messagefn` is the predicate function that constructs a message to append to each row. The message is stored in the _message column.\n// - `data` is meta data used to identify this check.\n//\n// ## Monitor disk usage\n// ```\n// import \"influxdata/influxdb/monitor\"\n//\n// from(bucket: \"telegraf\")\n//   |> range(start: -1h)\n//   |> filter(fn: (r) =>\n//       r._measurement == \"disk\" and\n//       r._field == \"used_percent\"\n//   )\n//   |> group(columns: [\"_measurement\"])\n//   |> monitor.check(\n//     crit: (r) => r._value > 90.0,\n//     warn: (r) => r._value > 80.0,\n//     info: (r) => r._value > 70.0,\n//     ok:   (r) => r._value <= 60.0,\n//     messageFn: (r) =>\n//       if r._level == \"crit\" then \"Critical alert!! Disk usage is at ${r._value}%!\"\n//       else if r._level == \"warn\" then \"Warning! Disk usage is at ${r._value}%.\"\n//       else if r._level == \"info\" then \"Disk usage is at ${r._value}%.\"\n//       else \"Things are looking good.\",\n//     data: {\n//       _check_name: \"Disk Utilization (Used Percentage)\",\n//       _check_id: \"disk_used_percent\",\n//       _type: \"threshold\",\n//       tags: {}\n//     }\n//   )\n// ```\n//\ncheck = (\n        tables=<-,\n        data,\n        messageFn,\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n) => tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )\n    |> experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )\n    |> write()",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   9,
					},
					File:   "monitor.flux",
					Source: "bucket = \"_monitoring\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "monitor.flux",
						Source: "bucket",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "bucket",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   9,
						},
						File:   "monitor.flux",
						Source: "\"_monitoring\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "_monitoring",
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   12,
						},
						File:   "monitor.flux",
						Source: "write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   12,
							},
							File:   "monitor.flux",
							Source: "write",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Name: "write",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   12,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 16,
								Line:   12,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   12,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   12,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 31,
									Line:   12,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   12,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 57,
											Line:   12,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   12,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 57,
												Line:   12,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   12,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 57,
													Line:   12,
												},
											},
										},
										Name: "bucket",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   12,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 65,
													Line:   12,
												},
											},
										},
										Name: "bucket",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   12,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 41,
										Line:   12,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   12,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 41,
											Line:   12,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   12,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 41,
												Line:   12,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   12,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 54,
												Line:   12,
											},
										},
									},
									Name: "to",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   12,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 17,
									Line:   12,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   12,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 17,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   12,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 24,
									Line:   12,
								},
							},
						}},
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Write persists the check statuses\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 72,
						Line:   12,
					},
					File:   "monitor.flux",
					Source: "option write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   15,
						},
						File:   "monitor.flux",
						Source: "log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   15,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   15,
							},
							File:   "monitor.flux",
							Source: "log",
							Start: ast.Position{
								Column: 8,
								Line:   15,
							},
						},
					},
					Name: "log",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   15,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 14,
								Line:   15,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   15,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   15,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   15,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 29,
									Line:   15,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   15,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 55,
											Line:   15,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   15,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 55,
												Line:   15,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   15,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 55,
													Line:   15,
												},
											},
										},
										Name: "bucket",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   15,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 63,
													Line:   15,
												},
											},
										},
										Name: "bucket",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   15,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 39,
										Line:   15,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   15,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 39,
											Line:   15,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   15,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 39,
												Line:   15,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   15,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 52,
												Line:   15,
											},
										},
									},
									Name: "to",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   15,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 15,
									Line:   15,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   15,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 15,
										Line:   15,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   15,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 22,
									Line:   15,
								},
							},
						}},
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Log records notification events\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   15,
					},
					File:   "monitor.flux",
					Source: "option log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   46,
					},
					File:   "monitor.flux",
					Source: "logs = (start, stop=now(), fn) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// logs retrieves notification events stored in the notifications measurement in the _monitoring bucket.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `start` is the earliest time to include in results\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n"}, ast.Comment{Text: "//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `stop` is the latest time to include in results\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n"}, ast.Comment{Text: "//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `fn` is a single argument predicate function that evaluates true or false.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Records or rows (r) that evaluate to true are included in output tables.\n"}, ast.Comment{Text: "//      Records that evaluate to null or false are not included in output tables.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Query notification events from the last hour\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/monitor\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// monitor.logs(start: -2h, fn: (r) => true)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   42,
						},
						File:   "monitor.flux",
						Source: "logs",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "logs",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   46,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   42,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   42,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 49,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   42,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 49,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   42,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 49,
															Line:   42,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   42,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 57,
															Line:   42,
														},
													},
												},
												Name: "bucket",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   42,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 35,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   42,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 35,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   42,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 35,
														Line:   42,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   42,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 44,
														Line:   42,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   43,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 35,
											Line:   42,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   43,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 14,
													Line:   43,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   43,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 14,
														Line:   43,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   43,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 21,
															Line:   43,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   43,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 28,
														Line:   43,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 28,
															Line:   43,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 34,
															Line:   43,
														},
													},
												},
												Name: "stop",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   43,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 8,
												Line:   43,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   43,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   43,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   44,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")",
									Start: ast.Position{
										Column: 35,
										Line:   42,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   44,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"notifications\"",
											Start: ast.Position{
												Column: 15,
												Line:   44,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   44,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"notifications\"",
												Start: ast.Position{
													Column: 15,
													Line:   44,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   44,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   44,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   44,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"notifications\"",
													Start: ast.Position{
														Column: 19,
														Line:   44,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   44,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"notifications\"",
														Start: ast.Position{
															Column: 26,
															Line:   44,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 26,
																Line:   44,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 26,
																	Line:   44,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 28,
																	Line:   44,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "\"notifications\"",
															Start: ast.Position{
																Column: 44,
																Line:   44,
															},
														},
													},
													Value: "notifications",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   44,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   44,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   44,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   44,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"notifications\")",
										Start: ast.Position{
											Column: 8,
											Line:   44,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   44,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 8,
												Line:   44,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   45,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")\n    |> filter(fn: fn)",
								Start: ast.Position{
									Column: 35,
									Line:   42,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   45,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 15,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   45,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 15,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   45,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 15,
													Line:   45,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   45,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   45,
												},
											},
										},
										Name: "fn",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   45,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   45,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"notifications\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 35,
								Line:   42,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   46,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   46,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   46,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   46,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 11,
											Line:   46,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   42,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   42,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   42,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   42,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   42,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   42,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   42,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   42,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   42,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   42,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "monitor.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 28,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   42,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   42,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   80,
					},
					File:   "monitor.flux",
					Source: "from = (start, stop=now(), fn=(r) => true) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// from retrieves check statuses stored in the statuses measurement in the _monitoring bucket.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `start` is the earliest time to include in results\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n"}, ast.Comment{Text: "//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `stop` is the latest time to include in results\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Use a relative duration, absolute time, or integer (Unix timestamp in seconds).\n"}, ast.Comment{Text: "//      For example, -1h, 2019-08-28T22:00:00Z, or 1567029600. Durations are relative to now().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `fn` is a single argument predicate function that evaluates true or false.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Records or rows (r) that evaluate to true are included in output tables.\n"}, ast.Comment{Text: "//      Records that evaluate to null or false are not included in output tables.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## View critical check statuses from the last hour\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/monitor\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// monitor.from(\n"}, ast.Comment{Text: "//  start: -1h,\n"}, ast.Comment{Text: "//  fn: (r) => r._level == \"crit\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   76,
						},
						File:   "monitor.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   76,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   80,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn=(r) => true) => influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   76,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 61,
													Line:   76,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   76,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 61,
														Line:   76,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   76,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 61,
															Line:   76,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   76,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 69,
															Line:   76,
														},
													},
												},
												Name: "bucket",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   76,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 47,
												Line:   76,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 47,
													Line:   76,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   76,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 47,
														Line:   76,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   76,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 56,
														Line:   76,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   77,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 47,
											Line:   76,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   77,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 14,
													Line:   77,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   77,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 14,
														Line:   77,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   77,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 21,
															Line:   77,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   77,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 28,
														Line:   77,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 28,
															Line:   77,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 34,
															Line:   77,
														},
													},
												},
												Name: "stop",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   77,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 8,
												Line:   77,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   77,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   77,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   78,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")",
									Start: ast.Position{
										Column: 47,
										Line:   76,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   78,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"statuses\"",
											Start: ast.Position{
												Column: 15,
												Line:   78,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   78,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"statuses\"",
												Start: ast.Position{
													Column: 15,
													Line:   78,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   78,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 15,
														Line:   78,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   78,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"statuses\"",
													Start: ast.Position{
														Column: 19,
														Line:   78,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   78,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"statuses\"",
														Start: ast.Position{
															Column: 26,
															Line:   78,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   78,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 26,
																Line:   78,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   78,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 26,
																	Line:   78,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   78,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 28,
																	Line:   78,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   78,
															},
															File:   "monitor.flux",
															Source: "\"statuses\"",
															Start: ast.Position{
																Column: 44,
																Line:   78,
															},
														},
													},
													Value: "statuses",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   78,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   78,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   78,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   78,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   78,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"statuses\")",
										Start: ast.Position{
											Column: 8,
											Line:   78,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   78,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 8,
												Line:   78,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   79,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")\n    |> filter(fn: fn)",
								Start: ast.Position{
									Column: 47,
									Line:   76,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   79,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 15,
											Line:   79,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   79,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 15,
												Line:   79,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 15,
													Line:   79,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   79,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   79,
												},
											},
										},
										Name: "fn",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   79,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 8,
										Line:   79,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   79,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 8,
											Line:   79,
										},
									},
								},
								Name: "filter",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   80,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n    |> range(start: start, stop: stop)\n    |> filter(fn: (r) => r._measurement == \"statuses\")\n    |> filter(fn: fn)\n    |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 47,
								Line:   76,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   80,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 8,
									Line:   80,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   80,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 8,
										Line:   80,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   80,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 8,
											Line:   80,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   80,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 11,
											Line:   80,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   76,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   76,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   76,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   76,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   76,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   76,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   76,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   76,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   76,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   76,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   76,
							},
							File:   "monitor.flux",
							Source: "fn=(r) => true",
							Start: ast.Position{
								Column: 28,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   76,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   76,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   76,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 31,
									Line:   76,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   76,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 38,
										Line:   76,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   76,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 32,
										Line:   76,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   76,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 32,
											Line:   76,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   83,
					},
					File:   "monitor.flux",
					Source: "levelOK = \"ok\"",
					Start: ast.Position{
						Column: 1,
						Line:   83,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// levels describing the result of a check\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   83,
						},
						File:   "monitor.flux",
						Source: "levelOK",
						Start: ast.Position{
							Column: 1,
							Line:   83,
						},
					},
				},
				Name: "levelOK",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   83,
						},
						File:   "monitor.flux",
						Source: "\"ok\"",
						Start: ast.Position{
							Column: 11,
							Line:   83,
						},
					},
				},
				Value: "ok",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   84,
					},
					File:   "monitor.flux",
					Source: "levelInfo = \"info\"",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   84,
						},
						File:   "monitor.flux",
						Source: "levelInfo",
						Start: ast.Position{
							Column: 1,
							Line:   84,
						},
					},
				},
				Name: "levelInfo",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   84,
						},
						File:   "monitor.flux",
						Source: "\"info\"",
						Start: ast.Position{
							Column: 13,
							Line:   84,
						},
					},
				},
				Value: "info",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   85,
					},
					File:   "monitor.flux",
					Source: "levelWarn = \"warn\"",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   85,
						},
						File:   "monitor.flux",
						Source: "levelWarn",
						Start: ast.Position{
							Column: 1,
							Line:   85,
						},
					},
				},
				Name: "levelWarn",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   85,
						},
						File:   "monitor.flux",
						Source: "\"warn\"",
						Start: ast.Position{
							Column: 13,
							Line:   85,
						},
					},
				},
				Value: "warn",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   86,
					},
					File:   "monitor.flux",
					Source: "levelCrit = \"crit\"",
					Start: ast.Position{
						Column: 1,
						Line:   86,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   86,
						},
						File:   "monitor.flux",
						Source: "levelCrit",
						Start: ast.Position{
							Column: 1,
							Line:   86,
						},
					},
				},
				Name: "levelCrit",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   86,
						},
						File:   "monitor.flux",
						Source: "\"crit\"",
						Start: ast.Position{
							Column: 13,
							Line:   86,
						},
					},
				},
				Value: "crit",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   87,
					},
					File:   "monitor.flux",
					Source: "levelUnknown = \"unknown\"",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   87,
						},
						File:   "monitor.flux",
						Source: "levelUnknown",
						Start: ast.Position{
							Column: 1,
							Line:   87,
						},
					},
				},
				Name: "levelUnknown",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   87,
						},
						File:   "monitor.flux",
						Source: "\"unknown\"",
						Start: ast.Position{
							Column: 16,
							Line:   87,
						},
					},
				},
				Value: "unknown",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   117,
					},
					File:   "monitor.flux",
					Source: "_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel\n    fromLevelFilter = if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel\n\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   88,
						},
						File:   "monitor.flux",
						Source: "_stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   88,
						},
					},
				},
				Name: "_stateChanges",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   117,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel\n    fromLevelFilter = if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel\n\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 17,
							Line:   88,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   117,
							},
							File:   "monitor.flux",
							Source: "{\n    toLevelFilter = if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel\n    fromLevelFilter = if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel\n\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 64,
								Line:   88,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   92,
								},
								File:   "monitor.flux",
								Source: "toLevelFilter = if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel",
								Start: ast.Position{
									Column: 5,
									Line:   89,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   89,
									},
									File:   "monitor.flux",
									Source: "toLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   89,
									},
								},
							},
							Name: "toLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   92,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == toLevel",
										Start: ast.Position{
											Column: 9,
											Line:   92,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   92,
											},
											File:   "monitor.flux",
											Source: "r._level == toLevel",
											Start: ast.Position{
												Column: 16,
												Line:   92,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   92,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 16,
													Line:   92,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   92,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   92,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   92,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 18,
														Line:   92,
													},
												},
											},
											Name: "_level",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   92,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 28,
													Line:   92,
												},
											},
										},
										Name: "toLevel",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   92,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   92,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   92,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   92,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   92,
									},
									File:   "monitor.flux",
									Source: "if toLevel == \"any\" then\n        (r) => r._level != fromLevel and exists r._level\n    else\n        (r) => r._level == toLevel",
									Start: ast.Position{
										Column: 21,
										Line:   89,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   90,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != fromLevel and exists r._level",
										Start: ast.Position{
											Column: 9,
											Line:   90,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   90,
											},
											File:   "monitor.flux",
											Source: "r._level != fromLevel and exists r._level",
											Start: ast.Position{
												Column: 16,
												Line:   90,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   90,
												},
												File:   "monitor.flux",
												Source: "r._level != fromLevel",
												Start: ast.Position{
													Column: 16,
													Line:   90,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   90,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 16,
														Line:   90,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   90,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   90,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   90,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 18,
															Line:   90,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   90,
													},
													File:   "monitor.flux",
													Source: "fromLevel",
													Start: ast.Position{
														Column: 28,
														Line:   90,
													},
												},
											},
											Name: "fromLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   90,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 49,
														Line:   90,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   90,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 49,
															Line:   90,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   90,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 51,
															Line:   90,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   90,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 42,
													Line:   90,
												},
											},
										},
										Operator: 14,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   90,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   90,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   90,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   90,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   89,
										},
										File:   "monitor.flux",
										Source: "toLevel == \"any\"",
										Start: ast.Position{
											Column: 24,
											Line:   89,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   89,
											},
											File:   "monitor.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 24,
												Line:   89,
											},
										},
									},
									Name: "toLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   89,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 35,
												Line:   89,
											},
										},
									},
									Value: "any",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   96,
								},
								File:   "monitor.flux",
								Source: "fromLevelFilter = if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel",
								Start: ast.Position{
									Column: 5,
									Line:   93,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   93,
									},
									File:   "monitor.flux",
									Source: "fromLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   93,
									},
								},
							},
							Name: "fromLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   96,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == fromLevel",
										Start: ast.Position{
											Column: 9,
											Line:   96,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   96,
											},
											File:   "monitor.flux",
											Source: "r._level == fromLevel",
											Start: ast.Position{
												Column: 16,
												Line:   96,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   96,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 16,
													Line:   96,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   96,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   96,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   96,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 18,
														Line:   96,
													},
												},
											},
											Name: "_level",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   96,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 28,
													Line:   96,
												},
											},
										},
										Name: "fromLevel",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   96,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   96,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   96,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   96,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   96,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" then\n        (r) => r._level != toLevel and exists r._level\n    else\n        (r) => r._level == fromLevel",
									Start: ast.Position{
										Column: 23,
										Line:   93,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   94,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != toLevel and exists r._level",
										Start: ast.Position{
											Column: 9,
											Line:   94,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "r._level != toLevel and exists r._level",
											Start: ast.Position{
												Column: 16,
												Line:   94,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "r._level != toLevel",
												Start: ast.Position{
													Column: 16,
													Line:   94,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   94,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 16,
														Line:   94,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   94,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   94,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   94,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 18,
															Line:   94,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   94,
													},
													File:   "monitor.flux",
													Source: "toLevel",
													Start: ast.Position{
														Column: 28,
														Line:   94,
													},
												},
											},
											Name: "toLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   94,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 47,
														Line:   94,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   94,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 47,
															Line:   94,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   94,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 49,
															Line:   94,
														},
													},
												},
												Name: "_level",
											},
											Rbrack: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 40,
													Line:   94,
												},
											},
										},
										Operator: 14,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   94,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   94,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   94,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   94,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   93,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\"",
										Start: ast.Position{
											Column: 26,
											Line:   93,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   93,
											},
											File:   "monitor.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 26,
												Line:   93,
											},
										},
									},
									Name: "fromLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   93,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 39,
												Line:   93,
											},
										},
									},
									Value: "any",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   98,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   98,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 10,
																		Line:   108,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )",
																	Start: ast.Position{
																		Column: 12,
																		Line:   98,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   107,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            })",
																			Start: ast.Position{
																				Column: 13,
																				Line:   100,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 15,
																					Line:   107,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            })",
																				Start: ast.Position{
																					Column: 13,
																					Line:   100,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   100,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 13,
																						Line:   100,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Separator: nil,
																		Value: &ast.FunctionExpression{
																			Arrow: nil,
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   107,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            })",
																					Start: ast.Position{
																						Column: 17,
																						Line:   100,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 15,
																							Line:   107,
																						},
																						File:   "monitor.flux",
																						Source: "({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            })",
																						Start: ast.Position{
																							Column: 24,
																							Line:   100,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 14,
																								Line:   107,
																							},
																							File:   "monitor.flux",
																							Source: "{r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }",
																							Start: ast.Position{
																								Column: 25,
																								Line:   100,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 24,
																									Line:   106,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10",
																								Start: ast.Position{
																									Column: 17,
																									Line:   101,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 28,
																										Line:   101,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 17,
																										Line:   101,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Separator: nil,
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.UnaryExpression{
																									Argument: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 24,
																													Line:   106,
																												},
																												File:   "monitor.flux",
																												Source: "10",
																												Start: ast.Position{
																													Column: 22,
																													Line:   106,
																												},
																											},
																										},
																										Value: int64(10),
																									},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 24,
																												Line:   106,
																											},
																											File:   "monitor.flux",
																											Source: "-10",
																											Start: ast.Position{
																												Column: 21,
																												Line:   106,
																											},
																										},
																									},
																									Operator: 6,
																								},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 24,
																											Line:   106,
																										},
																										File:   "monitor.flux",
																										Source: "if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10",
																										Start: ast.Position{
																											Column: 22,
																											Line:   103,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 22,
																												Line:   104,
																											},
																											File:   "monitor.flux",
																											Source: "0",
																											Start: ast.Position{
																												Column: 21,
																												Line:   104,
																											},
																										},
																									},
																									Value: int64(0),
																								},
																								Test: &ast.CallExpression{
																									Arguments: []ast.Expression{&ast.ObjectExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   103,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 41,
																													Line:   103,
																												},
																											},
																										},
																										Lbrace: nil,
																										Properties: []*ast.Property{&ast.Property{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 45,
																														Line:   103,
																													},
																													File:   "monitor.flux",
																													Source: "r: r",
																													Start: ast.Position{
																														Column: 41,
																														Line:   103,
																													},
																												},
																											},
																											Comma: nil,
																											Key: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 42,
																															Line:   103,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 41,
																															Line:   103,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Separator: nil,
																											Value: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 45,
																															Line:   103,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 44,
																															Line:   103,
																														},
																													},
																												},
																												Name: "r",
																											},
																										}},
																										Rbrace: nil,
																										With:   nil,
																									}},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 46,
																												Line:   103,
																											},
																											File:   "monitor.flux",
																											Source: "fromLevelFilter(r: r)",
																											Start: ast.Position{
																												Column: 25,
																												Line:   103,
																											},
																										},
																									},
																									Callee: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 40,
																													Line:   103,
																												},
																												File:   "monitor.flux",
																												Source: "fromLevelFilter",
																												Start: ast.Position{
																													Column: 25,
																													Line:   103,
																												},
																											},
																										},
																										Name: "fromLevelFilter",
																									},
																									Lparen: nil,
																									Rparen: nil,
																								},
																								Tk_else: nil,
																								Tk_if:   nil,
																								Tk_then: nil,
																							},
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 24,
																										Line:   106,
																									},
																									File:   "monitor.flux",
																									Source: "if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10",
																									Start: ast.Position{
																										Column: 30,
																										Line:   101,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 22,
																											Line:   102,
																										},
																										File:   "monitor.flux",
																										Source: "1",
																										Start: ast.Position{
																											Column: 21,
																											Line:   102,
																										},
																									},
																								},
																								Value: int64(1),
																							},
																							Test: &ast.CallExpression{
																								Arguments: []ast.Expression{&ast.ObjectExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   101,
																											},
																											File:   "monitor.flux",
																											Source: "r: r",
																											Start: ast.Position{
																												Column: 47,
																												Line:   101,
																											},
																										},
																									},
																									Lbrace: nil,
																									Properties: []*ast.Property{&ast.Property{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 51,
																													Line:   101,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 47,
																													Line:   101,
																												},
																											},
																										},
																										Comma: nil,
																										Key: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 48,
																														Line:   101,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 47,
																														Line:   101,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Separator: nil,
																										Value: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 51,
																														Line:   101,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 50,
																														Line:   101,
																													},
																												},
																											},
																											Name: "r",
																										},
																									}},
																									Rbrace: nil,
																									With:   nil,
																								}},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 52,
																											Line:   101,
																										},
																										File:   "monitor.flux",
																										Source: "toLevelFilter(r: r)",
																										Start: ast.Position{
																											Column: 33,
																											Line:   101,
																										},
																									},
																								},
																								Callee: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 46,
																												Line:   101,
																											},
																											File:   "monitor.flux",
																											Source: "toLevelFilter",
																											Start: ast.Position{
																												Column: 33,
																												Line:   101,
																											},
																										},
																									},
																									Name: "toLevelFilter",
																								},
																								Lparen: nil,
																								Rparen: nil,
																							},
																							Tk_else: nil,
																							Tk_if:   nil,
																							Tk_then: nil,
																						},
																					}},
																					Rbrace: nil,
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 27,
																									Line:   100,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 26,
																									Line:   100,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Lparen: nil,
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 19,
																							Line:   100,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 18,
																							Line:   100,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 19,
																								Line:   100,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 18,
																								Line:   100,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value:     nil,
																			}},
																			Rparan: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 10,
																			Line:   108,
																		},
																		File:   "monitor.flux",
																		Source: "map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )",
																		Start: ast.Position{
																			Column: 12,
																			Line:   99,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   99,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   99,
																			},
																		},
																	},
																	Name: "map",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   109,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   98,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   109,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   109,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   109,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   109,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   109,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   109,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   109,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   109,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   109,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   109,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   109,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   109,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   109,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   109,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   109,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   109,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   109,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   109,
																		},
																	},
																},
																Name: "duplicate",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   110,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   98,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   110,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   110,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   110,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   110,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   110,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   110,
																			},
																		},
																	},
																	Name: "columns",
																},
																Separator: nil,
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   110,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   110,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   110,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   110,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   110,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   110,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   110,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   110,
																	},
																},
															},
															Name: "drop",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   111,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   98,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   111,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   111,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   111,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   111,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   111,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   111,
																		},
																	},
																},
																Name: "columns",
															},
															Separator: nil,
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   111,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   111,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   111,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   111,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   111,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   111,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   111,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   111,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   111,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   111,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   111,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   111,
																},
															},
														},
														Name: "rename",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   112,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   98,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   112,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_source_timestamp\", \"_time\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   112,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   112,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_source_timestamp\", \"_time\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   112,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   112,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   112,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   112,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_source_timestamp\", \"_time\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   112,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   112,
																		},
																		File:   "monitor.flux",
																		Source: "\"_source_timestamp\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   112,
																		},
																	},
																},
																Value: "_source_timestamp",
															}, &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   112,
																		},
																		File:   "monitor.flux",
																		Source: "\"_time\"",
																		Start: ast.Position{
																			Column: 48,
																			Line:   112,
																		},
																	},
																},
																Value: "_time",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   112,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 58,
																	Line:   112,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   112,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 58,
																		Line:   112,
																	},
																},
															},
															Name: "desc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   112,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 64,
																		Line:   112,
																	},
																},
															},
															Name: "false",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   112,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   112,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   112,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   112,
															},
														},
													},
													Name: "sort",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   113,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   98,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   113,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   113,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   113,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   113,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   113,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   113,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   113,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   113,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   113,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   113,
																	},
																},
															},
															Value: "level_value",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   113,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   113,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   113,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   113,
														},
													},
												},
												Name: "difference",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   114,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)",
											Start: ast.Position{
												Column: 12,
												Line:   98,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   114,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value == 1",
													Start: ast.Position{
														Column: 19,
														Line:   114,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   114,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value == 1",
														Start: ast.Position{
															Column: 19,
															Line:   114,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   114,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   114,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   114,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value == 1",
															Start: ast.Position{
																Column: 23,
																Line:   114,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   114,
																},
																File:   "monitor.flux",
																Source: "r.level_value == 1",
																Start: ast.Position{
																	Column: 30,
																	Line:   114,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   114,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   114,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   114,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   114,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   114,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   114,
																		},
																	},
																},
																Name: "level_value",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   114,
																	},
																	File:   "monitor.flux",
																	Source: "1",
																	Start: ast.Position{
																		Column: 47,
																		Line:   114,
																	},
																},
															},
															Value: int64(1),
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   114,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   114,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   114,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   114,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   114,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value == 1)",
												Start: ast.Position{
													Column: 12,
													Line:   114,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   114,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   114,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   115,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   98,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   115,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   115,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   115,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   115,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   115,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   115,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   115,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   115,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   115,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   115,
															},
														},
													},
													Value: "level_value",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   115,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   115,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   115,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   115,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   116,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   98,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   116,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   116,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   116,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   116,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   116,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   116,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   116,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   116,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   116,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   116,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   116,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   116,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   116,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   116,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   116,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   116,
														},
													},
												},
												Value: "_level",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   116,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   116,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   116,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   116,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   116,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   116,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   116,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   116,
												},
											},
										},
										Name: "group",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   116,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if toLevelFilter(r: r) then\n                    1\n                else if fromLevelFilter(r: r) then\n                    0\n                else\n                    -10,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   98,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   88,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 18,
								Line:   88,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   88,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 18,
									Line:   88,
								},
							},
						},
						Name: "fromLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   88,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 28,
									Line:   88,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   88,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 35,
								Line:   88,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   88,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 35,
									Line:   88,
								},
							},
						},
						Name: "toLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   88,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 43,
									Line:   88,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   88,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 50,
								Line:   88,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   88,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 50,
									Line:   88,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   88,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 57,
								Line:   88,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   132,
					},
					File:   "monitor.flux",
					Source: "notify = (tables=<-, endpoint, data) => tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n    |> log()",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Notify will call the endpoint and log the results.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   120,
						},
						File:   "monitor.flux",
						Source: "notify",
						Start: ast.Position{
							Column: 1,
							Line:   120,
						},
					},
				},
				Name: "notify",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   132,
						},
						File:   "monitor.flux",
						Source: "(tables=<-, endpoint, data) => tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n    |> log()",
						Start: ast.Position{
							Column: 10,
							Line:   120,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   120,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   120,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   121,
												},
												File:   "monitor.flux",
												Source: "tables\n    |> experimental.set(o: data)",
												Start: ast.Position{
													Column: 41,
													Line:   120,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   121,
														},
														File:   "monitor.flux",
														Source: "o: data",
														Start: ast.Position{
															Column: 25,
															Line:   121,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "o: data",
															Start: ast.Position{
																Column: 25,
																Line:   121,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   121,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 25,
																	Line:   121,
																},
															},
														},
														Name: "o",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   121,
																},
																File:   "monitor.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 28,
																	Line:   121,
																},
															},
														},
														Name: "data",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   121,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data)",
													Start: ast.Position{
														Column: 8,
														Line:   121,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   121,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 8,
															Line:   121,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 8,
																Line:   121,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 21,
																Line:   121,
															},
														},
													},
													Name: "set",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   122,
											},
											File:   "monitor.flux",
											Source: "tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
											Start: ast.Position{
												Column: 41,
												Line:   120,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   122,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data)",
													Start: ast.Position{
														Column: 27,
														Line:   122,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 27,
															Line:   122,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 27,
																Line:   122,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 33,
																Line:   122,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data)",
														Start: ast.Position{
															Column: 43,
															Line:   122,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 43,
																Line:   122,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 83,
																	Line:   122,
																},
																File:   "monitor.flux",
																Source: "o: data",
																Start: ast.Position{
																	Column: 76,
																	Line:   122,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "o: data",
																	Start: ast.Position{
																		Column: 76,
																		Line:   122,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   122,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 76,
																			Line:   122,
																		},
																	},
																},
																Name: "o",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   122,
																		},
																		File:   "monitor.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 79,
																			Line:   122,
																		},
																	},
																},
																Name: "data",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data)",
															Start: ast.Position{
																Column: 52,
																Line:   122,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   122,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 52,
																	Line:   122,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 52,
																		Line:   122,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 65,
																		Line:   122,
																	},
																},
															},
															Name: "objectKeys",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   122,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
												Start: ast.Position{
													Column: 8,
													Line:   122,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   122,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 8,
														Line:   122,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 8,
															Line:   122,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 21,
															Line:   122,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   129,
										},
										File:   "monitor.flux",
										Source: "tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )",
										Start: ast.Position{
											Column: 41,
											Line:   120,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   128,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 9,
													Line:   124,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   128,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 9,
														Line:   124,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   124,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 9,
															Line:   124,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   128,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 13,
															Line:   124,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   128,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 20,
																Line:   124,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   128,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 21,
																	Line:   124,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   125,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"notifications\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   125,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   125,
																		},
																	},
																},
																Name: "_measurement",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "\"notifications\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   125,
																		},
																	},
																},
																Value: "notifications",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   126,
																	},
																	File:   "monitor.flux",
																	Source: "_status_timestamp: int(v: r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   126,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   126,
																		},
																		File:   "monitor.flux",
																		Source: "_status_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   126,
																		},
																	},
																},
																Name: "_status_timestamp",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   126,
																			},
																			File:   "monitor.flux",
																			Source: "v: r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   126,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   126,
																				},
																				File:   "monitor.flux",
																				Source: "v: r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   126,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   126,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   126,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   126,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 39,
																						Line:   126,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   126,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 39,
																							Line:   126,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   126,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 41,
																							Line:   126,
																						},
																					},
																				},
																				Name: "_time",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   126,
																		},
																		File:   "monitor.flux",
																		Source: "int(v: r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   126,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   126,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   126,
																			},
																		},
																	},
																	Name: "int",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   127,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   127,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   127,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   127,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   127,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   127,
																			},
																		},
																	},
																	Name: "now",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   124,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 22,
																		Line:   124,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   124,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   124,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   124,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   124,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   129,
											},
											File:   "monitor.flux",
											Source: "map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   123,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   123,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   123,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   130,
									},
									File:   "monitor.flux",
									Source: "tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()",
									Start: ast.Position{
										Column: 41,
										Line:   120,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   130,
										},
										File:   "monitor.flux",
										Source: "endpoint()",
										Start: ast.Position{
											Column: 8,
											Line:   130,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   130,
											},
											File:   "monitor.flux",
											Source: "endpoint",
											Start: ast.Position{
												Column: 8,
												Line:   130,
											},
										},
									},
									Name: "endpoint",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   131,
								},
								File:   "monitor.flux",
								Source: "tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
								Start: ast.Position{
									Column: 41,
									Line:   120,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   131,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\", columns: [\"_sent\"]",
										Start: ast.Position{
											Column: 27,
											Line:   131,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   131,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 27,
												Line:   131,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   131,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 27,
													Line:   131,
												},
											},
										},
										Name: "mode",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   131,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 33,
													Line:   131,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   131,
											},
											File:   "monitor.flux",
											Source: "columns: [\"_sent\"]",
											Start: ast.Position{
												Column: 43,
												Line:   131,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   131,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 43,
													Line:   131,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   131,
												},
												File:   "monitor.flux",
												Source: "[\"_sent\"]",
												Start: ast.Position{
													Column: 52,
													Line:   131,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   131,
													},
													File:   "monitor.flux",
													Source: "\"_sent\"",
													Start: ast.Position{
														Column: 53,
														Line:   131,
													},
												},
											},
											Value: "_sent",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   131,
									},
									File:   "monitor.flux",
									Source: "experimental.group(mode: \"extend\", columns: [\"_sent\"])",
									Start: ast.Position{
										Column: 8,
										Line:   131,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   131,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 8,
											Line:   131,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   131,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 8,
												Line:   131,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   131,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 21,
												Line:   131,
											},
										},
									},
									Name: "group",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   132,
							},
							File:   "monitor.flux",
							Source: "tables\n    |> experimental.set(o: data)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> endpoint()\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n    |> log()",
							Start: ast.Position{
								Column: 41,
								Line:   120,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   132,
								},
								File:   "monitor.flux",
								Source: "log()",
								Start: ast.Position{
									Column: 8,
									Line:   132,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   132,
									},
									File:   "monitor.flux",
									Source: "log",
									Start: ast.Position{
										Column: 8,
										Line:   132,
									},
								},
							},
							Name: "log",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   120,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   120,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   120,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   120,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   120,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   120,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   120,
							},
							File:   "monitor.flux",
							Source: "endpoint",
							Start: ast.Position{
								Column: 22,
								Line:   120,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   120,
								},
								File:   "monitor.flux",
								Source: "endpoint",
								Start: ast.Position{
									Column: 22,
									Line:   120,
								},
							},
						},
						Name: "endpoint",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   120,
							},
							File:   "monitor.flux",
							Source: "data",
							Start: ast.Position{
								Column: 32,
								Line:   120,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   120,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 32,
									Line:   120,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   170,
					},
					File:   "monitor.flux",
					Source: "stateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   146,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateChangesOnly takes a stream of tables that contains a _level column\n"}, ast.Comment{Text: "// and returns a stream of tables where each record represents a state change.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return records representing state changes\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/monitor\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// monitor.from(start: -1h)\n"}, ast.Comment{Text: "//  |> monitor.stateChangesOnly()\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   146,
						},
						File:   "monitor.flux",
						Source: "stateChangesOnly",
						Start: ast.Position{
							Column: 1,
							Line:   146,
						},
					},
				},
				Name: "stateChangesOnly",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   170,
						},
						File:   "monitor.flux",
						Source: "(tables=<-) => {\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 20,
							Line:   146,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   170,
							},
							File:   "monitor.flux",
							Source: "{\n    return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 35,
								Line:   146,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   147,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   147,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 10,
																		Line:   161,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )",
																	Start: ast.Position{
																		Column: 12,
																		Line:   147,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   160,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            })",
																			Start: ast.Position{
																				Column: 13,
																				Line:   149,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 15,
																					Line:   160,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            })",
																				Start: ast.Position{
																					Column: 13,
																					Line:   149,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   149,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 13,
																						Line:   149,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Separator: nil,
																		Value: &ast.FunctionExpression{
																			Arrow: nil,
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 15,
																						Line:   160,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            })",
																					Start: ast.Position{
																						Column: 17,
																						Line:   149,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 15,
																							Line:   160,
																						},
																						File:   "monitor.flux",
																						Source: "({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            })",
																						Start: ast.Position{
																							Column: 24,
																							Line:   149,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 14,
																								Line:   160,
																							},
																							File:   "monitor.flux",
																							Source: "{r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }",
																							Start: ast.Position{
																								Column: 25,
																								Line:   149,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 22,
																									Line:   159,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0",
																								Start: ast.Position{
																									Column: 17,
																									Line:   150,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 28,
																										Line:   150,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 17,
																										Line:   150,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Separator: nil,
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.ConditionalExpression{
																									Alternate: &ast.ConditionalExpression{
																										Alternate: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 22,
																														Line:   159,
																													},
																													File:   "monitor.flux",
																													Source: "0",
																													Start: ast.Position{
																														Column: 21,
																														Line:   159,
																													},
																												},
																											},
																											Value: int64(0),
																										},
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 22,
																													Line:   159,
																												},
																												File:   "monitor.flux",
																												Source: "if r._level == levelOK then\n                    1\n                else\n                    0",
																												Start: ast.Position{
																													Column: 22,
																													Line:   156,
																												},
																											},
																										},
																										Consequent: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 22,
																														Line:   157,
																													},
																													File:   "monitor.flux",
																													Source: "1",
																													Start: ast.Position{
																														Column: 21,
																														Line:   157,
																													},
																												},
																											},
																											Value: int64(1),
																										},
																										Test: &ast.BinaryExpression{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 44,
																														Line:   156,
																													},
																													File:   "monitor.flux",
																													Source: "r._level == levelOK",
																													Start: ast.Position{
																														Column: 25,
																														Line:   156,
																													},
																												},
																											},
																											Left: &ast.MemberExpression{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 33,
																															Line:   156,
																														},
																														File:   "monitor.flux",
																														Source: "r._level",
																														Start: ast.Position{
																															Column: 25,
																															Line:   156,
																														},
																													},
																												},
																												Lbrack: nil,
																												Object: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Comments: nil,
																														Errors:   nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 26,
																																Line:   156,
																															},
																															File:   "monitor.flux",
																															Source: "r",
																															Start: ast.Position{
																																Column: 25,
																																Line:   156,
																															},
																														},
																													},
																													Name: "r",
																												},
																												Property: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Comments: nil,
																														Errors:   nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 33,
																																Line:   156,
																															},
																															File:   "monitor.flux",
																															Source: "_level",
																															Start: ast.Position{
																																Column: 27,
																																Line:   156,
																															},
																														},
																													},
																													Name: "_level",
																												},
																												Rbrack: nil,
																											},
																											Operator: 17,
																											Right: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 44,
																															Line:   156,
																														},
																														File:   "monitor.flux",
																														Source: "levelOK",
																														Start: ast.Position{
																															Column: 37,
																															Line:   156,
																														},
																													},
																												},
																												Name: "levelOK",
																											},
																										},
																										Tk_else: nil,
																										Tk_if:   nil,
																										Tk_then: nil,
																									},
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 22,
																												Line:   159,
																											},
																											File:   "monitor.flux",
																											Source: "if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0",
																											Start: ast.Position{
																												Column: 22,
																												Line:   154,
																											},
																										},
																									},
																									Consequent: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 22,
																													Line:   155,
																												},
																												File:   "monitor.flux",
																												Source: "2",
																												Start: ast.Position{
																													Column: 21,
																													Line:   155,
																												},
																											},
																										},
																										Value: int64(2),
																									},
																									Test: &ast.BinaryExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 46,
																													Line:   154,
																												},
																												File:   "monitor.flux",
																												Source: "r._level == levelInfo",
																												Start: ast.Position{
																													Column: 25,
																													Line:   154,
																												},
																											},
																										},
																										Left: &ast.MemberExpression{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 33,
																														Line:   154,
																													},
																													File:   "monitor.flux",
																													Source: "r._level",
																													Start: ast.Position{
																														Column: 25,
																														Line:   154,
																													},
																												},
																											},
																											Lbrack: nil,
																											Object: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 26,
																															Line:   154,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 25,
																															Line:   154,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Property: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Comments: nil,
																													Errors:   nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 33,
																															Line:   154,
																														},
																														File:   "monitor.flux",
																														Source: "_level",
																														Start: ast.Position{
																															Column: 27,
																															Line:   154,
																														},
																													},
																												},
																												Name: "_level",
																											},
																											Rbrack: nil,
																										},
																										Operator: 17,
																										Right: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 46,
																														Line:   154,
																													},
																													File:   "monitor.flux",
																													Source: "levelInfo",
																													Start: ast.Position{
																														Column: 37,
																														Line:   154,
																													},
																												},
																											},
																											Name: "levelInfo",
																										},
																									},
																									Tk_else: nil,
																									Tk_if:   nil,
																									Tk_then: nil,
																								},
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 22,
																											Line:   159,
																										},
																										File:   "monitor.flux",
																										Source: "if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0",
																										Start: ast.Position{
																											Column: 22,
																											Line:   152,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 22,
																												Line:   153,
																											},
																											File:   "monitor.flux",
																											Source: "3",
																											Start: ast.Position{
																												Column: 21,
																												Line:   153,
																											},
																										},
																									},
																									Value: int64(3),
																								},
																								Test: &ast.BinaryExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 46,
																												Line:   152,
																											},
																											File:   "monitor.flux",
																											Source: "r._level == levelWarn",
																											Start: ast.Position{
																												Column: 25,
																												Line:   152,
																											},
																										},
																									},
																									Left: &ast.MemberExpression{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 33,
																													Line:   152,
																												},
																												File:   "monitor.flux",
																												Source: "r._level",
																												Start: ast.Position{
																													Column: 25,
																													Line:   152,
																												},
																											},
																										},
																										Lbrack: nil,
																										Object: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 26,
																														Line:   152,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 25,
																														Line:   152,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Property: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Comments: nil,
																												Errors:   nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 33,
																														Line:   152,
																													},
																													File:   "monitor.flux",
																													Source: "_level",
																													Start: ast.Position{
																														Column: 27,
																														Line:   152,
																													},
																												},
																											},
																											Name: "_level",
																										},
																										Rbrack: nil,
																									},
																									Operator: 17,
																									Right: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 46,
																													Line:   152,
																												},
																												File:   "monitor.flux",
																												Source: "levelWarn",
																												Start: ast.Position{
																													Column: 37,
																													Line:   152,
																												},
																											},
																										},
																										Name: "levelWarn",
																									},
																								},
																								Tk_else: nil,
																								Tk_if:   nil,
																								Tk_then: nil,
																							},
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 22,
																										Line:   159,
																									},
																									File:   "monitor.flux",
																									Source: "if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0",
																									Start: ast.Position{
																										Column: 30,
																										Line:   150,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 22,
																											Line:   151,
																										},
																										File:   "monitor.flux",
																										Source: "4",
																										Start: ast.Position{
																											Column: 21,
																											Line:   151,
																										},
																									},
																								},
																								Value: int64(4),
																							},
																							Test: &ast.BinaryExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 54,
																											Line:   150,
																										},
																										File:   "monitor.flux",
																										Source: "r._level == levelCrit",
																										Start: ast.Position{
																											Column: 33,
																											Line:   150,
																										},
																									},
																								},
																								Left: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   150,
																											},
																											File:   "monitor.flux",
																											Source: "r._level",
																											Start: ast.Position{
																												Column: 33,
																												Line:   150,
																											},
																										},
																									},
																									Lbrack: nil,
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 34,
																													Line:   150,
																												},
																												File:   "monitor.flux",
																												Source: "r",
																												Start: ast.Position{
																													Column: 33,
																													Line:   150,
																												},
																											},
																										},
																										Name: "r",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Comments: nil,
																											Errors:   nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 41,
																													Line:   150,
																												},
																												File:   "monitor.flux",
																												Source: "_level",
																												Start: ast.Position{
																													Column: 35,
																													Line:   150,
																												},
																											},
																										},
																										Name: "_level",
																									},
																									Rbrack: nil,
																								},
																								Operator: 17,
																								Right: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 54,
																												Line:   150,
																											},
																											File:   "monitor.flux",
																											Source: "levelCrit",
																											Start: ast.Position{
																												Column: 45,
																												Line:   150,
																											},
																										},
																									},
																									Name: "levelCrit",
																								},
																							},
																							Tk_else: nil,
																							Tk_if:   nil,
																							Tk_then: nil,
																						},
																					}},
																					Rbrace: nil,
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 27,
																									Line:   149,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 26,
																									Line:   149,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Lparen: nil,
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 19,
																							Line:   149,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 18,
																							Line:   149,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 19,
																								Line:   149,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 18,
																								Line:   149,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value:     nil,
																			}},
																			Rparan: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 10,
																			Line:   161,
																		},
																		File:   "monitor.flux",
																		Source: "map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )",
																		Start: ast.Position{
																			Column: 12,
																			Line:   148,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   148,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   148,
																			},
																		},
																	},
																	Name: "map",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   162,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   147,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   162,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   162,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   162,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   162,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   162,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   162,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   162,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   162,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   162,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   162,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   162,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   162,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   162,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   162,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   162,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   162,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   162,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   162,
																		},
																	},
																},
																Name: "duplicate",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   163,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   147,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   163,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   163,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   163,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   163,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   163,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   163,
																			},
																		},
																	},
																	Name: "columns",
																},
																Separator: nil,
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   163,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   163,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   163,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   163,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   163,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   163,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   163,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   163,
																	},
																},
															},
															Name: "drop",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   164,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   147,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   164,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   164,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   164,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   164,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   164,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   164,
																		},
																	},
																},
																Name: "columns",
															},
															Separator: nil,
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   164,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   164,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   164,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   164,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   164,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   164,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   164,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   164,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   164,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   164,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   164,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   164,
																},
															},
														},
														Name: "rename",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   165,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   147,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   165,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_source_timestamp\", \"_time\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   165,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   165,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_source_timestamp\", \"_time\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   165,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   165,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   165,
																	},
																},
															},
															Name: "columns",
														},
														Separator: nil,
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   165,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_source_timestamp\", \"_time\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   165,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   165,
																		},
																		File:   "monitor.flux",
																		Source: "\"_source_timestamp\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   165,
																		},
																	},
																},
																Value: "_source_timestamp",
															}, &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   165,
																		},
																		File:   "monitor.flux",
																		Source: "\"_time\"",
																		Start: ast.Position{
																			Column: 48,
																			Line:   165,
																		},
																	},
																},
																Value: "_time",
															}},
															Lbrack: nil,
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   165,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 58,
																	Line:   165,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   165,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 58,
																		Line:   165,
																	},
																},
															},
															Name: "desc",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   165,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 64,
																		Line:   165,
																	},
																},
															},
															Name: "false",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   165,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   165,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   165,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   165,
															},
														},
													},
													Name: "sort",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   166,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   147,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   166,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   166,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   166,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   166,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   166,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   166,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   166,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   166,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   166,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   166,
																	},
																},
															},
															Value: "level_value",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   166,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   166,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   166,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   166,
														},
													},
												},
												Name: "difference",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   167,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)",
											Start: ast.Position{
												Column: 12,
												Line:   147,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   167,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value != 0",
													Start: ast.Position{
														Column: 19,
														Line:   167,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   167,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value != 0",
														Start: ast.Position{
															Column: 19,
															Line:   167,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   167,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   167,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   167,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value != 0",
															Start: ast.Position{
																Column: 23,
																Line:   167,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   167,
																},
																File:   "monitor.flux",
																Source: "r.level_value != 0",
																Start: ast.Position{
																	Column: 30,
																	Line:   167,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   167,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   167,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   167,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   167,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   167,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   167,
																		},
																	},
																},
																Name: "level_value",
															},
															Rbrack: nil,
														},
														Operator: 18,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   167,
																	},
																	File:   "monitor.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 47,
																		Line:   167,
																	},
																},
															},
															Value: int64(0),
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   167,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   167,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   167,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   167,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   167,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value != 0)",
												Start: ast.Position{
													Column: 12,
													Line:   167,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   167,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   167,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   168,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   147,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   168,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   168,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   168,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   168,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   168,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   168,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   168,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   168,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   168,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   168,
															},
														},
													},
													Value: "level_value",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   168,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   168,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   168,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   168,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   169,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   147,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   169,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   169,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   169,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   169,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   169,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   169,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   169,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   169,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   169,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   169,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   169,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   169,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   169,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   169,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   169,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   169,
														},
													},
												},
												Value: "_level",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   169,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   169,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   169,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   169,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   169,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   169,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   169,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   169,
												},
											},
										},
										Name: "group",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   169,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(\n            fn: (r) => ({r with\n                level_value: if r._level == levelCrit then\n                    4\n                else if r._level == levelWarn then\n                    3\n                else if r._level == levelInfo then\n                    2\n                else if r._level == levelOK then\n                    1\n                else\n                    0,\n            }),\n        )\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_source_timestamp\", \"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   147,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   146,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   146,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   146,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   146,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   146,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   146,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   189,
					},
					File:   "monitor.flux",
					Source: "stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   184,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateChanges detects state changes in a stream of data with a _level column and outputs records that change from fromLevel to toLevel.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `fromLevel` is the level to detect a change from. Defaults to \"any\".\n"}, ast.Comment{Text: "// - `toLevel` is the level to detect a change to. The function output records that change to this level\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Detect when the state changes to critical\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// monitor.from(start: -1h)\n"}, ast.Comment{Text: "//    |> monitor.stateChanges(toLevel: \"crit\")\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   184,
						},
						File:   "monitor.flux",
						Source: "stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   184,
						},
					},
				},
				Name: "stateChanges",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   189,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
						Start: ast.Position{
							Column: 16,
							Line:   184,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   189,
							},
							File:   "monitor.flux",
							Source: "{\n    return if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
							Start: ast.Position{
								Column: 63,
								Line:   184,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   188,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   188,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   188,
										},
										File:   "monitor.flux",
										Source: "tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
										Start: ast.Position{
											Column: 9,
											Line:   188,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   188,
												},
												File:   "monitor.flux",
												Source: "fromLevel: fromLevel, toLevel: toLevel",
												Start: ast.Position{
													Column: 33,
													Line:   188,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   188,
													},
													File:   "monitor.flux",
													Source: "fromLevel: fromLevel",
													Start: ast.Position{
														Column: 33,
														Line:   188,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   188,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 33,
															Line:   188,
														},
													},
												},
												Name: "fromLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   188,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 44,
															Line:   188,
														},
													},
												},
												Name: "fromLevel",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   188,
													},
													File:   "monitor.flux",
													Source: "toLevel: toLevel",
													Start: ast.Position{
														Column: 55,
														Line:   188,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   188,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 55,
															Line:   188,
														},
													},
												},
												Name: "toLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   188,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 64,
															Line:   188,
														},
													},
												},
												Name: "toLevel",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   188,
											},
											File:   "monitor.flux",
											Source: "_stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
											Start: ast.Position{
												Column: 19,
												Line:   188,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   188,
												},
												File:   "monitor.flux",
												Source: "_stateChanges",
												Start: ast.Position{
													Column: 19,
													Line:   188,
												},
											},
										},
										Name: "_stateChanges",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   188,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
									Start: ast.Position{
										Column: 12,
										Line:   185,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   186,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   186,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   186,
										},
										File:   "monitor.flux",
										Source: "tables |> stateChangesOnly()",
										Start: ast.Position{
											Column: 9,
											Line:   186,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   186,
											},
											File:   "monitor.flux",
											Source: "stateChangesOnly()",
											Start: ast.Position{
												Column: 19,
												Line:   186,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   186,
												},
												File:   "monitor.flux",
												Source: "stateChangesOnly",
												Start: ast.Position{
													Column: 19,
													Line:   186,
												},
											},
										},
										Name: "stateChangesOnly",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.LogicalExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   185,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\" and toLevel == \"any\"",
										Start: ast.Position{
											Column: 15,
											Line:   185,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   185,
											},
											File:   "monitor.flux",
											Source: "fromLevel == \"any\"",
											Start: ast.Position{
												Column: 15,
												Line:   185,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   185,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 15,
													Line:   185,
												},
											},
										},
										Name: "fromLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   185,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 28,
													Line:   185,
												},
											},
										},
										Value: "any",
									},
								},
								Operator: 1,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   185,
											},
											File:   "monitor.flux",
											Source: "toLevel == \"any\"",
											Start: ast.Position{
												Column: 38,
												Line:   185,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   185,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 38,
													Line:   185,
												},
											},
										},
										Name: "toLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   185,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 49,
													Line:   185,
												},
											},
										},
										Value: "any",
									},
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   188,
								},
								File:   "monitor.flux",
								Source: "return if fromLevel == \"any\" and toLevel == \"any\" then\n        tables |> stateChangesOnly()\n    else\n        tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
								Start: ast.Position{
									Column: 5,
									Line:   185,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   184,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 17,
								Line:   184,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   184,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 17,
									Line:   184,
								},
							},
						},
						Name: "fromLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   184,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 27,
									Line:   184,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   184,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 34,
								Line:   184,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   184,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 34,
									Line:   184,
								},
							},
						},
						Name: "toLevel",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   184,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 42,
									Line:   184,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   184,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 49,
								Line:   184,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   184,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 49,
									Line:   184,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   184,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 56,
								Line:   184,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 52,
						Line:   213,
					},
					File:   "monitor.flux",
					Source: "deadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ({r with dead: r._time < t}))",
					Start: ast.Position{
						Column: 1,
						Line:   211,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// deadman detects when a group stops reporting data.\n"}, ast.Comment{Text: "// It takes a stream of tables and reports if groups have been observed since time t.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      monitor.deadman() retains the most recent row from each input table and adds a dead column.\n"}, ast.Comment{Text: "//      If a record appears after time t, monitor.deadman() sets dead to false. Otherwise, dead is set to true.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time threshold for the deadman check.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Detect if a host hasn’t reported in the last five minutes\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/monitor\"\n"}, ast.Comment{Text: "// import \"experimental\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -10m)\n"}, ast.Comment{Text: "//   |> group(columns: [\"host\"])\n"}, ast.Comment{Text: "//   |> monitor.deadman(t: experimental.subDuration(d: 5m, from: now() ))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   211,
						},
						File:   "monitor.flux",
						Source: "deadman",
						Start: ast.Position{
							Column: 1,
							Line:   211,
						},
					},
				},
				Name: "deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 52,
							Line:   213,
						},
						File:   "monitor.flux",
						Source: "(t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ({r with dead: r._time < t}))",
						Start: ast.Position{
							Column: 11,
							Line:   211,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   211,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   211,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   212,
								},
								File:   "monitor.flux",
								Source: "tables\n    |> max(column: \"_time\")",
								Start: ast.Position{
									Column: 29,
									Line:   211,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   212,
										},
										File:   "monitor.flux",
										Source: "column: \"_time\"",
										Start: ast.Position{
											Column: 12,
											Line:   212,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   212,
											},
											File:   "monitor.flux",
											Source: "column: \"_time\"",
											Start: ast.Position{
												Column: 12,
												Line:   212,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   212,
												},
												File:   "monitor.flux",
												Source: "column",
												Start: ast.Position{
													Column: 12,
													Line:   212,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   212,
												},
												File:   "monitor.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 20,
													Line:   212,
												},
											},
										},
										Value: "_time",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   212,
									},
									File:   "monitor.flux",
									Source: "max(column: \"_time\")",
									Start: ast.Position{
										Column: 8,
										Line:   212,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   212,
										},
										File:   "monitor.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   212,
										},
									},
								},
								Name: "max",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 52,
								Line:   213,
							},
							File:   "monitor.flux",
							Source: "tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ({r with dead: r._time < t}))",
							Start: ast.Position{
								Column: 29,
								Line:   211,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   213,
									},
									File:   "monitor.flux",
									Source: "fn: (r) => ({r with dead: r._time < t})",
									Start: ast.Position{
										Column: 12,
										Line:   213,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   213,
										},
										File:   "monitor.flux",
										Source: "fn: (r) => ({r with dead: r._time < t})",
										Start: ast.Position{
											Column: 12,
											Line:   213,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   213,
											},
											File:   "monitor.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   213,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   213,
											},
											File:   "monitor.flux",
											Source: "(r) => ({r with dead: r._time < t})",
											Start: ast.Position{
												Column: 16,
												Line:   213,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   213,
												},
												File:   "monitor.flux",
												Source: "({r with dead: r._time < t})",
												Start: ast.Position{
													Column: 23,
													Line:   213,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   213,
													},
													File:   "monitor.flux",
													Source: "{r with dead: r._time < t}",
													Start: ast.Position{
														Column: 24,
														Line:   213,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   213,
														},
														File:   "monitor.flux",
														Source: "dead: r._time < t",
														Start: ast.Position{
															Column: 32,
															Line:   213,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   213,
															},
															File:   "monitor.flux",
															Source: "dead",
															Start: ast.Position{
																Column: 32,
																Line:   213,
															},
														},
													},
													Name: "dead",
												},
												Separator: nil,
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   213,
															},
															File:   "monitor.flux",
															Source: "r._time < t",
															Start: ast.Position{
																Column: 38,
																Line:   213,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   213,
																},
																File:   "monitor.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 38,
																	Line:   213,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   213,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 38,
																		Line:   213,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   213,
																	},
																	File:   "monitor.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 40,
																		Line:   213,
																	},
																},
															},
															Name: "_time",
														},
														Rbrack: nil,
													},
													Operator: 8,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   213,
																},
																File:   "monitor.flux",
																Source: "t",
																Start: ast.Position{
																	Column: 48,
																	Line:   213,
																},
															},
														},
														Name: "t",
													},
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   213,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   213,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   213,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   213,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   213,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   213,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   213,
								},
								File:   "monitor.flux",
								Source: "map(fn: (r) => ({r with dead: r._time < t}))",
								Start: ast.Position{
									Column: 8,
									Line:   213,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   213,
									},
									File:   "monitor.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   213,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   211,
							},
							File:   "monitor.flux",
							Source: "t",
							Start: ast.Position{
								Column: 12,
								Line:   211,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   211,
								},
								File:   "monitor.flux",
								Source: "t",
								Start: ast.Position{
									Column: 12,
									Line:   211,
								},
							},
						},
						Name: "t",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   211,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   211,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   211,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   211,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   211,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   211,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   304,
					},
					File:   "monitor.flux",
					Source: "check = (\n        tables=<-,\n        data,\n        messageFn,\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n) => tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )\n    |> experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )\n    |> write()",
					Start: ast.Position{
						Column: 1,
						Line:   257,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// check checks input data and assigns a level (ok, info, warn, or crit) to each row based on predicate functions.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      monitor.check() stores statuses in the _level column and writes results to the statuses measurement in the _monitoring bucket.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `crit` is the predicate function that determines crit status. Default is (r) => false.\n"}, ast.Comment{Text: "// - `warn` is the predicate function that determines warn status. Default is (r) => false.\n"}, ast.Comment{Text: "// - `info` is the predicate function that determines info status. Default is (r) => false.\n"}, ast.Comment{Text: "// - `ok` is the predicate function that determines ok status. Default is (r) => false.\n"}, ast.Comment{Text: "// - `messagefn` is the predicate function that constructs a message to append to each row. The message is stored in the _message column.\n"}, ast.Comment{Text: "// - `data` is meta data used to identify this check.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Monitor disk usage\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/monitor\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket: \"telegraf\")\n"}, ast.Comment{Text: "//   |> range(start: -1h)\n"}, ast.Comment{Text: "//   |> filter(fn: (r) =>\n"}, ast.Comment{Text: "//       r._measurement == \"disk\" and\n"}, ast.Comment{Text: "//       r._field == \"used_percent\"\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "//   |> group(columns: [\"_measurement\"])\n"}, ast.Comment{Text: "//   |> monitor.check(\n"}, ast.Comment{Text: "//     crit: (r) => r._value > 90.0,\n"}, ast.Comment{Text: "//     warn: (r) => r._value > 80.0,\n"}, ast.Comment{Text: "//     info: (r) => r._value > 70.0,\n"}, ast.Comment{Text: "//     ok:   (r) => r._value <= 60.0,\n"}, ast.Comment{Text: "//     messageFn: (r) =>\n"}, ast.Comment{Text: "//       if r._level == \"crit\" then \"Critical alert!! Disk usage is at ${r._value}%!\"\n"}, ast.Comment{Text: "//       else if r._level == \"warn\" then \"Warning! Disk usage is at ${r._value}%.\"\n"}, ast.Comment{Text: "//       else if r._level == \"info\" then \"Disk usage is at ${r._value}%.\"\n"}, ast.Comment{Text: "//       else \"Things are looking good.\",\n"}, ast.Comment{Text: "//     data: {\n"}, ast.Comment{Text: "//       _check_name: \"Disk Utilization (Used Percentage)\",\n"}, ast.Comment{Text: "//       _check_id: \"disk_used_percent\",\n"}, ast.Comment{Text: "//       _type: \"threshold\",\n"}, ast.Comment{Text: "//       tags: {}\n"}, ast.Comment{Text: "//     }\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   257,
						},
						File:   "monitor.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   257,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   304,
						},
						File:   "monitor.flux",
						Source: "(\n        tables=<-,\n        data,\n        messageFn,\n        crit=(r) => false,\n        warn=(r) => false,\n        info=(r) => false,\n        ok=(r) => true,\n) => tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )\n    |> experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )\n    |> write()",
						Start: ast.Position{
							Column: 9,
							Line:   257,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   265,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 6,
														Line:   265,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   266,
												},
												File:   "monitor.flux",
												Source: "tables\n    |> experimental.set(o: data.tags)",
												Start: ast.Position{
													Column: 6,
													Line:   265,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   266,
														},
														File:   "monitor.flux",
														Source: "o: data.tags",
														Start: ast.Position{
															Column: 25,
															Line:   266,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   266,
															},
															File:   "monitor.flux",
															Source: "o: data.tags",
															Start: ast.Position{
																Column: 25,
																Line:   266,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   266,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 25,
																	Line:   266,
																},
															},
														},
														Name: "o",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   266,
																},
																File:   "monitor.flux",
																Source: "data.tags",
																Start: ast.Position{
																	Column: 28,
																	Line:   266,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   266,
																	},
																	File:   "monitor.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 28,
																		Line:   266,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   266,
																	},
																	File:   "monitor.flux",
																	Source: "tags",
																	Start: ast.Position{
																		Column: 33,
																		Line:   266,
																	},
																},
															},
															Name: "tags",
														},
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   266,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data.tags)",
													Start: ast.Position{
														Column: 8,
														Line:   266,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   266,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 8,
															Line:   266,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   266,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 8,
																Line:   266,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   266,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 21,
																Line:   266,
															},
														},
													},
													Name: "set",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   267,
											},
											File:   "monitor.flux",
											Source: "tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
											Start: ast.Position{
												Column: 6,
												Line:   265,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   267,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data.tags)",
													Start: ast.Position{
														Column: 27,
														Line:   267,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   267,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 27,
															Line:   267,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   267,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 27,
																Line:   267,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   267,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 33,
																Line:   267,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 89,
															Line:   267,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data.tags)",
														Start: ast.Position{
															Column: 43,
															Line:   267,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   267,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 43,
																Line:   267,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 88,
																	Line:   267,
																},
																File:   "monitor.flux",
																Source: "o: data.tags",
																Start: ast.Position{
																	Column: 76,
																	Line:   267,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 88,
																		Line:   267,
																	},
																	File:   "monitor.flux",
																	Source: "o: data.tags",
																	Start: ast.Position{
																		Column: 76,
																		Line:   267,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   267,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 76,
																			Line:   267,
																		},
																	},
																},
																Name: "o",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 88,
																			Line:   267,
																		},
																		File:   "monitor.flux",
																		Source: "data.tags",
																		Start: ast.Position{
																			Column: 79,
																			Line:   267,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 83,
																				Line:   267,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 79,
																				Line:   267,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 88,
																				Line:   267,
																			},
																			File:   "monitor.flux",
																			Source: "tags",
																			Start: ast.Position{
																				Column: 84,
																				Line:   267,
																			},
																		},
																	},
																	Name: "tags",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 89,
																Line:   267,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data.tags)",
															Start: ast.Position{
																Column: 52,
																Line:   267,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   267,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 52,
																	Line:   267,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   267,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 52,
																		Line:   267,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   267,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 65,
																		Line:   267,
																	},
																},
															},
															Name: "objectKeys",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   267,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
												Start: ast.Position{
													Column: 8,
													Line:   267,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   267,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 8,
														Line:   267,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   267,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 8,
															Line:   267,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   267,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 21,
															Line:   267,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   288,
										},
										File:   "monitor.flux",
										Source: "tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )",
										Start: ast.Position{
											Column: 6,
											Line:   265,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   287,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 9,
													Line:   269,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   287,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 9,
														Line:   269,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   269,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 9,
															Line:   269,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   287,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 13,
															Line:   269,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   287,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 20,
																Line:   269,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   287,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 21,
																	Line:   269,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   270,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"statuses\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   270,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   270,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   270,
																		},
																	},
																},
																Name: "_measurement",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   270,
																		},
																		File:   "monitor.flux",
																		Source: "\"statuses\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   270,
																		},
																	},
																},
																Value: "statuses",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   271,
																	},
																	File:   "monitor.flux",
																	Source: "_source_measurement: r._measurement",
																	Start: ast.Position{
																		Column: 13,
																		Line:   271,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   271,
																		},
																		File:   "monitor.flux",
																		Source: "_source_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   271,
																		},
																	},
																},
																Name: "_source_measurement",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   271,
																		},
																		File:   "monitor.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 34,
																			Line:   271,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   271,
																			},
																			File:   "monitor.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 34,
																				Line:   271,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   271,
																			},
																			File:   "monitor.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 36,
																				Line:   271,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   272,
																	},
																	File:   "monitor.flux",
																	Source: "_type: data._type",
																	Start: ast.Position{
																		Column: 13,
																		Line:   272,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   272,
																		},
																		File:   "monitor.flux",
																		Source: "_type",
																		Start: ast.Position{
																			Column: 13,
																			Line:   272,
																		},
																	},
																},
																Name: "_type",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   272,
																		},
																		File:   "monitor.flux",
																		Source: "data._type",
																		Start: ast.Position{
																			Column: 20,
																			Line:   272,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   272,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 20,
																				Line:   272,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   272,
																			},
																			File:   "monitor.flux",
																			Source: "_type",
																			Start: ast.Position{
																				Column: 25,
																				Line:   272,
																			},
																		},
																	},
																	Name: "_type",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   273,
																	},
																	File:   "monitor.flux",
																	Source: "_check_id: data._check_id",
																	Start: ast.Position{
																		Column: 13,
																		Line:   273,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   273,
																		},
																		File:   "monitor.flux",
																		Source: "_check_id",
																		Start: ast.Position{
																			Column: 13,
																			Line:   273,
																		},
																	},
																},
																Name: "_check_id",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   273,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_id",
																		Start: ast.Position{
																			Column: 24,
																			Line:   273,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   273,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 24,
																				Line:   273,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   273,
																			},
																			File:   "monitor.flux",
																			Source: "_check_id",
																			Start: ast.Position{
																				Column: 29,
																				Line:   273,
																			},
																		},
																	},
																	Name: "_check_id",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   274,
																	},
																	File:   "monitor.flux",
																	Source: "_check_name: data._check_name",
																	Start: ast.Position{
																		Column: 13,
																		Line:   274,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   274,
																		},
																		File:   "monitor.flux",
																		Source: "_check_name",
																		Start: ast.Position{
																			Column: 13,
																			Line:   274,
																		},
																	},
																},
																Name: "_check_name",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   274,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_name",
																		Start: ast.Position{
																			Column: 26,
																			Line:   274,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   274,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 26,
																				Line:   274,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 42,
																				Line:   274,
																			},
																			File:   "monitor.flux",
																			Source: "_check_name",
																			Start: ast.Position{
																				Column: 31,
																				Line:   274,
																			},
																		},
																	},
																	Name: "_check_name",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   284,
																	},
																	File:   "monitor.flux",
																	Source: "_level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown",
																	Start: ast.Position{
																		Column: 13,
																		Line:   275,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   275,
																		},
																		File:   "monitor.flux",
																		Source: "_level",
																		Start: ast.Position{
																			Column: 13,
																			Line:   275,
																		},
																	},
																},
																Name: "_level",
															},
															Separator: nil,
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.ConditionalExpression{
																		Alternate: &ast.ConditionalExpression{
																			Alternate: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   284,
																						},
																						File:   "monitor.flux",
																						Source: "levelUnknown",
																						Start: ast.Position{
																							Column: 17,
																							Line:   284,
																						},
																					},
																				},
																				Name: "levelUnknown",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   284,
																					},
																					File:   "monitor.flux",
																					Source: "if ok(r: r) then\n                levelOK\n            else\n                levelUnknown",
																					Start: ast.Position{
																						Column: 18,
																						Line:   281,
																					},
																				},
																			},
																			Consequent: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   282,
																						},
																						File:   "monitor.flux",
																						Source: "levelOK",
																						Start: ast.Position{
																							Column: 17,
																							Line:   282,
																						},
																					},
																				},
																				Name: "levelOK",
																			},
																			Test: &ast.CallExpression{
																				Arguments: []ast.Expression{&ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   281,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 24,
																								Line:   281,
																							},
																						},
																					},
																					Lbrace: nil,
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 28,
																									Line:   281,
																								},
																								File:   "monitor.flux",
																								Source: "r: r",
																								Start: ast.Position{
																									Column: 24,
																									Line:   281,
																								},
																							},
																						},
																						Comma: nil,
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 25,
																										Line:   281,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 24,
																										Line:   281,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Separator: nil,
																						Value: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 28,
																										Line:   281,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 27,
																										Line:   281,
																									},
																								},
																							},
																							Name: "r",
																						},
																					}},
																					Rbrace: nil,
																					With:   nil,
																				}},
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   281,
																						},
																						File:   "monitor.flux",
																						Source: "ok(r: r)",
																						Start: ast.Position{
																							Column: 21,
																							Line:   281,
																						},
																					},
																				},
																				Callee: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 23,
																								Line:   281,
																							},
																							File:   "monitor.flux",
																							Source: "ok",
																							Start: ast.Position{
																								Column: 21,
																								Line:   281,
																							},
																						},
																					},
																					Name: "ok",
																				},
																				Lparen: nil,
																				Rparen: nil,
																			},
																			Tk_else: nil,
																			Tk_if:   nil,
																			Tk_then: nil,
																		},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 29,
																					Line:   284,
																				},
																				File:   "monitor.flux",
																				Source: "if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown",
																				Start: ast.Position{
																					Column: 18,
																					Line:   279,
																				},
																			},
																		},
																		Consequent: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 26,
																						Line:   280,
																					},
																					File:   "monitor.flux",
																					Source: "levelInfo",
																					Start: ast.Position{
																						Column: 17,
																						Line:   280,
																					},
																				},
																			},
																			Name: "levelInfo",
																		},
																		Test: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 30,
																							Line:   279,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 26,
																							Line:   279,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 30,
																								Line:   279,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 26,
																								Line:   279,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 27,
																									Line:   279,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 26,
																									Line:   279,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 30,
																									Line:   279,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 29,
																									Line:   279,
																								},
																							},
																						},
																						Name: "r",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 31,
																						Line:   279,
																					},
																					File:   "monitor.flux",
																					Source: "info(r: r)",
																					Start: ast.Position{
																						Column: 21,
																						Line:   279,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   279,
																						},
																						File:   "monitor.flux",
																						Source: "info",
																						Start: ast.Position{
																							Column: 21,
																							Line:   279,
																						},
																					},
																				},
																				Name: "info",
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																		Tk_else: nil,
																		Tk_if:   nil,
																		Tk_then: nil,
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   284,
																			},
																			File:   "monitor.flux",
																			Source: "if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown",
																			Start: ast.Position{
																				Column: 18,
																				Line:   277,
																			},
																		},
																	},
																	Consequent: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 26,
																					Line:   278,
																				},
																				File:   "monitor.flux",
																				Source: "levelWarn",
																				Start: ast.Position{
																					Column: 17,
																					Line:   278,
																				},
																			},
																		},
																		Name: "levelWarn",
																	},
																	Test: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 30,
																						Line:   277,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 26,
																						Line:   277,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 30,
																							Line:   277,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 26,
																							Line:   277,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 27,
																								Line:   277,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 26,
																								Line:   277,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 30,
																								Line:   277,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 29,
																								Line:   277,
																							},
																						},
																					},
																					Name: "r",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 31,
																					Line:   277,
																				},
																				File:   "monitor.flux",
																				Source: "warn(r: r)",
																				Start: ast.Position{
																					Column: 21,
																					Line:   277,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   277,
																					},
																					File:   "monitor.flux",
																					Source: "warn",
																					Start: ast.Position{
																						Column: 21,
																						Line:   277,
																					},
																				},
																			},
																			Name: "warn",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																	Tk_else: nil,
																	Tk_if:   nil,
																	Tk_then: nil,
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   284,
																		},
																		File:   "monitor.flux",
																		Source: "if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown",
																		Start: ast.Position{
																			Column: 21,
																			Line:   275,
																		},
																	},
																},
																Consequent: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   276,
																			},
																			File:   "monitor.flux",
																			Source: "levelCrit",
																			Start: ast.Position{
																				Column: 17,
																				Line:   276,
																			},
																		},
																	},
																	Name: "levelCrit",
																},
																Test: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 33,
																					Line:   275,
																				},
																				File:   "monitor.flux",
																				Source: "r: r",
																				Start: ast.Position{
																					Column: 29,
																					Line:   275,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 33,
																						Line:   275,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 29,
																						Line:   275,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 30,
																							Line:   275,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 29,
																							Line:   275,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 33,
																							Line:   275,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 32,
																							Line:   275,
																						},
																					},
																				},
																				Name: "r",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   275,
																			},
																			File:   "monitor.flux",
																			Source: "crit(r: r)",
																			Start: ast.Position{
																				Column: 24,
																				Line:   275,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   275,
																				},
																				File:   "monitor.flux",
																				Source: "crit",
																				Start: ast.Position{
																					Column: 24,
																					Line:   275,
																				},
																			},
																		},
																		Name: "crit",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   285,
																	},
																	File:   "monitor.flux",
																	Source: "_source_timestamp: int(v: r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   285,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   285,
																		},
																		File:   "monitor.flux",
																		Source: "_source_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   285,
																		},
																	},
																},
																Name: "_source_timestamp",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   285,
																			},
																			File:   "monitor.flux",
																			Source: "v: r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   285,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   285,
																				},
																				File:   "monitor.flux",
																				Source: "v: r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   285,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   285,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   285,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   285,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 39,
																						Line:   285,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   285,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 39,
																							Line:   285,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   285,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 41,
																							Line:   285,
																						},
																					},
																				},
																				Name: "_time",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   285,
																		},
																		File:   "monitor.flux",
																		Source: "int(v: r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   285,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   285,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   285,
																			},
																		},
																	},
																	Name: "int",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   286,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   286,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   286,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   286,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   286,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   286,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   286,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   286,
																			},
																		},
																	},
																	Name: "now",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   269,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 22,
																		Line:   269,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   269,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   269,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   269,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   269,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   288,
											},
											File:   "monitor.flux",
											Source: "map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   268,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   268,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   268,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   293,
									},
									File:   "monitor.flux",
									Source: "tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )",
									Start: ast.Position{
										Column: 6,
										Line:   265,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   292,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   290,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   292,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
												Start: ast.Position{
													Column: 9,
													Line:   290,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   290,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   290,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   292,
													},
													File:   "monitor.flux",
													Source: "(r) => ({r with\n            _message: messageFn(r: r),\n        })",
													Start: ast.Position{
														Column: 13,
														Line:   290,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   292,
														},
														File:   "monitor.flux",
														Source: "({r with\n            _message: messageFn(r: r),\n        })",
														Start: ast.Position{
															Column: 20,
															Line:   290,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   292,
															},
															File:   "monitor.flux",
															Source: "{r with\n            _message: messageFn(r: r),\n        }",
															Start: ast.Position{
																Column: 21,
																Line:   290,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   291,
																},
																File:   "monitor.flux",
																Source: "_message: messageFn(r: r)",
																Start: ast.Position{
																	Column: 13,
																	Line:   291,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   291,
																	},
																	File:   "monitor.flux",
																	Source: "_message",
																	Start: ast.Position{
																		Column: 13,
																		Line:   291,
																	},
																},
															},
															Name: "_message",
														},
														Separator: nil,
														Value: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   291,
																		},
																		File:   "monitor.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 33,
																			Line:   291,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   291,
																			},
																			File:   "monitor.flux",
																			Source: "r: r",
																			Start: ast.Position{
																				Column: 33,
																				Line:   291,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   291,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 33,
																					Line:   291,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Separator: nil,
																	Value: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   291,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 36,
																					Line:   291,
																				},
																			},
																		},
																		Name: "r",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   291,
																	},
																	File:   "monitor.flux",
																	Source: "messageFn(r: r)",
																	Start: ast.Position{
																		Column: 23,
																		Line:   291,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   291,
																		},
																		File:   "monitor.flux",
																		Source: "messageFn",
																		Start: ast.Position{
																			Column: 23,
																			Line:   291,
																		},
																	},
																},
																Name: "messageFn",
															},
															Lparen: nil,
															Rparen: nil,
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   290,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   290,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   290,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   290,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   290,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   290,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   293,
										},
										File:   "monitor.flux",
										Source: "map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   289,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   289,
											},
											File:   "monitor.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   289,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   303,
								},
								File:   "monitor.flux",
								Source: "tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )\n    |> experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )",
								Start: ast.Position{
									Column: 6,
									Line:   265,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   302,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ]",
										Start: ast.Position{
											Column: 9,
											Line:   295,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   295,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 9,
												Line:   295,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   295,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 9,
													Line:   295,
												},
											},
										},
										Name: "mode",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   295,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 15,
													Line:   295,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   302,
											},
											File:   "monitor.flux",
											Source: "columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ]",
											Start: ast.Position{
												Column: 9,
												Line:   296,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   296,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 9,
													Line:   296,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   302,
												},
												File:   "monitor.flux",
												Source: "[\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ]",
												Start: ast.Position{
													Column: 18,
													Line:   296,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   297,
													},
													File:   "monitor.flux",
													Source: "\"_source_measurement\"",
													Start: ast.Position{
														Column: 13,
														Line:   297,
													},
												},
											},
											Value: "_source_measurement",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   298,
													},
													File:   "monitor.flux",
													Source: "\"_type\"",
													Start: ast.Position{
														Column: 13,
														Line:   298,
													},
												},
											},
											Value: "_type",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   299,
													},
													File:   "monitor.flux",
													Source: "\"_check_id\"",
													Start: ast.Position{
														Column: 13,
														Line:   299,
													},
												},
											},
											Value: "_check_id",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   300,
													},
													File:   "monitor.flux",
													Source: "\"_check_name\"",
													Start: ast.Position{
														Column: 13,
														Line:   300,
													},
												},
											},
											Value: "_check_name",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   301,
													},
													File:   "monitor.flux",
													Source: "\"_level\"",
													Start: ast.Position{
														Column: 13,
														Line:   301,
													},
												},
											},
											Value: "_level",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   303,
									},
									File:   "monitor.flux",
									Source: "experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   294,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   294,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 8,
											Line:   294,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   294,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 8,
												Line:   294,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   294,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 21,
												Line:   294,
											},
										},
									},
									Name: "group",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   304,
							},
							File:   "monitor.flux",
							Source: "tables\n    |> experimental.set(o: data.tags)\n    |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n    |> map(\n        fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id: data._check_id,\n            _check_name: data._check_name,\n            _level: if crit(r: r) then\n                levelCrit\n            else if warn(r: r) then\n                levelWarn\n            else if info(r: r) then\n                levelInfo\n            else if ok(r: r) then\n                levelOK\n            else\n                levelUnknown,\n            _source_timestamp: int(v: r._time),\n            _time: now(),\n        }),\n    )\n    |> map(\n        fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }),\n    )\n    |> experimental.group(\n        mode: \"extend\",\n        columns: [\n            \"_source_measurement\",\n            \"_type\",\n            \"_check_id\",\n            \"_check_name\",\n            \"_level\",\n        ],\n    )\n    |> write()",
							Start: ast.Position{
								Column: 6,
								Line:   265,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   304,
								},
								File:   "monitor.flux",
								Source: "write()",
								Start: ast.Position{
									Column: 8,
									Line:   304,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   304,
									},
									File:   "monitor.flux",
									Source: "write",
									Start: ast.Position{
										Column: 8,
										Line:   304,
									},
								},
							},
							Name: "write",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   258,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   258,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   258,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   258,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   258,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   258,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   259,
							},
							File:   "monitor.flux",
							Source: "data",
							Start: ast.Position{
								Column: 9,
								Line:   259,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   259,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 9,
									Line:   259,
								},
							},
						},
						Name: "data",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   260,
							},
							File:   "monitor.flux",
							Source: "messageFn",
							Start: ast.Position{
								Column: 9,
								Line:   260,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   260,
								},
								File:   "monitor.flux",
								Source: "messageFn",
								Start: ast.Position{
									Column: 9,
									Line:   260,
								},
							},
						},
						Name: "messageFn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   261,
							},
							File:   "monitor.flux",
							Source: "crit=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   261,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   261,
								},
								File:   "monitor.flux",
								Source: "crit",
								Start: ast.Position{
									Column: 9,
									Line:   261,
								},
							},
						},
						Name: "crit",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   261,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   261,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   261,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   261,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   261,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   261,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   261,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   261,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   262,
							},
							File:   "monitor.flux",
							Source: "warn=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   262,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   262,
								},
								File:   "monitor.flux",
								Source: "warn",
								Start: ast.Position{
									Column: 9,
									Line:   262,
								},
							},
						},
						Name: "warn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   262,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   262,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   262,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   262,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   262,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   262,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   262,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   262,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   263,
							},
							File:   "monitor.flux",
							Source: "info=(r) => false",
							Start: ast.Position{
								Column: 9,
								Line:   263,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   263,
								},
								File:   "monitor.flux",
								Source: "info",
								Start: ast.Position{
									Column: 9,
									Line:   263,
								},
							},
						},
						Name: "info",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   263,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 14,
									Line:   263,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   263,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 21,
										Line:   263,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   263,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 15,
										Line:   263,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   263,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 15,
											Line:   263,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   264,
							},
							File:   "monitor.flux",
							Source: "ok=(r) => true",
							Start: ast.Position{
								Column: 9,
								Line:   264,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   264,
								},
								File:   "monitor.flux",
								Source: "ok",
								Start: ast.Position{
									Column: 9,
									Line:   264,
								},
							},
						},
						Name: "ok",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   264,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 12,
									Line:   264,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   264,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 19,
										Line:   264,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   264,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 13,
										Line:   264,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   264,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 13,
											Line:   264,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   5,
					},
					File:   "monitor.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   5,
						},
						File:   "monitor.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   6,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   6,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   7,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   7,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "monitor.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// The Flux monitor package provides tools for monitoring and alerting with InfluxDB.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   2,
					},
					File:   "monitor.flux",
					Source: "package monitor",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   2,
						},
						File:   "monitor.flux",
						Source: "monitor",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "monitor",
			},
		},
	}},
	Package: "monitor",
	Path:    "influxdata/influxdb/monitor",
}
