// DO NOT EDIT: This file is autogenerated via the builtin command.

package sample

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   84,
				},
				File:   "sample.flux",
				Source: "package sample\n\n\nimport \"array\"\nimport \"dict\"\nimport \"experimental/csv\"\n\nsets = [\n    \"airSensor\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\",\n        desc: \"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\",\n        size: \"~600 KB\",\n    },\n    \"birdMigration\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\",\n        desc: \"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\",\n        size: \"~1.2 MB\",\n    },\n    \"noaa\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\",\n        desc: \"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\",\n        size: \"~1.3 MB\",\n    },\n    \"usgs\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\",\n        desc: \"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\",\n        size: \"~6 MB\",\n    },\n]\n\n_setInfo = (set) => {\n    _setDict = dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})\n\n    return {name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}\n}\n\n// data downloads a specified InfluxDB sample dataset.\n//\n// ## Parameters\n//\n// - `set` is the sample data set to download and output. Valid datasets:\n//    - **airSensor**: Simulated temperature, humidity, and CO data from an office building.\n//    - **birdMigration**: 2019 African bird migration data from [Movebank: Animal Tracking](https://www.kaggle.com/pulkit8595/movebank-animal-tracking).\n//    - **noaa**: Latest observations from the [NOAA National Data Buoy Center (NDBC)](https://www.ndbc.noaa.gov/).\n//    - **usgs**: USGS earthquake data from the last week.\n//\n// ## Load InfluxDB sample data\n//\n// ```\n// import \"influxdata/influxdb/sample\"\n//\n// sample.data(set: \"airSensor\")\n// ```\n//\ndata = (set) => {\n    setInfo = _setInfo(set: set)\n\n    url = if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url\n\n    return csv.from(url: url)\n}\n\n// list outputs information about available InfluxDB sample datasets.\n//\n// ## List available InfluxDB sample datasets\n//\n// ```\n// import \"influxdata/influxdb/sample\"\n//\n// sample.list()\n// ```\n//\nlist = () => array.from(\n    rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ],\n)",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   30,
					},
					File:   "sample.flux",
					Source: "sets = [\n    \"airSensor\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\",\n        desc: \"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\",\n        size: \"~600 KB\",\n    },\n    \"birdMigration\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\",\n        desc: \"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\",\n        size: \"~1.2 MB\",\n    },\n    \"noaa\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\",\n        desc: \"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\",\n        size: \"~1.3 MB\",\n    },\n    \"usgs\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\",\n        desc: \"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\",\n        size: \"~6 MB\",\n    },\n]",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   9,
						},
						File:   "sample.flux",
						Source: "sets",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "sets",
			},
			Init: &ast.DictExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   30,
						},
						File:   "sample.flux",
						Source: "[\n    \"airSensor\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\",\n        desc: \"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\",\n        size: \"~600 KB\",\n    },\n    \"birdMigration\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\",\n        desc: \"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\",\n        size: \"~1.2 MB\",\n    },\n    \"noaa\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\",\n        desc: \"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\",\n        size: \"~1.3 MB\",\n    },\n    \"usgs\": {\n        url: \"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\",\n        desc: \"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\",\n        size: \"~6 MB\",\n    },\n]",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				Elements: []*ast.DictItem{&ast.DictItem{
					Comma: nil,
					Key: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   10,
								},
								File:   "sample.flux",
								Source: "\"airSensor\"",
								Start: ast.Position{
									Column: 5,
									Line:   10,
								},
							},
						},
						Value: "airSensor",
					},
					Val: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   14,
								},
								File:   "sample.flux",
								Source: "{\n        url: \"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\",\n        desc: \"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\",\n        size: \"~600 KB\",\n    }",
								Start: ast.Position{
									Column: 18,
									Line:   10,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   11,
									},
									File:   "sample.flux",
									Source: "url: \"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\"",
									Start: ast.Position{
										Column: 9,
										Line:   11,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   11,
										},
										File:   "sample.flux",
										Source: "url",
										Start: ast.Position{
											Column: 9,
											Line:   11,
										},
									},
								},
								Name: "url",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   11,
										},
										File:   "sample.flux",
										Source: "\"https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv\"",
										Start: ast.Position{
											Column: 14,
											Line:   11,
										},
									},
								},
								Value: "https://influx-testdata.s3.amazonaws.com/air-sensor-data-annotated.csv",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 156,
										Line:   12,
									},
									File:   "sample.flux",
									Source: "desc: \"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\"",
									Start: ast.Position{
										Column: 9,
										Line:   12,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   12,
										},
										File:   "sample.flux",
										Source: "desc",
										Start: ast.Position{
											Column: 9,
											Line:   12,
										},
									},
								},
								Name: "desc",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 156,
											Line:   12,
										},
										File:   "sample.flux",
										Source: "\"Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.\"",
										Start: ast.Position{
											Column: 15,
											Line:   12,
										},
									},
								},
								Value: "Simulated office building air sensor data with temperature, humidity, and carbon monoxide metrics. Data is updated approximately every 15m.",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   13,
									},
									File:   "sample.flux",
									Source: "size: \"~600 KB\"",
									Start: ast.Position{
										Column: 9,
										Line:   13,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   13,
										},
										File:   "sample.flux",
										Source: "size",
										Start: ast.Position{
											Column: 9,
											Line:   13,
										},
									},
								},
								Name: "size",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   13,
										},
										File:   "sample.flux",
										Source: "\"~600 KB\"",
										Start: ast.Position{
											Column: 15,
											Line:   13,
										},
									},
								},
								Value: "~600 KB",
							},
						}},
						Rbrace: nil,
						With:   nil,
					},
				}, &ast.DictItem{
					Comma: nil,
					Key: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   15,
								},
								File:   "sample.flux",
								Source: "\"birdMigration\"",
								Start: ast.Position{
									Column: 5,
									Line:   15,
								},
							},
						},
						Value: "birdMigration",
					},
					Val: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   19,
								},
								File:   "sample.flux",
								Source: "{\n        url: \"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\",\n        desc: \"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\",\n        size: \"~1.2 MB\",\n    }",
								Start: ast.Position{
									Column: 22,
									Line:   15,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   16,
									},
									File:   "sample.flux",
									Source: "url: \"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\"",
									Start: ast.Position{
										Column: 9,
										Line:   16,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   16,
										},
										File:   "sample.flux",
										Source: "url",
										Start: ast.Position{
											Column: 9,
											Line:   16,
										},
									},
								},
								Name: "url",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   16,
										},
										File:   "sample.flux",
										Source: "\"https://influx-testdata.s3.amazonaws.com/bird-migration.csv\"",
										Start: ast.Position{
											Column: 14,
											Line:   16,
										},
									},
								},
								Value: "https://influx-testdata.s3.amazonaws.com/bird-migration.csv",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 158,
										Line:   17,
									},
									File:   "sample.flux",
									Source: "desc: \"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\"",
									Start: ast.Position{
										Column: 9,
										Line:   17,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   17,
										},
										File:   "sample.flux",
										Source: "desc",
										Start: ast.Position{
											Column: 9,
											Line:   17,
										},
									},
								},
								Name: "desc",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 158,
											Line:   17,
										},
										File:   "sample.flux",
										Source: "\"2019 African bird migration data from the \\\"Movebank: Animal Tracking\\\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.\"",
										Start: ast.Position{
											Column: 15,
											Line:   17,
										},
									},
								},
								Value: "2019 African bird migration data from the \"Movebank: Animal Tracking\" dataset. Contains geotemporal data between 2019-01-01 and 2019-12-31.",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   18,
									},
									File:   "sample.flux",
									Source: "size: \"~1.2 MB\"",
									Start: ast.Position{
										Column: 9,
										Line:   18,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   18,
										},
										File:   "sample.flux",
										Source: "size",
										Start: ast.Position{
											Column: 9,
											Line:   18,
										},
									},
								},
								Name: "size",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   18,
										},
										File:   "sample.flux",
										Source: "\"~1.2 MB\"",
										Start: ast.Position{
											Column: 15,
											Line:   18,
										},
									},
								},
								Value: "~1.2 MB",
							},
						}},
						Rbrace: nil,
						With:   nil,
					},
				}, &ast.DictItem{
					Comma: nil,
					Key: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   20,
								},
								File:   "sample.flux",
								Source: "\"noaa\"",
								Start: ast.Position{
									Column: 5,
									Line:   20,
								},
							},
						},
						Value: "noaa",
					},
					Val: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   24,
								},
								File:   "sample.flux",
								Source: "{\n        url: \"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\",\n        desc: \"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\",\n        size: \"~1.3 MB\",\n    }",
								Start: ast.Position{
									Column: 13,
									Line:   20,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   21,
									},
									File:   "sample.flux",
									Source: "url: \"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\"",
									Start: ast.Position{
										Column: 9,
										Line:   21,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   21,
										},
										File:   "sample.flux",
										Source: "url",
										Start: ast.Position{
											Column: 9,
											Line:   21,
										},
									},
								},
								Name: "url",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   21,
										},
										File:   "sample.flux",
										Source: "\"https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv\"",
										Start: ast.Position{
											Column: 14,
											Line:   21,
										},
									},
								},
								Value: "https://influx-testdata.s3.amazonaws.com/noaa-ndbc-latest-observations-annotated.csv",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 190,
										Line:   22,
									},
									File:   "sample.flux",
									Source: "desc: \"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\"",
									Start: ast.Position{
										Column: 9,
										Line:   22,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   22,
										},
										File:   "sample.flux",
										Source: "desc",
										Start: ast.Position{
											Column: 9,
											Line:   22,
										},
									},
								},
								Name: "desc",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 190,
											Line:   22,
										},
										File:   "sample.flux",
										Source: "\"Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.\"",
										Start: ast.Position{
											Column: 15,
											Line:   22,
										},
									},
								},
								Value: "Latest observations from the NOAA National Data Buoy Center (NDBC). Contains only the most recent observations (no historical data). Data is updated approximately every 15m.",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   23,
									},
									File:   "sample.flux",
									Source: "size: \"~1.3 MB\"",
									Start: ast.Position{
										Column: 9,
										Line:   23,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   23,
										},
										File:   "sample.flux",
										Source: "size",
										Start: ast.Position{
											Column: 9,
											Line:   23,
										},
									},
								},
								Name: "size",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   23,
										},
										File:   "sample.flux",
										Source: "\"~1.3 MB\"",
										Start: ast.Position{
											Column: 15,
											Line:   23,
										},
									},
								},
								Value: "~1.3 MB",
							},
						}},
						Rbrace: nil,
						With:   nil,
					},
				}, &ast.DictItem{
					Comma: nil,
					Key: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   25,
								},
								File:   "sample.flux",
								Source: "\"usgs\"",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						Value: "usgs",
					},
					Val: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   29,
								},
								File:   "sample.flux",
								Source: "{\n        url: \"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\",\n        desc: \"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\",\n        size: \"~6 MB\",\n    }",
								Start: ast.Position{
									Column: 13,
									Line:   25,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   26,
									},
									File:   "sample.flux",
									Source: "url: \"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\"",
									Start: ast.Position{
										Column: 9,
										Line:   26,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   26,
										},
										File:   "sample.flux",
										Source: "url",
										Start: ast.Position{
											Column: 9,
											Line:   26,
										},
									},
								},
								Name: "url",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   26,
										},
										File:   "sample.flux",
										Source: "\"https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv\"",
										Start: ast.Position{
											Column: 14,
											Line:   26,
										},
									},
								},
								Value: "https://influx-testdata.s3.amazonaws.com/usgs-earthquake-all-week-annotated.csv",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 178,
										Line:   27,
									},
									File:   "sample.flux",
									Source: "desc: \"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\"",
									Start: ast.Position{
										Column: 9,
										Line:   27,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   27,
										},
										File:   "sample.flux",
										Source: "desc",
										Start: ast.Position{
											Column: 9,
											Line:   27,
										},
									},
								},
								Name: "desc",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 178,
											Line:   27,
										},
										File:   "sample.flux",
										Source: "\"USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.\"",
										Start: ast.Position{
											Column: 15,
											Line:   27,
										},
									},
								},
								Value: "USGS earthquake data from the last week. Contains geotemporal data collected from USGS seismic sensors around the world. Data is updated approximately every 15m.",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   28,
									},
									File:   "sample.flux",
									Source: "size: \"~6 MB\"",
									Start: ast.Position{
										Column: 9,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   28,
										},
										File:   "sample.flux",
										Source: "size",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Name: "size",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   28,
										},
										File:   "sample.flux",
										Source: "\"~6 MB\"",
										Start: ast.Position{
											Column: 15,
											Line:   28,
										},
									},
								},
								Value: "~6 MB",
							},
						}},
						Rbrace: nil,
						With:   nil,
					},
				}},
				Lbrack: nil,
				Rbrack: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "sample.flux",
					Source: "_setInfo = (set) => {\n    _setDict = dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})\n\n    return {name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}\n}",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   32,
						},
						File:   "sample.flux",
						Source: "_setInfo",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "_setInfo",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "sample.flux",
						Source: "(set) => {\n    _setDict = dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})\n\n    return {name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}\n}",
						Start: ast.Position{
							Column: 12,
							Line:   32,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   36,
							},
							File:   "sample.flux",
							Source: "{\n    _setDict = dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})\n\n    return {name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}\n}",
							Start: ast.Position{
								Column: 21,
								Line:   32,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   33,
								},
								File:   "sample.flux",
								Source: "_setDict = dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})",
								Start: ast.Position{
									Column: 5,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   33,
									},
									File:   "sample.flux",
									Source: "_setDict",
									Start: ast.Position{
										Column: 5,
										Line:   33,
									},
								},
							},
							Name: "_setDict",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   33,
										},
										File:   "sample.flux",
										Source: "dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"}",
										Start: ast.Position{
											Column: 25,
											Line:   33,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   33,
											},
											File:   "sample.flux",
											Source: "dict: sets",
											Start: ast.Position{
												Column: 25,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "dict",
												Start: ast.Position{
													Column: 25,
													Line:   33,
												},
											},
										},
										Name: "dict",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "sets",
												Start: ast.Position{
													Column: 31,
													Line:   33,
												},
											},
										},
										Name: "sets",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   33,
											},
											File:   "sample.flux",
											Source: "key: set",
											Start: ast.Position{
												Column: 37,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "key",
												Start: ast.Position{
													Column: 37,
													Line:   33,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "set",
												Start: ast.Position{
													Column: 42,
													Line:   33,
												},
											},
										},
										Name: "set",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   33,
											},
											File:   "sample.flux",
											Source: "default: {url: \"\", desc: \"\", size: \"\"}",
											Start: ast.Position{
												Column: 47,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "default",
												Start: ast.Position{
													Column: 47,
													Line:   33,
												},
											},
										},
										Name: "default",
									},
									Separator: nil,
									Value: &ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   33,
												},
												File:   "sample.flux",
												Source: "{url: \"\", desc: \"\", size: \"\"}",
												Start: ast.Position{
													Column: 56,
													Line:   33,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   33,
													},
													File:   "sample.flux",
													Source: "url: \"\"",
													Start: ast.Position{
														Column: 57,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "url",
														Start: ast.Position{
															Column: 57,
															Line:   33,
														},
													},
												},
												Name: "url",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 62,
															Line:   33,
														},
													},
												},
												Value: "",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   33,
													},
													File:   "sample.flux",
													Source: "desc: \"\"",
													Start: ast.Position{
														Column: 66,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "desc",
														Start: ast.Position{
															Column: 66,
															Line:   33,
														},
													},
												},
												Name: "desc",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 72,
															Line:   33,
														},
													},
												},
												Value: "",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   33,
													},
													File:   "sample.flux",
													Source: "size: \"\"",
													Start: ast.Position{
														Column: 76,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "size",
														Start: ast.Position{
															Column: 76,
															Line:   33,
														},
													},
												},
												Name: "size",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   33,
														},
														File:   "sample.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 82,
															Line:   33,
														},
													},
												},
												Value: "",
											},
										}},
										Rbrace: nil,
										With:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   33,
									},
									File:   "sample.flux",
									Source: "dict.get(dict: sets, key: set, default: {url: \"\", desc: \"\", size: \"\"})",
									Start: ast.Position{
										Column: 16,
										Line:   33,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   33,
										},
										File:   "sample.flux",
										Source: "dict.get",
										Start: ast.Position{
											Column: 16,
											Line:   33,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   33,
											},
											File:   "sample.flux",
											Source: "dict",
											Start: ast.Position{
												Column: 16,
												Line:   33,
											},
										},
									},
									Name: "dict",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   33,
											},
											File:   "sample.flux",
											Source: "get",
											Start: ast.Position{
												Column: 21,
												Line:   33,
											},
										},
									},
									Name: "get",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   35,
									},
									File:   "sample.flux",
									Source: "{name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   35,
										},
										File:   "sample.flux",
										Source: "name: set",
										Start: ast.Position{
											Column: 13,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "name",
											Start: ast.Position{
												Column: 13,
												Line:   35,
											},
										},
									},
									Name: "name",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "set",
											Start: ast.Position{
												Column: 19,
												Line:   35,
											},
										},
									},
									Name: "set",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   35,
										},
										File:   "sample.flux",
										Source: "description: _setDict.desc",
										Start: ast.Position{
											Column: 24,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "description",
											Start: ast.Position{
												Column: 24,
												Line:   35,
											},
										},
									},
									Name: "description",
								},
								Separator: nil,
								Value: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "_setDict.desc",
											Start: ast.Position{
												Column: 37,
												Line:   35,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "_setDict",
												Start: ast.Position{
													Column: 37,
													Line:   35,
												},
											},
										},
										Name: "_setDict",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 46,
													Line:   35,
												},
											},
										},
										Name: "desc",
									},
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   35,
										},
										File:   "sample.flux",
										Source: "url: _setDict.url",
										Start: ast.Position{
											Column: 52,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "url",
											Start: ast.Position{
												Column: 52,
												Line:   35,
											},
										},
									},
									Name: "url",
								},
								Separator: nil,
								Value: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "_setDict.url",
											Start: ast.Position{
												Column: 57,
												Line:   35,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "_setDict",
												Start: ast.Position{
													Column: 57,
													Line:   35,
												},
											},
										},
										Name: "_setDict",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "url",
												Start: ast.Position{
													Column: 66,
													Line:   35,
												},
											},
										},
										Name: "url",
									},
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   35,
										},
										File:   "sample.flux",
										Source: "size: _setDict.size",
										Start: ast.Position{
											Column: 71,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "size",
											Start: ast.Position{
												Column: 71,
												Line:   35,
											},
										},
									},
									Name: "size",
								},
								Separator: nil,
								Value: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   35,
											},
											File:   "sample.flux",
											Source: "_setDict.size",
											Start: ast.Position{
												Column: 77,
												Line:   35,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "_setDict",
												Start: ast.Position{
													Column: 77,
													Line:   35,
												},
											},
										},
										Name: "_setDict",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   35,
												},
												File:   "sample.flux",
												Source: "size",
												Start: ast.Position{
													Column: 86,
													Line:   35,
												},
											},
										},
										Name: "size",
									},
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   35,
								},
								File:   "sample.flux",
								Source: "return {name: set, description: _setDict.desc, url: _setDict.url, size: _setDict.size}",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   32,
							},
							File:   "sample.flux",
							Source: "set",
							Start: ast.Position{
								Column: 13,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   32,
								},
								File:   "sample.flux",
								Source: "set",
								Start: ast.Position{
									Column: 13,
									Line:   32,
								},
							},
						},
						Name: "set",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   65,
					},
					File:   "sample.flux",
					Source: "data = (set) => {\n    setInfo = _setInfo(set: set)\n\n    url = if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url\n\n    return csv.from(url: url)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   56,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// data downloads a specified InfluxDB sample dataset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `set` is the sample data set to download and output. Valid datasets:\n"}, ast.Comment{Text: "//    - **airSensor**: Simulated temperature, humidity, and CO data from an office building.\n"}, ast.Comment{Text: "//    - **birdMigration**: 2019 African bird migration data from [Movebank: Animal Tracking](https://www.kaggle.com/pulkit8595/movebank-animal-tracking).\n"}, ast.Comment{Text: "//    - **noaa**: Latest observations from the [NOAA National Data Buoy Center (NDBC)](https://www.ndbc.noaa.gov/).\n"}, ast.Comment{Text: "//    - **usgs**: USGS earthquake data from the last week.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Load InfluxDB sample data\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/sample\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sample.data(set: \"airSensor\")\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   56,
						},
						File:   "sample.flux",
						Source: "data",
						Start: ast.Position{
							Column: 1,
							Line:   56,
						},
					},
				},
				Name: "data",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   65,
						},
						File:   "sample.flux",
						Source: "(set) => {\n    setInfo = _setInfo(set: set)\n\n    url = if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url\n\n    return csv.from(url: url)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   56,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   65,
							},
							File:   "sample.flux",
							Source: "{\n    setInfo = _setInfo(set: set)\n\n    url = if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url\n\n    return csv.from(url: url)\n}",
							Start: ast.Position{
								Column: 17,
								Line:   56,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   57,
								},
								File:   "sample.flux",
								Source: "setInfo = _setInfo(set: set)",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   57,
									},
									File:   "sample.flux",
									Source: "setInfo",
									Start: ast.Position{
										Column: 5,
										Line:   57,
									},
								},
							},
							Name: "setInfo",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   57,
										},
										File:   "sample.flux",
										Source: "set: set",
										Start: ast.Position{
											Column: 24,
											Line:   57,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   57,
											},
											File:   "sample.flux",
											Source: "set: set",
											Start: ast.Position{
												Column: 24,
												Line:   57,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   57,
												},
												File:   "sample.flux",
												Source: "set",
												Start: ast.Position{
													Column: 24,
													Line:   57,
												},
											},
										},
										Name: "set",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   57,
												},
												File:   "sample.flux",
												Source: "set",
												Start: ast.Position{
													Column: 29,
													Line:   57,
												},
											},
										},
										Name: "set",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   57,
									},
									File:   "sample.flux",
									Source: "_setInfo(set: set)",
									Start: ast.Position{
										Column: 15,
										Line:   57,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   57,
										},
										File:   "sample.flux",
										Source: "_setInfo",
										Start: ast.Position{
											Column: 15,
											Line:   57,
										},
									},
								},
								Name: "_setInfo",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   62,
								},
								File:   "sample.flux",
								Source: "url = if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   59,
									},
									File:   "sample.flux",
									Source: "url",
									Start: ast.Position{
										Column: 5,
										Line:   59,
									},
								},
							},
							Name: "url",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   62,
										},
										File:   "sample.flux",
										Source: "setInfo.url",
										Start: ast.Position{
											Column: 9,
											Line:   62,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   62,
											},
											File:   "sample.flux",
											Source: "setInfo",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Name: "setInfo",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   62,
											},
											File:   "sample.flux",
											Source: "url",
											Start: ast.Position{
												Column: 17,
												Line:   62,
											},
										},
									},
									Name: "url",
								},
								Rbrack: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   62,
									},
									File:   "sample.flux",
									Source: "if setInfo.url == \"\" then\n        die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")\n    else\n        setInfo.url",
									Start: ast.Position{
										Column: 11,
										Line:   59,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   60,
											},
											File:   "sample.flux",
											Source: "msg: \"Invalid sample data set. Use sample.list to view available datasets.\"",
											Start: ast.Position{
												Column: 13,
												Line:   60,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   60,
												},
												File:   "sample.flux",
												Source: "msg: \"Invalid sample data set. Use sample.list to view available datasets.\"",
												Start: ast.Position{
													Column: 13,
													Line:   60,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   60,
													},
													File:   "sample.flux",
													Source: "msg",
													Start: ast.Position{
														Column: 13,
														Line:   60,
													},
												},
											},
											Name: "msg",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   60,
													},
													File:   "sample.flux",
													Source: "\"Invalid sample data set. Use sample.list to view available datasets.\"",
													Start: ast.Position{
														Column: 18,
														Line:   60,
													},
												},
											},
											Value: "Invalid sample data set. Use sample.list to view available datasets.",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   60,
										},
										File:   "sample.flux",
										Source: "die(msg: \"Invalid sample data set. Use sample.list to view available datasets.\")",
										Start: ast.Position{
											Column: 9,
											Line:   60,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   60,
											},
											File:   "sample.flux",
											Source: "die",
											Start: ast.Position{
												Column: 9,
												Line:   60,
											},
										},
									},
									Name: "die",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   59,
										},
										File:   "sample.flux",
										Source: "setInfo.url == \"\"",
										Start: ast.Position{
											Column: 14,
											Line:   59,
										},
									},
								},
								Left: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   59,
											},
											File:   "sample.flux",
											Source: "setInfo.url",
											Start: ast.Position{
												Column: 14,
												Line:   59,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   59,
												},
												File:   "sample.flux",
												Source: "setInfo",
												Start: ast.Position{
													Column: 14,
													Line:   59,
												},
											},
										},
										Name: "setInfo",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   59,
												},
												File:   "sample.flux",
												Source: "url",
												Start: ast.Position{
													Column: 22,
													Line:   59,
												},
											},
										},
										Name: "url",
									},
									Rbrack: nil,
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   59,
											},
											File:   "sample.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 29,
												Line:   59,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   64,
										},
										File:   "sample.flux",
										Source: "url: url",
										Start: ast.Position{
											Column: 21,
											Line:   64,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   64,
											},
											File:   "sample.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 21,
												Line:   64,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   64,
												},
												File:   "sample.flux",
												Source: "url",
												Start: ast.Position{
													Column: 21,
													Line:   64,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   64,
												},
												File:   "sample.flux",
												Source: "url",
												Start: ast.Position{
													Column: 26,
													Line:   64,
												},
											},
										},
										Name: "url",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   64,
									},
									File:   "sample.flux",
									Source: "csv.from(url: url)",
									Start: ast.Position{
										Column: 12,
										Line:   64,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   64,
										},
										File:   "sample.flux",
										Source: "csv.from",
										Start: ast.Position{
											Column: 12,
											Line:   64,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   64,
											},
											File:   "sample.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 12,
												Line:   64,
											},
										},
									},
									Name: "csv",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   64,
											},
											File:   "sample.flux",
											Source: "from",
											Start: ast.Position{
												Column: 16,
												Line:   64,
											},
										},
									},
									Name: "from",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   64,
								},
								File:   "sample.flux",
								Source: "return csv.from(url: url)",
								Start: ast.Position{
									Column: 5,
									Line:   64,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   56,
							},
							File:   "sample.flux",
							Source: "set",
							Start: ast.Position{
								Column: 9,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   56,
								},
								File:   "sample.flux",
								Source: "set",
								Start: ast.Position{
									Column: 9,
									Line:   56,
								},
							},
						},
						Name: "set",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   84,
					},
					File:   "sample.flux",
					Source: "list = () => array.from(\n    rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ],\n)",
					Start: ast.Position{
						Column: 1,
						Line:   77,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// list outputs information about available InfluxDB sample datasets.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## List available InfluxDB sample datasets\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/sample\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sample.list()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   77,
						},
						File:   "sample.flux",
						Source: "list",
						Start: ast.Position{
							Column: 1,
							Line:   77,
						},
					},
				},
				Name: "list",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   84,
						},
						File:   "sample.flux",
						Source: "() => array.from(\n    rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ],\n)",
						Start: ast.Position{
							Column: 8,
							Line:   77,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   83,
								},
								File:   "sample.flux",
								Source: "rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ]",
								Start: ast.Position{
									Column: 5,
									Line:   78,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   83,
									},
									File:   "sample.flux",
									Source: "rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ]",
									Start: ast.Position{
										Column: 5,
										Line:   78,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   78,
										},
										File:   "sample.flux",
										Source: "rows",
										Start: ast.Position{
											Column: 5,
											Line:   78,
										},
									},
								},
								Name: "rows",
							},
							Separator: nil,
							Value: &ast.ArrayExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   83,
										},
										File:   "sample.flux",
										Source: "[\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ]",
										Start: ast.Position{
											Column: 11,
											Line:   78,
										},
									},
								},
								Elements: []ast.Expression{&ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   79,
												},
												File:   "sample.flux",
												Source: "set: \"airSensor\"",
												Start: ast.Position{
													Column: 18,
													Line:   79,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   79,
													},
													File:   "sample.flux",
													Source: "set: \"airSensor\"",
													Start: ast.Position{
														Column: 18,
														Line:   79,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   79,
														},
														File:   "sample.flux",
														Source: "set",
														Start: ast.Position{
															Column: 18,
															Line:   79,
														},
													},
												},
												Name: "set",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   79,
														},
														File:   "sample.flux",
														Source: "\"airSensor\"",
														Start: ast.Position{
															Column: 23,
															Line:   79,
														},
													},
												},
												Value: "airSensor",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   79,
											},
											File:   "sample.flux",
											Source: "_setInfo(set: \"airSensor\")",
											Start: ast.Position{
												Column: 9,
												Line:   79,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   79,
												},
												File:   "sample.flux",
												Source: "_setInfo",
												Start: ast.Position{
													Column: 9,
													Line:   79,
												},
											},
										},
										Name: "_setInfo",
									},
									Lparen: nil,
									Rparen: nil,
								}, &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   80,
												},
												File:   "sample.flux",
												Source: "set: \"birdMigration\"",
												Start: ast.Position{
													Column: 18,
													Line:   80,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   80,
													},
													File:   "sample.flux",
													Source: "set: \"birdMigration\"",
													Start: ast.Position{
														Column: 18,
														Line:   80,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   80,
														},
														File:   "sample.flux",
														Source: "set",
														Start: ast.Position{
															Column: 18,
															Line:   80,
														},
													},
												},
												Name: "set",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   80,
														},
														File:   "sample.flux",
														Source: "\"birdMigration\"",
														Start: ast.Position{
															Column: 23,
															Line:   80,
														},
													},
												},
												Value: "birdMigration",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   80,
											},
											File:   "sample.flux",
											Source: "_setInfo(set: \"birdMigration\")",
											Start: ast.Position{
												Column: 9,
												Line:   80,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   80,
												},
												File:   "sample.flux",
												Source: "_setInfo",
												Start: ast.Position{
													Column: 9,
													Line:   80,
												},
											},
										},
										Name: "_setInfo",
									},
									Lparen: nil,
									Rparen: nil,
								}, &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   81,
												},
												File:   "sample.flux",
												Source: "set: \"noaa\"",
												Start: ast.Position{
													Column: 18,
													Line:   81,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   81,
													},
													File:   "sample.flux",
													Source: "set: \"noaa\"",
													Start: ast.Position{
														Column: 18,
														Line:   81,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   81,
														},
														File:   "sample.flux",
														Source: "set",
														Start: ast.Position{
															Column: 18,
															Line:   81,
														},
													},
												},
												Name: "set",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   81,
														},
														File:   "sample.flux",
														Source: "\"noaa\"",
														Start: ast.Position{
															Column: 23,
															Line:   81,
														},
													},
												},
												Value: "noaa",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   81,
											},
											File:   "sample.flux",
											Source: "_setInfo(set: \"noaa\")",
											Start: ast.Position{
												Column: 9,
												Line:   81,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   81,
												},
												File:   "sample.flux",
												Source: "_setInfo",
												Start: ast.Position{
													Column: 9,
													Line:   81,
												},
											},
										},
										Name: "_setInfo",
									},
									Lparen: nil,
									Rparen: nil,
								}, &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   82,
												},
												File:   "sample.flux",
												Source: "set: \"usgs\"",
												Start: ast.Position{
													Column: 18,
													Line:   82,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   82,
													},
													File:   "sample.flux",
													Source: "set: \"usgs\"",
													Start: ast.Position{
														Column: 18,
														Line:   82,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   82,
														},
														File:   "sample.flux",
														Source: "set",
														Start: ast.Position{
															Column: 18,
															Line:   82,
														},
													},
												},
												Name: "set",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   82,
														},
														File:   "sample.flux",
														Source: "\"usgs\"",
														Start: ast.Position{
															Column: 23,
															Line:   82,
														},
													},
												},
												Value: "usgs",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   82,
											},
											File:   "sample.flux",
											Source: "_setInfo(set: \"usgs\")",
											Start: ast.Position{
												Column: 9,
												Line:   82,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   82,
												},
												File:   "sample.flux",
												Source: "_setInfo",
												Start: ast.Position{
													Column: 9,
													Line:   82,
												},
											},
										},
										Name: "_setInfo",
									},
									Lparen: nil,
									Rparen: nil,
								}},
								Lbrack: nil,
								Rbrack: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   84,
							},
							File:   "sample.flux",
							Source: "array.from(\n    rows: [\n        _setInfo(set: \"airSensor\"),\n        _setInfo(set: \"birdMigration\"),\n        _setInfo(set: \"noaa\"),\n        _setInfo(set: \"usgs\"),\n    ],\n)",
							Start: ast.Position{
								Column: 14,
								Line:   77,
							},
						},
					},
					Callee: &ast.MemberExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   77,
								},
								File:   "sample.flux",
								Source: "array.from",
								Start: ast.Position{
									Column: 14,
									Line:   77,
								},
							},
						},
						Lbrack: nil,
						Object: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   77,
									},
									File:   "sample.flux",
									Source: "array",
									Start: ast.Position{
										Column: 14,
										Line:   77,
									},
								},
							},
							Name: "array",
						},
						Property: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   77,
									},
									File:   "sample.flux",
									Source: "from",
									Start: ast.Position{
										Column: 20,
										Line:   77,
									},
								},
							},
							Name: "from",
						},
						Rbrack: nil,
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   5,
					},
					File:   "sample.flux",
					Source: "import \"array\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   5,
						},
						File:   "sample.flux",
						Source: "\"array\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "array",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "sample.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "sample.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "dict",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   7,
					},
					File:   "sample.flux",
					Source: "import \"experimental/csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   7,
						},
						File:   "sample.flux",
						Source: "\"experimental/csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental/csv",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "sample.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package sample provides functions for downloading and ouputting InfluxDB sample datasets.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   2,
					},
					File:   "sample.flux",
					Source: "package sample",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   2,
						},
						File:   "sample.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "sample",
			},
		},
	}},
	Package: "sample",
	Path:    "influxdata/influxdb/sample",
}
