// DO NOT EDIT: This file is autogenerated via the builtin command.

package testing

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   350,
				},
				File:   "testing.flux",
				Source: "package testing\n\n\nimport c \"csv\"\n\n// assertEquals tests whether two streams have identical data.\n//\n//      If equal, the function outputs the tested data stream unchanged.\n//      If unequal, the function returns an error.\n//\n// assertEquals can be used to perform in-line tests in a query.\n//\n// ## Parameters\n// - `name` is the unique name given to the assertion.\n// - `got` is the stream containing data to test. Defaults to piped-forward data (<-).\n// - `want` is the stream that contains the expected data to test against.\n//\n// ## Assert of separate streams\n// ```\n// import \"testing\"\n//\n// want = from(bucket: \"backup-example-bucket\")\n//   |> range(start: -5m)\n//\n// got = from(bucket: \"example-bucket\")\n//   |> range(start: -5m)\n//\n// testing.assertEquals(got: got, want: want)\n// ```\n//\n// ## Inline assertion\n// ```\n// import \"testing\"\n//\n// want = from(bucket: \"backup-example-bucket\")\n//   |> range(start: -5m)\n//\n// from(bucket: \"example-bucket\")\n//   |> range(start: -5m)\n//   |> testing.assertEquals(want: want)\n// ```\n//\nbuiltin assertEquals : (name: string, <-got: [A], want: [A]) => [A]\n\n// assertEmpty tests if an input stream is empty. If not empty, the function returns an error.\n// assertEmpty can be used to perform in-line tests in a query.\n//\n// ## Check if there is a difference between streams\n//\n//      This example uses the testing.diff() function which outputs the diff for the two streams.\n//      The .testing.assertEmpty() function checks to see if the diff is empty.\n//\n// ```\n// import \"testing\"\n//\n// got = from(bucket: \"example-bucket\")\n//   |> range(start: -15m)\n// want = from(bucket: \"backup_example-bucket\")\n//   |> range(start: -15m)\n// got\n//   |> testing.diff(want: want)\n//   |> testing.assertEmpty()\n// ```\n//\nbuiltin assertEmpty : (<-tables: [A]) => [A]\n\n// diff produces a diff between two streams.\n//\n// It matches tables from each stream with the same group keys.\n//\n//      For each matched table, it produces a diff. Any added or removed rows are added to the table as a row.\n//      An additional string column with the name diff is created and contains a\n//      - if the row was present in the got table and not in the want table or + if the opposite is true.\n//\n// The diff function is guaranteed to emit at least one row if the tables are different and no rows if the tables are the same. The exact diff produced may change.\n// diff can be used to perform in-line diffs in a query.\n//\n// ## Parameters\n// - `got` is the stream containing data to test. Defaults to piped-forward data (<-).\n// - `want` is the stream that contains the expected data to test against.\n// - `epsilon` specifies how far apart two float values can be, but still considered equal. Defaults to 0.000000001.\n//\n// ## Diff separate streams\n// ```\n// import \"testing\"\n//\n// want = from(bucket: \"backup-example-bucket\")\n//   |> range(start: -5m)\n// got = from(bucket: \"example-bucket\")\n//   |> range(start: -5m)\n// testing.diff(got: got, want: want)\n// ```\n//\n// ## Inline diff\n// ```\n// import \"testing\"\n//\n// want = from(bucket: \"backup-example-bucket\") |> range(start: -5m)\n// from(bucket: \"example-bucket\")\n//   |> range(start: -5m)\n//   |> testing.diff(want: want)\n// ```\n//\nbuiltin diff : (\n    <-got: [A],\n    want: [A],\n    ?verbose: bool,\n    ?epsilon: float,\n    ?nansEqual: bool,\n) => [{A with _diff: string}]\n\n// loadStorage loads annotated CSV test data as if it were queried from InfluxDB.\n// This function ensures tests behave correctly in both the Flux and InfluxDB test suites.\n//\n// ## Function Requirements\n// - Test data requires the _field, _measurement, and _time columns\n//\n// ## Parameters\n// - `csv` is the annotated CSV data to load\n//\n// ## Examples\n// ```\n// import \"testing\"\n//\n// csvData = \"\n// #datatype,string,long,string,dateTime:RFC3339,string,double\n// #group,false,false,true,false,true,false\n// #default,_result,,,,,\n// ,result,table,_measurement,_time,_field,_value\n// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n// \"\n//\n// testing.loadStorage(csv: csvData)\n// ```\n//\noption loadStorage = (csv) => c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)\n    |> map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )\n\n// load loads tests data from a stream of tables.\n//\n// ## Parameters\n// - `tables` is the input data. Default is piped-forward data (<-).\n//\n// ## Load a raw stream of tables in a test case\n//\n//      The following test uses array.from() to create two streams of tables to compare in the test.\n//\n// ```\n// import \"testing\"\n// import \"array\"\n//\n// got = array.from(rows: [\n//   {_time: 2021-01-01T00:00:00Z, _measurement: \"m\", _field: \"t\", _value: 1.2},\n//   {_time: 2021-01-01T01:00:00Z, _measurement: \"m\", _field: \"t\", _value: 0.8},\n//   {_time: 2021-01-01T02:00:00Z, _measurement: \"m\", _field: \"t\", _value: 3.2}\n// ])\n//\n// want = array.from(rows: [\n//   {_time: 2021-01-01T00:00:00Z, _measurement: \"m\", _field: \"t\", _value: 1.2},\n//   {_time: 2021-01-01T01:00:00Z, _measurement: \"m\", _field: \"t\", _value: 0.8},\n//   {_time: 2021-01-01T02:00:00Z, _measurement: \"m\", _field: \"t\", _value: 3.1}\n// ])\n//\n// testing.diff(got, want)\n// ```\n//\noption load = (tables=<-) => tables\n\n// loadMem loads annotated CSV test data from memory to emulate query results returned by Flux.\n//\n// ## Parameters\n// - `csv` is the annotated CSV data to load.\n//\n// ## Examples\n// ```\n// import \"testing\"\n//\n// csvData = \"\n// #datatype,string,long,string,dateTime:RFC3339,string,double\n// #group,false,false,true,false,true,false\n// #default,_result,,,,,\n// ,result,table,_measurement,_time,_field,_value\n// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n// \"\n//\n// testing.loadMem(csv: csvData)\n// ```\noption loadMem = (csv) => c.from(csv: csv)\n\n// inspect returns information about a test case.\n//\n// ## Parameters\n// - `case` is the test case to inspect.\n//\n// ## Define and inspect a test case\n// ```\n// import \"testing\"\n//\n// inData = \"\n// #datatype,string,long,string,dateTime:RFC3339,string,double\n// #group,false,false,true,false,true,false\n// #default,_result,,,,,\n// ,result,table,_measurement,_time,_field,_value\n// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n// \"\n//\n// outData = \"\n// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n// #group,false,false,true,true,true,true,false\n// #default,_result,,,,,,\n// ,result,table,_start,_stop,_measurement,_field,_value\n// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n// \"\n//\n// t_sum = (table=<-) =>\n//   (table\n//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n//     |> sum())\n//\n// test _sum = () =>\n//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n//\n// testing.inpsect(case: _sum)\n//\n// // Returns: {\n// //   fn: (<-table: [{_time: time | t10997}]) -> [t10996],\n// //   input: fromCSV -> range -> map,\n// //   want: fromCSV -> yield,\n// //   got: fromCSV -> range -> map -> range -> sum -> yield,\n// //   diff: ( fromCSV; fromCSV -> range -> map -> range -> sum;  ) -> diff -> yield\n// // }\n// ```\ninspect = (case) => {\n    tc = case()\n    got = tc.input |> tc.fn()\n    dif = got |> diff(want: tc.want)\n\n    return {\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }\n}\n\n// run executes a specified test case.\n//\n// ## Parameters\n// - `case` is the test case to run.\n//\n// ## Define and execute a test case\n// ```\n// import \"testing\"\n//\n// inData = \"\n// #datatype,string,long,string,dateTime:RFC3339,string,double\n// #group,false,false,true,false,true,false\n// #default,_result,,,,,\n// ,result,table,_measurement,_time,_field,_value\n// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n// \"\n//\n// outData = \"\n// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n// #group,false,false,true,true,true,true,false\n// #default,_result,,,,,,\n// ,result,table,_start,_stop,_measurement,_field,_value\n// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n// \"\n//\n// t_sum = (table=<-) =>\n//   (table\n//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n//     |> sum())\n//\n// test _sum = () =>\n//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n//\n// testing.run(case: _sum)\n// ```\nrun = (case) => {\n    return inspect(case: case).diff |> assertEmpty()\n}\n\n// benchmark executes a test case without comparing test output with the expected test output.\n// This lets you accurately benchmark a test case without the added overhead of comparing test output that occurs in testing.run().\n//\n// ## Parameters\n// - `case` is the test case to benchmark.\n//\n// ## Define and benchmark a test case\n//\n//      The following script defines a test case for the sum() function and enables profilers to measure query performance.\n//\n// ```\n// import \"testing\"\n// import \"profiler\"\n//\n// option profiler.enabledProfilers = [\"query\", \"operator\"]\n//\n// inData = \"\n// #datatype,string,long,string,dateTime:RFC3339,string,double\n// #group,false,false,true,false,true,false\n// #default,_result,,,,,\n// ,result,table,_measurement,_time,_field,_value\n// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n// \"\n//\n// outData = \"\n// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n// #group,false,false,true,true,true,true,false\n// #default,_result,,,,,,\n// ,result,table,_start,_stop,_measurement,_field,_value\n// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n// \"\n//\n// t_sum = (table=<-) =>\n//   (table\n//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n//     |> sum())\n//\n// test _sum = () =>\n//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n//\n// testing.benchmark(case: _sum)\n// ```\nbenchmark = (case) => {\n    tc = case()\n\n    return tc.input |> tc.fn()\n}",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// assertEquals tests whether two streams have identical data.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      If equal, the function outputs the tested data stream unchanged.\n"}, ast.Comment{Text: "//      If unequal, the function returns an error.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// assertEquals can be used to perform in-line tests in a query.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `name` is the unique name given to the assertion.\n"}, ast.Comment{Text: "// - `got` is the stream containing data to test. Defaults to piped-forward data (<-).\n"}, ast.Comment{Text: "// - `want` is the stream that contains the expected data to test against.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Assert of separate streams\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// want = from(bucket: \"backup-example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// got = from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.assertEquals(got: got, want: want)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Inline assertion\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// want = from(bucket: \"backup-example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//   |> testing.assertEquals(want: want)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   44,
					},
					File:   "testing.flux",
					Source: "builtin assertEquals",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   44,
						},
						File:   "testing.flux",
						Source: "assertEquals",
						Start: ast.Position{
							Column: 9,
							Line:   44,
						},
					},
				},
				Name: "assertEquals",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   44,
						},
						File:   "testing.flux",
						Source: "(name: string, <-got: [A], want: [A]) => [A]",
						Start: ast.Position{
							Column: 24,
							Line:   44,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   44,
							},
							File:   "testing.flux",
							Source: "(name: string, <-got: [A], want: [A]) => [A]",
							Start: ast.Position{
								Column: 24,
								Line:   44,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   44,
								},
								File:   "testing.flux",
								Source: "name: string",
								Start: ast.Position{
									Column: 25,
									Line:   44,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "name",
									Start: ast.Position{
										Column: 25,
										Line:   44,
									},
								},
							},
							Name: "name",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "string",
									Start: ast.Position{
										Column: 31,
										Line:   44,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   44,
										},
										File:   "testing.flux",
										Source: "string",
										Start: ast.Position{
											Column: 31,
											Line:   44,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   44,
								},
								File:   "testing.flux",
								Source: "<-got: [A]",
								Start: ast.Position{
									Column: 39,
									Line:   44,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "got",
									Start: ast.Position{
										Column: 41,
										Line:   44,
									},
								},
							},
							Name: "got",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 46,
										Line:   44,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   44,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 47,
											Line:   44,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   44,
											},
											File:   "testing.flux",
											Source: "A",
											Start: ast.Position{
												Column: 47,
												Line:   44,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   44,
								},
								File:   "testing.flux",
								Source: "want: [A]",
								Start: ast.Position{
									Column: 51,
									Line:   44,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "want",
									Start: ast.Position{
										Column: 51,
										Line:   44,
									},
								},
							},
							Name: "want",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 57,
										Line:   44,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   44,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 58,
											Line:   44,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   44,
											},
											File:   "testing.flux",
											Source: "A",
											Start: ast.Position{
												Column: 58,
												Line:   44,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   44,
								},
								File:   "testing.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 65,
									Line:   44,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   44,
									},
									File:   "testing.flux",
									Source: "A",
									Start: ast.Position{
										Column: 66,
										Line:   44,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   44,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 66,
											Line:   44,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// assertEmpty tests if an input stream is empty. If not empty, the function returns an error.\n"}, ast.Comment{Text: "// assertEmpty can be used to perform in-line tests in a query.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Check if there is a difference between streams\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      This example uses the testing.diff() function which outputs the diff for the two streams.\n"}, ast.Comment{Text: "//      The .testing.assertEmpty() function checks to see if the diff is empty.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// got = from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -15m)\n"}, ast.Comment{Text: "// want = from(bucket: \"backup_example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -15m)\n"}, ast.Comment{Text: "// got\n"}, ast.Comment{Text: "//   |> testing.diff(want: want)\n"}, ast.Comment{Text: "//   |> testing.assertEmpty()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   66,
					},
					File:   "testing.flux",
					Source: "builtin assertEmpty",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   66,
						},
						File:   "testing.flux",
						Source: "assertEmpty",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "assertEmpty",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   66,
						},
						File:   "testing.flux",
						Source: "(<-tables: [A]) => [A]",
						Start: ast.Position{
							Column: 23,
							Line:   66,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   66,
							},
							File:   "testing.flux",
							Source: "(<-tables: [A]) => [A]",
							Start: ast.Position{
								Column: 23,
								Line:   66,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   66,
								},
								File:   "testing.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 24,
									Line:   66,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   66,
									},
									File:   "testing.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   66,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   66,
									},
									File:   "testing.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 34,
										Line:   66,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   66,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 35,
											Line:   66,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   66,
											},
											File:   "testing.flux",
											Source: "A",
											Start: ast.Position{
												Column: 35,
												Line:   66,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   66,
								},
								File:   "testing.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 42,
									Line:   66,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   66,
									},
									File:   "testing.flux",
									Source: "A",
									Start: ast.Position{
										Column: 43,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   66,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 43,
											Line:   66,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// diff produces a diff between two streams.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// It matches tables from each stream with the same group keys.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      For each matched table, it produces a diff. Any added or removed rows are added to the table as a row.\n"}, ast.Comment{Text: "//      An additional string column with the name diff is created and contains a\n"}, ast.Comment{Text: "//      - if the row was present in the got table and not in the want table or + if the opposite is true.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The diff function is guaranteed to emit at least one row if the tables are different and no rows if the tables are the same. The exact diff produced may change.\n"}, ast.Comment{Text: "// diff can be used to perform in-line diffs in a query.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `got` is the stream containing data to test. Defaults to piped-forward data (<-).\n"}, ast.Comment{Text: "// - `want` is the stream that contains the expected data to test against.\n"}, ast.Comment{Text: "// - `epsilon` specifies how far apart two float values can be, but still considered equal. Defaults to 0.000000001.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Diff separate streams\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// want = from(bucket: \"backup-example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "// got = from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "// testing.diff(got: got, want: want)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Inline diff\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// want = from(bucket: \"backup-example-bucket\") |> range(start: -5m)\n"}, ast.Comment{Text: "// from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -5m)\n"}, ast.Comment{Text: "//   |> testing.diff(want: want)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   105,
					},
					File:   "testing.flux",
					Source: "builtin diff",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   105,
						},
						File:   "testing.flux",
						Source: "diff",
						Start: ast.Position{
							Column: 9,
							Line:   105,
						},
					},
				},
				Name: "diff",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   111,
						},
						File:   "testing.flux",
						Source: "(\n    <-got: [A],\n    want: [A],\n    ?verbose: bool,\n    ?epsilon: float,\n    ?nansEqual: bool,\n) => [{A with _diff: string}]",
						Start: ast.Position{
							Column: 16,
							Line:   105,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   111,
							},
							File:   "testing.flux",
							Source: "(\n    <-got: [A],\n    want: [A],\n    ?verbose: bool,\n    ?epsilon: float,\n    ?nansEqual: bool,\n) => [{A with _diff: string}]",
							Start: ast.Position{
								Column: 16,
								Line:   105,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   106,
								},
								File:   "testing.flux",
								Source: "<-got: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   106,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   106,
									},
									File:   "testing.flux",
									Source: "got",
									Start: ast.Position{
										Column: 7,
										Line:   106,
									},
								},
							},
							Name: "got",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   106,
									},
									File:   "testing.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 12,
										Line:   106,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   106,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 13,
											Line:   106,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   106,
											},
											File:   "testing.flux",
											Source: "A",
											Start: ast.Position{
												Column: 13,
												Line:   106,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   107,
								},
								File:   "testing.flux",
								Source: "want: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   107,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   107,
									},
									File:   "testing.flux",
									Source: "want",
									Start: ast.Position{
										Column: 5,
										Line:   107,
									},
								},
							},
							Name: "want",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   107,
									},
									File:   "testing.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 11,
										Line:   107,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   107,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 12,
											Line:   107,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   107,
											},
											File:   "testing.flux",
											Source: "A",
											Start: ast.Position{
												Column: 12,
												Line:   107,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   108,
								},
								File:   "testing.flux",
								Source: "?verbose: bool",
								Start: ast.Position{
									Column: 5,
									Line:   108,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   108,
									},
									File:   "testing.flux",
									Source: "verbose",
									Start: ast.Position{
										Column: 6,
										Line:   108,
									},
								},
							},
							Name: "verbose",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   108,
									},
									File:   "testing.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 15,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   108,
										},
										File:   "testing.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 15,
											Line:   108,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   109,
								},
								File:   "testing.flux",
								Source: "?epsilon: float",
								Start: ast.Position{
									Column: 5,
									Line:   109,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   109,
									},
									File:   "testing.flux",
									Source: "epsilon",
									Start: ast.Position{
										Column: 6,
										Line:   109,
									},
								},
							},
							Name: "epsilon",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   109,
									},
									File:   "testing.flux",
									Source: "float",
									Start: ast.Position{
										Column: 15,
										Line:   109,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   109,
										},
										File:   "testing.flux",
										Source: "float",
										Start: ast.Position{
											Column: 15,
											Line:   109,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   110,
								},
								File:   "testing.flux",
								Source: "?nansEqual: bool",
								Start: ast.Position{
									Column: 5,
									Line:   110,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   110,
									},
									File:   "testing.flux",
									Source: "nansEqual",
									Start: ast.Position{
										Column: 6,
										Line:   110,
									},
								},
							},
							Name: "nansEqual",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   110,
									},
									File:   "testing.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 17,
										Line:   110,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   110,
										},
										File:   "testing.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 17,
											Line:   110,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   111,
								},
								File:   "testing.flux",
								Source: "[{A with _diff: string}]",
								Start: ast.Position{
									Column: 6,
									Line:   111,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   111,
									},
									File:   "testing.flux",
									Source: "{A with _diff: string}",
									Start: ast.Position{
										Column: 7,
										Line:   111,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   111,
										},
										File:   "testing.flux",
										Source: "_diff: string",
										Start: ast.Position{
											Column: 15,
											Line:   111,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   111,
											},
											File:   "testing.flux",
											Source: "_diff",
											Start: ast.Position{
												Column: 15,
												Line:   111,
											},
										},
									},
									Name: "_diff",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   111,
											},
											File:   "testing.flux",
											Source: "string",
											Start: ast.Position{
												Column: 22,
												Line:   111,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   111,
												},
												File:   "testing.flux",
												Source: "string",
												Start: ast.Position{
													Column: 22,
													Line:   111,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   111,
										},
										File:   "testing.flux",
										Source: "A",
										Start: ast.Position{
											Column: 8,
											Line:   111,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   147,
						},
						File:   "testing.flux",
						Source: "loadStorage = (csv) => c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)\n    |> map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )",
						Start: ast.Position{
							Column: 8,
							Line:   139,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   139,
							},
							File:   "testing.flux",
							Source: "loadStorage",
							Start: ast.Position{
								Column: 8,
								Line:   139,
							},
						},
					},
					Name: "loadStorage",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   147,
							},
							File:   "testing.flux",
							Source: "(csv) => c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)\n    |> map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )",
							Start: ast.Position{
								Column: 22,
								Line:   139,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   139,
											},
											File:   "testing.flux",
											Source: "csv: csv",
											Start: ast.Position{
												Column: 38,
												Line:   139,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   139,
												},
												File:   "testing.flux",
												Source: "csv: csv",
												Start: ast.Position{
													Column: 38,
													Line:   139,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   139,
													},
													File:   "testing.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 38,
														Line:   139,
													},
												},
											},
											Name: "csv",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   139,
													},
													File:   "testing.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 43,
														Line:   139,
													},
												},
											},
											Name: "csv",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   139,
										},
										File:   "testing.flux",
										Source: "c.from(csv: csv)",
										Start: ast.Position{
											Column: 31,
											Line:   139,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   139,
											},
											File:   "testing.flux",
											Source: "c.from",
											Start: ast.Position{
												Column: 31,
												Line:   139,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   139,
												},
												File:   "testing.flux",
												Source: "c",
												Start: ast.Position{
													Column: 31,
													Line:   139,
												},
											},
										},
										Name: "c",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   139,
												},
												File:   "testing.flux",
												Source: "from",
												Start: ast.Position{
													Column: 33,
													Line:   139,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   140,
									},
									File:   "testing.flux",
									Source: "c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)",
									Start: ast.Position{
										Column: 31,
										Line:   139,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   140,
											},
											File:   "testing.flux",
											Source: "start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z",
											Start: ast.Position{
												Column: 14,
												Line:   140,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   140,
												},
												File:   "testing.flux",
												Source: "start: 1800-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   140,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   140,
													},
													File:   "testing.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   140,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   140,
													},
													File:   "testing.flux",
													Source: "1800-01-01T00:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   140,
													},
												},
											},
											Value: parser.MustParseTime("1800-01-01T00:00:00Z"),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   140,
												},
												File:   "testing.flux",
												Source: "stop: 2200-12-31T11:59:59Z",
												Start: ast.Position{
													Column: 43,
													Line:   140,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   140,
													},
													File:   "testing.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 43,
														Line:   140,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   140,
													},
													File:   "testing.flux",
													Source: "2200-12-31T11:59:59Z",
													Start: ast.Position{
														Column: 49,
														Line:   140,
													},
												},
											},
											Value: parser.MustParseTime("2200-12-31T11:59:59Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   140,
										},
										File:   "testing.flux",
										Source: "range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)",
										Start: ast.Position{
											Column: 8,
											Line:   140,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   140,
											},
											File:   "testing.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   140,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   147,
								},
								File:   "testing.flux",
								Source: "c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)\n    |> map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )",
								Start: ast.Position{
									Column: 31,
									Line:   139,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   146,
										},
										File:   "testing.flux",
										Source: "fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        })",
										Start: ast.Position{
											Column: 9,
											Line:   142,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   146,
											},
											File:   "testing.flux",
											Source: "fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   142,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   142,
												},
												File:   "testing.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 9,
													Line:   142,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   146,
												},
												File:   "testing.flux",
												Source: "(r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        })",
												Start: ast.Position{
													Column: 13,
													Line:   142,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   146,
													},
													File:   "testing.flux",
													Source: "({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        })",
													Start: ast.Position{
														Column: 20,
														Line:   142,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   146,
														},
														File:   "testing.flux",
														Source: "{r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }",
														Start: ast.Position{
															Column: 21,
															Line:   142,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 115,
																Line:   143,
															},
															File:   "testing.flux",
															Source: "_field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\")",
															Start: ast.Position{
																Column: 13,
																Line:   143,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   143,
																},
																File:   "testing.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 13,
																	Line:   143,
																},
															},
														},
														Name: "_field",
													},
													Separator: nil,
													Value: &ast.ConditionalExpression{
														Alternate: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 114,
																			Line:   143,
																		},
																		File:   "testing.flux",
																		Source: "msg: \"test input table does not have _field column\"",
																		Start: ast.Position{
																			Column: 63,
																			Line:   143,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 114,
																				Line:   143,
																			},
																			File:   "testing.flux",
																			Source: "msg: \"test input table does not have _field column\"",
																			Start: ast.Position{
																				Column: 63,
																				Line:   143,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   143,
																				},
																				File:   "testing.flux",
																				Source: "msg",
																				Start: ast.Position{
																					Column: 63,
																					Line:   143,
																				},
																			},
																		},
																		Name: "msg",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 114,
																					Line:   143,
																				},
																				File:   "testing.flux",
																				Source: "\"test input table does not have _field column\"",
																				Start: ast.Position{
																					Column: 68,
																					Line:   143,
																				},
																			},
																		},
																		Value: "test input table does not have _field column",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 115,
																		Line:   143,
																	},
																	File:   "testing.flux",
																	Source: "die(msg: \"test input table does not have _field column\")",
																	Start: ast.Position{
																		Column: 59,
																		Line:   143,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   143,
																		},
																		File:   "testing.flux",
																		Source: "die",
																		Start: ast.Position{
																			Column: 59,
																			Line:   143,
																		},
																	},
																},
																Name: "die",
															},
															Lparen: nil,
															Rparen: nil,
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 115,
																	Line:   143,
																},
																File:   "testing.flux",
																Source: "if exists r._field then r._field else die(msg: \"test input table does not have _field column\")",
																Start: ast.Position{
																	Column: 21,
																	Line:   143,
																},
															},
														},
														Consequent: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   143,
																	},
																	File:   "testing.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 45,
																		Line:   143,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   143,
																		},
																		File:   "testing.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 45,
																			Line:   143,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   143,
																		},
																		File:   "testing.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 47,
																			Line:   143,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Test: &ast.UnaryExpression{
															Argument: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   143,
																		},
																		File:   "testing.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 31,
																			Line:   143,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 32,
																				Line:   143,
																			},
																			File:   "testing.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 31,
																				Line:   143,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   143,
																			},
																			File:   "testing.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 33,
																				Line:   143,
																			},
																		},
																	},
																	Name: "_field",
																},
																Rbrack: nil,
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   143,
																	},
																	File:   "testing.flux",
																	Source: "exists r._field",
																	Start: ast.Position{
																		Column: 24,
																		Line:   143,
																	},
																},
															},
															Operator: 14,
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 139,
																Line:   144,
															},
															File:   "testing.flux",
															Source: "_measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\")",
															Start: ast.Position{
																Column: 13,
																Line:   144,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   144,
																},
																File:   "testing.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 13,
																	Line:   144,
																},
															},
														},
														Name: "_measurement",
													},
													Separator: nil,
													Value: &ast.ConditionalExpression{
														Alternate: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 138,
																			Line:   144,
																		},
																		File:   "testing.flux",
																		Source: "msg: \"test input table does not have _measurement column\"",
																		Start: ast.Position{
																			Column: 81,
																			Line:   144,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 138,
																				Line:   144,
																			},
																			File:   "testing.flux",
																			Source: "msg: \"test input table does not have _measurement column\"",
																			Start: ast.Position{
																				Column: 81,
																				Line:   144,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 84,
																					Line:   144,
																				},
																				File:   "testing.flux",
																				Source: "msg",
																				Start: ast.Position{
																					Column: 81,
																					Line:   144,
																				},
																			},
																		},
																		Name: "msg",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 138,
																					Line:   144,
																				},
																				File:   "testing.flux",
																				Source: "\"test input table does not have _measurement column\"",
																				Start: ast.Position{
																					Column: 86,
																					Line:   144,
																				},
																			},
																		},
																		Value: "test input table does not have _measurement column",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 139,
																		Line:   144,
																	},
																	File:   "testing.flux",
																	Source: "die(msg: \"test input table does not have _measurement column\")",
																	Start: ast.Position{
																		Column: 77,
																		Line:   144,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   144,
																		},
																		File:   "testing.flux",
																		Source: "die",
																		Start: ast.Position{
																			Column: 77,
																			Line:   144,
																		},
																	},
																},
																Name: "die",
															},
															Lparen: nil,
															Rparen: nil,
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 139,
																	Line:   144,
																},
																File:   "testing.flux",
																Source: "if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\")",
																Start: ast.Position{
																	Column: 27,
																	Line:   144,
																},
															},
														},
														Consequent: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   144,
																	},
																	File:   "testing.flux",
																	Source: "r._measurement",
																	Start: ast.Position{
																		Column: 57,
																		Line:   144,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   144,
																		},
																		File:   "testing.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 57,
																			Line:   144,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 71,
																			Line:   144,
																		},
																		File:   "testing.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 59,
																			Line:   144,
																		},
																	},
																},
																Name: "_measurement",
															},
															Rbrack: nil,
														},
														Test: &ast.UnaryExpression{
															Argument: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   144,
																		},
																		File:   "testing.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 37,
																			Line:   144,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   144,
																			},
																			File:   "testing.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 37,
																				Line:   144,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   144,
																			},
																			File:   "testing.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 39,
																				Line:   144,
																			},
																		},
																	},
																	Name: "_measurement",
																},
																Rbrack: nil,
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   144,
																	},
																	File:   "testing.flux",
																	Source: "exists r._measurement",
																	Start: ast.Position{
																		Column: 30,
																		Line:   144,
																	},
																},
															},
															Operator: 14,
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 111,
																Line:   145,
															},
															File:   "testing.flux",
															Source: "_time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\")",
															Start: ast.Position{
																Column: 13,
																Line:   145,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   145,
																},
																File:   "testing.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 13,
																	Line:   145,
																},
															},
														},
														Name: "_time",
													},
													Separator: nil,
													Value: &ast.ConditionalExpression{
														Alternate: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 110,
																			Line:   145,
																		},
																		File:   "testing.flux",
																		Source: "msg: \"test input table does not have _time column\"",
																		Start: ast.Position{
																			Column: 60,
																			Line:   145,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 110,
																				Line:   145,
																			},
																			File:   "testing.flux",
																			Source: "msg: \"test input table does not have _time column\"",
																			Start: ast.Position{
																				Column: 60,
																				Line:   145,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 63,
																					Line:   145,
																				},
																				File:   "testing.flux",
																				Source: "msg",
																				Start: ast.Position{
																					Column: 60,
																					Line:   145,
																				},
																			},
																		},
																		Name: "msg",
																	},
																	Separator: nil,
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 110,
																					Line:   145,
																				},
																				File:   "testing.flux",
																				Source: "\"test input table does not have _time column\"",
																				Start: ast.Position{
																					Column: 65,
																					Line:   145,
																				},
																			},
																		},
																		Value: "test input table does not have _time column",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 111,
																		Line:   145,
																	},
																	File:   "testing.flux",
																	Source: "die(msg: \"test input table does not have _time column\")",
																	Start: ast.Position{
																		Column: 56,
																		Line:   145,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   145,
																		},
																		File:   "testing.flux",
																		Source: "die",
																		Start: ast.Position{
																			Column: 56,
																			Line:   145,
																		},
																	},
																},
																Name: "die",
															},
															Lparen: nil,
															Rparen: nil,
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 111,
																	Line:   145,
																},
																File:   "testing.flux",
																Source: "if exists r._time then r._time else die(msg: \"test input table does not have _time column\")",
																Start: ast.Position{
																	Column: 20,
																	Line:   145,
																},
															},
														},
														Consequent: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   145,
																	},
																	File:   "testing.flux",
																	Source: "r._time",
																	Start: ast.Position{
																		Column: 43,
																		Line:   145,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   145,
																		},
																		File:   "testing.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 43,
																			Line:   145,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   145,
																		},
																		File:   "testing.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 45,
																			Line:   145,
																		},
																	},
																},
																Name: "_time",
															},
															Rbrack: nil,
														},
														Test: &ast.UnaryExpression{
															Argument: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   145,
																		},
																		File:   "testing.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 30,
																			Line:   145,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   145,
																			},
																			File:   "testing.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 30,
																				Line:   145,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   145,
																			},
																			File:   "testing.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 32,
																				Line:   145,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   145,
																	},
																	File:   "testing.flux",
																	Source: "exists r._time",
																	Start: ast.Position{
																		Column: 23,
																		Line:   145,
																	},
																},
															},
															Operator: 14,
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   142,
															},
															File:   "testing.flux",
															Source: "r",
															Start: ast.Position{
																Column: 22,
																Line:   142,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   142,
													},
													File:   "testing.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   142,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   142,
														},
														File:   "testing.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   142,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   147,
									},
									File:   "testing.flux",
									Source: "map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   141,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   141,
										},
										File:   "testing.flux",
										Source: "map",
										Start: ast.Position{
											Column: 8,
											Line:   141,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   139,
								},
								File:   "testing.flux",
								Source: "csv",
								Start: ast.Position{
									Column: 23,
									Line:   139,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   139,
									},
									File:   "testing.flux",
									Source: "csv",
									Start: ast.Position{
										Column: 23,
										Line:   139,
									},
								},
							},
							Name: "csv",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// loadStorage loads annotated CSV test data as if it were queried from InfluxDB.\n"}, ast.Comment{Text: "// This function ensures tests behave correctly in both the Flux and InfluxDB test suites.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Function Requirements\n"}, ast.Comment{Text: "// - Test data requires the _field, _measurement, and _time columns\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `csv` is the annotated CSV data to load\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// csvData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,string,dateTime:RFC3339,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,false,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,\n"}, ast.Comment{Text: "// ,result,table,_measurement,_time,_field,_value\n"}, ast.Comment{Text: "// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n"}, ast.Comment{Text: "// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n"}, ast.Comment{Text: "// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.loadStorage(csv: csvData)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   147,
					},
					File:   "testing.flux",
					Source: "option loadStorage = (csv) => c.from(csv: csv)\n    |> range(start: 1800-01-01T00:00:00Z, stop: 2200-12-31T11:59:59Z)\n    |> map(\n        fn: (r) => ({r with\n            _field: if exists r._field then r._field else die(msg: \"test input table does not have _field column\"),\n            _measurement: if exists r._measurement then r._measurement else die(msg: \"test input table does not have _measurement column\"),\n            _time: if exists r._time then r._time else die(msg: \"test input table does not have _time column\"),\n        }),\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   139,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   177,
						},
						File:   "testing.flux",
						Source: "load = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   177,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   177,
							},
							File:   "testing.flux",
							Source: "load",
							Start: ast.Position{
								Column: 8,
								Line:   177,
							},
						},
					},
					Name: "load",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   177,
							},
							File:   "testing.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 15,
								Line:   177,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   177,
								},
								File:   "testing.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 30,
									Line:   177,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   177,
								},
								File:   "testing.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 16,
									Line:   177,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   177,
									},
									File:   "testing.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 16,
										Line:   177,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   177,
								},
								File:   "testing.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 23,
									Line:   177,
								},
							},
						}},
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// load loads tests data from a stream of tables.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `tables` is the input data. Default is piped-forward data (<-).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Load a raw stream of tables in a test case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The following test uses array.from() to create two streams of tables to compare in the test.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "// import \"array\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// got = array.from(rows: [\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T00:00:00Z, _measurement: \"m\", _field: \"t\", _value: 1.2},\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T01:00:00Z, _measurement: \"m\", _field: \"t\", _value: 0.8},\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T02:00:00Z, _measurement: \"m\", _field: \"t\", _value: 3.2}\n"}, ast.Comment{Text: "// ])\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// want = array.from(rows: [\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T00:00:00Z, _measurement: \"m\", _field: \"t\", _value: 1.2},\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T01:00:00Z, _measurement: \"m\", _field: \"t\", _value: 0.8},\n"}, ast.Comment{Text: "//   {_time: 2021-01-01T02:00:00Z, _measurement: \"m\", _field: \"t\", _value: 3.1}\n"}, ast.Comment{Text: "// ])\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.diff(got, want)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   177,
					},
					File:   "testing.flux",
					Source: "option load = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   177,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   200,
						},
						File:   "testing.flux",
						Source: "loadMem = (csv) => c.from(csv: csv)",
						Start: ast.Position{
							Column: 8,
							Line:   200,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   200,
							},
							File:   "testing.flux",
							Source: "loadMem",
							Start: ast.Position{
								Column: 8,
								Line:   200,
							},
						},
					},
					Name: "loadMem",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   200,
							},
							File:   "testing.flux",
							Source: "(csv) => c.from(csv: csv)",
							Start: ast.Position{
								Column: 18,
								Line:   200,
							},
						},
					},
					Body: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   200,
									},
									File:   "testing.flux",
									Source: "csv: csv",
									Start: ast.Position{
										Column: 34,
										Line:   200,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   200,
										},
										File:   "testing.flux",
										Source: "csv: csv",
										Start: ast.Position{
											Column: 34,
											Line:   200,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   200,
											},
											File:   "testing.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 34,
												Line:   200,
											},
										},
									},
									Name: "csv",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   200,
											},
											File:   "testing.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 39,
												Line:   200,
											},
										},
									},
									Name: "csv",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   200,
								},
								File:   "testing.flux",
								Source: "c.from(csv: csv)",
								Start: ast.Position{
									Column: 27,
									Line:   200,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   200,
									},
									File:   "testing.flux",
									Source: "c.from",
									Start: ast.Position{
										Column: 27,
										Line:   200,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   200,
										},
										File:   "testing.flux",
										Source: "c",
										Start: ast.Position{
											Column: 27,
											Line:   200,
										},
									},
								},
								Name: "c",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   200,
										},
										File:   "testing.flux",
										Source: "from",
										Start: ast.Position{
											Column: 29,
											Line:   200,
										},
									},
								},
								Name: "from",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   200,
								},
								File:   "testing.flux",
								Source: "csv",
								Start: ast.Position{
									Column: 19,
									Line:   200,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   200,
									},
									File:   "testing.flux",
									Source: "csv",
									Start: ast.Position{
										Column: 19,
										Line:   200,
									},
								},
							},
							Name: "csv",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// loadMem loads annotated CSV test data from memory to emulate query results returned by Flux.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `csv` is the annotated CSV data to load.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// csvData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,string,dateTime:RFC3339,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,false,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,\n"}, ast.Comment{Text: "// ,result,table,_measurement,_time,_field,_value\n"}, ast.Comment{Text: "// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n"}, ast.Comment{Text: "// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n"}, ast.Comment{Text: "// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.loadMem(csv: csvData)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   200,
					},
					File:   "testing.flux",
					Source: "option loadMem = (csv) => c.from(csv: csv)",
					Start: ast.Position{
						Column: 1,
						Line:   200,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   259,
					},
					File:   "testing.flux",
					Source: "inspect = (case) => {\n    tc = case()\n    got = tc.input |> tc.fn()\n    dif = got |> diff(want: tc.want)\n\n    return {\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }\n}",
					Start: ast.Position{
						Column: 1,
						Line:   247,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// inspect returns information about a test case.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `case` is the test case to inspect.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Define and inspect a test case\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// inData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,string,dateTime:RFC3339,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,false,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,\n"}, ast.Comment{Text: "// ,result,table,_measurement,_time,_field,_value\n"}, ast.Comment{Text: "// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n"}, ast.Comment{Text: "// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n"}, ast.Comment{Text: "// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// outData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,true,true,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,,\n"}, ast.Comment{Text: "// ,result,table,_start,_stop,_measurement,_field,_value\n"}, ast.Comment{Text: "// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// t_sum = (table=<-) =>\n"}, ast.Comment{Text: "//   (table\n"}, ast.Comment{Text: "//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n"}, ast.Comment{Text: "//     |> sum())\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// test _sum = () =>\n"}, ast.Comment{Text: "//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.inpsect(case: _sum)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // Returns: {\n"}, ast.Comment{Text: "// //   fn: (<-table: [{_time: time | t10997}]) -> [t10996],\n"}, ast.Comment{Text: "// //   input: fromCSV -> range -> map,\n"}, ast.Comment{Text: "// //   want: fromCSV -> yield,\n"}, ast.Comment{Text: "// //   got: fromCSV -> range -> map -> range -> sum -> yield,\n"}, ast.Comment{Text: "// //   diff: ( fromCSV; fromCSV -> range -> map -> range -> sum;  ) -> diff -> yield\n"}, ast.Comment{Text: "// // }\n"}, ast.Comment{Text: "// ```\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   247,
						},
						File:   "testing.flux",
						Source: "inspect",
						Start: ast.Position{
							Column: 1,
							Line:   247,
						},
					},
				},
				Name: "inspect",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   259,
						},
						File:   "testing.flux",
						Source: "(case) => {\n    tc = case()\n    got = tc.input |> tc.fn()\n    dif = got |> diff(want: tc.want)\n\n    return {\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }\n}",
						Start: ast.Position{
							Column: 11,
							Line:   247,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   259,
							},
							File:   "testing.flux",
							Source: "{\n    tc = case()\n    got = tc.input |> tc.fn()\n    dif = got |> diff(want: tc.want)\n\n    return {\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }\n}",
							Start: ast.Position{
								Column: 21,
								Line:   247,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   248,
								},
								File:   "testing.flux",
								Source: "tc = case()",
								Start: ast.Position{
									Column: 5,
									Line:   248,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   248,
									},
									File:   "testing.flux",
									Source: "tc",
									Start: ast.Position{
										Column: 5,
										Line:   248,
									},
								},
							},
							Name: "tc",
						},
						Init: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   248,
									},
									File:   "testing.flux",
									Source: "case()",
									Start: ast.Position{
										Column: 10,
										Line:   248,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   248,
										},
										File:   "testing.flux",
										Source: "case",
										Start: ast.Position{
											Column: 10,
											Line:   248,
										},
									},
								},
								Name: "case",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   249,
								},
								File:   "testing.flux",
								Source: "got = tc.input |> tc.fn()",
								Start: ast.Position{
									Column: 5,
									Line:   249,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   249,
									},
									File:   "testing.flux",
									Source: "got",
									Start: ast.Position{
										Column: 5,
										Line:   249,
									},
								},
							},
							Name: "got",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   249,
										},
										File:   "testing.flux",
										Source: "tc.input",
										Start: ast.Position{
											Column: 11,
											Line:   249,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   249,
											},
											File:   "testing.flux",
											Source: "tc",
											Start: ast.Position{
												Column: 11,
												Line:   249,
											},
										},
									},
									Name: "tc",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   249,
											},
											File:   "testing.flux",
											Source: "input",
											Start: ast.Position{
												Column: 14,
												Line:   249,
											},
										},
									},
									Name: "input",
								},
								Rbrack: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   249,
									},
									File:   "testing.flux",
									Source: "tc.input |> tc.fn()",
									Start: ast.Position{
										Column: 11,
										Line:   249,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   249,
										},
										File:   "testing.flux",
										Source: "tc.fn()",
										Start: ast.Position{
											Column: 23,
											Line:   249,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   249,
											},
											File:   "testing.flux",
											Source: "tc.fn",
											Start: ast.Position{
												Column: 23,
												Line:   249,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   249,
												},
												File:   "testing.flux",
												Source: "tc",
												Start: ast.Position{
													Column: 23,
													Line:   249,
												},
											},
										},
										Name: "tc",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   249,
												},
												File:   "testing.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 26,
													Line:   249,
												},
											},
										},
										Name: "fn",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   250,
								},
								File:   "testing.flux",
								Source: "dif = got |> diff(want: tc.want)",
								Start: ast.Position{
									Column: 5,
									Line:   250,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   250,
									},
									File:   "testing.flux",
									Source: "dif",
									Start: ast.Position{
										Column: 5,
										Line:   250,
									},
								},
							},
							Name: "dif",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   250,
										},
										File:   "testing.flux",
										Source: "got",
										Start: ast.Position{
											Column: 11,
											Line:   250,
										},
									},
								},
								Name: "got",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   250,
									},
									File:   "testing.flux",
									Source: "got |> diff(want: tc.want)",
									Start: ast.Position{
										Column: 11,
										Line:   250,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   250,
											},
											File:   "testing.flux",
											Source: "want: tc.want",
											Start: ast.Position{
												Column: 23,
												Line:   250,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   250,
												},
												File:   "testing.flux",
												Source: "want: tc.want",
												Start: ast.Position{
													Column: 23,
													Line:   250,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   250,
													},
													File:   "testing.flux",
													Source: "want",
													Start: ast.Position{
														Column: 23,
														Line:   250,
													},
												},
											},
											Name: "want",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   250,
													},
													File:   "testing.flux",
													Source: "tc.want",
													Start: ast.Position{
														Column: 29,
														Line:   250,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   250,
														},
														File:   "testing.flux",
														Source: "tc",
														Start: ast.Position{
															Column: 29,
															Line:   250,
														},
													},
												},
												Name: "tc",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   250,
														},
														File:   "testing.flux",
														Source: "want",
														Start: ast.Position{
															Column: 32,
															Line:   250,
														},
													},
												},
												Name: "want",
											},
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   250,
										},
										File:   "testing.flux",
										Source: "diff(want: tc.want)",
										Start: ast.Position{
											Column: 18,
											Line:   250,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   250,
											},
											File:   "testing.flux",
											Source: "diff",
											Start: ast.Position{
												Column: 18,
												Line:   250,
											},
										},
									},
									Name: "diff",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   258,
									},
									File:   "testing.flux",
									Source: "{\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   252,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   253,
										},
										File:   "testing.flux",
										Source: "fn: tc.fn",
										Start: ast.Position{
											Column: 9,
											Line:   253,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   253,
											},
											File:   "testing.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 9,
												Line:   253,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   253,
											},
											File:   "testing.flux",
											Source: "tc.fn",
											Start: ast.Position{
												Column: 13,
												Line:   253,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   253,
												},
												File:   "testing.flux",
												Source: "tc",
												Start: ast.Position{
													Column: 13,
													Line:   253,
												},
											},
										},
										Name: "tc",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   253,
												},
												File:   "testing.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 16,
													Line:   253,
												},
											},
										},
										Name: "fn",
									},
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   254,
										},
										File:   "testing.flux",
										Source: "input: tc.input",
										Start: ast.Position{
											Column: 9,
											Line:   254,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   254,
											},
											File:   "testing.flux",
											Source: "input",
											Start: ast.Position{
												Column: 9,
												Line:   254,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   254,
											},
											File:   "testing.flux",
											Source: "tc.input",
											Start: ast.Position{
												Column: 16,
												Line:   254,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   254,
												},
												File:   "testing.flux",
												Source: "tc",
												Start: ast.Position{
													Column: 16,
													Line:   254,
												},
											},
										},
										Name: "tc",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   254,
												},
												File:   "testing.flux",
												Source: "input",
												Start: ast.Position{
													Column: 19,
													Line:   254,
												},
											},
										},
										Name: "input",
									},
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   255,
										},
										File:   "testing.flux",
										Source: "want: tc.want |> yield(name: \"want\")",
										Start: ast.Position{
											Column: 9,
											Line:   255,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   255,
											},
											File:   "testing.flux",
											Source: "want",
											Start: ast.Position{
												Column: 9,
												Line:   255,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.PipeExpression{
									Argument: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   255,
												},
												File:   "testing.flux",
												Source: "tc.want",
												Start: ast.Position{
													Column: 15,
													Line:   255,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   255,
													},
													File:   "testing.flux",
													Source: "tc",
													Start: ast.Position{
														Column: 15,
														Line:   255,
													},
												},
											},
											Name: "tc",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   255,
													},
													File:   "testing.flux",
													Source: "want",
													Start: ast.Position{
														Column: 18,
														Line:   255,
													},
												},
											},
											Name: "want",
										},
										Rbrack: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   255,
											},
											File:   "testing.flux",
											Source: "tc.want |> yield(name: \"want\")",
											Start: ast.Position{
												Column: 15,
												Line:   255,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   255,
													},
													File:   "testing.flux",
													Source: "name: \"want\"",
													Start: ast.Position{
														Column: 32,
														Line:   255,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   255,
														},
														File:   "testing.flux",
														Source: "name: \"want\"",
														Start: ast.Position{
															Column: 32,
															Line:   255,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   255,
															},
															File:   "testing.flux",
															Source: "name",
															Start: ast.Position{
																Column: 32,
																Line:   255,
															},
														},
													},
													Name: "name",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   255,
															},
															File:   "testing.flux",
															Source: "\"want\"",
															Start: ast.Position{
																Column: 38,
																Line:   255,
															},
														},
													},
													Value: "want",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   255,
												},
												File:   "testing.flux",
												Source: "yield(name: \"want\")",
												Start: ast.Position{
													Column: 26,
													Line:   255,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   255,
													},
													File:   "testing.flux",
													Source: "yield",
													Start: ast.Position{
														Column: 26,
														Line:   255,
													},
												},
											},
											Name: "yield",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   256,
										},
										File:   "testing.flux",
										Source: "got: got |> yield(name: \"got\")",
										Start: ast.Position{
											Column: 9,
											Line:   256,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   256,
											},
											File:   "testing.flux",
											Source: "got",
											Start: ast.Position{
												Column: 9,
												Line:   256,
											},
										},
									},
									Name: "got",
								},
								Separator: nil,
								Value: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   256,
												},
												File:   "testing.flux",
												Source: "got",
												Start: ast.Position{
													Column: 14,
													Line:   256,
												},
											},
										},
										Name: "got",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   256,
											},
											File:   "testing.flux",
											Source: "got |> yield(name: \"got\")",
											Start: ast.Position{
												Column: 14,
												Line:   256,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   256,
													},
													File:   "testing.flux",
													Source: "name: \"got\"",
													Start: ast.Position{
														Column: 27,
														Line:   256,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   256,
														},
														File:   "testing.flux",
														Source: "name: \"got\"",
														Start: ast.Position{
															Column: 27,
															Line:   256,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   256,
															},
															File:   "testing.flux",
															Source: "name",
															Start: ast.Position{
																Column: 27,
																Line:   256,
															},
														},
													},
													Name: "name",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   256,
															},
															File:   "testing.flux",
															Source: "\"got\"",
															Start: ast.Position{
																Column: 33,
																Line:   256,
															},
														},
													},
													Value: "got",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   256,
												},
												File:   "testing.flux",
												Source: "yield(name: \"got\")",
												Start: ast.Position{
													Column: 21,
													Line:   256,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   256,
													},
													File:   "testing.flux",
													Source: "yield",
													Start: ast.Position{
														Column: 21,
														Line:   256,
													},
												},
											},
											Name: "yield",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   257,
										},
										File:   "testing.flux",
										Source: "diff: dif |> yield(name: \"diff\")",
										Start: ast.Position{
											Column: 9,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   257,
											},
											File:   "testing.flux",
											Source: "diff",
											Start: ast.Position{
												Column: 9,
												Line:   257,
											},
										},
									},
									Name: "diff",
								},
								Separator: nil,
								Value: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   257,
												},
												File:   "testing.flux",
												Source: "dif",
												Start: ast.Position{
													Column: 15,
													Line:   257,
												},
											},
										},
										Name: "dif",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   257,
											},
											File:   "testing.flux",
											Source: "dif |> yield(name: \"diff\")",
											Start: ast.Position{
												Column: 15,
												Line:   257,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   257,
													},
													File:   "testing.flux",
													Source: "name: \"diff\"",
													Start: ast.Position{
														Column: 28,
														Line:   257,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   257,
														},
														File:   "testing.flux",
														Source: "name: \"diff\"",
														Start: ast.Position{
															Column: 28,
															Line:   257,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   257,
															},
															File:   "testing.flux",
															Source: "name",
															Start: ast.Position{
																Column: 28,
																Line:   257,
															},
														},
													},
													Name: "name",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   257,
															},
															File:   "testing.flux",
															Source: "\"diff\"",
															Start: ast.Position{
																Column: 34,
																Line:   257,
															},
														},
													},
													Value: "diff",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   257,
												},
												File:   "testing.flux",
												Source: "yield(name: \"diff\")",
												Start: ast.Position{
													Column: 22,
													Line:   257,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   257,
													},
													File:   "testing.flux",
													Source: "yield",
													Start: ast.Position{
														Column: 22,
														Line:   257,
													},
												},
											},
											Name: "yield",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   258,
								},
								File:   "testing.flux",
								Source: "return {\n        fn: tc.fn,\n        input: tc.input,\n        want: tc.want |> yield(name: \"want\"),\n        got: got |> yield(name: \"got\"),\n        diff: dif |> yield(name: \"diff\"),\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   252,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   247,
							},
							File:   "testing.flux",
							Source: "case",
							Start: ast.Position{
								Column: 12,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   247,
								},
								File:   "testing.flux",
								Source: "case",
								Start: ast.Position{
									Column: 12,
									Line:   247,
								},
							},
						},
						Name: "case",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   300,
					},
					File:   "testing.flux",
					Source: "run = (case) => {\n    return inspect(case: case).diff |> assertEmpty()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   298,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// run executes a specified test case.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `case` is the test case to run.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Define and execute a test case\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// inData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,string,dateTime:RFC3339,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,false,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,\n"}, ast.Comment{Text: "// ,result,table,_measurement,_time,_field,_value\n"}, ast.Comment{Text: "// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n"}, ast.Comment{Text: "// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n"}, ast.Comment{Text: "// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// outData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,true,true,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,,\n"}, ast.Comment{Text: "// ,result,table,_start,_stop,_measurement,_field,_value\n"}, ast.Comment{Text: "// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// t_sum = (table=<-) =>\n"}, ast.Comment{Text: "//   (table\n"}, ast.Comment{Text: "//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n"}, ast.Comment{Text: "//     |> sum())\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// test _sum = () =>\n"}, ast.Comment{Text: "//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.run(case: _sum)\n"}, ast.Comment{Text: "// ```\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   298,
						},
						File:   "testing.flux",
						Source: "run",
						Start: ast.Position{
							Column: 1,
							Line:   298,
						},
					},
				},
				Name: "run",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   300,
						},
						File:   "testing.flux",
						Source: "(case) => {\n    return inspect(case: case).diff |> assertEmpty()\n}",
						Start: ast.Position{
							Column: 7,
							Line:   298,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   300,
							},
							File:   "testing.flux",
							Source: "{\n    return inspect(case: case).diff |> assertEmpty()\n}",
							Start: ast.Position{
								Column: 17,
								Line:   298,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   299,
										},
										File:   "testing.flux",
										Source: "inspect(case: case).diff",
										Start: ast.Position{
											Column: 12,
											Line:   299,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   299,
												},
												File:   "testing.flux",
												Source: "case: case",
												Start: ast.Position{
													Column: 20,
													Line:   299,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   299,
													},
													File:   "testing.flux",
													Source: "case: case",
													Start: ast.Position{
														Column: 20,
														Line:   299,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   299,
														},
														File:   "testing.flux",
														Source: "case",
														Start: ast.Position{
															Column: 20,
															Line:   299,
														},
													},
												},
												Name: "case",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   299,
														},
														File:   "testing.flux",
														Source: "case",
														Start: ast.Position{
															Column: 26,
															Line:   299,
														},
													},
												},
												Name: "case",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   299,
											},
											File:   "testing.flux",
											Source: "inspect(case: case)",
											Start: ast.Position{
												Column: 12,
												Line:   299,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   299,
												},
												File:   "testing.flux",
												Source: "inspect",
												Start: ast.Position{
													Column: 12,
													Line:   299,
												},
											},
										},
										Name: "inspect",
									},
									Lparen: nil,
									Rparen: nil,
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   299,
											},
											File:   "testing.flux",
											Source: "diff",
											Start: ast.Position{
												Column: 32,
												Line:   299,
											},
										},
									},
									Name: "diff",
								},
								Rbrack: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   299,
									},
									File:   "testing.flux",
									Source: "inspect(case: case).diff |> assertEmpty()",
									Start: ast.Position{
										Column: 12,
										Line:   299,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   299,
										},
										File:   "testing.flux",
										Source: "assertEmpty()",
										Start: ast.Position{
											Column: 40,
											Line:   299,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   299,
											},
											File:   "testing.flux",
											Source: "assertEmpty",
											Start: ast.Position{
												Column: 40,
												Line:   299,
											},
										},
									},
									Name: "assertEmpty",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   299,
								},
								File:   "testing.flux",
								Source: "return inspect(case: case).diff |> assertEmpty()",
								Start: ast.Position{
									Column: 5,
									Line:   299,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   298,
							},
							File:   "testing.flux",
							Source: "case",
							Start: ast.Position{
								Column: 8,
								Line:   298,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   298,
								},
								File:   "testing.flux",
								Source: "case",
								Start: ast.Position{
									Column: 8,
									Line:   298,
								},
							},
						},
						Name: "case",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   350,
					},
					File:   "testing.flux",
					Source: "benchmark = (case) => {\n    tc = case()\n\n    return tc.input |> tc.fn()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   346,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// benchmark executes a test case without comparing test output with the expected test output.\n"}, ast.Comment{Text: "// This lets you accurately benchmark a test case without the added overhead of comparing test output that occurs in testing.run().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `case` is the test case to benchmark.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Define and benchmark a test case\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The following script defines a test case for the sum() function and enables profilers to measure query performance.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"testing\"\n"}, ast.Comment{Text: "// import \"profiler\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option profiler.enabledProfilers = [\"query\", \"operator\"]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// inData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,string,dateTime:RFC3339,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,false,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,\n"}, ast.Comment{Text: "// ,result,table,_measurement,_time,_field,_value\n"}, ast.Comment{Text: "// ,,0,m,2021-01-01T00:00:00Z,t,1.2\n"}, ast.Comment{Text: "// ,,0,m,2021-01-02T00:00:00Z,t,1.4\n"}, ast.Comment{Text: "// ,,0,m,2021-01-03T00:00:00Z,t,2.2\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// outData = \"\n"}, ast.Comment{Text: "// #datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n"}, ast.Comment{Text: "// #group,false,false,true,true,true,true,false\n"}, ast.Comment{Text: "// #default,_result,,,,,,\n"}, ast.Comment{Text: "// ,result,table,_start,_stop,_measurement,_field,_value\n"}, ast.Comment{Text: "// ,,0,2021-01-01T00:00:00Z,2021-01-03T01:00:00Z,m,t,4.8\n"}, ast.Comment{Text: "// \"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// t_sum = (table=<-) =>\n"}, ast.Comment{Text: "//   (table\n"}, ast.Comment{Text: "//     |> range(start:2021-01-01T00:00:00Z, stop:2021-01-03T01:00:00Z)\n"}, ast.Comment{Text: "//     |> sum())\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// test _sum = () =>\n"}, ast.Comment{Text: "//   ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_sum})\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// testing.benchmark(case: _sum)\n"}, ast.Comment{Text: "// ```\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   346,
						},
						File:   "testing.flux",
						Source: "benchmark",
						Start: ast.Position{
							Column: 1,
							Line:   346,
						},
					},
				},
				Name: "benchmark",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   350,
						},
						File:   "testing.flux",
						Source: "(case) => {\n    tc = case()\n\n    return tc.input |> tc.fn()\n}",
						Start: ast.Position{
							Column: 13,
							Line:   346,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   350,
							},
							File:   "testing.flux",
							Source: "{\n    tc = case()\n\n    return tc.input |> tc.fn()\n}",
							Start: ast.Position{
								Column: 23,
								Line:   346,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   347,
								},
								File:   "testing.flux",
								Source: "tc = case()",
								Start: ast.Position{
									Column: 5,
									Line:   347,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   347,
									},
									File:   "testing.flux",
									Source: "tc",
									Start: ast.Position{
										Column: 5,
										Line:   347,
									},
								},
							},
							Name: "tc",
						},
						Init: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   347,
									},
									File:   "testing.flux",
									Source: "case()",
									Start: ast.Position{
										Column: 10,
										Line:   347,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   347,
										},
										File:   "testing.flux",
										Source: "case",
										Start: ast.Position{
											Column: 10,
											Line:   347,
										},
									},
								},
								Name: "case",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   349,
										},
										File:   "testing.flux",
										Source: "tc.input",
										Start: ast.Position{
											Column: 12,
											Line:   349,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   349,
											},
											File:   "testing.flux",
											Source: "tc",
											Start: ast.Position{
												Column: 12,
												Line:   349,
											},
										},
									},
									Name: "tc",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   349,
											},
											File:   "testing.flux",
											Source: "input",
											Start: ast.Position{
												Column: 15,
												Line:   349,
											},
										},
									},
									Name: "input",
								},
								Rbrack: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   349,
									},
									File:   "testing.flux",
									Source: "tc.input |> tc.fn()",
									Start: ast.Position{
										Column: 12,
										Line:   349,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   349,
										},
										File:   "testing.flux",
										Source: "tc.fn()",
										Start: ast.Position{
											Column: 24,
											Line:   349,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   349,
											},
											File:   "testing.flux",
											Source: "tc.fn",
											Start: ast.Position{
												Column: 24,
												Line:   349,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   349,
												},
												File:   "testing.flux",
												Source: "tc",
												Start: ast.Position{
													Column: 24,
													Line:   349,
												},
											},
										},
										Name: "tc",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   349,
												},
												File:   "testing.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 27,
													Line:   349,
												},
											},
										},
										Name: "fn",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   349,
								},
								File:   "testing.flux",
								Source: "return tc.input |> tc.fn()",
								Start: ast.Position{
									Column: 5,
									Line:   349,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   346,
							},
							File:   "testing.flux",
							Source: "case",
							Start: ast.Position{
								Column: 14,
								Line:   346,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   346,
								},
								File:   "testing.flux",
								Source: "case",
								Start: ast.Position{
									Column: 14,
									Line:   346,
								},
							},
						},
						Name: "case",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   5,
						},
						File:   "testing.flux",
						Source: "c",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Name: "c",
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   5,
					},
					File:   "testing.flux",
					Source: "import c \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   5,
						},
						File:   "testing.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "testing.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package testing functions test piped-forward data in specific ways and return errors if the tests fail.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   2,
					},
					File:   "testing.flux",
					Source: "package testing",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   2,
						},
						File:   "testing.flux",
						Source: "testing",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "testing",
			},
		},
	}},
	Package: "testing",
	Path:    "testing",
}
