/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.SolrClientNodeStateProvider;
import org.apache.solr.client.solrj.impl.ZkDistribStateManager;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCloudManager
implements SolrCloudManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CloudHttp2SolrClient cloudSolrClient;
    private final ZkDistribStateManager stateManager;
    private final ZkStateReader zkStateReader;
    private final SolrZkClient zkClient;
    private final ObjectCache objectCache;
    private final boolean closeObjectCache;
    private volatile boolean isClosed;
    private static final byte[] EMPTY = new byte[0];

    public SolrClientCloudManager(CloudHttp2SolrClient client, ObjectCache objectCache) {
        this.cloudSolrClient = client;
        this.zkStateReader = ZkStateReader.from((CloudSolrClient)client);
        this.zkClient = this.zkStateReader.getZkClient();
        this.stateManager = new ZkDistribStateManager(this.zkClient);
        this.isClosed = false;
        if (objectCache == null) {
            this.objectCache = new ObjectCache();
            this.closeObjectCache = true;
        } else {
            this.objectCache = objectCache;
            this.closeObjectCache = false;
        }
    }

    public void close() {
        this.isClosed = true;
        if (this.closeObjectCache) {
            IOUtils.closeQuietly((AutoCloseable)this.objectCache);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    @Override
    public TimeSource getTimeSource() {
        return TimeSource.NANO_TIME;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.cloudSolrClient.getClusterStateProvider();
    }

    @Override
    public NodeStateProvider getNodeStateProvider() {
        return new SolrClientNodeStateProvider(this.cloudSolrClient);
    }

    @Override
    public DistribStateManager getDistribStateManager() {
        return this.stateManager;
    }

    @Override
    public <T extends SolrResponse> T request(SolrRequest<T> req) throws IOException {
        try {
            return (T)req.process((SolrClient)this.cloudSolrClient);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }
}

