/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.impl.NodeMetricImpl;
import org.apache.solr.cluster.placement.plugins.OrderedNodePlacementPlugin;

public class MinimizeCoresPlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new MinimizeCoresPlacementPlugin();
    }

    private static class NodeWithCoreCount
    extends OrderedNodePlacementPlugin.WeightedNode {
        private int coreCount;

        public NodeWithCoreCount(Node node, int coreCount) {
            super(node);
            this.coreCount = coreCount;
        }

        @Override
        public int calcWeight() {
            return this.coreCount;
        }

        @Override
        public int calcRelevantWeightWithReplica(Replica replica) {
            return this.coreCount + 1;
        }

        @Override
        public boolean addProjectedReplicaWeights(Replica replica) {
            ++this.coreCount;
            return false;
        }

        @Override
        public void removeProjectedReplicaWeights(Replica replica) {
            --this.coreCount;
        }
    }

    private static class MinimizeCoresPlacementPlugin
    extends OrderedNodePlacementPlugin {
        private MinimizeCoresPlacementPlugin() {
        }

        @Override
        protected Map<Node, OrderedNodePlacementPlugin.WeightedNode> getBaseWeightedNodes(PlacementContext placementContext, Set<Node> nodes, Iterable<SolrCollection> relevantCollections, boolean skipNodesWithErrors) throws PlacementException {
            AttributeFetcher attributeFetcher = placementContext.getAttributeFetcher();
            attributeFetcher.requestNodeMetric(NodeMetricImpl.NUM_CORES);
            attributeFetcher.fetchFrom(nodes);
            AttributeValues attrValues = attributeFetcher.fetchAttributes();
            HashMap<Node, OrderedNodePlacementPlugin.WeightedNode> nodeMap = new HashMap<Node, OrderedNodePlacementPlugin.WeightedNode>();
            for (Node node : nodes) {
                if (skipNodesWithErrors && attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).isEmpty()) {
                    throw new PlacementException("Can't get number of cores in " + node);
                }
                nodeMap.put(node, new NodeWithCoreCount(node, attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).orElse(0)));
            }
            return nodeMap;
        }
    }
}

