/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class JapanesePartOfSpeechStopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "japanesePartOfSpeechStop";
    private final String stopTagFiles;
    private Set<String> stopTags;

    public JapanesePartOfSpeechStopFilterFactory(Map<String, String> args) {
        super(args);
        this.stopTagFiles = this.get(args, "tags");
        if (this.stopTagFiles == null) {
            this.stopTags = JapaneseAnalyzer.getDefaultStopTags();
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public JapanesePartOfSpeechStopFilterFactory() {
        throw JapanesePartOfSpeechStopFilterFactory.defaultCtorException();
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.stopTagFiles != null) {
            this.stopTags = null;
            CharArraySet cas = this.getWordSet(loader, this.stopTagFiles, false);
            if (cas != null) {
                this.stopTags = new HashSet<String>();
                for (Object element : cas) {
                    char[] chars = (char[])element;
                    this.stopTags.add(new String(chars));
                }
            }
        }
    }

    public TokenStream create(TokenStream stream) {
        if (this.stopTags != null) {
            JapanesePartOfSpeechStopFilter filter = new JapanesePartOfSpeechStopFilter(stream, this.stopTags);
            return filter;
        }
        return stream;
    }
}

