/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public abstract class GroupFacetCollector
extends SimpleCollector {
    protected final String groupField;
    protected final String facetField;
    protected final BytesRef facetPrefix;
    protected final List<SegmentResult> segmentResults;
    protected int[] segmentFacetCounts;
    protected int segmentTotalCount;
    protected int startFacetOrd;
    protected int endFacetOrd;

    protected GroupFacetCollector(String groupField, String facetField, BytesRef facetPrefix) {
        this.groupField = groupField;
        this.facetField = facetField;
        this.facetPrefix = facetPrefix;
        this.segmentResults = new ArrayList<SegmentResult>();
    }

    public GroupedFacetResult mergeSegmentResults(int size, int minCount, boolean orderByCount) throws IOException {
        int totalCount = 0;
        int missingCount = 0;
        SegmentResultPriorityQueue segments = new SegmentResultPriorityQueue(this.segmentResults.size());
        for (SegmentResult segmentResult : this.segmentResults) {
            missingCount += segmentResult.missing;
            if (segmentResult.mergePos >= segmentResult.maxTermPos) continue;
            totalCount += segmentResult.total;
            segments.add(segmentResult);
        }
        GroupedFacetResult facetResult = new GroupedFacetResult(size, minCount, orderByCount, totalCount, missingCount);
        while (segments.size() > 0) {
            SegmentResult segmentResult;
            segmentResult = (SegmentResult)segments.top();
            BytesRef currentFacetValue = BytesRef.deepCopyOf((BytesRef)segmentResult.mergeTerm);
            int count = 0;
            do {
                count += segmentResult.counts[segmentResult.mergePos++];
                if (segmentResult.mergePos < segmentResult.maxTermPos) {
                    segmentResult.nextTerm();
                    segmentResult = (SegmentResult)segments.updateTop();
                    continue;
                }
                segments.pop();
                segmentResult = (SegmentResult)segments.top();
                if (segmentResult == null) break;
            } while (currentFacetValue.equals((Object)segmentResult.mergeTerm));
            facetResult.addFacetCount(currentFacetValue, count);
        }
        return facetResult;
    }

    public void finish() throws IOException {
        this.segmentResults.add(this.createSegmentResult());
        this.segmentFacetCounts = null;
    }

    protected abstract SegmentResult createSegmentResult() throws IOException;

    public void setScorer(Scorable scorer) throws IOException {
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    private static class SegmentResultPriorityQueue
    extends PriorityQueue<SegmentResult> {
        SegmentResultPriorityQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(SegmentResult a, SegmentResult b) {
            return a.mergeTerm.compareTo(b.mergeTerm) < 0;
        }
    }

    protected static abstract class SegmentResult {
        protected final int[] counts;
        protected final int total;
        protected final int missing;
        protected final int maxTermPos;
        protected BytesRef mergeTerm;
        protected int mergePos;

        protected SegmentResult(int[] counts, int total, int missing, int maxTermPos) {
            this.counts = counts;
            this.total = total;
            this.missing = missing;
            this.maxTermPos = maxTermPos;
        }

        protected abstract void nextTerm() throws IOException;
    }

    public static class FacetEntry {
        private final BytesRef value;
        private final int count;

        public FacetEntry(BytesRef value, int count) {
            this.value = value;
            this.count = count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FacetEntry that = (FacetEntry)o;
            if (this.count != that.count) {
                return false;
            }
            return this.value.equals((Object)that.value);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.count;
            return result;
        }

        public String toString() {
            return "FacetEntry{value=" + this.value.utf8ToString() + ", count=" + this.count + "}";
        }

        public BytesRef getValue() {
            return this.value;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class GroupedFacetResult {
        private static final Comparator<FacetEntry> orderByCountAndValue = new Comparator<FacetEntry>(){

            @Override
            public int compare(FacetEntry a, FacetEntry b) {
                int cmp = b.count - a.count;
                if (cmp != 0) {
                    return cmp;
                }
                return a.value.compareTo(b.value);
            }
        };
        private static final Comparator<FacetEntry> orderByValue = new Comparator<FacetEntry>(){

            @Override
            public int compare(FacetEntry a, FacetEntry b) {
                return a.value.compareTo(b.value);
            }
        };
        private final int maxSize;
        private final NavigableSet<FacetEntry> facetEntries;
        private final int totalMissingCount;
        private final int totalCount;
        private int currentMin;

        public GroupedFacetResult(int size, int minCount, boolean orderByCount, int totalCount, int totalMissingCount) {
            this.facetEntries = new TreeSet<FacetEntry>(orderByCount ? orderByCountAndValue : orderByValue);
            this.totalMissingCount = totalMissingCount;
            this.totalCount = totalCount;
            this.maxSize = size;
            this.currentMin = minCount;
        }

        public void addFacetCount(BytesRef facetValue, int count) {
            if (count < this.currentMin) {
                return;
            }
            FacetEntry facetEntry = new FacetEntry(facetValue, count);
            if (this.facetEntries.size() == this.maxSize) {
                if (this.facetEntries.higher(facetEntry) == null) {
                    return;
                }
                this.facetEntries.pollLast();
            }
            this.facetEntries.add(facetEntry);
            if (this.facetEntries.size() == this.maxSize) {
                this.currentMin = ((FacetEntry)this.facetEntries.last()).count;
            }
        }

        public List<FacetEntry> getFacetEntries(int offset, int limit) {
            LinkedList<FacetEntry> entries = new LinkedList<FacetEntry>();
            int skipped = 0;
            int included = 0;
            for (FacetEntry facetEntry : this.facetEntries) {
                if (skipped < offset) {
                    ++skipped;
                    continue;
                }
                if (included++ >= limit) break;
                entries.add(facetEntry);
            }
            return entries;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getTotalMissingCount() {
            return this.totalMissingCount;
        }
    }
}

