/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.NegotiationStatus;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AddPrincipalRep;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AddPrincipalReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AdminMessage;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageType;
import org.apache.hadoop.shaded.org.xnio.sasl.SaslWrapper;

public class KadminCode {
    public static ByteBuffer encodeMessage(AdminMessage adminMessage) {
        int length = adminMessage.encodingLength();
        ByteBuffer buffer = ByteBuffer.allocate(length + 4);
        buffer.putInt(length);
        buffer.put(adminMessage.getMessageBuffer());
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer encodeSaslMessage(byte[] bytes, NegotiationStatus status) {
        int length = bytes.length + 4;
        ByteBuffer buffer = ByteBuffer.allocate(length + 4);
        buffer.putInt(length);
        buffer.putInt(status.getValue());
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer encodeWrapMessage(AdminMessage adminMessage, SaslWrapper sasl) throws SaslException {
        byte[] wrapBytes = sasl.wrap(adminMessage.getMessageBuffer());
        int length = wrapBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(length + 4);
        buffer.putInt(length);
        buffer.put(wrapBytes);
        buffer.flip();
        return buffer;
    }

    public static AdminMessage decodeMessage(ByteBuffer buffer) throws IOException {
        int type = buffer.getInt();
        System.out.println("type: " + type);
        AdminMessageType adminMessageType = AdminMessageType.findType(type);
        AdminMessage adminMessage = null;
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        if (adminMessageType == AdminMessageType.ADD_PRINCIPAL_REQ) {
            adminMessage = new AddPrincipalReq();
            System.out.println("check if decoding right: " + new String(ByteBuffer.wrap(bytes).array()));
        } else if (adminMessageType == AdminMessageType.ADD_PRINCIPAL_REP) {
            adminMessage = new AddPrincipalRep();
            System.out.println("check if decoding right2: " + new String(ByteBuffer.wrap(bytes).array()));
        } else {
            throw new IOException("Unknown Admin Message Type: " + type);
        }
        return adminMessage;
    }
}

