/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.util.Date;
import java.util.function.LongFunction;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocValuesIteratorCache;

class MultiFieldWriter
extends FieldWriter {
    private final String field;
    private final FieldType fieldType;
    private final SchemaField schemaField;
    private final boolean numeric;
    private final CharsRefBuilder cref = new CharsRefBuilder();
    private final LongFunction<Object> bitsToValue;
    private final DocValuesIteratorCache.FieldDocValuesSupplier docValuesCache;

    public MultiFieldWriter(String field, FieldType fieldType, SchemaField schemaField, boolean numeric, DocValuesIteratorCache.FieldDocValuesSupplier docValuesCache) {
        this.field = field;
        this.fieldType = fieldType;
        this.schemaField = schemaField;
        this.numeric = numeric;
        this.bitsToValue = this.fieldType.isPointField() ? MultiFieldWriter.bitsToValue(fieldType) : null;
        this.docValuesCache = docValuesCache;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReaderContext readerContext, MapWriter.EntryWriter out, int fieldIndex) throws IOException {
        if (this.fieldType.isPointField()) {
            SortedNumericDocValues vals = this.docValuesCache.getSortedNumericDocValues(sortDoc.docId, readerContext.reader(), readerContext.ord);
            if (vals == null) {
                return false;
            }
            SortedNumericDocValues docVals = vals;
            out.put((CharSequence)this.field, w -> {
                int count = docVals.docValueCount();
                for (int i = 0; i < count; ++i) {
                    w.add(this.bitsToValue.apply(docVals.nextValue()));
                }
            });
            return true;
        }
        SortedSetDocValues vals = this.docValuesCache.getSortedSetDocValues(sortDoc.docId, readerContext.reader(), readerContext.ord);
        if (vals == null) {
            return false;
        }
        SortedSetDocValues docVals = vals;
        out.put((CharSequence)this.field, w -> {
            int count = docVals.docValueCount();
            for (int i = 0; i < count; ++i) {
                BytesRef ref = docVals.lookupOrd(docVals.nextOrd());
                this.fieldType.indexedToReadable(ref, this.cref);
                IndexableField f = this.fieldType.createField(this.schemaField, this.cref.toString());
                if (f == null) {
                    w.add((Object)this.cref.toString());
                    continue;
                }
                w.add(this.fieldType.toObject(f));
            }
        });
        return true;
    }

    static LongFunction<Object> bitsToValue(FieldType fieldType) {
        switch (fieldType.getNumberType()) {
            case LONG: {
                return bits -> bits;
            }
            case DATE: {
                return bits -> new Date(bits);
            }
            case INTEGER: {
                return bits -> (int)bits;
            }
            case FLOAT: {
                return bits -> Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)bits)));
            }
            case DOUBLE: {
                return bits -> NumericUtils.sortableLongToDouble((long)bits);
            }
        }
        throw new AssertionError((Object)("Unsupported NumberType: " + fieldType.getNumberType()));
    }
}

