/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.ReturnFields;

public class JSONResponseWriter
implements QueryResponseWriter {
    public static String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=UTF-8";
    private String contentType = CONTENT_TYPE_JSON_UTF8;

    @Override
    public void init(NamedList<?> namedList) {
        String contentType = (String)namedList.get("content-type");
        if (contentType != null) {
            this.contentType = contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        String wrapperFunction = params.get("json.wrf");
        String namedListStyle = params.get("json.nl", "flat").intern();
        try (JSONWriter w = namedListStyle.equals("arrntv") ? new ArrayOfNameTypeValueJSONWriter(writer, req, rsp, wrapperFunction, namedListStyle, true) : new JSONWriter(writer, req, rsp, wrapperFunction, namedListStyle);){
            w.writeResponse();
        }
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return this.contentType;
    }

    public static PushWriter getPushWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        return new JSONWriter(writer, req, rsp);
    }

    static abstract class NaNFloatWriter
    extends JSONWriter {
        protected abstract String getNaN();

        protected abstract String getInf();

        public NaNFloatWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
            super(writer, req, rsp);
        }

        public void writeFloat(String name, float val) throws IOException {
            if (Float.isNaN(val)) {
                this.writer.write(this.getNaN());
            } else if (Float.isInfinite(val)) {
                if (val < 0.0f) {
                    this.writer.write('-');
                }
                this.writer.write(this.getInf());
            } else {
                this.writeFloat(name, Float.toString(val));
            }
        }

        public void writeDouble(String name, double val) throws IOException {
            if (Double.isNaN(val)) {
                this.writer.write(this.getNaN());
            } else if (Double.isInfinite(val)) {
                if (val < 0.0) {
                    this.writer.write('-');
                }
                this.writer.write(this.getInf());
            } else {
                this.writeDouble(name, Double.toString(val));
            }
        }
    }

    static class ArrayOfNameTypeValueJSONWriter
    extends JSONWriter {
        protected boolean writeTypeAndValueKey = false;
        private final boolean writeNullName;

        public ArrayOfNameTypeValueJSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp, String wrapperFunction, String namedListStyle, boolean writeNullName) {
            super(writer, req, rsp, wrapperFunction, namedListStyle);
            this.writeNullName = writeNullName;
        }

        public void writeNamedList(String name, NamedList<?> val) throws IOException {
            if (val instanceof SimpleOrderedMap) {
                super.writeNamedList(name, val);
                return;
            }
            int sz = val.size();
            this.indent();
            this.writeArrayOpener(sz);
            this.incLevel();
            boolean first = true;
            for (int i = 0; i < sz; ++i) {
                if (first) {
                    first = false;
                } else {
                    this.writeArraySeparator();
                }
                this.indent();
                String elementName = val.getName(i);
                Object elementVal = val.getVal(i);
                this.writeMapOpener(-1);
                if (elementName != null || this.writeNullName) {
                    this.writeKey("name", false);
                    this.writeVal("name", elementName);
                    this.writeMapSeparator();
                }
                this.writeTypeAndValueKey = true;
                this.writeVal(null, elementVal);
                if (this.writeTypeAndValueKey) {
                    throw new RuntimeException("writeTypeAndValueKey should have been reset to false by writeVal('" + elementName + "','" + elementVal + "')");
                }
                this.writeMapCloser();
            }
            this.decLevel();
            this.writeArrayCloser();
        }

        protected void ifNeededWriteTypeAndValueKey(String type) throws IOException {
            if (this.writeTypeAndValueKey) {
                this.writeTypeAndValueKey = false;
                this.writeKey("type", false);
                this.writeVal("type", type);
                this.writeMapSeparator();
                this.writeKey("value", false);
            }
        }

        public void writeInt(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("int");
            super.writeInt(name, val);
        }

        public void writeLong(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("long");
            super.writeLong(name, val);
        }

        public void writeFloat(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("float");
            super.writeFloat(name, val);
        }

        public void writeDouble(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("double");
            super.writeDouble(name, val);
        }

        public void writeBool(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("bool");
            super.writeBool(name, val);
        }

        public void writeDate(String name, String val) throws IOException {
            this.ifNeededWriteTypeAndValueKey("date");
            super.writeDate(name, val);
        }

        public void writeStrRaw(String name, String val) throws IOException {
            if (this.writeTypeAndValueKey) {
                throw new IllegalStateException("NamedList should never be a field value");
            }
            super.writeStrRaw(name, val);
        }

        public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
            this.ifNeededWriteTypeAndValueKey("str");
            super.writeStr(name, val, needsEscaping);
        }

        @Override
        public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
            this.ifNeededWriteTypeAndValueKey("doc");
            super.writeSolrDocument(name, doc, returnFields, idx);
        }

        @Override
        public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
            this.ifNeededWriteTypeAndValueKey("doclist");
            super.writeStartDocumentList(name, start, size, numFound, maxScore, numFoundExact);
        }

        public void writeMap(String name, Map<?, ?> val, boolean excludeOuter, boolean isFirstVal) throws IOException {
            this.ifNeededWriteTypeAndValueKey("map");
            super.writeMap(name, val, excludeOuter, isFirstVal);
        }

        public void writeArray(String name, Iterator<?> val, boolean raw) throws IOException {
            this.ifNeededWriteTypeAndValueKey("array");
            super.writeArray(name, val, raw);
        }

        public void writeNull(String name) throws IOException {
            this.ifNeededWriteTypeAndValueKey("null");
            super.writeNull(name);
        }
    }
}

