/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.IntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetQuery;

public class SortedIntDocSet
extends DocSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SortedIntDocSet.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    protected final int[] docs;
    public static int[] zeroInts = new int[0];
    public static SortedIntDocSet zero = new SortedIntDocSet(zeroInts);
    private volatile int[] cachedOrdIdxMap;

    public SortedIntDocSet(int[] docs) {
        this.docs = docs;
    }

    public SortedIntDocSet(int[] docs, int len) {
        this(SortedIntDocSet.shrink(docs, len));
    }

    public int[] getDocs() {
        return this.docs;
    }

    @Override
    public int size() {
        return this.docs.length;
    }

    public static int[] shrink(int[] arr, int newSize) {
        if (arr.length == newSize) {
            return arr;
        }
        int[] newArr = new int[newSize];
        System.arraycopy(arr, 0, newArr, 0, newSize);
        return newArr;
    }

    public static int intersectionSize(int[] smallerSortedList, int[] biggerSortedList) {
        int[] a = smallerSortedList;
        int[] b = biggerSortedList;
        int step = b.length / a.length + 1;
        step += step;
        int icount = 0;
        int low = 0;
        int max = b.length - 1;
        block0: for (int i = 0; i < a.length; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                ++icount;
                low = mid + 1;
                continue block0;
            }
        }
        return icount;
    }

    public static boolean intersects(int[] smallerSortedList, int[] biggerSortedList) {
        int[] a = smallerSortedList;
        int[] b = biggerSortedList;
        int step = b.length / a.length + 1;
        step += step;
        int low = 0;
        int max = b.length - 1;
        for (int i = 0; i < a.length; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int intersectionSize(DocSet other) {
        int[] b;
        if (!(other instanceof SortedIntDocSet)) {
            int icount = 0;
            for (int i = 0; i < this.docs.length; ++i) {
                if (!other.exists(this.docs[i])) continue;
                ++icount;
            }
            return icount;
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int[] a = this.docs.length < otherDocs.length ? this.docs : otherDocs;
        int[] nArray = b = this.docs.length < otherDocs.length ? otherDocs : this.docs;
        if (a.length == 0) {
            return 0;
        }
        if (b.length >> 3 >= a.length) {
            return SortedIntDocSet.intersectionSize(a, b);
        }
        int icount = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= b.length) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                if (++i >= a.length) break;
                doca = a[i];
                continue;
            }
            ++icount;
            if (++i >= a.length) break;
            doca = a[i];
            if (++j >= b.length) break;
            docb = b[j];
        }
        return icount;
    }

    @Override
    public boolean intersects(DocSet other) {
        block9: {
            int[] b;
            if (!(other instanceof SortedIntDocSet)) {
                for (int doc : this.docs) {
                    if (!other.exists(doc)) continue;
                    return true;
                }
                return false;
            }
            int[] otherDocs = ((SortedIntDocSet)other).docs;
            int[] a = this.docs.length < otherDocs.length ? this.docs : otherDocs;
            int[] nArray = b = this.docs.length < otherDocs.length ? otherDocs : this.docs;
            if (a.length == 0) {
                return false;
            }
            if (b.length >> 3 >= a.length) {
                return SortedIntDocSet.intersects(a, b);
            }
            int i = 0;
            int j = 0;
            int doca = a[i];
            int docb = b[j];
            while (true) {
                if (doca > docb) {
                    if (++j < b.length) {
                        docb = b[j];
                        continue;
                    }
                } else {
                    if (doca >= docb) break;
                    if (++i < a.length) {
                        doca = a[i];
                        continue;
                    }
                }
                break block9;
                break;
            }
            return true;
        }
        return false;
    }

    public static int intersection(int[] a, int lena, int[] b, int lenb, int[] target) {
        if (lena > lenb) {
            int ti = lena;
            lena = lenb;
            lenb = ti;
            int[] ta = a;
            a = b;
            b = ta;
        }
        if (lena == 0) {
            return 0;
        }
        if (lenb >> 3 >= lena) {
            return SortedIntDocSet.intersectionBinarySearch(a, lena, b, lenb, target);
        }
        int icount = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= lenb) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                if (++i >= lena) break;
                doca = a[i];
                continue;
            }
            target[icount++] = doca;
            if (++i >= lena) break;
            doca = a[i];
            if (++j >= lenb) break;
            docb = b[j];
        }
        return icount;
    }

    protected static int intersectionBinarySearch(int[] a, int lena, int[] b, int lenb, int[] target) {
        int step = lenb / lena + 1;
        step += step;
        int icount = 0;
        int low = 0;
        int max = lenb - 1;
        block0: for (int i = 0; i < lena; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                target[icount++] = doca;
                low = mid + 1;
                continue block0;
            }
        }
        return icount;
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (!(other instanceof SortedIntDocSet)) {
            int icount = 0;
            int[] arr = new int[this.docs.length];
            for (int i = 0; i < this.docs.length; ++i) {
                int doc = this.docs[i];
                if (!other.exists(doc)) continue;
                arr[icount++] = doc;
            }
            if (icount == this.docs.length) {
                return this;
            }
            return new SortedIntDocSet(arr, icount);
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int maxsz = Math.min(this.docs.length, otherDocs.length);
        int[] arr = new int[maxsz];
        int sz = SortedIntDocSet.intersection(this.docs, this.docs.length, otherDocs, otherDocs.length, arr);
        if (sz == this.docs.length) {
            return this;
        }
        return new SortedIntDocSet(arr, sz);
    }

    protected static int andNotBinarySearch(int[] a, int lena, int[] b, int lenb, int[] target) {
        int step = lenb / lena + 1;
        step += step;
        int count = 0;
        int low = 0;
        int max = lenb - 1;
        block0: for (int i = 0; i < lena; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
                continue block0;
            }
            target[count++] = doca;
        }
        return count;
    }

    public static int andNot(int[] a, int lena, int[] b, int lenb, int[] target) {
        if (lena == 0) {
            return 0;
        }
        if (lenb == 0) {
            System.arraycopy(a, 0, target, 0, lena);
            return lena;
        }
        if (lenb >> 3 >= lena) {
            return SortedIntDocSet.andNotBinarySearch(a, lena, b, lenb, target);
        }
        int count = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= lenb) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                target[count++] = doca;
                if (++i >= lena) break;
                doca = a[i];
                continue;
            }
            if (++i >= lena) break;
            doca = a[i];
            if (++j >= lenb) break;
            docb = b[j];
        }
        int leftover = lena - i;
        if (leftover > 0) {
            System.arraycopy(a, i, target, count, leftover);
            count += leftover;
        }
        return count;
    }

    @Override
    public DocSet andNot(DocSet other) {
        if (other.size() == 0) {
            return this;
        }
        if (!(other instanceof SortedIntDocSet)) {
            int count = 0;
            int[] arr = new int[this.docs.length];
            for (int i = 0; i < this.docs.length; ++i) {
                int doc = this.docs[i];
                if (other.exists(doc)) continue;
                arr[count++] = doc;
            }
            if (count == this.docs.length) {
                return this;
            }
            return new SortedIntDocSet(arr, count);
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int[] arr = new int[this.docs.length];
        int sz = SortedIntDocSet.andNot(this.docs, this.docs.length, otherDocs, otherDocs.length, arr);
        if (sz == this.docs.length) {
            return this;
        }
        return new SortedIntDocSet(arr, sz);
    }

    @Override
    public void addAllTo(FixedBitSet target) {
        for (int doc : this.docs) {
            target.set(doc);
        }
    }

    @Override
    public boolean exists(int doc) {
        int low = 0;
        int high = this.docs.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int docb = this.docs[mid];
            if (docb < doc) {
                low = mid + 1;
                continue;
            }
            if (docb > doc) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < SortedIntDocSet.this.docs.length;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
            }

            @Override
            public int nextDoc() {
                return SortedIntDocSet.this.docs[this.pos++];
            }

            @Override
            public float score() {
                return 0.0f;
            }
        };
    }

    @Override
    public Bits getBits() {
        final IntHashSet hashSet = new IntHashSet(this.docs.length);
        for (int doc : this.docs) {
            hashSet.add(doc);
        }
        return new Bits(){

            public boolean get(int index) {
                return hashSet.contains(index);
            }

            public int length() {
                return SortedIntDocSet.this.getLength();
            }
        };
    }

    private int getLength() {
        return this.size() == 0 ? 0 : this.getDocs()[this.size() - 1] + 1;
    }

    @Override
    protected FixedBitSet getFixedBitSet() {
        return this.getFixedBitSetClone();
    }

    @Override
    protected FixedBitSet getFixedBitSetClone() {
        FixedBitSet bitSet = new FixedBitSet(this.getLength());
        this.addAllTo(bitSet);
        return bitSet;
    }

    @Override
    public DocSet union(DocSet other) {
        FixedBitSet otherBits = other.getFixedBitSet();
        FixedBitSet newbits = FixedBitSet.ensureCapacity((FixedBitSet)this.getFixedBitSetClone(), (int)otherBits.length());
        newbits.or(otherBits);
        return new BitDocSet(newbits);
    }

    private int[] getOrdIdxMap(LeafReaderContext ctx) {
        int[] cached = this.cachedOrdIdxMap;
        if (cached != null) {
            return cached;
        }
        List leaves = ReaderUtil.getTopLevelContext((IndexReaderContext)ctx).leaves();
        int[] ret = new int[leaves.size()];
        int lastLimit = 0;
        int lastLimitDoc = this.docs[0];
        for (LeafReaderContext lrc : leaves) {
            assert (lrc.ord != 0 || lastLimitDoc >= lrc.docBase);
            int max = lrc.docBase + lrc.reader().maxDoc();
            if (lastLimitDoc >= max) {
                ret[lrc.ord] = lastLimit;
                continue;
            }
            assert (lastLimitDoc >= lrc.docBase);
            int nextLimit = Arrays.binarySearch(this.docs, lastLimit + 1, this.docs.length, max);
            lastLimit = nextLimit < 0 ? ~nextLimit : nextLimit;
            lastLimitDoc = lastLimit < this.docs.length ? this.docs[lastLimit] : Integer.MAX_VALUE;
            ret[lrc.ord] = lastLimit;
        }
        this.cachedOrdIdxMap = ret;
        return ret;
    }

    @Override
    public DocIdSetIterator iterator(LeafReaderContext context) {
        int limitIdx;
        int startIdx;
        if (this.docs.length == 0 || context.reader().maxDoc() < 1) {
            return null;
        }
        if (context.isTopLevel) {
            startIdx = 0;
            limitIdx = this.docs.length;
        } else {
            int[] ordIdxMap;
            startIdx = context.ord == 0 ? 0 : ordIdxMap[context.ord - 1];
            if (startIdx >= (limitIdx = (ordIdxMap = this.getOrdIdxMap(context))[context.ord])) {
                return null;
            }
        }
        final int base = context.docBase;
        return new DocIdSetIterator(){
            int idx;
            int adjustedDoc;
            {
                this.idx = startIdx - 1;
                this.adjustedDoc = -1;
            }

            public int docID() {
                return this.adjustedDoc;
            }

            public int nextDoc() {
                this.adjustedDoc = ++this.idx >= limitIdx ? Integer.MAX_VALUE : SortedIntDocSet.this.docs[this.idx] - base;
                return this.adjustedDoc;
            }

            public int advance(int target) {
                if (++this.idx >= limitIdx || target == Integer.MAX_VALUE) {
                    this.adjustedDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int rawDoc = SortedIntDocSet.this.docs[this.idx];
                if (rawDoc >= (target += base)) {
                    this.adjustedDoc = rawDoc - base;
                    return this.adjustedDoc;
                }
                int findIdx = Arrays.binarySearch(SortedIntDocSet.this.docs, this.idx + 1, limitIdx, target);
                this.idx = findIdx < 0 ? ~findIdx : findIdx;
                this.adjustedDoc = this.idx < limitIdx ? SortedIntDocSet.this.docs[this.idx] - base : Integer.MAX_VALUE;
                return this.adjustedDoc;
            }

            public long cost() {
                return (long)limitIdx - (long)startIdx;
            }
        };
    }

    @Override
    public DocSetQuery makeQuery() {
        return new DocSetQuery(this);
    }

    @Override
    public SortedIntDocSet clone() {
        return new SortedIntDocSet((int[])this.docs.clone());
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (long)(this.docs.length << 2);
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return "SortedIntDocSet{size=" + this.size() + ",ramUsed=" + RamUsageEstimator.humanReadableUnits((long)this.ramBytesUsed()) + "}";
    }
}

