/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.concurrent.TimeUnit;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QueryLimit;

public class TimeAllowedLimit
implements QueryLimit {
    private final long timeoutAt;
    private final long timingSince;

    public TimeAllowedLimit(SolrQueryRequest req) {
        long reqTimeAllowed = req.getParams().getLong("timeAllowed", -1L);
        if (reqTimeAllowed == -1L) {
            throw new IllegalArgumentException("Check for limit with hasTimeLimit(req) before creating a TimeAllowedLimit");
        }
        long timeAlreadySpent = (long)req.getRequestTimer().getTime();
        long now = System.nanoTime();
        long timeAllowed = reqTimeAllowed - timeAlreadySpent;
        long nanosAllowed = TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS);
        this.timeoutAt = now + nanosAllowed;
        this.timingSince = now - timeAlreadySpent;
    }

    static boolean hasTimeLimit(SolrQueryRequest req) {
        return req.getParams().getLong("timeAllowed", -1L) >= 0L;
    }

    public boolean shouldExit() {
        return this.timeoutAt - System.nanoTime() < 0L;
    }

    @Override
    public Object currentValue() {
        return System.nanoTime() - this.timingSince;
    }
}

