// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/dataset_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The dataset usage (e.g. training/validation).
type AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage int32

const (
	// Default value. Should not be used.
	AssessDataRequest_TuningValidationAssessmentConfig_DATASET_USAGE_UNSPECIFIED AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage = 0
	// Supervised fine-tuning training dataset.
	AssessDataRequest_TuningValidationAssessmentConfig_SFT_TRAINING AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage = 1
	// Supervised fine-tuning validation dataset.
	AssessDataRequest_TuningValidationAssessmentConfig_SFT_VALIDATION AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage = 2
)

// Enum value maps for AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage.
var (
	AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage_name = map[int32]string{
		0: "DATASET_USAGE_UNSPECIFIED",
		1: "SFT_TRAINING",
		2: "SFT_VALIDATION",
	}
	AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage_value = map[string]int32{
		"DATASET_USAGE_UNSPECIFIED": 0,
		"SFT_TRAINING":              1,
		"SFT_VALIDATION":            2,
	}
)

func (x AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) Enum() *AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage {
	p := new(AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage)
	*p = x
	return p
}

func (x AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_enumTypes[0].Descriptor()
}

func (AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_enumTypes[0]
}

func (x AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage.Descriptor instead.
func (AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33, 0, 0}
}

// Request message for
// [DatasetService.CreateDataset][google.cloud.aiplatform.v1beta1.DatasetService.CreateDataset].
type CreateDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the Dataset in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Dataset to create.
	Dataset *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
}

func (x *CreateDatasetRequest) Reset() {
	*x = CreateDatasetRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetRequest) ProtoMessage() {}

func (x *CreateDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetRequest.ProtoReflect.Descriptor instead.
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDatasetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDatasetRequest) GetDataset() *Dataset {
	if x != nil {
		return x.Dataset
	}
	return nil
}

// Runtime operation information for
// [DatasetService.CreateDataset][google.cloud.aiplatform.v1beta1.DatasetService.CreateDataset].
type CreateDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateDatasetOperationMetadata) Reset() {
	*x = CreateDatasetOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetOperationMetadata) ProtoMessage() {}

func (x *CreateDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateDatasetOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [DatasetService.GetDataset][google.cloud.aiplatform.v1beta1.DatasetService.GetDataset].
type GetDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Dataset resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *GetDatasetRequest) Reset() {
	*x = GetDatasetRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatasetRequest) ProtoMessage() {}

func (x *GetDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatasetRequest.ProtoReflect.Descriptor instead.
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDatasetRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Request message for
// [DatasetService.UpdateDataset][google.cloud.aiplatform.v1beta1.DatasetService.UpdateDataset].
type UpdateDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Dataset which replaces the resource on the server.
	Dataset *Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// [google.protobuf.FieldMask][google.protobuf.FieldMask]. Updatable fields:
	//
	//   - `display_name`
	//   - `description`
	//   - `labels`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDatasetRequest) Reset() {
	*x = UpdateDatasetRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDatasetRequest) ProtoMessage() {}

func (x *UpdateDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDatasetRequest.ProtoReflect.Descriptor instead.
func (*UpdateDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateDatasetRequest) GetDataset() *Dataset {
	if x != nil {
		return x.Dataset
	}
	return nil
}

func (x *UpdateDatasetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DatasetService.UpdateDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.UpdateDatasetVersion].
type UpdateDatasetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatasetVersion which replaces the resource on the server.
	DatasetVersion *DatasetVersion `protobuf:"bytes,1,opt,name=dataset_version,json=datasetVersion,proto3" json:"dataset_version,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// [google.protobuf.FieldMask][google.protobuf.FieldMask]. Updatable fields:
	//
	//   - `display_name`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDatasetVersionRequest) Reset() {
	*x = UpdateDatasetVersionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDatasetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDatasetVersionRequest) ProtoMessage() {}

func (x *UpdateDatasetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDatasetVersionRequest.ProtoReflect.Descriptor instead.
func (*UpdateDatasetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateDatasetVersionRequest) GetDatasetVersion() *DatasetVersion {
	if x != nil {
		return x.DatasetVersion
	}
	return nil
}

func (x *UpdateDatasetVersionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DatasetService.ListDatasets][google.cloud.aiplatform.v1beta1.DatasetService.ListDatasets].
type ListDatasetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Dataset's parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request. For field names
	// both snake_case and camelCase are supported.
	//
	//   - `display_name`: supports = and !=
	//   - `metadata_schema_uri`: supports = and !=
	//   - `labels` supports general map functions that is:
	//   - `labels.key=value` - key:value equality
	//   - `labels.key:* or labels:key - key existence
	//   - A key including a space must be quoted. `labels."a key"`.
	//
	// Some examples:
	//
	//   - `displayName="myDisplayName"`
	//   - `labels.myKey="myValue"`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	// Supported fields:
	//
	//   - `display_name`
	//   - `create_time`
	//   - `update_time`
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDatasetsRequest) Reset() {
	*x = ListDatasetsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatasetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetsRequest) ProtoMessage() {}

func (x *ListDatasetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetsRequest.ProtoReflect.Descriptor instead.
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListDatasetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDatasetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDatasetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatasetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDatasetsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListDatasetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [DatasetService.ListDatasets][google.cloud.aiplatform.v1beta1.DatasetService.ListDatasets].
type ListDatasetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Datasets that matches the specified filter in the request.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDatasetsResponse) Reset() {
	*x = ListDatasetsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatasetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetsResponse) ProtoMessage() {}

func (x *ListDatasetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetsResponse.ProtoReflect.Descriptor instead.
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListDatasetsResponse) GetDatasets() []*Dataset {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (x *ListDatasetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DatasetService.DeleteDataset][google.cloud.aiplatform.v1beta1.DatasetService.DeleteDataset].
type DeleteDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset to delete.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDatasetRequest) Reset() {
	*x = DeleteDatasetRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatasetRequest) ProtoMessage() {}

func (x *DeleteDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatasetRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [DatasetService.ImportData][google.cloud.aiplatform.v1beta1.DatasetService.ImportData].
type ImportDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Dataset resource.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input locations. The contents of all input locations
	// will be imported in one batch.
	ImportConfigs []*ImportDataConfig `protobuf:"bytes,2,rep,name=import_configs,json=importConfigs,proto3" json:"import_configs,omitempty"`
}

func (x *ImportDataRequest) Reset() {
	*x = ImportDataRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataRequest) ProtoMessage() {}

func (x *ImportDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataRequest.ProtoReflect.Descriptor instead.
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{8}
}

func (x *ImportDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportDataRequest) GetImportConfigs() []*ImportDataConfig {
	if x != nil {
		return x.ImportConfigs
	}
	return nil
}

// Response message for
// [DatasetService.ImportData][google.cloud.aiplatform.v1beta1.DatasetService.ImportData].
type ImportDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportDataResponse) Reset() {
	*x = ImportDataResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataResponse) ProtoMessage() {}

func (x *ImportDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataResponse.ProtoReflect.Descriptor instead.
func (*ImportDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{9}
}

// Runtime operation information for
// [DatasetService.ImportData][google.cloud.aiplatform.v1beta1.DatasetService.ImportData].
type ImportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *ImportDataOperationMetadata) Reset() {
	*x = ImportDataOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataOperationMetadata) ProtoMessage() {}

func (x *ImportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{10}
}

func (x *ImportDataOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [DatasetService.ExportData][google.cloud.aiplatform.v1beta1.DatasetService.ExportData].
type ExportDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Dataset resource.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	ExportConfig *ExportDataConfig `protobuf:"bytes,2,opt,name=export_config,json=exportConfig,proto3" json:"export_config,omitempty"`
}

func (x *ExportDataRequest) Reset() {
	*x = ExportDataRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataRequest) ProtoMessage() {}

func (x *ExportDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataRequest.ProtoReflect.Descriptor instead.
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{11}
}

func (x *ExportDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportDataRequest) GetExportConfig() *ExportDataConfig {
	if x != nil {
		return x.ExportConfig
	}
	return nil
}

// Response message for
// [DatasetService.ExportData][google.cloud.aiplatform.v1beta1.DatasetService.ExportData].
type ExportDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All of the files that are exported in this export operation. For custom
	// code training export, only three (training, validation and test)
	// Cloud Storage paths in wildcard format are populated
	// (for example, gs://.../training-*).
	ExportedFiles []string `protobuf:"bytes,1,rep,name=exported_files,json=exportedFiles,proto3" json:"exported_files,omitempty"`
}

func (x *ExportDataResponse) Reset() {
	*x = ExportDataResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataResponse) ProtoMessage() {}

func (x *ExportDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataResponse.ProtoReflect.Descriptor instead.
func (*ExportDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{12}
}

func (x *ExportDataResponse) GetExportedFiles() []string {
	if x != nil {
		return x.ExportedFiles
	}
	return nil
}

// Runtime operation information for
// [DatasetService.ExportData][google.cloud.aiplatform.v1beta1.DatasetService.ExportData].
type ExportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// A Google Cloud Storage directory which path ends with '/'. The exported
	// data is stored in the directory.
	GcsOutputDirectory string `protobuf:"bytes,2,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3" json:"gcs_output_directory,omitempty"`
}

func (x *ExportDataOperationMetadata) Reset() {
	*x = ExportDataOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationMetadata) ProtoMessage() {}

func (x *ExportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{13}
}

func (x *ExportDataOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *ExportDataOperationMetadata) GetGcsOutputDirectory() string {
	if x != nil {
		return x.GcsOutputDirectory
	}
	return ""
}

// Request message for
// [DatasetService.CreateDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.CreateDatasetVersion].
type CreateDatasetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Dataset resource.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The version to be created. The same CMEK policies with the
	// original Dataset will be applied the dataset version. So here we don't need
	// to specify the EncryptionSpecType here.
	DatasetVersion *DatasetVersion `protobuf:"bytes,2,opt,name=dataset_version,json=datasetVersion,proto3" json:"dataset_version,omitempty"`
}

func (x *CreateDatasetVersionRequest) Reset() {
	*x = CreateDatasetVersionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatasetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetVersionRequest) ProtoMessage() {}

func (x *CreateDatasetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetVersionRequest.ProtoReflect.Descriptor instead.
func (*CreateDatasetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{14}
}

func (x *CreateDatasetVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDatasetVersionRequest) GetDatasetVersion() *DatasetVersion {
	if x != nil {
		return x.DatasetVersion
	}
	return nil
}

// Runtime operation information for
// [DatasetService.CreateDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.CreateDatasetVersion].
type CreateDatasetVersionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateDatasetVersionOperationMetadata) Reset() {
	*x = CreateDatasetVersionOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatasetVersionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetVersionOperationMetadata) ProtoMessage() {}

func (x *CreateDatasetVersionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetVersionOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateDatasetVersionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{15}
}

func (x *CreateDatasetVersionOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [DatasetService.DeleteDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.DeleteDatasetVersion].
type DeleteDatasetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset version to delete.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDatasetVersionRequest) Reset() {
	*x = DeleteDatasetVersionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDatasetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatasetVersionRequest) ProtoMessage() {}

func (x *DeleteDatasetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatasetVersionRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatasetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteDatasetVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [DatasetService.GetDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.GetDatasetVersion].
type GetDatasetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset version to delete.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *GetDatasetVersionRequest) Reset() {
	*x = GetDatasetVersionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDatasetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatasetVersionRequest) ProtoMessage() {}

func (x *GetDatasetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatasetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetDatasetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetDatasetVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDatasetVersionRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Request message for
// [DatasetService.ListDatasetVersions][google.cloud.aiplatform.v1beta1.DatasetService.ListDatasetVersions].
type ListDatasetVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset to list DatasetVersions from.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// Optional. A comma-separated list of fields to order by, sorted in ascending
	// order. Use "desc" after a field name for descending.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDatasetVersionsRequest) Reset() {
	*x = ListDatasetVersionsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatasetVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetVersionsRequest) ProtoMessage() {}

func (x *ListDatasetVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListDatasetVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListDatasetVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDatasetVersionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDatasetVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatasetVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDatasetVersionsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListDatasetVersionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [DatasetService.ListDatasetVersions][google.cloud.aiplatform.v1beta1.DatasetService.ListDatasetVersions].
type ListDatasetVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of DatasetVersions that matches the specified filter in the request.
	DatasetVersions []*DatasetVersion `protobuf:"bytes,1,rep,name=dataset_versions,json=datasetVersions,proto3" json:"dataset_versions,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDatasetVersionsResponse) Reset() {
	*x = ListDatasetVersionsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatasetVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetVersionsResponse) ProtoMessage() {}

func (x *ListDatasetVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListDatasetVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListDatasetVersionsResponse) GetDatasetVersions() []*DatasetVersion {
	if x != nil {
		return x.DatasetVersions
	}
	return nil
}

func (x *ListDatasetVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DatasetService.RestoreDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.RestoreDatasetVersion].
type RestoreDatasetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DatasetVersion resource.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RestoreDatasetVersionRequest) Reset() {
	*x = RestoreDatasetVersionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreDatasetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreDatasetVersionRequest) ProtoMessage() {}

func (x *RestoreDatasetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreDatasetVersionRequest.ProtoReflect.Descriptor instead.
func (*RestoreDatasetVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{20}
}

func (x *RestoreDatasetVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Runtime operation information for
// [DatasetService.RestoreDatasetVersion][google.cloud.aiplatform.v1beta1.DatasetService.RestoreDatasetVersion].
type RestoreDatasetVersionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *RestoreDatasetVersionOperationMetadata) Reset() {
	*x = RestoreDatasetVersionOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreDatasetVersionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreDatasetVersionOperationMetadata) ProtoMessage() {}

func (x *RestoreDatasetVersionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreDatasetVersionOperationMetadata.ProtoReflect.Descriptor instead.
func (*RestoreDatasetVersionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{21}
}

func (x *RestoreDatasetVersionOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [DatasetService.ListDataItems][google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems].
type ListDataItemsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset to list DataItems from.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDataItemsRequest) Reset() {
	*x = ListDataItemsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataItemsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataItemsRequest) ProtoMessage() {}

func (x *ListDataItemsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataItemsRequest.ProtoReflect.Descriptor instead.
func (*ListDataItemsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListDataItemsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataItemsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDataItemsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataItemsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataItemsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListDataItemsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [DatasetService.ListDataItems][google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems].
type ListDataItemsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of DataItems that matches the specified filter in the request.
	DataItems []*DataItem `protobuf:"bytes,1,rep,name=data_items,json=dataItems,proto3" json:"data_items,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataItemsResponse) Reset() {
	*x = ListDataItemsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataItemsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataItemsResponse) ProtoMessage() {}

func (x *ListDataItemsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataItemsResponse.ProtoReflect.Descriptor instead.
func (*ListDataItemsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListDataItemsResponse) GetDataItems() []*DataItem {
	if x != nil {
		return x.DataItems
	}
	return nil
}

func (x *ListDataItemsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems].
type SearchDataItemsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Order:
	//
	//	*SearchDataItemsRequest_OrderByDataItem
	//	*SearchDataItemsRequest_OrderByAnnotation_
	Order isSearchDataItemsRequest_Order `protobuf_oneof:"order"`
	// Required. The resource name of the Dataset from which to search DataItems.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The resource name of a SavedQuery(annotation set in UI).
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
	// All of the search will be done in the context of this SavedQuery.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
	SavedQuery string `protobuf:"bytes,2,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// The resource name of a DataLabelingJob.
	// Format:
	// `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
	// If this field is set, all of the search will be done in the context of
	// this DataLabelingJob.
	DataLabelingJob string `protobuf:"bytes,3,opt,name=data_labeling_job,json=dataLabelingJob,proto3" json:"data_labeling_job,omitempty"`
	// An expression for filtering the DataItem that will be returned.
	//
	//   - `data_item_id` - for = or !=.
	//   - `labeled` - for = or !=.
	//   - `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
	//     have at least one annotation with annotation_spec_id =
	//     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
	//
	// For example:
	//
	// * `data_item=1`
	// * `has_annotation(5)`
	DataItemFilter string `protobuf:"bytes,4,opt,name=data_item_filter,json=dataItemFilter,proto3" json:"data_item_filter,omitempty"`
	// An expression for filtering the Annotations that will be returned per
	// DataItem.
	//   - `annotation_spec_id` - for = or !=.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
	AnnotationsFilter string `protobuf:"bytes,5,opt,name=annotations_filter,json=annotationsFilter,proto3" json:"annotations_filter,omitempty"`
	// An expression that specifies what Annotations will be returned per
	// DataItem. Annotations satisfied either of the conditions will be returned.
	//   - `annotation_spec_id` - for = or !=.
	//
	// Must specify `saved_query_id=` - saved query id that annotations should
	// belong to.
	AnnotationFilters []string `protobuf:"bytes,11,rep,name=annotation_filters,json=annotationFilters,proto3" json:"annotation_filters,omitempty"`
	// Mask specifying which fields of
	// [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// If set, only up to this many of Annotations will be returned per
	// DataItemView. The maximum value is 1000. If not set, the maximum value will
	// be used.
	AnnotationsLimit int32 `protobuf:"varint,7,opt,name=annotations_limit,json=annotationsLimit,proto3" json:"annotations_limit,omitempty"`
	// Requested page size. Server may return fewer results than requested.
	// Default and maximum page size is 100.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
	OrderBy string `protobuf:"bytes,9,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
	// of the previous
	// [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
	// call.
	PageToken string `protobuf:"bytes,10,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchDataItemsRequest) Reset() {
	*x = SearchDataItemsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDataItemsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDataItemsRequest) ProtoMessage() {}

func (x *SearchDataItemsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDataItemsRequest.ProtoReflect.Descriptor instead.
func (*SearchDataItemsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{24}
}

func (m *SearchDataItemsRequest) GetOrder() isSearchDataItemsRequest_Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (x *SearchDataItemsRequest) GetOrderByDataItem() string {
	if x, ok := x.GetOrder().(*SearchDataItemsRequest_OrderByDataItem); ok {
		return x.OrderByDataItem
	}
	return ""
}

func (x *SearchDataItemsRequest) GetOrderByAnnotation() *SearchDataItemsRequest_OrderByAnnotation {
	if x, ok := x.GetOrder().(*SearchDataItemsRequest_OrderByAnnotation_); ok {
		return x.OrderByAnnotation
	}
	return nil
}

func (x *SearchDataItemsRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
func (x *SearchDataItemsRequest) GetSavedQuery() string {
	if x != nil {
		return x.SavedQuery
	}
	return ""
}

func (x *SearchDataItemsRequest) GetDataLabelingJob() string {
	if x != nil {
		return x.DataLabelingJob
	}
	return ""
}

func (x *SearchDataItemsRequest) GetDataItemFilter() string {
	if x != nil {
		return x.DataItemFilter
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
func (x *SearchDataItemsRequest) GetAnnotationsFilter() string {
	if x != nil {
		return x.AnnotationsFilter
	}
	return ""
}

func (x *SearchDataItemsRequest) GetAnnotationFilters() []string {
	if x != nil {
		return x.AnnotationFilters
	}
	return nil
}

func (x *SearchDataItemsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *SearchDataItemsRequest) GetAnnotationsLimit() int32 {
	if x != nil {
		return x.AnnotationsLimit
	}
	return 0
}

func (x *SearchDataItemsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/dataset_service.proto.
func (x *SearchDataItemsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchDataItemsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type isSearchDataItemsRequest_Order interface {
	isSearchDataItemsRequest_Order()
}

type SearchDataItemsRequest_OrderByDataItem struct {
	// A comma-separated list of data item fields to order by, sorted in
	// ascending order. Use "desc" after a field name for descending.
	OrderByDataItem string `protobuf:"bytes,12,opt,name=order_by_data_item,json=orderByDataItem,proto3,oneof"`
}

type SearchDataItemsRequest_OrderByAnnotation_ struct {
	// Expression that allows ranking results based on annotation's property.
	OrderByAnnotation *SearchDataItemsRequest_OrderByAnnotation `protobuf:"bytes,13,opt,name=order_by_annotation,json=orderByAnnotation,proto3,oneof"`
}

func (*SearchDataItemsRequest_OrderByDataItem) isSearchDataItemsRequest_Order() {}

func (*SearchDataItemsRequest_OrderByAnnotation_) isSearchDataItemsRequest_Order() {}

// Response message for
// [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems].
type SearchDataItemsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DataItemViews read.
	DataItemViews []*DataItemView `protobuf:"bytes,1,rep,name=data_item_views,json=dataItemViews,proto3" json:"data_item_views,omitempty"`
	// A token to retrieve next page of results.
	// Pass to
	// [SearchDataItemsRequest.page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchDataItemsResponse) Reset() {
	*x = SearchDataItemsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDataItemsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDataItemsResponse) ProtoMessage() {}

func (x *SearchDataItemsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDataItemsResponse.ProtoReflect.Descriptor instead.
func (*SearchDataItemsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{25}
}

func (x *SearchDataItemsResponse) GetDataItemViews() []*DataItemView {
	if x != nil {
		return x.DataItemViews
	}
	return nil
}

func (x *SearchDataItemsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A container for a single DataItem and Annotations on it.
type DataItemView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DataItem.
	DataItem *DataItem `protobuf:"bytes,1,opt,name=data_item,json=dataItem,proto3" json:"data_item,omitempty"`
	// The Annotations on the DataItem. If too many Annotations should be returned
	// for the DataItem, this field will be truncated per annotations_limit in
	// request. If it was, then the has_truncated_annotations will be set to true.
	Annotations []*Annotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// True if and only if the Annotations field has been truncated. It happens if
	// more Annotations for this DataItem met the request's annotation_filter than
	// are allowed to be returned by annotations_limit.
	// Note that if Annotations field is not being returned due to field mask,
	// then this field will not be set to true no matter how many Annotations are
	// there.
	HasTruncatedAnnotations bool `protobuf:"varint,3,opt,name=has_truncated_annotations,json=hasTruncatedAnnotations,proto3" json:"has_truncated_annotations,omitempty"`
}

func (x *DataItemView) Reset() {
	*x = DataItemView{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataItemView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataItemView) ProtoMessage() {}

func (x *DataItemView) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataItemView.ProtoReflect.Descriptor instead.
func (*DataItemView) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{26}
}

func (x *DataItemView) GetDataItem() *DataItem {
	if x != nil {
		return x.DataItem
	}
	return nil
}

func (x *DataItemView) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *DataItemView) GetHasTruncatedAnnotations() bool {
	if x != nil {
		return x.HasTruncatedAnnotations
	}
	return false
}

// Request message for
// [DatasetService.ListSavedQueries][google.cloud.aiplatform.v1beta1.DatasetService.ListSavedQueries].
type ListSavedQueriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Dataset to list SavedQueries from.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSavedQueriesRequest) Reset() {
	*x = ListSavedQueriesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSavedQueriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesRequest) ProtoMessage() {}

func (x *ListSavedQueriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesRequest.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListSavedQueriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSavedQueriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListSavedQueriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [DatasetService.ListSavedQueries][google.cloud.aiplatform.v1beta1.DatasetService.ListSavedQueries].
type ListSavedQueriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of SavedQueries that match the specified filter in the request.
	SavedQueries []*SavedQuery `protobuf:"bytes,1,rep,name=saved_queries,json=savedQueries,proto3" json:"saved_queries,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSavedQueriesResponse) Reset() {
	*x = ListSavedQueriesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSavedQueriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesResponse) ProtoMessage() {}

func (x *ListSavedQueriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesResponse.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListSavedQueriesResponse) GetSavedQueries() []*SavedQuery {
	if x != nil {
		return x.SavedQueries
	}
	return nil
}

func (x *ListSavedQueriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DatasetService.DeleteSavedQuery][google.cloud.aiplatform.v1beta1.DatasetService.DeleteSavedQuery].
type DeleteSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the SavedQuery to delete.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSavedQueryRequest) Reset() {
	*x = DeleteSavedQueryRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSavedQueryRequest) ProtoMessage() {}

func (x *DeleteSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*DeleteSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteSavedQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [DatasetService.GetAnnotationSpec][google.cloud.aiplatform.v1beta1.DatasetService.GetAnnotationSpec].
type GetAnnotationSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the AnnotationSpec resource.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *GetAnnotationSpecRequest) Reset() {
	*x = GetAnnotationSpecRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAnnotationSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnnotationSpecRequest) ProtoMessage() {}

func (x *GetAnnotationSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnnotationSpecRequest.ProtoReflect.Descriptor instead.
func (*GetAnnotationSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{30}
}

func (x *GetAnnotationSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAnnotationSpecRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Request message for
// [DatasetService.ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
type ListAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataItem to list Annotations from.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAnnotationsRequest) Reset() {
	*x = ListAnnotationsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsRequest) ProtoMessage() {}

func (x *ListAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListAnnotationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnnotationsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListAnnotationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [DatasetService.ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
type ListAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Annotations that matches the specified filter in the request.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationsResponse) Reset() {
	*x = ListAnnotationsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsResponse) ProtoMessage() {}

func (x *ListAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ListAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DatasetService.AssessData][google.cloud.aiplatform.v1beta1.DatasetService.AssessData].
// Used only for MULTIMODAL datasets.
type AssessDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The assessment type.
	//
	// Types that are assignable to AssessmentConfig:
	//
	//	*AssessDataRequest_TuningValidationAssessmentConfig_
	//	*AssessDataRequest_TuningResourceUsageAssessmentConfig_
	//	*AssessDataRequest_BatchPredictionValidationAssessmentConfig_
	//	*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_
	AssessmentConfig isAssessDataRequest_AssessmentConfig `protobuf_oneof:"assessment_config"`
	// The read config for the dataset.
	//
	// Types that are assignable to ReadConfig:
	//
	//	*AssessDataRequest_GeminiTemplateConfig
	//	*AssessDataRequest_RequestColumnName
	ReadConfig isAssessDataRequest_ReadConfig `protobuf_oneof:"read_config"`
	// Required. The name of the Dataset resource. Used only for MULTIMODAL
	// datasets. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AssessDataRequest) Reset() {
	*x = AssessDataRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataRequest) ProtoMessage() {}

func (x *AssessDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataRequest.ProtoReflect.Descriptor instead.
func (*AssessDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33}
}

func (m *AssessDataRequest) GetAssessmentConfig() isAssessDataRequest_AssessmentConfig {
	if m != nil {
		return m.AssessmentConfig
	}
	return nil
}

func (x *AssessDataRequest) GetTuningValidationAssessmentConfig() *AssessDataRequest_TuningValidationAssessmentConfig {
	if x, ok := x.GetAssessmentConfig().(*AssessDataRequest_TuningValidationAssessmentConfig_); ok {
		return x.TuningValidationAssessmentConfig
	}
	return nil
}

func (x *AssessDataRequest) GetTuningResourceUsageAssessmentConfig() *AssessDataRequest_TuningResourceUsageAssessmentConfig {
	if x, ok := x.GetAssessmentConfig().(*AssessDataRequest_TuningResourceUsageAssessmentConfig_); ok {
		return x.TuningResourceUsageAssessmentConfig
	}
	return nil
}

func (x *AssessDataRequest) GetBatchPredictionValidationAssessmentConfig() *AssessDataRequest_BatchPredictionValidationAssessmentConfig {
	if x, ok := x.GetAssessmentConfig().(*AssessDataRequest_BatchPredictionValidationAssessmentConfig_); ok {
		return x.BatchPredictionValidationAssessmentConfig
	}
	return nil
}

func (x *AssessDataRequest) GetBatchPredictionResourceUsageAssessmentConfig() *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig {
	if x, ok := x.GetAssessmentConfig().(*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_); ok {
		return x.BatchPredictionResourceUsageAssessmentConfig
	}
	return nil
}

func (m *AssessDataRequest) GetReadConfig() isAssessDataRequest_ReadConfig {
	if m != nil {
		return m.ReadConfig
	}
	return nil
}

func (x *AssessDataRequest) GetGeminiTemplateConfig() *GeminiTemplateConfig {
	if x, ok := x.GetReadConfig().(*AssessDataRequest_GeminiTemplateConfig); ok {
		return x.GeminiTemplateConfig
	}
	return nil
}

func (x *AssessDataRequest) GetRequestColumnName() string {
	if x, ok := x.GetReadConfig().(*AssessDataRequest_RequestColumnName); ok {
		return x.RequestColumnName
	}
	return ""
}

func (x *AssessDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isAssessDataRequest_AssessmentConfig interface {
	isAssessDataRequest_AssessmentConfig()
}

type AssessDataRequest_TuningValidationAssessmentConfig_ struct {
	// Optional. Configuration for the tuning validation assessment.
	TuningValidationAssessmentConfig *AssessDataRequest_TuningValidationAssessmentConfig `protobuf:"bytes,2,opt,name=tuning_validation_assessment_config,json=tuningValidationAssessmentConfig,proto3,oneof"`
}

type AssessDataRequest_TuningResourceUsageAssessmentConfig_ struct {
	// Optional. Configuration for the tuning resource usage assessment.
	TuningResourceUsageAssessmentConfig *AssessDataRequest_TuningResourceUsageAssessmentConfig `protobuf:"bytes,3,opt,name=tuning_resource_usage_assessment_config,json=tuningResourceUsageAssessmentConfig,proto3,oneof"`
}

type AssessDataRequest_BatchPredictionValidationAssessmentConfig_ struct {
	// Optional. Configuration for the batch prediction validation assessment.
	BatchPredictionValidationAssessmentConfig *AssessDataRequest_BatchPredictionValidationAssessmentConfig `protobuf:"bytes,6,opt,name=batch_prediction_validation_assessment_config,json=batchPredictionValidationAssessmentConfig,proto3,oneof"`
}

type AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_ struct {
	// Optional. Configuration for the batch prediction resource usage
	// assessment.
	BatchPredictionResourceUsageAssessmentConfig *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig `protobuf:"bytes,7,opt,name=batch_prediction_resource_usage_assessment_config,json=batchPredictionResourceUsageAssessmentConfig,proto3,oneof"`
}

func (*AssessDataRequest_TuningValidationAssessmentConfig_) isAssessDataRequest_AssessmentConfig() {}

func (*AssessDataRequest_TuningResourceUsageAssessmentConfig_) isAssessDataRequest_AssessmentConfig() {
}

func (*AssessDataRequest_BatchPredictionValidationAssessmentConfig_) isAssessDataRequest_AssessmentConfig() {
}

func (*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_) isAssessDataRequest_AssessmentConfig() {
}

type isAssessDataRequest_ReadConfig interface {
	isAssessDataRequest_ReadConfig()
}

type AssessDataRequest_GeminiTemplateConfig struct {
	// Optional. Config for assembling templates with a Gemini API structure to
	// assess assembled data.
	GeminiTemplateConfig *GeminiTemplateConfig `protobuf:"bytes,4,opt,name=gemini_template_config,json=geminiTemplateConfig,proto3,oneof"`
}

type AssessDataRequest_RequestColumnName struct {
	// Optional. The column name in the underlying table that contains already
	// fully assembled requests.
	RequestColumnName string `protobuf:"bytes,5,opt,name=request_column_name,json=requestColumnName,proto3,oneof"`
}

func (*AssessDataRequest_GeminiTemplateConfig) isAssessDataRequest_ReadConfig() {}

func (*AssessDataRequest_RequestColumnName) isAssessDataRequest_ReadConfig() {}

// Response message for
// [DatasetService.AssessData][google.cloud.aiplatform.v1beta1.DatasetService.AssessData].
type AssessDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The assessment result.
	//
	// Types that are assignable to AssessmentResult:
	//
	//	*AssessDataResponse_TuningValidationAssessmentResult_
	//	*AssessDataResponse_TuningResourceUsageAssessmentResult_
	//	*AssessDataResponse_BatchPredictionValidationAssessmentResult_
	//	*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult_
	AssessmentResult isAssessDataResponse_AssessmentResult `protobuf_oneof:"assessment_result"`
}

func (x *AssessDataResponse) Reset() {
	*x = AssessDataResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataResponse) ProtoMessage() {}

func (x *AssessDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataResponse.ProtoReflect.Descriptor instead.
func (*AssessDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{34}
}

func (m *AssessDataResponse) GetAssessmentResult() isAssessDataResponse_AssessmentResult {
	if m != nil {
		return m.AssessmentResult
	}
	return nil
}

func (x *AssessDataResponse) GetTuningValidationAssessmentResult() *AssessDataResponse_TuningValidationAssessmentResult {
	if x, ok := x.GetAssessmentResult().(*AssessDataResponse_TuningValidationAssessmentResult_); ok {
		return x.TuningValidationAssessmentResult
	}
	return nil
}

func (x *AssessDataResponse) GetTuningResourceUsageAssessmentResult() *AssessDataResponse_TuningResourceUsageAssessmentResult {
	if x, ok := x.GetAssessmentResult().(*AssessDataResponse_TuningResourceUsageAssessmentResult_); ok {
		return x.TuningResourceUsageAssessmentResult
	}
	return nil
}

func (x *AssessDataResponse) GetBatchPredictionValidationAssessmentResult() *AssessDataResponse_BatchPredictionValidationAssessmentResult {
	if x, ok := x.GetAssessmentResult().(*AssessDataResponse_BatchPredictionValidationAssessmentResult_); ok {
		return x.BatchPredictionValidationAssessmentResult
	}
	return nil
}

func (x *AssessDataResponse) GetBatchPredictionResourceUsageAssessmentResult() *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult {
	if x, ok := x.GetAssessmentResult().(*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult_); ok {
		return x.BatchPredictionResourceUsageAssessmentResult
	}
	return nil
}

type isAssessDataResponse_AssessmentResult interface {
	isAssessDataResponse_AssessmentResult()
}

type AssessDataResponse_TuningValidationAssessmentResult_ struct {
	// Optional. The result of the tuning validation assessment.
	TuningValidationAssessmentResult *AssessDataResponse_TuningValidationAssessmentResult `protobuf:"bytes,1,opt,name=tuning_validation_assessment_result,json=tuningValidationAssessmentResult,proto3,oneof"`
}

type AssessDataResponse_TuningResourceUsageAssessmentResult_ struct {
	// Optional. The result of the tuning resource usage assessment.
	TuningResourceUsageAssessmentResult *AssessDataResponse_TuningResourceUsageAssessmentResult `protobuf:"bytes,2,opt,name=tuning_resource_usage_assessment_result,json=tuningResourceUsageAssessmentResult,proto3,oneof"`
}

type AssessDataResponse_BatchPredictionValidationAssessmentResult_ struct {
	// Optional. The result of the batch prediction validation assessment.
	BatchPredictionValidationAssessmentResult *AssessDataResponse_BatchPredictionValidationAssessmentResult `protobuf:"bytes,3,opt,name=batch_prediction_validation_assessment_result,json=batchPredictionValidationAssessmentResult,proto3,oneof"`
}

type AssessDataResponse_BatchPredictionResourceUsageAssessmentResult_ struct {
	// Optional. The result of the batch prediction resource usage assessment.
	BatchPredictionResourceUsageAssessmentResult *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult `protobuf:"bytes,4,opt,name=batch_prediction_resource_usage_assessment_result,json=batchPredictionResourceUsageAssessmentResult,proto3,oneof"`
}

func (*AssessDataResponse_TuningValidationAssessmentResult_) isAssessDataResponse_AssessmentResult() {
}

func (*AssessDataResponse_TuningResourceUsageAssessmentResult_) isAssessDataResponse_AssessmentResult() {
}

func (*AssessDataResponse_BatchPredictionValidationAssessmentResult_) isAssessDataResponse_AssessmentResult() {
}

func (*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult_) isAssessDataResponse_AssessmentResult() {
}

// Runtime operation information for
// [DatasetService.AssessData][google.cloud.aiplatform.v1beta1.DatasetService.AssessData].
type AssessDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *AssessDataOperationMetadata) Reset() {
	*x = AssessDataOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataOperationMetadata) ProtoMessage() {}

func (x *AssessDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*AssessDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{35}
}

func (x *AssessDataOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Template configuration to create Gemini examples from a multimodal dataset.
type GeminiTemplateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The template that will be used for assembling the request to use
	// for downstream applications.
	GeminiExample *GeminiExample `protobuf:"bytes,1,opt,name=gemini_example,json=geminiExample,proto3" json:"gemini_example,omitempty"`
	// Required. Map of template params to the columns in the dataset table.
	FieldMapping map[string]string `protobuf:"bytes,2,rep,name=field_mapping,json=fieldMapping,proto3" json:"field_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GeminiTemplateConfig) Reset() {
	*x = GeminiTemplateConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeminiTemplateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeminiTemplateConfig) ProtoMessage() {}

func (x *GeminiTemplateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeminiTemplateConfig.ProtoReflect.Descriptor instead.
func (*GeminiTemplateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{36}
}

func (x *GeminiTemplateConfig) GetGeminiExample() *GeminiExample {
	if x != nil {
		return x.GeminiExample
	}
	return nil
}

func (x *GeminiTemplateConfig) GetFieldMapping() map[string]string {
	if x != nil {
		return x.FieldMapping
	}
	return nil
}

// Format for Gemini examples used for Vertex Multimodal datasets.
type GeminiExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The fully qualified name of the publisher model or tuned model
	// endpoint to use.
	//
	// Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	//
	// Tuned model endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content of the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn
	// queries, this is a repeated field that contains conversation history +
	// latest request.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The user provided system instructions for the model.
	// Note: only text should be used in parts and content in each part will be
	// in a separate paragraph.
	SystemInstruction *Content `protobuf:"bytes,8,opt,name=system_instruction,json=systemInstruction,proto3,oneof" json:"system_instruction,omitempty"`
	// Optional. The name of the cached content used as context to serve the
	// prediction. Note: only used in explicit caching, where users can have
	// control over caching (e.g. what content to cache) and enjoy guaranteed cost
	// savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `protobuf:"bytes,9,opt,name=cached_content,json=cachedContent,proto3" json:"cached_content,omitempty"`
	// Optional. A list of `Tools` the model may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*Tool `protobuf:"bytes,6,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Tool config. This config is shared for all tools provided in the
	// request.
	ToolConfig *ToolConfig `protobuf:"bytes,7,opt,name=tool_config,json=toolConfig,proto3" json:"tool_config,omitempty"`
	// Optional. The labels with user-defined metadata for the request. It is used
	// for billing and reporting only.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints) and can only contain lowercase letters, numeric
	// characters, underscores, and dashes. International characters are
	// allowed. Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Generation config.
	GenerationConfig *GenerationConfig `protobuf:"bytes,4,opt,name=generation_config,json=generationConfig,proto3" json:"generation_config,omitempty"`
}

func (x *GeminiExample) Reset() {
	*x = GeminiExample{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeminiExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeminiExample) ProtoMessage() {}

func (x *GeminiExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeminiExample.ProtoReflect.Descriptor instead.
func (*GeminiExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{37}
}

func (x *GeminiExample) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GeminiExample) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GeminiExample) GetSystemInstruction() *Content {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *GeminiExample) GetCachedContent() string {
	if x != nil {
		return x.CachedContent
	}
	return ""
}

func (x *GeminiExample) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *GeminiExample) GetToolConfig() *ToolConfig {
	if x != nil {
		return x.ToolConfig
	}
	return nil
}

func (x *GeminiExample) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GeminiExample) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GeminiExample) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

// Request message for
// [DatasetService.AssembleData][google.cloud.aiplatform.v1beta1.DatasetService.AssembleData].
// Used only for MULTIMODAL datasets.
type AssembleDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The read config for the dataset.
	//
	// Types that are assignable to ReadConfig:
	//
	//	*AssembleDataRequest_GeminiTemplateConfig
	//	*AssembleDataRequest_RequestColumnName
	ReadConfig isAssembleDataRequest_ReadConfig `protobuf_oneof:"read_config"`
	// Required. The name of the Dataset resource (used only for MULTIMODAL
	// datasets). Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AssembleDataRequest) Reset() {
	*x = AssembleDataRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssembleDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssembleDataRequest) ProtoMessage() {}

func (x *AssembleDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssembleDataRequest.ProtoReflect.Descriptor instead.
func (*AssembleDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{38}
}

func (m *AssembleDataRequest) GetReadConfig() isAssembleDataRequest_ReadConfig {
	if m != nil {
		return m.ReadConfig
	}
	return nil
}

func (x *AssembleDataRequest) GetGeminiTemplateConfig() *GeminiTemplateConfig {
	if x, ok := x.GetReadConfig().(*AssembleDataRequest_GeminiTemplateConfig); ok {
		return x.GeminiTemplateConfig
	}
	return nil
}

func (x *AssembleDataRequest) GetRequestColumnName() string {
	if x, ok := x.GetReadConfig().(*AssembleDataRequest_RequestColumnName); ok {
		return x.RequestColumnName
	}
	return ""
}

func (x *AssembleDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isAssembleDataRequest_ReadConfig interface {
	isAssembleDataRequest_ReadConfig()
}

type AssembleDataRequest_GeminiTemplateConfig struct {
	// Optional. Config for assembling templates with a Gemini API structure.
	GeminiTemplateConfig *GeminiTemplateConfig `protobuf:"bytes,2,opt,name=gemini_template_config,json=geminiTemplateConfig,proto3,oneof"`
}

type AssembleDataRequest_RequestColumnName struct {
	// Optional. The column name in the underlying table that contains already
	// fully assembled requests. If this field is set, the original request will
	// be copied to the output table.
	RequestColumnName string `protobuf:"bytes,5,opt,name=request_column_name,json=requestColumnName,proto3,oneof"`
}

func (*AssembleDataRequest_GeminiTemplateConfig) isAssembleDataRequest_ReadConfig() {}

func (*AssembleDataRequest_RequestColumnName) isAssembleDataRequest_ReadConfig() {}

// Response message for
// [DatasetService.AssembleData][google.cloud.aiplatform.v1beta1.DatasetService.AssembleData].
type AssembleDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination BigQuery table path containing the assembled data as a single
	// column.
	BigqueryDestination string `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
}

func (x *AssembleDataResponse) Reset() {
	*x = AssembleDataResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssembleDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssembleDataResponse) ProtoMessage() {}

func (x *AssembleDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssembleDataResponse.ProtoReflect.Descriptor instead.
func (*AssembleDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{39}
}

func (x *AssembleDataResponse) GetBigqueryDestination() string {
	if x != nil {
		return x.BigqueryDestination
	}
	return ""
}

// Runtime operation information for
// [DatasetService.AssembleData][google.cloud.aiplatform.v1beta1.DatasetService.AssembleData].
type AssembleDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *AssembleDataOperationMetadata) Reset() {
	*x = AssembleDataOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssembleDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssembleDataOperationMetadata) ProtoMessage() {}

func (x *AssembleDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssembleDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*AssembleDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{40}
}

func (x *AssembleDataOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Expression that allows ranking results based on annotation's property.
type SearchDataItemsRequest_OrderByAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Saved query of the Annotation. Only Annotations belong to this
	// saved query will be considered for ordering.
	SavedQuery string `protobuf:"bytes,1,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// A comma-separated list of annotation fields to order by, sorted in
	// ascending order. Use "desc" after a field name for descending. Must also
	// specify saved_query.
	OrderBy string `protobuf:"bytes,2,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchDataItemsRequest_OrderByAnnotation) Reset() {
	*x = SearchDataItemsRequest_OrderByAnnotation{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDataItemsRequest_OrderByAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDataItemsRequest_OrderByAnnotation) ProtoMessage() {}

func (x *SearchDataItemsRequest_OrderByAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDataItemsRequest_OrderByAnnotation.ProtoReflect.Descriptor instead.
func (*SearchDataItemsRequest_OrderByAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{24, 0}
}

func (x *SearchDataItemsRequest_OrderByAnnotation) GetSavedQuery() string {
	if x != nil {
		return x.SavedQuery
	}
	return ""
}

func (x *SearchDataItemsRequest_OrderByAnnotation) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Configuration for the tuning validation assessment.
type AssessDataRequest_TuningValidationAssessmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model used for tuning.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	// Required. The dataset usage (e.g. training/validation).
	DatasetUsage AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage `protobuf:"varint,2,opt,name=dataset_usage,json=datasetUsage,proto3,enum=google.cloud.aiplatform.v1beta1.AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage" json:"dataset_usage,omitempty"`
}

func (x *AssessDataRequest_TuningValidationAssessmentConfig) Reset() {
	*x = AssessDataRequest_TuningValidationAssessmentConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataRequest_TuningValidationAssessmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataRequest_TuningValidationAssessmentConfig) ProtoMessage() {}

func (x *AssessDataRequest_TuningValidationAssessmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataRequest_TuningValidationAssessmentConfig.ProtoReflect.Descriptor instead.
func (*AssessDataRequest_TuningValidationAssessmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33, 0}
}

func (x *AssessDataRequest_TuningValidationAssessmentConfig) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

func (x *AssessDataRequest_TuningValidationAssessmentConfig) GetDatasetUsage() AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage {
	if x != nil {
		return x.DatasetUsage
	}
	return AssessDataRequest_TuningValidationAssessmentConfig_DATASET_USAGE_UNSPECIFIED
}

// Configuration for the tuning resource usage assessment.
type AssessDataRequest_TuningResourceUsageAssessmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model used for tuning.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
}

func (x *AssessDataRequest_TuningResourceUsageAssessmentConfig) Reset() {
	*x = AssessDataRequest_TuningResourceUsageAssessmentConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataRequest_TuningResourceUsageAssessmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataRequest_TuningResourceUsageAssessmentConfig) ProtoMessage() {}

func (x *AssessDataRequest_TuningResourceUsageAssessmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataRequest_TuningResourceUsageAssessmentConfig.ProtoReflect.Descriptor instead.
func (*AssessDataRequest_TuningResourceUsageAssessmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33, 1}
}

func (x *AssessDataRequest_TuningResourceUsageAssessmentConfig) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

// Configuration for the batch prediction validation assessment.
type AssessDataRequest_BatchPredictionValidationAssessmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model used for batch prediction.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
}

func (x *AssessDataRequest_BatchPredictionValidationAssessmentConfig) Reset() {
	*x = AssessDataRequest_BatchPredictionValidationAssessmentConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataRequest_BatchPredictionValidationAssessmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataRequest_BatchPredictionValidationAssessmentConfig) ProtoMessage() {}

func (x *AssessDataRequest_BatchPredictionValidationAssessmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataRequest_BatchPredictionValidationAssessmentConfig.ProtoReflect.Descriptor instead.
func (*AssessDataRequest_BatchPredictionValidationAssessmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33, 2}
}

func (x *AssessDataRequest_BatchPredictionValidationAssessmentConfig) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

// Configuration for the batch prediction resource usage assessment.
type AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model used for batch prediction.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
}

func (x *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) Reset() {
	*x = AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) ProtoMessage() {}

func (x *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig.ProtoReflect.Descriptor instead.
func (*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{33, 3}
}

func (x *AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

// The result of the tuning validation assessment.
type AssessDataResponse_TuningValidationAssessmentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list containing the first validation errors.
	Errors []string `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *AssessDataResponse_TuningValidationAssessmentResult) Reset() {
	*x = AssessDataResponse_TuningValidationAssessmentResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataResponse_TuningValidationAssessmentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataResponse_TuningValidationAssessmentResult) ProtoMessage() {}

func (x *AssessDataResponse_TuningValidationAssessmentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataResponse_TuningValidationAssessmentResult.ProtoReflect.Descriptor instead.
func (*AssessDataResponse_TuningValidationAssessmentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{34, 0}
}

func (x *AssessDataResponse_TuningValidationAssessmentResult) GetErrors() []string {
	if x != nil {
		return x.Errors
	}
	return nil
}

// The result of the tuning resource usage assessment.
type AssessDataResponse_TuningResourceUsageAssessmentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of tokens in the tuning dataset.
	TokenCount int64 `protobuf:"varint,1,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Number of billable tokens in the tuning dataset.
	BillableCharacterCount int64 `protobuf:"varint,2,opt,name=billable_character_count,json=billableCharacterCount,proto3" json:"billable_character_count,omitempty"`
}

func (x *AssessDataResponse_TuningResourceUsageAssessmentResult) Reset() {
	*x = AssessDataResponse_TuningResourceUsageAssessmentResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataResponse_TuningResourceUsageAssessmentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataResponse_TuningResourceUsageAssessmentResult) ProtoMessage() {}

func (x *AssessDataResponse_TuningResourceUsageAssessmentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataResponse_TuningResourceUsageAssessmentResult.ProtoReflect.Descriptor instead.
func (*AssessDataResponse_TuningResourceUsageAssessmentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{34, 1}
}

func (x *AssessDataResponse_TuningResourceUsageAssessmentResult) GetTokenCount() int64 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *AssessDataResponse_TuningResourceUsageAssessmentResult) GetBillableCharacterCount() int64 {
	if x != nil {
		return x.BillableCharacterCount
	}
	return 0
}

// The result of the batch prediction validation assessment.
type AssessDataResponse_BatchPredictionValidationAssessmentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AssessDataResponse_BatchPredictionValidationAssessmentResult) Reset() {
	*x = AssessDataResponse_BatchPredictionValidationAssessmentResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataResponse_BatchPredictionValidationAssessmentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataResponse_BatchPredictionValidationAssessmentResult) ProtoMessage() {}

func (x *AssessDataResponse_BatchPredictionValidationAssessmentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataResponse_BatchPredictionValidationAssessmentResult.ProtoReflect.Descriptor instead.
func (*AssessDataResponse_BatchPredictionValidationAssessmentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{34, 2}
}

// The result of the batch prediction resource usage assessment.
type AssessDataResponse_BatchPredictionResourceUsageAssessmentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of tokens in the batch prediction dataset.
	TokenCount int64 `protobuf:"varint,1,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Number of audio tokens in the batch prediction dataset.
	AudioTokenCount int64 `protobuf:"varint,2,opt,name=audio_token_count,json=audioTokenCount,proto3" json:"audio_token_count,omitempty"`
}

func (x *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) Reset() {
	*x = AssessDataResponse_BatchPredictionResourceUsageAssessmentResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) ProtoMessage() {}

func (x *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssessDataResponse_BatchPredictionResourceUsageAssessmentResult.ProtoReflect.Descriptor instead.
func (*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP(), []int{34, 3}
}

func (x *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) GetTokenCount() int64 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *AssessDataResponse_BatchPredictionResourceUsageAssessmentResult) GetAudioTokenCount() int64 {
	if x != nil {
		return x.AudioTokenCount
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_dataset_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2,
	0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x22, 0x86, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8b, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa1, 0x01, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbe,
	0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d,
	0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x80, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37,
	0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x84, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x55, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xb1, 0x01, 0x0a, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x22, 0x14, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1b, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xaf, 0x01, 0x0a, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x3b, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22,
	0xb5, 0x01, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x14, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x67, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x25, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x63, 0x0a, 0x1b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99,
	0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa0, 0x02, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x3c, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa1, 0x01,
	0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a,
	0x10, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x64, 0x0a, 0x1c, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x26, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x81, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x89, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb1, 0x06, 0x0a, 0x16, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74,
	0x65, 0x6d, 0x12, 0x7b, 0x0a, 0x13, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x43, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x52, 0x0a, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x28,
	0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74,
	0x65, 0x6d, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x31, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x54, 0x0a,
	0x11, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x61,
	0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x42, 0x07, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x22, 0x98, 0x01, 0x0a,
	0x17, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe1, 0x01, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61,
	0x49, 0x74, 0x65, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x12, 0x46, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d,
	0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3a, 0x0a, 0x19, 0x68, 0x61, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x17, 0x68, 0x61, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x84, 0x02, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37,
	0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x50, 0x0a, 0x0d, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5b, 0x0a, 0x17, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x84, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb8, 0x0c, 0x0a,
	0x11, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0xa9, 0x01, 0x0a, 0x23, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x20, 0x74, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xb3,
	0x01, 0x0a, 0x27, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x23, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0xc5, 0x01, 0x0a, 0x2d, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x29, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xcf, 0x01, 0x0a,
	0x31, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x2c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x72,
	0x0a, 0x16, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x14, 0x67, 0x65,
	0x6d, 0x69, 0x6e, 0x69, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x35, 0x0a, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xa8, 0x02, 0x0a, 0x20, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a,
	0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x8a, 0x01, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x22, 0x53,
	0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d,
	0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x53, 0x46, 0x54, 0x5f, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x46, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x1a, 0x49, 0x0a, 0x23, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x4f,
	0x0a, 0x29, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x52, 0x0a, 0x2c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x97, 0x09, 0x0a, 0x12, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xaa,
	0x01, 0x0a, 0x23, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x27,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x23, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0xc6, 0x01, 0x0a, 0x2d, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x29, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xd0, 0x01, 0x0a, 0x31,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x2c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x3f,
	0x0a, 0x20, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a,
	0x80, 0x01, 0x0a, 0x23, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x62, 0x69, 0x6c, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x62, 0x69, 0x6c, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x2b, 0x0a, 0x29, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a,
	0x7b, 0x0a, 0x2c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x2a, 0x0a, 0x11, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x13, 0x0a, 0x11,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x83, 0x01, 0x0a, 0x1b, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa6, 0x02, 0x0a, 0x14, 0x47, 0x65, 0x6d, 0x69,
	0x6e, 0x69, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5a, 0x0a, 0x0e, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e,
	0x69, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x67,
	0x65, 0x6d, 0x69, 0x6e, 0x69, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x71, 0x0a, 0x0d,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a,
	0x3f, 0x0a, 0x11, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xda, 0x06, 0x0a, 0x0d, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x49, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x61, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x56, 0x0a, 0x0e, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x29, 0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x05, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x0b,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x0f, 0x73, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x63, 0x0a, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x02,
	0x0a, 0x13, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x72, 0x0a, 0x16, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x14, 0x67, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35, 0x0a, 0x13, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x0d, 0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x49,
	0x0a, 0x14, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x1d, 0x41, 0x73,
	0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x32, 0xc9, 0x2a, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x85, 0x02, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0xca,
	0x41, 0x29, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x1e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0e, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x5a, 0x3a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5a, 0x1c, 0x3a, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x11, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0xca, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x5e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x5a, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x82, 0x02, 0x0a, 0x0d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x8f, 0x01, 0xda,
	0x41, 0x13, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x73, 0x3a, 0x07, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5a, 0x2d, 0x3a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x32,
	0x22, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4,
	0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x5a, 0x13, 0x12,
	0x11, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0xf9, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01,
	0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51,
	0x5a, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x31,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xef, 0x01, 0x0a, 0x0a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0xee, 0x01, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x12, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0xe7, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf1, 0x01, 0xca, 0x41, 0x37,
	0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01, 0x3a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5a, 0x3f, 0x3a, 0x0f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x2c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe4,
	0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x01, 0xda, 0x41, 0x1b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb7, 0x01, 0x3a, 0x0f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5a,
	0x4f, 0x3a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x32, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x32, 0x53, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xab, 0x02, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5, 0x01, 0xca, 0x41,
	0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x75, 0x5a, 0x2e,
	0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x43,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x84, 0x02, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x75, 0x5a, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x84, 0x01,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x75, 0x5a,
	0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc6, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xce, 0x01, 0xca,
	0x41, 0x38, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x26, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x85, 0x01, 0x5a, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0xce, 0x01,
	0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12,
	0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0xd2,
	0x01, 0x0a, 0x0f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49,
	0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74,
	0x65, 0x6d, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x12, 0xf0, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61,
	0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82,
	0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x2a, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x0f, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd8,
	0x01, 0x0a, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x77, 0xca, 0x41, 0x31, 0x0a, 0x12, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22,
	0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x12, 0xe2, 0x01, 0x0a, 0x0c, 0x41, 0x73,
	0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7d, 0xca, 0x41, 0x35, 0x0a, 0x14, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x41, 0x73, 0x73, 0x65,
	0x6d, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a,
	0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x1a, 0x4d,
	0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xea, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70,
	0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_dataset_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 52)
var file_google_cloud_aiplatform_v1beta1_dataset_service_proto_goTypes = []any{
	(AssessDataRequest_TuningValidationAssessmentConfig_DatasetUsage)(0),    // 0: google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage
	(*CreateDatasetRequest)(nil),                                            // 1: google.cloud.aiplatform.v1beta1.CreateDatasetRequest
	(*CreateDatasetOperationMetadata)(nil),                                  // 2: google.cloud.aiplatform.v1beta1.CreateDatasetOperationMetadata
	(*GetDatasetRequest)(nil),                                               // 3: google.cloud.aiplatform.v1beta1.GetDatasetRequest
	(*UpdateDatasetRequest)(nil),                                            // 4: google.cloud.aiplatform.v1beta1.UpdateDatasetRequest
	(*UpdateDatasetVersionRequest)(nil),                                     // 5: google.cloud.aiplatform.v1beta1.UpdateDatasetVersionRequest
	(*ListDatasetsRequest)(nil),                                             // 6: google.cloud.aiplatform.v1beta1.ListDatasetsRequest
	(*ListDatasetsResponse)(nil),                                            // 7: google.cloud.aiplatform.v1beta1.ListDatasetsResponse
	(*DeleteDatasetRequest)(nil),                                            // 8: google.cloud.aiplatform.v1beta1.DeleteDatasetRequest
	(*ImportDataRequest)(nil),                                               // 9: google.cloud.aiplatform.v1beta1.ImportDataRequest
	(*ImportDataResponse)(nil),                                              // 10: google.cloud.aiplatform.v1beta1.ImportDataResponse
	(*ImportDataOperationMetadata)(nil),                                     // 11: google.cloud.aiplatform.v1beta1.ImportDataOperationMetadata
	(*ExportDataRequest)(nil),                                               // 12: google.cloud.aiplatform.v1beta1.ExportDataRequest
	(*ExportDataResponse)(nil),                                              // 13: google.cloud.aiplatform.v1beta1.ExportDataResponse
	(*ExportDataOperationMetadata)(nil),                                     // 14: google.cloud.aiplatform.v1beta1.ExportDataOperationMetadata
	(*CreateDatasetVersionRequest)(nil),                                     // 15: google.cloud.aiplatform.v1beta1.CreateDatasetVersionRequest
	(*CreateDatasetVersionOperationMetadata)(nil),                           // 16: google.cloud.aiplatform.v1beta1.CreateDatasetVersionOperationMetadata
	(*DeleteDatasetVersionRequest)(nil),                                     // 17: google.cloud.aiplatform.v1beta1.DeleteDatasetVersionRequest
	(*GetDatasetVersionRequest)(nil),                                        // 18: google.cloud.aiplatform.v1beta1.GetDatasetVersionRequest
	(*ListDatasetVersionsRequest)(nil),                                      // 19: google.cloud.aiplatform.v1beta1.ListDatasetVersionsRequest
	(*ListDatasetVersionsResponse)(nil),                                     // 20: google.cloud.aiplatform.v1beta1.ListDatasetVersionsResponse
	(*RestoreDatasetVersionRequest)(nil),                                    // 21: google.cloud.aiplatform.v1beta1.RestoreDatasetVersionRequest
	(*RestoreDatasetVersionOperationMetadata)(nil),                          // 22: google.cloud.aiplatform.v1beta1.RestoreDatasetVersionOperationMetadata
	(*ListDataItemsRequest)(nil),                                            // 23: google.cloud.aiplatform.v1beta1.ListDataItemsRequest
	(*ListDataItemsResponse)(nil),                                           // 24: google.cloud.aiplatform.v1beta1.ListDataItemsResponse
	(*SearchDataItemsRequest)(nil),                                          // 25: google.cloud.aiplatform.v1beta1.SearchDataItemsRequest
	(*SearchDataItemsResponse)(nil),                                         // 26: google.cloud.aiplatform.v1beta1.SearchDataItemsResponse
	(*DataItemView)(nil),                                                    // 27: google.cloud.aiplatform.v1beta1.DataItemView
	(*ListSavedQueriesRequest)(nil),                                         // 28: google.cloud.aiplatform.v1beta1.ListSavedQueriesRequest
	(*ListSavedQueriesResponse)(nil),                                        // 29: google.cloud.aiplatform.v1beta1.ListSavedQueriesResponse
	(*DeleteSavedQueryRequest)(nil),                                         // 30: google.cloud.aiplatform.v1beta1.DeleteSavedQueryRequest
	(*GetAnnotationSpecRequest)(nil),                                        // 31: google.cloud.aiplatform.v1beta1.GetAnnotationSpecRequest
	(*ListAnnotationsRequest)(nil),                                          // 32: google.cloud.aiplatform.v1beta1.ListAnnotationsRequest
	(*ListAnnotationsResponse)(nil),                                         // 33: google.cloud.aiplatform.v1beta1.ListAnnotationsResponse
	(*AssessDataRequest)(nil),                                               // 34: google.cloud.aiplatform.v1beta1.AssessDataRequest
	(*AssessDataResponse)(nil),                                              // 35: google.cloud.aiplatform.v1beta1.AssessDataResponse
	(*AssessDataOperationMetadata)(nil),                                     // 36: google.cloud.aiplatform.v1beta1.AssessDataOperationMetadata
	(*GeminiTemplateConfig)(nil),                                            // 37: google.cloud.aiplatform.v1beta1.GeminiTemplateConfig
	(*GeminiExample)(nil),                                                   // 38: google.cloud.aiplatform.v1beta1.GeminiExample
	(*AssembleDataRequest)(nil),                                             // 39: google.cloud.aiplatform.v1beta1.AssembleDataRequest
	(*AssembleDataResponse)(nil),                                            // 40: google.cloud.aiplatform.v1beta1.AssembleDataResponse
	(*AssembleDataOperationMetadata)(nil),                                   // 41: google.cloud.aiplatform.v1beta1.AssembleDataOperationMetadata
	(*SearchDataItemsRequest_OrderByAnnotation)(nil),                        // 42: google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
	(*AssessDataRequest_TuningValidationAssessmentConfig)(nil),              // 43: google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
	(*AssessDataRequest_TuningResourceUsageAssessmentConfig)(nil),           // 44: google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
	(*AssessDataRequest_BatchPredictionValidationAssessmentConfig)(nil),     // 45: google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig
	(*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig)(nil),  // 46: google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig
	(*AssessDataResponse_TuningValidationAssessmentResult)(nil),             // 47: google.cloud.aiplatform.v1beta1.AssessDataResponse.TuningValidationAssessmentResult
	(*AssessDataResponse_TuningResourceUsageAssessmentResult)(nil),          // 48: google.cloud.aiplatform.v1beta1.AssessDataResponse.TuningResourceUsageAssessmentResult
	(*AssessDataResponse_BatchPredictionValidationAssessmentResult)(nil),    // 49: google.cloud.aiplatform.v1beta1.AssessDataResponse.BatchPredictionValidationAssessmentResult
	(*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult)(nil), // 50: google.cloud.aiplatform.v1beta1.AssessDataResponse.BatchPredictionResourceUsageAssessmentResult
	nil,                              // 51: google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.FieldMappingEntry
	nil,                              // 52: google.cloud.aiplatform.v1beta1.GeminiExample.LabelsEntry
	(*Dataset)(nil),                  // 53: google.cloud.aiplatform.v1beta1.Dataset
	(*GenericOperationMetadata)(nil), // 54: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*fieldmaskpb.FieldMask)(nil),    // 55: google.protobuf.FieldMask
	(*DatasetVersion)(nil),           // 56: google.cloud.aiplatform.v1beta1.DatasetVersion
	(*ImportDataConfig)(nil),         // 57: google.cloud.aiplatform.v1beta1.ImportDataConfig
	(*ExportDataConfig)(nil),         // 58: google.cloud.aiplatform.v1beta1.ExportDataConfig
	(*DataItem)(nil),                 // 59: google.cloud.aiplatform.v1beta1.DataItem
	(*Annotation)(nil),               // 60: google.cloud.aiplatform.v1beta1.Annotation
	(*SavedQuery)(nil),               // 61: google.cloud.aiplatform.v1beta1.SavedQuery
	(*Content)(nil),                  // 62: google.cloud.aiplatform.v1beta1.Content
	(*Tool)(nil),                     // 63: google.cloud.aiplatform.v1beta1.Tool
	(*ToolConfig)(nil),               // 64: google.cloud.aiplatform.v1beta1.ToolConfig
	(*SafetySetting)(nil),            // 65: google.cloud.aiplatform.v1beta1.SafetySetting
	(*GenerationConfig)(nil),         // 66: google.cloud.aiplatform.v1beta1.GenerationConfig
	(*longrunningpb.Operation)(nil),  // 67: google.longrunning.Operation
	(*AnnotationSpec)(nil),           // 68: google.cloud.aiplatform.v1beta1.AnnotationSpec
}
var file_google_cloud_aiplatform_v1beta1_dataset_service_proto_depIdxs = []int32{
	53, // 0: google.cloud.aiplatform.v1beta1.CreateDatasetRequest.dataset:type_name -> google.cloud.aiplatform.v1beta1.Dataset
	54, // 1: google.cloud.aiplatform.v1beta1.CreateDatasetOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	55, // 2: google.cloud.aiplatform.v1beta1.GetDatasetRequest.read_mask:type_name -> google.protobuf.FieldMask
	53, // 3: google.cloud.aiplatform.v1beta1.UpdateDatasetRequest.dataset:type_name -> google.cloud.aiplatform.v1beta1.Dataset
	55, // 4: google.cloud.aiplatform.v1beta1.UpdateDatasetRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 5: google.cloud.aiplatform.v1beta1.UpdateDatasetVersionRequest.dataset_version:type_name -> google.cloud.aiplatform.v1beta1.DatasetVersion
	55, // 6: google.cloud.aiplatform.v1beta1.UpdateDatasetVersionRequest.update_mask:type_name -> google.protobuf.FieldMask
	55, // 7: google.cloud.aiplatform.v1beta1.ListDatasetsRequest.read_mask:type_name -> google.protobuf.FieldMask
	53, // 8: google.cloud.aiplatform.v1beta1.ListDatasetsResponse.datasets:type_name -> google.cloud.aiplatform.v1beta1.Dataset
	57, // 9: google.cloud.aiplatform.v1beta1.ImportDataRequest.import_configs:type_name -> google.cloud.aiplatform.v1beta1.ImportDataConfig
	54, // 10: google.cloud.aiplatform.v1beta1.ImportDataOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	58, // 11: google.cloud.aiplatform.v1beta1.ExportDataRequest.export_config:type_name -> google.cloud.aiplatform.v1beta1.ExportDataConfig
	54, // 12: google.cloud.aiplatform.v1beta1.ExportDataOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	56, // 13: google.cloud.aiplatform.v1beta1.CreateDatasetVersionRequest.dataset_version:type_name -> google.cloud.aiplatform.v1beta1.DatasetVersion
	54, // 14: google.cloud.aiplatform.v1beta1.CreateDatasetVersionOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	55, // 15: google.cloud.aiplatform.v1beta1.GetDatasetVersionRequest.read_mask:type_name -> google.protobuf.FieldMask
	55, // 16: google.cloud.aiplatform.v1beta1.ListDatasetVersionsRequest.read_mask:type_name -> google.protobuf.FieldMask
	56, // 17: google.cloud.aiplatform.v1beta1.ListDatasetVersionsResponse.dataset_versions:type_name -> google.cloud.aiplatform.v1beta1.DatasetVersion
	54, // 18: google.cloud.aiplatform.v1beta1.RestoreDatasetVersionOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	55, // 19: google.cloud.aiplatform.v1beta1.ListDataItemsRequest.read_mask:type_name -> google.protobuf.FieldMask
	59, // 20: google.cloud.aiplatform.v1beta1.ListDataItemsResponse.data_items:type_name -> google.cloud.aiplatform.v1beta1.DataItem
	42, // 21: google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by_annotation:type_name -> google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
	55, // 22: google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.field_mask:type_name -> google.protobuf.FieldMask
	27, // 23: google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.data_item_views:type_name -> google.cloud.aiplatform.v1beta1.DataItemView
	59, // 24: google.cloud.aiplatform.v1beta1.DataItemView.data_item:type_name -> google.cloud.aiplatform.v1beta1.DataItem
	60, // 25: google.cloud.aiplatform.v1beta1.DataItemView.annotations:type_name -> google.cloud.aiplatform.v1beta1.Annotation
	55, // 26: google.cloud.aiplatform.v1beta1.ListSavedQueriesRequest.read_mask:type_name -> google.protobuf.FieldMask
	61, // 27: google.cloud.aiplatform.v1beta1.ListSavedQueriesResponse.saved_queries:type_name -> google.cloud.aiplatform.v1beta1.SavedQuery
	55, // 28: google.cloud.aiplatform.v1beta1.GetAnnotationSpecRequest.read_mask:type_name -> google.protobuf.FieldMask
	55, // 29: google.cloud.aiplatform.v1beta1.ListAnnotationsRequest.read_mask:type_name -> google.protobuf.FieldMask
	60, // 30: google.cloud.aiplatform.v1beta1.ListAnnotationsResponse.annotations:type_name -> google.cloud.aiplatform.v1beta1.Annotation
	43, // 31: google.cloud.aiplatform.v1beta1.AssessDataRequest.tuning_validation_assessment_config:type_name -> google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig
	44, // 32: google.cloud.aiplatform.v1beta1.AssessDataRequest.tuning_resource_usage_assessment_config:type_name -> google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningResourceUsageAssessmentConfig
	45, // 33: google.cloud.aiplatform.v1beta1.AssessDataRequest.batch_prediction_validation_assessment_config:type_name -> google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionValidationAssessmentConfig
	46, // 34: google.cloud.aiplatform.v1beta1.AssessDataRequest.batch_prediction_resource_usage_assessment_config:type_name -> google.cloud.aiplatform.v1beta1.AssessDataRequest.BatchPredictionResourceUsageAssessmentConfig
	37, // 35: google.cloud.aiplatform.v1beta1.AssessDataRequest.gemini_template_config:type_name -> google.cloud.aiplatform.v1beta1.GeminiTemplateConfig
	47, // 36: google.cloud.aiplatform.v1beta1.AssessDataResponse.tuning_validation_assessment_result:type_name -> google.cloud.aiplatform.v1beta1.AssessDataResponse.TuningValidationAssessmentResult
	48, // 37: google.cloud.aiplatform.v1beta1.AssessDataResponse.tuning_resource_usage_assessment_result:type_name -> google.cloud.aiplatform.v1beta1.AssessDataResponse.TuningResourceUsageAssessmentResult
	49, // 38: google.cloud.aiplatform.v1beta1.AssessDataResponse.batch_prediction_validation_assessment_result:type_name -> google.cloud.aiplatform.v1beta1.AssessDataResponse.BatchPredictionValidationAssessmentResult
	50, // 39: google.cloud.aiplatform.v1beta1.AssessDataResponse.batch_prediction_resource_usage_assessment_result:type_name -> google.cloud.aiplatform.v1beta1.AssessDataResponse.BatchPredictionResourceUsageAssessmentResult
	54, // 40: google.cloud.aiplatform.v1beta1.AssessDataOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	38, // 41: google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.gemini_example:type_name -> google.cloud.aiplatform.v1beta1.GeminiExample
	51, // 42: google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.field_mapping:type_name -> google.cloud.aiplatform.v1beta1.GeminiTemplateConfig.FieldMappingEntry
	62, // 43: google.cloud.aiplatform.v1beta1.GeminiExample.contents:type_name -> google.cloud.aiplatform.v1beta1.Content
	62, // 44: google.cloud.aiplatform.v1beta1.GeminiExample.system_instruction:type_name -> google.cloud.aiplatform.v1beta1.Content
	63, // 45: google.cloud.aiplatform.v1beta1.GeminiExample.tools:type_name -> google.cloud.aiplatform.v1beta1.Tool
	64, // 46: google.cloud.aiplatform.v1beta1.GeminiExample.tool_config:type_name -> google.cloud.aiplatform.v1beta1.ToolConfig
	52, // 47: google.cloud.aiplatform.v1beta1.GeminiExample.labels:type_name -> google.cloud.aiplatform.v1beta1.GeminiExample.LabelsEntry
	65, // 48: google.cloud.aiplatform.v1beta1.GeminiExample.safety_settings:type_name -> google.cloud.aiplatform.v1beta1.SafetySetting
	66, // 49: google.cloud.aiplatform.v1beta1.GeminiExample.generation_config:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig
	37, // 50: google.cloud.aiplatform.v1beta1.AssembleDataRequest.gemini_template_config:type_name -> google.cloud.aiplatform.v1beta1.GeminiTemplateConfig
	54, // 51: google.cloud.aiplatform.v1beta1.AssembleDataOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	0,  // 52: google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.dataset_usage:type_name -> google.cloud.aiplatform.v1beta1.AssessDataRequest.TuningValidationAssessmentConfig.DatasetUsage
	1,  // 53: google.cloud.aiplatform.v1beta1.DatasetService.CreateDataset:input_type -> google.cloud.aiplatform.v1beta1.CreateDatasetRequest
	3,  // 54: google.cloud.aiplatform.v1beta1.DatasetService.GetDataset:input_type -> google.cloud.aiplatform.v1beta1.GetDatasetRequest
	4,  // 55: google.cloud.aiplatform.v1beta1.DatasetService.UpdateDataset:input_type -> google.cloud.aiplatform.v1beta1.UpdateDatasetRequest
	6,  // 56: google.cloud.aiplatform.v1beta1.DatasetService.ListDatasets:input_type -> google.cloud.aiplatform.v1beta1.ListDatasetsRequest
	8,  // 57: google.cloud.aiplatform.v1beta1.DatasetService.DeleteDataset:input_type -> google.cloud.aiplatform.v1beta1.DeleteDatasetRequest
	9,  // 58: google.cloud.aiplatform.v1beta1.DatasetService.ImportData:input_type -> google.cloud.aiplatform.v1beta1.ImportDataRequest
	12, // 59: google.cloud.aiplatform.v1beta1.DatasetService.ExportData:input_type -> google.cloud.aiplatform.v1beta1.ExportDataRequest
	15, // 60: google.cloud.aiplatform.v1beta1.DatasetService.CreateDatasetVersion:input_type -> google.cloud.aiplatform.v1beta1.CreateDatasetVersionRequest
	5,  // 61: google.cloud.aiplatform.v1beta1.DatasetService.UpdateDatasetVersion:input_type -> google.cloud.aiplatform.v1beta1.UpdateDatasetVersionRequest
	17, // 62: google.cloud.aiplatform.v1beta1.DatasetService.DeleteDatasetVersion:input_type -> google.cloud.aiplatform.v1beta1.DeleteDatasetVersionRequest
	18, // 63: google.cloud.aiplatform.v1beta1.DatasetService.GetDatasetVersion:input_type -> google.cloud.aiplatform.v1beta1.GetDatasetVersionRequest
	19, // 64: google.cloud.aiplatform.v1beta1.DatasetService.ListDatasetVersions:input_type -> google.cloud.aiplatform.v1beta1.ListDatasetVersionsRequest
	21, // 65: google.cloud.aiplatform.v1beta1.DatasetService.RestoreDatasetVersion:input_type -> google.cloud.aiplatform.v1beta1.RestoreDatasetVersionRequest
	23, // 66: google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems:input_type -> google.cloud.aiplatform.v1beta1.ListDataItemsRequest
	25, // 67: google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems:input_type -> google.cloud.aiplatform.v1beta1.SearchDataItemsRequest
	28, // 68: google.cloud.aiplatform.v1beta1.DatasetService.ListSavedQueries:input_type -> google.cloud.aiplatform.v1beta1.ListSavedQueriesRequest
	30, // 69: google.cloud.aiplatform.v1beta1.DatasetService.DeleteSavedQuery:input_type -> google.cloud.aiplatform.v1beta1.DeleteSavedQueryRequest
	31, // 70: google.cloud.aiplatform.v1beta1.DatasetService.GetAnnotationSpec:input_type -> google.cloud.aiplatform.v1beta1.GetAnnotationSpecRequest
	32, // 71: google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations:input_type -> google.cloud.aiplatform.v1beta1.ListAnnotationsRequest
	34, // 72: google.cloud.aiplatform.v1beta1.DatasetService.AssessData:input_type -> google.cloud.aiplatform.v1beta1.AssessDataRequest
	39, // 73: google.cloud.aiplatform.v1beta1.DatasetService.AssembleData:input_type -> google.cloud.aiplatform.v1beta1.AssembleDataRequest
	67, // 74: google.cloud.aiplatform.v1beta1.DatasetService.CreateDataset:output_type -> google.longrunning.Operation
	53, // 75: google.cloud.aiplatform.v1beta1.DatasetService.GetDataset:output_type -> google.cloud.aiplatform.v1beta1.Dataset
	53, // 76: google.cloud.aiplatform.v1beta1.DatasetService.UpdateDataset:output_type -> google.cloud.aiplatform.v1beta1.Dataset
	7,  // 77: google.cloud.aiplatform.v1beta1.DatasetService.ListDatasets:output_type -> google.cloud.aiplatform.v1beta1.ListDatasetsResponse
	67, // 78: google.cloud.aiplatform.v1beta1.DatasetService.DeleteDataset:output_type -> google.longrunning.Operation
	67, // 79: google.cloud.aiplatform.v1beta1.DatasetService.ImportData:output_type -> google.longrunning.Operation
	67, // 80: google.cloud.aiplatform.v1beta1.DatasetService.ExportData:output_type -> google.longrunning.Operation
	67, // 81: google.cloud.aiplatform.v1beta1.DatasetService.CreateDatasetVersion:output_type -> google.longrunning.Operation
	56, // 82: google.cloud.aiplatform.v1beta1.DatasetService.UpdateDatasetVersion:output_type -> google.cloud.aiplatform.v1beta1.DatasetVersion
	67, // 83: google.cloud.aiplatform.v1beta1.DatasetService.DeleteDatasetVersion:output_type -> google.longrunning.Operation
	56, // 84: google.cloud.aiplatform.v1beta1.DatasetService.GetDatasetVersion:output_type -> google.cloud.aiplatform.v1beta1.DatasetVersion
	20, // 85: google.cloud.aiplatform.v1beta1.DatasetService.ListDatasetVersions:output_type -> google.cloud.aiplatform.v1beta1.ListDatasetVersionsResponse
	67, // 86: google.cloud.aiplatform.v1beta1.DatasetService.RestoreDatasetVersion:output_type -> google.longrunning.Operation
	24, // 87: google.cloud.aiplatform.v1beta1.DatasetService.ListDataItems:output_type -> google.cloud.aiplatform.v1beta1.ListDataItemsResponse
	26, // 88: google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems:output_type -> google.cloud.aiplatform.v1beta1.SearchDataItemsResponse
	29, // 89: google.cloud.aiplatform.v1beta1.DatasetService.ListSavedQueries:output_type -> google.cloud.aiplatform.v1beta1.ListSavedQueriesResponse
	67, // 90: google.cloud.aiplatform.v1beta1.DatasetService.DeleteSavedQuery:output_type -> google.longrunning.Operation
	68, // 91: google.cloud.aiplatform.v1beta1.DatasetService.GetAnnotationSpec:output_type -> google.cloud.aiplatform.v1beta1.AnnotationSpec
	33, // 92: google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations:output_type -> google.cloud.aiplatform.v1beta1.ListAnnotationsResponse
	67, // 93: google.cloud.aiplatform.v1beta1.DatasetService.AssessData:output_type -> google.longrunning.Operation
	67, // 94: google.cloud.aiplatform.v1beta1.DatasetService.AssembleData:output_type -> google.longrunning.Operation
	74, // [74:95] is the sub-list for method output_type
	53, // [53:74] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_dataset_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_dataset_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_dataset_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_annotation_proto_init()
	file_google_cloud_aiplatform_v1beta1_annotation_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_content_proto_init()
	file_google_cloud_aiplatform_v1beta1_data_item_proto_init()
	file_google_cloud_aiplatform_v1beta1_dataset_proto_init()
	file_google_cloud_aiplatform_v1beta1_dataset_version_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_saved_query_proto_init()
	file_google_cloud_aiplatform_v1beta1_tool_proto_init()
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[24].OneofWrappers = []any{
		(*SearchDataItemsRequest_OrderByDataItem)(nil),
		(*SearchDataItemsRequest_OrderByAnnotation_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[33].OneofWrappers = []any{
		(*AssessDataRequest_TuningValidationAssessmentConfig_)(nil),
		(*AssessDataRequest_TuningResourceUsageAssessmentConfig_)(nil),
		(*AssessDataRequest_BatchPredictionValidationAssessmentConfig_)(nil),
		(*AssessDataRequest_BatchPredictionResourceUsageAssessmentConfig_)(nil),
		(*AssessDataRequest_GeminiTemplateConfig)(nil),
		(*AssessDataRequest_RequestColumnName)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[34].OneofWrappers = []any{
		(*AssessDataResponse_TuningValidationAssessmentResult_)(nil),
		(*AssessDataResponse_TuningResourceUsageAssessmentResult_)(nil),
		(*AssessDataResponse_BatchPredictionValidationAssessmentResult_)(nil),
		(*AssessDataResponse_BatchPredictionResourceUsageAssessmentResult_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[37].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes[38].OneofWrappers = []any{
		(*AssembleDataRequest_GeminiTemplateConfig)(nil),
		(*AssembleDataRequest_RequestColumnName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   52,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_dataset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_dataset_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_dataset_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_dataset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_dataset_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_dataset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DatasetServiceClient is the client API for DatasetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatasetServiceClient interface {
	// Creates a Dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Updates a Dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists Datasets in a Location.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports data into a Dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports data from a Dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a version from a Dataset.
	CreateDatasetVersion(ctx context.Context, in *CreateDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a DatasetVersion.
	UpdateDatasetVersion(ctx context.Context, in *UpdateDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error)
	// Deletes a Dataset version.
	DeleteDatasetVersion(ctx context.Context, in *DeleteDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Dataset version.
	GetDatasetVersion(ctx context.Context, in *GetDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error)
	// Lists DatasetVersions in a Dataset.
	ListDatasetVersions(ctx context.Context, in *ListDatasetVersionsRequest, opts ...grpc.CallOption) (*ListDatasetVersionsResponse, error)
	// Restores a dataset version.
	RestoreDatasetVersion(ctx context.Context, in *RestoreDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DataItems in a Dataset.
	ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error)
	// Searches DataItems in a Dataset.
	SearchDataItems(ctx context.Context, in *SearchDataItemsRequest, opts ...grpc.CallOption) (*SearchDataItemsResponse, error)
	// Lists SavedQueries in a Dataset.
	ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error)
	// Deletes a SavedQuery.
	DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an AnnotationSpec.
	GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Lists Annotations belongs to a dataitem.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Assesses the state or validity of the dataset with respect to a given use
	// case.
	AssessData(ctx context.Context, in *AssessDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Assembles each row of a multimodal dataset and writes the result into a
	// BigQuery table.
	AssembleData(ctx context.Context, in *AssembleDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type datasetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDatasetServiceClient(cc grpc.ClientConnInterface) DatasetServiceClient {
	return &datasetServiceClient{cc}
}

func (c *datasetServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/UpdateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) CreateDatasetVersion(ctx context.Context, in *CreateDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/CreateDatasetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) UpdateDatasetVersion(ctx context.Context, in *UpdateDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error) {
	out := new(DatasetVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/UpdateDatasetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteDatasetVersion(ctx context.Context, in *DeleteDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteDatasetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetDatasetVersion(ctx context.Context, in *GetDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error) {
	out := new(DatasetVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/GetDatasetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDatasetVersions(ctx context.Context, in *ListDatasetVersionsRequest, opts ...grpc.CallOption) (*ListDatasetVersionsResponse, error) {
	out := new(ListDatasetVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ListDatasetVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) RestoreDatasetVersion(ctx context.Context, in *RestoreDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/RestoreDatasetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error) {
	out := new(ListDataItemsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ListDataItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) SearchDataItems(ctx context.Context, in *SearchDataItemsRequest, opts ...grpc.CallOption) (*SearchDataItemsResponse, error) {
	out := new(SearchDataItemsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/SearchDataItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error) {
	out := new(ListSavedQueriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ListSavedQueries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/GetAnnotationSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) AssessData(ctx context.Context, in *AssessDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/AssessData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) AssembleData(ctx context.Context, in *AssembleDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.DatasetService/AssembleData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatasetServiceServer is the server API for DatasetService service.
type DatasetServiceServer interface {
	// Creates a Dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Updates a Dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Lists Datasets in a Location.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error)
	// Imports data into a Dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error)
	// Exports data from a Dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error)
	// Create a version from a Dataset.
	CreateDatasetVersion(context.Context, *CreateDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Updates a DatasetVersion.
	UpdateDatasetVersion(context.Context, *UpdateDatasetVersionRequest) (*DatasetVersion, error)
	// Deletes a Dataset version.
	DeleteDatasetVersion(context.Context, *DeleteDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Gets a Dataset version.
	GetDatasetVersion(context.Context, *GetDatasetVersionRequest) (*DatasetVersion, error)
	// Lists DatasetVersions in a Dataset.
	ListDatasetVersions(context.Context, *ListDatasetVersionsRequest) (*ListDatasetVersionsResponse, error)
	// Restores a dataset version.
	RestoreDatasetVersion(context.Context, *RestoreDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Lists DataItems in a Dataset.
	ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error)
	// Searches DataItems in a Dataset.
	SearchDataItems(context.Context, *SearchDataItemsRequest) (*SearchDataItemsResponse, error)
	// Lists SavedQueries in a Dataset.
	ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error)
	// Deletes a SavedQuery.
	DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*longrunningpb.Operation, error)
	// Gets an AnnotationSpec.
	GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error)
	// Lists Annotations belongs to a dataitem.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Assesses the state or validity of the dataset with respect to a given use
	// case.
	AssessData(context.Context, *AssessDataRequest) (*longrunningpb.Operation, error)
	// Assembles each row of a multimodal dataset and writes the result into a
	// BigQuery table.
	AssembleData(context.Context, *AssembleDataRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDatasetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDatasetServiceServer struct {
}

func (*UnimplementedDatasetServiceServer) CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (*UnimplementedDatasetServiceServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (*UnimplementedDatasetServiceServer) UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (*UnimplementedDatasetServiceServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (*UnimplementedDatasetServiceServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (*UnimplementedDatasetServiceServer) ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (*UnimplementedDatasetServiceServer) ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (*UnimplementedDatasetServiceServer) CreateDatasetVersion(context.Context, *CreateDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatasetVersion not implemented")
}
func (*UnimplementedDatasetServiceServer) UpdateDatasetVersion(context.Context, *UpdateDatasetVersionRequest) (*DatasetVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatasetVersion not implemented")
}
func (*UnimplementedDatasetServiceServer) DeleteDatasetVersion(context.Context, *DeleteDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDatasetVersion not implemented")
}
func (*UnimplementedDatasetServiceServer) GetDatasetVersion(context.Context, *GetDatasetVersionRequest) (*DatasetVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatasetVersion not implemented")
}
func (*UnimplementedDatasetServiceServer) ListDatasetVersions(context.Context, *ListDatasetVersionsRequest) (*ListDatasetVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasetVersions not implemented")
}
func (*UnimplementedDatasetServiceServer) RestoreDatasetVersion(context.Context, *RestoreDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreDatasetVersion not implemented")
}
func (*UnimplementedDatasetServiceServer) ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataItems not implemented")
}
func (*UnimplementedDatasetServiceServer) SearchDataItems(context.Context, *SearchDataItemsRequest) (*SearchDataItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchDataItems not implemented")
}
func (*UnimplementedDatasetServiceServer) ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSavedQueries not implemented")
}
func (*UnimplementedDatasetServiceServer) DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSavedQuery not implemented")
}
func (*UnimplementedDatasetServiceServer) GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpec not implemented")
}
func (*UnimplementedDatasetServiceServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}
func (*UnimplementedDatasetServiceServer) AssessData(context.Context, *AssessDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AssessData not implemented")
}
func (*UnimplementedDatasetServiceServer) AssembleData(context.Context, *AssembleDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AssembleData not implemented")
}

func RegisterDatasetServiceServer(s *grpc.Server, srv DatasetServiceServer) {
	s.RegisterService(&_DatasetService_serviceDesc, srv)
}

func _DatasetService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/UpdateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_CreateDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).CreateDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/CreateDatasetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).CreateDatasetVersion(ctx, req.(*CreateDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_UpdateDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).UpdateDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/UpdateDatasetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).UpdateDatasetVersion(ctx, req.(*UpdateDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteDatasetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteDatasetVersion(ctx, req.(*DeleteDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/GetDatasetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetDatasetVersion(ctx, req.(*GetDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDatasetVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDatasetVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ListDatasetVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDatasetVersions(ctx, req.(*ListDatasetVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_RestoreDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).RestoreDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/RestoreDatasetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).RestoreDatasetVersion(ctx, req.(*RestoreDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ListDataItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDataItems(ctx, req.(*ListDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_SearchDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).SearchDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/SearchDataItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).SearchDataItems(ctx, req.(*SearchDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListSavedQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSavedQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListSavedQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ListSavedQueries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListSavedQueries(ctx, req.(*ListSavedQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/DeleteSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteSavedQuery(ctx, req.(*DeleteSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/GetAnnotationSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetAnnotationSpec(ctx, req.(*GetAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_AssessData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AssessDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).AssessData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/AssessData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).AssessData(ctx, req.(*AssessDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_AssembleData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AssembleDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).AssembleData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.DatasetService/AssembleData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).AssembleData(ctx, req.(*AssembleDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatasetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.DatasetService",
	HandlerType: (*DatasetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DatasetService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DatasetService_GetDataset_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _DatasetService_UpdateDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DatasetService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _DatasetService_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _DatasetService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _DatasetService_ExportData_Handler,
		},
		{
			MethodName: "CreateDatasetVersion",
			Handler:    _DatasetService_CreateDatasetVersion_Handler,
		},
		{
			MethodName: "UpdateDatasetVersion",
			Handler:    _DatasetService_UpdateDatasetVersion_Handler,
		},
		{
			MethodName: "DeleteDatasetVersion",
			Handler:    _DatasetService_DeleteDatasetVersion_Handler,
		},
		{
			MethodName: "GetDatasetVersion",
			Handler:    _DatasetService_GetDatasetVersion_Handler,
		},
		{
			MethodName: "ListDatasetVersions",
			Handler:    _DatasetService_ListDatasetVersions_Handler,
		},
		{
			MethodName: "RestoreDatasetVersion",
			Handler:    _DatasetService_RestoreDatasetVersion_Handler,
		},
		{
			MethodName: "ListDataItems",
			Handler:    _DatasetService_ListDataItems_Handler,
		},
		{
			MethodName: "SearchDataItems",
			Handler:    _DatasetService_SearchDataItems_Handler,
		},
		{
			MethodName: "ListSavedQueries",
			Handler:    _DatasetService_ListSavedQueries_Handler,
		},
		{
			MethodName: "DeleteSavedQuery",
			Handler:    _DatasetService_DeleteSavedQuery_Handler,
		},
		{
			MethodName: "GetAnnotationSpec",
			Handler:    _DatasetService_GetAnnotationSpec_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _DatasetService_ListAnnotations_Handler,
		},
		{
			MethodName: "AssessData",
			Handler:    _DatasetService_AssessData_Handler,
		},
		{
			MethodName: "AssembleData",
			Handler:    _DatasetService_AssembleData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/dataset_service.proto",
}
