// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/example_store_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [ExampleStoreService.CreateExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.CreateExampleStore].
type CreateExampleStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the ExampleStore in.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Example Store to be created.
	ExampleStore *ExampleStore `protobuf:"bytes,2,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
}

func (x *CreateExampleStoreRequest) Reset() {
	*x = CreateExampleStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateExampleStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExampleStoreRequest) ProtoMessage() {}

func (x *CreateExampleStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExampleStoreRequest.ProtoReflect.Descriptor instead.
func (*CreateExampleStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateExampleStoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExampleStoreRequest) GetExampleStore() *ExampleStore {
	if x != nil {
		return x.ExampleStore
	}
	return nil
}

// Details of
// [ExampleStoreService.CreateExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.CreateExampleStore]
// operation.
type CreateExampleStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateExampleStoreOperationMetadata) Reset() {
	*x = CreateExampleStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateExampleStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExampleStoreOperationMetadata) ProtoMessage() {}

func (x *CreateExampleStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExampleStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateExampleStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateExampleStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ExampleStoreService.GetExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.GetExampleStore].
type GetExampleStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ExampleStore.
	// Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetExampleStoreRequest) Reset() {
	*x = GetExampleStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetExampleStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExampleStoreRequest) ProtoMessage() {}

func (x *GetExampleStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExampleStoreRequest.ProtoReflect.Descriptor instead.
func (*GetExampleStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetExampleStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ExampleStoreService.UpdateExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpdateExampleStore].
type UpdateExampleStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Example Store which replaces the resource on the server.
	ExampleStore *ExampleStore `protobuf:"bytes,1,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
	// Optional. Mask specifying which fields to update.
	// Supported fields:
	//
	//   - `display_name`
	//   - `description`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExampleStoreRequest) Reset() {
	*x = UpdateExampleStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateExampleStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExampleStoreRequest) ProtoMessage() {}

func (x *UpdateExampleStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExampleStoreRequest.ProtoReflect.Descriptor instead.
func (*UpdateExampleStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateExampleStoreRequest) GetExampleStore() *ExampleStore {
	if x != nil {
		return x.ExampleStore
	}
	return nil
}

func (x *UpdateExampleStoreRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Details of
// [ExampleStoreService.UpdateExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpdateExampleStore]
// operation.
type UpdateExampleStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateExampleStoreOperationMetadata) Reset() {
	*x = UpdateExampleStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateExampleStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExampleStoreOperationMetadata) ProtoMessage() {}

func (x *UpdateExampleStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExampleStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateExampleStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateExampleStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ExampleStoreService.DeleteExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.DeleteExampleStore].
type DeleteExampleStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ExampleStore to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteExampleStoreRequest) Reset() {
	*x = DeleteExampleStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteExampleStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExampleStoreRequest) ProtoMessage() {}

func (x *DeleteExampleStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExampleStoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteExampleStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteExampleStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details of
// [ExampleStoreService.DeleteExampleStore][google.cloud.aiplatform.v1beta1.ExampleStoreService.DeleteExampleStore]
// operation.
type DeleteExampleStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *DeleteExampleStoreOperationMetadata) Reset() {
	*x = DeleteExampleStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteExampleStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExampleStoreOperationMetadata) ProtoMessage() {}

func (x *DeleteExampleStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExampleStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteExampleStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteExampleStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ExampleStoreService.ListExampleStores][google.cloud.aiplatform.v1beta1.ExampleStoreService.ListExampleStores].
type ListExampleStoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list the ExampleStores from.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list filter.
	// More detail in [AIP-160](https://google.aip.dev/160).
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListExampleStoresRequest) Reset() {
	*x = ListExampleStoresRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExampleStoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExampleStoresRequest) ProtoMessage() {}

func (x *ListExampleStoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExampleStoresRequest.ProtoReflect.Descriptor instead.
func (*ListExampleStoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListExampleStoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExampleStoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListExampleStoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExampleStoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ExampleStoreService.ListExampleStores][google.cloud.aiplatform.v1beta1.ExampleStoreService.ListExampleStores].
type ListExampleStoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ExampleStore in the requested page.
	ExampleStores []*ExampleStore `protobuf:"bytes,1,rep,name=example_stores,json=exampleStores,proto3" json:"example_stores,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListExampleStoresRequest.page_token][google.cloud.aiplatform.v1beta1.ListExampleStoresRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExampleStoresResponse) Reset() {
	*x = ListExampleStoresResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExampleStoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExampleStoresResponse) ProtoMessage() {}

func (x *ListExampleStoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExampleStoresResponse.ProtoReflect.Descriptor instead.
func (*ListExampleStoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListExampleStoresResponse) GetExampleStores() []*ExampleStore {
	if x != nil {
		return x.ExampleStores
	}
	return nil
}

func (x *ListExampleStoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A single example to upload or read from the Example Store.
type Example struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the example. Each example type has a defined format
	//
	// Types that are assignable to ExampleType:
	//
	//	*Example_StoredContentsExample
	ExampleType isExample_ExampleType `protobuf_oneof:"example_type"`
	// Optional. The display name for Example.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Immutable. Unique identifier of an example. If not specified when
	// upserting new examples, the example_id will be generated.
	ExampleId string `protobuf:"bytes,4,opt,name=example_id,json=exampleId,proto3" json:"example_id,omitempty"`
	// Output only. Timestamp when this Example was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *Example) Reset() {
	*x = Example{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Example) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Example) ProtoMessage() {}

func (x *Example) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Example.ProtoReflect.Descriptor instead.
func (*Example) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{9}
}

func (m *Example) GetExampleType() isExample_ExampleType {
	if m != nil {
		return m.ExampleType
	}
	return nil
}

func (x *Example) GetStoredContentsExample() *StoredContentsExample {
	if x, ok := x.GetExampleType().(*Example_StoredContentsExample); ok {
		return x.StoredContentsExample
	}
	return nil
}

func (x *Example) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Example) GetExampleId() string {
	if x != nil {
		return x.ExampleId
	}
	return ""
}

func (x *Example) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type isExample_ExampleType interface {
	isExample_ExampleType()
}

type Example_StoredContentsExample struct {
	// An example of chat history and its expected outcome to be used with
	// GenerateContent.
	StoredContentsExample *StoredContentsExample `protobuf:"bytes,6,opt,name=stored_contents_example,json=storedContentsExample,proto3,oneof"`
}

func (*Example_StoredContentsExample) isExample_ExampleType() {}

// Request message for
// [ExampleStoreService.UpsertExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples].
type UpsertExamplesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ExampleStore resource that examples are added to
	// or updated in. Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	ExampleStore string `protobuf:"bytes,1,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
	// Required. A list of examples to be created/updated.
	Examples []*Example `protobuf:"bytes,2,rep,name=examples,proto3" json:"examples,omitempty"`
	// Optional. A flag indicating whether an example can be overwritten if it
	// already exists. If False (default) and the example already exists, the
	// example will not be updated. This does not affect behavior if the example
	// does not exist already.
	Overwrite bool `protobuf:"varint,4,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
}

func (x *UpsertExamplesRequest) Reset() {
	*x = UpsertExamplesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpsertExamplesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpsertExamplesRequest) ProtoMessage() {}

func (x *UpsertExamplesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpsertExamplesRequest.ProtoReflect.Descriptor instead.
func (*UpsertExamplesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{10}
}

func (x *UpsertExamplesRequest) GetExampleStore() string {
	if x != nil {
		return x.ExampleStore
	}
	return ""
}

func (x *UpsertExamplesRequest) GetExamples() []*Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *UpsertExamplesRequest) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

// Response message for
// [ExampleStoreService.UpsertExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples].
type UpsertExamplesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of results for creating/updating. It's either a successfully
	// created/updated example or a status with an error message.
	Results []*UpsertExamplesResponse_UpsertResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *UpsertExamplesResponse) Reset() {
	*x = UpsertExamplesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpsertExamplesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpsertExamplesResponse) ProtoMessage() {}

func (x *UpsertExamplesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpsertExamplesResponse.ProtoReflect.Descriptor instead.
func (*UpsertExamplesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpsertExamplesResponse) GetResults() []*UpsertExamplesResponse_UpsertResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request message for
// [ExampleStoreService.RemoveExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples].
type RemoveExamplesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata filters that will be used to select which examples should be
	// removed.
	//
	// Types that are assignable to MetadataFilter:
	//
	//	*RemoveExamplesRequest_StoredContentsExampleFilter
	MetadataFilter isRemoveExamplesRequest_MetadataFilter `protobuf_oneof:"metadata_filter"`
	// Required. The name of the ExampleStore resource that the examples should be
	// removed from. Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	ExampleStore string `protobuf:"bytes,1,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
	// Optional. Example IDs to remove. If both metadata filters and Example IDs
	// are specified, the metadata filters will be applied to the specified
	// examples in order to identify which should be removed.
	ExampleIds []string `protobuf:"bytes,6,rep,name=example_ids,json=exampleIds,proto3" json:"example_ids,omitempty"`
}

func (x *RemoveExamplesRequest) Reset() {
	*x = RemoveExamplesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveExamplesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveExamplesRequest) ProtoMessage() {}

func (x *RemoveExamplesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveExamplesRequest.ProtoReflect.Descriptor instead.
func (*RemoveExamplesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{12}
}

func (m *RemoveExamplesRequest) GetMetadataFilter() isRemoveExamplesRequest_MetadataFilter {
	if m != nil {
		return m.MetadataFilter
	}
	return nil
}

func (x *RemoveExamplesRequest) GetStoredContentsExampleFilter() *StoredContentsExampleFilter {
	if x, ok := x.GetMetadataFilter().(*RemoveExamplesRequest_StoredContentsExampleFilter); ok {
		return x.StoredContentsExampleFilter
	}
	return nil
}

func (x *RemoveExamplesRequest) GetExampleStore() string {
	if x != nil {
		return x.ExampleStore
	}
	return ""
}

func (x *RemoveExamplesRequest) GetExampleIds() []string {
	if x != nil {
		return x.ExampleIds
	}
	return nil
}

type isRemoveExamplesRequest_MetadataFilter interface {
	isRemoveExamplesRequest_MetadataFilter()
}

type RemoveExamplesRequest_StoredContentsExampleFilter struct {
	// The metadata filters for StoredContentsExamples.
	StoredContentsExampleFilter *StoredContentsExampleFilter `protobuf:"bytes,8,opt,name=stored_contents_example_filter,json=storedContentsExampleFilter,proto3,oneof"`
}

func (*RemoveExamplesRequest_StoredContentsExampleFilter) isRemoveExamplesRequest_MetadataFilter() {}

// Response message for
// [ExampleStoreService.RemoveExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples].
type RemoveExamplesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IDs for the removed examples.
	ExampleIds []string `protobuf:"bytes,1,rep,name=example_ids,json=exampleIds,proto3" json:"example_ids,omitempty"`
}

func (x *RemoveExamplesResponse) Reset() {
	*x = RemoveExamplesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveExamplesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveExamplesResponse) ProtoMessage() {}

func (x *RemoveExamplesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveExamplesResponse.ProtoReflect.Descriptor instead.
func (*RemoveExamplesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{13}
}

func (x *RemoveExamplesResponse) GetExampleIds() []string {
	if x != nil {
		return x.ExampleIds
	}
	return nil
}

// Request message for
// [ExampleStoreService.SearchExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.SearchExamples].
type SearchExamplesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parameters to search for similar examples. This includes which value to
	// use for similarity search and the filters that should be applied to the
	// search. Filters limit which examples are considered as candidates for
	// similarity search.
	//
	// Types that are assignable to Parameters:
	//
	//	*SearchExamplesRequest_StoredContentsExampleParameters
	Parameters isSearchExamplesRequest_Parameters `protobuf_oneof:"parameters"`
	// Required. The name of the ExampleStore resource that examples are retrieved
	// from. Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	ExampleStore string `protobuf:"bytes,1,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
	// Optional. The number of similar examples to return.
	TopK int64 `protobuf:"varint,2,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
}

func (x *SearchExamplesRequest) Reset() {
	*x = SearchExamplesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchExamplesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExamplesRequest) ProtoMessage() {}

func (x *SearchExamplesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExamplesRequest.ProtoReflect.Descriptor instead.
func (*SearchExamplesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{14}
}

func (m *SearchExamplesRequest) GetParameters() isSearchExamplesRequest_Parameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (x *SearchExamplesRequest) GetStoredContentsExampleParameters() *StoredContentsExampleParameters {
	if x, ok := x.GetParameters().(*SearchExamplesRequest_StoredContentsExampleParameters); ok {
		return x.StoredContentsExampleParameters
	}
	return nil
}

func (x *SearchExamplesRequest) GetExampleStore() string {
	if x != nil {
		return x.ExampleStore
	}
	return ""
}

func (x *SearchExamplesRequest) GetTopK() int64 {
	if x != nil {
		return x.TopK
	}
	return 0
}

type isSearchExamplesRequest_Parameters interface {
	isSearchExamplesRequest_Parameters()
}

type SearchExamplesRequest_StoredContentsExampleParameters struct {
	// The parameters of StoredContentsExamples to be searched.
	StoredContentsExampleParameters *StoredContentsExampleParameters `protobuf:"bytes,6,opt,name=stored_contents_example_parameters,json=storedContentsExampleParameters,proto3,oneof"`
}

func (*SearchExamplesRequest_StoredContentsExampleParameters) isSearchExamplesRequest_Parameters() {}

// Response message for
// [ExampleStoreService.SearchExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.SearchExamples].
type SearchExamplesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of searching for similar examples.
	Results []*SearchExamplesResponse_SimilarExample `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *SearchExamplesResponse) Reset() {
	*x = SearchExamplesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchExamplesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExamplesResponse) ProtoMessage() {}

func (x *SearchExamplesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExamplesResponse.ProtoReflect.Descriptor instead.
func (*SearchExamplesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{15}
}

func (x *SearchExamplesResponse) GetResults() []*SearchExamplesResponse_SimilarExample {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request message for
// [ExampleStoreService.FetchExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.FetchExamples].
type FetchExamplesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The example type-specific filters to be applied to the fetch operation.
	//
	// Types that are assignable to MetadataFilter:
	//
	//	*FetchExamplesRequest_StoredContentsExampleFilter
	MetadataFilter isFetchExamplesRequest_MetadataFilter `protobuf_oneof:"metadata_filter"`
	// Required. The name of the ExampleStore resource that the examples should be
	// fetched from. Format:
	// `projects/{project}/locations/{location}/exampleStores/{example_store}`
	ExampleStore string `protobuf:"bytes,1,opt,name=example_store,json=exampleStore,proto3" json:"example_store,omitempty"`
	// Optional. The maximum number of examples to return. The service may return
	// fewer than this value. If unspecified, at most 100 examples will be
	// returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The
	// [next_page_token][google.cloud.aiplatform.v1beta1.FetchExamplesResponse.next_page_token]
	// value returned from a previous list
	// [ExampleStoreService.FetchExamplesResponse][] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Example IDs to fetch. If both metadata filters and Example IDs
	// are specified, then both ID and metadata filtering will be applied.
	ExampleIds []string `protobuf:"bytes,6,rep,name=example_ids,json=exampleIds,proto3" json:"example_ids,omitempty"`
}

func (x *FetchExamplesRequest) Reset() {
	*x = FetchExamplesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchExamplesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchExamplesRequest) ProtoMessage() {}

func (x *FetchExamplesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchExamplesRequest.ProtoReflect.Descriptor instead.
func (*FetchExamplesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{16}
}

func (m *FetchExamplesRequest) GetMetadataFilter() isFetchExamplesRequest_MetadataFilter {
	if m != nil {
		return m.MetadataFilter
	}
	return nil
}

func (x *FetchExamplesRequest) GetStoredContentsExampleFilter() *StoredContentsExampleFilter {
	if x, ok := x.GetMetadataFilter().(*FetchExamplesRequest_StoredContentsExampleFilter); ok {
		return x.StoredContentsExampleFilter
	}
	return nil
}

func (x *FetchExamplesRequest) GetExampleStore() string {
	if x != nil {
		return x.ExampleStore
	}
	return ""
}

func (x *FetchExamplesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchExamplesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *FetchExamplesRequest) GetExampleIds() []string {
	if x != nil {
		return x.ExampleIds
	}
	return nil
}

type isFetchExamplesRequest_MetadataFilter interface {
	isFetchExamplesRequest_MetadataFilter()
}

type FetchExamplesRequest_StoredContentsExampleFilter struct {
	// The metadata filters for StoredContentsExamples.
	StoredContentsExampleFilter *StoredContentsExampleFilter `protobuf:"bytes,8,opt,name=stored_contents_example_filter,json=storedContentsExampleFilter,proto3,oneof"`
}

func (*FetchExamplesRequest_StoredContentsExampleFilter) isFetchExamplesRequest_MetadataFilter() {}

// Response message for
// [ExampleStoreService.FetchExamples][google.cloud.aiplatform.v1beta1.ExampleStoreService.FetchExamples].
type FetchExamplesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The examples in the Example Store that satisfy the metadata filters.
	Examples []*Example `protobuf:"bytes,1,rep,name=examples,proto3" json:"examples,omitempty"`
	// A token, which can be sent as [FetchExamplesRequest.page_token][] to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchExamplesResponse) Reset() {
	*x = FetchExamplesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchExamplesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchExamplesResponse) ProtoMessage() {}

func (x *FetchExamplesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchExamplesResponse.ProtoReflect.Descriptor instead.
func (*FetchExamplesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{17}
}

func (x *FetchExamplesResponse) GetExamples() []*Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *FetchExamplesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The result for creating/updating a single example.
type UpsertExamplesResponse_UpsertResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The outcome of creating/updating a single example. It's either the
	// example that was successfully created/updated or a status with an error
	// message.
	//
	// Types that are assignable to Result:
	//
	//	*UpsertExamplesResponse_UpsertResult_Example
	//	*UpsertExamplesResponse_UpsertResult_Status
	Result isUpsertExamplesResponse_UpsertResult_Result `protobuf_oneof:"result"`
}

func (x *UpsertExamplesResponse_UpsertResult) Reset() {
	*x = UpsertExamplesResponse_UpsertResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpsertExamplesResponse_UpsertResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpsertExamplesResponse_UpsertResult) ProtoMessage() {}

func (x *UpsertExamplesResponse_UpsertResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpsertExamplesResponse_UpsertResult.ProtoReflect.Descriptor instead.
func (*UpsertExamplesResponse_UpsertResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{11, 0}
}

func (m *UpsertExamplesResponse_UpsertResult) GetResult() isUpsertExamplesResponse_UpsertResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *UpsertExamplesResponse_UpsertResult) GetExample() *Example {
	if x, ok := x.GetResult().(*UpsertExamplesResponse_UpsertResult_Example); ok {
		return x.Example
	}
	return nil
}

func (x *UpsertExamplesResponse_UpsertResult) GetStatus() *status.Status {
	if x, ok := x.GetResult().(*UpsertExamplesResponse_UpsertResult_Status); ok {
		return x.Status
	}
	return nil
}

type isUpsertExamplesResponse_UpsertResult_Result interface {
	isUpsertExamplesResponse_UpsertResult_Result()
}

type UpsertExamplesResponse_UpsertResult_Example struct {
	// The example created/updated successfully.
	Example *Example `protobuf:"bytes,1,opt,name=example,proto3,oneof"`
}

type UpsertExamplesResponse_UpsertResult_Status struct {
	// The error message of the example that was not created/updated
	// successfully.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3,oneof"`
}

func (*UpsertExamplesResponse_UpsertResult_Example) isUpsertExamplesResponse_UpsertResult_Result() {}

func (*UpsertExamplesResponse_UpsertResult_Status) isUpsertExamplesResponse_UpsertResult_Result() {}

// The result of the similar example.
type SearchExamplesResponse_SimilarExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The example that is similar to the searched query.
	Example *Example `protobuf:"bytes,1,opt,name=example,proto3" json:"example,omitempty"`
	// The similarity score of this example.
	SimilarityScore float32 `protobuf:"fixed32,2,opt,name=similarity_score,json=similarityScore,proto3" json:"similarity_score,omitempty"`
}

func (x *SearchExamplesResponse_SimilarExample) Reset() {
	*x = SearchExamplesResponse_SimilarExample{}
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchExamplesResponse_SimilarExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExamplesResponse_SimilarExample) ProtoMessage() {}

func (x *SearchExamplesResponse_SimilarExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExamplesResponse_SimilarExample.ProtoReflect.Descriptor instead.
func (*SearchExamplesResponse_SimilarExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP(), []int{15, 0}
}

func (x *SearchExamplesResponse_SimilarExample) GetExample() *Example {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *SearchExamplesResponse_SimilarExample) GetSimilarityScore() float32 {
	if x != nil {
		return x.SimilarityScore
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_example_store_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x8b,
	0x01, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x5c, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x8b, 0x01, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x5f, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xc0, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x9c, 0x02, 0x0a, 0x07, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x70, 0x0a, 0x17, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x15, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0a, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41,
	0x05, 0x52, 0x09, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xda,
	0x01, 0x0a, 0x15, 0x55, 0x70, 0x73, 0x65, 0x72, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x49, 0x0a,
	0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x22, 0x87, 0x02, 0x0a, 0x16,
	0x55, 0x70, 0x73, 0x65, 0x72, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x73, 0x65, 0x72, 0x74,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x55, 0x70, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x8c, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x73, 0x65, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xab, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x83, 0x01, 0x0a, 0x1e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x1b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0c, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x49, 0x64, 0x73,
	0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0x39, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x22, 0xa6,
	0x02, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x22, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x1f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x18, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xfb, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x60, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x69, 0x6d,
	0x69, 0x6c, 0x61, 0x72, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x1a, 0x7f, 0x0a, 0x0e, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x69,
	0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xf0, 0x02, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x83,
	0x01, 0x0a, 0x1e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x1b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0c, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x24, 0x0a, 0x0b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x49, 0x64, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x85, 0x01, 0x0a, 0x15, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x08,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x32, 0xe1, 0x11, 0x0a, 0x13, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xce, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x01, 0xca, 0x41, 0x33,
	0x0a, 0x0c, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x23,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x88,
	0x01, 0x3a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5a, 0x3f, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x0f, 0x47, 0x65,
	0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9f, 0x02, 0x0a,
	0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad,
	0x01, 0xca, 0x41, 0x33, 0x0a, 0x0c, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6,
	0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x84, 0x01, 0xca, 0x41, 0x3c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x23, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a,
	0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xdc, 0x01,
	0x0a, 0x0e, 0x55, 0x70, 0x73, 0x65, 0x72, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x73, 0x65, 0x72, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x73, 0x65, 0x72,
	0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x70,
	0x73, 0x65, 0x72, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0xdc, 0x01, 0x0a,
	0x0e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x0e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0xd8, 0x01, 0x0a, 0x0d, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xef, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_aiplatform_v1beta1_example_store_service_proto_goTypes = []any{
	(*CreateExampleStoreRequest)(nil),             // 0: google.cloud.aiplatform.v1beta1.CreateExampleStoreRequest
	(*CreateExampleStoreOperationMetadata)(nil),   // 1: google.cloud.aiplatform.v1beta1.CreateExampleStoreOperationMetadata
	(*GetExampleStoreRequest)(nil),                // 2: google.cloud.aiplatform.v1beta1.GetExampleStoreRequest
	(*UpdateExampleStoreRequest)(nil),             // 3: google.cloud.aiplatform.v1beta1.UpdateExampleStoreRequest
	(*UpdateExampleStoreOperationMetadata)(nil),   // 4: google.cloud.aiplatform.v1beta1.UpdateExampleStoreOperationMetadata
	(*DeleteExampleStoreRequest)(nil),             // 5: google.cloud.aiplatform.v1beta1.DeleteExampleStoreRequest
	(*DeleteExampleStoreOperationMetadata)(nil),   // 6: google.cloud.aiplatform.v1beta1.DeleteExampleStoreOperationMetadata
	(*ListExampleStoresRequest)(nil),              // 7: google.cloud.aiplatform.v1beta1.ListExampleStoresRequest
	(*ListExampleStoresResponse)(nil),             // 8: google.cloud.aiplatform.v1beta1.ListExampleStoresResponse
	(*Example)(nil),                               // 9: google.cloud.aiplatform.v1beta1.Example
	(*UpsertExamplesRequest)(nil),                 // 10: google.cloud.aiplatform.v1beta1.UpsertExamplesRequest
	(*UpsertExamplesResponse)(nil),                // 11: google.cloud.aiplatform.v1beta1.UpsertExamplesResponse
	(*RemoveExamplesRequest)(nil),                 // 12: google.cloud.aiplatform.v1beta1.RemoveExamplesRequest
	(*RemoveExamplesResponse)(nil),                // 13: google.cloud.aiplatform.v1beta1.RemoveExamplesResponse
	(*SearchExamplesRequest)(nil),                 // 14: google.cloud.aiplatform.v1beta1.SearchExamplesRequest
	(*SearchExamplesResponse)(nil),                // 15: google.cloud.aiplatform.v1beta1.SearchExamplesResponse
	(*FetchExamplesRequest)(nil),                  // 16: google.cloud.aiplatform.v1beta1.FetchExamplesRequest
	(*FetchExamplesResponse)(nil),                 // 17: google.cloud.aiplatform.v1beta1.FetchExamplesResponse
	(*UpsertExamplesResponse_UpsertResult)(nil),   // 18: google.cloud.aiplatform.v1beta1.UpsertExamplesResponse.UpsertResult
	(*SearchExamplesResponse_SimilarExample)(nil), // 19: google.cloud.aiplatform.v1beta1.SearchExamplesResponse.SimilarExample
	(*ExampleStore)(nil),                          // 20: google.cloud.aiplatform.v1beta1.ExampleStore
	(*GenericOperationMetadata)(nil),              // 21: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*fieldmaskpb.FieldMask)(nil),                 // 22: google.protobuf.FieldMask
	(*StoredContentsExample)(nil),                 // 23: google.cloud.aiplatform.v1beta1.StoredContentsExample
	(*timestamppb.Timestamp)(nil),                 // 24: google.protobuf.Timestamp
	(*StoredContentsExampleFilter)(nil),           // 25: google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
	(*StoredContentsExampleParameters)(nil),       // 26: google.cloud.aiplatform.v1beta1.StoredContentsExampleParameters
	(*status.Status)(nil),                         // 27: google.rpc.Status
	(*longrunningpb.Operation)(nil),               // 28: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_example_store_service_proto_depIdxs = []int32{
	20, // 0: google.cloud.aiplatform.v1beta1.CreateExampleStoreRequest.example_store:type_name -> google.cloud.aiplatform.v1beta1.ExampleStore
	21, // 1: google.cloud.aiplatform.v1beta1.CreateExampleStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	20, // 2: google.cloud.aiplatform.v1beta1.UpdateExampleStoreRequest.example_store:type_name -> google.cloud.aiplatform.v1beta1.ExampleStore
	22, // 3: google.cloud.aiplatform.v1beta1.UpdateExampleStoreRequest.update_mask:type_name -> google.protobuf.FieldMask
	21, // 4: google.cloud.aiplatform.v1beta1.UpdateExampleStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	21, // 5: google.cloud.aiplatform.v1beta1.DeleteExampleStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	20, // 6: google.cloud.aiplatform.v1beta1.ListExampleStoresResponse.example_stores:type_name -> google.cloud.aiplatform.v1beta1.ExampleStore
	23, // 7: google.cloud.aiplatform.v1beta1.Example.stored_contents_example:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExample
	24, // 8: google.cloud.aiplatform.v1beta1.Example.create_time:type_name -> google.protobuf.Timestamp
	9,  // 9: google.cloud.aiplatform.v1beta1.UpsertExamplesRequest.examples:type_name -> google.cloud.aiplatform.v1beta1.Example
	18, // 10: google.cloud.aiplatform.v1beta1.UpsertExamplesResponse.results:type_name -> google.cloud.aiplatform.v1beta1.UpsertExamplesResponse.UpsertResult
	25, // 11: google.cloud.aiplatform.v1beta1.RemoveExamplesRequest.stored_contents_example_filter:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
	26, // 12: google.cloud.aiplatform.v1beta1.SearchExamplesRequest.stored_contents_example_parameters:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExampleParameters
	19, // 13: google.cloud.aiplatform.v1beta1.SearchExamplesResponse.results:type_name -> google.cloud.aiplatform.v1beta1.SearchExamplesResponse.SimilarExample
	25, // 14: google.cloud.aiplatform.v1beta1.FetchExamplesRequest.stored_contents_example_filter:type_name -> google.cloud.aiplatform.v1beta1.StoredContentsExampleFilter
	9,  // 15: google.cloud.aiplatform.v1beta1.FetchExamplesResponse.examples:type_name -> google.cloud.aiplatform.v1beta1.Example
	9,  // 16: google.cloud.aiplatform.v1beta1.UpsertExamplesResponse.UpsertResult.example:type_name -> google.cloud.aiplatform.v1beta1.Example
	27, // 17: google.cloud.aiplatform.v1beta1.UpsertExamplesResponse.UpsertResult.status:type_name -> google.rpc.Status
	9,  // 18: google.cloud.aiplatform.v1beta1.SearchExamplesResponse.SimilarExample.example:type_name -> google.cloud.aiplatform.v1beta1.Example
	0,  // 19: google.cloud.aiplatform.v1beta1.ExampleStoreService.CreateExampleStore:input_type -> google.cloud.aiplatform.v1beta1.CreateExampleStoreRequest
	2,  // 20: google.cloud.aiplatform.v1beta1.ExampleStoreService.GetExampleStore:input_type -> google.cloud.aiplatform.v1beta1.GetExampleStoreRequest
	3,  // 21: google.cloud.aiplatform.v1beta1.ExampleStoreService.UpdateExampleStore:input_type -> google.cloud.aiplatform.v1beta1.UpdateExampleStoreRequest
	5,  // 22: google.cloud.aiplatform.v1beta1.ExampleStoreService.DeleteExampleStore:input_type -> google.cloud.aiplatform.v1beta1.DeleteExampleStoreRequest
	7,  // 23: google.cloud.aiplatform.v1beta1.ExampleStoreService.ListExampleStores:input_type -> google.cloud.aiplatform.v1beta1.ListExampleStoresRequest
	10, // 24: google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples:input_type -> google.cloud.aiplatform.v1beta1.UpsertExamplesRequest
	12, // 25: google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples:input_type -> google.cloud.aiplatform.v1beta1.RemoveExamplesRequest
	14, // 26: google.cloud.aiplatform.v1beta1.ExampleStoreService.SearchExamples:input_type -> google.cloud.aiplatform.v1beta1.SearchExamplesRequest
	16, // 27: google.cloud.aiplatform.v1beta1.ExampleStoreService.FetchExamples:input_type -> google.cloud.aiplatform.v1beta1.FetchExamplesRequest
	28, // 28: google.cloud.aiplatform.v1beta1.ExampleStoreService.CreateExampleStore:output_type -> google.longrunning.Operation
	20, // 29: google.cloud.aiplatform.v1beta1.ExampleStoreService.GetExampleStore:output_type -> google.cloud.aiplatform.v1beta1.ExampleStore
	28, // 30: google.cloud.aiplatform.v1beta1.ExampleStoreService.UpdateExampleStore:output_type -> google.longrunning.Operation
	28, // 31: google.cloud.aiplatform.v1beta1.ExampleStoreService.DeleteExampleStore:output_type -> google.longrunning.Operation
	8,  // 32: google.cloud.aiplatform.v1beta1.ExampleStoreService.ListExampleStores:output_type -> google.cloud.aiplatform.v1beta1.ListExampleStoresResponse
	11, // 33: google.cloud.aiplatform.v1beta1.ExampleStoreService.UpsertExamples:output_type -> google.cloud.aiplatform.v1beta1.UpsertExamplesResponse
	13, // 34: google.cloud.aiplatform.v1beta1.ExampleStoreService.RemoveExamples:output_type -> google.cloud.aiplatform.v1beta1.RemoveExamplesResponse
	15, // 35: google.cloud.aiplatform.v1beta1.ExampleStoreService.SearchExamples:output_type -> google.cloud.aiplatform.v1beta1.SearchExamplesResponse
	17, // 36: google.cloud.aiplatform.v1beta1.ExampleStoreService.FetchExamples:output_type -> google.cloud.aiplatform.v1beta1.FetchExamplesResponse
	28, // [28:37] is the sub-list for method output_type
	19, // [19:28] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_example_store_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_example_store_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_example_store_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_example_proto_init()
	file_google_cloud_aiplatform_v1beta1_example_store_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[9].OneofWrappers = []any{
		(*Example_StoredContentsExample)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[12].OneofWrappers = []any{
		(*RemoveExamplesRequest_StoredContentsExampleFilter)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[14].OneofWrappers = []any{
		(*SearchExamplesRequest_StoredContentsExampleParameters)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[16].OneofWrappers = []any{
		(*FetchExamplesRequest_StoredContentsExampleFilter)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes[18].OneofWrappers = []any{
		(*UpsertExamplesResponse_UpsertResult_Example)(nil),
		(*UpsertExamplesResponse_UpsertResult_Status)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_example_store_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_example_store_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_example_store_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_example_store_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_example_store_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ExampleStoreServiceClient is the client API for ExampleStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExampleStoreServiceClient interface {
	// Create an ExampleStore.
	CreateExampleStore(ctx context.Context, in *CreateExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get an ExampleStore.
	GetExampleStore(ctx context.Context, in *GetExampleStoreRequest, opts ...grpc.CallOption) (*ExampleStore, error)
	// Update an ExampleStore.
	UpdateExampleStore(ctx context.Context, in *UpdateExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an ExampleStore.
	DeleteExampleStore(ctx context.Context, in *DeleteExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List ExampleStores in a Location.
	ListExampleStores(ctx context.Context, in *ListExampleStoresRequest, opts ...grpc.CallOption) (*ListExampleStoresResponse, error)
	// Create or update Examples in the Example Store.
	UpsertExamples(ctx context.Context, in *UpsertExamplesRequest, opts ...grpc.CallOption) (*UpsertExamplesResponse, error)
	// Remove Examples from the Example Store.
	RemoveExamples(ctx context.Context, in *RemoveExamplesRequest, opts ...grpc.CallOption) (*RemoveExamplesResponse, error)
	// Search for similar Examples for given selection criteria.
	SearchExamples(ctx context.Context, in *SearchExamplesRequest, opts ...grpc.CallOption) (*SearchExamplesResponse, error)
	// Get Examples from the Example Store.
	FetchExamples(ctx context.Context, in *FetchExamplesRequest, opts ...grpc.CallOption) (*FetchExamplesResponse, error)
}

type exampleStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewExampleStoreServiceClient(cc grpc.ClientConnInterface) ExampleStoreServiceClient {
	return &exampleStoreServiceClient{cc}
}

func (c *exampleStoreServiceClient) CreateExampleStore(ctx context.Context, in *CreateExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/CreateExampleStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) GetExampleStore(ctx context.Context, in *GetExampleStoreRequest, opts ...grpc.CallOption) (*ExampleStore, error) {
	out := new(ExampleStore)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/GetExampleStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) UpdateExampleStore(ctx context.Context, in *UpdateExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/UpdateExampleStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) DeleteExampleStore(ctx context.Context, in *DeleteExampleStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/DeleteExampleStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) ListExampleStores(ctx context.Context, in *ListExampleStoresRequest, opts ...grpc.CallOption) (*ListExampleStoresResponse, error) {
	out := new(ListExampleStoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/ListExampleStores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) UpsertExamples(ctx context.Context, in *UpsertExamplesRequest, opts ...grpc.CallOption) (*UpsertExamplesResponse, error) {
	out := new(UpsertExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/UpsertExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) RemoveExamples(ctx context.Context, in *RemoveExamplesRequest, opts ...grpc.CallOption) (*RemoveExamplesResponse, error) {
	out := new(RemoveExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/RemoveExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) SearchExamples(ctx context.Context, in *SearchExamplesRequest, opts ...grpc.CallOption) (*SearchExamplesResponse, error) {
	out := new(SearchExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/SearchExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleStoreServiceClient) FetchExamples(ctx context.Context, in *FetchExamplesRequest, opts ...grpc.CallOption) (*FetchExamplesResponse, error) {
	out := new(FetchExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.ExampleStoreService/FetchExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExampleStoreServiceServer is the server API for ExampleStoreService service.
type ExampleStoreServiceServer interface {
	// Create an ExampleStore.
	CreateExampleStore(context.Context, *CreateExampleStoreRequest) (*longrunningpb.Operation, error)
	// Get an ExampleStore.
	GetExampleStore(context.Context, *GetExampleStoreRequest) (*ExampleStore, error)
	// Update an ExampleStore.
	UpdateExampleStore(context.Context, *UpdateExampleStoreRequest) (*longrunningpb.Operation, error)
	// Delete an ExampleStore.
	DeleteExampleStore(context.Context, *DeleteExampleStoreRequest) (*longrunningpb.Operation, error)
	// List ExampleStores in a Location.
	ListExampleStores(context.Context, *ListExampleStoresRequest) (*ListExampleStoresResponse, error)
	// Create or update Examples in the Example Store.
	UpsertExamples(context.Context, *UpsertExamplesRequest) (*UpsertExamplesResponse, error)
	// Remove Examples from the Example Store.
	RemoveExamples(context.Context, *RemoveExamplesRequest) (*RemoveExamplesResponse, error)
	// Search for similar Examples for given selection criteria.
	SearchExamples(context.Context, *SearchExamplesRequest) (*SearchExamplesResponse, error)
	// Get Examples from the Example Store.
	FetchExamples(context.Context, *FetchExamplesRequest) (*FetchExamplesResponse, error)
}

// UnimplementedExampleStoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedExampleStoreServiceServer struct {
}

func (*UnimplementedExampleStoreServiceServer) CreateExampleStore(context.Context, *CreateExampleStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateExampleStore not implemented")
}
func (*UnimplementedExampleStoreServiceServer) GetExampleStore(context.Context, *GetExampleStoreRequest) (*ExampleStore, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetExampleStore not implemented")
}
func (*UnimplementedExampleStoreServiceServer) UpdateExampleStore(context.Context, *UpdateExampleStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateExampleStore not implemented")
}
func (*UnimplementedExampleStoreServiceServer) DeleteExampleStore(context.Context, *DeleteExampleStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteExampleStore not implemented")
}
func (*UnimplementedExampleStoreServiceServer) ListExampleStores(context.Context, *ListExampleStoresRequest) (*ListExampleStoresResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListExampleStores not implemented")
}
func (*UnimplementedExampleStoreServiceServer) UpsertExamples(context.Context, *UpsertExamplesRequest) (*UpsertExamplesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpsertExamples not implemented")
}
func (*UnimplementedExampleStoreServiceServer) RemoveExamples(context.Context, *RemoveExamplesRequest) (*RemoveExamplesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveExamples not implemented")
}
func (*UnimplementedExampleStoreServiceServer) SearchExamples(context.Context, *SearchExamplesRequest) (*SearchExamplesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchExamples not implemented")
}
func (*UnimplementedExampleStoreServiceServer) FetchExamples(context.Context, *FetchExamplesRequest) (*FetchExamplesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchExamples not implemented")
}

func RegisterExampleStoreServiceServer(s *grpc.Server, srv ExampleStoreServiceServer) {
	s.RegisterService(&_ExampleStoreService_serviceDesc, srv)
}

func _ExampleStoreService_CreateExampleStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExampleStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).CreateExampleStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/CreateExampleStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).CreateExampleStore(ctx, req.(*CreateExampleStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_GetExampleStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExampleStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).GetExampleStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/GetExampleStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).GetExampleStore(ctx, req.(*GetExampleStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_UpdateExampleStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExampleStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).UpdateExampleStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/UpdateExampleStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).UpdateExampleStore(ctx, req.(*UpdateExampleStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_DeleteExampleStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExampleStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).DeleteExampleStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/DeleteExampleStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).DeleteExampleStore(ctx, req.(*DeleteExampleStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_ListExampleStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExampleStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).ListExampleStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/ListExampleStores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).ListExampleStores(ctx, req.(*ListExampleStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_UpsertExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpsertExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).UpsertExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/UpsertExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).UpsertExamples(ctx, req.(*UpsertExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_RemoveExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).RemoveExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/RemoveExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).RemoveExamples(ctx, req.(*RemoveExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_SearchExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).SearchExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/SearchExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).SearchExamples(ctx, req.(*SearchExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleStoreService_FetchExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleStoreServiceServer).FetchExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.ExampleStoreService/FetchExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleStoreServiceServer).FetchExamples(ctx, req.(*FetchExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExampleStoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ExampleStoreService",
	HandlerType: (*ExampleStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateExampleStore",
			Handler:    _ExampleStoreService_CreateExampleStore_Handler,
		},
		{
			MethodName: "GetExampleStore",
			Handler:    _ExampleStoreService_GetExampleStore_Handler,
		},
		{
			MethodName: "UpdateExampleStore",
			Handler:    _ExampleStoreService_UpdateExampleStore_Handler,
		},
		{
			MethodName: "DeleteExampleStore",
			Handler:    _ExampleStoreService_DeleteExampleStore_Handler,
		},
		{
			MethodName: "ListExampleStores",
			Handler:    _ExampleStoreService_ListExampleStores_Handler,
		},
		{
			MethodName: "UpsertExamples",
			Handler:    _ExampleStoreService_UpsertExamples_Handler,
		},
		{
			MethodName: "RemoveExamples",
			Handler:    _ExampleStoreService_RemoveExamples_Handler,
		},
		{
			MethodName: "SearchExamples",
			Handler:    _ExampleStoreService_SearchExamples_Handler,
		},
		{
			MethodName: "FetchExamples",
			Handler:    _ExampleStoreService_FetchExamples_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/example_store_service.proto",
}
