/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class Shape {
    private final List<Coordinate> coords = new ArrayList<Coordinate>();

    public Shape(String asString, String separator) {
        CheckParameterUtil.ensureParameterNotNull(asString, "asString");
        String[] components = asString.split(separator);
        if (components.length % 2 != 0) {
            throw new IllegalArgumentException(MessageFormat.format("Even number of doubles expected in string, got {0}: {1}", components.length, asString));
        }
        for (int i = 0; i < components.length; i += 2) {
            this.addPoint(components[i], components[i + 1]);
        }
    }

    public Shape() {
    }

    public String encodeAsString(String separator) {
        StringBuilder sb = new StringBuilder();
        for (Coordinate c : this.coords) {
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(c.getLat()).append(separator).append(c.getLon());
        }
        return sb.toString();
    }

    public List<Coordinate> getPoints() {
        return this.coords;
    }

    public boolean contains(LatLon latlon) {
        if (latlon == null) {
            return false;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.coords.size());
        for (Coordinate c : this.coords) {
            nodes.add(new Node(new LatLon(c.getLat(), c.getLon())));
        }
        return Geometry.nodeInsidePolygon(new Node(latlon), nodes);
    }

    public void addPoint(String sLat, String sLon) {
        double lon;
        double lat;
        CheckParameterUtil.ensureParameterNotNull(sLat, "sLat");
        CheckParameterUtil.ensureParameterNotNull(sLon, "sLon");
        try {
            lat = Double.parseDouble(sLat);
            if (!LatLon.isValidLat(lat)) {
                throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", lat));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", sLat), e);
        }
        try {
            lon = Double.parseDouble(sLon);
            if (!LatLon.isValidLon(lon)) {
                throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", lon));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", sLon), e);
        }
        this.coords.add(new Coordinate(LatLon.roundToOsmPrecision(lat), LatLon.roundToOsmPrecision(lon)));
    }

    public int hashCode() {
        return Objects.hash(this.coords);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Shape shape = (Shape)obj;
        return Objects.equals(this.coords, shape.coords);
    }
}

