// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkebackup/logging/v1/logging.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of changes this log is about.
type ChangeType int32

const (
	// Default value, not specified.
	ChangeType_CHANGE_TYPE_UNSPECIFIED ChangeType = 0
	// The resource is created.
	ChangeType_CREATION ChangeType = 1
	// The resource is updated.
	ChangeType_UPDATE ChangeType = 2
	// The resource is deleted.
	ChangeType_DELETION ChangeType = 3
)

// Enum value maps for ChangeType.
var (
	ChangeType_name = map[int32]string{
		0: "CHANGE_TYPE_UNSPECIFIED",
		1: "CREATION",
		2: "UPDATE",
		3: "DELETION",
	}
	ChangeType_value = map[string]int32{
		"CHANGE_TYPE_UNSPECIFIED": 0,
		"CREATION":                1,
		"UPDATE":                  2,
		"DELETION":                3,
	}
)

func (x ChangeType) Enum() *ChangeType {
	p := new(ChangeType)
	*p = x
	return p
}

func (x ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_enumTypes[0].Descriptor()
}

func (ChangeType) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_logging_v1_logging_proto_enumTypes[0]
}

func (x ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeType.Descriptor instead.
func (ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP(), []int{0}
}

// use case 1
// A log entry when modification(creation, update, deletion) is made to a
// BackupPlan
type BackupPlanChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the old BackupPlan resource that is being modified.
	// Empty for creation.
	// Format: projects/{project}/locations/{location}/backupPlans/{backup_plan}
	BackupPlan string `protobuf:"bytes,1,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Type of the change is being made.
	ChangeType ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.gkebackup.logging.v1.ChangeType" json:"change_type,omitempty"`
	// Modification details.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The input BackupPlan resource with the updated fields populated to update
	// the source BackupPlan to.
	InputBackupPlan *LoggedBackupPlan `protobuf:"bytes,4,opt,name=input_backup_plan,json=inputBackupPlan,proto3" json:"input_backup_plan,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *BackupPlanChange) Reset() {
	*x = BackupPlanChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupPlanChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlanChange) ProtoMessage() {}

func (x *BackupPlanChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlanChange.ProtoReflect.Descriptor instead.
func (*BackupPlanChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP(), []int{0}
}

func (x *BackupPlanChange) GetBackupPlan() string {
	if x != nil {
		return x.BackupPlan
	}
	return ""
}

func (x *BackupPlanChange) GetChangeType() ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeType_CHANGE_TYPE_UNSPECIFIED
}

func (x *BackupPlanChange) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *BackupPlanChange) GetInputBackupPlan() *LoggedBackupPlan {
	if x != nil {
		return x.InputBackupPlan
	}
	return nil
}

func (x *BackupPlanChange) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// use case 2
// A log entry when modification(creation, update, deletion) is made to a
// Backup
type BackupChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the Backup resource that is being modified.
	// Format:
	// projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Type of the change is being made.
	ChangeType ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.gkebackup.logging.v1.ChangeType" json:"change_type,omitempty"`
	// Whether the change is made manually or automatically.
	Scheduled bool `protobuf:"varint,3,opt,name=scheduled,proto3" json:"scheduled,omitempty"`
	// Modification details.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The input Backup resource with the updated fields populated to update
	// the source Backup to, or the backup created automatically from retention
	// policy.
	InputBackup *LoggedBackup `protobuf:"bytes,5,opt,name=input_backup,json=inputBackup,proto3" json:"input_backup,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *BackupChange) Reset() {
	*x = BackupChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupChange) ProtoMessage() {}

func (x *BackupChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupChange.ProtoReflect.Descriptor instead.
func (*BackupChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP(), []int{1}
}

func (x *BackupChange) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *BackupChange) GetChangeType() ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeType_CHANGE_TYPE_UNSPECIFIED
}

func (x *BackupChange) GetScheduled() bool {
	if x != nil {
		return x.Scheduled
	}
	return false
}

func (x *BackupChange) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *BackupChange) GetInputBackup() *LoggedBackup {
	if x != nil {
		return x.InputBackup
	}
	return nil
}

func (x *BackupChange) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// use case 3
// A log entry when modification(creation, update, deletion) is made to a
// restorePlan.
type RestorePlanChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the RestorePlan resource that is being modified.
	// Empty for creation.
	// Format: projects/*/locations/*/restorePlans/*
	RestorePlan string `protobuf:"bytes,1,opt,name=restore_plan,json=restorePlan,proto3" json:"restore_plan,omitempty"`
	// Type of the change is being made.
	ChangeType ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.gkebackup.logging.v1.ChangeType" json:"change_type,omitempty"`
	// Modification details.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The input RestorePlan resource with the updated fields populated to update
	// the source RestorePlan to.
	InputRestorePlan *LoggedRestorePlan `protobuf:"bytes,4,opt,name=input_restore_plan,json=inputRestorePlan,proto3" json:"input_restore_plan,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *RestorePlanChange) Reset() {
	*x = RestorePlanChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestorePlanChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestorePlanChange) ProtoMessage() {}

func (x *RestorePlanChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestorePlanChange.ProtoReflect.Descriptor instead.
func (*RestorePlanChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP(), []int{2}
}

func (x *RestorePlanChange) GetRestorePlan() string {
	if x != nil {
		return x.RestorePlan
	}
	return ""
}

func (x *RestorePlanChange) GetChangeType() ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeType_CHANGE_TYPE_UNSPECIFIED
}

func (x *RestorePlanChange) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *RestorePlanChange) GetInputRestorePlan() *LoggedRestorePlan {
	if x != nil {
		return x.InputRestorePlan
	}
	return nil
}

func (x *RestorePlanChange) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// use case 4
// A log entry when modification(creation, update, deletion) is made to a
// restore.
type RestoreChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the Restore resource that is being modified.
	// Empty for creation.
	// Format: projects/*/locations/*/restorePlans/*/restores/*
	Restore string `protobuf:"bytes,1,opt,name=restore,proto3" json:"restore,omitempty"`
	// Type of the change is being made.
	ChangeType ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.gkebackup.logging.v1.ChangeType" json:"change_type,omitempty"`
	// Modification details.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The input Restore resource with the updated fields populated to update
	// the source Restore to.
	InputRestore *LoggedRestore `protobuf:"bytes,4,opt,name=input_restore,json=inputRestore,proto3" json:"input_restore,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *RestoreChange) Reset() {
	*x = RestoreChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreChange) ProtoMessage() {}

func (x *RestoreChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreChange.ProtoReflect.Descriptor instead.
func (*RestoreChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP(), []int{3}
}

func (x *RestoreChange) GetRestore() string {
	if x != nil {
		return x.Restore
	}
	return ""
}

func (x *RestoreChange) GetChangeType() ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeType_CHANGE_TYPE_UNSPECIFIED
}

func (x *RestoreChange) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *RestoreChange) GetInputRestore() *LoggedRestore {
	if x != nil {
		return x.InputRestore
	}
	return nil
}

func (x *RestoreChange) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

var File_google_cloud_gkebackup_logging_v1_logging_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_logging_v1_logging_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x65,
	0x64, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x02, 0x0a, 0x10, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x4e, 0x0a,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5f, 0x0a, 0x11, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x28, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xcf, 0x02, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x4e,
	0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x52, 0x0a, 0x0c, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x28, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xd1, 0x02, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x4e, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x62, 0x0a,
	0x12, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x65, 0x64, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xb7, 0x02, 0x0a, 0x0d,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x55, 0x0a, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x2a, 0x51, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x42, 0xed, 0x01, 0x0a, 0x21, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x0c,
	0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31,
	0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescData = file_google_cloud_gkebackup_logging_v1_logging_proto_rawDesc
)

func file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_logging_v1_logging_proto_rawDescData
}

var file_google_cloud_gkebackup_logging_v1_logging_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_gkebackup_logging_v1_logging_proto_goTypes = []interface{}{
	(ChangeType)(0),               // 0: google.cloud.gkebackup.logging.v1.ChangeType
	(*BackupPlanChange)(nil),      // 1: google.cloud.gkebackup.logging.v1.BackupPlanChange
	(*BackupChange)(nil),          // 2: google.cloud.gkebackup.logging.v1.BackupChange
	(*RestorePlanChange)(nil),     // 3: google.cloud.gkebackup.logging.v1.RestorePlanChange
	(*RestoreChange)(nil),         // 4: google.cloud.gkebackup.logging.v1.RestoreChange
	(*fieldmaskpb.FieldMask)(nil), // 5: google.protobuf.FieldMask
	(*LoggedBackupPlan)(nil),      // 6: google.cloud.gkebackup.logging.v1.LoggedBackupPlan
	(*status.Status)(nil),         // 7: google.rpc.Status
	(*LoggedBackup)(nil),          // 8: google.cloud.gkebackup.logging.v1.LoggedBackup
	(*LoggedRestorePlan)(nil),     // 9: google.cloud.gkebackup.logging.v1.LoggedRestorePlan
	(*LoggedRestore)(nil),         // 10: google.cloud.gkebackup.logging.v1.LoggedRestore
}
var file_google_cloud_gkebackup_logging_v1_logging_proto_depIdxs = []int32{
	0,  // 0: google.cloud.gkebackup.logging.v1.BackupPlanChange.change_type:type_name -> google.cloud.gkebackup.logging.v1.ChangeType
	5,  // 1: google.cloud.gkebackup.logging.v1.BackupPlanChange.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 2: google.cloud.gkebackup.logging.v1.BackupPlanChange.input_backup_plan:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackupPlan
	7,  // 3: google.cloud.gkebackup.logging.v1.BackupPlanChange.error:type_name -> google.rpc.Status
	0,  // 4: google.cloud.gkebackup.logging.v1.BackupChange.change_type:type_name -> google.cloud.gkebackup.logging.v1.ChangeType
	5,  // 5: google.cloud.gkebackup.logging.v1.BackupChange.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 6: google.cloud.gkebackup.logging.v1.BackupChange.input_backup:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackup
	7,  // 7: google.cloud.gkebackup.logging.v1.BackupChange.error:type_name -> google.rpc.Status
	0,  // 8: google.cloud.gkebackup.logging.v1.RestorePlanChange.change_type:type_name -> google.cloud.gkebackup.logging.v1.ChangeType
	5,  // 9: google.cloud.gkebackup.logging.v1.RestorePlanChange.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 10: google.cloud.gkebackup.logging.v1.RestorePlanChange.input_restore_plan:type_name -> google.cloud.gkebackup.logging.v1.LoggedRestorePlan
	7,  // 11: google.cloud.gkebackup.logging.v1.RestorePlanChange.error:type_name -> google.rpc.Status
	0,  // 12: google.cloud.gkebackup.logging.v1.RestoreChange.change_type:type_name -> google.cloud.gkebackup.logging.v1.ChangeType
	5,  // 13: google.cloud.gkebackup.logging.v1.RestoreChange.update_mask:type_name -> google.protobuf.FieldMask
	10, // 14: google.cloud.gkebackup.logging.v1.RestoreChange.input_restore:type_name -> google.cloud.gkebackup.logging.v1.LoggedRestore
	7,  // 15: google.cloud.gkebackup.logging.v1.RestoreChange.error:type_name -> google.rpc.Status
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_logging_v1_logging_proto_init() }
func file_google_cloud_gkebackup_logging_v1_logging_proto_init() {
	if File_google_cloud_gkebackup_logging_v1_logging_proto != nil {
		return
	}
	file_google_cloud_gkebackup_logging_v1_logged_backup_proto_init()
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_init()
	file_google_cloud_gkebackup_logging_v1_logged_restore_proto_init()
	file_google_cloud_gkebackup_logging_v1_logged_restore_plan_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupPlanChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestorePlanChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_logging_v1_logging_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_logging_v1_logging_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_logging_v1_logging_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_logging_v1_logging_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_logging_v1_logging_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_logging_v1_logging_proto = out.File
	file_google_cloud_gkebackup_logging_v1_logging_proto_rawDesc = nil
	file_google_cloud_gkebackup_logging_v1_logging_proto_goTypes = nil
	file_google_cloud_gkebackup_logging_v1_logging_proto_depIdxs = nil
}
