// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegrationRequest
type DeleteIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIntegrationInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.IntegrationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntegrationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntegrationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationId != nil {
		v := *s.IntegrationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "integrationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegrationOutput
type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntegrationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes an Integration.
//
//    // Example sending a request using DeleteIntegrationRequest.
//    req := client.DeleteIntegrationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegration
func (c *Client) DeleteIntegrationRequest(input *DeleteIntegrationInput) DeleteIntegrationRequest {
	op := &aws.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	req := c.newRequest(op, input, &DeleteIntegrationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteIntegrationRequest{Request: req, Input: input, Copy: c.DeleteIntegrationRequest}
}

// DeleteIntegrationRequest is the request type for the
// DeleteIntegration API operation.
type DeleteIntegrationRequest struct {
	*aws.Request
	Input *DeleteIntegrationInput
	Copy  func(*DeleteIntegrationInput) DeleteIntegrationRequest
}

// Send marshals and sends the DeleteIntegration API request.
func (r DeleteIntegrationRequest) Send(ctx context.Context) (*DeleteIntegrationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIntegrationResponse{
		DeleteIntegrationOutput: r.Request.Data.(*DeleteIntegrationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIntegrationResponse is the response type for the
// DeleteIntegration API operation.
type DeleteIntegrationResponse struct {
	*DeleteIntegrationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIntegration request.
func (r *DeleteIntegrationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
