// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersionsInput
type ListBackupPlanVersionsInput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBackupPlanVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupPlanVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBackupPlanVersionsInput"}

	if s.BackupPlanId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupPlanId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupPlanVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.BackupPlanId != nil {
		v := *s.BackupPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersionsOutput
type ListBackupPlanVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of version list items containing metadata about your backup plans.
	BackupPlanVersionsList []BackupPlansListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBackupPlanVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupPlanVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.BackupPlanVersionsList) > 0 {
		v := s.BackupPlanVersionsList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BackupPlanVersionsList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBackupPlanVersions = "ListBackupPlanVersions"

// ListBackupPlanVersionsRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns version metadata of your backup plans, including Amazon Resource
// Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and
// version IDs.
//
//    // Example sending a request using ListBackupPlanVersionsRequest.
//    req := client.ListBackupPlanVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions
func (c *Client) ListBackupPlanVersionsRequest(input *ListBackupPlanVersionsInput) ListBackupPlanVersionsRequest {
	op := &aws.Operation{
		Name:       opListBackupPlanVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/versions/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupPlanVersionsInput{}
	}

	req := c.newRequest(op, input, &ListBackupPlanVersionsOutput{})
	return ListBackupPlanVersionsRequest{Request: req, Input: input, Copy: c.ListBackupPlanVersionsRequest}
}

// ListBackupPlanVersionsRequest is the request type for the
// ListBackupPlanVersions API operation.
type ListBackupPlanVersionsRequest struct {
	*aws.Request
	Input *ListBackupPlanVersionsInput
	Copy  func(*ListBackupPlanVersionsInput) ListBackupPlanVersionsRequest
}

// Send marshals and sends the ListBackupPlanVersions API request.
func (r ListBackupPlanVersionsRequest) Send(ctx context.Context) (*ListBackupPlanVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBackupPlanVersionsResponse{
		ListBackupPlanVersionsOutput: r.Request.Data.(*ListBackupPlanVersionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBackupPlanVersionsRequestPaginator returns a paginator for ListBackupPlanVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBackupPlanVersionsRequest(input)
//   p := backup.NewListBackupPlanVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBackupPlanVersionsPaginator(req ListBackupPlanVersionsRequest) ListBackupPlanVersionsPaginator {
	return ListBackupPlanVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBackupPlanVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBackupPlanVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBackupPlanVersionsPaginator struct {
	aws.Pager
}

func (p *ListBackupPlanVersionsPaginator) CurrentPage() *ListBackupPlanVersionsOutput {
	return p.Pager.CurrentPage().(*ListBackupPlanVersionsOutput)
}

// ListBackupPlanVersionsResponse is the response type for the
// ListBackupPlanVersions API operation.
type ListBackupPlanVersionsResponse struct {
	*ListBackupPlanVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBackupPlanVersions request.
func (r *ListBackupPlanVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
