// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to list invalidations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ListInvalidationsRequest
type ListInvalidationsInput struct {
	_ struct{} `type:"structure"`

	// The distribution's ID.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// Use this parameter when paginating results to indicate where to begin in
	// your list of invalidation batches. Because the results are returned in decreasing
	// order from most recent to oldest, the most recent results are on the first
	// page, the second page will contain earlier results, and so on. To get the
	// next page of results, set Marker to the value of the NextMarker from the
	// current page's response. This value is the same as the ID of the last invalidation
	// batch on that page.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of invalidation batches that you want in the response
	// body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListInvalidationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvalidationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInvalidationsInput"}

	if s.DistributionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DistributionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInvalidationsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DistributionId != nil {
		v := *s.DistributionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DistributionId", protocol.StringValue(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The returned result of the corresponding request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ListInvalidationsResult
type ListInvalidationsOutput struct {
	_ struct{} `type:"structure" payload:"InvalidationList"`

	// Information about invalidation batches.
	InvalidationList *InvalidationList `type:"structure"`
}

// String returns the string representation
func (s ListInvalidationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInvalidationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InvalidationList != nil {
		v := s.InvalidationList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "InvalidationList", v, metadata)
	}
	return nil
}

const opListInvalidations = "ListInvalidations2018_11_05"

// ListInvalidationsRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Lists invalidation batches.
//
//    // Example sending a request using ListInvalidationsRequest.
//    req := client.ListInvalidationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/ListInvalidations
func (c *Client) ListInvalidationsRequest(input *ListInvalidationsInput) ListInvalidationsRequest {
	op := &aws.Operation{
		Name:       opListInvalidations,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-11-05/distribution/{DistributionId}/invalidation",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"InvalidationList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "InvalidationList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListInvalidationsInput{}
	}

	req := c.newRequest(op, input, &ListInvalidationsOutput{})
	return ListInvalidationsRequest{Request: req, Input: input, Copy: c.ListInvalidationsRequest}
}

// ListInvalidationsRequest is the request type for the
// ListInvalidations API operation.
type ListInvalidationsRequest struct {
	*aws.Request
	Input *ListInvalidationsInput
	Copy  func(*ListInvalidationsInput) ListInvalidationsRequest
}

// Send marshals and sends the ListInvalidations API request.
func (r ListInvalidationsRequest) Send(ctx context.Context) (*ListInvalidationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInvalidationsResponse{
		ListInvalidationsOutput: r.Request.Data.(*ListInvalidationsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInvalidationsRequestPaginator returns a paginator for ListInvalidations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInvalidationsRequest(input)
//   p := cloudfront.NewListInvalidationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInvalidationsPaginator(req ListInvalidationsRequest) ListInvalidationsPaginator {
	return ListInvalidationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInvalidationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInvalidationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInvalidationsPaginator struct {
	aws.Pager
}

func (p *ListInvalidationsPaginator) CurrentPage() *ListInvalidationsOutput {
	return p.Pager.CurrentPage().(*ListInvalidationsOutput)
}

// ListInvalidationsResponse is the response type for the
// ListInvalidations API operation.
type ListInvalidationsResponse struct {
	*ListInvalidationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInvalidations request.
func (r *ListInvalidationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
