// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a BatchGetOnPremisesInstances operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstancesInput
type BatchGetOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances about which to get information. The
	// maximum number of instance names you can specify is 25.
	//
	// InstanceNames is a required field
	InstanceNames []string `locationName:"instanceNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetOnPremisesInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetOnPremisesInstancesInput"}

	if s.InstanceNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a BatchGetOnPremisesInstances operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstancesOutput
type BatchGetOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the on-premises instances.
	InstanceInfos []InstanceInfo `locationName:"instanceInfos" type:"list"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetOnPremisesInstances = "BatchGetOnPremisesInstances"

// BatchGetOnPremisesInstancesRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Gets information about one or more on-premises instances. The maximum number
// of on-premises instances that can be returned is 25.
//
//    // Example sending a request using BatchGetOnPremisesInstancesRequest.
//    req := client.BatchGetOnPremisesInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances
func (c *Client) BatchGetOnPremisesInstancesRequest(input *BatchGetOnPremisesInstancesInput) BatchGetOnPremisesInstancesRequest {
	op := &aws.Operation{
		Name:       opBatchGetOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetOnPremisesInstancesInput{}
	}

	req := c.newRequest(op, input, &BatchGetOnPremisesInstancesOutput{})
	return BatchGetOnPremisesInstancesRequest{Request: req, Input: input, Copy: c.BatchGetOnPremisesInstancesRequest}
}

// BatchGetOnPremisesInstancesRequest is the request type for the
// BatchGetOnPremisesInstances API operation.
type BatchGetOnPremisesInstancesRequest struct {
	*aws.Request
	Input *BatchGetOnPremisesInstancesInput
	Copy  func(*BatchGetOnPremisesInstancesInput) BatchGetOnPremisesInstancesRequest
}

// Send marshals and sends the BatchGetOnPremisesInstances API request.
func (r BatchGetOnPremisesInstancesRequest) Send(ctx context.Context) (*BatchGetOnPremisesInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetOnPremisesInstancesResponse{
		BatchGetOnPremisesInstancesOutput: r.Request.Data.(*BatchGetOnPremisesInstancesOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetOnPremisesInstancesResponse is the response type for the
// BatchGetOnPremisesInstances API operation.
type BatchGetOnPremisesInstancesResponse struct {
	*BatchGetOnPremisesInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetOnPremisesInstances request.
func (r *BatchGetOnPremisesInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
