// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhookInput
type PutWebhookInput struct {
	_ struct{} `type:"structure"`

	// The tags for the webhook.
	Tags []Tag `locationName:"tags" type:"list"`

	// The detail provided in an input file to create the webhook, such as the webhook
	// name, the pipeline name, and the action name. Give the webhook a unique name
	// which identifies the webhook being defined. You may choose to name the webhook
	// after the pipeline and action it targets so that you can easily recognize
	// what it's used for later.
	//
	// Webhook is a required field
	Webhook *WebhookDefinition `locationName:"webhook" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutWebhookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutWebhookInput"}

	if s.Webhook == nil {
		invalidParams.Add(aws.NewErrParamRequired("Webhook"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Webhook != nil {
		if err := s.Webhook.Validate(); err != nil {
			invalidParams.AddNested("Webhook", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhookOutput
type PutWebhookOutput struct {
	_ struct{} `type:"structure"`

	// The detail returned from creating the webhook, such as the webhook name,
	// webhook URL, and webhook ARN.
	Webhook *ListWebhookItem `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s PutWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutWebhook = "PutWebhook"

// PutWebhookRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Defines a webhook and returns a unique webhook URL generated by CodePipeline.
// This URL can be supplied to third party source hosting providers to call
// every time there's a code change. When CodePipeline receives a POST request
// on this URL, the pipeline defined in the webhook is started as long as the
// POST request satisfied the authentication and filtering requirements supplied
// when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty
// APIs can be used to automatically configure supported third parties to call
// the generated webhook URL.
//
//    // Example sending a request using PutWebhookRequest.
//    req := client.PutWebhookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhook
func (c *Client) PutWebhookRequest(input *PutWebhookInput) PutWebhookRequest {
	op := &aws.Operation{
		Name:       opPutWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutWebhookInput{}
	}

	req := c.newRequest(op, input, &PutWebhookOutput{})
	return PutWebhookRequest{Request: req, Input: input, Copy: c.PutWebhookRequest}
}

// PutWebhookRequest is the request type for the
// PutWebhook API operation.
type PutWebhookRequest struct {
	*aws.Request
	Input *PutWebhookInput
	Copy  func(*PutWebhookInput) PutWebhookRequest
}

// Send marshals and sends the PutWebhook API request.
func (r PutWebhookRequest) Send(ctx context.Context) (*PutWebhookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutWebhookResponse{
		PutWebhookOutput: r.Request.Data.(*PutWebhookOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutWebhookResponse is the response type for the
// PutWebhook API operation.
type PutWebhookResponse struct {
	*PutWebhookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutWebhook request.
func (r *PutWebhookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
