// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The amount of instance usage that a reservation covered.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/Coverage
type Coverage struct {
	_ struct{} `type:"structure"`

	// The amount of cost that the reservation covered.
	CoverageCost *CoverageCost `type:"structure"`

	// The amount of instance usage that the reservation covered, in hours.
	CoverageHours *CoverageHours `type:"structure"`

	// The amount of instance usage that the reservation covered, in normalized
	// units.
	CoverageNormalizedUnits *CoverageNormalizedUnits `type:"structure"`
}

// String returns the string representation
func (s Coverage) String() string {
	return awsutil.Prettify(s)
}

// Reservation coverage for a specified period, in hours.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CoverageByTime
type CoverageByTime struct {
	_ struct{} `type:"structure"`

	// The groups of instances that the reservation covered.
	Groups []ReservationCoverageGroup `type:"list"`

	// The period that this coverage was used over.
	TimePeriod *DateInterval `type:"structure"`

	// The total reservation coverage, in hours.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s CoverageByTime) String() string {
	return awsutil.Prettify(s)
}

// How much it cost to run an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CoverageCost
type CoverageCost struct {
	_ struct{} `type:"structure"`

	// How much an On-Demand instance cost.
	OnDemandCost *string `type:"string"`
}

// String returns the string representation
func (s CoverageCost) String() string {
	return awsutil.Prettify(s)
}

// How long a running instance either used a reservation or was On-Demand.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CoverageHours
type CoverageHours struct {
	_ struct{} `type:"structure"`

	// The percentage of instance hours that a reservation covered.
	CoverageHoursPercentage *string `type:"string"`

	// The number of instance running hours that On-Demand Instances covered.
	OnDemandHours *string `type:"string"`

	// The number of instance running hours that reservations covered.
	ReservedHours *string `type:"string"`

	// The total instance usage, in hours.
	TotalRunningHours *string `type:"string"`
}

// String returns the string representation
func (s CoverageHours) String() string {
	return awsutil.Prettify(s)
}

// The amount of instance usage, in normalized units. Normalized units enable
// you to see your EC2 usage for multiple sizes of instances in a uniform way.
// For example, suppose you run an xlarge instance and a 2xlarge instance. If
// you run both instances for the same amount of time, the 2xlarge instance
// uses twice as much of your reservation as the xlarge instance, even though
// both instances show only one instance-hour. Using normalized units instead
// of instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge
// instance used 16 normalized units.
//
// For more information, see Modifying Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CoverageNormalizedUnits
type CoverageNormalizedUnits struct {
	_ struct{} `type:"structure"`

	// The percentage of your used instance normalized units that a reservation
	// covers.
	CoverageNormalizedUnitsPercentage *string `type:"string"`

	// The number of normalized units that are covered by On-Demand Instances instead
	// of a reservation.
	OnDemandNormalizedUnits *string `type:"string"`

	// The number of normalized units that a reservation covers.
	ReservedNormalizedUnits *string `type:"string"`

	// The total number of normalized units that you used.
	TotalRunningNormalizedUnits *string `type:"string"`
}

// String returns the string representation
func (s CoverageNormalizedUnits) String() string {
	return awsutil.Prettify(s)
}

// The time period that you want the usage and costs for.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DateInterval
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period that you want the usage and costs for. The end
	// date is exclusive. For example, if end is 2017-05-01, AWS retrieves cost
	// and usage data from the start date up to, but not including, 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period that you want the usage and costs for. The
	// start date is inclusive. For example, if start is 2017-01-01, AWS retrieves
	// cost and usage data starting at 2017-01-01 up to the end date.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DateInterval"}

	if s.End == nil {
		invalidParams.Add(aws.NewErrParamRequired("End"))
	}

	if s.Start == nil {
		invalidParams.Add(aws.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DimensionValues
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	Key Dimension `type:"string" enum:"true"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	//
	// Valid values for the SERVICE dimension are Amazon Elastic Compute Cloud -
	// Compute, Amazon Elasticsearch Service, Amazon ElastiCache, Amazon Redshift,
	// and Amazon Relational Database Service.
	Values []string `type:"list"`
}

// String returns the string representation
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DimensionValuesWithAttributes
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon EC2 instances that AWS recommends that you purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/EC2InstanceDetails
type EC2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string `type:"string"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`

	// Whether the recommended reservation is dedicated or shared.
	Tenancy *string `type:"string"`
}

// String returns the string representation
func (s EC2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
// for.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/EC2Specification
type EC2Specification struct {
	_ struct{} `type:"structure"`

	// Whether you want a recommendation for standard or convertible reservations.
	OfferingClass OfferingClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s EC2Specification) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon ES instances that AWS recommends that you purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ESInstanceDetails
type ESInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The class of instance that AWS recommends.
	InstanceClass *string `type:"string"`

	// The size of instance that AWS recommends.
	InstanceSize *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ESInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon ElastiCache instances that AWS recommends that you
// purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ElastiCacheInstanceDetails
type ElastiCacheInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The description of the recommended reservation.
	ProductDescription *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ElastiCacheInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
//    * Simple dimension values - You can set the dimension name and values
//    for the filters that you plan to use. For example, you can filter for
//    INSTANCE_TYPE==m4.xlarge OR INSTANCE_TYPE==c4.large. The Expression for
//    that looks like this: { "Dimensions": { "Key": "INSTANCE_TYPE", "Values":
//    [ "m4.xlarge", “c4.large” ] } } The list of dimension values are OR'd
//    together to retrieve cost or usage data. You can create Expression and
//    DimensionValues objects using either with* methods or set* methods in
//    multiple lines.
//
//    * Compound dimension values with logical operations - You can use multiple
//    Expression types and the logical operators AND/OR/NOT to create a list
//    of one or more Expression objects. This allows you to filter on more advanced
//    options. For example, you can filter on ((INSTANCE_TYPE == m4.large OR
//    INSTANCE_TYPE == m3.large) OR (TAG.Type == Type1)) AND (USAGE_TYPE !=
//    DataTransfer). The Expression for that looks like this: { "And": [ {"Or":
//    [ {"Dimensions": { "Key": "INSTANCE_TYPE", "Values": [ "m4.x.large", "c4.large"
//    ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not":
//    {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ]
//    } Because each Expression can have only one operator, the service returns
//    an error if more than one is specified. The following example shows an
//    Expression object that creates an error. { "And": [ ... ], "DimensionValues":
//    { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/Expression
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []Expression `type:"list"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match a Dimension object.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension object.
	Or []Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// The forecast created for your query.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ForecastResult
type ForecastResult struct {
	_ struct{} `type:"structure"`

	// The mean value of the forecast.
	MeanValue *string `type:"string"`

	// The lower limit for the prediction interval.
	PredictionIntervalLowerBound *string `type:"string"`

	// The upper limit for the prediction interval.
	PredictionIntervalUpperBound *string `type:"string"`

	// The period of time that the forecast covers.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s ForecastResult) String() string {
	return awsutil.Prettify(s)
}

// One level of grouped data in the results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/Group
type Group struct {
	_ struct{} `type:"structure"`

	// The keys that are included in this group.
	Keys []string `type:"list"`

	// The metrics that are included in this group.
	Metrics map[string]MetricValue `type:"map"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// Represents a group when you specify a group by criteria or in the response
// to a query with a specific grouping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GroupDefinition
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type GroupDefinitionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// Details about the instances that AWS recommends that you purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/InstanceDetails
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 instances that AWS recommends that you purchase.
	EC2InstanceDetails *EC2InstanceDetails `type:"structure"`

	// The Amazon ES instances that AWS recommends that you purchase.
	ESInstanceDetails *ESInstanceDetails `type:"structure"`

	// The ElastiCache instances that AWS recommends that you purchase.
	ElastiCacheInstanceDetails *ElastiCacheInstanceDetails `type:"structure"`

	// The Amazon RDS instances that AWS recommends that you purchase.
	RDSInstanceDetails *RDSInstanceDetails `type:"structure"`

	// The Amazon Redshift instances that AWS recommends that you purchase.
	RedshiftInstanceDetails *RedshiftInstanceDetails `type:"structure"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// The aggregated value for a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/MetricValue
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon RDS instances that AWS recommends that you purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/RDSInstanceDetails
type RDSInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string `type:"string"`

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string `type:"string"`

	// Whether the recommendation is for a reservation in a single Availability
	// Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string `type:"string"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The license model that the recommended reservation supports.
	LicenseModel *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RDSInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon Redshift instances that AWS recommends that you
// purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/RedshiftInstanceDetails
type RedshiftInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RedshiftInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// The aggregated numbers for your reservation usage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationAggregates
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// The monthly cost of your reservation, amortized over the reservation period.
	AmortizedRecurringFee *string `type:"string"`

	// The upfront cost of your reservation, amortized over the reservation period.
	AmortizedUpfrontFee *string `type:"string"`

	// How much you saved due to purchasing and utilizing reservation. AWS calculates
	// this by subtracting TotalAmortizedFee from OnDemandCostOfRIHoursUsed.
	NetRISavings *string `type:"string"`

	// How much your reservation would cost if charged On-Demand rates.
	OnDemandCostOfRIHoursUsed *string `type:"string"`

	// How many reservation hours that you purchased.
	PurchasedHours *string `type:"string"`

	// How many Amazon EC2 reservation hours that you purchased, converted to normalized
	// units. Normalized units are available only for Amazon EC2 usage after November
	// 11, 2017.
	PurchasedUnits *string `type:"string"`

	// The total number of reservation hours that you used.
	TotalActualHours *string `type:"string"`

	// The total number of Amazon EC2 reservation hours that you used, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	TotalActualUnits *string `type:"string"`

	// The total cost of your reservation, amortized over the reservation period.
	TotalAmortizedFee *string `type:"string"`

	// How much you could save if you use your entire reservation.
	TotalPotentialRISavings *string `type:"string"`

	// The number of reservation hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The number of Amazon EC2 reservation hours that you didn't use, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UnusedUnits *string `type:"string"`

	// The percentage of reservation time that you used.
	UtilizationPercentage *string `type:"string"`

	// The percentage of Amazon EC2 reservation time that you used, converted to
	// normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UtilizationPercentageInUnits *string `type:"string"`
}

// String returns the string representation
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// A group of reservations that share a set of attributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationCoverageGroup
type ReservationCoverageGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]string `type:"map"`

	// How much instance usage this group of reservations covered.
	Coverage *Coverage `type:"structure"`
}

// String returns the string representation
func (s ReservationCoverageGroup) String() string {
	return awsutil.Prettify(s)
}

// A specific reservation that AWS recommends for purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationPurchaseRecommendation
type ReservationPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that AWS recommends that you purchase this instance for.
	// For example, you can purchase this reservation for an entire organization
	// in AWS Organizations.
	AccountScope AccountScope `type:"string" enum:"true"`

	// How many days of previous usage that AWS considers when making this recommendation.
	LookbackPeriodInDays LookbackPeriodInDays `type:"string" enum:"true"`

	// The payment option for the reservation. For example, AllUpfront or NoUpfront.
	PaymentOption PaymentOption `type:"string" enum:"true"`

	// Details about the recommended purchases.
	RecommendationDetails []ReservationPurchaseRecommendationDetail `type:"list"`

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary `type:"structure"`

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The term of the reservation that you want recommendations for, in years.
	TermInYears TermInYears `type:"string" enum:"true"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// Details about your recommended reservation purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationPurchaseRecommendationDetail
type ReservationPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The account that this RI recommendation is for.
	AccountId *string `type:"string"`

	// The average number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	AverageNormalizedUnitsUsedPerHour *string `type:"string"`

	// The average number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	AverageNumberOfInstancesUsedPerHour *string `type:"string"`

	// The average utilization of your instances. AWS uses this to calculate your
	// recommended reservation purchases.
	AverageUtilization *string `type:"string"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// How long AWS estimates that it takes for this instance to start saving you
	// money, in months.
	EstimatedBreakEvenInMonths *string `type:"string"`

	// How much AWS estimates that you spend on On-Demand Instances in a month.
	EstimatedMonthlyOnDemandCost *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string `type:"string"`

	// How much AWS estimates that you would have spent for all usage during the
	// specified historical period if you had had a reservation.
	EstimatedReservationCostForLookbackPeriod *string `type:"string"`

	// Details about the instances that AWS recommends that you purchase.
	InstanceDetails *InstanceDetails `type:"structure"`

	// The maximum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MaximumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The maximum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MaximumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The minimum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MinimumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The minimum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MinimumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The number of normalized units that AWS recommends that you purchase.
	RecommendedNormalizedUnitsToPurchase *string `type:"string"`

	// The number of instances that AWS recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string `type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string `type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about this specific recommendation, such as the time stamp for
// when AWS made a specific recommendation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationPurchaseRecommendationMetadata
type ReservationPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The time stamp for when AWS made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// A summary about this recommendation, such as the currency code, the amount
// that AWS estimates that you could save, and the total amount of reservation
// to purchase.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationPurchaseRecommendationSummary
type ReservationPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code used for this recommendation.
	CurrencyCode *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month.
	TotalEstimatedMonthlySavingsAmount *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// A group of reservations that share a set of attributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ReservationUtilizationGroup
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]string `type:"map"`

	// The key for a specific reservation attribute.
	Key *string `type:"string"`

	// How much you used this group of reservations.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific reservation attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// The result that is associated with a time period.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ResultByTime
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Whether the result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that this time period includes.
	Groups []Group `type:"list"`

	// The time period that the result covers.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]MetricValue `type:"map"`
}

// String returns the string representation
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// Hardware specifications for the service that you want recommendations for.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ServiceSpecification
type ServiceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
	// for.
	EC2Specification *EC2Specification `type:"structure"`
}

// String returns the string representation
func (s ServiceSpecification) String() string {
	return awsutil.Prettify(s)
}

// The values that are available for a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/TagValues
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	Key *string `type:"string"`

	// The specific value of the tag.
	Values []string `type:"list"`
}

// String returns the string representation
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// The amount of utilization, in hours.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UtilizationByTime
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that this utilization result uses.
	Groups []ReservationUtilizationGroup `type:"list"`

	// The period of time that this utilization was used for.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of reservation hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}
