// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Describes a conditional forwarder.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwardersRequest
type DescribeConditionalForwardersInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which to get the list of associated conditional forwarders.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain names (FQDN) of the remote domains for which to
	// get the list of associated conditional forwarders. If this member is null,
	// all conditional forwarders are returned.
	RemoteDomainNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConditionalForwardersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConditionalForwardersInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeConditionalForwarder request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwardersResult
type DescribeConditionalForwardersOutput struct {
	_ struct{} `type:"structure"`

	// The list of conditional forwarders that have been created.
	ConditionalForwarders []ConditionalForwarder `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConditionalForwarders = "DescribeConditionalForwarders"

// DescribeConditionalForwardersRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Obtains information about the conditional forwarders for this account.
//
// If no input parameters are provided for RemoteDomainNames, this request describes
// all conditional forwarders for the specified directory ID.
//
//    // Example sending a request using DescribeConditionalForwardersRequest.
//    req := client.DescribeConditionalForwardersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders
func (c *Client) DescribeConditionalForwardersRequest(input *DescribeConditionalForwardersInput) DescribeConditionalForwardersRequest {
	op := &aws.Operation{
		Name:       opDescribeConditionalForwarders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConditionalForwardersInput{}
	}

	req := c.newRequest(op, input, &DescribeConditionalForwardersOutput{})
	return DescribeConditionalForwardersRequest{Request: req, Input: input, Copy: c.DescribeConditionalForwardersRequest}
}

// DescribeConditionalForwardersRequest is the request type for the
// DescribeConditionalForwarders API operation.
type DescribeConditionalForwardersRequest struct {
	*aws.Request
	Input *DescribeConditionalForwardersInput
	Copy  func(*DescribeConditionalForwardersInput) DescribeConditionalForwardersRequest
}

// Send marshals and sends the DescribeConditionalForwarders API request.
func (r DescribeConditionalForwardersRequest) Send(ctx context.Context) (*DescribeConditionalForwardersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConditionalForwardersResponse{
		DescribeConditionalForwardersOutput: r.Request.Data.(*DescribeConditionalForwardersOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConditionalForwardersResponse is the response type for the
// DescribeConditionalForwarders API operation.
type DescribeConditionalForwardersResponse struct {
	*DescribeConditionalForwardersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConditionalForwarders request.
func (r *DescribeConditionalForwardersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
