// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTableInput
type CreateGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The global table name.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`

	// The regions where the global table needs to be created.
	//
	// ReplicationGroup is a required field
	ReplicationGroup []Replica `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGlobalTableInput"}

	if s.GlobalTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GlobalTableName", 3))
	}

	if s.ReplicationGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTableOutput
type CreateGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateGlobalTable = "CreateGlobalTable"

// CreateGlobalTableRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Creates a global table from an existing table. A global table creates a replication
// relationship between two or more DynamoDB tables with the same table name
// in the provided regions.
//
// If you want to add a new replica table to a global table, each of the following
// conditions must be true:
//
//    * The table must have the same primary key as all of the other replicas.
//
//    * The table must have the same name as all of the other replicas.
//
//    * The table must have DynamoDB Streams enabled, with the stream containing
//    both the new and the old images of the item.
//
//    * None of the replica tables in the global table can contain any data.
//
// If global secondary indexes are specified, then the following conditions
// must also be met:
//
//    * The global secondary indexes must have the same name.
//
//    * The global secondary indexes must have the same hash key and sort key
//    (if present).
//
// Write capacity settings should be set consistently across your replica tables
// and secondary indexes. DynamoDB strongly recommends enabling auto scaling
// to manage the write capacity settings for all of your global tables replicas
// and indexes.
//
// If you prefer to manage write capacity settings manually, you should provision
// equal replicated write capacity units to your replica tables. You should
// also provision equal replicated write capacity units to matching secondary
// indexes across your global table.
//
//    // Example sending a request using CreateGlobalTableRequest.
//    req := client.CreateGlobalTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable
func (c *Client) CreateGlobalTableRequest(input *CreateGlobalTableInput) CreateGlobalTableRequest {
	op := &aws.Operation{
		Name:       opCreateGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGlobalTableInput{}
	}

	req := c.newRequest(op, input, &CreateGlobalTableOutput{})
	return CreateGlobalTableRequest{Request: req, Input: input, Copy: c.CreateGlobalTableRequest}
}

// CreateGlobalTableRequest is the request type for the
// CreateGlobalTable API operation.
type CreateGlobalTableRequest struct {
	*aws.Request
	Input *CreateGlobalTableInput
	Copy  func(*CreateGlobalTableInput) CreateGlobalTableRequest
}

// Send marshals and sends the CreateGlobalTable API request.
func (r CreateGlobalTableRequest) Send(ctx context.Context) (*CreateGlobalTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGlobalTableResponse{
		CreateGlobalTableOutput: r.Request.Data.(*CreateGlobalTableOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGlobalTableResponse is the response type for the
// CreateGlobalTable API operation.
type CreateGlobalTableResponse struct {
	*CreateGlobalTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGlobalTable request.
func (r *CreateGlobalTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
