// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of an UpdateTimeToLive operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLiveInput
type UpdateTimeToLiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to be configured.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// Represents the settings used to enable or disable Time to Live for the specified
	// table.
	//
	// TimeToLiveSpecification is a required field
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTimeToLiveInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTimeToLiveInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTimeToLiveInput"}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if s.TimeToLiveSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeToLiveSpecification"))
	}
	if s.TimeToLiveSpecification != nil {
		if err := s.TimeToLiveSpecification.Validate(); err != nil {
			invalidParams.AddNested("TimeToLiveSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLiveOutput
type UpdateTimeToLiveOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of an UpdateTimeToLive operation.
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure"`
}

// String returns the string representation
func (s UpdateTimeToLiveOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateTimeToLive = "UpdateTimeToLive"

// UpdateTimeToLiveRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// The UpdateTimeToLive method will enable or disable TTL for the specified
// table. A successful UpdateTimeToLive call returns the current TimeToLiveSpecification;
// it may take up to one hour for the change to fully process. Any additional
// UpdateTimeToLive calls for the same table during this one hour duration result
// in a ValidationException.
//
// TTL compares the current time in epoch time format to the time stored in
// the TTL attribute of an item. If the epoch time value stored in the attribute
// is less than the current time, the item is marked as expired and subsequently
// deleted.
//
// The epoch time format is the number of seconds elapsed since 12:00:00 AM
// January 1st, 1970 UTC.
//
// DynamoDB deletes expired items on a best-effort basis to ensure availability
// of throughput for other data operations.
//
// DynamoDB typically deletes expired items within two days of expiration. The
// exact duration within which an item gets deleted after expiration is specific
// to the nature of the workload. Items that have expired and not been deleted
// will still show up in reads, queries, and scans.
//
// As items are deleted, they are removed from any Local Secondary Index and
// Global Secondary Index immediately in the same eventually consistent way
// as a standard delete operation.
//
// For more information, see Time To Live (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html)
// in the Amazon DynamoDB Developer Guide.
//
//    // Example sending a request using UpdateTimeToLiveRequest.
//    req := client.UpdateTimeToLiveRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive
func (c *Client) UpdateTimeToLiveRequest(input *UpdateTimeToLiveInput) UpdateTimeToLiveRequest {
	op := &aws.Operation{
		Name:       opUpdateTimeToLive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTimeToLiveInput{}
	}

	req := c.newRequest(op, input, &UpdateTimeToLiveOutput{})
	return UpdateTimeToLiveRequest{Request: req, Input: input, Copy: c.UpdateTimeToLiveRequest}
}

// UpdateTimeToLiveRequest is the request type for the
// UpdateTimeToLive API operation.
type UpdateTimeToLiveRequest struct {
	*aws.Request
	Input *UpdateTimeToLiveInput
	Copy  func(*UpdateTimeToLiveInput) UpdateTimeToLiveRequest
}

// Send marshals and sends the UpdateTimeToLive API request.
func (r UpdateTimeToLiveRequest) Send(ctx context.Context) (*UpdateTimeToLiveResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTimeToLiveResponse{
		UpdateTimeToLiveOutput: r.Request.Data.(*UpdateTimeToLiveOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTimeToLiveResponse is the response type for the
// UpdateTimeToLive API operation.
type UpdateTimeToLiveResponse struct {
	*UpdateTimeToLiveOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTimeToLive request.
func (r *UpdateTimeToLiveResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
