// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsRequest
type AcceptVpcEndpointConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the endpoint service.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`

	// The IDs of one or more interface VPC endpoints.
	//
	// VpcEndpointIds is a required field
	VpcEndpointIds []string `locationName:"VpcEndpointId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s AcceptVpcEndpointConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptVpcEndpointConnectionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AcceptVpcEndpointConnectionsInput"}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}

	if s.VpcEndpointIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcEndpointIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsResult
type AcceptVpcEndpointConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the interface endpoints that were not accepted, if applicable.
	Unsuccessful []UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s AcceptVpcEndpointConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opAcceptVpcEndpointConnections = "AcceptVpcEndpointConnections"

// AcceptVpcEndpointConnectionsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Accepts one or more interface VPC endpoint connection requests to your VPC
// endpoint service.
//
//    // Example sending a request using AcceptVpcEndpointConnectionsRequest.
//    req := client.AcceptVpcEndpointConnectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections
func (c *Client) AcceptVpcEndpointConnectionsRequest(input *AcceptVpcEndpointConnectionsInput) AcceptVpcEndpointConnectionsRequest {
	op := &aws.Operation{
		Name:       opAcceptVpcEndpointConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcEndpointConnectionsInput{}
	}

	req := c.newRequest(op, input, &AcceptVpcEndpointConnectionsOutput{})
	return AcceptVpcEndpointConnectionsRequest{Request: req, Input: input, Copy: c.AcceptVpcEndpointConnectionsRequest}
}

// AcceptVpcEndpointConnectionsRequest is the request type for the
// AcceptVpcEndpointConnections API operation.
type AcceptVpcEndpointConnectionsRequest struct {
	*aws.Request
	Input *AcceptVpcEndpointConnectionsInput
	Copy  func(*AcceptVpcEndpointConnectionsInput) AcceptVpcEndpointConnectionsRequest
}

// Send marshals and sends the AcceptVpcEndpointConnections API request.
func (r AcceptVpcEndpointConnectionsRequest) Send(ctx context.Context) (*AcceptVpcEndpointConnectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AcceptVpcEndpointConnectionsResponse{
		AcceptVpcEndpointConnectionsOutput: r.Request.Data.(*AcceptVpcEndpointConnectionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AcceptVpcEndpointConnectionsResponse is the response type for the
// AcceptVpcEndpointConnections API operation.
type AcceptVpcEndpointConnectionsResponse struct {
	*AcceptVpcEndpointConnectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AcceptVpcEndpointConnections request.
func (r *AcceptVpcEndpointConnectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
