// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupportRequest
type DescribeVpcClassicLinkDnsSupportInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// One or more VPC IDs.
	VpcIds []string `locationNameList:"VpcId" type:"list"`
}

// String returns the string representation
func (s DescribeVpcClassicLinkDnsSupportInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVpcClassicLinkDnsSupportInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeVpcClassicLinkDnsSupportInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupportResult
type DescribeVpcClassicLinkDnsSupportOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about the ClassicLink DNS support status of the VPCs.
	Vpcs []ClassicLinkDnsSupport `locationName:"vpcs" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcClassicLinkDnsSupportOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpcClassicLinkDnsSupport = "DescribeVpcClassicLinkDnsSupport"

// DescribeVpcClassicLinkDnsSupportRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the ClassicLink DNS support status of one or more VPCs. If enabled,
// the DNS hostname of a linked EC2-Classic instance resolves to its private
// IP address when addressed from an instance in the VPC to which it's linked.
// Similarly, the DNS hostname of an instance in a VPC resolves to its private
// IP address when addressed from a linked EC2-Classic instance. For more information,
// see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using DescribeVpcClassicLinkDnsSupportRequest.
//    req := client.DescribeVpcClassicLinkDnsSupportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport
func (c *Client) DescribeVpcClassicLinkDnsSupportRequest(input *DescribeVpcClassicLinkDnsSupportInput) DescribeVpcClassicLinkDnsSupportRequest {
	op := &aws.Operation{
		Name:       opDescribeVpcClassicLinkDnsSupport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVpcClassicLinkDnsSupportInput{}
	}

	req := c.newRequest(op, input, &DescribeVpcClassicLinkDnsSupportOutput{})
	return DescribeVpcClassicLinkDnsSupportRequest{Request: req, Input: input, Copy: c.DescribeVpcClassicLinkDnsSupportRequest}
}

// DescribeVpcClassicLinkDnsSupportRequest is the request type for the
// DescribeVpcClassicLinkDnsSupport API operation.
type DescribeVpcClassicLinkDnsSupportRequest struct {
	*aws.Request
	Input *DescribeVpcClassicLinkDnsSupportInput
	Copy  func(*DescribeVpcClassicLinkDnsSupportInput) DescribeVpcClassicLinkDnsSupportRequest
}

// Send marshals and sends the DescribeVpcClassicLinkDnsSupport API request.
func (r DescribeVpcClassicLinkDnsSupportRequest) Send(ctx context.Context) (*DescribeVpcClassicLinkDnsSupportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpcClassicLinkDnsSupportResponse{
		DescribeVpcClassicLinkDnsSupportOutput: r.Request.Data.(*DescribeVpcClassicLinkDnsSupportOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeVpcClassicLinkDnsSupportRequestPaginator returns a paginator for DescribeVpcClassicLinkDnsSupport.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeVpcClassicLinkDnsSupportRequest(input)
//   p := ec2.NewDescribeVpcClassicLinkDnsSupportRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeVpcClassicLinkDnsSupportPaginator(req DescribeVpcClassicLinkDnsSupportRequest) DescribeVpcClassicLinkDnsSupportPaginator {
	return DescribeVpcClassicLinkDnsSupportPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeVpcClassicLinkDnsSupportInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeVpcClassicLinkDnsSupportPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeVpcClassicLinkDnsSupportPaginator struct {
	aws.Pager
}

func (p *DescribeVpcClassicLinkDnsSupportPaginator) CurrentPage() *DescribeVpcClassicLinkDnsSupportOutput {
	return p.Pager.CurrentPage().(*DescribeVpcClassicLinkDnsSupportOutput)
}

// DescribeVpcClassicLinkDnsSupportResponse is the response type for the
// DescribeVpcClassicLinkDnsSupport API operation.
type DescribeVpcClassicLinkDnsSupportResponse struct {
	*DescribeVpcClassicLinkDnsSupportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpcClassicLinkDnsSupport request.
func (r *DescribeVpcClassicLinkDnsSupportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
