// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributesInput
type DescribeTargetGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTargetGroupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetGroupAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTargetGroupAttributesInput"}

	if s.TargetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributesOutput
type DescribeTargetGroupAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target group attributes
	Attributes []TargetGroupAttribute `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTargetGroupAttributes = "DescribeTargetGroupAttributes"

// DescribeTargetGroupAttributesRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Describes the attributes for the specified target group.
//
// For more information, see Target Group Attributes (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes)
// in the Application Load Balancers Guide or Target Group Attributes (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes)
// in the Network Load Balancers Guide.
//
//    // Example sending a request using DescribeTargetGroupAttributesRequest.
//    req := client.DescribeTargetGroupAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes
func (c *Client) DescribeTargetGroupAttributesRequest(input *DescribeTargetGroupAttributesInput) DescribeTargetGroupAttributesRequest {
	op := &aws.Operation{
		Name:       opDescribeTargetGroupAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTargetGroupAttributesInput{}
	}

	req := c.newRequest(op, input, &DescribeTargetGroupAttributesOutput{})
	return DescribeTargetGroupAttributesRequest{Request: req, Input: input, Copy: c.DescribeTargetGroupAttributesRequest}
}

// DescribeTargetGroupAttributesRequest is the request type for the
// DescribeTargetGroupAttributes API operation.
type DescribeTargetGroupAttributesRequest struct {
	*aws.Request
	Input *DescribeTargetGroupAttributesInput
	Copy  func(*DescribeTargetGroupAttributesInput) DescribeTargetGroupAttributesRequest
}

// Send marshals and sends the DescribeTargetGroupAttributes API request.
func (r DescribeTargetGroupAttributesRequest) Send(ctx context.Context) (*DescribeTargetGroupAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTargetGroupAttributesResponse{
		DescribeTargetGroupAttributesOutput: r.Request.Data.(*DescribeTargetGroupAttributesOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTargetGroupAttributesResponse is the response type for the
// DescribeTargetGroupAttributes API operation.
type DescribeTargetGroupAttributesResponse struct {
	*DescribeTargetGroupAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTargetGroupAttributes request.
func (r *DescribeTargetGroupAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
