// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Change the size of some instance groups.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroupsInput
type ModifyInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the cluster to which the instance group belongs.
	ClusterId *string `type:"string"`

	// Instance groups to change.
	InstanceGroups []InstanceGroupModifyConfig `type:"list"`
}

// String returns the string representation
func (s ModifyInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyInstanceGroupsInput"}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroupsOutput
type ModifyInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyInstanceGroups = "ModifyInstanceGroups"

// ModifyInstanceGroupsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// ModifyInstanceGroups modifies the number of nodes and configuration settings
// of an instance group. The input parameters include the new target instance
// count for the group and the instance group ID. The call will either succeed
// or fail atomically.
//
//    // Example sending a request using ModifyInstanceGroupsRequest.
//    req := client.ModifyInstanceGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups
func (c *Client) ModifyInstanceGroupsRequest(input *ModifyInstanceGroupsInput) ModifyInstanceGroupsRequest {
	op := &aws.Operation{
		Name:       opModifyInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceGroupsInput{}
	}

	req := c.newRequest(op, input, &ModifyInstanceGroupsOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ModifyInstanceGroupsRequest{Request: req, Input: input, Copy: c.ModifyInstanceGroupsRequest}
}

// ModifyInstanceGroupsRequest is the request type for the
// ModifyInstanceGroups API operation.
type ModifyInstanceGroupsRequest struct {
	*aws.Request
	Input *ModifyInstanceGroupsInput
	Copy  func(*ModifyInstanceGroupsInput) ModifyInstanceGroupsRequest
}

// Send marshals and sends the ModifyInstanceGroups API request.
func (r ModifyInstanceGroupsRequest) Send(ctx context.Context) (*ModifyInstanceGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyInstanceGroupsResponse{
		ModifyInstanceGroupsOutput: r.Request.Data.(*ModifyInstanceGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyInstanceGroupsResponse is the response type for the
// ModifyInstanceGroups API operation.
type ModifyInstanceGroupsResponse struct {
	*ModifyInstanceGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyInstanceGroups request.
func (r *ModifyInstanceGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
