// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreamsInput
type ListDeliveryStreamsInput struct {
	_ struct{} `type:"structure"`

	// The delivery stream type. This can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis data stream
	//    as a source.
	//
	// This parameter is optional. If this parameter is omitted, delivery streams
	// of all types are returned.
	DeliveryStreamType DeliveryStreamType `type:"string" enum:"true"`

	// The list of delivery streams returned by this call to ListDeliveryStreams
	// will start with the delivery stream whose name comes alphabetically immediately
	// after the name you specify in ExclusiveStartDeliveryStreamName.
	ExclusiveStartDeliveryStreamName *string `min:"1" type:"string"`

	// The maximum number of delivery streams to list. The default value is 10.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListDeliveryStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeliveryStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDeliveryStreamsInput"}
	if s.ExclusiveStartDeliveryStreamName != nil && len(*s.ExclusiveStartDeliveryStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusiveStartDeliveryStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreamsOutput
type ListDeliveryStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the delivery streams.
	//
	// DeliveryStreamNames is a required field
	DeliveryStreamNames []string `type:"list" required:"true"`

	// Indicates whether there are more delivery streams available to list.
	//
	// HasMoreDeliveryStreams is a required field
	HasMoreDeliveryStreams *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ListDeliveryStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDeliveryStreams = "ListDeliveryStreams"

// ListDeliveryStreamsRequest returns a request value for making API operation for
// Amazon Kinesis Firehose.
//
// Lists your delivery streams in alphabetical order of their names.
//
// The number of delivery streams might be too large to return using a single
// call to ListDeliveryStreams. You can limit the number of delivery streams
// returned, using the Limit parameter. To determine whether there are more
// delivery streams to list, check the value of HasMoreDeliveryStreams in the
// output. If there are more delivery streams to list, you can request them
// by calling this operation again and setting the ExclusiveStartDeliveryStreamName
// parameter to the name of the last delivery stream returned in the last call.
//
//    // Example sending a request using ListDeliveryStreamsRequest.
//    req := client.ListDeliveryStreamsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreams
func (c *Client) ListDeliveryStreamsRequest(input *ListDeliveryStreamsInput) ListDeliveryStreamsRequest {
	op := &aws.Operation{
		Name:       opListDeliveryStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeliveryStreamsInput{}
	}

	req := c.newRequest(op, input, &ListDeliveryStreamsOutput{})
	return ListDeliveryStreamsRequest{Request: req, Input: input, Copy: c.ListDeliveryStreamsRequest}
}

// ListDeliveryStreamsRequest is the request type for the
// ListDeliveryStreams API operation.
type ListDeliveryStreamsRequest struct {
	*aws.Request
	Input *ListDeliveryStreamsInput
	Copy  func(*ListDeliveryStreamsInput) ListDeliveryStreamsRequest
}

// Send marshals and sends the ListDeliveryStreams API request.
func (r ListDeliveryStreamsRequest) Send(ctx context.Context) (*ListDeliveryStreamsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDeliveryStreamsResponse{
		ListDeliveryStreamsOutput: r.Request.Data.(*ListDeliveryStreamsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDeliveryStreamsResponse is the response type for the
// ListDeliveryStreams API operation.
type ListDeliveryStreamsResponse struct {
	*ListDeliveryStreamsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDeliveryStreams request.
func (r *ListDeliveryStreamsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
