// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionInput
type UpdateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to update.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Policy determining whether or not the game session accepts new players.
	PlayerSessionCreationPolicy PlayerSessionCreationPolicy `type:"string" enum:"true"`

	// Game session protection policy to apply to this game session only.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy ProtectionPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGameSessionInput"}

	if s.GameSessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionOutput
type UpdateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated game session metadata.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGameSession = "UpdateGameSession"

// UpdateGameSessionRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Updates game session properties. This includes the session name, maximum
// player count, protection policy, which controls whether or not an active
// game session can be terminated during a scale-down event, and the player
// session creation policy, which controls whether or not new players can join
// the session. To update a game session, specify the game session ID and the
// values you want to change. If successful, an updated GameSession object is
// returned.
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
//
//    // Example sending a request using UpdateGameSessionRequest.
//    req := client.UpdateGameSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *Client) UpdateGameSessionRequest(input *UpdateGameSessionInput) UpdateGameSessionRequest {
	op := &aws.Operation{
		Name:       opUpdateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionInput{}
	}

	req := c.newRequest(op, input, &UpdateGameSessionOutput{})
	return UpdateGameSessionRequest{Request: req, Input: input, Copy: c.UpdateGameSessionRequest}
}

// UpdateGameSessionRequest is the request type for the
// UpdateGameSession API operation.
type UpdateGameSessionRequest struct {
	*aws.Request
	Input *UpdateGameSessionInput
	Copy  func(*UpdateGameSessionInput) UpdateGameSessionRequest
}

// Send marshals and sends the UpdateGameSession API request.
func (r UpdateGameSessionRequest) Send(ctx context.Context) (*UpdateGameSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGameSessionResponse{
		UpdateGameSessionOutput: r.Request.Data.(*UpdateGameSessionOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGameSessionResponse is the response type for the
// UpdateGameSession API operation.
type UpdateGameSessionResponse struct {
	*UpdateGameSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGameSession request.
func (r *UpdateGameSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
