// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Provides options for retrieving a list of parts of an archive that have been
// uploaded in a specific multipart upload.
type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of parts to be returned. The default limit is 50. The
	// number of parts returned might be fewer than the specified limit, but the
	// number of returned parts never exceeds the limit.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the part at which
	// the listing of parts should begin. Get the marker value from the response
	// of a previous List Parts response. You need only include the marker if you
	// are continuing the pagination of results started in a previous List Parts
	// request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The upload ID of the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPartsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "uploadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the Amazon Glacier response to your request.
type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// An opaque string that represents where to continue pagination of the results.
	// You use the marker in a new List Parts request to obtain more jobs in the
	// list. If there are no more parts, this value is null.
	Marker *string `type:"string"`

	// The ID of the upload to which the parts are associated.
	MultipartUploadId *string `type:"string"`

	// The part size in bytes. This is the same value that you specified in the
	// Initiate Multipart Upload request.
	PartSizeInBytes *int64 `type:"long"`

	// A list of the part sizes of the multipart upload. Each object in the array
	// contains a RangeBytes and sha256-tree-hash name/value pair.
	Parts []PartListElement `type:"list"`

	// The Amazon Resource Name (ARN) of the vault to which the multipart upload
	// was initiated.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveDescription != nil {
		v := *s.ArchiveDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultipartUploadId != nil {
		v := *s.MultipartUploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MultipartUploadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PartSizeInBytes != nil {
		v := *s.PartSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if len(s.Parts) > 0 {
		v := s.Parts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Parts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VaultARN != nil {
		v := *s.VaultARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VaultARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListParts = "ListParts"

// ListPartsRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation lists the parts of an archive that have been uploaded in a
// specific multipart upload. You can make this request at any time during an
// in-progress multipart upload before you complete the upload (see CompleteMultipartUpload.
// List Parts returns an error for completed uploads. The list returned in the
// List Parts response is sorted by part range.
//
// The List Parts operation supports pagination. By default, this operation
// returns up to 50 uploaded parts in the response. You should always check
// the response for a marker at which to continue the list; if there are no
// more items the marker is null. To return a list of parts that begins at a
// specific part, set the marker request parameter to the value you obtained
// from a previous List Parts request. You can also limit the number of parts
// returned in the response by specifying the limit parameter in the request.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, see Working with
// Archives in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and List Parts (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using ListPartsRequest.
//    req := client.ListPartsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListPartsRequest(input *ListPartsInput) ListPartsRequest {
	op := &aws.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req := c.newRequest(op, input, &ListPartsOutput{})
	return ListPartsRequest{Request: req, Input: input, Copy: c.ListPartsRequest}
}

// ListPartsRequest is the request type for the
// ListParts API operation.
type ListPartsRequest struct {
	*aws.Request
	Input *ListPartsInput
	Copy  func(*ListPartsInput) ListPartsRequest
}

// Send marshals and sends the ListParts API request.
func (r ListPartsRequest) Send(ctx context.Context) (*ListPartsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPartsResponse{
		ListPartsOutput: r.Request.Data.(*ListPartsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPartsRequestPaginator returns a paginator for ListParts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPartsRequest(input)
//   p := glacier.NewListPartsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPartsPaginator(req ListPartsRequest) ListPartsPaginator {
	return ListPartsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPartsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPartsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPartsPaginator struct {
	aws.Pager
}

func (p *ListPartsPaginator) CurrentPage() *ListPartsOutput {
	return p.Pager.CurrentPage().(*ListPartsOutput)
}

// ListPartsResponse is the response type for the
// ListParts API operation.
type ListPartsResponse struct {
	*ListPartsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListParts request.
func (r *ListPartsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
