// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnectionRequest
type BatchDeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connections reside. If none is provided,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of names of the connections to delete.
	//
	// ConnectionNameList is a required field
	ConnectionNameList []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDeleteConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ConnectionNameList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionNameList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnectionResponse
type BatchDeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// A map of the names of connections that were not successfully deleted to error
	// details.
	Errors map[string]ErrorDetail `type:"map"`

	// A list of names of the connection definitions that were successfully deleted.
	Succeeded []string `type:"list"`
}

// String returns the string representation
func (s BatchDeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchDeleteConnection = "BatchDeleteConnection"

// BatchDeleteConnectionRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a list of connection definitions from the Data Catalog.
//
//    // Example sending a request using BatchDeleteConnectionRequest.
//    req := client.BatchDeleteConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection
func (c *Client) BatchDeleteConnectionRequest(input *BatchDeleteConnectionInput) BatchDeleteConnectionRequest {
	op := &aws.Operation{
		Name:       opBatchDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteConnectionInput{}
	}

	req := c.newRequest(op, input, &BatchDeleteConnectionOutput{})
	return BatchDeleteConnectionRequest{Request: req, Input: input, Copy: c.BatchDeleteConnectionRequest}
}

// BatchDeleteConnectionRequest is the request type for the
// BatchDeleteConnection API operation.
type BatchDeleteConnectionRequest struct {
	*aws.Request
	Input *BatchDeleteConnectionInput
	Copy  func(*BatchDeleteConnectionInput) BatchDeleteConnectionRequest
}

// Send marshals and sends the BatchDeleteConnection API request.
func (r BatchDeleteConnectionRequest) Send(ctx context.Context) (*BatchDeleteConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDeleteConnectionResponse{
		BatchDeleteConnectionOutput: r.Request.Data.(*BatchDeleteConnectionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDeleteConnectionResponse is the response type for the
// BatchDeleteConnection API operation.
type BatchDeleteConnectionResponse struct {
	*BatchDeleteConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDeleteConnection request.
func (r *BatchDeleteConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
