// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerScheduleRequest
type StopCrawlerScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler whose schedule state to set.
	//
	// CrawlerName is a required field
	CrawlerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopCrawlerScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCrawlerScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopCrawlerScheduleInput"}

	if s.CrawlerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrawlerName"))
	}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CrawlerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerScheduleResponse
type StopCrawlerScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopCrawlerScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopCrawlerSchedule = "StopCrawlerSchedule"

// StopCrawlerScheduleRequest returns a request value for making API operation for
// AWS Glue.
//
// Sets the schedule state of the specified crawler to NOT_SCHEDULED, but does
// not stop the crawler if it is already running.
//
//    // Example sending a request using StopCrawlerScheduleRequest.
//    req := client.StopCrawlerScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule
func (c *Client) StopCrawlerScheduleRequest(input *StopCrawlerScheduleInput) StopCrawlerScheduleRequest {
	op := &aws.Operation{
		Name:       opStopCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerScheduleInput{}
	}

	req := c.newRequest(op, input, &StopCrawlerScheduleOutput{})
	return StopCrawlerScheduleRequest{Request: req, Input: input, Copy: c.StopCrawlerScheduleRequest}
}

// StopCrawlerScheduleRequest is the request type for the
// StopCrawlerSchedule API operation.
type StopCrawlerScheduleRequest struct {
	*aws.Request
	Input *StopCrawlerScheduleInput
	Copy  func(*StopCrawlerScheduleInput) StopCrawlerScheduleRequest
}

// Send marshals and sends the StopCrawlerSchedule API request.
func (r StopCrawlerScheduleRequest) Send(ctx context.Context) (*StopCrawlerScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopCrawlerScheduleResponse{
		StopCrawlerScheduleOutput: r.Request.Data.(*StopCrawlerScheduleOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopCrawlerScheduleResponse is the response type for the
// StopCrawlerSchedule API operation.
type StopCrawlerScheduleResponse struct {
	*StopCrawlerScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopCrawlerSchedule request.
func (r *StopCrawlerScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
